
/*
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: menu_extractor.c 2583 2007-07-22 13:53:06Z mschwerin $
 *
 */
#include "config.h"

#include <assert.h>
#include <math.h>

#include "disc.h"
#include "environment.h"
#include "extractor.h"
#include "heap.h"
#include "i18n.h"
#include "logger.h"
#include "otk.h"
#include "oxine.h"
#include "utils.h"

#include "menu_base.h"
#include "menu_extractor.h"
#include "menu_main.h"

#ifdef HAVE_EXTRACTOR

extern oxine_t *oxine;

#define EXTRACTOR_BUTTONS_NUM 4
static otk_widget_t *extractor_menu_buttons[EXTRACTOR_BUTTONS_NUM];
static otk_widget_t *extractor_menu_window = NULL;
static otk_widget_t *extractor_menu_list = NULL;
static otk_widget_t *extractor_menu_title = NULL;


static void
extractor_menu_update_buttons (void)
{
    if (extractor_is_paused ()) {
        otk_button_set_text (extractor_menu_buttons[0], _("Continue"));
    }
    else {
        otk_button_set_text (extractor_menu_buttons[0], _("Pause"));
    }
}


static void
extractor_menu_update_list (void)
{
    assert (extractor_menu_list);
    otk_list_clear (extractor_menu_list);

    filelist_t *list = extractor_get_list ();
    if (!list) {
        return;
    }

    int i = 1;
    fileitem_t *item = filelist_first (list);
    while (item) {
        otk_widget_t *w = otk_listentry_new (extractor_menu_list, item->title,
                                             NULL, NULL, NULL, NULL,
                                             NULL, NULL);

        if (i == extractor_get_progress_all ()) {
            otk_widget_set_enabled (w, false);
        }

        item = filelist_next (list, item);
        i += 1;
    }
}


static void
extractor_pause_cb (void *p)
{
    extractor_pause ();
    extractor_menu_update_buttons ();
}


static void
extractor_stop_cb (void *p)
{
    extractor_stop ();
    show_menu_main (oxine);
}


static void
extractor_menu_event_handler (void *p, oxine_event_t * event)
{
    if (is_current_menu (show_menu_extractor)
        && (event->type == OXINE_EVENT_KEY)
        && (event->source.key == OXINE_KEY_BACK)) {
        show_menu_main (oxine);
        event->source.key = OXINE_KEY_NULL;
    }
}


#if 0
static int
get_extractor_progress_cur (void *p)
{
    double length = extractor_get_length_cur ();
    double progress = extractor_get_progress_cur ();

    return (length != 0) ? round (progress / (length / 100.0)) : 0;
}


static int
get_extractor_progress_all (void *p)
{
    double length = extractor_get_length_all ();
    double progress = extractor_get_progress_all ();

    return (length != 0) ? round (progress / (length / 100.0)) : 0;
}
#endif


void
show_menu_extractor (void *p)
{
    if (!extractor_is_running ()) {
        show_menu_main (oxine);
        return;
    }

    if (extractor_menu_window) {
        otk_set_current_window (oxine->otk, extractor_menu_window);
        goto out_show;
    }
    odk_add_event_handler (oxine->odk, extractor_menu_event_handler, oxine,
                           EVENT_HANDLER_PRIORITY_NORMAL);

    extractor_menu_window = create_new_window (true, true);

    int x = 20;
    int y = 100;
    int w = 180;
    int h = 35;

    extractor_menu_buttons[0] =
        otk_text_button_new (oxine->otk, x, y, w, h, _("Pause"),
                             extractor_pause_cb, oxine);
    y += 40;
    extractor_menu_buttons[1] =
        otk_text_button_new (oxine->otk, x, y, w, h, _("Cancel"),
                             extractor_stop_cb, oxine);
    y += 40;
    extractor_menu_buttons[2] =
        otk_text_button_new (oxine->otk, x, y, w, h, _("Eject"),
                             eject_cb, oxine);
    y += 50;
    extractor_menu_buttons[3] =
        otk_text_button_new (oxine->otk, x, y, w, h, _("Mainmenu"),
                             show_menu_main, oxine);

    x = 220;
    y = 117;
    w = odk_osd_get_width (oxine->odk) - 20 - x;

    extractor_menu_title =
        otk_label_new (oxine->otk, x, y, w,
                       OTK_ALIGN_LEFT | OTK_ALIGN_VCENTER,
                       _("Currently ripping:"));
    otk_widget_set_font (extractor_menu_title, "sans", 32);

    y = 140;
    h = odk_osd_get_height (oxine->odk) - 160;

    extractor_menu_list =
        otk_list_new (oxine->otk, x, y, w, h, 30, 30,
                      true, true, OTK_LIST_SELECTION_NONE, oxine);

#if 0
    y = odk_osd_get_height (oxine->odk) - 75;
    b = otk_label_new (oxine->otk, x, y, w,
                       OTK_ALIGN_LEFT | OTK_ALIGN_VCENTER,
                       _("Progress over all:"));

    y = odk_osd_get_height (oxine->odk) - 55;
    b = otk_slider_new (oxine->otk, x, y, w, 35, 0, 20, false,
                        OTK_SLIDER_HORIZONTAL, "%2.0f %%", 1,
                        false, false, 0, 1, 0, 100,
                        get_extractor_progress_all, oxine, NULL, NULL);
    otk_widget_set_updated (b, true);
    otk_widget_set_enabled (b, false);

    y += 62;
    b = otk_label_new (oxine->otk, x, y, 780 - x,
                       OTK_ALIGN_LEFT | OTK_ALIGN_VCENTER,
                       _("Progress current track:"));

    y += 20;
    b = otk_slider_new (oxine->otk, x, y, 780 - x, 35,
                        0, 20, false, OTK_SLIDER_HORIZONTAL,
                        "%2.0f %%", 1, false, false, 0, 1, 0, 100,
                        get_extractor_progress_cur, oxine, NULL, NULL);
    otk_widget_set_updated (b, true);
    otk_widget_set_enabled (b, false);
#endif

    otk_widget_set_focused (extractor_menu_buttons[0], true);

  out_show:
    extractor_menu_update_buttons ();
    extractor_menu_update_list ();

    set_backto_menu (show_menu_extractor, NULL);
    set_current_menu (show_menu_extractor, NULL);

    show_user_interface (NULL);
    show_menu_background ("menu_extractor.png");
}

#endif /* HAVE_EXTRACTOR */
