
/*
 * Copyright (C) 2007 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: menu_password.h 2044 2007-05-15 13:01:50Z mschwerin $
 *
 */

#ifndef HAVE_PASSWORD_MENU_H
#define HAVE_PASSWORD_MENU_H
#ifdef __cplusplus
extern "C" {
#endif

#include "types.h"

/// Checks an encrypted password against a user provided password.
/**
 * @param mrl                   The password protected MRL.
 * @param pwd                   The encrypted password.
 */
bool check_password_for_mrl (const char *mrl, const char *pwd);

void free_menu_password (void);

#ifdef __cplusplus
}
#endif
#endif /* HAVE_PASSWORD_MENU_H */
