
/*
 * Copyright (C) 2005 Miguel Freitas
 * Copyright (C) 2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: otk_scrollbar.h 2468 2007-07-09 09:57:39Z mschwerin $
 *
 */

#ifndef HAVE_OTK_SCROLLBAR_H
#define HAVE_OTK_SCROLLBAR_H


/**
 * Creates a new scrollbar widget.
 *
 * @param otk                   The OTK object.
 * @param x                     The x-coordinate of the top left-hand corner.
 * @param y                     The y-coordinate of the top left-hand corner.
 * @param w                     The width of the scrollbar.
 * @param h                     The height of the scrollbar.
 * @param cb_click              This is called whenever the user hits the
 *                              left mouse button while inside the scrollbar.
 * @param cb_up                 This is called whenever the user selects the
 *                              up button.
 * @param cb_down               This is called whenever the user selects the
 *                              down button.
 * @param cb_pgup               This is called whenever the user selects the
 *                              page up button.
 * @param cb_pgdown             This is called whenever the user selects the
 *                              page down button.
 * @param cb_data               Callback data for all three callbacks.
 */
otk_widget_t *otk_scrollbar_new (otk_t * otk, int x, int y, int w, int h,
                                 otk_int_set_cb_t cb_click,
                                 otk_cb_t cb_up, otk_cb_t cb_down,
                                 otk_cb_t cb_pgup, otk_cb_t cb_pgdown,
                                 void *cb_data);


/**
 * Sets the length and position of the scrollbar. The user must make sure
 * that position and length add up to 100% when the scrollbar reaches the
 * lowest position.
 *
 * @param scrollbar             The scrollbar object.
 * @param position              The start of the visible area in percent.
 * @param length                The length of the visible area in percent.
 */
void otk_scrollbar_set (otk_widget_t * scrollbar, double position,
                        double length);


#endif /* HAVE_OTK_SCROLLBAR_H */
