/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.pmd;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTStatementExpression;
import net.sourceforge.pmd.lang.java.ast.ASTType;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.symboltable.NameOccurrence;
import net.sourceforge.pmd.lang.rule.properties.StringProperty;
import net.sourceforge.pmd.util.CollectionUtil;

public class ConfigurableUselessOperationOnImmutable
extends AbstractJavaRule {
    private static final PropertyDescriptor<String> IMMUTABLE_METHODS = new StringProperty("immutableOperations", "Which operations on immutable objects should be checked (format: \"<fully-qualified-class-name>:<method-name>1,<method-name>2,...;...\")", "java.util.BigDecimal:abs,add,divide,divideToIntegralValue,max,min,movePointLeft,movePointRight,multiply,negate,plus,pow,remainder,round,scaleByPowerOfTen,setScale,stripTrailingZeros,subtract,ulp;java.util.BigInteger:abs,add,and,andNot,clearBit,divide,flipBit,gcd,max,min,mod,modInverse,modPow,multiply,negate,nextProbablePrine,not,or,pow,remainder,setBit,shiftLeft,shiftRight,subtract,xor;java.lang.String:concat,intern,replace,replaceAll,replaceFirst,substring,toLowerCase,toString,toUpperCase,trim", 1.0f);
    private Map<String, Set<String>> mImmutableOps;

    public ConfigurableUselessOperationOnImmutable() {
        this.definePropertyDescriptor(IMMUTABLE_METHODS);
    }

    private void loadConfiguration() {
        String[] parts;
        if (this.mImmutableOps != null) {
            return;
        }
        this.mImmutableOps = new HashMap<String, Set<String>>();
        String prop = (String)this.getProperty(IMMUTABLE_METHODS);
        String[] stringArray = parts = prop.split(";");
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            String[] comps = p.split(":");
            if (comps.length != 2) {
                throw new IllegalArgumentException("Illegal Format");
            }
            String[] clsparts = comps[0].split("\\.");
            Object[] methods = comps[1].split(",");
            Set methodsset = CollectionUtil.asSet((Object[])methods);
            this.mImmutableOps.put(comps[0], methodsset);
            int pos = clsparts.length - 1;
            if (pos >= 0) {
                this.mImmutableOps.put(clsparts[pos], methodsset);
            }
            ++n2;
        }
    }

    public Object visit(ASTLocalVariableDeclaration node, Object data) {
        this.loadConfiguration();
        ASTVariableDeclaratorId var = this.getDeclaration(node.getTypeNode(), (AbstractJavaNode)node);
        if (var == null) {
            return super.visit(node, data);
        }
        for (NameOccurrence no : var.getUsages()) {
            this.checkUsage(no, node.getTypeNode(), (AbstractJavaNode)node, data);
        }
        return super.visit(node, data);
    }

    public Object visit(ASTFieldDeclaration node, Object data) {
        this.loadConfiguration();
        ASTType type = ((ASTVariableDeclaratorId)node.getFirstDescendantOfType(ASTVariableDeclaratorId.class)).getTypeNode();
        ASTVariableDeclaratorId var = this.getDeclaration(type, (AbstractJavaNode)node);
        if (var == null) {
            return super.visit(node, data);
        }
        for (NameOccurrence no : var.getUsages()) {
            this.checkUsage(no, type, (AbstractJavaNode)node, data);
        }
        return super.visit(node, data);
    }

    private void checkUsage(NameOccurrence no, ASTType type, AbstractJavaNode node, Object data) {
        String methodCall;
        int idx;
        JavaNode sn = no.getLocation();
        Node primaryExpression = sn.jjtGetParent().jjtGetParent();
        Class<?> parentClass = primaryExpression.jjtGetParent().getClass();
        if (parentClass.equals(ASTStatementExpression.class) && (idx = (methodCall = sn.getImage()).lastIndexOf(46)) >= 0) {
            methodCall = methodCall.substring(idx + 1);
            if (type != null && this.mImmutableOps.get(type.getTypeImage()).contains(methodCall)) {
                this.addViolation(data, (Node)sn);
            }
        }
    }

    private ASTVariableDeclaratorId getDeclaration(ASTType type, AbstractJavaNode node) {
        if (this.mImmutableOps.containsKey(type.getTypeImage())) {
            return (ASTVariableDeclaratorId)node.getFirstDescendantOfType(ASTVariableDeclaratorId.class);
        }
        return null;
    }
}

