/*
 * Decompiled with CFR 0.152.
 */
package com.github.jhoenicke.javacup;

import com.github.jhoenicke.javacup.ErrorManager;
import com.github.jhoenicke.javacup.Grammar;
import com.github.jhoenicke.javacup.Lexer;
import com.github.jhoenicke.javacup.emit;
import com.github.jhoenicke.javacup.non_terminal;
import com.github.jhoenicke.javacup.parser;
import com.github.jhoenicke.javacup.runtime.ComplexSymbolFactory;
import com.github.jhoenicke.javacup.terminal;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;

public class Main {
    private boolean print_progress = false;
    private boolean opt_dump_states = false;
    private boolean opt_dump_tables = false;
    private boolean opt_dump_grammar = false;
    private boolean opt_show_timing = false;
    private boolean opt_do_debug = false;
    private boolean opt_compact_red = false;
    private boolean opt_java15 = false;
    private boolean include_non_terms = false;
    private boolean no_summary = false;
    private int expect_conflicts = 0;
    private boolean opt_lr_values = true;
    private boolean opt_old_lr_values = true;
    private boolean sym_interface = false;
    private boolean suppress_scanner = false;
    private long start_time = 0L;
    private long prelim_end = 0L;
    private long parse_end = 0L;
    private long check_end = 0L;
    private long dump_end = 0L;
    private long build_end = 0L;
    private long nullability_end = 0L;
    private long first_end = 0L;
    private long machine_end = 0L;
    private long table_end = 0L;
    private long reduce_check_end = 0L;
    private long emit_end = 0L;
    private long final_time = 0L;
    emit emit = new emit();
    private InputStream input_file = System.in;
    private PrintWriter parser_class_file;
    private PrintWriter symbol_class_file;
    private File dest_dir = null;

    public Main() {
        this.start_time = System.currentTimeMillis();
    }

    public boolean run() throws Exception {
        boolean bl = false;
        this.prelim_end = System.currentTimeMillis();
        if (this.print_progress) {
            System.err.println("Parsing specification...");
        }
        Grammar grammar = this.parse_grammar_spec();
        grammar.add_wildcard_rules();
        this.parse_end = System.currentTimeMillis();
        if (ErrorManager.getManager().getErrorCount() == 0) {
            if (this.print_progress) {
                System.err.println("Checking specification...");
            }
            this.check_unused(grammar);
            this.check_end = System.currentTimeMillis();
            if (this.print_progress) {
                System.err.println("Building parse tables...");
            }
            this.build_parser(grammar);
            this.build_end = System.currentTimeMillis();
            if (ErrorManager.getManager().getErrorCount() != 0) {
                this.opt_dump_tables = false;
            } else {
                if (this.print_progress) {
                    System.err.println("Writing parser...");
                }
                this.open_files();
                this.emit_parser(grammar);
                bl = true;
                if (this.print_progress) {
                    System.err.println("Closing files...");
                }
                this.close_files();
            }
        }
        this.emit_end = System.currentTimeMillis();
        if (this.opt_dump_grammar) {
            grammar.dump_grammar();
        }
        if (this.opt_dump_states) {
            grammar.dump_machine();
        }
        if (this.opt_dump_tables) {
            grammar.dump_tables();
        }
        this.dump_end = System.currentTimeMillis();
        if (!this.no_summary) {
            this.emit_summary(grammar, bl);
        }
        return ErrorManager.getManager().getErrorCount() == 0;
    }

    private void usage() {
        System.err.println();
        System.err.println("Usage: java -jar jh-javacup1.2.jar [options] [filename]\n  and expects a specification file on standard input if no filename is given.\n  Legal options include:\n    -package name  specify package generated classes go in [default none]\n    -destdir name  specify the destination directory, to store the generated files in\n    -parser name   specify parser class name [default \"parser\"]\n    -typearg args  specify type arguments for parser class\n    -symbols name  specify name for symbol constant class [default \"sym\"]\n    -interface     put symbols in an interface, rather than a class\n    -nonterms      put non terminals in symbol constant class\n    -expect #      number of conflicts expected/allowed [default 0]\n    -compact_red   compact tables by defaulting to most frequent reduce\n    -newpositions  don't generate old style access for left and right token\n    -nowarn        don't warn about useless productions, etc.\n    -nosummary     don't print the usual summary of parse states, etc.\n    -nopositions   don't propagate the left and right token position values\n    -noscanner     don't refer to com.github.jhoenicke.javacup.runtime.Scanner\n    -progress      print messages to indicate progress of the system\n    -time          print time usage summary\n    -dump_grammar  produce a human readable dump of the symbols and grammar\n    -dump_states   produce a dump of parse state machine\n    -dump_tables   produce a dump of the parse tables\n    -dump          produce a dump of all of the above\n    -version       print the version information for CUP and exit\n");
        System.exit(1);
    }

    public boolean setOption(String string) {
        return this.setOption(string, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setOption(String string, String string2) {
        if (string.equals("package")) {
            if (string2 != null) {
                this.emit.package_name = string2;
                return true;
            }
            System.err.println("package must have a name argument");
            return false;
        }
        if (string.equals("destdir")) {
            if (string2 != null) {
                this.dest_dir = new File(string2);
                return true;
            }
            System.err.println("destdir must have a name argument");
            return false;
        }
        if (string.equals("parser")) {
            if (string2 != null) {
                this.emit.parser_class_name = string2;
                return true;
            }
            System.err.println("parser must have a name argument");
            return false;
        }
        if (string.equals("typearg")) {
            if (string2 == null) {
                System.err.println("symbols must have a name argument");
                return false;
            }
            this.opt_java15 = true;
            this.emit.class_type_argument = string;
            return true;
        }
        if (string.equals("symbols")) {
            if (string2 != null) {
                this.emit.symbol_const_class_name = string2;
                return true;
            }
            System.err.println("symbols must have a name argument");
            return false;
        }
        if (string.equals("nonterms")) {
            this.include_non_terms = true;
            return true;
        }
        if (string.equals("expect")) {
            if (string2 == null) {
                System.err.println("expect must have a number argument");
                return false;
            }
            try {
                this.expect_conflicts = Integer.parseInt(string2);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("expect must be followed by a decimal integer");
                return false;
            }
        }
        if (string.equals("java15")) {
            this.opt_java15 = true;
            return true;
        }
        if (string.equals("compact_red")) {
            this.opt_compact_red = true;
            return true;
        }
        if (string.equals("nosummary")) {
            this.no_summary = true;
            return true;
        }
        if (string.equals("nowarn")) {
            this.emit.nowarn = true;
            return true;
        }
        if (string.equals("dump_states")) {
            this.opt_dump_states = true;
            return true;
        }
        if (string.equals("dump_tables")) {
            this.opt_dump_tables = true;
            return true;
        }
        if (string.equals("progress")) {
            this.print_progress = true;
            return true;
        }
        if (string.equals("dump_grammar")) {
            this.opt_dump_grammar = true;
            return true;
        }
        if (string.equals("dump")) {
            this.opt_dump_grammar = true;
            this.opt_dump_tables = true;
            this.opt_dump_states = true;
            return true;
        }
        if (string.equals("time")) {
            this.opt_show_timing = true;
            return true;
        }
        if (string.equals("debug")) {
            this.opt_do_debug = true;
            return true;
        }
        if (string.equals("nopositions")) {
            this.opt_lr_values = false;
            this.opt_old_lr_values = false;
            return true;
        }
        if (string.equals("newpositions")) {
            this.opt_old_lr_values = false;
            return true;
        }
        if (string.equals("interface")) {
            this.sym_interface = true;
            return true;
        }
        if (string.equals("noscanner")) {
            this.suppress_scanner = true;
            return true;
        }
        System.err.println("Unrecognized option \"" + string + "\"");
        return false;
    }

    private void parse_args(String[] stringArray) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            if (string.equals("-package") || string.equals("-destdir") || string.equals("-parser") || string.equals("-typearg") || string.equals("-symbols") || string.equals("-expect")) {
                if (++i >= n || stringArray[i].startsWith("-") || stringArray[i].endsWith(".cup")) {
                    System.err.println(string + " must have an argument");
                    continue;
                }
                if (this.setOption(string.substring(1), stringArray[i])) continue;
                this.usage();
                continue;
            }
            if (stringArray[i].equals("-version")) {
                System.out.println("jh-javacup-1.2 20210807");
                System.exit(1);
                continue;
            }
            if (string.startsWith("-")) {
                if (this.setOption(string.substring(1))) continue;
                this.usage();
                continue;
            }
            if (!stringArray[i].startsWith("-") && i == n - 1) {
                try {
                    this.input_file = new FileInputStream(stringArray[i]);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.err.println("Unable to open \"" + stringArray[i] + "\" for input");
                    this.usage();
                }
                continue;
            }
            System.err.println("Unrecognized option \"" + stringArray[i] + "\"");
            this.usage();
        }
    }

    private void open_files() {
        String string = this.emit.parser_class_name + ".java";
        File file = new File(this.dest_dir, string);
        try {
            this.parser_class_file = new PrintWriter(new BufferedOutputStream(new FileOutputStream(file), 4096));
        }
        catch (Exception exception) {
            System.err.println("Can't open \"" + string + "\" for output");
            System.exit(3);
        }
        string = this.emit.symbol_const_class_name + ".java";
        file = new File(this.dest_dir, string);
        try {
            this.symbol_class_file = new PrintWriter(new BufferedOutputStream(new FileOutputStream(file), 4096));
        }
        catch (Exception exception) {
            System.err.println("Can't open \"" + string + "\" for output");
            System.exit(4);
        }
    }

    private void close_files() throws IOException {
        if (this.parser_class_file != null) {
            this.parser_class_file.close();
        }
        if (this.symbol_class_file != null) {
            this.symbol_class_file.close();
        }
    }

    private Grammar parse_grammar_spec() {
        ComplexSymbolFactory complexSymbolFactory = new ComplexSymbolFactory();
        parser parser2 = new parser(new Lexer(this.input_file, complexSymbolFactory), complexSymbolFactory);
        parser2.main = this;
        parser2.emit = this.emit;
        try {
            Grammar grammar = this.opt_do_debug ? (Grammar)parser2.debug_parse().value : (Grammar)parser2.parse().value;
            if (this.input_file != System.in) {
                this.input_file.close();
            }
            return grammar;
        }
        catch (Exception exception) {
            AssertionError assertionError = new AssertionError((Object)"Exception in parser");
            ((Throwable)((Object)assertionError)).initCause(exception);
            throw assertionError;
        }
    }

    private void check_unused(Grammar grammar) {
        for (terminal symbol2 : grammar.terminals()) {
            if (symbol2 == terminal.EOF || symbol2 == terminal.error || symbol2.use_count() != 0) continue;
            ++this.emit.unused_term;
            if (this.emit.nowarn) continue;
            ErrorManager.getManager().emit_warning("Terminal \"" + symbol2.name() + "\" was declared but never used");
        }
        for (non_terminal non_terminal2 : grammar.non_terminals()) {
            if (non_terminal2.use_count() != 0 && non_terminal2.productions().size() != 0) continue;
            ++this.emit.unused_non_term;
            if (this.emit.nowarn) continue;
            String string = non_terminal2.use_count() == 0 ? "\" was declared but never used" : "\" has no production";
            ErrorManager.getManager().emit_warning("Non terminal \"" + non_terminal2.name() + string);
        }
    }

    private void build_parser(Grammar grammar) {
        if (this.opt_do_debug || this.print_progress) {
            System.err.println("  Computing non-terminal nullability...");
        }
        grammar.compute_nullability();
        this.nullability_end = System.currentTimeMillis();
        if (this.opt_do_debug || this.print_progress) {
            System.err.println("  Computing first sets...");
        }
        grammar.compute_first_sets();
        this.first_end = System.currentTimeMillis();
        if (this.opt_do_debug || this.print_progress) {
            System.err.println("  Building state machine...");
        }
        grammar.build_machine();
        this.machine_end = System.currentTimeMillis();
        if (this.opt_do_debug || this.print_progress) {
            System.err.println("  Filling in tables...");
        }
        grammar.build_tables(this.opt_compact_red);
        this.table_end = System.currentTimeMillis();
        if (this.opt_do_debug || this.print_progress) {
            System.err.println("  Checking for non-reduced productions...");
        }
        if (!this.emit.nowarn) {
            grammar.check_tables();
        }
        this.reduce_check_end = System.currentTimeMillis();
        if (grammar.num_conflicts() > this.expect_conflicts) {
            ErrorManager.getManager().emit_error("*** More conflicts encountered than expected -- parser generation aborted");
        }
    }

    private void emit_parser(Grammar grammar) {
        this.emit.symbols(this.symbol_class_file, grammar, this.include_non_terms, this.sym_interface);
        this.emit.parser(this.parser_class_file, grammar, this.suppress_scanner, this.opt_lr_values, this.opt_old_lr_values, this.opt_java15);
    }

    private String plural(int n) {
        if (n == 1) {
            return "";
        }
        return "s";
    }

    private void emit_summary(Grammar grammar, boolean bl) {
        this.final_time = System.currentTimeMillis();
        System.err.println("------- jh-javacup-1.2 20210807 Parser Generation Summary -------");
        System.err.println("  " + ErrorManager.getManager().getErrorCount() + " error" + this.plural(ErrorManager.getManager().getErrorCount()) + " and " + ErrorManager.getManager().getWarningCount() + " warning" + this.plural(ErrorManager.getManager().getWarningCount()));
        System.err.print("  " + grammar.num_terminals() + " terminal" + this.plural(grammar.num_terminals()) + ", ");
        System.err.print(grammar.num_non_terminals() + " non-terminal" + this.plural(grammar.num_non_terminals()) + ", and ");
        System.err.println(grammar.num_productions() + " production" + this.plural(grammar.num_productions()) + " declared, ");
        System.err.print("  producing " + grammar.lalr_states().size() + " unique parse states,");
        System.err.println(" " + grammar.num_actions() + " unique action" + this.plural(grammar.num_actions()) + ". ");
        System.err.println("  " + this.emit.unused_term + " terminal" + this.plural(this.emit.unused_term) + " declared but not used.");
        System.err.println("  " + this.emit.unused_non_term + " non-terminal" + this.plural(this.emit.unused_non_term) + " declared but not used.");
        System.err.println("  " + this.emit.not_reduced + " production" + this.plural(this.emit.not_reduced) + " never reduced.");
        System.err.println("  " + grammar.num_conflicts() + " conflict" + this.plural(grammar.num_conflicts()) + " detected (" + this.expect_conflicts + " expected).");
        if (bl) {
            System.err.println("  Code written to \"" + this.emit.parser_class_name + ".java\", and \"" + this.emit.symbol_const_class_name + ".java\".");
        } else {
            System.err.println("  No code produced.");
        }
        if (this.opt_show_timing) {
            this.show_times();
        }
        System.err.println("---------------------------------------------------- (1.2 20210807)");
    }

    private void show_times() {
        long l = this.final_time - this.start_time;
        System.err.println(". . . . . . . . . . . . . . . . . . . . . . . . . ");
        System.err.println("  Timing Summary");
        System.err.println("    Total time       " + this.timestr(this.final_time - this.start_time, l));
        System.err.println("      Startup        " + this.timestr(this.prelim_end - this.start_time, l));
        System.err.println("      Parse          " + this.timestr(this.parse_end - this.prelim_end, l));
        if (this.check_end != 0L) {
            System.err.println("      Checking       " + this.timestr(this.check_end - this.parse_end, l));
        }
        if (this.check_end != 0L && this.build_end != 0L) {
            System.err.println("      Parser Build   " + this.timestr(this.build_end - this.check_end, l));
        }
        if (this.nullability_end != 0L && this.check_end != 0L) {
            System.err.println("        Nullability  " + this.timestr(this.nullability_end - this.check_end, l));
        }
        if (this.first_end != 0L && this.nullability_end != 0L) {
            System.err.println("        First sets   " + this.timestr(this.first_end - this.nullability_end, l));
        }
        if (this.machine_end != 0L && this.first_end != 0L) {
            System.err.println("        State build  " + this.timestr(this.machine_end - this.first_end, l));
        }
        if (this.table_end != 0L && this.machine_end != 0L) {
            System.err.println("        Table build  " + this.timestr(this.table_end - this.machine_end, l));
        }
        if (this.reduce_check_end != 0L && this.table_end != 0L) {
            System.err.println("        Checking     " + this.timestr(this.reduce_check_end - this.table_end, l));
        }
        if (this.emit_end != 0L && this.build_end != 0L) {
            System.err.println("      Code Output    " + this.timestr(this.emit_end - this.build_end, l));
        }
        if (this.emit.symbols_time != 0L) {
            System.err.println("        Symbols      " + this.timestr(this.emit.symbols_time, l));
        }
        if (this.emit.parser_time != 0L) {
            System.err.println("        Parser class " + this.timestr(this.emit.parser_time, l));
        }
        if (this.emit.action_code_time != 0L) {
            System.err.println("          Actions    " + this.timestr(this.emit.action_code_time, l));
        }
        if (this.emit.production_table_time != 0L) {
            System.err.println("          Prod table " + this.timestr(this.emit.production_table_time, l));
        }
        if (this.emit.action_table_time != 0L) {
            System.err.println("          Action tab " + this.timestr(this.emit.action_table_time, l));
        }
        if (this.emit.goto_table_time != 0L) {
            System.err.println("          Reduce tab " + this.timestr(this.emit.goto_table_time, l));
        }
        System.err.println("      Dump Output    " + this.timestr(this.dump_end - this.emit_end, l));
    }

    private String timestr(long l, long l2) {
        String string = "   " + l / 1000L;
        String string2 = "00" + l % 1000L;
        long l3 = l * 1000L / l2;
        return string.substring(string.length() - 4) + "." + string2.substring(string2.length() - 3) + "sec (" + l3 / 10L + "." + l3 % 10L + "%)";
    }

    public static void main(String[] stringArray) throws Exception {
        Main main = new Main();
        main.parse_args(stringArray);
        boolean bl = main.run();
        if (!bl) {
            System.exit(1);
        }
    }
}

