/*
 * Decompiled with CFR 0.152.
 */
package com.github.jhoenicke.javacup;

import com.github.jhoenicke.javacup.CombRow;
import com.github.jhoenicke.javacup.Grammar;
import java.util.BitSet;
import java.util.TreeSet;

public class parse_action_table {
    public final int[][] table;
    public static final int ERROR = 0;
    public static final int SHIFT = 1;
    public static final int REDUCE = 2;

    public parse_action_table(Grammar grammar) {
        int n = grammar.lalr_states().size();
        int n2 = grammar.num_terminals();
        this.table = new int[n][n2 + 1];
    }

    public static int action(int n, int n2) {
        return 2 * n2 + n;
    }

    public static boolean isReduce(int n) {
        return n != 0 && (n & 1) == 0;
    }

    public static boolean isShift(int n) {
        return (n & 1) != 0;
    }

    public static int index(int n) {
        return n - 1 >> 1;
    }

    public static String toString(int n) {
        if (n == 0) {
            return "ERROR";
        }
        if (parse_action_table.isShift(n)) {
            return "SHIFT(" + parse_action_table.index(n) + ")";
        }
        return "REDUCE(" + parse_action_table.index(n) + ")";
    }

    public short[] compress(int[] nArray) {
        int n;
        int[] nArray2 = new int[this.table.length];
        TreeSet<CombRow> treeSet = new TreeSet<CombRow>();
        for (int i = 0; i < this.table.length; ++i) {
            int[] nArray3 = this.table[i];
            nArray2[i] = nArray3[nArray3.length - 1];
            int n2 = 0;
            for (int j = 0; j < nArray3.length - 1; ++j) {
                if (nArray3[j] == nArray2[i]) continue;
                ++n2;
            }
            if (n2 == 0) continue;
            int[] nArray4 = new int[n2];
            n2 = 0;
            for (n = 0; n < nArray3.length - 1; ++n) {
                if (nArray3[n] == nArray2[i]) continue;
                nArray4[n2++] = n;
            }
            treeSet.add(new CombRow(i, nArray4));
        }
        BitSet bitSet = new BitSet();
        int n3 = 0;
        for (CombRow combRow : treeSet) {
            combRow.fitInComb(bitSet);
            n = combRow.base + this.table[combRow.index].length;
            if (n <= n3) continue;
            n3 = n;
        }
        int n4 = this.table.length;
        short[] sArray = new short[n4 + 2 * n3];
        for (n = 0; n < n4; ++n) {
            nArray[n] = (short)n4;
            sArray[n] = (short)nArray2[n];
        }
        for (n = 0; n < n3; ++n) {
            sArray[n4 + 2 * n] = (short)n4;
            sArray[n4 + 2 * n + 1] = 1;
        }
        for (CombRow combRow : treeSet) {
            int n5;
            nArray[combRow.index] = n5 = this.table.length + 2 * combRow.base;
            for (int i = 0; i < combRow.comb.length; ++i) {
                int n6 = combRow.comb[i];
                sArray[n5 + 2 * n6] = (short)combRow.index;
                sArray[n5 + 2 * n6 + 1] = (short)this.table[combRow.index][n6];
            }
        }
        return sArray;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("-------- ACTION_TABLE --------\n");
        for (int i = 0; i < this.table.length; ++i) {
            stringBuilder.append("From state #").append(i).append("\n");
            int n = 0;
            int n2 = this.table[i][this.table[i].length - 1];
            stringBuilder.append(" [default:").append(parse_action_table.toString(n2)).append("]\n");
            for (int j = 0; j < this.table[i].length; ++j) {
                if (this.table[i][j] == n2) continue;
                stringBuilder.append(" [term ").append(j).append(":").append(parse_action_table.toString(this.table[i][j])).append("]");
                if (++n != 2) continue;
                stringBuilder.append("\n");
                n = 0;
            }
            if (n == 0) continue;
            stringBuilder.append("\n");
        }
        stringBuilder.append("------------------------------");
        return stringBuilder.toString();
    }
}

