/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.resolver.internal.ant.org.eclipse.aether.internal.impl;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

class SimpleDigest {
    private static final String[] HASH_ALGOS = new String[]{"SHA-1", "MD5"};
    private MessageDigest digest;
    private long hash;

    SimpleDigest() {
        for (String hashAlgo : HASH_ALGOS) {
            try {
                this.digest = MessageDigest.getInstance(hashAlgo);
                this.hash = 0L;
                break;
            }
            catch (NoSuchAlgorithmException ne) {
                this.digest = null;
                this.hash = 13L;
            }
        }
    }

    public void update(String data) {
        if (data == null || data.length() <= 0) {
            return;
        }
        if (this.digest != null) {
            this.digest.update(data.getBytes(StandardCharsets.UTF_8));
        } else {
            this.hash = this.hash * 31L + (long)data.hashCode();
        }
    }

    public String digest() {
        if (this.digest != null) {
            byte[] bytes;
            StringBuilder buffer = new StringBuilder(64);
            for (byte aByte : bytes = this.digest.digest()) {
                int b = aByte & 0xFF;
                if (b < 16) {
                    buffer.append('0');
                }
                buffer.append(Integer.toHexString(b));
            }
            return buffer.toString();
        }
        return Long.toHexString(this.hash);
    }
}

