/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.resolver.internal.ant.org.eclipse.aether.transport.http;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.resolver.internal.ant.org.apache.http.client.utils.URIUtils;

final class UriUtils {
    UriUtils() {
    }

    public static URI resolve(URI base, URI ref) {
        String path = ref.getRawPath();
        if (!(path == null || path.length() <= 0 || (path = base.getRawPath()) != null && path.endsWith("/"))) {
            try {
                base = new URI(base.getScheme(), base.getAuthority(), base.getPath() + '/', null, null);
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException(e);
            }
        }
        return URIUtils.resolve(base, ref);
    }

    public static List<URI> getDirectories(URI base, URI uri) {
        ArrayList<URI> dirs = new ArrayList<URI>();
        URI dir = uri.resolve(".");
        while (!UriUtils.isBase(base, dir)) {
            dirs.add(dir);
            dir = dir.resolve("..");
        }
        return dirs;
    }

    private static boolean isBase(URI base, URI uri) {
        URI rel;
        String path = uri.getRawPath();
        if (path == null || "/".equals(path)) {
            return true;
        }
        return base != null && ((rel = base.relativize(uri)).getRawPath() == null || rel.getRawPath().length() <= 0 || rel.equals(uri));
    }
}

