/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.resolver.internal.ant.types;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.resolver.internal.ant.types.Artifact;
import org.apache.maven.resolver.internal.ant.types.ArtifactContainer;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Reference;

public class Artifacts
extends DataType
implements ArtifactContainer {
    private List<ArtifactContainer> containers = new ArrayList<ArtifactContainer>();

    protected Artifacts getRef() {
        return (Artifacts)this.getCheckedRef();
    }

    @Override
    public void validate(Task task) {
        if (this.isReference()) {
            this.getRef().validate(task);
        } else {
            for (ArtifactContainer container : this.containers) {
                container.validate(task);
            }
        }
    }

    public void setRefid(Reference ref) {
        if (!this.containers.isEmpty()) {
            throw this.noChildrenAllowed();
        }
        super.setRefid(ref);
    }

    public void addArtifact(Artifact artifact) {
        this.checkChildrenAllowed();
        this.containers.add(artifact);
    }

    public void addArtifacts(Artifacts artifacts) {
        this.checkChildrenAllowed();
        if (artifacts == this) {
            throw this.circularReference();
        }
        this.containers.add(artifacts);
    }

    @Override
    public List<Artifact> getArtifacts() {
        if (this.isReference()) {
            return this.getRef().getArtifacts();
        }
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        for (ArtifactContainer container : this.containers) {
            artifacts.addAll(container.getArtifacts());
        }
        return artifacts;
    }
}

