% Ultralytics 🚀 AGPL-3.0 License - https://ultralytics.com/license

function [cc, az1, el1, naz, nel, elazCells, elvec, azvec] = fcnuniformsphere(nel,naz,plotflag)
%cc = x y z unit vectors that make up a uniform sphere
if nargin==2
    plotflag = false;
elseif nargin==0
    nel = 11;
    naz = 23;
    plotflag = false;
end

if mod(naz,2)==0
    naz = naz+1;
end

if mod(nel,2)==0
    nel = nel+1;
end

elvec = linspace(-pi/2,pi/2,nel);
azvec = linspace(-pi,pi,naz);
azvec(ceil(naz/2)) = 0;
elvec(ceil(nel/2)) = 0;

[azu, elu] = meshgrid(azvec,elvec);
np = size(azu,2)*size(elu,1);

az0 = reshape(azu,np,1);
el0 = reshape(elu,np,1);
leftlim = -pi*cos(el0);
rightlim = pi*cos(el0);

v1 = find(az0>=leftlim & az0<=rightlim);
el1 = el0(v1);
az1 = az0(v1);
az1 = az1./cos(el1);
cc = fcnSC2CC(1,el1,az1);

%az per el row
elazCells = cell(1,nel);
for i = 1:nel
    el = elvec(i);
    saz = azvec./cos(el);
    v1 = saz>=-pi & saz<pi;
    elazCells{i} = azvec(v1)/cos(elvec(i));
end

if plotflag
    fig(2,2,3,1.5);
    
    
    subplot(221);
    plot(az0,el0,'m.'); hold on
    y1 = (-pi/2):pi/20:(pi/2);
    x1 = -pi*cos(y1);
    plot(x1,y1,'g','LineWidth',3)
    y2 = (-pi/2):pi/20:(pi/2);
    x2 = pi*cos(y2);
    plot(x2,y2,'r','LineWidth',3)
    axis equal tight;
    v1 = find(az0>=leftlim & az0<=rightlim);
    el1 = [el0(v1); -pi/2; pi/2];
    az1 = [az0(v1); 0; 0];
    plot(az1,el1,'.b','MarkerSize',20)
    xlabel('Az*cos(El) (rad)'); ylabel('El (rad)'); title('Sinusoidal Projection')
    set(gca,'XTick',-4*pi:pi:4*pi,'XTickLabel',{'-4pi','-3pi','-2pi','-pi','0','pi','2pi','3pi','4pi'})
    set(gca,'YTick',-pi/2:pi/4:pi/2,'YTickLabel',{'-pi/2','-pi/4','0','pi/4','pi/2'})
    
    subplot(212);
    az1 = az1./cos(el1);
    az0 = az0./cos(el0);
    v1 = find(abs(az0)<(6*pi));
    plot(az0(v1),el0(v1),'.m');  hold on
    plot(az1,el1,'.b','MarkerSize',20);
    plot(x2./cos(y2),y2,'r','LineWidth',5)
    plot(x1./cos(y1),y1,'g','LineWidth',5)
    axis equal tight;
    xlabel('Az (rad)'); ylabel('El (rad)'); title('Mercator Projection')
    set(gca,'XTick',-4*pi:pi:4*pi,'XTickLabel',{'-4pi','-3pi','-2pi','-pi','0','pi','2pi','3pi','4pi'})
    set(gca,'YTick',-pi/2:pi/4:pi/2,'YTickLabel',{'-pi/2','-pi/4','0','pi/4','pi/2'})
    
    
    subplot(222);
    [x,y,z] = sphere(30); surf(x,y,z,'EdgeColor','w','FaceColor',[.7 .7 .7]); hold on
    cc3 = fcnSC2CC([ones(numel(v1),1) el0(v1) az0(v1)]);
    plot3(cc3(:,1),cc3(:,2),cc3(:,3),'m.','MarkerSize',10); axis tight equal vis3d; grid off; box on
    plot3(cc(:,1),cc(:,2),cc(:,3),'b.','MarkerSize',20);
    cc1 = fcnSC2CC([ones(numel(y1),1)*1.02 y1' (x1./cos(y1))'+.03]);
    cc2 = fcnSC2CC([ones(numel(y2),1)*1.02 y2' (x2./cos(y2))'-.03]);
    plot3(cc1(:,1),cc1(:,2),cc1(:,3),'g','LineWidth',5)
    plot3(cc2(:,1),cc2(:,2),cc2(:,3),'r','LineWidth',5)
    xlabel('X'); ylabel('Y'); zlabel('Z'); set(gca,'YDir','reverse','ZDir','reverse'); title('3D Sphere')
end








% cc = [  -0.747652890184928        -0.321586967393372        -0.581030961482139
%          0.313090254120263        -0.840625615359261         0.441953693928191
%         -0.902919734077452        -0.392255513187521         0.175703062544449
%         -0.445057852355085        -0.877254384661835        -0.179856199917226
%         0.0191648378856287        -0.478187525660449         0.878048631507137
%          0.729805093994244       -0.0150100959550102        -0.683490469428415
%          0.318485158269486         0.202798610459204        -0.925980522234608
%         -0.933471505851571         0.264331910846754         0.242403771982418
%          0.366283766697754         -0.88325889419163        -0.292728420357649
%         -0.504083568272385         0.830941138339376         0.235449741586273
%         -0.422134990469078        -0.473629027206033        -0.772966748579483
%          0.562122376389526         0.342971801034031         -0.75258805309257
%           0.47488670832709       -0.0440884468022111        -0.878941876982107
%         -0.316503181926798         0.824206835710962        -0.469583674969154
%         -0.851012783302676        -0.227403528224722          0.47335491758973
%         -0.201505059887582         0.960918311025049         0.189820205395708
%          0.134946638458873          0.99035188966013        0.0315045935580923
%          0.956463939949156       -0.0172333109503254        -0.291341285386447
%          0.153634967997045        -0.812976248914578        -0.561663524994573
%         -0.045116422233054        -0.998512785714592        0.0306059668916889
%         -0.851158728687144         0.318701805244035        -0.417082699130372
%          -0.64292364111967        -0.155491800804942         0.749980994140427
%          0.040027769326845        -0.781222928464844         0.622967506153836
%           0.57151139162512         0.817770040488456        0.0680212475791796
%         -0.971118251972848       -0.0129809866388241        -0.238245324552412
%         0.0323659781466574         0.622499622994987         0.781950550117914
%          0.939826349692285        -0.311045842208315        -0.141339720068332
%         -0.699855468794036        -0.532820179093236          0.47571522947046
%          0.884582439150109         0.417684693614843         0.207493144626801
%         -0.107696877907393        -0.625660797430301        -0.772625361380196
%          0.363222628527568         0.474154172814948         0.802026896386709
%          0.551762851974431        -0.834000144142603      -0.00123075227426574
%           0.27960636753143        -0.957537236287372        0.0703044832071291
%          0.363881413036082         0.708661541363741        -0.604474264993002
%         -0.522709698368653        -0.441760688569855         0.729124176848937
%         -0.312284938916817          0.58820851768192        -0.745981807185777
%        -0.0128329111799609         0.779532704937268        -0.626230052236263
%         -0.779718558233148         0.586454163718457         0.219341021708448
%          0.578451311054925        -0.745640759268962         0.330777778660606
%           0.99315012315382        0.0865462962729932        0.0785020476228455
%         -0.987890830135373       -0.0930487208242668         0.124151694661858
%          0.788628509471027         0.609585501908488       -0.0804399770790797
%        -0.0784996629834994         0.376122478822591        -0.923238692774424
%         -0.384884756311282        -0.915763911488638         0.115065993126704
%         -0.313066647875459         0.517145832803742         0.796586129430928
%         -0.554806509075221        -0.143692417802117        -0.819476800497701
%           0.65876932530018         0.671967917752027         0.338352026084595
%         -0.254459300309275        -0.676496600754889         0.691088137398692
%         -0.402379046598918        -0.796846871477315         0.450695203297042
%         -0.911921204272241        -0.335869454901685        -0.235778341801596
%           0.74581589590743        -0.628285591530498        -0.221395268438532
%          0.343388654882662         0.718252032209972         0.605143164816493
%         -0.604829957280966         0.620809175765224        -0.498775189901431
%         -0.227144421869287        -0.266247376452159        -0.936759171903862
%          0.813080183948139         0.257581369317655        -0.522065563556246
%          0.569112449239518        -0.369089264521919        -0.734768082414625
%          0.246066903817843        -0.560988943200037        -0.790406531129903
%         -0.284839653090177        -0.813300409571453        -0.507354723855386
%          0.815092574733733        -0.566794371384457         0.119867573516913
%         -0.622586701434447         0.328624653435316        -0.710205348016679
%        -0.0733078266960112         0.332881994506803         0.940114642093335
%          0.884013881761852         0.149745110832594         0.442827120481659
%          0.840431358597636        -0.199677067461463         0.503789837348593
%          0.190260750853732        -0.275806772752388          -0.9421950280003
%          -0.20085419577021         0.967185759121349        -0.155593378375697
%          0.933727761326556         0.314658230439894        -0.170712230799476
%          0.650921103688794        -0.520418850096799         0.552689729628196
%         0.0305873117972021         0.884132504791687         0.466233986671712
%          -0.50543776999959         0.855690731805726        -0.111022665071695
%          0.532829355615869        -0.675578483373161        -0.509594535486005
%          0.823831850597751        -0.301991467935533        -0.479689728089758
%          0.110743175640674         0.940094201833908        -0.322426488873487
%          0.666791937825853         0.582104277076188        -0.465341941221778
%          0.329417540082174         0.899426569509102         0.287255862163502
%        -0.0439468377733134        -0.939627008368994         0.339366705192571
%          0.948814651096306        -0.236388980960605         0.209454070252649
%          0.310035380581945        -0.612759065549374           0.7269142936925
%         -0.396601385487369        0.0949805932480039         0.913064087529324
%         -0.954550001085586         0.292376909645775       -0.0578795139362359
%         -0.645445184601952         0.562533971108522         0.516677892911076
%           0.63002695382143         0.128406643103572         0.765883654000633
%          -0.61668440961551         0.259526556183791         0.743200044115009
%         -0.823654849167562      -0.00106346347191296        -0.567090432372302
%          0.194857699669509         0.534368241656557        -0.822484686294151
%          0.275044521357146        -0.260105542586792         0.925578531507213
%          0.313567027234433         0.154224719893331         0.936958086151768
%          0.584712672669503        -0.244117581199286         0.773639255059551
%           0.68142388750756         0.441899259748013         0.583426541878446
%          0.466285115842187         0.847572412435529        -0.253375603447246
%         -0.298200316746928         0.785843911675329         0.541780322247725
%         -0.849628081653607         0.114230384678788         0.514862643898105
%         -0.745037813621811        -0.641914244076033        -0.181286401933311
%          -0.70546243568549         -0.69042213253881         0.160125047188933
%         -0.259344936509856        -0.291422993713237         0.920767529098368
%         -0.766592229687691         0.623586220822615        -0.153220685883546
%         -0.587183394609228        -0.628643391709435         -0.50992464850725
%        -0.0315702938628221        -0.956129296010598        -0.291238881085088
%         -0.367915383869698         0.154640371163042        -0.916910369621027
%                          0                         0                         1
%                          0                         0                        -1];

%PLOT SPHERE POINTS
% figure;
% [x,y,z] = sphere(100);
% surf(x,y,z,'EdgeColor','none','FaceColor',[.7 .7 .7]); hold on
% plot3(cc(:,1),cc(:,2),cc(:,3),'r.','MarkerSize',20);
% camlight; view(30,30); material dull; axis equal vis3d


%CREATE NEW SPHERE POINTS
% clc
% close all
% clear all
% 
% np = 100;
% cc = randn(np,3);
% cc = fcnVec2uVec(cc)*1; %unit vectors around the sphere
% cc(99,1:3) = [0 0 1];
% cc(100,1:3) = [0 0 -1];
% 
% figure;
% [x,y,z] = sphere(100); xlabel('X'); ylabel('Y'); zlabel('Z'); set(gca,'YDir','reverse','ZDir','reverse');
% surf(x,y,z,'EdgeColor','none','FaceColor',[.7 .7 .7]); hold on
% h = plot3(cc(:,1),cc(:,2),cc(:,3),'r.','MarkerSize',20);
% camlight; view(30,30); material dull; axis equal vis3d
% 
% pause(.5)
% 
% vi = [1:np]';
% for j = 1:10000
%     for i = 1:np
%         p1 = cc(i,1:3);
%         rv =  ones(np,1)*p1 - cc;
%         r = sqrt(rv(:,1).^2+rv(:,2).^2+rv(:,3).^2);
%         
%         v1 = find(r<1 & r~=0);
%         if numel(v1)~=0
%             for k = (v1')
%                 if k<(np-2) %don't move 2 polar ones
%                     minr = r(k);
%                     p2 = cc(k,1:3); %to be moved
%                     
%                     vec = (p2-p1)/minr*.0015/minr^2*2;
%                     p2 = p2+vec;
%                     p2 = p2/norm(p2); %normalize back to the surface
%                     cc(k,1:3) = p2;
%                 end
%             end
%         end
%     end
%     delete(h)
%     h = plot3(cc(:,1),cc(:,2),cc(:,3),'r.','MarkerSize',20);
%     drawnow
% end
