/***************************************************************************
                          ip.c  -  description
                             -------------------
    begin                : Tue Apr 2 2002
    copyright            : (C) 2002 by Josiah Zayner
    email                : phric@legions.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _WAND_H
#include "wand.h"
#endif


int get_ip_arg(char *arg, char *next_arg, struct ip *yourp, int *opts)
{
  struct protoent *ourproto = NULL;
  static int optlen;

  switch((int)arg[2])
  {

    case 's':
    yourp->ip_src = wherefromto(next_arg);
    break;

    case 'd':
    yourp->ip_dst = wherefromto(next_arg);
    break;

    case 'h':
    yourp->ip_hl = atoi(next_arg);
    break;

    case 'v':
    yourp->ip_v = atoi(next_arg);
    break;

    case 'l':

    yourp->ip_ttl = atoi(next_arg);
    break;

    case 't':
    yourp->ip_tos = atoi(next_arg);
    break;


    case 'o':
    if(strstr(next_arg, "F"))
    {  yourp->ip_off = htons(0x1000); }
    else if(strstr(next_arg, "D"))
    { yourp->ip_off = htons(0x4000); }
    else if(strstr(next_arg, "M"))
    { yourp->ip_off = htons(0x2000); }
    else if(strstr(next_arg, "N"))
    { yourp->ip_off = 0; }
    break;

    case 'i':
    yourp->ip_id = htons(atoi(next_arg));
    break;

    case 'p':
    if((ourproto = getprotobyname(next_arg)) == NULL)
    {
      perror("Getprotobyname:");
      exit(-1);
    }
    yourp->ip_p = ourproto->p_proto;
    break;

    case 'e':

    break;

    /* give us good argument or give us death */
    default:
    fprintf(stderr, "Bad Option: %s, see usage -h\n", arg);
    exit(-1);
    break;
  }

  /* we return our options length */
  return optlen;
}

