/***************************************************************************
                          wand.h  -  description
                             -------------------
    begin                : Sat Feb 2 2002
    copyright            : (C) 2002 by Josiah Zayner
    email                : phric@legions.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef _WAND_H
#define _WAND_H

#ifndef _BSD_SOURCE
#define _BSD_SOURCE
#endif

#ifndef __FAVOR_BSD
#define __FAVOR_BSD
#endif

#ifndef __USE_BSD
#define __USE_BSD
#endif

#ifndef __USE_BSD_SOURCE
#define __USE_BSD_SOURCE
#endif

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <unistd.h>
#include <fcntl.h>
#include <features.h>
#include <string.h>
#include <netdb.h>
#include <time.h>
#include <ctype.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <arpa/nameser.h>
#include<net/if.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>

#if __GLIBC__ >= 2 && __GLIBC_MINOR >=1
#include <netpacket/packet.h>
#include <net/ethernet.h>
#else
#include <asm/types.h>
#include <linux/if_packet.h>
#include <linux/if_ether.h>
#endif

/* not using these now put them in later
#include <net/if.h>
#include <net/if_arp.h>
*/
#include <arpa/inet.h>

#include "ip.h"
#include "icmp.h"
#include "igmp.h"
#include "udp.h"
#include "route.h"
#include "tcp.h"



/* to recv all ethernet packets on device */
#ifndef ETH_P_ALL
#define ETH_P_ALL   0x0003
#endif

/* prefixed to tcp and udp header for checksum so we get protection from misrouted segments */
struct nmrhdr{

  struct in_addr saddr;
  struct in_addr daddr;
  unsigned char none;
  unsigned char protocol;
  unsigned short length;

};
#define S_NMR      sizeof(struct nmrhdr)


struct looky {
    struct ip *iph;
    struct icmp *icmph;
    struct igmp *igmph;
    struct tcphdr *tcph;
    struct udphdr *udph;

};


struct extra_ingredients {
    u_short pack_sz;
    u_short dport;
    u_int num;
    int READ_IT;
};


int pooper_snooper(int tosnooporpoop, struct in_addr dst, int dport, void *gtkwid);

/* diplay your flags with honor! */
char *TCP_FLAGS(u_char flags);

/* clean allocation of memory */
void *clalloc(int bytes);

/* looking up address */
struct in_addr wherefromto(const char *herefrom);

/* to calculate internet checksum */
unsigned short in_cksum(unsigned short *addr, int len);

void prterr(char *message);

/* Begin GTK includes and stuff */
#ifdef _GTK_
#include <gtk/gtk.h>

GtkWidget *fixed_pos;
GtkWidget *tab, *snoop_check;

struct packmack{

  unsigned short d_port;
  unsigned int packsz;

};



/*
   it's all gtk_signal_connect()'s fault I tell ya',
*/

struct packmack *icmp_gather(char *icmp_pack, char *data);
struct packmack *udp_gather(char *udp_pack, char *data,
                            struct in_addr scorch,
                            struct in_addr desterdly
                           );
struct packmack *tcp_gather(char *tcp_pack,
                            char *data,
                            struct in_addr sourcery,
                            struct in_addr destined);

void gather_info(char *envelope, int proto, int pasize);

void ip_cauldron(void);
void tcp_spell(void);
void udp_spell(void);

GtkWidget *make_misc_meat(void);
void clear_tcp(void);
void clear_udp(void);
void clear_icmp(void);
void clear_dns(void);

void ip_defaults(GtkWidget *oldbutton);
void tcp_defaults(void);
void udp_defaults(void);
void icmp_defaults(void);
void send_packet(GtkWidget *oldbutton);
int packet_send(void);


/* for the ICMP type combo box */
int geticmptypebyname(const char *type_name);

/* for the ICMP sub combo box */
int geticmpsubbyname(const char *sub_name);

/* for making and displaying widgets! */

/* for combo box */
GtkWidget *make_combo(GtkWidget *fixer,
                      GtkWidget *box,
                      int obj_len,
                      int obj_hi,
                      short int pos_len,
                      short int pos_hi
                     );

/* for dem der labels */
GtkWidget *make_label(GtkWidget *fixer,
                      GtkWidget *lbl,
                      char *text,
                      short int pos_len,
                      short int pos_hi
                     );

/* yes you guessed it for buttons */
GtkWidget *make_button(GtkWidget *fixed,
                       GtkWidget *button,
                       const gchar *text,
                       int obj_len,
                       int obj_hi,
                       short int pos_len,
                       short int pos_hi,
                       int textorcheck
                      );

/* for text boxes */
GtkWidget *make_text(GtkWidget *fixer,
                     GtkWidget *text,
                     int obj_len,
                     int obj_hi,
                     short int pos_len,
                     short int pos_hi
                    );

GtkWidget *make_tex(GtkWidget *fixer,
                    GtkWidget *text,
                    int obj_len,
                    int obj_hi,
                    short int pos_len,
                    short int pos_hi
                   );

#endif /* _GTK_ */


#ifdef _CON_
/* send out our creations! */
int cast_spell(char *envelope,
               struct extra_ingredients exi,
               struct in_addr dst,
               struct in_addr src
              );

/* to intialize our IP header */
void ip_sorcery(struct ip *ip_sorc,
                struct in_addr source,
                struct in_addr dest,
                int proto,
                unsigned int hl,
                unsigned int ver,
                unsigned char tos,
                unsigned short len,
                unsigned short id,
                unsigned char ttl,
                int off
               );

/* build and send our packets */
int packet_sorcery(char *pack,
                   struct extra_ingredients exi,
                   struct in_addr daddr,
                   struct in_addr saddr
                  );


int mix_ipoption(unsigned int opt,
                 unsigned int optlen,
                 unsigned int totlen,
                 struct ip *ip_p,
                 char *pack
                );


#endif /* _CON_ */

#endif /* _WAND_H */

