/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.conv;

import com.jclark.xsl.conv.AlphabetFormatTokenHandler;
import com.jclark.xsl.conv.AlphabetNumberFormat;
import com.jclark.xsl.conv.DecimalNumberFormat;
import com.jclark.xsl.conv.FormatTokenHandler;
import com.jclark.xsl.conv.NumberFormat;
import com.jclark.xsl.conv.RomanNumberFormat;
import java.util.Hashtable;

public class NumberListFormat
implements Cloneable {
    private static NumberFormat defaultFormat = new DecimalNumberFormat('0', 1);
    private static Hashtable formatTokenHandlerTable = new Hashtable();
    private NumberFormat[] formats = null;
    private String[] formatTokens = new String[]{"1"};
    private String prefix = "";
    private String suffix = "";
    private String[] separators = new String[]{"."};
    private int groupingSize = 0;
    private String groupingSeparator = null;
    private String lang = null;
    private String letterValue = null;

    public static void setFormatTokenHandler(String string, FormatTokenHandler formatTokenHandler) {
        formatTokenHandlerTable.put(string, formatTokenHandler);
    }

    public void setFormat(String string) {
        this.formats = null;
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            if (NumberListFormat.isAlnum(string.charAt(n2)) && (n2 == 0 || !NumberListFormat.isAlnum(string.charAt(n2 - 1)))) {
                ++n;
            }
            ++n2;
        }
        if (n == 0) {
            this.formatTokens = new String[1];
            this.formatTokens[0] = "1";
            this.prefix = "";
        } else {
            this.formatTokens = new String[n];
        }
        if (n <= 1) {
            this.separators = new String[1];
            this.separators[0] = ".";
        } else {
            this.separators = new String[n - 1];
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            int n5 = n3;
            while (!NumberListFormat.isAlnum(string.charAt(n3))) {
                ++n3;
            }
            if (n4 == 0) {
                this.prefix = string.substring(0, n3);
            } else {
                this.separators[n4 - 1] = string.substring(n5, n3);
            }
            int n6 = n3++;
            while (n3 < string.length() && NumberListFormat.isAlnum(string.charAt(n3))) {
                ++n3;
            }
            this.formatTokens[n4] = string.substring(n6, n3);
            ++n4;
        }
        this.suffix = string.substring(n3);
    }

    private static boolean isAlnum(char c) {
        switch (Character.getType(c)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    public void setLang(String string) {
        this.formats = null;
        this.lang = string;
    }

    public void setLetterValue(String string) {
        this.letterValue = string;
    }

    public void setGroupingSeparator(String string) {
        this.groupingSeparator = string == null || string.length() == 0 ? null : string;
    }

    public void setGroupingSize(int n) {
        this.groupingSize = n;
    }

    public String getPrefix(int n) {
        if (n == 0) {
            return this.prefix;
        }
        if (--n < this.separators.length) {
            return this.separators[n];
        }
        return this.separators[this.separators.length - 1];
    }

    public String formatNumber(int n, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("cannot format negative number");
        }
        return this.group(this.getFormat(n).format(n2));
    }

    public String getSuffix() {
        return this.suffix;
    }

    private NumberFormat getFormat(int n) {
        if (this.formats == null) {
            this.formats = new NumberFormat[this.formatTokens.length];
        }
        if (n >= this.formats.length) {
            n = this.formats.length - 1;
        }
        if (this.formats[n] == null) {
            this.formats[n] = this.findFormat(this.formatTokens[n]);
        }
        return this.formats[n];
    }

    private NumberFormat findFormat(String string) {
        NumberFormat numberFormat = this.findDecimalFormat(string);
        if (numberFormat != null) {
            return numberFormat;
        }
        FormatTokenHandler formatTokenHandler = (FormatTokenHandler)formatTokenHandlerTable.get(string);
        if (formatTokenHandler != null && (numberFormat = formatTokenHandler.getFormat(this.lang, this.letterValue)) != null) {
            return numberFormat;
        }
        return defaultFormat;
    }

    private NumberFormat findDecimalFormat(String string) {
        char c = string.charAt(string.length() - 1);
        if (!Character.isDigit(c) || Character.digit(c, 10) != 1) {
            return null;
        }
        int n = 0;
        while (n < string.length() - 1) {
            if (string.charAt(n) + '\u0001' != c) {
                return null;
            }
            ++n;
        }
        return new DecimalNumberFormat((char)(c - '\u0001'), string.length());
    }

    private String group(String string) {
        if (this.groupingSeparator == null || this.groupingSize <= 0 || string.length() <= this.groupingSize) {
            return string;
        }
        char[] cArray = new char[string.length() + (string.length() - 1) / this.groupingSize * this.groupingSeparator.length()];
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            if (n2 > 0 && (string.length() - n2) % this.groupingSize == 0) {
                int n3 = 0;
                while (n3 < this.groupingSeparator.length()) {
                    cArray[n++] = this.groupingSeparator.charAt(n3);
                    ++n3;
                }
            }
            cArray[n++] = string.charAt(n2);
            ++n2;
        }
        return new String(cArray);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    static {
        AlphabetNumberFormat alphabetNumberFormat = new AlphabetNumberFormat("abcdefghijklmnopqrstuvwxyz");
        AlphabetFormatTokenHandler alphabetFormatTokenHandler = new AlphabetFormatTokenHandler(alphabetNumberFormat);
        formatTokenHandlerTable.put("a", alphabetFormatTokenHandler);
        alphabetNumberFormat = new AlphabetNumberFormat("ABCDEFGHIJKLMNOPQRSTUVWXYZ");
        alphabetFormatTokenHandler = new AlphabetFormatTokenHandler(alphabetNumberFormat);
        formatTokenHandlerTable.put("A", alphabetFormatTokenHandler);
        formatTokenHandlerTable.put("i", new RomanNumberFormat("mdclxvi"));
        formatTokenHandlerTable.put("I", new RomanNumberFormat("MDCLXVI"));
    }
}

