/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.dom;

import com.jclark.xsl.dom.DOMBuilder;
import com.jclark.xsl.dom.DOMExtensions;
import com.jclark.xsl.dom.NodeBase;
import com.jclark.xsl.dom.RootNode;
import com.jclark.xsl.dom.Transform;
import com.jclark.xsl.dom.TransformEngine;
import com.jclark.xsl.dom.TransformException;
import com.jclark.xsl.om.Name;
import com.jclark.xsl.om.NameTable;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.XSLException;
import com.jclark.xsl.sax.ExtensionHandlerImpl;
import com.jclark.xsl.sax.MultiNamespaceResult;
import com.jclark.xsl.tr.Engine;
import com.jclark.xsl.tr.EngineImpl;
import com.jclark.xsl.tr.LoadContext;
import com.jclark.xsl.tr.ParameterSet;
import com.jclark.xsl.tr.Result;
import com.jclark.xsl.tr.Sheet;
import com.jclark.xsl.tr.XMLProcessor;
import java.io.IOException;
import java.net.URL;
import org.w3c.dom.DocumentFragment;

public class XSLTransformEngine
implements TransformEngine,
XMLProcessor {
    private Engine engine = new EngineImpl(this, new ExtensionHandlerImpl());
    private DOMExtensions extend;

    public LoadContext getSourceLoadContext() {
        return this.engine.getSheetLoadContext();
    }

    public Node load(URL uRL, int n, LoadContext loadContext, NameTable nameTable) throws XSLException {
        throw new XSLException("external documents not supported");
    }

    public NameTable getNameTable() {
        return this.engine.getNameTable();
    }

    public Result createResult(Node node, int n, LoadContext loadContext, Node[] nodeArray) throws XSLException {
        if (node == null) {
            throw new XSLException("cannot convert result tree fragment returned by extension function to a node-set with the DOM");
        }
        RootNode rootNode = ((NodeBase)node).root;
        DocumentFragment documentFragment = rootNode.ownerDocument.createDocumentFragment();
        String string = null;
        URL uRL = node.getURL();
        if (uRL != null) {
            string = uRL.toString();
        }
        nodeArray[0] = new RootNode(documentFragment, this.extend, loadContext, this.engine.getNameTable(), string, n);
        return new MultiNamespaceResult(new DOMBuilder(documentFragment), null);
    }

    public XSLTransformEngine() {
    }

    public XSLTransformEngine(DOMExtensions dOMExtensions) {
        this();
        this.extend = dOMExtensions;
    }

    public Transform createTransform(org.w3c.dom.Node node) throws TransformException {
        try {
            return new TransformImpl(this.engine.createSheet(new RootNode(node, this.extend, this.engine.getSheetLoadContext(), this.engine.getNameTable(), null, 0)));
        }
        catch (XSLException xSLException) {
            throw this.toTransformException(xSLException);
        }
        catch (IOException iOException) {
            throw new Error("unexpected exception: " + iOException);
        }
    }

    public Transform createTransform(Node node) throws TransformException {
        try {
            return new TransformImpl(this.engine.createSheet(node));
        }
        catch (XSLException xSLException) {
            throw this.toTransformException(xSLException);
        }
        catch (IOException iOException) {
            throw new Error("unexpected exception: " + iOException);
        }
    }

    private TransformException toTransformException(XSLException xSLException) {
        org.w3c.dom.Node node = null;
        Node node2 = xSLException.getNode();
        if (node2 != null) {
            node = ((NodeBase)node2).domNode;
        }
        String string = xSLException.getMessage();
        if (xSLException == null) {
            string = xSLException.getException().toString();
        }
        return new TransformException(string, node);
    }

    private class TransformImpl
    implements Transform,
    ParameterSet {
        private Sheet sheet;

        TransformImpl(Sheet sheet) {
            this.sheet = sheet;
        }

        public void transform(org.w3c.dom.Node node, org.w3c.dom.Node node2) throws TransformException {
            try {
                this.sheet.process(new RootNode(node, XSLTransformEngine.this.extend, this.sheet.getSourceLoadContext(), XSLTransformEngine.this.engine.getNameTable(), null, 0), XSLTransformEngine.this, this, new MultiNamespaceResult(new DOMBuilder(node2), null));
            }
            catch (XSLException xSLException) {
                throw XSLTransformEngine.this.toTransformException(xSLException);
            }
        }

        public void transform(Node node, Result result) throws TransformException {
            try {
                this.sheet.process(node, XSLTransformEngine.this, this, result);
            }
            catch (XSLException xSLException) {
                xSLException.printStackTrace();
                throw XSLTransformEngine.this.toTransformException(xSLException);
            }
        }

        public Object getParameter(Name name) {
            return null;
        }
    }
}

