/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.tr;

import com.jclark.xsl.expr.ExprContext;
import com.jclark.xsl.expr.Variant;
import com.jclark.xsl.expr.VariantExpr;
import com.jclark.xsl.om.Name;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.XSLException;
import com.jclark.xsl.tr.Action;

abstract class ParamAction
implements Action {
    private Name[] paramNames = null;
    private VariantExpr[] paramExprs = null;

    ParamAction() {
    }

    void addParam(Name name, VariantExpr variantExpr) {
        if (this.paramNames == null) {
            this.paramNames = new Name[]{name};
            this.paramExprs = new VariantExpr[]{variantExpr};
        } else {
            Name[] nameArray = this.paramNames;
            this.paramNames = new Name[nameArray.length + 1];
            System.arraycopy(nameArray, 0, this.paramNames, 0, nameArray.length);
            this.paramNames[nameArray.length] = name;
            VariantExpr[] variantExprArray = this.paramExprs;
            this.paramExprs = new VariantExpr[variantExprArray.length + 1];
            System.arraycopy(variantExprArray, 0, this.paramExprs, 0, variantExprArray.length);
            this.paramExprs[variantExprArray.length] = variantExpr;
        }
    }

    Name[] getParamNames() {
        return this.paramNames;
    }

    Variant[] getParamValues(Node node, ExprContext exprContext) throws XSLException {
        if (this.paramExprs == null) {
            return null;
        }
        Variant[] variantArray = new Variant[this.paramExprs.length];
        int n = 0;
        while (n < variantArray.length) {
            variantArray[n] = this.paramExprs[n].eval(node, exprContext).makePermanent();
            ++n;
        }
        return variantArray;
    }
}

