/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.adapter;

import com.sun.star.io.XInputStream;
import java.io.IOException;
import java.io.InputStream;

public class XInputStreamToInputStreamAdapter
extends InputStream {
    private XInputStream xin;

    public XInputStreamToInputStreamAdapter(XInputStream xInputStream) {
        this.xin = xInputStream;
    }

    public int available() throws IOException {
        int n;
        try {
            n = this.xin.available();
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
        return n;
    }

    public void close() throws IOException {
        try {
            this.xin.closeInput();
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    public int read() throws IOException {
        byte[][] byArray = new byte[1][1];
        try {
            long l = this.xin.readBytes(byArray, 1);
            if (l <= 0L) {
                return -1;
            }
            int n = byArray[0][0];
            if (n < 0) {
                n = 256 + n;
            }
            return n;
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    public int read(byte[] byArray) throws IOException {
        int n;
        byte[][] byArray2 = new byte[1][byArray.length];
        try {
            n = this.xin.readBytes(byArray2, byArray.length);
            if (n <= 0) {
                return -1;
            }
            if (n < byArray.length) {
                System.arraycopy(byArray2[0], 0, byArray, 0, n);
            } else {
                System.arraycopy(byArray2[0], 0, byArray, 0, byArray.length);
            }
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        boolean bl = false;
        byte[][] byArray2 = new byte[1][byArray.length];
        try {
            long l = 0L;
            l = n2 > this.xin.available() ? (long)this.xin.readBytes(byArray2, this.xin.available()) : (long)this.xin.readBytes(byArray2, n2);
            if (l <= 0L) {
                return -1;
            }
            if (l < (long)n2) {
                System.arraycopy(byArray2[0], 0, byArray, n, (int)l);
            } else {
                System.arraycopy(byArray2[0], 0, byArray, n, n2);
            }
            return (int)l;
        }
        catch (Exception exception) {
            throw new IOException("reader error: " + exception.toString());
        }
    }

    public long skip(long l) throws IOException {
        int n;
        long l2 = l;
        try {
            n = this.xin.available();
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
        do {
            int n2 = l2 >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
            l2 -= (long)n2;
            try {
                this.xin.skipBytes(n2);
            }
            catch (Exception exception) {
                throw new IOException(exception.toString());
            }
        } while (l2 > 0L);
        if ((long)n < l) {
            return n;
        }
        return l;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int n) {
    }

    public void reset() throws IOException {
    }
}

