/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.sandbox;

import com.sun.star.lib.sandbox.ClassContextImpl;
import com.sun.star.lib.sandbox.SandboxSecurityException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.IdentityScope;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.security.provider.IdentityDatabase;

public class SandboxSecurity
extends SecurityManager {
    private static boolean debug = false;
    public static final int NETWORK_NONE = 1;
    public static final int NETWORK_HOST = 2;
    public static final int NETWORK_UNRESTRICTED = 3;
    private static final int PRIVELEGED_PORT = 1024;
    boolean bNoExit;
    boolean initACL;
    String[] readACL;
    String[] writeACL;
    int networkMode;
    boolean bCheckSecurity;
    IdentityScope scope;
    Hashtable loadedClasses;

    public int getNetworkMode() {
        return this.networkMode;
    }

    public SandboxSecurity() {
        this.reset();
    }

    public SandboxSecurity(boolean bl) {
        this.reset();
        this.bNoExit = bl;
    }

    public void reset() {
        String string = System.getProperty("appletviewer.security.mode");
        this.networkMode = string == null ? 2 : (string.equals("unrestricted") ? 3 : (string.equals("none") ? 1 : 2));
        this.bCheckSecurity = !Boolean.getBoolean("stardiv.security.disableSecurity");
        IdentityScope identityScope = IdentityScope.getSystemScope();
        if (identityScope instanceof IdentityDatabase) {
            this.scope = (IdentityDatabase)identityScope;
            this.debug("installing " + identityScope + " as the scope for signers.");
        } else {
            this.debug("no signer scope found.");
        }
        this.loadedClasses = new Hashtable();
    }

    boolean inApplet() {
        return this.inClassLoader();
    }

    public Object getSecurityContext() {
        ClassLoader classLoader = this.currentClassLoader();
        if (classLoader == null) {
            return null;
        }
        if (classLoader instanceof ClassContextImpl) {
            ClassContextImpl classContextImpl = (ClassContextImpl)classLoader;
            return classContextImpl.getBase();
        }
        throw new SandboxSecurityException("getsecuritycontext.unknown");
    }

    public synchronized void checkCreateClassLoader() {
        if (this.bCheckSecurity && !this.isSecureLoader() && this.classLoaderDepth() == 2) {
            throw new SandboxSecurityException("checkcreateclassloader");
        }
    }

    protected boolean inThreadGroup(ThreadGroup threadGroup) {
        ClassLoader classLoader = this.currentClassLoader();
        if (classLoader instanceof ClassContextImpl) {
            ClassContextImpl classContextImpl = (ClassContextImpl)classLoader;
            ThreadGroup threadGroup2 = classContextImpl.getThreadGroup();
            return threadGroup2.parentOf(threadGroup);
        }
        return false;
    }

    protected boolean inThreadGroup(Thread thread) {
        return this.inThreadGroup(thread.getThreadGroup());
    }

    public synchronized void checkAccess(Thread thread) {
        if (this.bCheckSecurity && !this.isSecureLoader() && this.classLoaderDepth() == 3 && !this.inThreadGroup(thread)) {
            throw new SandboxSecurityException("checkaccess.thread");
        }
    }

    public synchronized void checkAccess(ThreadGroup threadGroup) {
        if (this.bCheckSecurity && !this.isSecureLoader() && this.classLoaderDepth() == 4 && !this.inThreadGroup(threadGroup)) {
            throw new SandboxSecurityException("checkaccess.threadgroup", threadGroup.toString());
        }
    }

    public synchronized void checkExit(int n) {
        if (this.bNoExit) {
            throw new SandboxSecurityException("checkexit", String.valueOf(n));
        }
        if (this.bCheckSecurity && !this.isSecureLoader() && this.inApplet()) {
            throw new SandboxSecurityException("checkexit", String.valueOf(n));
        }
    }

    public synchronized void checkExec(String string) {
        if (this.bCheckSecurity && !this.isSecureLoader() && this.inApplet()) {
            throw new SandboxSecurityException("checkexec", string);
        }
    }

    public synchronized void checkLink(String string) {
        if (this.bCheckSecurity && !this.isSecureLoader()) {
            switch (this.classLoaderDepth()) {
                case 2: 
                case 3: {
                    throw new SandboxSecurityException("checklink", string);
                }
            }
        }
    }

    public synchronized void checkPropertiesAccess() {
        if (this.bCheckSecurity && !this.isSecureLoader() && this.classLoaderDepth() == 2) {
            throw new SandboxSecurityException("checkpropsaccess");
        }
    }

    public synchronized void checkPropertyAccess(String string) {
        String string2;
        boolean bl;
        if (this.bCheckSecurity && !this.isSecureLoader() && this.classLoaderDepth() == 2 && !(bl = new Boolean(string2 = System.getProperty(string + ".applet")).booleanValue())) {
            throw new SandboxSecurityException("checkpropsaccess.key", string2);
        }
    }

    void parseACL(Vector vector, String string, String string2) {
        String string3 = System.getProperty("path.separator");
        StringTokenizer stringTokenizer = new StringTokenizer(string, string3);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.startsWith("~")) {
                vector.addElement(System.getProperty("user.home") + string4.substring(1));
                continue;
            }
            if (string4.equals("+")) {
                if (string2 == null) continue;
                this.parseACL(vector, string2, null);
                continue;
            }
            vector.addElement(string4);
        }
    }

    String[] parseACL(String string, String string2) {
        if (string == null) {
            return new String[0];
        }
        if (string.equals("*")) {
            return null;
        }
        Vector vector = new Vector();
        this.parseACL(vector, string, string2);
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    void initializeACLs() {
        this.readACL = this.parseACL(System.getProperty("acl.read"), System.getProperty("acl.read.default"));
        this.writeACL = this.parseACL(System.getProperty("acl.write"), System.getProperty("acl.write.default"));
        this.initACL = true;
    }

    public synchronized void checkRead(String string) {
        if (this.bCheckSecurity && !this.isSecureLoader()) {
            ClassLoader classLoader = this.currentClassLoader();
            if (classLoader == null) {
                return;
            }
            if (!(classLoader instanceof ClassContextImpl)) {
                throw new SandboxSecurityException("checkread.unknown", string);
            }
            ClassContextImpl classContextImpl = (ClassContextImpl)classLoader;
            URL uRL = classContextImpl.getBase();
            this.checkRead(string, uRL);
        }
    }

    public synchronized void checkRead(String string, URL uRL) {
        if (this.bCheckSecurity && uRL != null && !this.isSecureLoader()) {
            if (!this.initACL) {
                this.initializeACLs();
            }
            if (this.readACL == null) {
                return;
            }
            String string2 = null;
            try {
                string2 = new File(string).getCanonicalPath();
            }
            catch (IOException iOException) {
                throw new SandboxSecurityException("checkread.exception1", iOException.getMessage(), string);
            }
            int n = this.readACL.length;
            while (n-- > 0) {
                if (!string2.startsWith(this.readACL[n])) continue;
                return;
            }
            if (uRL.getProtocol().equals("file")) {
                String string3 = null;
                try {
                    StringBuffer stringBuffer = new StringBuffer(256);
                    String string4 = "%20";
                    String string5 = uRL.getFile();
                    int n2 = 0;
                    int n3 = 0;
                    while ((n3 = string5.indexOf(string4, n2)) != -1) {
                        stringBuffer.append(string5.substring(n2, n3));
                        stringBuffer.append(" ");
                        n2 = n3 + string4.length();
                    }
                    stringBuffer.append(string5.substring(n2));
                    String string6 = stringBuffer.toString();
                    string3 = new File(string6).getCanonicalPath();
                }
                catch (IOException iOException) {
                    throw new SandboxSecurityException("checkread.exception2", iOException.toString());
                }
                if (string2.startsWith(string3)) {
                    return;
                }
            }
            throw new SandboxSecurityException("checkread", string, string2);
        }
    }

    public void checkRead(String string, Object object) {
        this.checkRead(string);
        if (object != null) {
            this.checkRead(string, (URL)object);
        }
    }

    public synchronized void checkWrite(String string) {
        if (this.bCheckSecurity && this.inApplet() && !this.isSecureLoader()) {
            if (!this.initACL) {
                this.initializeACLs();
            }
            if (this.writeACL == null) {
                return;
            }
            String string2 = null;
            try {
                string2 = new File(string).getCanonicalPath();
            }
            catch (IOException iOException) {
                throw new SandboxSecurityException("checkwrite.exception", iOException.getMessage(), string);
            }
            int n = this.writeACL.length;
            while (n-- > 0) {
                if (!string2.startsWith(this.writeACL[n])) continue;
                return;
            }
            throw new SandboxSecurityException("checkwrite", string, string2);
        }
    }

    public synchronized void checkRead(FileDescriptor fileDescriptor) {
        if (this.bCheckSecurity && !this.isSecureLoader() && (this.inApplet() && !this.inClass("java.net.SocketInputStream") || !fileDescriptor.valid())) {
            throw new SandboxSecurityException("checkread.fd");
        }
    }

    public synchronized void checkWrite(FileDescriptor fileDescriptor) {
        if (this.bCheckSecurity && !this.isSecureLoader() && (this.inApplet() && !this.inClass("java.net.SocketOutputStream") || !fileDescriptor.valid())) {
            throw new SandboxSecurityException("checkwrite.fd");
        }
    }

    public synchronized void checkListen(int n) {
        if (this.bCheckSecurity && !this.isSecureLoader() && this.inApplet() && n > 0 && n < 1024) {
            throw new SandboxSecurityException("checklisten", String.valueOf(n));
        }
    }

    public synchronized void checkAccept(String string, int n) {
        if (this.bCheckSecurity && !this.isSecureLoader()) {
            if (this.inApplet() && n < 1024) {
                throw new SandboxSecurityException("checkaccept", string, String.valueOf(n));
            }
            this.checkConnect(string, n);
        }
    }

    public synchronized void checkConnect(String string, int n) {
        if (this.bCheckSecurity && !this.isSecureLoader()) {
            ClassLoader classLoader = this.currentClassLoader();
            if (classLoader == null) {
                return;
            }
            int n2 = this.classDepth("sun.net.www.http.HttpClient");
            if (n2 > 1) {
                return;
            }
            if (this.getInCheck()) {
                return;
            }
            if (classLoader instanceof ClassContextImpl) {
                ClassContextImpl classContextImpl = (ClassContextImpl)classLoader;
                this.checkConnect(classContextImpl.getBase().getHost(), string);
            } else {
                throw new SandboxSecurityException("checkconnect.unknown");
            }
        }
    }

    public void checkConnect(String string, int n, Object object) {
        this.checkConnect(string, n);
        if (object != null) {
            this.checkConnect(((URL)object).getHost(), string);
        }
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void checkConnect(String var1_1, String var2_2, boolean var3_3) {
        block14: {
            if (!this.bCheckSecurity || this.isSecureLoader()) break block14;
            if (var1_1 == null) {
                return;
            }
            switch (this.networkMode) {
                case 1: {
                    throw new SandboxSecurityException("checkconnect.networknone", var1_1, var2_2);
                }
                case 2: {
                    try {
                        this.inCheck = true;
                        if (var1_1.equals(var2_2)) ** GOTO lbl24
                        try {
                            var4_4 = InetAddress.getByName(var2_2);
                            var5_6 = InetAddress.getByName(var1_1);
                            if (!var5_6.equals(var4_4)) ** GOTO lbl22
                        }
                        catch (UnknownHostException var6_11) {
                            throw new SecurityException("checkconnect.networkhost2" + var2_2 + var1_1);
                        }
                        var8_7 = null;
                        this.inCheck = false;
                        return;
lbl22:
                        // 2 sources

                        throw new SandboxSecurityException("checkconnect.networkhost1", var2_2, var1_1);
lbl24:
                        // 2 sources

                        var4_5 = InetAddress.getByName(var2_2);
                    }
                    catch (Throwable var7_13) {
                        var8_10 = null;
                        this.inCheck = false;
                        throw var7_13;
                    }
                    var8_8 = null;
                    this.inCheck = false;
                    {
                        return;
                        catch (UnknownHostException var6_12) {
                            if (var3_3) {
                                var8_9 = null;
                                this.inCheck = false;
                                return;
                            }
                            throw new SandboxSecurityException("checkconnect.networkhost3", var2_2);
                        }
                    }
                }
                case 3: {
                    return;
                }
            }
            throw new SandboxSecurityException("checkconnect", var1_1, var2_2);
        }
    }

    public synchronized void checkConnect(String string, String string2) {
        this.checkConnect(string, string2, Boolean.getBoolean("trustProxy"));
    }

    public synchronized boolean checkTopLevelWindow(Object object) {
        return !this.bCheckSecurity || !this.inClassLoader() || this.isSecureLoader();
    }

    public synchronized void checkPackageAccess(String string) {
        if (this.bCheckSecurity && this.inClassLoader() && !this.isSecureLoader()) {
            if (string.equals("stardiv.applet") || string.equals("stardiv.look") || string.equals("netscape.javascript")) {
                return;
            }
            String[] stringArray = new String[]{"com.sun.star.uno", "com.sun.star.lib.uno", "com.sun.star.comp.connections", "com.sun.star.comp.loader", "com.sun.star.comp.servicemanager"};
            int n = 0;
            while (n < stringArray.length) {
                if (string.startsWith(stringArray[n])) {
                    throw new SandboxSecurityException("checkpackageaccess2", string);
                }
                ++n;
            }
            int n2 = string.indexOf(46);
            while (n2 > 0) {
                String string2 = string.substring(0, n2);
                if (Boolean.getBoolean("package.restrict.access." + string2)) {
                    throw new SandboxSecurityException("checkpackageaccess", string);
                }
                n2 = string.indexOf(46, n2 + 1);
            }
        }
    }

    public synchronized void checkPackageDefinition(String string) {
    }

    public synchronized void checkSetFactory() {
        if (this.bCheckSecurity && this.inApplet() && !this.isSecureLoader()) {
            throw new SandboxSecurityException("cannotsetfactory");
        }
    }

    public void checkMemberAccess(Class clazz, int n) {
        ClassLoader classLoader;
        if (this.bCheckSecurity && !this.isSecureLoader() && n != 0 && (classLoader = this.currentClassLoader()) != null && this.classLoaderDepth() <= 3 && classLoader != clazz.getClassLoader()) {
            throw new SandboxSecurityException("checkmemberaccess");
        }
    }

    public void checkPrintJobAccess() {
        if (this.bCheckSecurity && this.inApplet() && !this.isSecureLoader()) {
            throw new SandboxSecurityException("checkgetprintjob");
        }
    }

    public void checkSystemClipboardAccess() {
        if (this.bCheckSecurity && this.inApplet() && !this.isSecureLoader()) {
            throw new SandboxSecurityException("checksystemclipboardaccess");
        }
    }

    public void checkAwtEventQueueAccess() {
        if (!(this.bCheckSecurity && this.inClassLoader() && this.isSecureLoader())) {
            // empty if block
        }
    }

    public void checkSecurityAccess(String string) {
        if (this.bCheckSecurity && this.inApplet() && !this.isSecureLoader()) {
            throw new SandboxSecurityException("checksecurityaccess", string);
        }
    }

    public ThreadGroup getThreadGroup() {
        ClassLoader classLoader = this.currentClassLoader();
        if (classLoader != null && classLoader instanceof ClassContextImpl) {
            if (this.inThreadGroup(Thread.currentThread())) {
                return Thread.currentThread().getThreadGroup();
            }
            ClassContextImpl classContextImpl = (ClassContextImpl)classLoader;
            return classContextImpl.getThreadGroup();
        }
        return super.getThreadGroup();
    }

    public void debug(String string) {
        if (debug) {
            System.err.println(string);
        }
    }

    private boolean isSecureLoader() {
        ClassLoader classLoader = this.currentClassLoader();
        if (classLoader != null) {
            if (classLoader instanceof ClassContextImpl) {
                return !((ClassContextImpl)classLoader).checkSecurity();
            }
            return true;
        }
        return true;
    }
}

