/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.sandbox.generic;

import com.sun.star.lib.sandbox.generic.PoolConstant;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Vector;

public class ConstantPool {
    Vector aAtoms = new Vector();

    public ConstantPool() {
        this.aAtoms.addElement(null);
    }

    public short size() {
        return (short)this.aAtoms.size();
    }

    private short addElement(PoolConstant poolConstant) {
        this.aAtoms.addElement(poolConstant);
        if (poolConstant.iTag == 5 || poolConstant.iTag == 6) {
            this.aAtoms.addElement(null);
        }
        return (short)this.aAtoms.indexOf(poolConstant);
    }

    public short getUtf8(String string) {
        PoolConstant poolConstant;
        short s = 1;
        while (s < this.aAtoms.size()) {
            poolConstant = (PoolConstant)this.aAtoms.elementAt(s);
            if (poolConstant != null && poolConstant.iTag == 1 && string.equals(poolConstant.aUTF)) {
                return s;
            }
            s = (short)(s + 1);
        }
        poolConstant = new PoolConstant();
        poolConstant.iTag = 1;
        poolConstant.aUTF = string;
        return this.addElement(poolConstant);
    }

    private short get(byte by, short s, short s2) {
        PoolConstant poolConstant;
        short s3 = 1;
        while (s3 < this.aAtoms.size()) {
            poolConstant = (PoolConstant)this.aAtoms.elementAt(s3);
            if (poolConstant != null && poolConstant.iTag == by && poolConstant.s == s && poolConstant.s1 == s2) {
                return s3;
            }
            s3 = (short)(s3 + 1);
        }
        poolConstant = new PoolConstant();
        poolConstant.iTag = by;
        poolConstant.s = s;
        poolConstant.s1 = s2;
        return this.addElement(poolConstant);
    }

    public short getString(String string) {
        short s = this.getUtf8(string);
        return this.get((byte)8, s, (short)0);
    }

    public short getClass(String string) {
        short s = this.getUtf8(string);
        return this.get((byte)7, s, (short)0);
    }

    public short getMethodRef(short s, short s2) {
        return this.get((byte)10, s, s2);
    }

    public short getInterfaceMethodRef(short s, short s2) {
        return this.get((byte)11, s, s2);
    }

    public short getFieldRef(short s, short s2) {
        return this.get((byte)9, s, s2);
    }

    public short getNameAndType(short s, short s2) {
        return this.get((byte)12, s, s2);
    }

    public short getNameAndType(String string, String string2) {
        short s = this.getUtf8(string);
        short s2 = this.getUtf8(string2);
        return this.get((byte)12, s, s2);
    }

    public void read(DataInput dataInput) throws IOException {
        short s = dataInput.readShort();
        short s2 = 1;
        while (s2 < s) {
            PoolConstant poolConstant = new PoolConstant();
            poolConstant.read(dataInput);
            this.aAtoms.addElement(poolConstant);
            if (poolConstant.iTag == 5 || poolConstant.iTag == 6) {
                s2 = (short)(s2 + 1);
            }
            s2 = (short)(s2 + 1);
        }
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this.aAtoms.size());
        int n = 1;
        while (n < this.aAtoms.size()) {
            PoolConstant poolConstant = (PoolConstant)this.aAtoms.elementAt(n);
            if (poolConstant != null) {
                poolConstant.write(dataOutput);
            } else {
                n = (short)(n + 1);
            }
            n = (short)(n + 1);
        }
    }

    public String toString(short s) {
        PoolConstant poolConstant = (PoolConstant)this.aAtoms.elementAt(s);
        if (null != poolConstant) {
            switch (poolConstant.iTag) {
                case 7: 
                case 8: {
                    return this.toString(poolConstant.s);
                }
                case 1: {
                    return poolConstant.aUTF;
                }
            }
        }
        return String.valueOf(s);
    }

    public String toString() {
        short s = this.size();
        String string = "Constant Pool: " + s + "\n";
        string = string + "\t0: VM entry\n";
        short s2 = 1;
        while (s2 < s) {
            PoolConstant poolConstant = (PoolConstant)this.aAtoms.elementAt(s2);
            if (poolConstant != null) {
                string = string + "\t" + s2 + ": ";
                switch (poolConstant.iTag) {
                    case 7: {
                        string = string + "Class: " + this.toString(poolConstant.s);
                        break;
                    }
                    case 9: {
                        string = string + "Fieldref: Class=" + this.toString(poolConstant.s) + " NameType=" + this.toString(poolConstant.s1);
                        break;
                    }
                    case 10: {
                        string = string + "Methodref: Class=" + this.toString(poolConstant.s) + " NameType=" + this.toString(poolConstant.s1);
                        break;
                    }
                    case 11: {
                        string = string + "InterfaceMethodref: Class=" + this.toString(poolConstant.s) + " NameType=" + this.toString(poolConstant.s1);
                        break;
                    }
                    case 8: {
                        string = string + "String: " + this.toString(poolConstant.s);
                        break;
                    }
                    case 3: {
                        string = string + "Integer: " + poolConstant.i;
                        break;
                    }
                    case 4: {
                        string = string + "Float: " + poolConstant.f;
                        break;
                    }
                    case 5: {
                        string = string + "Long: " + poolConstant.l;
                        break;
                    }
                    case 6: {
                        string = string + "Double: " + poolConstant.d;
                        break;
                    }
                    case 12: {
                        string = string + "NameAndType: " + this.toString(poolConstant.s) + ", " + this.toString(poolConstant.s1);
                        break;
                    }
                    case 1: {
                        string = string + "Utf8: " + poolConstant.aUTF;
                        break;
                    }
                    default: {
                        System.out.println("error: Tag = " + poolConstant.iTag);
                    }
                }
                string = string + "\n";
            }
            s2 = (short)(s2 + 1);
        }
        return string;
    }
}

