;; uninstall.scm - Run `make uninstall' and interpret output.
;; Written by Tom Tromey <tromey@cygnus.com>

(use-modules (ice-9 expect) (ice-9 regex))

(define (uninstall-subpackage package)
  (let* ((echo "echo")
	 (magic "-=-=-=-= ")

	 (normal "NORMAL")
	 (pre "PRE")
	 (post "POST")

	 (destdir (local-directory (get-name package)))

	 (scan-mode normal)

	 (expect-port
	  (open-input-pipe (string-append
			    "make"	; FIXME: configure?
			    " "
			    "NORMAL_UNINSTALL='" echo magic normal "' "
			    "PRE_UNINSTALL='" echo magic pre "' "
			    "POST_UNINSTALL='" echo magic post "' "
			    "DESTDIR='" destdir "' "
			    "uninstall 2>&1"))))

    (while (char-ready? expect-port)
	   (expect-strings
	    ;; Recognize a mode change.
	    ((string-append "^" (regexp-quote magic)
			    "(" normal "|" pre "|" post ")\n")
	     => (lambda (all mode)
		  (set! scan-mode mode)))

	    ;; Ignore some stuff.
	    ("^(Making|make[^:]*:) .*\n" => (lambda args #f))

	    ;; Disposition of other lines depends on mode.
	    ("^[ \t]*(.*)[ \t]*\n"
	     => (lambda (all command)
		  (cond
		   ((equal? scan-mode "NORMAL")
		    ;; Just ignore all "normal" commands.
		    ;; FIXME?
		    )

		   ((equal? scan-mode "PRE")
		    (add-pre-uninstall-command command))

		   ((equal? scan-mode "POST")
		    (add-post-uninstall-command command))

		   (#t
		    (error "Unrecognized scan mode!")))))))

    ;; FIXME: handle return value.
    (close-pipe expect-port)))
