/* CPU data header for or1k.

THIS FILE IS MACHINE GENERATED WITH CGEN.

Copyright (C) 1996-2014 Free Software Foundation, Inc.

This file is part of the GNU Binutils and/or GDB, the GNU debugger.

   This file is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   It is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
   or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
   License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   51 Franklin Street - Fifth Floor, Boston, MA 02110-1301, USA.

*/

#ifndef OR1K_CPU_H
#define OR1K_CPU_H

#define CGEN_ARCH or1k

/* Given symbol S, return or1k_cgen_<S>.  */
#define CGEN_SYM(s) or1k##_cgen_##s


/* Selected cpu families.  */
#define HAVE_CPU_OR1K32BF
#define HAVE_CPU_OR1K64BF

#define CGEN_INSN_LSB0_P 1

/* Minimum size of any insn (in bytes).  */
#define CGEN_MIN_INSN_SIZE 4

/* Maximum size of any insn (in bytes).  */
#define CGEN_MAX_INSN_SIZE 4

#define CGEN_INT_INSN_P 1

/* Maximum number of syntax elements in an instruction.  */
#define CGEN_ACTUAL_MAX_SYNTAX_ELEMENTS 17

/* CGEN_MNEMONIC_OPERANDS is defined if mnemonics have operands.
   e.g. In "b,a foo" the ",a" is an operand.  If mnemonics have operands
   we can't hash on everything up to the space.  */
#define CGEN_MNEMONIC_OPERANDS

/* Maximum number of fields in an instruction.  */
#define CGEN_ACTUAL_MAX_IFMT_OPERANDS 8

/* Enums.  */

/* Enum declaration for Exception numbers.  */
typedef enum except_number {
  EXCEPT_NONE, EXCEPT_RESET, EXCEPT_BUSERR, EXCEPT_DPF
 , EXCEPT_IPF, EXCEPT_TICK, EXCEPT_ALIGN, EXCEPT_ILLEGAL
 , EXCEPT_INT, EXCEPT_DTLBMISS, EXCEPT_ITLBMISS, EXCEPT_RANGE
 , EXCEPT_SYSCALL, EXCEPT_FPE, EXCEPT_TRAP
} EXCEPT_NUMBER;

/* Enum declaration for special purpose register groups.  */
typedef enum spr_groups {
  SPR_GROUP_SYS, SPR_GROUP_DMMU, SPR_GROUP_IMMU, SPR_GROUP_DCACHE
 , SPR_GROUP_ICACHE, SPR_GROUP_MAC, SPR_GROUP_DEBUG, SPR_GROUP_PERF
 , SPR_GROUP_POWER, SPR_GROUP_PIC, SPR_GROUP_TICK, SPR_GROUP_FPU
} SPR_GROUPS;

/* Enum declaration for special purpose register indicies.  */
typedef enum spr_reg_indices {
  SPR_INDEX_SYS_VR = 0, SPR_INDEX_SYS_UPR = 1, SPR_INDEX_SYS_CPUCFGR = 2, SPR_INDEX_SYS_DMMUCFGR = 3
 , SPR_INDEX_SYS_IMMUCFGR = 4, SPR_INDEX_SYS_DCCFGR = 5, SPR_INDEX_SYS_ICCFGR = 6, SPR_INDEX_SYS_DCFGR = 7
 , SPR_INDEX_SYS_PCCFGR = 8, SPR_INDEX_SYS_NPC = 16, SPR_INDEX_SYS_SR = 17, SPR_INDEX_SYS_PPC = 18
 , SPR_INDEX_SYS_FPCSR = 20, SPR_INDEX_SYS_EPCR0 = 32, SPR_INDEX_SYS_EPCR1 = 33, SPR_INDEX_SYS_EPCR2 = 34
 , SPR_INDEX_SYS_EPCR3 = 35, SPR_INDEX_SYS_EPCR4 = 36, SPR_INDEX_SYS_EPCR5 = 37, SPR_INDEX_SYS_EPCR6 = 38
 , SPR_INDEX_SYS_EPCR7 = 39, SPR_INDEX_SYS_EPCR8 = 40, SPR_INDEX_SYS_EPCR9 = 41, SPR_INDEX_SYS_EPCR10 = 42
 , SPR_INDEX_SYS_EPCR11 = 43, SPR_INDEX_SYS_EPCR12 = 44, SPR_INDEX_SYS_EPCR13 = 45, SPR_INDEX_SYS_EPCR14 = 46
 , SPR_INDEX_SYS_EPCR15 = 47, SPR_INDEX_SYS_EEAR0 = 48, SPR_INDEX_SYS_EEAR1 = 49, SPR_INDEX_SYS_EEAR2 = 50
 , SPR_INDEX_SYS_EEAR3 = 51, SPR_INDEX_SYS_EEAR4 = 52, SPR_INDEX_SYS_EEAR5 = 53, SPR_INDEX_SYS_EEAR6 = 54
 , SPR_INDEX_SYS_EEAR7 = 55, SPR_INDEX_SYS_EEAR8 = 56, SPR_INDEX_SYS_EEAR9 = 57, SPR_INDEX_SYS_EEAR10 = 58
 , SPR_INDEX_SYS_EEAR11 = 59, SPR_INDEX_SYS_EEAR12 = 60, SPR_INDEX_SYS_EEAR13 = 61, SPR_INDEX_SYS_EEAR14 = 62
 , SPR_INDEX_SYS_EEAR15 = 63, SPR_INDEX_SYS_ESR0 = 64, SPR_INDEX_SYS_ESR1 = 65, SPR_INDEX_SYS_ESR2 = 66
 , SPR_INDEX_SYS_ESR3 = 67, SPR_INDEX_SYS_ESR4 = 68, SPR_INDEX_SYS_ESR5 = 69, SPR_INDEX_SYS_ESR6 = 70
 , SPR_INDEX_SYS_ESR7 = 71, SPR_INDEX_SYS_ESR8 = 72, SPR_INDEX_SYS_ESR9 = 73, SPR_INDEX_SYS_ESR10 = 74
 , SPR_INDEX_SYS_ESR11 = 75, SPR_INDEX_SYS_ESR12 = 76, SPR_INDEX_SYS_ESR13 = 77, SPR_INDEX_SYS_ESR14 = 78
 , SPR_INDEX_SYS_ESR15 = 79, SPR_INDEX_SYS_GPR0 = 1024, SPR_INDEX_SYS_GPR1 = 1025, SPR_INDEX_SYS_GPR2 = 1026
 , SPR_INDEX_SYS_GPR3 = 1027, SPR_INDEX_SYS_GPR4 = 1028, SPR_INDEX_SYS_GPR5 = 1029, SPR_INDEX_SYS_GPR6 = 1030
 , SPR_INDEX_SYS_GPR7 = 1031, SPR_INDEX_SYS_GPR8 = 1032, SPR_INDEX_SYS_GPR9 = 1033, SPR_INDEX_SYS_GPR10 = 1034
 , SPR_INDEX_SYS_GPR11 = 1035, SPR_INDEX_SYS_GPR12 = 1036, SPR_INDEX_SYS_GPR13 = 1037, SPR_INDEX_SYS_GPR14 = 1038
 , SPR_INDEX_SYS_GPR15 = 1039, SPR_INDEX_SYS_GPR16 = 1040, SPR_INDEX_SYS_GPR17 = 1041, SPR_INDEX_SYS_GPR18 = 1042
 , SPR_INDEX_SYS_GPR19 = 1043, SPR_INDEX_SYS_GPR20 = 1044, SPR_INDEX_SYS_GPR21 = 1045, SPR_INDEX_SYS_GPR22 = 1046
 , SPR_INDEX_SYS_GPR23 = 1047, SPR_INDEX_SYS_GPR24 = 1048, SPR_INDEX_SYS_GPR25 = 1049, SPR_INDEX_SYS_GPR26 = 1050
 , SPR_INDEX_SYS_GPR27 = 1051, SPR_INDEX_SYS_GPR28 = 1052, SPR_INDEX_SYS_GPR29 = 1053, SPR_INDEX_SYS_GPR30 = 1054
 , SPR_INDEX_SYS_GPR31 = 1055, SPR_INDEX_SYS_GPR32 = 1056, SPR_INDEX_SYS_GPR33 = 1057, SPR_INDEX_SYS_GPR34 = 1058
 , SPR_INDEX_SYS_GPR35 = 1059, SPR_INDEX_SYS_GPR36 = 1060, SPR_INDEX_SYS_GPR37 = 1061, SPR_INDEX_SYS_GPR38 = 1062
 , SPR_INDEX_SYS_GPR39 = 1063, SPR_INDEX_SYS_GPR40 = 1064, SPR_INDEX_SYS_GPR41 = 1065, SPR_INDEX_SYS_GPR42 = 1066
 , SPR_INDEX_SYS_GPR43 = 1067, SPR_INDEX_SYS_GPR44 = 1068, SPR_INDEX_SYS_GPR45 = 1069, SPR_INDEX_SYS_GPR46 = 1070
 , SPR_INDEX_SYS_GPR47 = 1071, SPR_INDEX_SYS_GPR48 = 1072, SPR_INDEX_SYS_GPR49 = 1073, SPR_INDEX_SYS_GPR50 = 1074
 , SPR_INDEX_SYS_GPR51 = 1075, SPR_INDEX_SYS_GPR52 = 1076, SPR_INDEX_SYS_GPR53 = 1077, SPR_INDEX_SYS_GPR54 = 1078
 , SPR_INDEX_SYS_GPR55 = 1079, SPR_INDEX_SYS_GPR56 = 1080, SPR_INDEX_SYS_GPR57 = 1081, SPR_INDEX_SYS_GPR58 = 1082
 , SPR_INDEX_SYS_GPR59 = 1083, SPR_INDEX_SYS_GPR60 = 1084, SPR_INDEX_SYS_GPR61 = 1085, SPR_INDEX_SYS_GPR62 = 1086
 , SPR_INDEX_SYS_GPR63 = 1087, SPR_INDEX_SYS_GPR64 = 1088, SPR_INDEX_SYS_GPR65 = 1089, SPR_INDEX_SYS_GPR66 = 1090
 , SPR_INDEX_SYS_GPR67 = 1091, SPR_INDEX_SYS_GPR68 = 1092, SPR_INDEX_SYS_GPR69 = 1093, SPR_INDEX_SYS_GPR70 = 1094
 , SPR_INDEX_SYS_GPR71 = 1095, SPR_INDEX_SYS_GPR72 = 1096, SPR_INDEX_SYS_GPR73 = 1097, SPR_INDEX_SYS_GPR74 = 1098
 , SPR_INDEX_SYS_GPR75 = 1099, SPR_INDEX_SYS_GPR76 = 1100, SPR_INDEX_SYS_GPR77 = 1101, SPR_INDEX_SYS_GPR78 = 1102
 , SPR_INDEX_SYS_GPR79 = 1103, SPR_INDEX_SYS_GPR80 = 1104, SPR_INDEX_SYS_GPR81 = 1105, SPR_INDEX_SYS_GPR82 = 1106
 , SPR_INDEX_SYS_GPR83 = 1107, SPR_INDEX_SYS_GPR84 = 1108, SPR_INDEX_SYS_GPR85 = 1109, SPR_INDEX_SYS_GPR86 = 1110
 , SPR_INDEX_SYS_GPR87 = 1111, SPR_INDEX_SYS_GPR88 = 1112, SPR_INDEX_SYS_GPR89 = 1113, SPR_INDEX_SYS_GPR90 = 1114
 , SPR_INDEX_SYS_GPR91 = 1115, SPR_INDEX_SYS_GPR92 = 1116, SPR_INDEX_SYS_GPR93 = 1117, SPR_INDEX_SYS_GPR94 = 1118
 , SPR_INDEX_SYS_GPR95 = 1119, SPR_INDEX_SYS_GPR96 = 1120, SPR_INDEX_SYS_GPR97 = 1121, SPR_INDEX_SYS_GPR98 = 1122
 , SPR_INDEX_SYS_GPR99 = 1123, SPR_INDEX_SYS_GPR100 = 1124, SPR_INDEX_SYS_GPR101 = 1125, SPR_INDEX_SYS_GPR102 = 1126
 , SPR_INDEX_SYS_GPR103 = 1127, SPR_INDEX_SYS_GPR104 = 1128, SPR_INDEX_SYS_GPR105 = 1129, SPR_INDEX_SYS_GPR106 = 1130
 , SPR_INDEX_SYS_GPR107 = 1131, SPR_INDEX_SYS_GPR108 = 1132, SPR_INDEX_SYS_GPR109 = 1133, SPR_INDEX_SYS_GPR110 = 1134
 , SPR_INDEX_SYS_GPR111 = 1135, SPR_INDEX_SYS_GPR112 = 1136, SPR_INDEX_SYS_GPR113 = 1137, SPR_INDEX_SYS_GPR114 = 1138
 , SPR_INDEX_SYS_GPR115 = 1139, SPR_INDEX_SYS_GPR116 = 1140, SPR_INDEX_SYS_GPR117 = 1141, SPR_INDEX_SYS_GPR118 = 1142
 , SPR_INDEX_SYS_GPR119 = 1143, SPR_INDEX_SYS_GPR120 = 1144, SPR_INDEX_SYS_GPR121 = 1145, SPR_INDEX_SYS_GPR122 = 1146
 , SPR_INDEX_SYS_GPR123 = 1147, SPR_INDEX_SYS_GPR124 = 1148, SPR_INDEX_SYS_GPR125 = 1149, SPR_INDEX_SYS_GPR126 = 1150
 , SPR_INDEX_SYS_GPR127 = 1151, SPR_INDEX_SYS_GPR128 = 1152, SPR_INDEX_SYS_GPR129 = 1153, SPR_INDEX_SYS_GPR130 = 1154
 , SPR_INDEX_SYS_GPR131 = 1155, SPR_INDEX_SYS_GPR132 = 1156, SPR_INDEX_SYS_GPR133 = 1157, SPR_INDEX_SYS_GPR134 = 1158
 , SPR_INDEX_SYS_GPR135 = 1159, SPR_INDEX_SYS_GPR136 = 1160, SPR_INDEX_SYS_GPR137 = 1161, SPR_INDEX_SYS_GPR138 = 1162
 , SPR_INDEX_SYS_GPR139 = 1163, SPR_INDEX_SYS_GPR140 = 1164, SPR_INDEX_SYS_GPR141 = 1165, SPR_INDEX_SYS_GPR142 = 1166
 , SPR_INDEX_SYS_GPR143 = 1167, SPR_INDEX_SYS_GPR144 = 1168, SPR_INDEX_SYS_GPR145 = 1169, SPR_INDEX_SYS_GPR146 = 1170
 , SPR_INDEX_SYS_GPR147 = 1171, SPR_INDEX_SYS_GPR148 = 1172, SPR_INDEX_SYS_GPR149 = 1173, SPR_INDEX_SYS_GPR150 = 1174
 , SPR_INDEX_SYS_GPR151 = 1175, SPR_INDEX_SYS_GPR152 = 1176, SPR_INDEX_SYS_GPR153 = 1177, SPR_INDEX_SYS_GPR154 = 1178
 , SPR_INDEX_SYS_GPR155 = 1179, SPR_INDEX_SYS_GPR156 = 1180, SPR_INDEX_SYS_GPR157 = 1181, SPR_INDEX_SYS_GPR158 = 1182
 , SPR_INDEX_SYS_GPR159 = 1183, SPR_INDEX_SYS_GPR160 = 1184, SPR_INDEX_SYS_GPR161 = 1185, SPR_INDEX_SYS_GPR162 = 1186
 , SPR_INDEX_SYS_GPR163 = 1187, SPR_INDEX_SYS_GPR164 = 1188, SPR_INDEX_SYS_GPR165 = 1189, SPR_INDEX_SYS_GPR166 = 1190
 , SPR_INDEX_SYS_GPR167 = 1191, SPR_INDEX_SYS_GPR168 = 1192, SPR_INDEX_SYS_GPR169 = 1193, SPR_INDEX_SYS_GPR170 = 1194
 , SPR_INDEX_SYS_GPR171 = 1195, SPR_INDEX_SYS_GPR172 = 1196, SPR_INDEX_SYS_GPR173 = 1197, SPR_INDEX_SYS_GPR174 = 1198
 , SPR_INDEX_SYS_GPR175 = 1199, SPR_INDEX_SYS_GPR176 = 1200, SPR_INDEX_SYS_GPR177 = 1201, SPR_INDEX_SYS_GPR178 = 1202
 , SPR_INDEX_SYS_GPR179 = 1203, SPR_INDEX_SYS_GPR180 = 1204, SPR_INDEX_SYS_GPR181 = 1205, SPR_INDEX_SYS_GPR182 = 1206
 , SPR_INDEX_SYS_GPR183 = 1207, SPR_INDEX_SYS_GPR184 = 1208, SPR_INDEX_SYS_GPR185 = 1209, SPR_INDEX_SYS_GPR186 = 1210
 , SPR_INDEX_SYS_GPR187 = 1211, SPR_INDEX_SYS_GPR188 = 1212, SPR_INDEX_SYS_GPR189 = 1213, SPR_INDEX_SYS_GPR190 = 1214
 , SPR_INDEX_SYS_GPR191 = 1215, SPR_INDEX_SYS_GPR192 = 1216, SPR_INDEX_SYS_GPR193 = 1217, SPR_INDEX_SYS_GPR194 = 1218
 , SPR_INDEX_SYS_GPR195 = 1219, SPR_INDEX_SYS_GPR196 = 1220, SPR_INDEX_SYS_GPR197 = 1221, SPR_INDEX_SYS_GPR198 = 1222
 , SPR_INDEX_SYS_GPR199 = 1223, SPR_INDEX_SYS_GPR200 = 1224, SPR_INDEX_SYS_GPR201 = 1225, SPR_INDEX_SYS_GPR202 = 1226
 , SPR_INDEX_SYS_GPR203 = 1227, SPR_INDEX_SYS_GPR204 = 1228, SPR_INDEX_SYS_GPR205 = 1229, SPR_INDEX_SYS_GPR206 = 1230
 , SPR_INDEX_SYS_GPR207 = 1231, SPR_INDEX_SYS_GPR208 = 1232, SPR_INDEX_SYS_GPR209 = 1233, SPR_INDEX_SYS_GPR210 = 1234
 , SPR_INDEX_SYS_GPR211 = 1235, SPR_INDEX_SYS_GPR212 = 1236, SPR_INDEX_SYS_GPR213 = 1237, SPR_INDEX_SYS_GPR214 = 1238
 , SPR_INDEX_SYS_GPR215 = 1239, SPR_INDEX_SYS_GPR216 = 1240, SPR_INDEX_SYS_GPR217 = 1241, SPR_INDEX_SYS_GPR218 = 1242
 , SPR_INDEX_SYS_GPR219 = 1243, SPR_INDEX_SYS_GPR220 = 1244, SPR_INDEX_SYS_GPR221 = 1245, SPR_INDEX_SYS_GPR222 = 1246
 , SPR_INDEX_SYS_GPR223 = 1247, SPR_INDEX_SYS_GPR224 = 1248, SPR_INDEX_SYS_GPR225 = 1249, SPR_INDEX_SYS_GPR226 = 1250
 , SPR_INDEX_SYS_GPR227 = 1251, SPR_INDEX_SYS_GPR228 = 1252, SPR_INDEX_SYS_GPR229 = 1253, SPR_INDEX_SYS_GPR230 = 1254
 , SPR_INDEX_SYS_GPR231 = 1255, SPR_INDEX_SYS_GPR232 = 1256, SPR_INDEX_SYS_GPR233 = 1257, SPR_INDEX_SYS_GPR234 = 1258
 , SPR_INDEX_SYS_GPR235 = 1259, SPR_INDEX_SYS_GPR236 = 1260, SPR_INDEX_SYS_GPR237 = 1261, SPR_INDEX_SYS_GPR238 = 1262
 , SPR_INDEX_SYS_GPR239 = 1263, SPR_INDEX_SYS_GPR240 = 1264, SPR_INDEX_SYS_GPR241 = 1265, SPR_INDEX_SYS_GPR242 = 1266
 , SPR_INDEX_SYS_GPR243 = 1267, SPR_INDEX_SYS_GPR244 = 1268, SPR_INDEX_SYS_GPR245 = 1269, SPR_INDEX_SYS_GPR246 = 1270
 , SPR_INDEX_SYS_GPR247 = 1271, SPR_INDEX_SYS_GPR248 = 1272, SPR_INDEX_SYS_GPR249 = 1273, SPR_INDEX_SYS_GPR250 = 1274
 , SPR_INDEX_SYS_GPR251 = 1275, SPR_INDEX_SYS_GPR252 = 1276, SPR_INDEX_SYS_GPR253 = 1277, SPR_INDEX_SYS_GPR254 = 1278
 , SPR_INDEX_SYS_GPR255 = 1279, SPR_INDEX_SYS_GPR256 = 1280, SPR_INDEX_SYS_GPR257 = 1281, SPR_INDEX_SYS_GPR258 = 1282
 , SPR_INDEX_SYS_GPR259 = 1283, SPR_INDEX_SYS_GPR260 = 1284, SPR_INDEX_SYS_GPR261 = 1285, SPR_INDEX_SYS_GPR262 = 1286
 , SPR_INDEX_SYS_GPR263 = 1287, SPR_INDEX_SYS_GPR264 = 1288, SPR_INDEX_SYS_GPR265 = 1289, SPR_INDEX_SYS_GPR266 = 1290
 , SPR_INDEX_SYS_GPR267 = 1291, SPR_INDEX_SYS_GPR268 = 1292, SPR_INDEX_SYS_GPR269 = 1293, SPR_INDEX_SYS_GPR270 = 1294
 , SPR_INDEX_SYS_GPR271 = 1295, SPR_INDEX_SYS_GPR272 = 1296, SPR_INDEX_SYS_GPR273 = 1297, SPR_INDEX_SYS_GPR274 = 1298
 , SPR_INDEX_SYS_GPR275 = 1299, SPR_INDEX_SYS_GPR276 = 1300, SPR_INDEX_SYS_GPR277 = 1301, SPR_INDEX_SYS_GPR278 = 1302
 , SPR_INDEX_SYS_GPR279 = 1303, SPR_INDEX_SYS_GPR280 = 1304, SPR_INDEX_SYS_GPR281 = 1305, SPR_INDEX_SYS_GPR282 = 1306
 , SPR_INDEX_SYS_GPR283 = 1307, SPR_INDEX_SYS_GPR284 = 1308, SPR_INDEX_SYS_GPR285 = 1309, SPR_INDEX_SYS_GPR286 = 1310
 , SPR_INDEX_SYS_GPR287 = 1311, SPR_INDEX_SYS_GPR288 = 1312, SPR_INDEX_SYS_GPR289 = 1313, SPR_INDEX_SYS_GPR290 = 1314
 , SPR_INDEX_SYS_GPR291 = 1315, SPR_INDEX_SYS_GPR292 = 1316, SPR_INDEX_SYS_GPR293 = 1317, SPR_INDEX_SYS_GPR294 = 1318
 , SPR_INDEX_SYS_GPR295 = 1319, SPR_INDEX_SYS_GPR296 = 1320, SPR_INDEX_SYS_GPR297 = 1321, SPR_INDEX_SYS_GPR298 = 1322
 , SPR_INDEX_SYS_GPR299 = 1323, SPR_INDEX_SYS_GPR300 = 1324, SPR_INDEX_SYS_GPR301 = 1325, SPR_INDEX_SYS_GPR302 = 1326
 , SPR_INDEX_SYS_GPR303 = 1327, SPR_INDEX_SYS_GPR304 = 1328, SPR_INDEX_SYS_GPR305 = 1329, SPR_INDEX_SYS_GPR306 = 1330
 , SPR_INDEX_SYS_GPR307 = 1331, SPR_INDEX_SYS_GPR308 = 1332, SPR_INDEX_SYS_GPR309 = 1333, SPR_INDEX_SYS_GPR310 = 1334
 , SPR_INDEX_SYS_GPR311 = 1335, SPR_INDEX_SYS_GPR312 = 1336, SPR_INDEX_SYS_GPR313 = 1337, SPR_INDEX_SYS_GPR314 = 1338
 , SPR_INDEX_SYS_GPR315 = 1339, SPR_INDEX_SYS_GPR316 = 1340, SPR_INDEX_SYS_GPR317 = 1341, SPR_INDEX_SYS_GPR318 = 1342
 , SPR_INDEX_SYS_GPR319 = 1343, SPR_INDEX_SYS_GPR320 = 1344, SPR_INDEX_SYS_GPR321 = 1345, SPR_INDEX_SYS_GPR322 = 1346
 , SPR_INDEX_SYS_GPR323 = 1347, SPR_INDEX_SYS_GPR324 = 1348, SPR_INDEX_SYS_GPR325 = 1349, SPR_INDEX_SYS_GPR326 = 1350
 , SPR_INDEX_SYS_GPR327 = 1351, SPR_INDEX_SYS_GPR328 = 1352, SPR_INDEX_SYS_GPR329 = 1353, SPR_INDEX_SYS_GPR330 = 1354
 , SPR_INDEX_SYS_GPR331 = 1355, SPR_INDEX_SYS_GPR332 = 1356, SPR_INDEX_SYS_GPR333 = 1357, SPR_INDEX_SYS_GPR334 = 1358
 , SPR_INDEX_SYS_GPR335 = 1359, SPR_INDEX_SYS_GPR336 = 1360, SPR_INDEX_SYS_GPR337 = 1361, SPR_INDEX_SYS_GPR338 = 1362
 , SPR_INDEX_SYS_GPR339 = 1363, SPR_INDEX_SYS_GPR340 = 1364, SPR_INDEX_SYS_GPR341 = 1365, SPR_INDEX_SYS_GPR342 = 1366
 , SPR_INDEX_SYS_GPR343 = 1367, SPR_INDEX_SYS_GPR344 = 1368, SPR_INDEX_SYS_GPR345 = 1369, SPR_INDEX_SYS_GPR346 = 1370
 , SPR_INDEX_SYS_GPR347 = 1371, SPR_INDEX_SYS_GPR348 = 1372, SPR_INDEX_SYS_GPR349 = 1373, SPR_INDEX_SYS_GPR350 = 1374
 , SPR_INDEX_SYS_GPR351 = 1375, SPR_INDEX_SYS_GPR352 = 1376, SPR_INDEX_SYS_GPR353 = 1377, SPR_INDEX_SYS_GPR354 = 1378
 , SPR_INDEX_SYS_GPR355 = 1379, SPR_INDEX_SYS_GPR356 = 1380, SPR_INDEX_SYS_GPR357 = 1381, SPR_INDEX_SYS_GPR358 = 1382
 , SPR_INDEX_SYS_GPR359 = 1383, SPR_INDEX_SYS_GPR360 = 1384, SPR_INDEX_SYS_GPR361 = 1385, SPR_INDEX_SYS_GPR362 = 1386
 , SPR_INDEX_SYS_GPR363 = 1387, SPR_INDEX_SYS_GPR364 = 1388, SPR_INDEX_SYS_GPR365 = 1389, SPR_INDEX_SYS_GPR366 = 1390
 , SPR_INDEX_SYS_GPR367 = 1391, SPR_INDEX_SYS_GPR368 = 1392, SPR_INDEX_SYS_GPR369 = 1393, SPR_INDEX_SYS_GPR370 = 1394
 , SPR_INDEX_SYS_GPR371 = 1395, SPR_INDEX_SYS_GPR372 = 1396, SPR_INDEX_SYS_GPR373 = 1397, SPR_INDEX_SYS_GPR374 = 1398
 , SPR_INDEX_SYS_GPR375 = 1399, SPR_INDEX_SYS_GPR376 = 1400, SPR_INDEX_SYS_GPR377 = 1401, SPR_INDEX_SYS_GPR378 = 1402
 , SPR_INDEX_SYS_GPR379 = 1403, SPR_INDEX_SYS_GPR380 = 1404, SPR_INDEX_SYS_GPR381 = 1405, SPR_INDEX_SYS_GPR382 = 1406
 , SPR_INDEX_SYS_GPR383 = 1407, SPR_INDEX_SYS_GPR384 = 1408, SPR_INDEX_SYS_GPR385 = 1409, SPR_INDEX_SYS_GPR386 = 1410
 , SPR_INDEX_SYS_GPR387 = 1411, SPR_INDEX_SYS_GPR388 = 1412, SPR_INDEX_SYS_GPR389 = 1413, SPR_INDEX_SYS_GPR390 = 1414
 , SPR_INDEX_SYS_GPR391 = 1415, SPR_INDEX_SYS_GPR392 = 1416, SPR_INDEX_SYS_GPR393 = 1417, SPR_INDEX_SYS_GPR394 = 1418
 , SPR_INDEX_SYS_GPR395 = 1419, SPR_INDEX_SYS_GPR396 = 1420, SPR_INDEX_SYS_GPR397 = 1421, SPR_INDEX_SYS_GPR398 = 1422
 , SPR_INDEX_SYS_GPR399 = 1423, SPR_INDEX_SYS_GPR400 = 1424, SPR_INDEX_SYS_GPR401 = 1425, SPR_INDEX_SYS_GPR402 = 1426
 , SPR_INDEX_SYS_GPR403 = 1427, SPR_INDEX_SYS_GPR404 = 1428, SPR_INDEX_SYS_GPR405 = 1429, SPR_INDEX_SYS_GPR406 = 1430
 , SPR_INDEX_SYS_GPR407 = 1431, SPR_INDEX_SYS_GPR408 = 1432, SPR_INDEX_SYS_GPR409 = 1433, SPR_INDEX_SYS_GPR410 = 1434
 , SPR_INDEX_SYS_GPR411 = 1435, SPR_INDEX_SYS_GPR412 = 1436, SPR_INDEX_SYS_GPR413 = 1437, SPR_INDEX_SYS_GPR414 = 1438
 , SPR_INDEX_SYS_GPR415 = 1439, SPR_INDEX_SYS_GPR416 = 1440, SPR_INDEX_SYS_GPR417 = 1441, SPR_INDEX_SYS_GPR418 = 1442
 , SPR_INDEX_SYS_GPR419 = 1443, SPR_INDEX_SYS_GPR420 = 1444, SPR_INDEX_SYS_GPR421 = 1445, SPR_INDEX_SYS_GPR422 = 1446
 , SPR_INDEX_SYS_GPR423 = 1447, SPR_INDEX_SYS_GPR424 = 1448, SPR_INDEX_SYS_GPR425 = 1449, SPR_INDEX_SYS_GPR426 = 1450
 , SPR_INDEX_SYS_GPR427 = 1451, SPR_INDEX_SYS_GPR428 = 1452, SPR_INDEX_SYS_GPR429 = 1453, SPR_INDEX_SYS_GPR430 = 1454
 , SPR_INDEX_SYS_GPR431 = 1455, SPR_INDEX_SYS_GPR432 = 1456, SPR_INDEX_SYS_GPR433 = 1457, SPR_INDEX_SYS_GPR434 = 1458
 , SPR_INDEX_SYS_GPR435 = 1459, SPR_INDEX_SYS_GPR436 = 1460, SPR_INDEX_SYS_GPR437 = 1461, SPR_INDEX_SYS_GPR438 = 1462
 , SPR_INDEX_SYS_GPR439 = 1463, SPR_INDEX_SYS_GPR440 = 1464, SPR_INDEX_SYS_GPR441 = 1465, SPR_INDEX_SYS_GPR442 = 1466
 , SPR_INDEX_SYS_GPR443 = 1467, SPR_INDEX_SYS_GPR444 = 1468, SPR_INDEX_SYS_GPR445 = 1469, SPR_INDEX_SYS_GPR446 = 1470
 , SPR_INDEX_SYS_GPR447 = 1471, SPR_INDEX_SYS_GPR448 = 1472, SPR_INDEX_SYS_GPR449 = 1473, SPR_INDEX_SYS_GPR450 = 1474
 , SPR_INDEX_SYS_GPR451 = 1475, SPR_INDEX_SYS_GPR452 = 1476, SPR_INDEX_SYS_GPR453 = 1477, SPR_INDEX_SYS_GPR454 = 1478
 , SPR_INDEX_SYS_GPR455 = 1479, SPR_INDEX_SYS_GPR456 = 1480, SPR_INDEX_SYS_GPR457 = 1481, SPR_INDEX_SYS_GPR458 = 1482
 , SPR_INDEX_SYS_GPR459 = 1483, SPR_INDEX_SYS_GPR460 = 1484, SPR_INDEX_SYS_GPR461 = 1485, SPR_INDEX_SYS_GPR462 = 1486
 , SPR_INDEX_SYS_GPR463 = 1487, SPR_INDEX_SYS_GPR464 = 1488, SPR_INDEX_SYS_GPR465 = 1489, SPR_INDEX_SYS_GPR466 = 1490
 , SPR_INDEX_SYS_GPR467 = 1491, SPR_INDEX_SYS_GPR468 = 1492, SPR_INDEX_SYS_GPR469 = 1493, SPR_INDEX_SYS_GPR470 = 1494
 , SPR_INDEX_SYS_GPR471 = 1495, SPR_INDEX_SYS_GPR472 = 1496, SPR_INDEX_SYS_GPR473 = 1497, SPR_INDEX_SYS_GPR474 = 1498
 , SPR_INDEX_SYS_GPR475 = 1499, SPR_INDEX_SYS_GPR476 = 1500, SPR_INDEX_SYS_GPR477 = 1501, SPR_INDEX_SYS_GPR478 = 1502
 , SPR_INDEX_SYS_GPR479 = 1503, SPR_INDEX_SYS_GPR480 = 1504, SPR_INDEX_SYS_GPR481 = 1505, SPR_INDEX_SYS_GPR482 = 1506
 , SPR_INDEX_SYS_GPR483 = 1507, SPR_INDEX_SYS_GPR484 = 1508, SPR_INDEX_SYS_GPR485 = 1509, SPR_INDEX_SYS_GPR486 = 1510
 , SPR_INDEX_SYS_GPR487 = 1511, SPR_INDEX_SYS_GPR488 = 1512, SPR_INDEX_SYS_GPR489 = 1513, SPR_INDEX_SYS_GPR490 = 1514
 , SPR_INDEX_SYS_GPR491 = 1515, SPR_INDEX_SYS_GPR492 = 1516, SPR_INDEX_SYS_GPR493 = 1517, SPR_INDEX_SYS_GPR494 = 1518
 , SPR_INDEX_SYS_GPR495 = 1519, SPR_INDEX_SYS_GPR496 = 1520, SPR_INDEX_SYS_GPR497 = 1521, SPR_INDEX_SYS_GPR498 = 1522
 , SPR_INDEX_SYS_GPR499 = 1523, SPR_INDEX_SYS_GPR500 = 1524, SPR_INDEX_SYS_GPR501 = 1525, SPR_INDEX_SYS_GPR502 = 1526
 , SPR_INDEX_SYS_GPR503 = 1527, SPR_INDEX_SYS_GPR504 = 1528, SPR_INDEX_SYS_GPR505 = 1529, SPR_INDEX_SYS_GPR506 = 1530
 , SPR_INDEX_SYS_GPR507 = 1531, SPR_INDEX_SYS_GPR508 = 1532, SPR_INDEX_SYS_GPR509 = 1533, SPR_INDEX_SYS_GPR510 = 1534
 , SPR_INDEX_SYS_GPR511 = 1535, SPR_INDEX_MAC_MACLO = 1, SPR_INDEX_MAC_MACHI = 2, SPR_INDEX_TICK_TTMR = 0
} SPR_REG_INDICES;

/* Enum declaration for SPR field msb positions.  */
typedef enum spr_field_msbs {
  SPR_FIELD_MSB_SYS_VR_REV = 5, SPR_FIELD_MSB_SYS_VR_CFG = 23, SPR_FIELD_MSB_SYS_VR_VER = 31, SPR_FIELD_MSB_SYS_UPR_UP = 0
 , SPR_FIELD_MSB_SYS_UPR_DCP = 1, SPR_FIELD_MSB_SYS_UPR_ICP = 2, SPR_FIELD_MSB_SYS_UPR_DMP = 3, SPR_FIELD_MSB_SYS_UPR_MP = 4
 , SPR_FIELD_MSB_SYS_UPR_IMP = 5, SPR_FIELD_MSB_SYS_UPR_DUP = 6, SPR_FIELD_MSB_SYS_UPR_PCUP = 7, SPR_FIELD_MSB_SYS_UPR_PICP = 8
 , SPR_FIELD_MSB_SYS_UPR_PMP = 9, SPR_FIELD_MSB_SYS_UPR_TTP = 10, SPR_FIELD_MSB_SYS_UPR_CUP = 31, SPR_FIELD_MSB_SYS_CPUCFGR_NSGR = 3
 , SPR_FIELD_MSB_SYS_CPUCFGR_CGF = 4, SPR_FIELD_MSB_SYS_CPUCFGR_OB32S = 5, SPR_FIELD_MSB_SYS_CPUCFGR_OB64S = 6, SPR_FIELD_MSB_SYS_CPUCFGR_OF32S = 7
 , SPR_FIELD_MSB_SYS_CPUCFGR_OF64S = 8, SPR_FIELD_MSB_SYS_CPUCFGR_OV64S = 9, SPR_FIELD_MSB_SYS_CPUCFGR_ND = 10, SPR_FIELD_MSB_SYS_SR_SM = 0
 , SPR_FIELD_MSB_SYS_SR_TEE = 1, SPR_FIELD_MSB_SYS_SR_IEE = 2, SPR_FIELD_MSB_SYS_SR_DCE = 3, SPR_FIELD_MSB_SYS_SR_ICE = 4
 , SPR_FIELD_MSB_SYS_SR_DME = 5, SPR_FIELD_MSB_SYS_SR_IME = 6, SPR_FIELD_MSB_SYS_SR_LEE = 7, SPR_FIELD_MSB_SYS_SR_CE = 8
 , SPR_FIELD_MSB_SYS_SR_F = 9, SPR_FIELD_MSB_SYS_SR_CY = 10, SPR_FIELD_MSB_SYS_SR_OV = 11, SPR_FIELD_MSB_SYS_SR_OVE = 12
 , SPR_FIELD_MSB_SYS_SR_DSX = 13, SPR_FIELD_MSB_SYS_SR_EPH = 14, SPR_FIELD_MSB_SYS_SR_FO = 15, SPR_FIELD_MSB_SYS_SR_SUMRA = 16
 , SPR_FIELD_MSB_SYS_SR_CID = 31, SPR_FIELD_MSB_SYS_FPCSR_FPEE = 0, SPR_FIELD_MSB_SYS_FPCSR_RM = 2, SPR_FIELD_MSB_SYS_FPCSR_OVF = 3
 , SPR_FIELD_MSB_SYS_FPCSR_UNF = 4, SPR_FIELD_MSB_SYS_FPCSR_SNF = 5, SPR_FIELD_MSB_SYS_FPCSR_QNF = 6, SPR_FIELD_MSB_SYS_FPCSR_ZF = 7
 , SPR_FIELD_MSB_SYS_FPCSR_IXF = 8, SPR_FIELD_MSB_SYS_FPCSR_IVF = 9, SPR_FIELD_MSB_SYS_FPCSR_INF = 10, SPR_FIELD_MSB_SYS_FPCSR_DZF = 11
} SPR_FIELD_MSBS;

/* Enum declaration for SPR field lsb positions.  */
typedef enum spr_field_lsbs {
  SPR_FIELD_SIZE_SYS_VR_REV = 0, SPR_FIELD_SIZE_SYS_VR_CFG = 16, SPR_FIELD_SIZE_SYS_VR_VER = 24, SPR_FIELD_SIZE_SYS_UPR_UP = 0
 , SPR_FIELD_SIZE_SYS_UPR_DCP = 1, SPR_FIELD_SIZE_SYS_UPR_ICP = 2, SPR_FIELD_SIZE_SYS_UPR_DMP = 3, SPR_FIELD_SIZE_SYS_UPR_MP = 4
 , SPR_FIELD_SIZE_SYS_UPR_IMP = 5, SPR_FIELD_SIZE_SYS_UPR_DUP = 6, SPR_FIELD_SIZE_SYS_UPR_PCUP = 7, SPR_FIELD_SIZE_SYS_UPR_PICP = 8
 , SPR_FIELD_SIZE_SYS_UPR_PMP = 9, SPR_FIELD_SIZE_SYS_UPR_TTP = 10, SPR_FIELD_SIZE_SYS_UPR_CUP = 24, SPR_FIELD_SIZE_SYS_CPUCFGR_NSGR = 0
 , SPR_FIELD_SIZE_SYS_CPUCFGR_CGF = 4, SPR_FIELD_SIZE_SYS_CPUCFGR_OB32S = 5, SPR_FIELD_SIZE_SYS_CPUCFGR_OB64S = 6, SPR_FIELD_SIZE_SYS_CPUCFGR_OF32S = 7
 , SPR_FIELD_SIZE_SYS_CPUCFGR_OF64S = 8, SPR_FIELD_SIZE_SYS_CPUCFGR_OV64S = 9, SPR_FIELD_SIZE_SYS_CPUCFGR_ND = 10, SPR_FIELD_SIZE_SYS_SR_SM = 0
 , SPR_FIELD_SIZE_SYS_SR_TEE = 1, SPR_FIELD_SIZE_SYS_SR_IEE = 2, SPR_FIELD_SIZE_SYS_SR_DCE = 3, SPR_FIELD_SIZE_SYS_SR_ICE = 4
 , SPR_FIELD_SIZE_SYS_SR_DME = 5, SPR_FIELD_SIZE_SYS_SR_IME = 6, SPR_FIELD_SIZE_SYS_SR_LEE = 7, SPR_FIELD_SIZE_SYS_SR_CE = 8
 , SPR_FIELD_SIZE_SYS_SR_F = 9, SPR_FIELD_SIZE_SYS_SR_CY = 10, SPR_FIELD_SIZE_SYS_SR_OV = 11, SPR_FIELD_SIZE_SYS_SR_OVE = 12
 , SPR_FIELD_SIZE_SYS_SR_DSX = 13, SPR_FIELD_SIZE_SYS_SR_EPH = 14, SPR_FIELD_SIZE_SYS_SR_FO = 15, SPR_FIELD_SIZE_SYS_SR_SUMRA = 16
 , SPR_FIELD_SIZE_SYS_SR_CID = 28, SPR_FIELD_SIZE_SYS_FPCSR_FPEE = 0, SPR_FIELD_SIZE_SYS_FPCSR_RM = 1, SPR_FIELD_SIZE_SYS_FPCSR_OVF = 3
 , SPR_FIELD_SIZE_SYS_FPCSR_UNF = 4, SPR_FIELD_SIZE_SYS_FPCSR_SNF = 5, SPR_FIELD_SIZE_SYS_FPCSR_QNF = 6, SPR_FIELD_SIZE_SYS_FPCSR_ZF = 7
 , SPR_FIELD_SIZE_SYS_FPCSR_IXF = 8, SPR_FIELD_SIZE_SYS_FPCSR_IVF = 9, SPR_FIELD_SIZE_SYS_FPCSR_INF = 10, SPR_FIELD_SIZE_SYS_FPCSR_DZF = 11
} SPR_FIELD_LSBS;

/* Enum declaration for SPR field masks.  */
typedef enum spr_field_masks {
  SPR_FIELD_MASK_SYS_VR_REV = 63, SPR_FIELD_MASK_SYS_VR_CFG = 16711680, SPR_FIELD_MASK_SYS_VR_VER = 4278190080u, SPR_FIELD_MASK_SYS_UPR_UP = 1
 , SPR_FIELD_MASK_SYS_UPR_DCP = 2, SPR_FIELD_MASK_SYS_UPR_ICP = 4, SPR_FIELD_MASK_SYS_UPR_DMP = 8, SPR_FIELD_MASK_SYS_UPR_MP = 16
 , SPR_FIELD_MASK_SYS_UPR_IMP = 32, SPR_FIELD_MASK_SYS_UPR_DUP = 64, SPR_FIELD_MASK_SYS_UPR_PCUP = 128, SPR_FIELD_MASK_SYS_UPR_PICP = 256
 , SPR_FIELD_MASK_SYS_UPR_PMP = 512, SPR_FIELD_MASK_SYS_UPR_TTP = 1024, SPR_FIELD_MASK_SYS_UPR_CUP = 4278190080u, SPR_FIELD_MASK_SYS_CPUCFGR_NSGR = 15
 , SPR_FIELD_MASK_SYS_CPUCFGR_CGF = 16, SPR_FIELD_MASK_SYS_CPUCFGR_OB32S = 32, SPR_FIELD_MASK_SYS_CPUCFGR_OB64S = 64, SPR_FIELD_MASK_SYS_CPUCFGR_OF32S = 128
 , SPR_FIELD_MASK_SYS_CPUCFGR_OF64S = 256, SPR_FIELD_MASK_SYS_CPUCFGR_OV64S = 512, SPR_FIELD_MASK_SYS_CPUCFGR_ND = 1024, SPR_FIELD_MASK_SYS_SR_SM = 1
 , SPR_FIELD_MASK_SYS_SR_TEE = 2, SPR_FIELD_MASK_SYS_SR_IEE = 4, SPR_FIELD_MASK_SYS_SR_DCE = 8, SPR_FIELD_MASK_SYS_SR_ICE = 16
 , SPR_FIELD_MASK_SYS_SR_DME = 32, SPR_FIELD_MASK_SYS_SR_IME = 64, SPR_FIELD_MASK_SYS_SR_LEE = 128, SPR_FIELD_MASK_SYS_SR_CE = 256
 , SPR_FIELD_MASK_SYS_SR_F = 512, SPR_FIELD_MASK_SYS_SR_CY = 1024, SPR_FIELD_MASK_SYS_SR_OV = 2048, SPR_FIELD_MASK_SYS_SR_OVE = 4096
 , SPR_FIELD_MASK_SYS_SR_DSX = 8192, SPR_FIELD_MASK_SYS_SR_EPH = 16384, SPR_FIELD_MASK_SYS_SR_FO = 32768, SPR_FIELD_MASK_SYS_SR_SUMRA = 65536
 , SPR_FIELD_MASK_SYS_SR_CID = 4026531840u, SPR_FIELD_MASK_SYS_FPCSR_FPEE = 1, SPR_FIELD_MASK_SYS_FPCSR_RM = 6, SPR_FIELD_MASK_SYS_FPCSR_OVF = 8
 , SPR_FIELD_MASK_SYS_FPCSR_UNF = 16, SPR_FIELD_MASK_SYS_FPCSR_SNF = 32, SPR_FIELD_MASK_SYS_FPCSR_QNF = 64, SPR_FIELD_MASK_SYS_FPCSR_ZF = 128
 , SPR_FIELD_MASK_SYS_FPCSR_IXF = 256, SPR_FIELD_MASK_SYS_FPCSR_IVF = 512, SPR_FIELD_MASK_SYS_FPCSR_INF = 1024, SPR_FIELD_MASK_SYS_FPCSR_DZF = 2048
} SPR_FIELD_MASKS;

/* Enum declaration for insn main opcode enums.  */
typedef enum insn_opcode {
  OPC_J = 0, OPC_JAL = 1, OPC_BNF = 3, OPC_BF = 4
 , OPC_NOP = 5, OPC_MOVHIMACRC = 6, OPC_SYSTRAPSYNCS = 8, OPC_RFE = 9
 , OPC_VECTOR = 10, OPC_JR = 17, OPC_JALR = 18, OPC_MACI = 19
 , OPC_LWA = 27, OPC_CUST1 = 28, OPC_CUST2 = 29, OPC_CUST3 = 30
 , OPC_CUST4 = 31, OPC_LD = 32, OPC_LWZ = 33, OPC_LWS = 34
 , OPC_LBZ = 35, OPC_LBS = 36, OPC_LHZ = 37, OPC_LHS = 38
 , OPC_ADDI = 39, OPC_ADDIC = 40, OPC_ANDI = 41, OPC_ORI = 42
 , OPC_XORI = 43, OPC_MULI = 44, OPC_MFSPR = 45, OPC_SHROTI = 46
 , OPC_SFI = 47, OPC_MTSPR = 48, OPC_MAC = 49, OPC_FLOAT = 50
 , OPC_SWA = 51, OPC_SD = 52, OPC_SW = 53, OPC_SB = 54
 , OPC_SH = 55, OPC_ALU = 56, OPC_SF = 57, OPC_CUST5 = 60
 , OPC_CUST6 = 61, OPC_CUST7 = 62, OPC_CUST8 = 63
} INSN_OPCODE;

/* Enum declaration for systrapsync insn opcode enums.  */
typedef enum insn_opcode_systrapsyncs {
  OPC_SYSTRAPSYNCS_SYSCALL = 0, OPC_SYSTRAPSYNCS_TRAP = 8, OPC_SYSTRAPSYNCS_MSYNC = 16, OPC_SYSTRAPSYNCS_PSYNC = 20
 , OPC_SYSTRAPSYNCS_CSYNC = 24
} INSN_OPCODE_SYSTRAPSYNCS;

/* Enum declaration for movhi/macrc insn opcode enums.  */
typedef enum insn_opcode_movehimacrc {
  OPC_MOVHIMACRC_MOVHI, OPC_MOVHIMACRC_MACRC
} INSN_OPCODE_MOVEHIMACRC;

/* Enum declaration for multiply/accumulate insn opcode enums.  */
typedef enum insn_opcode_mac {
  OPC_MAC_MAC = 1, OPC_MAC_MSB = 2
} INSN_OPCODE_MAC;

/* Enum declaration for shift/rotate insn opcode enums.  */
typedef enum insn_opcode_shorts {
  OPC_SHROTS_SLL, OPC_SHROTS_SRL, OPC_SHROTS_SRA, OPC_SHROTS_ROR
} INSN_OPCODE_SHORTS;

/* Enum declaration for extend byte/half opcode enums.  */
typedef enum insn_opcode_extbhs {
  OPC_EXTBHS_EXTHS, OPC_EXTBHS_EXTBS, OPC_EXTBHS_EXTHZ, OPC_EXTBHS_EXTBZ
} INSN_OPCODE_EXTBHS;

/* Enum declaration for extend word opcode enums.  */
typedef enum insn_opcode_extws {
  OPC_EXTWS_EXTWS, OPC_EXTWS_EXTWZ
} INSN_OPCODE_EXTWS;

/* Enum declaration for alu reg/reg insn opcode enums.  */
typedef enum insn_opcode_alu_regreg {
  OPC_ALU_REGREG_ADD = 0, OPC_ALU_REGREG_ADDC = 1, OPC_ALU_REGREG_SUB = 2, OPC_ALU_REGREG_AND = 3
 , OPC_ALU_REGREG_OR = 4, OPC_ALU_REGREG_XOR = 5, OPC_ALU_REGREG_MUL = 6, OPC_ALU_REGREG_SHROT = 8
 , OPC_ALU_REGREG_DIV = 9, OPC_ALU_REGREG_DIVU = 10, OPC_ALU_REGREG_MULU = 11, OPC_ALU_REGREG_EXTBH = 12
 , OPC_ALU_REGREG_EXTW = 13, OPC_ALU_REGREG_CMOV = 14, OPC_ALU_REGREG_FFL1 = 15
} INSN_OPCODE_ALU_REGREG;

/* Enum declaration for setflag insn opcode enums.  */
typedef enum insn_opcode_setflag {
  OPC_SF_EQ = 0, OPC_SF_NE = 1, OPC_SF_GTU = 2, OPC_SF_GEU = 3
 , OPC_SF_LTU = 4, OPC_SF_LEU = 5, OPC_SF_GTS = 10, OPC_SF_GES = 11
 , OPC_SF_LTS = 12, OPC_SF_LES = 13
} INSN_OPCODE_SETFLAG;

/* Enum declaration for floating point reg/reg insn opcode enums.  */
typedef enum insn_opcode_float_regreg {
  OPC_FLOAT_REGREG_ADD_S = 0, OPC_FLOAT_REGREG_SUB_S = 1, OPC_FLOAT_REGREG_MUL_S = 2, OPC_FLOAT_REGREG_DIV_S = 3
 , OPC_FLOAT_REGREG_ITOF_S = 4, OPC_FLOAT_REGREG_FTOI_S = 5, OPC_FLOAT_REGREG_REM_S = 6, OPC_FLOAT_REGREG_MADD_S = 7
 , OPC_FLOAT_REGREG_SFEQ_S = 8, OPC_FLOAT_REGREG_SFNE_S = 9, OPC_FLOAT_REGREG_SFGT_S = 10, OPC_FLOAT_REGREG_SFGE_S = 11
 , OPC_FLOAT_REGREG_SFLT_S = 12, OPC_FLOAT_REGREG_SFLE_S = 13, OPC_FLOAT_REGREG_ADD_D = 16, OPC_FLOAT_REGREG_SUB_D = 17
 , OPC_FLOAT_REGREG_MUL_D = 18, OPC_FLOAT_REGREG_DIV_D = 19, OPC_FLOAT_REGREG_ITOF_D = 20, OPC_FLOAT_REGREG_FTOI_D = 21
 , OPC_FLOAT_REGREG_REM_D = 22, OPC_FLOAT_REGREG_MADD_D = 23, OPC_FLOAT_REGREG_SFEQ_D = 24, OPC_FLOAT_REGREG_SFNE_D = 25
 , OPC_FLOAT_REGREG_SFGT_D = 26, OPC_FLOAT_REGREG_SFGE_D = 27, OPC_FLOAT_REGREG_SFLT_D = 28, OPC_FLOAT_REGREG_SFLE_D = 29
 , OPC_FLOAT_REGREG_CUST1_S = 208, OPC_FLOAT_REGREG_CUST1_D = 224
} INSN_OPCODE_FLOAT_REGREG;

/* Attributes.  */

/* Enum declaration for machine type selection.  */
typedef enum mach_attr {
  MACH_BASE, MACH_OR32, MACH_OR32ND, MACH_OR64
 , MACH_OR64ND, MACH_MAX
} MACH_ATTR;

/* Enum declaration for instruction set selection.  */
typedef enum isa_attr {
  ISA_OPENRISC, ISA_MAX
} ISA_ATTR;

/* Number of architecture variants.  */
#define MAX_ISAS  1
#define MAX_MACHS ((int) MACH_MAX)

/* Ifield support.  */

/* Ifield attribute indices.  */

/* Enum declaration for cgen_ifld attrs.  */
typedef enum cgen_ifld_attr {
  CGEN_IFLD_VIRTUAL, CGEN_IFLD_PCREL_ADDR, CGEN_IFLD_ABS_ADDR, CGEN_IFLD_RESERVED
 , CGEN_IFLD_SIGN_OPT, CGEN_IFLD_SIGNED, CGEN_IFLD_END_BOOLS, CGEN_IFLD_START_NBOOLS = 31
 , CGEN_IFLD_MACH, CGEN_IFLD_END_NBOOLS
} CGEN_IFLD_ATTR;

/* Number of non-boolean elements in cgen_ifld_attr.  */
#define CGEN_IFLD_NBOOL_ATTRS (CGEN_IFLD_END_NBOOLS - CGEN_IFLD_START_NBOOLS - 1)

/* cgen_ifld attribute accessor macros.  */
#define CGEN_ATTR_CGEN_IFLD_MACH_VALUE(attrs) ((attrs)->nonbool[CGEN_IFLD_MACH-CGEN_IFLD_START_NBOOLS-1].nonbitset)
#define CGEN_ATTR_CGEN_IFLD_VIRTUAL_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_IFLD_VIRTUAL)) != 0)
#define CGEN_ATTR_CGEN_IFLD_PCREL_ADDR_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_IFLD_PCREL_ADDR)) != 0)
#define CGEN_ATTR_CGEN_IFLD_ABS_ADDR_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_IFLD_ABS_ADDR)) != 0)
#define CGEN_ATTR_CGEN_IFLD_RESERVED_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_IFLD_RESERVED)) != 0)
#define CGEN_ATTR_CGEN_IFLD_SIGN_OPT_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_IFLD_SIGN_OPT)) != 0)
#define CGEN_ATTR_CGEN_IFLD_SIGNED_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_IFLD_SIGNED)) != 0)

/* Enum declaration for or1k ifield types.  */
typedef enum ifield_type {
  OR1K_F_NIL, OR1K_F_ANYOF, OR1K_F_OPCODE, OR1K_F_R1
 , OR1K_F_R2, OR1K_F_R3, OR1K_F_OP_25_2, OR1K_F_OP_25_5
 , OR1K_F_OP_16_1, OR1K_F_OP_7_4, OR1K_F_OP_3_4, OR1K_F_OP_9_2
 , OR1K_F_OP_9_4, OR1K_F_OP_7_8, OR1K_F_OP_7_2, OR1K_F_RESV_25_26
 , OR1K_F_RESV_25_10, OR1K_F_RESV_25_5, OR1K_F_RESV_23_8, OR1K_F_RESV_20_5
 , OR1K_F_RESV_20_4, OR1K_F_RESV_15_8, OR1K_F_RESV_15_6, OR1K_F_RESV_10_11
 , OR1K_F_RESV_10_7, OR1K_F_RESV_10_3, OR1K_F_RESV_10_1, OR1K_F_RESV_7_4
 , OR1K_F_RESV_5_2, OR1K_F_IMM16_25_5, OR1K_F_IMM16_10_11, OR1K_F_DISP26
 , OR1K_F_UIMM16, OR1K_F_SIMM16, OR1K_F_UIMM6, OR1K_F_UIMM16_SPLIT
 , OR1K_F_SIMM16_SPLIT, OR1K_F_MAX
} IFIELD_TYPE;

#define MAX_IFLD ((int) OR1K_F_MAX)

/* Hardware attribute indices.  */

/* Enum declaration for cgen_hw attrs.  */
typedef enum cgen_hw_attr {
  CGEN_HW_VIRTUAL, CGEN_HW_CACHE_ADDR, CGEN_HW_PC, CGEN_HW_PROFILE
 , CGEN_HW_END_BOOLS, CGEN_HW_START_NBOOLS = 31, CGEN_HW_MACH, CGEN_HW_END_NBOOLS
} CGEN_HW_ATTR;

/* Number of non-boolean elements in cgen_hw_attr.  */
#define CGEN_HW_NBOOL_ATTRS (CGEN_HW_END_NBOOLS - CGEN_HW_START_NBOOLS - 1)

/* cgen_hw attribute accessor macros.  */
#define CGEN_ATTR_CGEN_HW_MACH_VALUE(attrs) ((attrs)->nonbool[CGEN_HW_MACH-CGEN_HW_START_NBOOLS-1].nonbitset)
#define CGEN_ATTR_CGEN_HW_VIRTUAL_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_HW_VIRTUAL)) != 0)
#define CGEN_ATTR_CGEN_HW_CACHE_ADDR_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_HW_CACHE_ADDR)) != 0)
#define CGEN_ATTR_CGEN_HW_PC_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_HW_PC)) != 0)
#define CGEN_ATTR_CGEN_HW_PROFILE_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_HW_PROFILE)) != 0)

/* Enum declaration for or1k hardware types.  */
typedef enum cgen_hw_type {
  HW_H_MEMORY, HW_H_SINT, HW_H_UINT, HW_H_ADDR
 , HW_H_IADDR, HW_H_PC, HW_H_FSR, HW_H_FDR
 , HW_H_SPR, HW_H_GPR, HW_H_SYS_VR, HW_H_SYS_UPR
 , HW_H_SYS_CPUCFGR, HW_H_SYS_DMMUCFGR, HW_H_SYS_IMMUCFGR, HW_H_SYS_DCCFGR
 , HW_H_SYS_ICCFGR, HW_H_SYS_DCFGR, HW_H_SYS_PCCFGR, HW_H_SYS_NPC
 , HW_H_SYS_SR, HW_H_SYS_PPC, HW_H_SYS_FPCSR, HW_H_SYS_EPCR0
 , HW_H_SYS_EPCR1, HW_H_SYS_EPCR2, HW_H_SYS_EPCR3, HW_H_SYS_EPCR4
 , HW_H_SYS_EPCR5, HW_H_SYS_EPCR6, HW_H_SYS_EPCR7, HW_H_SYS_EPCR8
 , HW_H_SYS_EPCR9, HW_H_SYS_EPCR10, HW_H_SYS_EPCR11, HW_H_SYS_EPCR12
 , HW_H_SYS_EPCR13, HW_H_SYS_EPCR14, HW_H_SYS_EPCR15, HW_H_SYS_EEAR0
 , HW_H_SYS_EEAR1, HW_H_SYS_EEAR2, HW_H_SYS_EEAR3, HW_H_SYS_EEAR4
 , HW_H_SYS_EEAR5, HW_H_SYS_EEAR6, HW_H_SYS_EEAR7, HW_H_SYS_EEAR8
 , HW_H_SYS_EEAR9, HW_H_SYS_EEAR10, HW_H_SYS_EEAR11, HW_H_SYS_EEAR12
 , HW_H_SYS_EEAR13, HW_H_SYS_EEAR14, HW_H_SYS_EEAR15, HW_H_SYS_ESR0
 , HW_H_SYS_ESR1, HW_H_SYS_ESR2, HW_H_SYS_ESR3, HW_H_SYS_ESR4
 , HW_H_SYS_ESR5, HW_H_SYS_ESR6, HW_H_SYS_ESR7, HW_H_SYS_ESR8
 , HW_H_SYS_ESR9, HW_H_SYS_ESR10, HW_H_SYS_ESR11, HW_H_SYS_ESR12
 , HW_H_SYS_ESR13, HW_H_SYS_ESR14, HW_H_SYS_ESR15, HW_H_SYS_GPR0
 , HW_H_SYS_GPR1, HW_H_SYS_GPR2, HW_H_SYS_GPR3, HW_H_SYS_GPR4
 , HW_H_SYS_GPR5, HW_H_SYS_GPR6, HW_H_SYS_GPR7, HW_H_SYS_GPR8
 , HW_H_SYS_GPR9, HW_H_SYS_GPR10, HW_H_SYS_GPR11, HW_H_SYS_GPR12
 , HW_H_SYS_GPR13, HW_H_SYS_GPR14, HW_H_SYS_GPR15, HW_H_SYS_GPR16
 , HW_H_SYS_GPR17, HW_H_SYS_GPR18, HW_H_SYS_GPR19, HW_H_SYS_GPR20
 , HW_H_SYS_GPR21, HW_H_SYS_GPR22, HW_H_SYS_GPR23, HW_H_SYS_GPR24
 , HW_H_SYS_GPR25, HW_H_SYS_GPR26, HW_H_SYS_GPR27, HW_H_SYS_GPR28
 , HW_H_SYS_GPR29, HW_H_SYS_GPR30, HW_H_SYS_GPR31, HW_H_SYS_GPR32
 , HW_H_SYS_GPR33, HW_H_SYS_GPR34, HW_H_SYS_GPR35, HW_H_SYS_GPR36
 , HW_H_SYS_GPR37, HW_H_SYS_GPR38, HW_H_SYS_GPR39, HW_H_SYS_GPR40
 , HW_H_SYS_GPR41, HW_H_SYS_GPR42, HW_H_SYS_GPR43, HW_H_SYS_GPR44
 , HW_H_SYS_GPR45, HW_H_SYS_GPR46, HW_H_SYS_GPR47, HW_H_SYS_GPR48
 , HW_H_SYS_GPR49, HW_H_SYS_GPR50, HW_H_SYS_GPR51, HW_H_SYS_GPR52
 , HW_H_SYS_GPR53, HW_H_SYS_GPR54, HW_H_SYS_GPR55, HW_H_SYS_GPR56
 , HW_H_SYS_GPR57, HW_H_SYS_GPR58, HW_H_SYS_GPR59, HW_H_SYS_GPR60
 , HW_H_SYS_GPR61, HW_H_SYS_GPR62, HW_H_SYS_GPR63, HW_H_SYS_GPR64
 , HW_H_SYS_GPR65, HW_H_SYS_GPR66, HW_H_SYS_GPR67, HW_H_SYS_GPR68
 , HW_H_SYS_GPR69, HW_H_SYS_GPR70, HW_H_SYS_GPR71, HW_H_SYS_GPR72
 , HW_H_SYS_GPR73, HW_H_SYS_GPR74, HW_H_SYS_GPR75, HW_H_SYS_GPR76
 , HW_H_SYS_GPR77, HW_H_SYS_GPR78, HW_H_SYS_GPR79, HW_H_SYS_GPR80
 , HW_H_SYS_GPR81, HW_H_SYS_GPR82, HW_H_SYS_GPR83, HW_H_SYS_GPR84
 , HW_H_SYS_GPR85, HW_H_SYS_GPR86, HW_H_SYS_GPR87, HW_H_SYS_GPR88
 , HW_H_SYS_GPR89, HW_H_SYS_GPR90, HW_H_SYS_GPR91, HW_H_SYS_GPR92
 , HW_H_SYS_GPR93, HW_H_SYS_GPR94, HW_H_SYS_GPR95, HW_H_SYS_GPR96
 , HW_H_SYS_GPR97, HW_H_SYS_GPR98, HW_H_SYS_GPR99, HW_H_SYS_GPR100
 , HW_H_SYS_GPR101, HW_H_SYS_GPR102, HW_H_SYS_GPR103, HW_H_SYS_GPR104
 , HW_H_SYS_GPR105, HW_H_SYS_GPR106, HW_H_SYS_GPR107, HW_H_SYS_GPR108
 , HW_H_SYS_GPR109, HW_H_SYS_GPR110, HW_H_SYS_GPR111, HW_H_SYS_GPR112
 , HW_H_SYS_GPR113, HW_H_SYS_GPR114, HW_H_SYS_GPR115, HW_H_SYS_GPR116
 , HW_H_SYS_GPR117, HW_H_SYS_GPR118, HW_H_SYS_GPR119, HW_H_SYS_GPR120
 , HW_H_SYS_GPR121, HW_H_SYS_GPR122, HW_H_SYS_GPR123, HW_H_SYS_GPR124
 , HW_H_SYS_GPR125, HW_H_SYS_GPR126, HW_H_SYS_GPR127, HW_H_SYS_GPR128
 , HW_H_SYS_GPR129, HW_H_SYS_GPR130, HW_H_SYS_GPR131, HW_H_SYS_GPR132
 , HW_H_SYS_GPR133, HW_H_SYS_GPR134, HW_H_SYS_GPR135, HW_H_SYS_GPR136
 , HW_H_SYS_GPR137, HW_H_SYS_GPR138, HW_H_SYS_GPR139, HW_H_SYS_GPR140
 , HW_H_SYS_GPR141, HW_H_SYS_GPR142, HW_H_SYS_GPR143, HW_H_SYS_GPR144
 , HW_H_SYS_GPR145, HW_H_SYS_GPR146, HW_H_SYS_GPR147, HW_H_SYS_GPR148
 , HW_H_SYS_GPR149, HW_H_SYS_GPR150, HW_H_SYS_GPR151, HW_H_SYS_GPR152
 , HW_H_SYS_GPR153, HW_H_SYS_GPR154, HW_H_SYS_GPR155, HW_H_SYS_GPR156
 , HW_H_SYS_GPR157, HW_H_SYS_GPR158, HW_H_SYS_GPR159, HW_H_SYS_GPR160
 , HW_H_SYS_GPR161, HW_H_SYS_GPR162, HW_H_SYS_GPR163, HW_H_SYS_GPR164
 , HW_H_SYS_GPR165, HW_H_SYS_GPR166, HW_H_SYS_GPR167, HW_H_SYS_GPR168
 , HW_H_SYS_GPR169, HW_H_SYS_GPR170, HW_H_SYS_GPR171, HW_H_SYS_GPR172
 , HW_H_SYS_GPR173, HW_H_SYS_GPR174, HW_H_SYS_GPR175, HW_H_SYS_GPR176
 , HW_H_SYS_GPR177, HW_H_SYS_GPR178, HW_H_SYS_GPR179, HW_H_SYS_GPR180
 , HW_H_SYS_GPR181, HW_H_SYS_GPR182, HW_H_SYS_GPR183, HW_H_SYS_GPR184
 , HW_H_SYS_GPR185, HW_H_SYS_GPR186, HW_H_SYS_GPR187, HW_H_SYS_GPR188
 , HW_H_SYS_GPR189, HW_H_SYS_GPR190, HW_H_SYS_GPR191, HW_H_SYS_GPR192
 , HW_H_SYS_GPR193, HW_H_SYS_GPR194, HW_H_SYS_GPR195, HW_H_SYS_GPR196
 , HW_H_SYS_GPR197, HW_H_SYS_GPR198, HW_H_SYS_GPR199, HW_H_SYS_GPR200
 , HW_H_SYS_GPR201, HW_H_SYS_GPR202, HW_H_SYS_GPR203, HW_H_SYS_GPR204
 , HW_H_SYS_GPR205, HW_H_SYS_GPR206, HW_H_SYS_GPR207, HW_H_SYS_GPR208
 , HW_H_SYS_GPR209, HW_H_SYS_GPR210, HW_H_SYS_GPR211, HW_H_SYS_GPR212
 , HW_H_SYS_GPR213, HW_H_SYS_GPR214, HW_H_SYS_GPR215, HW_H_SYS_GPR216
 , HW_H_SYS_GPR217, HW_H_SYS_GPR218, HW_H_SYS_GPR219, HW_H_SYS_GPR220
 , HW_H_SYS_GPR221, HW_H_SYS_GPR222, HW_H_SYS_GPR223, HW_H_SYS_GPR224
 , HW_H_SYS_GPR225, HW_H_SYS_GPR226, HW_H_SYS_GPR227, HW_H_SYS_GPR228
 , HW_H_SYS_GPR229, HW_H_SYS_GPR230, HW_H_SYS_GPR231, HW_H_SYS_GPR232
 , HW_H_SYS_GPR233, HW_H_SYS_GPR234, HW_H_SYS_GPR235, HW_H_SYS_GPR236
 , HW_H_SYS_GPR237, HW_H_SYS_GPR238, HW_H_SYS_GPR239, HW_H_SYS_GPR240
 , HW_H_SYS_GPR241, HW_H_SYS_GPR242, HW_H_SYS_GPR243, HW_H_SYS_GPR244
 , HW_H_SYS_GPR245, HW_H_SYS_GPR246, HW_H_SYS_GPR247, HW_H_SYS_GPR248
 , HW_H_SYS_GPR249, HW_H_SYS_GPR250, HW_H_SYS_GPR251, HW_H_SYS_GPR252
 , HW_H_SYS_GPR253, HW_H_SYS_GPR254, HW_H_SYS_GPR255, HW_H_SYS_GPR256
 , HW_H_SYS_GPR257, HW_H_SYS_GPR258, HW_H_SYS_GPR259, HW_H_SYS_GPR260
 , HW_H_SYS_GPR261, HW_H_SYS_GPR262, HW_H_SYS_GPR263, HW_H_SYS_GPR264
 , HW_H_SYS_GPR265, HW_H_SYS_GPR266, HW_H_SYS_GPR267, HW_H_SYS_GPR268
 , HW_H_SYS_GPR269, HW_H_SYS_GPR270, HW_H_SYS_GPR271, HW_H_SYS_GPR272
 , HW_H_SYS_GPR273, HW_H_SYS_GPR274, HW_H_SYS_GPR275, HW_H_SYS_GPR276
 , HW_H_SYS_GPR277, HW_H_SYS_GPR278, HW_H_SYS_GPR279, HW_H_SYS_GPR280
 , HW_H_SYS_GPR281, HW_H_SYS_GPR282, HW_H_SYS_GPR283, HW_H_SYS_GPR284
 , HW_H_SYS_GPR285, HW_H_SYS_GPR286, HW_H_SYS_GPR287, HW_H_SYS_GPR288
 , HW_H_SYS_GPR289, HW_H_SYS_GPR290, HW_H_SYS_GPR291, HW_H_SYS_GPR292
 , HW_H_SYS_GPR293, HW_H_SYS_GPR294, HW_H_SYS_GPR295, HW_H_SYS_GPR296
 , HW_H_SYS_GPR297, HW_H_SYS_GPR298, HW_H_SYS_GPR299, HW_H_SYS_GPR300
 , HW_H_SYS_GPR301, HW_H_SYS_GPR302, HW_H_SYS_GPR303, HW_H_SYS_GPR304
 , HW_H_SYS_GPR305, HW_H_SYS_GPR306, HW_H_SYS_GPR307, HW_H_SYS_GPR308
 , HW_H_SYS_GPR309, HW_H_SYS_GPR310, HW_H_SYS_GPR311, HW_H_SYS_GPR312
 , HW_H_SYS_GPR313, HW_H_SYS_GPR314, HW_H_SYS_GPR315, HW_H_SYS_GPR316
 , HW_H_SYS_GPR317, HW_H_SYS_GPR318, HW_H_SYS_GPR319, HW_H_SYS_GPR320
 , HW_H_SYS_GPR321, HW_H_SYS_GPR322, HW_H_SYS_GPR323, HW_H_SYS_GPR324
 , HW_H_SYS_GPR325, HW_H_SYS_GPR326, HW_H_SYS_GPR327, HW_H_SYS_GPR328
 , HW_H_SYS_GPR329, HW_H_SYS_GPR330, HW_H_SYS_GPR331, HW_H_SYS_GPR332
 , HW_H_SYS_GPR333, HW_H_SYS_GPR334, HW_H_SYS_GPR335, HW_H_SYS_GPR336
 , HW_H_SYS_GPR337, HW_H_SYS_GPR338, HW_H_SYS_GPR339, HW_H_SYS_GPR340
 , HW_H_SYS_GPR341, HW_H_SYS_GPR342, HW_H_SYS_GPR343, HW_H_SYS_GPR344
 , HW_H_SYS_GPR345, HW_H_SYS_GPR346, HW_H_SYS_GPR347, HW_H_SYS_GPR348
 , HW_H_SYS_GPR349, HW_H_SYS_GPR350, HW_H_SYS_GPR351, HW_H_SYS_GPR352
 , HW_H_SYS_GPR353, HW_H_SYS_GPR354, HW_H_SYS_GPR355, HW_H_SYS_GPR356
 , HW_H_SYS_GPR357, HW_H_SYS_GPR358, HW_H_SYS_GPR359, HW_H_SYS_GPR360
 , HW_H_SYS_GPR361, HW_H_SYS_GPR362, HW_H_SYS_GPR363, HW_H_SYS_GPR364
 , HW_H_SYS_GPR365, HW_H_SYS_GPR366, HW_H_SYS_GPR367, HW_H_SYS_GPR368
 , HW_H_SYS_GPR369, HW_H_SYS_GPR370, HW_H_SYS_GPR371, HW_H_SYS_GPR372
 , HW_H_SYS_GPR373, HW_H_SYS_GPR374, HW_H_SYS_GPR375, HW_H_SYS_GPR376
 , HW_H_SYS_GPR377, HW_H_SYS_GPR378, HW_H_SYS_GPR379, HW_H_SYS_GPR380
 , HW_H_SYS_GPR381, HW_H_SYS_GPR382, HW_H_SYS_GPR383, HW_H_SYS_GPR384
 , HW_H_SYS_GPR385, HW_H_SYS_GPR386, HW_H_SYS_GPR387, HW_H_SYS_GPR388
 , HW_H_SYS_GPR389, HW_H_SYS_GPR390, HW_H_SYS_GPR391, HW_H_SYS_GPR392
 , HW_H_SYS_GPR393, HW_H_SYS_GPR394, HW_H_SYS_GPR395, HW_H_SYS_GPR396
 , HW_H_SYS_GPR397, HW_H_SYS_GPR398, HW_H_SYS_GPR399, HW_H_SYS_GPR400
 , HW_H_SYS_GPR401, HW_H_SYS_GPR402, HW_H_SYS_GPR403, HW_H_SYS_GPR404
 , HW_H_SYS_GPR405, HW_H_SYS_GPR406, HW_H_SYS_GPR407, HW_H_SYS_GPR408
 , HW_H_SYS_GPR409, HW_H_SYS_GPR410, HW_H_SYS_GPR411, HW_H_SYS_GPR412
 , HW_H_SYS_GPR413, HW_H_SYS_GPR414, HW_H_SYS_GPR415, HW_H_SYS_GPR416
 , HW_H_SYS_GPR417, HW_H_SYS_GPR418, HW_H_SYS_GPR419, HW_H_SYS_GPR420
 , HW_H_SYS_GPR421, HW_H_SYS_GPR422, HW_H_SYS_GPR423, HW_H_SYS_GPR424
 , HW_H_SYS_GPR425, HW_H_SYS_GPR426, HW_H_SYS_GPR427, HW_H_SYS_GPR428
 , HW_H_SYS_GPR429, HW_H_SYS_GPR430, HW_H_SYS_GPR431, HW_H_SYS_GPR432
 , HW_H_SYS_GPR433, HW_H_SYS_GPR434, HW_H_SYS_GPR435, HW_H_SYS_GPR436
 , HW_H_SYS_GPR437, HW_H_SYS_GPR438, HW_H_SYS_GPR439, HW_H_SYS_GPR440
 , HW_H_SYS_GPR441, HW_H_SYS_GPR442, HW_H_SYS_GPR443, HW_H_SYS_GPR444
 , HW_H_SYS_GPR445, HW_H_SYS_GPR446, HW_H_SYS_GPR447, HW_H_SYS_GPR448
 , HW_H_SYS_GPR449, HW_H_SYS_GPR450, HW_H_SYS_GPR451, HW_H_SYS_GPR452
 , HW_H_SYS_GPR453, HW_H_SYS_GPR454, HW_H_SYS_GPR455, HW_H_SYS_GPR456
 , HW_H_SYS_GPR457, HW_H_SYS_GPR458, HW_H_SYS_GPR459, HW_H_SYS_GPR460
 , HW_H_SYS_GPR461, HW_H_SYS_GPR462, HW_H_SYS_GPR463, HW_H_SYS_GPR464
 , HW_H_SYS_GPR465, HW_H_SYS_GPR466, HW_H_SYS_GPR467, HW_H_SYS_GPR468
 , HW_H_SYS_GPR469, HW_H_SYS_GPR470, HW_H_SYS_GPR471, HW_H_SYS_GPR472
 , HW_H_SYS_GPR473, HW_H_SYS_GPR474, HW_H_SYS_GPR475, HW_H_SYS_GPR476
 , HW_H_SYS_GPR477, HW_H_SYS_GPR478, HW_H_SYS_GPR479, HW_H_SYS_GPR480
 , HW_H_SYS_GPR481, HW_H_SYS_GPR482, HW_H_SYS_GPR483, HW_H_SYS_GPR484
 , HW_H_SYS_GPR485, HW_H_SYS_GPR486, HW_H_SYS_GPR487, HW_H_SYS_GPR488
 , HW_H_SYS_GPR489, HW_H_SYS_GPR490, HW_H_SYS_GPR491, HW_H_SYS_GPR492
 , HW_H_SYS_GPR493, HW_H_SYS_GPR494, HW_H_SYS_GPR495, HW_H_SYS_GPR496
 , HW_H_SYS_GPR497, HW_H_SYS_GPR498, HW_H_SYS_GPR499, HW_H_SYS_GPR500
 , HW_H_SYS_GPR501, HW_H_SYS_GPR502, HW_H_SYS_GPR503, HW_H_SYS_GPR504
 , HW_H_SYS_GPR505, HW_H_SYS_GPR506, HW_H_SYS_GPR507, HW_H_SYS_GPR508
 , HW_H_SYS_GPR509, HW_H_SYS_GPR510, HW_H_SYS_GPR511, HW_H_MAC_MACLO
 , HW_H_MAC_MACHI, HW_H_TICK_TTMR, HW_H_SYS_VR_REV, HW_H_SYS_VR_CFG
 , HW_H_SYS_VR_VER, HW_H_SYS_UPR_UP, HW_H_SYS_UPR_DCP, HW_H_SYS_UPR_ICP
 , HW_H_SYS_UPR_DMP, HW_H_SYS_UPR_MP, HW_H_SYS_UPR_IMP, HW_H_SYS_UPR_DUP
 , HW_H_SYS_UPR_PCUP, HW_H_SYS_UPR_PICP, HW_H_SYS_UPR_PMP, HW_H_SYS_UPR_TTP
 , HW_H_SYS_UPR_CUP, HW_H_SYS_CPUCFGR_NSGR, HW_H_SYS_CPUCFGR_CGF, HW_H_SYS_CPUCFGR_OB32S
 , HW_H_SYS_CPUCFGR_OB64S, HW_H_SYS_CPUCFGR_OF32S, HW_H_SYS_CPUCFGR_OF64S, HW_H_SYS_CPUCFGR_OV64S
 , HW_H_SYS_CPUCFGR_ND, HW_H_SYS_SR_SM, HW_H_SYS_SR_TEE, HW_H_SYS_SR_IEE
 , HW_H_SYS_SR_DCE, HW_H_SYS_SR_ICE, HW_H_SYS_SR_DME, HW_H_SYS_SR_IME
 , HW_H_SYS_SR_LEE, HW_H_SYS_SR_CE, HW_H_SYS_SR_F, HW_H_SYS_SR_CY
 , HW_H_SYS_SR_OV, HW_H_SYS_SR_OVE, HW_H_SYS_SR_DSX, HW_H_SYS_SR_EPH
 , HW_H_SYS_SR_FO, HW_H_SYS_SR_SUMRA, HW_H_SYS_SR_CID, HW_H_SYS_FPCSR_FPEE
 , HW_H_SYS_FPCSR_RM, HW_H_SYS_FPCSR_OVF, HW_H_SYS_FPCSR_UNF, HW_H_SYS_FPCSR_SNF
 , HW_H_SYS_FPCSR_QNF, HW_H_SYS_FPCSR_ZF, HW_H_SYS_FPCSR_IXF, HW_H_SYS_FPCSR_IVF
 , HW_H_SYS_FPCSR_INF, HW_H_SYS_FPCSR_DZF, HW_H_SIMM16, HW_H_UIMM16
 , HW_H_UIMM6, HW_H_ATOMIC_RESERVE, HW_H_ATOMIC_ADDRESS, HW_MAX
} CGEN_HW_TYPE;

#define MAX_HW ((int) HW_MAX)

/* Operand attribute indices.  */

/* Enum declaration for cgen_operand attrs.  */
typedef enum cgen_operand_attr {
  CGEN_OPERAND_VIRTUAL, CGEN_OPERAND_PCREL_ADDR, CGEN_OPERAND_ABS_ADDR, CGEN_OPERAND_SIGN_OPT
 , CGEN_OPERAND_SIGNED, CGEN_OPERAND_NEGATIVE, CGEN_OPERAND_RELAX, CGEN_OPERAND_SEM_ONLY
 , CGEN_OPERAND_END_BOOLS, CGEN_OPERAND_START_NBOOLS = 31, CGEN_OPERAND_MACH, CGEN_OPERAND_END_NBOOLS
} CGEN_OPERAND_ATTR;

/* Number of non-boolean elements in cgen_operand_attr.  */
#define CGEN_OPERAND_NBOOL_ATTRS (CGEN_OPERAND_END_NBOOLS - CGEN_OPERAND_START_NBOOLS - 1)

/* cgen_operand attribute accessor macros.  */
#define CGEN_ATTR_CGEN_OPERAND_MACH_VALUE(attrs) ((attrs)->nonbool[CGEN_OPERAND_MACH-CGEN_OPERAND_START_NBOOLS-1].nonbitset)
#define CGEN_ATTR_CGEN_OPERAND_VIRTUAL_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_OPERAND_VIRTUAL)) != 0)
#define CGEN_ATTR_CGEN_OPERAND_PCREL_ADDR_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_OPERAND_PCREL_ADDR)) != 0)
#define CGEN_ATTR_CGEN_OPERAND_ABS_ADDR_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_OPERAND_ABS_ADDR)) != 0)
#define CGEN_ATTR_CGEN_OPERAND_SIGN_OPT_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_OPERAND_SIGN_OPT)) != 0)
#define CGEN_ATTR_CGEN_OPERAND_SIGNED_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_OPERAND_SIGNED)) != 0)
#define CGEN_ATTR_CGEN_OPERAND_NEGATIVE_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_OPERAND_NEGATIVE)) != 0)
#define CGEN_ATTR_CGEN_OPERAND_RELAX_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_OPERAND_RELAX)) != 0)
#define CGEN_ATTR_CGEN_OPERAND_SEM_ONLY_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_OPERAND_SEM_ONLY)) != 0)

/* Enum declaration for or1k operand types.  */
typedef enum cgen_operand_type {
  OR1K_OPERAND_PC, OR1K_OPERAND_SYS_SR, OR1K_OPERAND_SYS_ESR0, OR1K_OPERAND_SYS_EPCR0
 , OR1K_OPERAND_SYS_SR_LEE, OR1K_OPERAND_SYS_SR_F, OR1K_OPERAND_SYS_SR_CY, OR1K_OPERAND_SYS_SR_OV
 , OR1K_OPERAND_SYS_SR_OVE, OR1K_OPERAND_SYS_CPUCFGR_OB64S, OR1K_OPERAND_SYS_CPUCFGR_ND, OR1K_OPERAND_SYS_FPCSR_RM
 , OR1K_OPERAND_MAC_MACHI, OR1K_OPERAND_MAC_MACLO, OR1K_OPERAND_ATOMIC_RESERVE, OR1K_OPERAND_ATOMIC_ADDRESS
 , OR1K_OPERAND_UIMM6, OR1K_OPERAND_RD, OR1K_OPERAND_RA, OR1K_OPERAND_RB
 , OR1K_OPERAND_DISP26, OR1K_OPERAND_SIMM16, OR1K_OPERAND_UIMM16, OR1K_OPERAND_SIMM16_SPLIT
 , OR1K_OPERAND_UIMM16_SPLIT, OR1K_OPERAND_RDSF, OR1K_OPERAND_RASF, OR1K_OPERAND_RBSF
 , OR1K_OPERAND_RDDF, OR1K_OPERAND_RADF, OR1K_OPERAND_RBDF, OR1K_OPERAND_MAX
} CGEN_OPERAND_TYPE;

/* Number of operands types.  */
#define MAX_OPERANDS 31

/* Maximum number of operands referenced by any insn.  */
#define MAX_OPERAND_INSTANCES 9

/* Insn attribute indices.  */

/* Enum declaration for cgen_insn attrs.  */
typedef enum cgen_insn_attr {
  CGEN_INSN_ALIAS, CGEN_INSN_VIRTUAL, CGEN_INSN_UNCOND_CTI, CGEN_INSN_COND_CTI
 , CGEN_INSN_SKIP_CTI, CGEN_INSN_DELAY_SLOT, CGEN_INSN_RELAXABLE, CGEN_INSN_RELAXED
 , CGEN_INSN_NO_DIS, CGEN_INSN_PBB, CGEN_INSN_DELAYED_CTI, CGEN_INSN_NOT_IN_DELAY_SLOT
 , CGEN_INSN_FORCED_CTI, CGEN_INSN_END_BOOLS, CGEN_INSN_START_NBOOLS = 31, CGEN_INSN_MACH
 , CGEN_INSN_END_NBOOLS
} CGEN_INSN_ATTR;

/* Number of non-boolean elements in cgen_insn_attr.  */
#define CGEN_INSN_NBOOL_ATTRS (CGEN_INSN_END_NBOOLS - CGEN_INSN_START_NBOOLS - 1)

/* cgen_insn attribute accessor macros.  */
#define CGEN_ATTR_CGEN_INSN_MACH_VALUE(attrs) ((attrs)->nonbool[CGEN_INSN_MACH-CGEN_INSN_START_NBOOLS-1].nonbitset)
#define CGEN_ATTR_CGEN_INSN_ALIAS_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_INSN_ALIAS)) != 0)
#define CGEN_ATTR_CGEN_INSN_VIRTUAL_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_INSN_VIRTUAL)) != 0)
#define CGEN_ATTR_CGEN_INSN_UNCOND_CTI_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_INSN_UNCOND_CTI)) != 0)
#define CGEN_ATTR_CGEN_INSN_COND_CTI_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_INSN_COND_CTI)) != 0)
#define CGEN_ATTR_CGEN_INSN_SKIP_CTI_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_INSN_SKIP_CTI)) != 0)
#define CGEN_ATTR_CGEN_INSN_DELAY_SLOT_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_INSN_DELAY_SLOT)) != 0)
#define CGEN_ATTR_CGEN_INSN_RELAXABLE_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_INSN_RELAXABLE)) != 0)
#define CGEN_ATTR_CGEN_INSN_RELAXED_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_INSN_RELAXED)) != 0)
#define CGEN_ATTR_CGEN_INSN_NO_DIS_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_INSN_NO_DIS)) != 0)
#define CGEN_ATTR_CGEN_INSN_PBB_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_INSN_PBB)) != 0)
#define CGEN_ATTR_CGEN_INSN_DELAYED_CTI_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_INSN_DELAYED_CTI)) != 0)
#define CGEN_ATTR_CGEN_INSN_NOT_IN_DELAY_SLOT_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_INSN_NOT_IN_DELAY_SLOT)) != 0)
#define CGEN_ATTR_CGEN_INSN_FORCED_CTI_VALUE(attrs) (((attrs)->bool_ & (1 << CGEN_INSN_FORCED_CTI)) != 0)

/* cgen.h uses things we just defined.  */
#include "opcode/cgen.h"

extern const struct cgen_ifld or1k_cgen_ifld_table[];

/* Attributes.  */
extern const CGEN_ATTR_TABLE or1k_cgen_hardware_attr_table[];
extern const CGEN_ATTR_TABLE or1k_cgen_ifield_attr_table[];
extern const CGEN_ATTR_TABLE or1k_cgen_operand_attr_table[];
extern const CGEN_ATTR_TABLE or1k_cgen_insn_attr_table[];

/* Hardware decls.  */

extern CGEN_KEYWORD or1k_cgen_opval_h_fsr;
extern CGEN_KEYWORD or1k_cgen_opval_h_fdr;
extern CGEN_KEYWORD or1k_cgen_opval_h_gpr;

extern const CGEN_HW_ENTRY or1k_cgen_hw_table[];



#endif /* OR1K_CPU_H */
