/* pr13212.c -- LD_PRELOAD this library to work-around GCC pr 13212.
   Copyright (C) 2006  Red Hat, Inc.

This file is part of java-gcj-compat.

java-gcj-compat is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

java-gcj-compat is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with java-gcj-compat; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version.  */

#define _GNU_SOURCE
#include <dlfcn.h>
#include <stdlib.h>
#include <pthread.h>

// A pointer to the real pthread_create

static int (*pthread_create_) (pthread_t *__restrict __newthread,
			       __const pthread_attr_t *__restrict __attr,
			       void *(*__start_routine) (void *),
			       void *__restrict __arg);


// The Boehm collector's pthread_create wrapper.
extern int GC_pthread_create (pthread_t *__restrict __newthread,
			      __const pthread_attr_t *__restrict __attr,
			      void *(*__start_routine) (void *),
			      void *__restrict __arg);

// The start routine used by the Boehm collector.  We'll use this to 
// recognize pthread_create calls made by the collector's wrapper.
extern void *GC_start_routine (void *);


/* Force constr to execute prior to main().  */
static void constr (void) __attribute__ ((constructor));

static void
constr (void)
{
  /* Get a pointer to the real pthread_create().  */
  pthread_create_ = dlsym (RTLD_NEXT, "pthread_create");

  if (pthread_create_ == NULL)
    abort ();
}

/** Wrap the pthread_create function.  */
int pthread_create (pthread_t *__restrict __newthread,
		    __const pthread_attr_t *__restrict __attr,
		    void *(*__start_routine) (void *),
		    void *__restrict __arg)
{
  // Call the real pthread_create() if we're called from boehm's wrapper,
  // and call boehm's wrapper otherwise.
  if (__start_routine == GC_start_routine)
    return pthread_create_ (__newthread, __attr, __start_routine, __arg);
  else
    return GC_pthread_create (__newthread, __attr, __start_routine, __arg);
}
