;; install.scm - Run `make install' and interpret output.
;; Written by Tom Tromey <tromey@cygnus.com>

(use-modules (ice-9 expect) (ice-9 regex))

(define (install-subpackage package)
  (let* ((install (lib-program "install-sh"))
	 (mkinstalldirs (lib-program "mkinstalldirs"))
	 (echo "echo")
	 (magic "-=-=-=-= ")

	 (normal "NORMAL")
	 (pre "PRE")
	 (post "POST")

	 (destdir (local-directory (get-name package)))

	 (scan-mode normal)

	 (expect-port
	  (open-input-pipe (string-append
			    "make"	; FIXME: configure?
			    " "
			    "NORMAL_INSTALL='" echo magic normal "' "
			    "PRE_INSTALL='" echo magic pre "' "
			    "POST_INSTALL='" echo magic post "' "
			    "mkinstalldirs='" mkinstalldirs "' "
			    "INSTALL='" install " -c' "
			    ;; FIXME: other install variables.
			    "DESTDIR='" destdir "' "
			    "install 2>&1"))))

    (while (char-ready? expect-port)
	   (expect-strings
	    ;; Recognize a mode change.
	    ((string-append "^" (regexp-quote magic)
			    "(" normal "|" pre "|" post ")\n")
	     => (lambda (all mode)
		  (set! scan-mode mode)))

	    ;; Recognize a `mkinstalldirs' command.
	    ((string-append "^[ ]*" (regexp-quote mkinstalldirs) " (.*)\n")
	     => (lambda (all dir)
		  (add-install-directory package dir)))

	    ;; Recognize an install command.
	    ((string-append "^[ ]*" (regexp-quote install)
			    " (.*) "	    ; Options.
			    "([^ ]*) "	    ; Source file.
			    (regexp-quote destdir) "/(.*)\n") ; Install file.
	     => (lambda (all options source-file install-file)
		  (add-install-file install-file)))

	    ;; Ignore some stuff.
	    ("^(Making|make[^:]*:) .*\n" => (lambda args #f))

	    ;; mkinstalldirs prints these lines.
	    ("^mkdir .*\n" => (lambda args #f))
	    
	    ;; Disposition of other lines depends on mode.
	    ("^[ \t]*(.*)[ \t]*\n"
	     => (lambda (all command)
		  (cond
		   ((equal? scan-mode "NORMAL")
		    (error "Unrecognized command in normal install"))

		   ((equal? scan-mode "PRE")
		    (add-pre-install-command command))

		   ((equal? scan-mode "POST")
		    (add-post-install-command command))

		   (#t
		    (error "Unrecognized scan mode!")))))))

    ;; FIXME: handle return value.
    (close-pipe expect-port)))
