;; make.scm - run `make' and understand its output.
;; Written by Tom Tromey <tromey@cygnus.com>

(use-modules (ice-9 expect) (ice-9 regex))

;; (set-up-path)

(define ignore
  (lambda args #f))

(define (print arg . args)
  (display arg)
  (if (null? args)
      (display "\n")
      (print args)))

(let ((install "/usr/bin/install") ;; (find-program "install"))
      (mkinstalldirs "/bin/sh ../../automake/mkinstalldirs");;  (find-program "mkinstalldirs"))
      (echo "echo")
      (magic "-=-=-=-= ")
      (normal "NORMAL")
      (pre "PRE")
      (post "POST")

      ;; Variables used by scanner.
      (scan-directory '())
      (scan-mode "NORMAL")

      (destdir "/home/tromey/gnu/egcs/automake/build/fred/usr/local")

      )


;  (scan-output
;   `("make"
;     ,(string-append "NORMAL_INSTALL=" echo magic normal)
;     ,(string-append "PRE_INSTALL=" echo magic pre)
;     ,(string-append "POST_INSTALL=" echo magic post)
;     ,(string-append "mkinstalldirs=" mkinstalldirs)
;     ,(string-append "install=" install)
;     ,(string-append "DESTDIR=" destdir)
;     "install")

(with-input-from-file "Make-out"

   (lambda ()
     (while (char-ready?)
	    (expect-strings
	     ;; Recognize a mode change.
	     ((string-append "^" (regexp-quote magic)
			     "(" normal "|" pre "|" post ")\n")
	      => (lambda (all mode)
		   (print "Entering mode " mode)
		   (set! scan-mode ;; (string->symbol mode)
			 mode)))

	     ;; Recognize directory change.
	     ("^make[^:]*: Entering directory `([^']*)'\n"
	      => (lambda (all dir)
		   (set! scan-directory dir)))

	     ;; Recognize a `mkinstalldirs' command.
	     ((string-append "^[ ]*" (regexp-quote mkinstalldirs) " (.*)\n")
	      => (lambda (all dir)
		   ;; (add-install-directory! dir)
		   (print "Directory now " dir)
		   ))

	     ;; Recognize an install command.
	     ((string-append "^[ ]*" (regexp-quote install)
			     " (.*) "	    ; Options.
			     "([^ ]*) "	    ; Source file.
			     (regexp-quote destdir) "/(.*)\n") ; Install file.
	      => (lambda (all options source-file install-file)
		   (print "install " source-file "  as  " install-file)
		   ))

	     ;; Ignore some stuff.
	     ("^(Making|make[^:]*:) .*\n" => ignore)

	     ;; mkinstalldirs prints these lines.
	     ("^mkdir .*\n" => ignore)
	     
	     ;; Disposition of other lines depends on mode.
	     ("^[ \t]*(.*)[ \t]*\n"
	      => (lambda (all command)
		   (print scan-mode " => " command))))))

)
)
