/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XStoreColor(display, colormap, color)
 *   Display	*display;
 *   Colormap colormap;
 *   XColor *color;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XStoreColor	1
char    *TestName = "XStoreColor";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_COLORMAP colormap


/*
 * Arguments to the XStoreColor function
 */
static Display	*display;
static Colormap colormap;
static XColor *color;


XColor dummycol;

#define lowbit(x)		((x) & (~(x) + 1))
#define bitcontig(x)	((((x) + lowbit(x)) & (x)) == 0)
#define bitsubset(a,b)	(((a) & (b)) == (a))

static int
maskshift(mask)
register unsigned long mask;
{
register int i;

	for (i = 0; mask; i++) {
		if (mask & 0x1)
			return i;
		mask >>= 1;
	}
	return i;
}

static int ncolors = 0;

static
Bool set_one_col(refp, s, flags, mask)
	unsigned long *refp;
	char *s;
	char flags;
	unsigned long mask;
{
	unsigned long i;
	XColor *cp1;
	XColor *save_col = color; /* for restoring color, later */
	unsigned long *lrefp = refp;
	int fail = 0; /* used in the FAIL in XCall (spelt wrong intentionally) */
	/* expects to find color and ncolors in-scope */

	for(i=0, cp1 = color; i < ncolors; i++, cp1++) {
		unsigned long subfield_ix = i << maskshift(mask);

		if (!bitsubset(subfield_ix, mask)) {
			delete("Inconsistent maxsize() result: size of %d is too big to fit into %s mask 0x%lx (detected at index %lu, giving pixel 0x%lx)",
				ncolors, s, mask, i, subfield_ix);
			return False;
		}
		cp1->pixel = subfield_ix;
		cp1->flags = flags;
		switch (flags) {
		case DoRed:
			cp1->red = i;
			break;
		case DoGreen:
			cp1->green = i;
			break;
		case DoBlue:
			cp1->blue = i;
			break;
		default:
			delete("Flags 0x%x has more than one colour in it.", (unsigned int)flags);
			color = save_col;
			return False;
		}
		color = cp1;
		/* The following may generate a warning about the return; */
		startcall(display);
		if (isdeleted())
			return;
		XStoreColor(display, colormap, color);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
	}
	color = save_col;
	XQueryColors(display, colormap, color, ncolors);
	for(i=0,cp1=color,lrefp=refp; i < ncolors; i++, lrefp++, cp1++) {
		*lrefp = (flags==DoRed) ? cp1->red :
				((flags==DoGreen) ? cp1->green : cp1->blue);
	}
	return (geterr() == Success);
}

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	colormap = DefaultColormap(display, DefaultScreen(display));
	color = &dummycol;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

XVisualInfo *vp;
XColor		testcol, storedcol, savedcol;
unsigned long vmask = (1<<DirectColor)|(1<<PseudoColor)|(1<<GrayScale);
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XStoreColor-1.(C)");
	report_assertion("If any of the visual classes DirectColor, PseudoColor or");
	report_assertion("Grayscale is supported: A call to XStoreColor obtains the");
	report_assertion("closest available RGB values for the colormap argument to");
	report_assertion("those specified in the red, green and blue components of");
	report_assertion("the XColor structure named by the color argument, and stores");
	report_assertion("those values in the read-write colourmap entry specified by");
	report_assertion("the pixel components of the XColor structure.");

	report_strategy("For each visual class DirectColor, PseudoColor and GrayScale:");
	report_strategy("  Create a colormap with alloc set to AllocAll.");
	report_strategy("  Store the color r = 0xffff g = 0xf1f0 b = 0x0ff8 at cell 0.");
	report_strategy("  Obtain the rbg values of the stored color with XQueryColor.");
	report_strategy("  Store the returned rgb values in cell 0");
	report_strategy("  Obtain the stored values with XQueryColor.");
	report_strategy("  Verify the rgb values stored in both cases were identical.");

	tpstartup();
	setargs();
	if( (vmask = visualsupported(display, vmask)) == 0L) {
		unsupported("DirectColor, PseudoColor and GrayScale are not supported");
		return;
	}

	storedcol.pixel = 0L;
	testcol.pixel = 0L;
	testcol.red = 0xffff;
	testcol.green = 0xf1f0;
	testcol.blue = 0x0ff8;
	testcol.flags = DoRed|DoGreen|DoBlue;

	for(resetsupvis(vmask); nextsupvis(&vp); ) {
		colormap = makecolmap(display, vp->visual, AllocAll);
		color = &testcol;
		startcall(display);
		if (isdeleted())
			return;
		XStoreColor(display, colormap, color);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
		XQueryColor(display, colormap, &storedcol);
		savedcol = storedcol;
		color = &storedcol;
		startcall(display);
		if (isdeleted())
			return;
		XStoreColor(display, colormap, color);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
		XQueryColor(display, colormap, &testcol);
		
		if( (savedcol.red != testcol.red) || (savedcol.green != testcol.green) || (savedcol.blue != testcol.blue) ) {
			report("XStoreColor() return RGB values r %u g %u b %u instead of r %u g %u b %u.", 
				savedcol.red, savedcol.green, savedcol.blue, testcol.red, testcol.green, testcol.blue);
			FAIL;
		} else
			CHECK;
	}
	CHECKPASS(nsupvis());

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

XVisualInfo *vp;
int 		i;
XColor		namedcol, testcol, storedcol;
unsigned long 	vmask = (1<<DirectColor)|(1<<PseudoColor)|(1<<GrayScale);
unsigned short	redval, greenval, blueval;
char		flags;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XStoreColor-2.(C)");
	report_assertion("If any of the visual classes DirectColor, PseudoColor or");
	report_assertion("GrayScale is supported: A call to XStoreColor changes the");
	report_assertion("red, green and blue values in the read-write colourmap entry");
	report_assertion("in accordance with the flags component of the XColor");
	report_assertion("structure named by the color argument.");

	report_strategy("For each supported visual class DirectColor, PseudoColor and GrayScale:");
	report_strategy("  Create a colormap with XCreateColormap.");
	report_strategy("  Store the color r = 0xffff g = 0xf1f0 b = 0x0ff8 at cell 0 with XStoreColor.");
	report_strategy("  Obtain the r,g and b values with XQueryColor.");
	report_strategy("  For each possible combination DoRed, DoGreen and DoBlue in flags:");
	report_strategy("    Store the bitwise complementary rgb values in the same cell with XStoreColor.");
	report_strategy("    Store the color r = 0xffff g = 0xf1f0 b = 0x0ff8 at cell 0 with XStoreColor.");
	report_strategy("    Verify that only the components of the colourcell specified by the flags value have been altered with XQueryColor.");
	report_strategy("");

	tpstartup();
	setargs();
	if( (vmask = visualsupported(display, vmask)) == 0L) {
		UNSUPPORTED;
		return;
	}

	for(resetsupvis(vmask); nextsupvis(&vp); ) {

		testcol.pixel = 0L;
		testcol.red = 0xffff;
		testcol.green = 0xf1f0;
		testcol.blue = 0x0ff8;
		testcol.flags = DoRed|DoGreen|DoBlue;
	
		color = &testcol;
		colormap = makecolmap(display, vp->visual, AllocAll);
		startcall(display);
		if (isdeleted())
			return;
		XStoreColor(display, colormap, color);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		namedcol.pixel = 0L;
		XQueryColor(display, colormap, &namedcol);     /* named color has expected r,g,b values.*/

		testcol = namedcol;
		testcol.red ^= 0xffff;
		testcol.green ^= 0xffff;
		testcol.blue ^= 0xffff;
		testcol.flags = DoRed|DoGreen|DoBlue;
		color = &testcol;
		startcall(display);
		if (isdeleted())
			return;
		XStoreColor(display, colormap, color);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
		XQueryColor(display, colormap, &testcol);      /* test color has the unexpected rgb vals */

		for(i=0; i<8; i++) {

			flags = 0;

			if(i&DoRed) {
				flags |= DoRed;
				redval = namedcol.red;
			} else
				redval = testcol.red;

			if(i&DoGreen) {
				flags |= DoGreen;
				greenval = namedcol.green;
			} else
				greenval = testcol.green;

			if(i&DoBlue) {
				flags |= DoBlue;
				blueval = namedcol.blue;
			} else
				blueval = testcol.blue;

			testcol.flags = DoRed|DoGreen|DoBlue;
			color = &testcol;
			startcall(display);
			if (isdeleted())
				return;
			XStoreColor(display, colormap, color);    /* Sore the inv colours */
			endcall(display);
			if (geterr() != Success) {
				report("Got %s, Expecting Success", errorname(geterr()));
				FAIL;
			}

			namedcol.flags = flags;
			color = &namedcol;
			startcall(display);
			if (isdeleted())
				return;
			XStoreColor(display, colormap, color);
			endcall(display);
			if (geterr() != Success) {
				report("Got %s, Expecting Success", errorname(geterr()));
				FAIL;
			}
			storedcol.pixel = 0L;
			storedcol.flags =  DoRed|DoGreen|DoBlue;
			XQueryColor(display, colormap, &storedcol);

			if( (redval != storedcol.red) || (greenval != storedcol.green) || (blueval != storedcol.blue) ) {
				report("XStoreColor() flags = %d RGB value r %u g %u b %u instead of r %u g %u b %u.", 
					(int) i,
					storedcol.red, storedcol.green, storedcol.blue, redval, greenval, blueval);
					FAIL;
				} else
					CHECK;
		}
	}

	CHECKPASS(i*nsupvis());

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.3596 */
static void t003(){

int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XStoreColor-3.(D)");
	report_assertion("If any of the visual classes DirectColor, PseudoColor or");
	report_assertion("GrayScale is supported: When the colormap is an installed");
	report_assertion("colourmap for its screen, then any changes made by a call to");
	report_assertion("XStoreColor are visible immediately.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.3596 */

static void t004(){

XVisualInfo	*vp;
XColor		testcol;
unsigned long	vmask = (1<<DirectColor)|(1<<PseudoColor)|(1<<GrayScale);
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XStoreColor-4.(C)");
	report_assertion("If any of the visual classes DirectColor, PseudoColor or");
	report_assertion("GrayScale is supported: When the pixel component in the");
	report_assertion("XColor structure named by the color argument is not a valid");
	report_assertion("entry in the colormap argument, then a BadValue error");
	report_assertion("occurs.");

	report_strategy("For each visual class DirectColor, PseudoColor and GrayScale:");
	report_strategy("  Create a colourmap with alloc set to AllocAll.");
	report_strategy("  Store the color r = 0xffff g = 0xf1f0 b = 0x0ff8 using XStoreColor with pixel = colormap_size.");
	report_strategy("  Verify that a BadValue error is generated.");

	tpstartup();
	setargs();
	if( (vmask = visualsupported(display, vmask)) == 0L) {
		UNSUPPORTED;
		return;
	}

	testcol.red = 0xffff;
	testcol.green = 0xf1f0;
	testcol.blue = 0x0ff8;
	color = &testcol;
	for(resetsupvis(vmask); nextsupvis(&vp); ) {
		colormap = makecolmap(display, vp->visual, AllocAll);
		testcol.pixel = maxsize(vp) + 1;
		if (vp->class == DirectColor) {
			testcol.pixel = (vp->red_mask | vp->blue_mask | vp->green_mask);
			testcol.pixel |= testcol.pixel << 1;
		}
		trace("Testing with pixel set to > colormap_size (%ld).",testcol.pixel);
		
		startcall(display);
		if (isdeleted())
			return;
		XStoreColor(display, colormap, color);
		endcall(display);
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
		}
		if(geterr() == BadValue)
			CHECK;

	}

	CHECKPASS(nsupvis());

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/EAcc3.mc */
/* End of included file error/EAcc3.mc */

static void t005(){

XVisualInfo	*vp;
XColor		testcol;
Display		*disp2;
unsigned long	i;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XStoreColor-5.(A)");
	report_assertion("When an attempt to store into a read-only or an unallocated");
	report_assertion("colormap entry is made, then a BadAccess error occurs.");

	report_strategy("For all visuals:");
	report_strategy("  Create a colormap with alloc set to AllocNone. (Unallocated for visual");
	report_strategy("	classes DirectColor, PseudoColor and GrayScale; R/O for visual");
	report_strategy("	classes TrueColor, StaticColor and StaticGray: all should");
	report_strategy("	provoke BadAccess)");
	report_strategy("  For each colormap cell:");
	report_strategy("    Store the color r = 0xffff g = 0xf1f0 b = 0x0ff8 using XStoreColor.");
	report_strategy("    Verify that a BadAccess error is generated.");
	report_strategy("  Create a new client with XOpenDisplay.");
	report_strategy("  Allocate a readonly cell for the new client with XAllocColor.");
	report_strategy("  Store a value in the cell with XStoreColor.");
	report_strategy("  Verify that a BadAccess error occurred.");
	report_strategy("  Allocate a readonly cell with XAllocColor.");
	report_strategy("  Store a value in the cell with XStoreColor.");
	report_strategy("  Verify that a BadAccess error occurred.");

	tpstartup();
	setargs();
	for(resetvinf(VI_WIN); nextvinf(&vp); ) {
	
		testcol.red = 0xffff;
		testcol.green = 0xf1f0;
		testcol.blue = 0x0ff8;

		color = &testcol;

		colormap = makecolmap(display, vp->visual, AllocNone);
		trace("Testing a colormap with no allocated/just r-o cells.");
		for(i=0; i < maxsize(vp); i++) {
			testcol.pixel = i;
			startcall(display);
			if (isdeleted())
				return;
			XStoreColor(display, colormap, color);
			endcall(display);
			if (geterr() != BadAccess) {
				report("Got %s, Expecting BadAccess", errorname(geterr()));
				FAIL;
			}
			startcall(display);
			if (isdeleted())
				return;
			/* the XStoreColor(display, colormap, color) will have done a check for geterr() ==
			endcall(display);
			if (geterr() != BadAccess) {
				report("Got %s, Expecting BadAccess", errorname(geterr()));
				FAIL;
			}
			   BadAccess (c.f. arg. after CODE keyword above)
			   and will FAIL if not.
			*/
		}
		if(i == maxsize(vp))
			CHECK;

		disp2 = XOpenDisplay(config.display);
		if (!disp2) {
			delete("XOpenDisplay() failed.");
			return;
		}

		if(XAllocColor(disp2, colormap, &testcol) == False) {
			delete("XAllocColor() failed to allocate a r/o cell for a second client.");
			XCloseDisplay(disp2);
			return;
		} else
			CHECK;

		trace("Trying to write into a r/o cell allocated by another client.");
		color = &testcol;
		startcall(display);
		if (isdeleted())
			return;
		XStoreColor(display, colormap, color);
		endcall(display);
		if (geterr() != BadAccess) {
			report("Got %s, Expecting BadAccess", errorname(geterr()));
			FAIL;
		}
		if(geterr() == BadAccess)
			CHECK;

		testcol.red ^= 0xffff;
		testcol.green ^= 0xffff;
		testcol.blue ^= 0xffff;

		if(XAllocColor(display, colormap, &testcol) == False) {
			delete("XAllocColor() failed to allocate a r/o cell");
			XCloseDisplay(disp2);
			return;
		} else
			CHECK;

		trace("Trying to write into a r/o cell allocated by self.");
		color = &testcol;
		startcall(display);
		if (isdeleted())
			return;
		XStoreColor(display, colormap, color);
		endcall(display);
		if (geterr() != BadAccess) {
			report("Got %s, Expecting BadAccess", errorname(geterr()));
			FAIL;
		}
		if(geterr() == BadAccess)
			CHECK;

		XCloseDisplay(disp2);
	}

	CHECKPASS(5*nvinf());
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/ECol.mc */
/* End of included file error/ECol.mc */

/* Including from file error/ECol.mc */
static void t006(){

int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XStoreColor-6.(A)");
	report_assertion("When a colourmap argument does not name a valid colourmap,");
	report_assertion("then a BadColor error occurs.");

	report_strategy("Create a bad colourmap by creating and freeing a colourmap.");
	report_strategy("Call test function using bad colourmap as the colourmap argument.");
	report_strategy("Verify that a BadColor error occurs.");

	tpstartup();
	setargs();
	A_COLORMAP = badcolormap(A_DISPLAY, DRW(A_DISPLAY));
	startcall(display);
	if (isdeleted())
		return;
	XStoreColor(display, colormap, color);
	endcall(display);
	if (geterr() != BadColor) {
		report("Got %s, Expecting BadColor", errorname(geterr()));
		FAIL;
	}
	if(geterr() == BadColor)
		PASS;
	else 
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/ECol.mc */

/* Including from file Mdefcode.tmc.3596 */
static void t007(){

int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XStoreColor-7.(D)");
	report_assertion("When rmask_return, gmask_return and bmask_return have been");
	report_assertion("returned by a previous call to XAllocColorPlanes and a");
	report_assertion("read-write colourmap entry for a pixel value is changed by a");
	report_assertion("call to XStoreColor, then the pixel value is decomposed");
	report_assertion("into three components using the masks and the independent");
	report_assertion("colourmap entries are updated.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.3596 */

static void t008(){

XVisualInfo 	*vp;
unsigned long 	vmask = (1<<DirectColor);
XColor		*colors;
unsigned long	i;
XColor		*refp;
unsigned long	*reds, *greens, *blues;
int		pathcnt = 0;
static XColor triples[] = {
		{ ~0UL, 0,0,0, DoRed|DoGreen|DoBlue, 0 },
		{ ~0UL, 1,0,0, DoRed|DoGreen|DoBlue, 0 },
		{ ~0UL, 0,1,0, DoRed|DoGreen|DoBlue, 0 },
		{ ~0UL, 0,0,1, DoRed|DoGreen|DoBlue, 0 },
		{ ~0UL, 3,2,1, DoRed|DoGreen|DoBlue, 0 },
		{ ~0UL, 1,3,0, DoRed|DoGreen|DoBlue, 0 },
		{ ~0UL, 7,3,1, DoRed|DoGreen|DoBlue, 0 },
		{ ~0UL, 7,8,5, DoRed|DoGreen|DoBlue, 0 },
		{ ~0UL, 15,11,12, DoRed|DoGreen|DoBlue, 0 },
		{ ~0UL, 42,99,13, DoRed|DoGreen|DoBlue, 0 },
		{ ~0UL, 112,127,64, DoRed|DoGreen|DoBlue, 0 },
		{ ~0UL, 255,64,33, DoRed|DoGreen|DoBlue, 0 },
		{ ~0UL, 64,255,33, DoRed|DoGreen|DoBlue, 0 },
		{ ~0UL, 64,33,255, DoRed|DoGreen|DoBlue, 0 },
		{ ~0UL, 255,255,255, DoRed|DoGreen|DoBlue, 0 },
	};
int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion XStoreColor-8.(C)");
	report_assertion("If the visual class DirectColor is supported: When the");
	report_assertion("colormap argument was created with visual type DirectColor");
	report_assertion("and with alloc set to AllocAll, and a read-write colourmap");
	report_assertion("entry for a pixel value is changed by a call to XStoreColor,");
	report_assertion("then the pixel value is decomposed into three components");
	report_assertion("using the red_mask, green_mask and blue_mask in the visual");
	report_assertion("and the independent colourmap entries are updated.");

	report_strategy("If visual class DirectColor is supported:");
	report_strategy("   Create a colourmap using makecolmap and AlocAll");
	report_strategy("   Allocate an array of XColor's and one for each of reds, greens & blues");
	report_strategy("   Set up each of reds, greens & blues to have a distinguishable value,");
	report_strategy("     using XStoreColor, and make sure that's what's in the equivalent colourmaps.");
	report_strategy("   Read back some suitably \"random\" triples and check their components");
	report_strategy("   Verify that each component is the same as the corresponding entry in");
	report_strategy("     reds, greens & blues.");
	report_strategy("   Free the allocated storage: colors, reds, greens & blues.");

	tpstartup();
	setargs();
/* If visual class DirectColor is supported: */
	if( (vmask = visualsupported(display, vmask)) == 0L) {
		UNSUPPORTED;
		return;
	}

	for(resetsupvis(vmask); nextsupvis(&vp); ) {

/*    Create a colourmap using makecolmap and AlocAll */
		colormap = makecolmap(display, vp->visual, AllocAll);
		ncolors = maxsize(vp);
/*    Allocate an array of XColor's and one for each of reds, greens & blues */
		colors = (XColor *) malloc(ncolors * sizeof(XColor));
		color = colors;
		reds = (unsigned long *) malloc(ncolors * sizeof(unsigned long));
		greens = (unsigned long *) malloc(ncolors * sizeof(unsigned long));
		blues = (unsigned long *) malloc(ncolors * sizeof(unsigned long));
		if ((colors == (XColor *) 0) || (reds == (unsigned long *) 0) ||
				(greens == (unsigned long *) 0) ||
				(blues == (unsigned long *) 0)) {
			delete("malloc() couldn't allocate %d cells for the XColor array.", ncolors);
			return;
		} else
			CHECK;

	/* now it's safe to call set_one_col: color and ncolors are set. */


/*    Set up each of reds, greens & blues to have a distinguishable value, */
/*      using xname, and make sure that's what's in the equivalent colourmaps. */
		/*
		   kept in reds, greens or blues. This routine expects
		   color and ncolors to be set right. It uses XCall as well.
		*/
		if (!set_one_col(reds, "red", DoRed, vp->red_mask) ||
		    !set_one_col(greens, "green", DoGreen, vp->green_mask) ||
		    !set_one_col(blues, "blue", DoBlue, vp->blue_mask)
		   ) {
			delete("Failed to set up colourmap for test.");
			return;
		} else
			CHECK;

/*    Read back some suitably "random" triples and check their components */
		for (i=0, refp=triples; i < NELEM(triples); i++, refp++) {
			XColor testcol;
			unsigned long r,g,b;

			if (refp->red >= (unsigned)ncolors ||
					refp->green >= (unsigned)ncolors ||
					refp->blue >= (unsigned)ncolors)
				continue;

			r = refp->red << maskshift(vp->red_mask);
			if (!bitsubset(r, vp->red_mask))
				continue;
			g = refp->green << maskshift(vp->green_mask);
			if (!bitsubset(g, vp->green_mask))
				continue;
			b = refp->blue << maskshift(vp->blue_mask);
			if (!bitsubset(b, vp->blue_mask))
				continue;
			testcol.pixel = r | g | b;

			XQueryColor(display, colormap, &testcol);

/*    Verify that each component is the same as the corresponding entry in */
/*      reds, greens & blues. */
			if (testcol.flags != (DoRed | DoGreen | DoBlue) ||
			    testcol.red != reds[refp->red] ||
			    testcol.green != greens[refp->green] ||
			    testcol.blue != blues[refp->blue]) {
				report("Expected r,g,b = %lu, %lu, %lu but got %lu, %lu, %lu for pixel 0x%lx with r-,g-,b-masks 0x%lx, 0x%lx, 0x%lx",
					reds[refp->red], greens[refp->green], blues[refp->blue],
					testcol.red, testcol.green, testcol.blue,
					testcol.pixel, vp->red_mask,
					vp->green_mask, vp->blue_mask);
				FAIL;
			} else
				CHECK;

			pathcnt++;
		}

/*    Free the allocated storage: colors, reds, greens & blues. */
		free((char*)colors);
		free((char*)reds);
		free((char*)greens);
		free((char*)blues);
	}

	CHECKPASS(pathcnt+2*nsupvis());
			

	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
