/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   Widget
 *   XtVaCreatePopupShell()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>
#include <X11/ShellP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;
ShellWidget menuw;
Widget labelw_good;
Widget pushb_good, rowcolw_good;

/*timeout callback*/
void XtTI_Proc(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
	if (menuw->shell.popped_up == False) {
		tet_infoline("ERROR: Shell is not popped up");
		tet_result(TET_FAIL);
	}
	exit(0);
}

void XtCBP_Proc(w, client_data, call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	avs_set_event(1,1);
	exit(0);
}



#define T_XtVaCreatePopupShell	1
char    *TestName = "XtVaCreatePopupShell";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

int status = 0;
pid_t pid2;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtVaCreatePopupShell-1.(A)");
	report_assertion("A successful call to Widget XtVaCreatePopupShell(name,");
	report_assertion("widget_class, parent,...) shall create a pop-up shell");
	report_assertion("widget belonging to the class widget_class, name the widget");
	report_assertion("instance as name, make it a pop-up child of parent, and");
	report_assertion("return a pointer to the pop-up shell widget instance");
	report_assertion("structure.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tvacrpsh1", "XtVaCreatePopupShell");
	tet_infoline("PREP: Create labelw_good widget");
	labelw_good = (Widget) CreateLabelWidget("ApTest", boxw1);
	tet_infoline("TEST: Create a popup shell");
	menuw = (ShellWidget)XtVaCreatePopupShell("menuw", overrideShellWidgetClass, labelw_good, NULL);
	tet_infoline("PREP: Create a rowcolw_good widget");
	rowcolw_good = (Widget) CreateRowColWidget((Widget)menuw);
	tet_infoline("PREP: Create pushb_good button Hello in rowcolw_good widget");
	pushb_good = (Widget) CreatePushButtonGadget( "Hello", rowcolw_good);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, &XtTI_Proc, NULL);
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Map a Pop-up shell.");
	XtPopup((Widget)menuw, XtGrabExclusive);
	tet_infoline("TEST: Shell is popped-up");
	XtAppMainLoop(app_ctext);
	KROF(pid2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.2592 */
/* End of included file Mdefcode.tmc.2592 */

static void t002(){

char label[80];
int status = 0;
pid_t pid2;
XtCallbackRec callbacks[2] = {
	{ (XtCallbackProc) XtCBP_Proc, (XtPointer) NULL },
	{ (XtCallbackProc) NULL, (XtPointer) NULL }
};
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtVaCreatePopupShell-2.(A)");
	report_assertion("When the resource XtNpopupCallback is specified, a call to");
	report_assertion("Widget XtVaCreatePopupShell(name, widget_class, parent,...)");
	report_assertion("shall register callback procedures on the shell's pop-up");
	report_assertion("callback list that shall be invoked when the widget is");
	report_assertion("popped up.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tvacrpshl2", "XtVaCreatePopupShell");
	tet_infoline("PREP: Create labelw_good widget Press Me");
	labelw_good = (Widget) CreateLabelWidget("Press Me", boxw1);
	tet_infoline("TEST: Create a vacrpshl shell");
	menuw = (ShellWidget)XtVaCreatePopupShell("menuw",
				overrideShellWidgetClass,
				labelw_good, 
				XtNpopupCallback,
				&callbacks[0],
				(char *)NULL);
	tet_infoline("PREP: Create a rowcolw_good widget");
	rowcolw_good = (Widget) CreateRowColWidget((Widget)menuw);
	tet_infoline("PREP: Create pushb_good button Hello in rowcolw_good widget");
	pushb_good = (Widget) CreatePushButtonGadget(
				"Hello",
				rowcolw_good);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Map a Pop-up shell.");
	XtPopup((Widget)menuw, XtGrabNone);
	XtAppMainLoop(app_ctext);
	KROF(pid2);
	tet_infoline("PREP: Procedure XtCBP_Proc was invoked.");
	status = avs_get_event(1);
	check_dec(1, status, "callback invocation count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.2592 */
/* End of included file Mdefcode.tmc.2592 */

static void t003(){

int status = 0;
pid_t pid2;
XtCallbackRec callbacks[2] = {
	{ (XtCallbackProc)XtCBP_Proc, (XtPointer) NULL },
	{ (XtCallbackProc) NULL, (XtPointer) NULL }
};
pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtVaCreatePopupShell-3.(A)");
	report_assertion("When the resource XtNpopdownCallback is specified, a call");
	report_assertion("to Widget XtVaCreatePopupShell(name, widget_class, parent,...)");
	report_assertion("shall register callback procedures on the shell's pop-down");
	report_assertion("callback list that shall be invoked when the widget is");
	report_assertion("popped down.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tvacrpshl3", "XtVaCreatePopupShell");
	tet_infoline("PREP: Create labelw_good widget Press Me");
	labelw_good = (Widget) CreateLabelWidget("Press Me", boxw1);
	tet_infoline("TEST: Create a vacrpshl shell");
	menuw = (ShellWidget)XtVaCreatePopupShell("menuw",
				overrideShellWidgetClass,
				labelw_good, 
				XtNpopdownCallback,
				&callbacks[0], (char *)NULL);
	tet_infoline("PREP: Create a rowcolw_good widget");
	rowcolw_good = (Widget) CreateRowColWidget((Widget)menuw);
	tet_infoline("PREP: Create pushb_good button Hello in rowcolw_good widget");
	pushb_good = (Widget) CreatePushButtonGadget(
				"Hello",
				rowcolw_good);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Map a Pop-up shell.");
	XtPopup((Widget)menuw, XtGrabNone);
	tet_infoline("PREP: UnMap a Pop-up shell.");
	XtPopdown((Widget)menuw);
	XtAppMainLoop(app_ctext);
	KROF(pid2);
	tet_infoline("TEST: Procedure XtCBP_Proc was invoked.");
	status = avs_get_event(1);
	check_dec(1, status, "callback invocation count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.2592 */
/* End of included file Mdefcode.tmc.2592 */

/* Including from file Mdefcode.tmc.2592 */
static void t004(){

pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtVaCreatePopupShell-4.(B)");
	report_assertion("A successful call to Widget XtVaCreatePopupShell(name,");
	report_assertion("widget_class, parent,...) when the varargs style variable");
	report_assertion("argument list specifies the XtNscreen argument shall create");
	report_assertion("the resource database for the pop-up shell widget using the");
	report_assertion("resource values specified in the varargs style arguments and");
	report_assertion("resource values from the resource database of the screen");
	report_assertion("specified by the XtNscreen argument for those resources not");
	report_assertion("specified in the variable argument list.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.2592 */

/* Including from file Mdefcode.tmc.2592 */
static void t005(){

pid_t	pid;

 	report_purpose(5);

	report_assertion("Assertion XtVaCreatePopupShell-5.(B)");
	report_assertion("A successful call to Widget XtVaCreatePopupShell(name,");
	report_assertion("widget_class, parent,...) when the variable argument list");
	report_assertion("does not specify the XtNscreen argument, and the resource");
	report_assertion("database associated with the parent's screen specifies the");
	report_assertion("resource name.screen, class class.screen where class is the");
	report_assertion("class_name field in the CoreClassPart of widget_class shall");
	report_assertion("create the resource database for the pop-up shell widget");
	report_assertion("using the resource values specified in the varargs style");
	report_assertion("arguments and resource values from the resource database of");
	report_assertion("the screen specified in the resource database of the");
	report_assertion("parent's screen for those resources not specified in the");
	report_assertion("variable argument list.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.2592 */

/* Including from file Mdefcode.tmc.2592 */
static void t006(){

pid_t	pid;

 	report_purpose(6);

	report_assertion("Assertion XtVaCreatePopupShell-6.(B)");
	report_assertion("A successful call to Widget XtVaCreatePopupShell(name,");
	report_assertion("widget_class, parent,...) when the variable argument list");
	report_assertion("does not specify the XtNscreen argument, and the resource");
	report_assertion("database associated with the parent's screen does not");
	report_assertion("specify the resource name.screen, class class.screen where");
	report_assertion("class is the class_name field in the CoreClassPart of");
	report_assertion("widget_class shall create the resource database for the");
	report_assertion("pop-up shell widget using the resource values specified in");
	report_assertion("the variable argument list and resource values from the");
	report_assertion("resource database of parent's screen for those resources not");
	report_assertion("specified in the variable argument list.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.2592 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
