.\"
.\"Copyright (c) 2005 X.Org Foundation L.L.C.
.\"
.\"Permission is hereby granted, free of charge, to any person obtaining a copy of
.\"this software and associated documentation files (the "Software"), to deal in
.\"the Software without restriction, including without limitation the rights to
.\"use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
.\"of the Software, and to permit persons to whom the Software is furnished to do
.\"so, subject to the following conditions:
.\"
.\"The above copyright notice and this permission notice shall be included in all
.\"copies or substantial portions of the Software.
.\"
.\"THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\"IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\"FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
.\"AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\"LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
.\"OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
.\"SOFTWARE.
.\"
.\"Copyright (c) 1994, 1995 Applied Testing and Technology, Inc.
.\"All rights reserved
.TH vswrptm "1" "November 1999" "The Open Group" "VSW5"
.SH NAME
vswrptm \- Report Comparison Generator for the VSW5 Test Suite
.SH SYNOPSIS
.in +10n
.ti -10n
\fBvswrptm\fR
[
.B -a
] [
.B -f
] [
.B -h
] [
.B -s
.I section
] [
.B -t
.I test_case
] [
.B -u
] [
.B -v
]
.I journal1 journal2
[
.I journal3
] [
.I journal4
] [
.I journal5
] [
.I journal6
]
.SH DESCRIPTION
\fRThe VSW5 Report Comparison Generator (vswrptm) produces a 
report comparing the Test Purpose results from two to six Test Environment
Toolkit (TET) journal files produced from runs of VSW5.
The report is written to stdout.
.PP
vswrptm employs the standard TET journal information along with additional
information provided by the Test Suite via the scenario file and the tests
themselves.  This data provides the names of Test Suite Sections and Test Cases
as well as invariant Test Purpose numbering to allow vswrptm to detect
missing Test Cases or Purposes.
.PP
The journal files given to vswrptm must be the result of a tcc command which
includes the -e option.  The -b and/or -c options may also have been used.
vswrptm cannot be used on journal files which do not contain the additional
information provided by VSW5.
.SH OPTIONS
.TP 5
.B Detail and Scope
.PP
vswrptm always produces a summary report of the results of the test runs in
the input journals.  By default it also reports the results for all Test
Purposes for which the results are not the same in each journal.
Five options provide the ability to alter this later information.
.TP  5
.B -a
Show results for all Test Purposes, not just variations.
.P
.TP  5
.B -f
Show results for Test Purposes where a failure is present as well as variations.
.P
.TP 5
.B -u
Show results for Test Purposes where UNINITIATED results are present as well as variations.
.TP 5
.B -t test_case
.PP
.in +5
Report results only for the Test Case
.I test_case.
.PP
.TP 5
.B -s section
.PP
.in +5
Report results only for the Test Suite Section
.I section.
.PP
.B Other Options
.PP
.TP 10
.B -h
Display usage information.
.TP 10
.B -v
Display program version.
.PP
.SH FIP RESULTS
\fRA Further Information Provided (FIP) result code indicates that manual
analysis is required to resolve an anomaly.  In some cases FIP results
are generated by Test Purposes themselves but primarily they are
produced during report generation.  If compiler warnings are present in a 
journal for the build phase of a test suite file and the result of a
Test Purpose in that file would otherwise be PASS vswrptm changes the
result to FIP.  This indicates the compiler warnings must be manually
examined and either corrected or justified.
.PP
.SH UNINITIATED RESULTS
\fRAn UNINITIATED result code indicate that a Test Purpose was not
executed, usually due to a compiler error during the build phase.
vswrptm is aware of which Test Purposes are executed and will report
result of UNINITIATED for each Test Purpose which is not run.  This
indicates that the compiler error should be corrected and the test
re-run.
.PP
.SH REPORT FORMATS
\fRThe summary report produced by vswrptm 
provides a summary of the result codes reported by the Test Purposes in
each journal file.
.PP
Result from Test Purposes are output in columnar form.
.PP
.SH ERRORS
vswrptm will print an error and usage message to stderr if illegal options
are specified. No report is generated.
.PP
vswrptm will print an error message to stderr if format errors are encountered
in the journal file.  No report is generated.
.SH SEE ALSO
.PP
vswrpt
.PP
Copyright (c) 1994-1997 Applied Testing and Technology, Inc.
