/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
* 
*/
/*
 * SYNOPSIS:
 *   Status
 *   XShapeQueryExtents()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/extensions/shape.h>
extern Display *display ;



#define T_XShapeQueryExtents	1
char    *TestName = "XShapeQueryExtents";



static int 	StatusReturn;

int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Window window;
int value_good;
int bounding_shaped, clip_shaped;
int x_bounding, y_bounding;
unsigned int w_bounding, h_bounding;
int x_clip, y_clip;
unsigned int w_clip, h_clip;
Window root;
int x, y;
unsigned int width, height;
unsigned int border_width;
unsigned int depth;
pid_t pid2;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XShapeQueryExtents-1.(A)");
	report_assertion("A call to Status XShapeQueryExtents(display, window,");
	report_assertion("bounding_shaped, x_bounding, y_bounding, w_bounding,");
	report_assertion("h_bounding, clip_shaped, x_clip, y_clip, w_clip, h_clip)");
	report_assertion("shall return a non-zero value, and set x_bounding,");
	report_assertion("y_bounding, w_bounding, h_bounding to the extents of the");
	report_assertion("bounding shape, and x_clip, y_clip, w_clip, h_clip to");
	report_assertion("extents of the clip shape.");
	FORK(pid);
	initconfig();



	FORK(pid2);
	tet_infoline("PREP: Open display and create window");
	window = (Window) avs_xext_init();
	tet_infoline("PREP: XShapeQueryExtents");
	value_good = XShapeQueryExtents(display, window,
			&bounding_shaped,
			&x_bounding, &y_bounding,
			&w_bounding, &h_bounding,
			&clip_shaped,
			&x_clip, &y_clip, 
			&w_clip, &h_clip);
	tet_infoline("TEST: Non zero value is returned");
	if (value_good <= 0) {
		sprintf(ebuf, "ERROR: Expected non zero value, returned %d", value_good);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("PREP: Get geometry of window");
	XGetGeometry(display,
		   window,
		   &root,
		   &x, &y,
		   &width, &height,
		   &border_width,
		   &depth 
		   );
	tet_infoline("TEST: Bounding shape and clip shape value");
	check_dec(-1, x_bounding, "x_bounding");
	check_dec(-1, y_bounding, "y_bounding");
	check_dec((width +(2 * border_width)), w_bounding, "w_bounding");
	check_dec((height+(2 * border_width)), h_bounding, "h_bounding");
	check_dec(0, x_clip, "x_clip");
	check_dec(0, y_clip, "y_clip");
	check_dec(width, w_clip, "w_clip");
	check_dec(height, h_clip, "h_clip");

	LKROF(pid2, AVSXTTIMEOUT);
        tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.364588 */
/* End of included file Mdefcode.tmc.364588 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
