/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1993 by the Hewlett-Packard Company.
* 
* Copyright 1990, 1991 UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the names of HP, and UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  HP, and UniSoft
* make no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   XDeviceTimeCoord *
 *   XGetDeviceMotionEvents(display, device, start, stop, nevents_return, mode_return, axis_count_return)
 *   Display *display;
 *   XDevice *device;
 *   Time start;
 *   Time stop;
 *   int *nevents_return;
 *   int *mode_return;
 *   int *axis_count_return;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XGetDeviceMotionEvents	1
char    *TestName = "XGetDeviceMotionEvents";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display


/*
 * Arguments to the XGetDeviceMotionEvents function
 */
static Display *display;
static XDevice *device;
static Time start;
static Time stop;
static int *nevents_return;
static int *mode_return;
static int *axis_count_return;


static	int	_nevents_return;
static	int	_mode_return;
static	int	_axis_count_return;
extern	ExtDeviceInfo Devs;

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	device = 0;
	start = CurrentTime;
	stop = CurrentTime;
	nevents_return = &_nevents_return;
	mode_return = &_mode_return;
	axis_count_return = &_axis_count_return;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XGetDeviceMotionEvents-1.(D)");
	report_assertion("If the implementation supports a more complete history of");
	report_assertion("the device motion than is reported by event notification: a");
	report_assertion("call to XGetDeviceMotionEvents returns all events in the");
	report_assertion("motion history buffer that fall between the start and stop");
	report_assertion("times, inclusive, and sets nevents_return to the number of");
	report_assertion("events returned.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("If a device motion buffer is not supported, return.");

	tpstartup();
	setargs();
/* If a device motion buffer is not supported, return. */
	if (!config.displaymotionbuffersize)
		unsupported("Device motion buffer is not supported.");
	else
		untested("There is no known portable test method for this assertion");
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

XDeviceTimeCoord *tc;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XGetDeviceMotionEvents-2.(C)");
	report_assertion("If the implementation does not support a more complete");
	report_assertion("history of device motion than is reported by event");
	report_assertion("notification: a call to XGetDeviceMotionEvents returns no");
	report_assertion("events.");

	report_strategy("If a device motion buffer is supported, return.");
	report_strategy("Call XGetDeviceMotionEvents.");
	report_strategy("Verify that no events were returned.");

	tpstartup();
	setargs();
/* If a device motion buffer is supported, return. */
	if (config.displaymotionbuffersize != 0) {
		report("Device motion buffer is supported.");
		UNSUPPORTED;
		return;
	}
	else
		CHECK;
	if (!Setup_Extension_DeviceInfo(ValMask))
	    {
	    untested("%s: No input extension valuator device.\n", TestName);
	    return;
	    }
	start = 0;
	stop = CurrentTime;
	*nevents_return = 1;
/* Call XGetDeviceMotionEvents. */
	device = Devs.Valuator;
	startcall(display);
	if (isdeleted())
		return;
	tc = XGetDeviceMotionEvents(display, device, start, stop, nevents_return, mode_return, axis_count_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
/* Verify that no events were returned. */
	if (tc != (XDeviceTimeCoord *) NULL) {
		report("Returned 0x%x, expected NULL", tc);
		FAIL;
		XFree((char*)tc);
	}
	else
		CHECK;
	if (*nevents_return != 0) {
		report("Returned %d, expected 0", *nevents_return);
		FAIL;
	}
	else
		CHECK;
	CHECKPASS(3);
	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

int i, val=0;
XDeviceTimeCoord *tc;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XGetDeviceMotionEvents-3.(B)");
	report_assertion("When start is later than stop, then a call to");
	report_assertion("XGetDeviceMotionEvents returns no events.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Set stop to current time.");
	report_strategy("Call XGetDeviceMotionEvents with start greater than stop.");
	report_strategy("Verify that no events were returned.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(ValMask))
	    {
	    untested("%s: No input extension valuator device.\n", TestName);
	    return;
	    }
	if (noext(0))
	    return;
/* Set stop to current time. */
	stop = gettime(display);
/* Call XGetDeviceMotionEvents with start greater than stop. */
	start = stop + 1;
	device = Devs.Valuator;
	for (i=0; i<20; i++)
	    SimulateDeviceMotionEvent (display, Devs.Valuator, False, 1, &val, 0);
	startcall(display);
	if (isdeleted())
		return;
	tc = XGetDeviceMotionEvents(display, device, start, stop, nevents_return, mode_return, axis_count_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
/* Verify that no events were returned. */
	if (tc != (XDeviceTimeCoord *) NULL) {
		report("Returned 0x%x, expected NULL", tc);
		XFreeDeviceMotionEvents(tc);
		FAIL;
	}
	else
		CHECK;
	if (*nevents_return != 0) {
		report("Returned %d, expected 0", *nevents_return);
		FAIL;
	}
	else
		CHECK;
	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

int i, val=0;
XDeviceTimeCoord *tc;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XGetDeviceMotionEvents-4.(B)");
	report_assertion("When start is in the future, then a call to");
	report_assertion("XGetDeviceMotionEvents returns no events.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Set stop to current time.");
	report_strategy("Set start to a future time.");
	report_strategy("Call XGetDeviceMotionEvents.");
	report_strategy("Verify that no events were returned.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(ValMask))
	    {
	    untested("%s: No input extension valuator device.\n", TestName);
	    return;
	    }
/* Set stop to current time. */
	stop = CurrentTime;
/* Set start to a future time. */
	start = gettime(display) + 10000;
/* Call XGetDeviceMotionEvents. */
	device = Devs.Valuator;
	for (i=0; i<20; i++)
	    SimulateDeviceMotionEvent (display, Devs.Valuator, False, 1, &val, 0);
	startcall(display);
	if (isdeleted())
		return;
	tc = XGetDeviceMotionEvents(display, device, start, stop, nevents_return, mode_return, axis_count_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
/* Verify that no events were returned. */
	if (tc != (XDeviceTimeCoord *) NULL) {
		report("Returned 0x%x, expected NULL", tc);
		XFreeDeviceMotionEvents(tc);
		FAIL;
	}
	else
		CHECK;
	if (*nevents_return != 0) {
		report("Returned %d, expected 0", *nevents_return);
		FAIL;
	}
	else
		CHECK;

/* Set stop to future time. */
	stop = gettime(display) + 10000;
/* Set start to a past time. */
	start = gettime(display) - 10000;
/* Call XGetDeviceMotionEvents. */
	device = Devs.Valuator;
	for (i=0; i<20; i++)
	    SimulateDeviceMotionEvent (display, Devs.Valuator, False, 1, &val, 0);
	startcall(display);
	if (isdeleted())
		return;
	tc = XGetDeviceMotionEvents(display, device, start, stop, nevents_return, mode_return, axis_count_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
/* Verify that no events were returned. */
	if (tc != (XDeviceTimeCoord *) NULL) {
		report("Returned 0x%x, expected NULL", tc);
		XFreeDeviceMotionEvents(tc);
		FAIL;
	}
	else
		CHECK;
	if (*nevents_return != 0) {
		report("Returned %d, expected 0", *nevents_return);
		FAIL;
	}
	else
		CHECK;
	CHECKPASS(4);
	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

int	dmn;
XEventClass classes[2];
Window w;
int axes=0, n, ret, i;
XEvent ev;
XDeviceMotionEvent *d;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XGetDeviceMotionEvents-5.(B)");
	report_assertion("A call to XGetDeviceMotionEvents will update the");
	report_assertion("DeviceMotionHint state and cause another device motion event");
	report_assertion("to be sent to interested clients, when more device motion");
	report_assertion("events are generated.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Select DeviceMotionNotify and DevicePointerMotionHint classes.");
	report_strategy("Generate some motion events, verify only one is sent.");
	report_strategy("Now call XGetDeviceMotionEvents.");
	report_strategy("Generate some motion events, verify another one is sent.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(ValMask))
	    {
	    untested("%s: Required input extension device not present.\n", 
		TestName);
	    return;
	    }
	if (noext(0))
	    return;
	device = Devs.Valuator;
/* Set stop to current time. */
	stop = CurrentTime;
/* Set start to a past time. */
	start = gettime(display);
	DeviceMotionNotify(device, dmn, classes[0]);
	DevicePointerMotionHint(device, unused, classes[1]);
	w = defwin(display);
	XSelectExtensionEvent(display, w, classes, 2);
	warppointer (display, w, 1, 1);

	XSync(display,1);
	for (i=0; i<10; i++)
	    SimulateDeviceMotionEvent(display, device, False, 1, &axes, 0);
	XSync(display,0);

	n = getevent(display, &ev);
	if (n != 1)
	    {
	    report("Expecting one event with DeviceMotionHint, got %d",n);
	    FAIL;
	    }
	else
	    CHECK;
	if (ev.type != dmn)
	    {
	    report("Expecting DeviceMotionNotify event, got event type %d",
		ev.type);
	    FAIL;
	    }
	else
	    CHECK;
	d = (XDeviceMotionEvent *) &ev;
	if (d->is_hint != True)
	    {
	    report("Expecting is_hint = True, was False");
	    FAIL;
	    }
	else
	    CHECK;

	startcall(display);
	if (isdeleted())
		return;
	XGetDeviceMotionEvents(display, device, start, stop, nevents_return, mode_return, axis_count_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if ((ret = geterr()) == Success)
		CHECK;
	else
	    {
	    report("Expecting Success, got error %d", ret);
	    FAIL;
	    }

	XSync(display,1);
	for (i=0; i<10; i++)
	    SimulateDeviceMotionEvent(display,  device, False, 1, &axes, 0);
	XSync(display,0);

	n = getevent(display, &ev);
	if (n != 1)
	    {
	    report("Expecting one event with DeviceMotionHint, got %d",n);
	    FAIL;
	    }
	else
	    CHECK;
	if (ev.type != dmn)
	    {
	    report("Expecting DeviceMotionNotify event, got event type %d",
		ev.type);
	    FAIL;
	    }
	else
	    CHECK;
	d = (XDeviceMotionEvent *) &ev;
	if (d->is_hint != True)
	    {
	    report("Expecting is_hint = True, was False");
	    FAIL;
	    }
	else
	    CHECK;

	CHECKPASS(7);
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.364612 */
static void t006(){

int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XGetDeviceMotionEvents-6.(B)");
	report_assertion("A call to XGetDeviceMotionEvents with stop in the future,");
	report_assertion("is equivalent to specifying a value of CurrentTime for stop.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.364612 */

/* Including from file Mdefcode.tmc.364612 */
static void t007(){

int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XGetDeviceMotionEvents-7.(D)");
	report_assertion("On a call to XGetDeviceMotionEvents the x and y members of");
	report_assertion("the events returned are set to the coordinates of the device");
	report_assertion("and the time member is set to the time the device reached");
	report_assertion("this coordinate.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.364612 */

static void t008(){

XDeviceTimeCoord *tc;
int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion XGetDeviceMotionEvents-8.(B)");
	report_assertion("When XGetDeviceMotionEvents is invoked with a device that");
	report_assertion("has no valuators, a BadMatch error results.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Specify a device with no valuators.");
	report_strategy("Verify that a BadMatch error results.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(NValsMask))
	    {
	    untested("%s: No input extension device without valuators.\n", TestName);
	    return;
	    }
	device = Devs.NoValuators;
/* Set stop to current time. */
	stop = CurrentTime;
/* Set start to a future time. */
	start = gettime(display) + 10000;
/* Call XGetDeviceMotionEvents. */
	startcall(display);
	if (isdeleted())
		return;
	tc = XGetDeviceMotionEvents(display, device, start, stop, nevents_return, mode_return, axis_count_return);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadMatch)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

static void t009(){

int baddevice;
XDevice nodevice;
XDeviceTimeCoord *tc;
int ximajor, first, err;
int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion XGetDeviceMotionEvents-9.(B)");
	report_assertion("When XGetDeviceMotionEvents is invoked with an invalid");
	report_assertion("device, a BadDevice error results.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Specify an invalid device.");
	report_strategy("Verify that a BadDevice error results.");

	tpstartup();
	setargs();
	if (!XQueryExtension (display, INAME, &ximajor, &first, &err))
	    {
	    untested("%s: Input extension not supported.\n", TestName);
	    return;
	    }

	BadDevice(display,baddevice);
	nodevice.device_id = -1;
	device = &nodevice;
/* Set stop to current time. */
	stop = CurrentTime;
/* Set start to a future time. */
	start = gettime(display) + 10000;
/* Call XGetDeviceMotionEvents. */
	startcall(display);
	if (isdeleted())
		return;
	tc = XGetDeviceMotionEvents(display, device, start, stop, nevents_return, mode_return, axis_count_return);
	endcall(display);
	if (geterr() != baddevice) {
		report("Got %s, Expecting baddevice", errorname(geterr()));
		FAIL;
	}

	if (geterr() == baddevice)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
