/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1993 by the Hewlett-Packard Company.
* 
* Copyright 1990, 1991 UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the names of HP, and UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  HP, and UniSoft
* make no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XGetDeviceFocus(display, device, focus, revert_to, time1)
 *   Display	*display;
 *   XDevice *device;
 *   Window	*focus;
 *   int	*revert_to;
 *   Time	*time1;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XGetDeviceFocus	1
char    *TestName = "XGetDeviceFocus";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display


/*
 * Arguments to the XGetDeviceFocus function
 */
static Display	*display;
static XDevice *device;
static Window	*focus;
static int	*revert_to;
static Time	*time1;


Window fwin;
int revert;
Time focus_time;
int baddevice;
extern ExtDeviceInfo Devs;


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	device = 0;
	focus = &fwin;
	revert_to = &revert;
	time1 = &focus_time;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Window w;
int devicestatenotify;
XEventClass devicestatenotifyclass;
XWindowAttributes attr;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XGetDeviceFocus-1.(B)");
	report_assertion("A call to GetDeviceFocus returns the focus window,");
	report_assertion("PointerRoot, FollowKeyboard, or None to focus_return, the");
	report_assertion("current focus revert state to revert_to_return, and the");
	report_assertion("last_focus_time to time_return.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Touch test.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(FocusMask))
	    {
	    untested("%s: Required input extension devices not found.\n", TestName);
	    return;
	    }
	device = Devs.Focus;

	startcall(display);
	if (isdeleted())
		return;
	XGetDeviceFocus(display, device, focus, revert_to, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (fwin!=None && fwin!=PointerRoot && fwin!=FollowKeyboard)
	    if (XGetWindowAttributes(display, fwin, &attr) != Success)
		{
		report("Bad window returned by %s\n",TestName);
		FAIL;
		}
	    else
		CHECK;
	else
	    CHECK;
	if (revert!=RevertToNone && revert!=RevertToPointerRoot && 
	    revert!=RevertToFollowKeyboard && revert!=RevertToParent)
	    {
	    report("Bad revert_to returned by %s\n",TestName);
	    FAIL;
	    }
	else
	    CHECK;


	XSetDeviceFocus(display, device, PointerRoot, RevertToPointerRoot, CurrentTime);
	startcall(display);
	if (isdeleted())
		return;
	XGetDeviceFocus(display, device, focus, revert_to, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (fwin!=PointerRoot)
	    {
	    report("Bad window returned by %s\n",TestName);
	    FAIL;
	    }
	else
	    CHECK;
	if (revert!=RevertToPointerRoot)
	    {
	    report("Bad revert_to returned by %s\n",TestName);
	    FAIL;
	    }
	else
	    CHECK;


	XSetDeviceFocus(display, device, FollowKeyboard, RevertToFollowKeyboard, CurrentTime);
	startcall(display);
	if (isdeleted())
		return;
	XGetDeviceFocus(display, device, focus, revert_to, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (fwin!=FollowKeyboard)
	    {
	    report("Bad window returned by %s\n",TestName);
	    FAIL;
	    }
	else
	    CHECK;
	if (revert!=RevertToFollowKeyboard)
	    {
	    report("Bad revert_to returned by %s\n",TestName);
	    FAIL;
	    }
	else
	    CHECK;

	w = defwin(display);
	DeviceStateNotify(device, devicestatenotify, devicestatenotifyclass);
	XSelectExtensionEvent(display, w, &devicestatenotifyclass, 1);
	XSync(display,0);

	XSetDeviceFocus(display, device, None, RevertToNone, CurrentTime);
	startcall(display);
	if (isdeleted())
		return;
	XGetDeviceFocus(display, device, focus, revert_to, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (fwin!=None)
	    {
	    report("Bad window returned by %s\n",TestName);
	    FAIL;
	    }
	else
	    CHECK;
	if (revert!=RevertToNone)
	    {
	    report("Bad revert_to returned by %s\n",TestName);
	    FAIL;
	    }
	else
	    CHECK;
	
	XSetDeviceFocus(display, device, w, RevertToPointerRoot, CurrentTime);
	startcall(display);
	if (isdeleted())
		return;
	XGetDeviceFocus(display, device, focus, revert_to, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (fwin!=w)
	    {
	    report("Bad window returned by %s\n",TestName);
	    FAIL;
	    }
	else
	    CHECK;
	if (revert!=RevertToPointerRoot)
	    {
	    report("Bad revert_to returned by %s\n",TestName);
	    FAIL;
	    }
	else
	    CHECK;

	CHECKPASS(10);


	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

XDevice nodevice;
int ximajor, first, err;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XGetDeviceFocus-2.(B)");
	report_assertion("A call to XGetDeviceFocus specifying an invalid device");
	report_assertion("results in a BadDevice error.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Make the call with an invalid device.");

	tpstartup();
	setargs();
	if (!XQueryExtension (display, INAME, &ximajor, &first, &err))
	    {
	    untested("%s: Input extension not supported.\n", TestName);
	    return;
	    }

	BadDevice (display, baddevice);
	nodevice.device_id = -1;
	device = &nodevice;

	startcall(display);
	if (isdeleted())
		return;
	XGetDeviceFocus(display, device, focus, revert_to, time1);
	endcall(display);
	if (geterr() != baddevice) {
		report("Got %s, Expecting baddevice", errorname(geterr()));
		FAIL;
	}

	if (geterr() == baddevice)
		CHECK;
	else
		FAIL;

	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
