/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   int
 *   XRectInRegion(r, x, y, width, height)
 *   Region		r;
 *   int		x;
 *   int		y;
 *   unsigned int	width;
 *   unsigned int	height;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XRectInRegion	1
char    *TestName = "XRectInRegion";

/*
 * Defines for different argument types
 */


/*
 * Arguments to the XRectInRegion function
 */
static Region		r;
static int		x;
static int		y;
static unsigned int	width;
static unsigned int	height;


static int 	ValueReturn;

static XRectangle	medrect = { 10,10, 15,5 };

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	r = 0;
	x = 0;
	y = 0;
	width = 0;
	height = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Region			R;
int			res;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XRectInRegion-1.(A)");
	report_assertion("When the rectangle specified by the x, y, width, and");
	report_assertion("height arguments is entirely in the region r, then a call");
	report_assertion("to XRectInRegion returns RectangleIn.");

	report_strategy("Create a region using XCreateRegion.");
	report_strategy("Set the region to a rectangle using XUnionRectWithRegion.");
	report_strategy("Verify that with a contained rectangle XRectInRegion returns RectangleIn.");

	tpstartup();
	setargs();
	R = makeregion();
	if(isdeleted()) return;

	XUnionRectWithRegion(&medrect, R, R);
	r = R;
	x=10;	
	y=10;
	width=15;
	height=5;

	startcall(Dsp);
	if (isdeleted())
		return;
	res = XRectInRegion(r, x, y, width, height);
	endcall(Dsp);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(res != RectangleIn) {
		report("%s() returned %d instead of RectangleIn (%d).", TestName, res, RectangleIn);
		FAIL;
	} else
		PASS;

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

Region			R;
int			res;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XRectInRegion-2.(A)");
	report_assertion("When the rectangle specified by the x, y, width, and");
	report_assertion("height arguments is entirely out of the region r, then a");
	report_assertion("call to XRectInRegion returns RectangleOut.");

	report_strategy("Create a region using XCreateRegion.");
	report_strategy("Set the region to a rectangle using XUnionRectWithRegion.");
	report_strategy("Verify that with a non-intersecting rectangle XRectInRegion returns RectangleOut.");

	tpstartup();
	setargs();
	R = makeregion();
	if(isdeleted()) return;

	XUnionRectWithRegion(&medrect, R, R);
	r = R;
	x=35;	
	y=15;
	width=5;
	height=2;

	startcall(Dsp);
	if (isdeleted())
		return;
	res = XRectInRegion(r, x, y, width, height);
	endcall(Dsp);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(res != RectangleOut) {
		report("%s() returned %d instead of RectangleOut (%d).", TestName, res, RectangleOut);
		FAIL;
	} else
		PASS;

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

Region			R;
int			res;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XRectInRegion-3.(A)");
	report_assertion("When the rectangle specified by the x, y, width, and");
	report_assertion("height arguments is partly in the region r, then a call to");
	report_assertion("XRectInRegion returns RectanglePart.");

	report_strategy("Create a region using XCreateRegion.");
	report_strategy("Set the region to a rectangle using XUnionRectWithRegion.");
	report_strategy("Verify that with an intersecting rectangle XRectInRegion returns RectanglePart.");

	tpstartup();
	setargs();
	R = makeregion();
	if(isdeleted()) return;

	XUnionRectWithRegion(&medrect, R, R);
	r = R;
	x=20;	
	y=5;
	width=4;
	height=10;

	startcall(Dsp);
	if (isdeleted())
		return;
	res = XRectInRegion(r, x, y, width, height);
	endcall(Dsp);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(res != RectanglePart) {
		report("%s() returned %d instead of RectanglePart (%d).", TestName, res, RectanglePart);
		FAIL;
	} else
		PASS;

	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
