/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   XPixmapFormatValues *
 *   XListPixmapFormats(display, count_return)
 *   Display	*display;
 *   int	*count_return;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XListPixmapFormats	1
char    *TestName = "XListPixmapFormats";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display


/*
 * Arguments to the XListPixmapFormats function
 */
static Display	*display;
static int	*count_return;


#include <string.h>
#define SEPS " "

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	count_return = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

XPixmapFormatValues	*plst = (XPixmapFormatValues *) NULL;
XPixmapFormatValues	*pt = (XPixmapFormatValues *) NULL;
char			*tok;
char			*dp;
int			*Pdepth;
int			Ndepth;
int			nr=0;
int			i;
int			j;
int			found;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XListPixmapFormats-1.(A)");
	report_assertion("A call to XListPixmapFormats returns an array of");
	report_assertion("XPixampFormatValues structures which can be freed with XFree");
	report_assertion("of length returned in the count_return argument that");
	report_assertion("describe the types of Z format images that are supported by");
	report_assertion("the display specified by the display argument.");

	report_strategy("Obtain a list of pixmap formats using XListPixmapFormats.");
	report_strategy("Verify the depths match those specified in XT_PIXMAP_DEPTHS.");
	report_strategy("Free the list using XFree.");

	tpstartup();
	setargs();
	count_return = &nr;
	startcall(display);
	if (isdeleted())
		return;
	pt = plst = XListPixmapFormats(display, count_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if(plst == (XPixmapFormatValues *) NULL) {
		delete("%s() returned NULL", TestName);
		return;
	} else
		CHECK;

	dp = config.pixmap_depths;
	if (dp == (char*)0) {
		delete("XT_PIXMAP_DEPTHS not set");
		return;
	} else
		CHECK;

	/*
	 * The number of pixmap depths in the string is less than the
	 * length of the string.
	 */
	Pdepth = (int*)malloc(strlen(dp) * sizeof(int));
	if (Pdepth == (int*)0) {
		delete("Could not allocate memory for pixmap depth array");
		return;
	} else
		CHECK;

	Ndepth = 0;
	for (tok = strtok(dp, SEPS); tok; tok = strtok((char*)0, SEPS))
		Pdepth[Ndepth++]  = atov(tok);

	if(nr != Ndepth) {
		report("%s() returned %d structures", TestName, nr);
		report("Expected %d structures", Ndepth);
		FAIL;
	} else
		CHECK;

	for(j = 0; j < Ndepth; j++) {
		trace("pixmap depth expected %d", Pdepth[j]);
		found = 0;
		for(pt = plst, i = 0; i < nr; i++, pt++) {
			trace("pixmap depth found %d", pt->depth);
			if(pt->depth == Pdepth[j]) {
				found = 1;
				break;
			}
		}
		if(!found) {
			report("Pixmap depth %d not returned by %s", Pdepth[j],
								TestName);
			FAIL;
		} else
			CHECK;
	}

	for(pt = plst, i = 0; i < nr; pt++) {
		trace("Pixmap format %d : depth %d, bits_per_pixel %d, scanline_pad %d.", ++i,
			pt->depth, pt-> bits_per_pixel, pt->scanline_pad);
	}
	XFree( (char *) plst);
	CHECKPASS(4+Ndepth);

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.363396 */
static void t002(){

int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XListPixmapFormats-2.(B)");
	report_assertion("When insufficient memory is available, then a call to");
	report_assertion("XListPixmapFormats returns NULL.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.363396 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
