/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   XImage *
 *   XGetImage(display, d, x, y, width, height, plane_mask, format)
 *   Display *display;
 *   Drawable d;
 *   int x;
 *   int y;
 *   unsigned int width;
 *   unsigned int height;
 *   long plane_mask;
 *   int format;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XGetImage	1
char    *TestName = "XGetImage";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_DRAWABLE d


/*
 * Arguments to the XGetImage function
 */
static Display *display;
static Drawable d;
static int x;
static int y;
static unsigned int width;
static unsigned int height;
static long plane_mask;
static int format;


/*
 * pre_xcall() - set globals
 */
static void
pre_xcall(win, ap, p, f)
Drawable win;
struct area *ap;
long p;
int f;
{
	d = win;
	x = ap->x;
	y = ap->y;
	width = ap->width;
	height = ap->height;
	plane_mask = p;
	format = f;
}

/*
 * plane masks for plane mask-related tests.
 * exercises each plane individually and various combinations of
 * planes.
 */
static long planelist[] = {
	0,
	1<<0,
	1<<1,
	1<<2,
	1<<3,
	1<<4,
	1<<5,
	1<<6,
	1<<7,
	1<<8,
	1<<9,
	1<<10,
	1<<11,
	1<<12,
	1<<13,
	1<<14,
	1<<15,
	1<<16,
	1<<17,
	1<<18,
	1<<19,
	1<<20,
	1<<21,
	1<<22,
	1<<23,
	1<<24,
	1<<25,
	1<<26,
	1<<27,
	1<<28,
	1<<29,
	1<<30,
	(long)((unsigned long)1<<31),
	0x23, 0xf8, 0x765, 0x3987, 0x129078, 0x23567193
};

/*
 * This list contains a number of areas suitable for getting
 * from the drawable.
 * This list need not contain as many members as the planelist.
 * The list is treated as if it were circular.
 */
static struct area arealist[] = {
	{0, 0, W_STDWIDTH, W_STDHEIGHT},
	{W_STDWIDTH/2, W_STDHEIGHT/2, W_STDWIDTH/4, W_STDHEIGHT/4},
	{W_STDWIDTH/2, W_STDHEIGHT/2, W_STDWIDTH/2, W_STDHEIGHT/2},
	{0, 0, 1, 1},
	{1, 1, 1, 1},
	{1, 1, 2, 2},
	{W_STDWIDTH/2, W_STDHEIGHT/2, 3, 3},
	{W_STDWIDTH-1, W_STDHEIGHT-1, 1, 1},
	{W_STDWIDTH-5, W_STDHEIGHT-5, 4, 4}
};


/* Value list for use in test t017 */
static int 	formatvallist[] = {
	XYPixmap,
	ZPixmap,
};


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	d = 0;
	x = 0;
	y = 0;
	width = 1;
	height = 1;
	plane_mask = AllPlanes;
	format = ZPixmap;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
	d = ErrdefDrawable;
}

static void t001(){

XVisualInfo *vp;
Window w;
XImage *im1, *im2;
static struct area area1 =
	{ 0, 0, W_STDWIDTH, W_STDHEIGHT };
static struct area area2 =
	{ W_STDWIDTH/2, W_STDHEIGHT/2, W_STDWIDTH/4, W_STDHEIGHT/4 };
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XGetImage-1.(A)");
	report_assertion("A call to XGetImage returns a pointer to an XImage");
	report_assertion("structure containing the contents of the specified rectangle");
	report_assertion("with upper left corner at [ x, y] relative to the origin");
	report_assertion("of the drawable d and with width width and height height in");
	report_assertion("the format specified by the format argument.");

	report_strategy("Create drawable.");
	report_strategy("Write known pattern to drawable.");
	report_strategy("Call XGetImage with XYPixmap format.");
	report_strategy("Verify XGetImage return value is not null.");
	report_strategy("Verify depth, width, height, and format values in gotten image structure.");
	report_strategy("Verify gotten image for known pattern.");
	report_strategy("Repeat for ZPixmap format.");
	report_strategy("Destroy images using XDestroyImage.");
	report_strategy("Repeat for each visual.");

	tpstartup();
	setargs();
	for (resetvinf(VI_WIN_PIX); nextvinf(&vp); ) {
		im1 = im2 = (XImage *) 0;

/* Create drawable. */
		/* do XYPixmap testing */
		trace("XYPixmap");
		w = makewin(display, vp);

/* Write known pattern to drawable. */
		dset(display, w, W_FG);

/* Call XGetImage with XYPixmap format. */
		pre_xcall(w, &area1, AllPlanes, XYPixmap);
		startcall(display);
		if (isdeleted())
			return;
		im1 = XGetImage(display, d, x, y, width, height, plane_mask, format);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

/* Verify XGetImage return value is not null. */
		if (im1 == (XImage *) 0) {
			report("Null image returned.");
			FAIL;
			return;
		}
		else
			CHECK;

/* Verify depth, width, height, and format values in gotten image structure. */
		if (checkimgstruct(im1, vp->depth, area1.width, area1.height, XYPixmap) == False)
			FAIL;
		else
			CHECK;

/* Verify gotten image for known pattern. */
		if (checkimg(im1, (struct area *) 0, W_FG, W_FG, 0) == False) {
			report("Image was not properly gotten.");
			FAIL;
		}
		else
			CHECK;

/* Repeat for ZPixmap format. */
		/* do ZPixmap testing */
		trace("ZPixmap");
		w = makewin(display, vp);
		dset(display, w, W_BG);

		pre_xcall(w, &area2, AllPlanes, ZPixmap);
		startcall(display);
		if (isdeleted())
			return;
		im2 = XGetImage(display, d, x, y, width, height, plane_mask, format);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
		if (im2 == (XImage *) 0) {
			report("Null image returned.");
			FAIL;
			return;
		}
		else
			CHECK;

		if (checkimgstruct(im2, vp->depth, area2.width, area2.height, ZPixmap) == False)
			FAIL;
		else
			CHECK;

		if (checkimg(im2, (struct area *) 0, W_BG, W_BG, 0) == False) {
			report("Image was not properly gotten.");
			FAIL;
		}
		else
			CHECK;
	
/* Destroy images using XDestroyImage. */
		if (im1 != (XImage *) 0)
			XDestroyImage(im1);
		if (im2 != (XImage *) 0)
			XDestroyImage(im2);

/* Repeat for each visual. */
	}

	CHECKPASS(3*2*nvinf());
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

XVisualInfo *vp;
Window w;
XImage *im1;
XImage *im2;
long mask;
long *pp;
struct area *ap;
unsigned int numbits;
unsigned long pix;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XGetImage-2.(A)");
	report_assertion("When the format is XYPixmap, then the image contains only");
	report_assertion("the bit planes specified in plane_mask.");

	report_strategy("Create drawable.");
	report_strategy("Set only bits in drawable corresponding to planes specified by planemask.");
	report_strategy("Call XGetImage with XYPixmap format.");
	report_strategy("Verify XGetImage return value is not null.");
	report_strategy("Verify depth, width, height, and format values in gotten image structure.");
	report_strategy("Verify gotten image for known pattern.");
	report_strategy("Repeat with only bits set not in planes specified by planemask.");
	report_strategy("Destroy images using XDestroyImage.");
	report_strategy("Repeat for each planemask.");
	report_strategy("Repeat for each visual.");

	tpstartup();
	setargs();
	for (resetvinf(VI_WIN_PIX); nextvinf(&vp); ) {
/* Create drawable. */
		w = makewin(display, vp);
		trace("depth of drawable: %d", vp->depth);
		for (ap = arealist, pp = planelist; pp < &planelist[NELEM(planelist)]; pp++) {
			im1 = im2 = (XImage *) 0;
			if (++ap >= (&arealist[NELEM(arealist)]))
				ap = arealist;
			mask = *pp & DEPTHMASK(vp->depth);
			numbits = bitcount(mask);
			trace("plane-mask 0x%x, numbits: %d, depth: %d",
				*pp, numbits, vp->depth);
			pre_xcall(w, ap, *pp, XYPixmap);

/* Set only bits in drawable corresponding to planes specified by planemask. */
			dset(display, w, mask);

/* Call XGetImage with XYPixmap format. */
			startcall(display);
			if (isdeleted())
				return;
			im1 = XGetImage(display, d, x, y, width, height, plane_mask, format);
			endcall(display);
			if (geterr() != Success) {
				report("Got %s, Expecting Success", errorname(geterr()));
				FAIL;
			}

/* Verify XGetImage return value is not null. */
			if (im1 == (XImage *) 0 && numbits) {
				report("Null image returned.");
				FAIL;
				return;
			} else
				CHECK;

/* Verify depth, width, height, and format values in gotten image structure. */
			if (im1 && checkimgstruct(im1, numbits, ap->width, ap->height, XYPixmap) == False)
				FAIL;
			else
				CHECK;

/* Verify gotten image for known pattern. */
			pix = DEPTHMASK(numbits);
			if (im1 && checkimg(im1, (struct area *) 0, pix, pix, 0) == False) {
				report("Image was not properly gotten.");
				FAIL;
			}
			else
				CHECK;

/* Repeat with only bits set not in planes specified by planemask. */
			trace("Repeat with complement.");
			dset(display, w, ~mask);

			startcall(display);
			if (isdeleted())
				return;
			im2 = XGetImage(display, d, x, y, width, height, plane_mask, format);
			endcall(display);
			if (geterr() != Success) {
				report("Got %s, Expecting Success", errorname(geterr()));
				FAIL;
			}

			if (im2 == (XImage *) 0 && numbits) {
				report("Null image returned.");
				FAIL;
				return;
			}
			else
				CHECK;

			if (im2 && checkimgstruct(im2, numbits, ap->width, ap->height, XYPixmap) == False)
				FAIL;
			else
				CHECK;

			if (im2 && checkimg(im2, (struct area *) 0, 0, 0, 0) == False) {
				report("Image was not properly gotten.");
				FAIL;
			}
			else
				CHECK;
/* Destroy images using XDestroyImage. */
			if (im1 != (XImage *) 0)
				XDestroyImage(im1);
			if (im2 != (XImage *) 0)
				XDestroyImage(im2);

/* Repeat for each planemask. */
		}


/* Repeat for each visual. */
	}

	CHECKPASS(nvinf() * 3 * 2 * NELEM(planelist));
	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){


 	report_purpose(3);

	report_assertion("Assertion XGetImage-3.(-)");
	report_assertion("When the format is XYPixmap and the plane_mask only");
	report_assertion("requests a subset of the planes of the display, then the");
	report_assertion("depth of the returned image will be the number of planes");
	report_assertion("requested.");
	report_assertion("The assertion is descriptive or is tested elsewhere.");
	tet_result(TET_NOTINUSE);
}

static void t004(){

XVisualInfo *vp;
Window w;
XImage *im1;
XImage *im2;
long mask;
long *pp;
struct area *ap;
unsigned long pix;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XGetImage-4.(A)");
	report_assertion("When the format is ZPixmap, then a call to XGetImage");
	report_assertion("returns as zero the bits in all planes not specified in");
	report_assertion("plane_mask.");

	report_strategy("Create drawable.");
	report_strategy("Set only bits in drawable corresponding to planes specified by planemask.");
	report_strategy("Call XGetImage with ZPixmap format.");
	report_strategy("Verify XGetImage return value is not null.");
	report_strategy("Verify depth, width, height, and format values in gotten image structure.");
	report_strategy("Verify gotten image for zero-bits in");
	report_strategy("all planes not specified in plane_mask.");
	report_strategy("Repeat with only bits set not in planes specified by planemask.");
	report_strategy("Destroy images using XDestroyImage.");
	report_strategy("Repeat for each planemask.");
	report_strategy("Repeat for each visual.");

	tpstartup();
	setargs();
	for (resetvinf(VI_WIN_PIX); nextvinf(&vp); ) {
		im1 = im2 = (XImage *) 0;

/* Create drawable. */
		w = makewin(display, vp);
		trace("depth of drawable: %d", vp->depth);
		for (ap = arealist, pp = planelist; pp < &planelist[NELEM(planelist)]; pp++) {
			/* wrap area pointer at end of list */
			if (++ap >= (&arealist[NELEM(arealist)]))
				ap = arealist;
			mask = *pp;
			mask &= DEPTHMASK(vp->depth);
			trace("plane-mask 0x%x", *pp);
			pre_xcall(w, ap, *pp, ZPixmap);

/* Set only bits in drawable corresponding to planes specified by planemask. */
			dset(display, w, mask);

/* Call XGetImage with ZPixmap format. */
			startcall(display);
			if (isdeleted())
				return;
			im1 = XGetImage(display, d, x, y, width, height, plane_mask, format);
			endcall(display);
			if (geterr() != Success) {
				report("Got %s, Expecting Success", errorname(geterr()));
				FAIL;
			}

/* Verify XGetImage return value is not null. */
			if (im1 == (XImage *) 0) {
				report("Null image returned.");
				FAIL;
				return;
			}
			else
				CHECK;

/* Verify depth, width, height, and format values in gotten image structure. */
			if (checkimgstruct(im1, vp->depth, ap->width, ap->height, ZPixmap) == False)
				FAIL;
			else
				CHECK;

/* Verify gotten image for zero-bits in */
/* all planes not specified in plane_mask. */
			pix = mask;
			if (checkimg(im1, (struct area *) 0, pix, pix, 0) == False) {
				report("Image was not properly gotten.");
				FAIL;
			}
			else
				CHECK;

/* Repeat with only bits set not in planes specified by planemask. */
			trace("Repeat with complement.");
			dset(display, w, ~mask);

			startcall(display);
			if (isdeleted())
				return;
			im2 = XGetImage(display, d, x, y, width, height, plane_mask, format);
			endcall(display);
			if (geterr() != Success) {
				report("Got %s, Expecting Success", errorname(geterr()));
				FAIL;
			}

			if (im2 == (XImage *) 0) {
				report("Null image returned.");
				FAIL;
				return;
			}
			else
				CHECK;

			if (checkimgstruct(im2, vp->depth, ap->width, ap->height, ZPixmap) == False)
				FAIL;
			else
				CHECK;

			if (checkimg(im2, (struct area *) 0, 0, 0, 0) == False) {
				report("Image was not properly gotten.");
				FAIL;
			}
			else
				CHECK;
/* Destroy images using XDestroyImage. */
			if (im1 != (XImage *) 0)
				XDestroyImage(im1);
			if (im2 != (XImage *) 0)
				XDestroyImage(im2);

/* Repeat for each planemask. */
		}


/* Repeat for each visual. */
	}

	CHECKPASS(nvinf() * 3 * 2 * NELEM(planelist));
	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){


 	report_purpose(5);

	report_assertion("Assertion XGetImage-5.(-)");
	report_assertion("When the format is ZPixmap, then the depth of the returned");
	report_assertion("image is as specified on drawable creation.");
	report_assertion("The assertion is descriptive or is tested elsewhere.");
	tet_result(TET_NOTINUSE);
}

static void t006(){


 	report_purpose(6);

	report_assertion("Assertion XGetImage-6.(-)");
	report_assertion("The value for plane_mask is truncated to the depth of the");
	report_assertion("drawable.");
	report_assertion("The assertion is descriptive or is tested elsewhere.");
	tet_result(TET_NOTINUSE);
}

static void t007(){

XVisualInfo *vp;
Window w;
XImage *im1, *im2;
static struct area area1 =
	{ -1, -1, 1, 1 };
int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XGetImage-7.(A)");
	report_assertion("When the specified rectangle includes the window border,");
	report_assertion("then the contents of the window border are obtained in the");
	report_assertion("XImage structure returned by a call to XGetImage.");

	report_strategy("Create drawable.");
	report_strategy("Set window border to W_FG.");
	report_strategy("Call XGetImage with ZPixmap format to get image of border pixel.");
	report_strategy("Verify XGetImage return value is not null.");
	report_strategy("Verify depth, width, height, and format values in gotten image structure.");
	report_strategy("Verify gotten image for known pattern.");
	report_strategy("Repeat with window border set to W_BG.");
	report_strategy("Destroy images using XDestroyImage.");
	report_strategy("Repeat for each type-window visual.");

	tpstartup();
	setargs();
	for (resetvinf(VI_WIN); nextvinf(&vp); ) {
		im1 = im2 = (XImage *) 0;

/* Create drawable. */
		/* do ZPixmap testing */
		trace("ZPixmap");
		w = makewin(display, vp);

/* Set window border to W_FG. */
		XSetWindowBorder(display, w, W_FG);

/* Call XGetImage with ZPixmap format to get image of border pixel. */
		pre_xcall(w, &area1, AllPlanes, ZPixmap);
		startcall(display);
		if (isdeleted())
			return;
		im1 = XGetImage(display, d, x, y, width, height, plane_mask, format);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

/* Verify XGetImage return value is not null. */
		if (im1 == (XImage *) 0) {
			report("Null image returned.");
			FAIL;
			return;
		}
		else
			CHECK;

/* Verify depth, width, height, and format values in gotten image structure. */
		if (checkimgstruct(im1, vp->depth, area1.width, area1.height, ZPixmap) == False)
			FAIL;
		else
			CHECK;

/* Verify gotten image for known pattern. */
		if (checkimg(im1, (struct area *) 0, W_FG, W_FG, 0) == False) {
			report("Image was not properly gotten.");
			FAIL;
		}
		else
			CHECK;

/* Repeat with window border set to W_BG. */
		trace("Repeat with window border to W_BG.");
		XSetWindowBorder(display, w, W_BG);

		pre_xcall(w, &area1, AllPlanes, ZPixmap);
		startcall(display);
		if (isdeleted())
			return;
		im2 = XGetImage(display, d, x, y, width, height, plane_mask, format);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		if (im2 == (XImage *) 0) {
			report("Null image returned.");
			FAIL;
			return;
		}
		else
			CHECK;

		if (checkimgstruct(im2, vp->depth, area1.width, area1.height, ZPixmap) == False)
			FAIL;
		else
			CHECK;

		if (checkimg(im2, (struct area *) 0, W_BG, W_BG, 0) == False) {
			report("Image was not properly gotten.");
			FAIL;
		}
		else
			CHECK;

/* Destroy images using XDestroyImage. */
		if (im1 != (XImage *) 0)
			XDestroyImage(im1);
		if (im2 != (XImage *) 0)
			XDestroyImage(im2);

/* Repeat for each type-window visual. */
	}

	CHECKPASS(6*nvinf());
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.363684 */
static void t008(){

int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion XGetImage-8.(D)");
	report_assertion("When the drawable is a window and the window has");
	report_assertion("backing-store and has regions obscured by noninferior");
	report_assertion("windows, then backing store contents are returned for those");
	report_assertion("regions in the XImage structure returned by a call to");
	report_assertion("XGetImage.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.363684 */

/* Including from file Mdefcode.tmc.363684 */
static void t009(){

int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion XGetImage-9.(D)");
	report_assertion("When the drawable is a window and the window does not have");
	report_assertion("backing-store and regions of the window are obscured by");
	report_assertion("noninferior windows, then undefined values are returned for");
	report_assertion("those regions.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.363684 */

/* Including from file Mdefcode.tmc.363684 */
static void t010(){

int 	pass = 0, fail = 0;

 	report_purpose(10);

	report_assertion("Assertion XGetImage-10.(B)");
	report_assertion("When the drawable is a window and visible regions of the");
	report_assertion("window are obscured by inferior windows of different depth");
	report_assertion("to the specified window, then undefined values are returned");
	report_assertion("for those regions.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.363684 */

static void t011(){

XVisualInfo *vp;
Window w;
XImage *im1, *im2;	/* two images */
int root_x, root_y;	/* pointer location after XGetImage */
int oroot_x, oroot_y;	/* pointer location before XGetImage */
int sroot_x, sroot_y;	/* initial pointer location */
Window oldroot;		/* initial root window */
int itmp;		/* useless XQueryPointer return values */
unsigned int uitmp;	/* useless XQueryPointer return values */
Window wtmp;		/* useless XQueryPointer return values */
static struct area area =
	{ 0, 0, W_STDWIDTH, W_STDHEIGHT };
int 	pass = 0, fail = 0;

 	report_purpose(11);

	report_assertion("Assertion XGetImage-11.(A)");
	report_assertion("The pointer cursor image is not included in the returned");
	report_assertion("contents.");

	report_strategy("Create drawable.");
	report_strategy("Grab server.");
	report_strategy("Enable synchronization.");
	report_strategy("Save initial pointer location.");
	report_strategy("Warp pointer to drawable.");
	report_strategy("Get new pointer location.");
	report_strategy("Call XGetImage with pointer inside drawable.");
	report_strategy("Verify XGetImage returned success.");
	report_strategy("Verify depth, width, height, and format values in gotten image structure.");
	report_strategy("Get current pointer location.");
	report_strategy("Check to see if pointer moved.");
	report_strategy("Warp pointer outside of drawable.");
	report_strategy("Get new pointer location.");
	report_strategy("Call XGetImage with pointer outside drawable.");
	report_strategy("Verify XGetImage returned success.");
	report_strategy("Verify depth, width, height, and format values in gotten image structure.");
	report_strategy("Get current pointer location.");
	report_strategy("Check to see if pointer moved.");
	report_strategy("Warp pointer back to where it started.");
	report_strategy("Disable synchronization.");
	report_strategy("Ungrab server.");
	report_strategy("Verify that two images are identical.");
	report_strategy("Destroy gotten images.");

	tpstartup();
	setargs();
	im1 = im2 = (XImage *) 0;
	resetvinf(VI_WIN);
	nextvinf(&vp);	/* use first one we come to */

/* Create drawable. */
	w = makewin(display, vp);

/* Grab server. */
	XGrabServer(display);

/* Enable synchronization. */
	XSynchronize(display, True);

/* Save initial pointer location. */
	XQueryPointer(display, w, &oldroot, &wtmp, &sroot_x, &sroot_y, &itmp, &itmp, &uitmp);

/* Warp pointer to drawable. */
	XWarpPointer(display, None, w, 0, 0, 0, 0, 0, 0);

/* Get new pointer location. */
	if (XQueryPointer(display, w, &wtmp, &wtmp, &oroot_x, &oroot_y, &itmp, &itmp, &uitmp) == False) {
		delete("Pointer on wrong root.");
		return;
	} else
		CHECK;

/* Call XGetImage with pointer inside drawable. */
	pre_xcall(w, &area, AllPlanes, ZPixmap);
	startcall(display);
	if (isdeleted())
		return;
	im1 = XGetImage(display, d, x, y, width, height, plane_mask, format);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify XGetImage returned success. */
	if (geterr() != Success)
		FAIL;
	else
		CHECK;

/* Verify depth, width, height, and format values in gotten image structure. */
	if (checkimgstruct(im1, vp->depth, area.width, area.height, ZPixmap) == False)
		FAIL;
	else
		CHECK;

/* Get current pointer location. */
	if (XQueryPointer(display, w, &wtmp, &wtmp, &root_x, &root_y, &itmp, &itmp, &uitmp) == False) {
		delete("Pointer moved.");
		return;
	}
	else
		CHECK;

/* Check to see if pointer moved. */
	if (oroot_x != root_x || oroot_y != root_y) {
		delete("Pointer moved.");
		return;
	}
	else
		CHECK;

/* Warp pointer outside of drawable. */
	XWarpPointer(display, None, w, W_STDWIDTH*2, W_STDHEIGHT*2, 0, 0, 0, 0);

/* Get new pointer location. */
	XQueryPointer(display, w, &wtmp, &wtmp, &oroot_x, &oroot_y, &itmp, &itmp, &uitmp);

/* Call XGetImage with pointer outside drawable. */
	pre_xcall(w, &area, AllPlanes, ZPixmap);
	startcall(display);
	if (isdeleted())
		return;
	im2 = XGetImage(display, d, x, y, width, height, plane_mask, format);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify XGetImage returned success. */
	if (geterr() != Success)
		FAIL;
	else
		CHECK;

/* Verify depth, width, height, and format values in gotten image structure. */
	if (checkimgstruct(im2, vp->depth, area.width, area.height, ZPixmap) == False)
		FAIL;
	else
		CHECK;

/* Get current pointer location. */
	if (XQueryPointer(display, w, &wtmp, &wtmp, &root_x, &root_y, &itmp, &itmp, &uitmp) == False) {
		delete("Pointer moved.");
		return;
	}
	else
		CHECK;

/* Check to see if pointer moved. */
	if (oroot_x != root_x || oroot_y != root_y) {
		delete("Pointer moved.");
		return;
	}
	else
		CHECK;

/* Warp pointer back to where it started. */
	XWarpPointer(display, None, oldroot, 0, 0, 0, 0, sroot_x, sroot_y);

/* Disable synchronization. */
	XSynchronize(display, False);

/* Ungrab server. */
	XUngrabServer(display);

/* Verify that two images are identical. */
	if (im1 == (XImage *) 0 || im2 == (XImage *) 0) {
		report("Null image returned.");
		FAIL;
	}
	else {
		int stop = 0;

		CHECK;
		for (root_x = 0; !stop && root_x < im1->width; root_x++)
			for (root_y = 0; !stop && root_y < im1->height; root_y++)
				if (XGetPixel(im1, root_x, root_y) !=
				    XGetPixel(im2, root_x, root_y))
					stop = 1;
		if (stop) {
			report("Images differ at (%d,%d)", root_x, root_y);
			FAIL;
		}
		else
			CHECK;
	}

/* Destroy gotten images. */
	if (im1 != (XImage *) 0)
		XDestroyImage(im1);
	if (im2 != (XImage *) 0)
		XDestroyImage(im2);
	CHECKPASS(11);
	tpcleanup();
	pfcount(pass, fail);
}

static void t012(){

Window w;
XImage *image;
static struct area area =
	{ 0, 0, W_STDWIDTH, W_STDHEIGHT };
int 	pass = 0, fail = 0;

 	report_purpose(12);

	report_assertion("Assertion XGetImage-12.(A)");
	report_assertion("When XGetImage fails, then it returns NULL.");

	report_strategy("Create bad drawable.");
	report_strategy("Call XGetImage with bad drawable.");
	report_strategy("Verify XGetImage return value is null.");

	tpstartup();
	setargs();
/* Create bad drawable. */
	w = badwin(display);

/* Call XGetImage with bad drawable. */
	pre_xcall(w, &area, AllPlanes, ZPixmap);
	startcall(display);
	if (isdeleted())
		return;
	image = XGetImage(display, d, x, y, width, height, plane_mask, format);
	endcall(display);
	if (geterr() != BadDrawable) {
		report("Got %s, Expecting BadDrawable", errorname(geterr()));
		FAIL;
	}

/* Verify XGetImage return value is null. */
	if (image == (XImage *) 0) {
		CHECK;
		if (geterr() != BadDrawable)
			trace("Returned null, but returned incorrect error");
	}
	else {
		FAIL;
		/* Destroy gotten images. */
		XDestroyImage(image);
	}
	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t013(){

XVisualInfo *vp;
Pixmap p;
XImage *image;
static struct area area1 =
	{ -W_STDWIDTH, -W_STDHEIGHT, W_STDWIDTH*2, W_STDHEIGHT*2 };
int 	pass = 0, fail = 0;

 	report_purpose(13);

	report_assertion("Assertion XGetImage-13.(A)");
	report_assertion("When the drawable is a pixmap and the given rectangle is");
	report_assertion("not wholly contained within the pixmap, then a BadMatch");
	report_assertion("error occurs.");

	report_strategy("Create pixmap.");
	report_strategy("Call XGetImage with rectangle not wholly contained within the pixmap.");
	report_strategy("Verify XGetImage return value is null.");
	report_strategy("Verify that BadMatch error occurred.");

	tpstartup();
	setargs();
	resetvinf(VI_PIX);
	nextvinf(&vp);	/* use first one we come to */

/* Create pixmap. */
	p = makepixm(display, vp);

/* Call XGetImage with rectangle not wholly contained within the pixmap. */
	pre_xcall(p, &area1, AllPlanes, ZPixmap);
	startcall(display);
	if (isdeleted())
		return;
	image = XGetImage(display, d, x, y, width, height, plane_mask, format);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}

/* Verify XGetImage return value is null. */
	if (image != (XImage *) 0) {
		report("Null image not returned.");
		FAIL;
		/* Destroy gotten images. */
		XDestroyImage(image);
	}
	else
		CHECK;
/* Verify that BadMatch error occurred. */
	if (geterr() != BadMatch)
		FAIL;
	else
		CHECK;

	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

static void t014(){

XVisualInfo *vp;
Window w;
XImage *image;
static struct area area1 =
	{ 0, 0, W_STDWIDTH, W_STDHEIGHT };
int 	pass = 0, fail = 0;

 	report_purpose(14);

	report_assertion("Assertion XGetImage-14.(A)");
	report_assertion("When the drawable is a window and the window is not");
	report_assertion("viewable, then a BadMatch error occurs.");

	report_strategy("Create window.");
	report_strategy("Call XUnmapWindow to make the window non-viewable.");
	report_strategy("Call XGetImage on window which is not viewable.");
	report_strategy("Verify XGetImage return value is null.");
	report_strategy("Verify that BadMatch error occurred.");

	tpstartup();
	setargs();
	resetvinf(VI_WIN);
	nextvinf(&vp);	/* use first one we come to */

/* Create window. */
	w = makewin(display, vp);

/* Call XUnmapWindow to make the window non-viewable. */
	XUnmapWindow(display, w);

/* Call XGetImage on window which is not viewable. */
	pre_xcall(w, &area1, AllPlanes, ZPixmap);
	startcall(display);
	if (isdeleted())
		return;
	image = XGetImage(display, d, x, y, width, height, plane_mask, format);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}

/* Verify XGetImage return value is null. */
	if (image != (XImage *) 0) {
		report("Null image not returned.");
		FAIL;
		/* Destroy gotten images. */
		XDestroyImage(image);
	}
	else
		CHECK;

/* Verify that BadMatch error occurred. */
	if (geterr() != BadMatch)
		FAIL;
	else
		CHECK;

	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

static void t015(){

XVisualInfo *vp;
Window w;
static struct area area1 =
	{ 0, 0, W_STDWIDTH, W_STDHEIGHT };
static struct area area2 =
	{ 0, 0, W_STDWIDTH, W_STDHEIGHT };
XImage *image;
int 	pass = 0, fail = 0;

 	report_purpose(15);

	report_assertion("Assertion XGetImage-15.(A)");
	report_assertion("When the drawable is a window and the window is viewable");
	report_assertion("and it is not the case that given there were no inferiors or");
	report_assertion("overlapping windows the specified rectangle of the window");
	report_assertion("would be fully visible on the screen and wholly contained");
	report_assertion("within the outside edges of the window, then a BadMatch");
	report_assertion("error occurs.");

	report_strategy("Create window which is not fully visible on the screen.");
	report_strategy("Call XMapWindow to make sure the window is viewable.");
	report_strategy("Call XGetImage with rectangle extending beyond edge of screen.");
	report_strategy("Verify XGetImage return value is null.");
	report_strategy("Verify that BadMatch error occurred.");
	report_strategy("Create window which is fully visible on the screen.");
	report_strategy("Call XMapWindow to make sure the window is viewable.");
	report_strategy("Call XGetImage with rectangle extending beyond edge of window.");
	report_strategy("Verify XGetImage return value is null.");
	report_strategy("Verify that BadMatch error occurred.");

	tpstartup();
	setargs();
	resetvinf(VI_WIN);
	nextvinf(&vp);	/* use first one we come to */

/* Create window which is not fully visible on the screen. */
	w = makewinpos(display, vp, -W_STDWIDTH/2, -W_STDHEIGHT/2);

/* Call XMapWindow to make sure the window is viewable. */
	XMapWindow(display, w);

/* Call XGetImage with rectangle extending beyond edge of screen. */
	pre_xcall(w, &area1, AllPlanes, ZPixmap);
	startcall(display);
	if (isdeleted())
		return;
	image = XGetImage(display, d, x, y, width, height, plane_mask, format);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}

/* Verify XGetImage return value is null. */
	if (image != (XImage *) 0) {
		report("Null image not returned.");
		FAIL;
		/* Destroy gotten images. */
		XDestroyImage(image);
	}
	else
		CHECK;

/* Verify that BadMatch error occurred. */
	if (geterr() != BadMatch)
		FAIL;
	else
		CHECK;

/* Create window which is fully visible on the screen. */
	w = makewinpos(display, vp, 0, 0);

/* Call XMapWindow to make sure the window is viewable. */
	XMapWindow(display, w);

/* Call XGetImage with rectangle extending beyond edge of window. */
	area2.width *= 2;
	area2.height *= 2;
	pre_xcall(w, &area2, AllPlanes, ZPixmap);
	startcall(display);
	if (isdeleted())
		return;
	image = XGetImage(display, d, x, y, width, height, plane_mask, format);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}

/* Verify XGetImage return value is null. */
	if (image != (XImage *) 0) {
		report("Null image not returned.");
		FAIL;
		/* Destroy gotten images. */
		XDestroyImage(image);
	}
	else
		CHECK;

/* Verify that BadMatch error occurred. */
	if (geterr() != BadMatch)
		FAIL;
	else
		CHECK;

	CHECKPASS(4);
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/EDra.mc */
/* End of included file error/EDra.mc */

/* Including from file error/EDra.mc */
static void t016(){

int 	pass = 0, fail = 0;

 	report_purpose(16);

	report_assertion("Assertion XGetImage-16.(A)");
	report_assertion("When a drawable argument does not name a valid Drawable,");
	report_assertion("then a BadDrawable error occurs.");

	report_strategy("Create a bad drawable by creating and destroying a window.");
	report_strategy("Call test function using bad drawable as the drawable argument.");
	report_strategy("Verify that a BadDrawable error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	A_DRAWABLE = (Drawable)badwin(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	XGetImage(display, d, x, y, width, height, plane_mask, format);
	endcall(display);
	if (geterr() != BadDrawable) {
		report("Got %s, Expecting BadDrawable", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadDrawable)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EDra.mc */

/* Including from file Mval.tmc.363684 */
/* End of included file Mval.tmc.363684 */

/* Including from file error/EVal.mc */
static void t017(){

#undef	VALUE_ARG
#define	VALUE_ARG format
#undef	VALUE_LIST
#define	VALUE_LIST formatvallist
#undef NOTMEMTYPE
#define NOTMEMTYPE 
#undef	NOTMEMBER
#define	NOTMEMBER notmember
int 	i;
int 	n;
NOTMEMTYPE
long	vals[NM_LEN];
int 	pass = 0, fail = 0;

 	report_purpose(17);

	report_assertion("Assertion XGetImage-17.(A)");
	report_assertion("When the value of format is other than XYPixmap or ZPixmap,");
	report_assertion("then a BadValue error occurs.");

	report_strategy("Obtain a sequence of values which are not in the list specified by VALUE_LIST.");
	report_strategy("For each value:");
	report_strategy("  Call test function with this value in the VALUE_ARG argument.");
	report_strategy("  Verify that a BadValue error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	n = NOTMEMBER(VALUE_LIST, NELEM(VALUE_LIST), vals);

	for (i = 0; i < n; i++) {

		debug(1, "Trying arg of %d", vals[i]);

		VALUE_ARG = vals[i];
		startcall(display);
		if (isdeleted())
			return;
		XGetImage(display, d, x, y, width, height, plane_mask, format);
		endcall(display);
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
		}

		if (geterr() == BadValue)
			CHECK;
		else {
			trace("Value of %d did not give BadValue", vals[i]);
			FAIL;
		}
	}

	CHECKPASS(n);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EVal.mc */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ t012, 12 },
	{ t013, 13 },
	{ t014, 14 },
	{ t015, 15 },
	{ t016, 16 },
	{ t017, 17 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
