/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

#ifndef XavsRChar
#define XavsRChar "Char"
#endif

Boolean XtCVT_StringToChar(display, args, num_args, from_val, to_val, converter_data)
Display *display;
XrmValuePtr args;
Cardinal *num_args;
XrmValue *from_val;
XrmValue *to_val;
XtPointer *converter_data;
{
	char *str = (char *) (from_val->addr);
	static unsigned char i;
	to_val->size = sizeof (unsigned char);
	to_val->addr = (XtPointer) &i;
	i = *str;
	return(True);
}

void XtDES_Proc(app_ctext, to_val, converter_data, args, num_args )
XtAppContext app_ctext;
XrmValue *to_val;
XtPointer converter_data;
XrmValuePtr args;
Cardinal *num_args;
{
	avs_set_event(1,avs_get_event(1)+1);
}


#define T_XtCallbackReleaseCacheRef	1
char    *TestName = "XtCallbackReleaseCacheRef";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Display *display_good;
XrmValue from, from_val;
XrmValue to_in_out;
XrmValue to_return;
XtCacheRef cache_ref_return;
Boolean status;
pid_t pid2;
unsigned char tchar;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtCallbackReleaseCacheRef-1.(A)");
	report_assertion("When added to a callback list with client_data specified as");
	report_assertion("an XtCacheRef value and later invoked, void");
	report_assertion("XtCallbackReleaseCacheRef(object, client_data, call_data)");
	report_assertion("shall decrement the reference count for the conversion entry");
	report_assertion("specified by client_data.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tcalbkrlc1", "XtCallbackReleaseCacheRef");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Register resource converter XtCVT_StringToChar");
	XtAppSetTypeConverter(app_ctext,
		 XtRString,
		 XavsRChar,
		 XtCVT_StringToChar,
		 (XtConvertArgList)NULL,
		 (Cardinal)0,
		 XtCacheAll|XtCacheRefCount,
		 XtDES_Proc);
	tet_infoline("PREP: Invoke converter XtCVT_StringToChar and cache resources");
	display_good = XtDisplay(topLevel);
	from.addr = (XtPointer)"Hello";
	from.size = sizeof(unsigned char);
	to_in_out.size = sizeof(unsigned char);
	to_in_out.addr = (XtPointer)&tchar;
	status = XtCallConverter(display_good,
		XtCVT_StringToChar,
		(XrmValuePtr)NULL,
		(Cardinal)0,
		&from,
		&to_in_out,
		&cache_ref_return
		);
	tet_infoline("TEST: Invoke XtCallbackReleaseCacheRef callback");
	XtAddCallback(topLevel, XtNdestroyCallback, XtCallbackReleaseCacheRef, (XtPointer)cache_ref_return);
	XtCallCallbacks(topLevel, XtNdestroyCallback, (XtPointer)NULL);
	tet_infoline("TEST: Destructor was called");
	status = avs_get_event(1);
	check_dec(1, status, "destructor invocation count");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.363244 */
/* End of included file Mdefcode.tmc.363244 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
