/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   Time
 *   XtLastTimestampProcessed()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

extern char *event_names[];

/*
** XtEVT_Proc
*/
void XtEVT_Proc(w, client_data, event, continue_to_dispatch)
Widget w;
XtPointer client_data;
XEvent *event;
Boolean *continue_to_dispatch;
{
	if ( event->type == ButtonPress )
	avs_set_event(1, 1);
	else {
	sprintf(ebuf, "ERROR: Event %s invoked procedure XtEVT_Proc", event_names[event->type]);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
}

#define DESIRED_TIME (Time) 779

void analyse_events(quit)
Widget quit;
{
	XtAppContext app_context;
	Display *display;
	XEvent loop_event;
	XEvent event_return;
	Time time_stamp;
	Widget widget;
	widget = XtParent(quit);
	app_context = XtWidgetToApplicationContext(widget);
	display = XtDisplay(widget);
	for (;;) {
	 XtAppNextEvent(app_context, &loop_event);
	 XSync(display, False);
		if ( loop_event.type == ButtonPress ) {
	 	XtDispatchEvent(&loop_event);
		tet_infoline("PREP: Get timestamp of ButtonPress");
		tet_infoline("TEST: Timestamp value");
	 	time_stamp = XtLastTimestampProcessed(display);
	 	if (!time_stamp) {
			sprintf(ebuf, "ERROR: Expected non-zero timestamp, got %d, event stamp %d", time_stamp, loop_event.xbutton.time);
			tet_infoline(ebuf);
			tet_result(TET_FAIL);
	 	}
		exit(0);
	}
	 XtDispatchEvent(&loop_event);
	} /* end for */
}

void analyse_events2(quit)
Widget quit;
{
	XtAppContext app_context;
	Display *display;
	XEvent loop_event;
	XEvent event_return;
	Time time_stamp;
	Widget widget;
	widget = XtParent(quit);
	app_context = XtWidgetToApplicationContext(widget);
	display = XtDisplay(widget);
	for (;;) {
		XtAppNextEvent(app_context, &loop_event);
		XSync(display, False);
		tet_infoline("PREP: Get timestamp before events processed");
		time_stamp = XtLastTimestampProcessed(display);
		tet_infoline("TEST: Timestamp value");
		avs_set_event(1, 1);
		if (time_stamp != 0) {
			sprintf(ebuf, "ERROR: Expected zero timestamp, got %d", time_stamp);
			tet_infoline(ebuf);
			tet_result(TET_FAIL);
		}
		exit(0);
	}
}


#define T_XtLastTimestampProcessed	1
char    *TestName = "XtLastTimestampProcessed";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Boolean dispatched;
Widget labelw_msg;
char *msg = "Test widget";
pid_t pid2;
int invoked = 0;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtLastTimestampProcessed-1.(A)");
	report_assertion("A successful call to Time XtLastTimestampProcessed(display)");
	report_assertion("shall return the timestamp from the most recent event passed");
	report_assertion("to XtDispatchEvent for the display display that contained a");
	report_assertion("timestamp.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tltmsproc1", "XtLastTimestampProcessed");
	tet_infoline("PREP: Create a test labelw_msg widget");
	labelw_msg = (Widget) CreateLabelWidget(msg, boxw1);
	tet_infoline("PREP: Register procedure XtEVT_Proc to handle events to");
	tet_infoline("PREP: labelw_msg widget");
	XtAddEventHandler(labelw_msg,
		 ButtonPress,
		 False,
		 XtEVT_Proc,
		 (XtPointer)NULL
		 );
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Send ButtonPress event");
	send_event_time(labelw_msg, ButtonPress, ButtonPressMask, TRUE, DESIRED_TIME);
	analyse_events(click_quit);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: XtEVT_Proc was invoked");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "XtEVT_Proc invocations count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.364788 */
/* End of included file Mdefcode.tmc.364788 */

static void t002(){

Boolean dispatched;
Widget labelw_msg;
char *msg = "Test widget";
pid_t pid2;
int invoked = 0;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtLastTimestampProcessed-2.(A)");
	report_assertion("When no KeyPress, KeyRelease, ButtonPress, ButtonRelease,");
	report_assertion("MotionNotify, EnterNotify, LeaveNotify, PropertyNotify or");
	report_assertion("SelectionClear event has yet been passed to XtDispatchEvent");
	report_assertion("for the display display a call to Time");
	report_assertion("XtLastTimestampProcessed(display) shall return zero.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tltmsproc2", "XtLastTimestampProcessed");
	tet_infoline("PREP: Create a test labelw_msg widget");
	labelw_msg = (Widget) CreateLabelWidget(msg, boxw1);
	tet_infoline("PREP: Register procedure XtEVT_Proc to handle events to");
	tet_infoline("PREP: labelw_msg widget");
	XtAddEventHandler(labelw_msg,
		 ButtonPress,
		 False,
		 XtEVT_Proc,
		 (XtPointer)NULL
		 );
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Send ButtonPress event");
	send_event_time(labelw_msg, ButtonPress, ButtonPressMask, TRUE, DESIRED_TIME);
	analyse_events2(click_quit);
	LKROF(pid2, AVSXTTIMEOUT-2);
	if (avs_get_event(1) == 0) {
		tet_infoline("ERROR: Event loop terminated abnormally");
		tet_result(TET_FAIL);
	}
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.364788 */
/* End of included file Mdefcode.tmc.364788 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
