/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   XrmDatabase
 *   XtDatabase()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;


#define T_XtDatabase	1
char    *TestName = "XtDatabase";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Display	*display;
Widget	labelw_good;
XrmDatabase database;
char	*str_type;
int	argcount = 0;
XrmValue	value[1];
static String fallback_res[] = {
	"*hello.labelString:  Hello World",
	NULL,
};
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtDatabase-1.(A)");
	report_assertion("A call to XrmDatabase XtDatabase(display) shall return the");
	report_assertion("default resource database associated with display.");
	FORK(pid);
	initconfig();

	XtToolkitInitialize();
	app_ctext = XtCreateApplicationContext();
	tet_infoline("PREP: Set default set of resource values.");
	XtAppSetFallbackResources(app_ctext, fallback_res);
	tet_infoline("PREP: Initialize display");
	sleep(config.reset_delay);
	display = XOpenDisplay(config.display);
	if (display == 0) {
		tet_infoline("ERROR: Cannot open display");
		tet_result(TET_FAIL);
		exit(1);
	}
	XtDisplayInitialize(app_ctext, display,
		    "tdtbs1", "Tdtbs1",
		    (XrmOptionDescRec *)NULL,
		    (Cardinal)0, &argcount,
		    (String *)NULL );
	tet_infoline("TEST: Get the resource database");
	database = XtDatabase(display);
	tet_infoline("TEST: Check resource values");
	XrmGetResource(database, "hello.labelString", NULL,
		   &str_type, &value[0]);
	if (strncmp("Hello World", value[0].addr, strlen("Hello World")) != 0 ) {
	    	sprintf(ebuf, "ERROR: Expected \"Hello World\"for hello.labelString,  Received %s", value[0].addr);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.364520 */
/* End of included file Mdefcode.tmc.364520 */

static void t002(){

Display	*display;
XrmDatabase	database;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtDatabase-2.(C)");
	report_assertion("If the implementation is X11R5 or later: A call to");
	report_assertion("XrmDatabase XtDatabase(display) when display has not been");
	report_assertion("initialized shall return NULL.");
	FORK(pid);
	initconfig();

#if XT_X_RELEASE > 4
	XtToolkitInitialize();
	app_ctext = XtCreateApplicationContext();
        if (app_ctext == NULL) {
        	tet_infoline("ERROR: Expected valid application context returned NULL");
                tet_result(TET_FAIL);
                return;
        }
	tet_infoline("PREP: Open display");
	sleep(config.reset_delay);
        display = XOpenDisplay(config.display);
	if (display == 0) {
		tet_infoline("ERROR: Cannot open display");
		tet_result(TET_FAIL);
		exit(1);
	}
	tet_infoline("TEST: Database is NULL");
	database = XtDatabase(display);
	if (database != NULL) {
	    	tet_infoline("ERROR: Expected return of NULL");
		tet_result(TET_FAIL);
	}
	tet_result(TET_PASS);
#else
	tet_infoline("INFO: Implementation is X11R4");
	tet_result(TET_UNSUPPORTED);
#endif

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.364520 */
/* End of included file Mdefcode.tmc.364520 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
