/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   Boolean
 *   XtDispatchEvent()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

extern char *event_names[] ;

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;
Widget labelw_msg;

/*
** XtEVT_Proc
*/
void XtEVT_Proc(w, client_data, event, continue_to_dispatch)
Widget w;
XtPointer client_data;
XEvent *event;
Boolean *continue_to_dispatch;
{
	if ( event->type == KeyPress ) {
		avs_set_event(1,1);
		exit(0);
	}
	else {
		sprintf(ebuf, "ERROR: Expected KeyPress event Received %s", event_names[event->type]);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
		exit(0);
	}
}
void XtTMO_Proc(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
	exit(0);
}
void XtTMO_Proc5(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
	tet_infoline("PREP: Send events");
	send_event_time(labelw_msg, ButtonPress, ButtonPressMask, TRUE, 1);
	send_event_time(labelw_msg, ButtonRelease, ButtonReleaseMask, TRUE, 2);
	send_event_time(labelw_msg, KeyRelease, KeyReleaseMask, TRUE, 3);
	send_event_time(labelw_msg, KeyPress, KeyPressMask, TRUE, 4);
	tet_infoline("PREP: Register timeout");
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, XtTMO_Proc, topLevel);
}
void XtEVT_Proc2(w, client_data, event, continue_to_dispatch)
Widget w;
XtPointer client_data;
XEvent *event;
Boolean *continue_to_dispatch;
{
XKeyEvent *tevent;

	tevent = (XKeyEvent *)event;

	tet_infoline("TEST: Event timestamp returned by XtLastTimestampProcessed");
	if (tevent->time != XtLastTimestampProcessed(XtDisplay(w))) {
		sprintf(ebuf, "ERROR: event->time = %ld, XtLastTimestampProcessed returned %ld", (unsigned long)tevent->time, (unsigned long)XtLastTimestampProcessed(XtDisplay(w)));
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	if (event->type == ButtonPress )
		avs_set_event(1, 1); 
	if (event->type == ButtonRelease )
		avs_set_event(2, 1); 
	if (event->type == KeyPress )
		avs_set_event(3, 1); 
	if (event->type == KeyRelease )
		avs_set_event(4, 1); 
}
static void analyse_events1(quit)
Widget quit;
{

int i;
XtAppContext app_context;
Display *display;
XEvent loop_event;
XEvent event_return;
int status;
Widget widget;

	widget = XtParent(quit);
	app_context = XtWidgetToApplicationContext(widget);
	display = XtDisplay(widget);
	for (i = 1; i == 1;) {
		XtAppNextEvent(app_context, &loop_event);
	 	XSync(display, False);
		/*
		** If KeyPress event should invoke XtEVT_Proc
		*/
		if (loop_event.type == KeyPress) {
			tet_infoline("TEST: XtDispatchEvent finds handler");
	 		status = XtDispatchEvent(&loop_event);
	 		check_dec(True, status, "XtDispatchEvent return");
		}
		else
			XtDispatchEvent(&loop_event);
	} /* end for */
}

static void analyse_events2(quit)
Widget quit;
{
int i;
XtAppContext app_context;
Display *display;
XEvent loop_event;
XEvent event_return;
int status;
Widget widget;

	widget = XtParent(quit);
	app_context = XtWidgetToApplicationContext(widget);
	display = XtDisplay(widget);
	for (i = 1; i == 1;) {
	 	XtAppNextEvent(app_context, &loop_event);
	 	XSync(display, False);
		if (loop_event.type == KeyRelease) {
			tet_infoline("TEST: XtDispatchEvent returns False");
	 		status = XtDispatchEvent(&loop_event);
	 		check_dec(False, status, "XtDispatchEvent return");	
			exit(0);
		}
		else
			XtDispatchEvent(&loop_event);
	} /* end for */
}


#define T_XtDispatchEvent	1
char    *TestName = "XtDispatchEvent";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

#if XT_X_RELEASE > 4
extern char *event_names[];
Boolean dispatched;
char *msg = "Test widget";
pid_t pid2;
int invoked = 0;
#endif
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtDispatchEvent-1.(C)");
	report_assertion("If the implementation is X11R5 or later: A successful call");
	report_assertion("to Boolean XtDispatchEvent(event) when no input method has");
	report_assertion("been registered on the event event for the widget to which");
	report_assertion("the event is to be dispatched shall dispatch the event to");
	report_assertion("handler procedures previously registered and return True.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

#if XT_X_RELEASE > 4
	FORK(pid2);
	avs_xt_hier("Tdispatet1", "XtDispatchEvent");
	tet_infoline("PREP: Create a test labelw_msg widget");
	labelw_msg = (Widget) CreateLabelWidget(msg, boxw1);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Register XtEVT_Proc to handle events to labelw_msg");
	XtAddEventHandler(labelw_msg,
		 KeyPressMask,
		 False,
		 XtEVT_Proc,
		 (Widget)NULL
		 );
	tet_infoline("PREP: Send ButtonPress over wire to widget labelw_msg");
	send_event(labelw_msg, KeyPress, KeyPressMask, TRUE);
	tet_infoline("TEST: Handler was invoked");
	analyse_events1(click_quit);
	LKROF(pid2, AVSXTTIMEOUT-2);
	invoked = avs_get_event(1);
	check_dec(1, invoked, "XtEVT_Proc invocation count");
	tet_result(TET_PASS);
#else
	tet_infoline("INFO: Implementation is not X11R5 or greater");
	tet_result(TET_UNSUPPORTED);
#endif

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.364652 */
/* End of included file Mdefcode.tmc.364652 */

static void t002(){

#if XT_X_RELEASE == 4
extern char *event_names[];
Boolean dispatched;
char *msg = "Test widget";
pid_t pid2;
int invoked = 0;
#endif
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtDispatchEvent-2.(C)");
	report_assertion("If the implementation is X11R4: A successful call to");
	report_assertion("Boolean XtDispatchEvent(event) shall dispatch the event to");
	report_assertion("the handler procedure previously registered for the widget");
	report_assertion("to which the event is to be dispatched and return True.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

#if XT_X_RELEASE == 4
	FORK(pid2);
	avs_xt_hier("Tdispatet1", "XtDispatchEvent");
	tet_infoline("PREP: Create a test labelw_msg widget");
	labelw_msg = (Widget) CreateLabelWidget(msg, boxw1);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Register XtEVT_Proc to handle events to labelw_msg");
	XtAddEventHandler(labelw_msg,
		 KeyPressMask,
		 False,
		 XtEVT_Proc,
		 (Widget)NULL
		 );
	tet_infoline("PREP: Send ButtonPress over wire to widget labelw_msg");
	send_event(labelw_msg, KeyPress, KeyPressMask, TRUE);
	tet_infoline("TEST: Handler was invoked");
	analyse_events1(click_quit);
	LKROF(pid2, AVSXTTIMEOUT-2);
	invoked = avs_get_event(1);
	check_dec(1, invoked, "XtEVT_Proc invocation count");
	tet_result(TET_PASS);
#else
	tet_infoline("INFO: Implementation is not X11R4");
	tet_result(TET_UNSUPPORTED);
#endif

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.364652 */
/* End of included file Mdefcode.tmc.364652 */

/* Including from file Mdefcode.tmc.364652 */
static void t003(){

pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtDispatchEvent-3.(D)");
	report_assertion("If the implementation is X11R5 or later: A call to Boolean");
	report_assertion("XtDispatchEvent(event) when an input method has been");
	report_assertion("registered on the event event for the widget to which the");
	report_assertion("event is to be dispatched and the specified event has not");
	report_assertion("caused a server keyboard or a pointer grab shall return True");
	report_assertion("immediately.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.364652 */

/* Including from file Mdefcode.tmc.364652 */
static void t004(){

pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtDispatchEvent-4.(D)");
	report_assertion("If the implementation is X11R5 or later: A successful call");
	report_assertion("to Boolean XtDispatchEvent(event) when an input method has");
	report_assertion("been registered on the event event for the widget to which");
	report_assertion("the event is to be dispatched and the event caused the");
	report_assertion("activation of a server keyboard grab shall cancel the");
	report_assertion("keyboard grab, not perform any other action, and return");
	report_assertion("True.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.364652 */

/* Including from file Mdefcode.tmc.364652 */
static void t005(){

pid_t	pid;

 	report_purpose(5);

	report_assertion("Assertion XtDispatchEvent-5.(D)");
	report_assertion("If the implementation is X11R5 or later: A successful call");
	report_assertion("to Boolean XtDispatchEvent(event) when an input method has");
	report_assertion("been registered on the event event for the widget to which");
	report_assertion("the event is to be dispatched and the event caused the");
	report_assertion("activation of a server pointer grab shall cancel the pointer");
	report_assertion("grab, not perform any other action, and return True.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.364652 */

static void t006(){

extern char *event_names[];
Boolean dispatched;
pid_t pid2;
int invoked = 0;
int i;
Display *display;
XEvent loop_event;
char *msg = "Test Widget";
pid_t	pid;

 	report_purpose(6);

	report_assertion("Assertion XtDispatchEvent-6.(A)");
	report_assertion("When event is a KeyPress, KeyRelease, ButtonPress,");
	report_assertion("ButtonRelease, MotionNotify, EnterNotify, LeaveNotify,");
	report_assertion("PropertyNotify or a SelectionClear event a call to Boolean");
	report_assertion("XtDispatchEvent(event) shall record the timestamp from the");
	report_assertion("event as the last timestamp value that will be returned by");
	report_assertion("the next call to XtLastTimestampProcessed.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tdispatet1", "XtDispatchEvent");
	tet_infoline("PREP: Create a test labelw_msg widget");
	labelw_msg = (Widget) CreateLabelWidget(msg, boxw1);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Register XtEVT_Proc to handle events to labelw_msg");
	XtAddEventHandler(labelw_msg,
		 ButtonPressMask|ButtonReleaseMask|KeyPressMask|KeyReleaseMask,
		 False,
		 XtEVT_Proc2,
		 (Widget)NULL
		 );
	tet_infoline("PREP: Register timeout procedure which will cause events");
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, XtTMO_Proc5, topLevel);
	display = XtDisplay(topLevel);
	for (i = 1; i == 1;) {
		XtAppNextEvent(app_ctext, &loop_event);
	 	XSync(display, False);
		XtDispatchEvent(&loop_event);
	} /* end for */
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Events were received");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "Handler invocation for ButtonPress count");
	invoked = avs_get_event(2);
	check_dec(1, invoked, "Handler invocation for ButtonRelease count");
	invoked = avs_get_event(3);
	check_dec(1, invoked, "Handler invocation for KeyPress count");
	invoked = avs_get_event(4);
	check_dec(1, invoked, "Handler invocation for KeyRelease count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.364652 */
/* End of included file Mdefcode.tmc.364652 */

/* Including from file Mdefcode.tmc.364652 */
static void t007(){

pid_t	pid;

 	report_purpose(7);

	report_assertion("Assertion XtDispatchEvent-7.(D)");
	report_assertion("If the implementation is X11R5 or later: When event is a");
	report_assertion("remap event, a modal cascade exists that has a widget with");
	report_assertion("spring_loaded field set to True, and no event input filter");
	report_assertion("has been registered for the spring-loaded widget on the");
	report_assertion("specified event a call to Boolean XtDispatchEvent(event)");
	report_assertion("shall dispatch the event to the spring-loaded widget after a");
	report_assertion("dispatch to the widget to which the event belonged.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.364652 */

/* Including from file Mdefcode.tmc.364652 */
static void t008(){

pid_t	pid;

 	report_purpose(8);

	report_assertion("Assertion XtDispatchEvent-8.(D)");
	report_assertion("If the implementation is X11R4: When event is a remap event");
	report_assertion("and a modal cascade exists that has a widget with");
	report_assertion("spring_loaded field set to True a call to Boolean");
	report_assertion("XtDispatchEvent(event) shall dispatch the event to the");
	report_assertion("spring-loaded widget after a dispatch to the widget to which");
	report_assertion("the event belonged.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.364652 */

/* Including from file Mdefcode.tmc.364652 */
static void t009(){

pid_t	pid;

 	report_purpose(9);

	report_assertion("Assertion XtDispatchEvent-9.(D)");
	report_assertion("If the implementation is X11R5 or later: When event is a");
	report_assertion("remap event, a modal cascade exists that has a widget with");
	report_assertion("spring_loaded field set to True, and an event input filter");
	report_assertion("has been registered for the spring-loaded widget on the");
	report_assertion("specified event a call to Boolean XtDispatchEvent(event)");
	report_assertion("shall not dispatch the event to the spring-loaded widget.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.364652 */

static void t010(){

#if XT_X_RELEASE > 4
Boolean dispatched;
int invoked = 0;
pid_t pid2;
#endif
pid_t	pid;

 	report_purpose(10);

	report_assertion("Assertion XtDispatchEvent-10.(C)");
	report_assertion("If the implementation is X11R5 or later: A successful call");
	report_assertion("to Boolean XtDispatchEvent(event) when an input method has");
	report_assertion("not been registered on the event event for the widget in");
	report_assertion("which the event occurs and the event is not being dispatched");
	report_assertion("to any widget shall return False.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

#if XT_X_RELEASE > 4
	FORK(pid2);
	avs_xt_hier("Tdispatet2", "XtDispatchEvent");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Send KeyRelease over wire to rowcolw");
	send_event(rowcolw, KeyRelease, KeyReleaseMask, TRUE);
	analyse_events2(click_quit);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);
#else
	tet_infoline("INFO: Implementation is not X11R5 or greater");
	tet_result(TET_UNSUPPORTED);
#endif

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.364652 */
/* End of included file Mdefcode.tmc.364652 */

static void t011(){

#if XT_X_RELEASE == 4
Boolean dispatched;
int invoked = 0;
pid_t pid2;
#endif
pid_t	pid;

 	report_purpose(11);

	report_assertion("Assertion XtDispatchEvent-11.(C)");
	report_assertion("If the implementation is X11R4: When no handler for the");
	report_assertion("specified event is registered a call to Boolean");
	report_assertion("XtDispatchEvent(event) shall return False.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

#if XT_X_RELEASE == 4
	FORK(pid2);
	avs_xt_hier("Tdispatet2", "XtDispatchEvent");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Send KeyRelease over wire to rowcolw");
	send_event(rowcolw, KeyRelease, KeyReleaseMask, TRUE);
	analyse_events2(click_quit);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);
#else
	tet_infoline("INFO: Implementation is not X11R4");
	tet_result(TET_UNSUPPORTED);
#endif

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.364652 */
/* End of included file Mdefcode.tmc.364652 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
