// $ANTLR 2.7.4: "cpp.g" -> "CppLexer.java"$

// This file is part of the program FRYSK.
//
// Copyright 2005, Red Hat Inc.
//
// FRYSK is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; version 2 of the License.
//
// FRYSK is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with FRYSK; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
// 
// In addition, as a special exception, Red Hat, Inc. gives You the
// additional right to link the code of FRYSK with code not covered
// under the GNU General Public License ("Non-GPL Code") and to
// distribute linked combinations including the two, subject to the
// limitations in this paragraph. Non-GPL Code permitted under this
// exception must only link to the code of FRYSK through those well
// defined interfaces identified in the file named EXCEPTION found in
// the source code files (the "Approved Interfaces"). The files of
// Non-GPL Code may instantiate templates or use macros or inline
// functions from the Approved Interfaces without causing the
// resulting work to be covered by the GNU General Public
// License. Only Red Hat, Inc. may make changes or additions to the
// list of Approved Interfaces. You must obey the GNU General Public
// License in all respects for all of the FRYSK code and other code
// used in conjunction with FRYSK except the Non-GPL Code covered by
// this exception. If you modify this file, you may extend this
// exception to your version of the file, but you are not obligated to
// do so. If you do not wish to provide this exception without
// modification, you must delete this exception statement from your
// version and license this file solely under the GPL without
// exception.
    package frysk.expr;

    /* import frysk.lang.*; */
    /* import java.util.*; */
  
import java.io.InputStream;
import antlr.TokenStreamException;
import antlr.TokenStreamIOException;
import antlr.TokenStreamRecognitionException;
import antlr.CharStreamException;
import antlr.CharStreamIOException;
/* import antlr.ANTLRException; */
import java.io.Reader;
import java.util.Hashtable;
/* import antlr.CharScanner; */
import antlr.InputBuffer;
import antlr.ByteBuffer;
import antlr.CharBuffer;
import antlr.Token;
/* import antlr.CommonToken; */
import antlr.RecognitionException;
import antlr.NoViableAltForCharException;
/* import antlr.MismatchedCharException; */
import antlr.TokenStream;
import antlr.ANTLRHashString;
import antlr.LexerSharedInputState;
import antlr.collections.impl.BitSet;
/* import antlr.SemanticException; */

public class CppLexer extends antlr.CharScanner implements CppParserTokenTypes, TokenStream
 {
public CppLexer(InputStream in) {
	this(new ByteBuffer(in));
}
public CppLexer(Reader in) {
	this(new CharBuffer(in));
}
public CppLexer(InputBuffer ib) {
	this(new LexerSharedInputState(ib));
}
public CppLexer(LexerSharedInputState state) {
	super(state);
	caseSensitiveLiterals = true;
	setCaseSensitive(true);
	literals = new Hashtable();
	literals.put(new ANTLRHashString("this", this), new Integer(54));
	literals.put(new ANTLRHashString("false", this), new Integer(63));
	literals.put(new ANTLRHashString("true", this), new Integer(62));
	literals.put(new ANTLRHashString("operator", this), new Integer(65));
}

public Token nextToken() throws TokenStreamException {
	/* Token theRetToken=null; */
tryAgain:
	for (;;) {
		/* Token _token = null; */
		int _ttype = Token.INVALID_TYPE;
		resetText();
		try {   // for char stream error handling
			try {   // for lexical error handling
				switch ( LA(1)) {
				case ',':
				{
					mCOMMA(true);
					/* theRetToken=_returnToken; */
					break;
				}
				case '?':
				{
					mQUESTIONMARK(true);
					/* theRetToken=_returnToken; */
					break;
				}
				case ';':
				{
					mSEMICOLON(true);
					/* theRetToken=_returnToken; */
					break;
				}
				case '\u0003':
				{
					mETX(true);
					/* theRetToken=_returnToken; */
					break;
				}
				case '(':
				{
					mLPAREN(true);
					/* theRetToken=_returnToken; */
					break;
				}
				case ')':
				{
					mRPAREN(true);
					/* theRetToken=_returnToken; */
					break;
				}
				case '[':
				{
					mLSQUARE(true);
					/* theRetToken=_returnToken; */
					break;
				}
				case ']':
				{
					mRSQUARE(true);
					/* theRetToken=_returnToken; */
					break;
				}
				case '{':
				{
					mLCURLY(true);
					/* theRetToken=_returnToken; */
					break;
				}
				case '}':
				{
					mRCURLY(true);
					/* theRetToken=_returnToken; */
					break;
				}
				case '~':
				{
					mTILDE(true);
					/* theRetToken=_returnToken; */
					break;
				}
				case '\t':  case 'A':  case 'B':  case 'C':
				case 'D':  case 'E':  case 'F':  case 'G':
				case 'H':  case 'I':  case 'J':  case 'K':
				case 'L':  case 'M':  case 'N':  case 'O':
				case 'P':  case 'Q':  case 'R':  case 'S':
				case 'T':  case 'U':  case 'V':  case 'W':
				case 'X':  case 'Y':  case 'Z':  case '_':
				case 'a':  case 'b':  case 'c':  case 'd':
				case 'e':  case 'f':  case 'g':  case 'h':
				case 'i':  case 'j':  case 'k':  case 'l':
				case 'm':  case 'n':  case 'o':  case 'p':
				case 'q':  case 'r':  case 's':  case 't':
				case 'u':  case 'v':  case 'w':  case 'x':
				case 'y':  case 'z':
				{
					mTAB_IDENT(true);
					/* theRetToken=_returnToken; */
					break;
				}
				case '\n':  case '\u000c':  case '\r':  case ' ':
				case '\\':
				{
					mWS(true);
					/* theRetToken=_returnToken; */
					break;
				}
				case '\'':
				{
					mCharLiteral(true);
					/* theRetToken=_returnToken; */
					break;
				}
				case '"':
				{
					mStringLiteral(true);
					/* theRetToken=_returnToken; */
					break;
				}
				default:
					if ((LA(1)=='>') && (LA(2)=='>') && (LA(3)=='=')) {
						mSHIFTRIGHTEQUAL(true);
						/* theRetToken=_returnToken; */
					}
					else if ((LA(1)=='<') && (LA(2)=='<') && (LA(3)=='=')) {
						mSHIFTLEFTEQUAL(true);
						/* theRetToken=_returnToken; */
					}
					else if ((LA(1)=='-') && (LA(2)=='>') && (LA(3)=='*')) {
						mPOINTERTOMBR(true);
						/* theRetToken=_returnToken; */
					}
					else if ((LA(1)=='-') && (LA(2)=='>') && (true)) {
						mPOINTERTO(true);
						/* theRetToken=_returnToken; */
					}
					else if ((LA(1)=='=') && (LA(2)=='=')) {
						mEQUAL(true);
						/* theRetToken=_returnToken; */
					}
					else if ((LA(1)=='!') && (LA(2)=='=')) {
						mNOTEQUAL(true);
						/* theRetToken=_returnToken; */
					}
					else if ((LA(1)=='<') && (LA(2)=='=')) {
						mLESSTHANOREQUALTO(true);
						/* theRetToken=_returnToken; */
					}
					else if ((LA(1)=='>') && (LA(2)=='=')) {
						mGREATERTHANOREQUALTO(true);
						/* theRetToken=_returnToken; */
					}
					else if ((LA(1)=='/') && (LA(2)=='=')) {
						mDIVIDEEQUAL(true);
						/* theRetToken=_returnToken; */
					}
					else if ((LA(1)=='+') && (LA(2)=='=')) {
						mPLUSEQUAL(true);
						/* theRetToken=_returnToken; */
					}
					else if ((LA(1)=='+') && (LA(2)=='+')) {
						mPLUSPLUS(true);
						/* theRetToken=_returnToken; */
					}
					else if ((LA(1)=='-') && (LA(2)=='=')) {
						mMINUSEQUAL(true);
						/* theRetToken=_returnToken; */
					}
					else if ((LA(1)=='-') && (LA(2)=='-')) {
						mMINUSMINUS(true);
						/* theRetToken=_returnToken; */
					}
					else if ((LA(1)=='*') && (LA(2)=='=')) {
						mTIMESEQUAL(true);
						/* theRetToken=_returnToken; */
					}
					else if ((LA(1)=='%') && (LA(2)=='=')) {
						mMODEQUAL(true);
						/* theRetToken=_returnToken; */
					}
					else if ((LA(1)=='>') && (LA(2)=='>') && (true)) {
						mSHIFTRIGHT(true);
						/* theRetToken=_returnToken; */
					}
					else if ((LA(1)=='<') && (LA(2)=='<') && (true)) {
						mSHIFTLEFT(true);
						/* theRetToken=_returnToken; */
					}
					else if ((LA(1)=='&') && (LA(2)=='&')) {
						mAND(true);
						/* theRetToken=_returnToken; */
					}
					else if ((LA(1)=='|') && (LA(2)=='|')) {
						mOR(true);
						/* theRetToken=_returnToken; */
					}
					else if ((LA(1)=='&') && (LA(2)=='=')) {
						mBITWISEANDEQUAL(true);
						/* theRetToken=_returnToken; */
					}
					else if ((LA(1)=='|') && (LA(2)=='=')) {
						mBITWISEOREQUAL(true);
						/* theRetToken=_returnToken; */
					}
					else if ((LA(1)=='^') && (LA(2)=='=')) {
						mBITWISEXOREQUAL(true);
						/* theRetToken=_returnToken; */
					}
					else if ((LA(1)=='.') && (LA(2)=='*')) {
						mDOTMBR(true);
						/* theRetToken=_returnToken; */
					}
					else if ((LA(1)==':') && (LA(2)==':')) {
						mSCOPE(true);
						/* theRetToken=_returnToken; */
					}
					else if ((LA(1)=='=') && (true)) {
						mASSIGNEQUAL(true);
						/* theRetToken=_returnToken; */
					}
					else if ((LA(1)==':') && (true)) {
						mCOLON(true);
						/* theRetToken=_returnToken; */
					}
					else if ((LA(1)=='<') && (true)) {
						mLESSTHAN(true);
						/* theRetToken=_returnToken; */
					}
					else if ((LA(1)=='>') && (true)) {
						mGREATERTHAN(true);
						/* theRetToken=_returnToken; */
					}
					else if ((LA(1)=='/') && (true)) {
						mDIVIDE(true);
						/* theRetToken=_returnToken; */
					}
					else if ((LA(1)=='+') && (true)) {
						mPLUS(true);
						/* theRetToken=_returnToken; */
					}
					else if ((LA(1)=='-') && (true)) {
						mMINUS(true);
						/* theRetToken=_returnToken; */
					}
					else if ((LA(1)=='*') && (true)) {
						mSTAR(true);
						/* theRetToken=_returnToken; */
					}
					else if ((LA(1)=='%') && (true)) {
						mMOD(true);
						/* theRetToken=_returnToken; */
					}
					else if ((LA(1)=='!') && (true)) {
						mNOT(true);
						/* theRetToken=_returnToken; */
					}
					else if ((LA(1)=='&') && (true)) {
						mAMPERSAND(true);
						/* theRetToken=_returnToken; */
					}
					else if ((LA(1)=='|') && (true)) {
						mBITWISEOR(true);
						/* theRetToken=_returnToken; */
					}
					else if ((LA(1)=='^') && (true)) {
						mBITWISEXOR(true);
						/* theRetToken=_returnToken; */
					}
					else if ((_tokenSet_0.member(LA(1))) && (true)) {
						mNUM(true);
						/* theRetToken=_returnToken; */
					}
				else {
					if (LA(1)==EOF_CHAR) {uponEOF(); _returnToken = makeToken(Token.EOF_TYPE);}
				else {throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());}
				}
				}
				if ( _returnToken==null ) continue tryAgain; // found SKIP token
				_ttype = _returnToken.getType();
				_ttype = testLiteralsTable(_ttype);
				_returnToken.setType(_ttype);
				return _returnToken;
			}
			catch (RecognitionException e) {
				throw new TokenStreamRecognitionException(e);
			}
		}
		catch (CharStreamException cse) {
			if ( cse instanceof CharStreamIOException ) {
				throw new TokenStreamIOException(((CharStreamIOException)cse).io);
			}
			else {
				throw new TokenStreamException(cse.getMessage());
			}
		}
	}
}

	public final void mASSIGNEQUAL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = ASSIGNEQUAL;
		/* int _saveIndex; */
		
		match('=');
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mCOLON(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = COLON;
		/* int _saveIndex; */
		
		match(':');
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mCOMMA(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = COMMA;
		/* int _saveIndex; */
		
		match(',');
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mQUESTIONMARK(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = QUESTIONMARK;
		/* int _saveIndex; */
		
		match('?');
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mSEMICOLON(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = SEMICOLON;
		/* int _saveIndex; */
		
		match(';');
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mPOINTERTO(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = POINTERTO;
		/* int _saveIndex; */
		
		match("->");
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mETX(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = ETX;
		/* int _saveIndex; */
		
		match('\3');
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mLPAREN(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = LPAREN;
		/* int _saveIndex; */
		
		match('(');
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mRPAREN(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = RPAREN;
		/* int _saveIndex; */
		
		match(')');
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mLSQUARE(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = LSQUARE;
		/* int _saveIndex; */
		
		match('[');
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mRSQUARE(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = RSQUARE;
		/* int _saveIndex; */
		
		match(']');
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mLCURLY(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = LCURLY;
		/* int _saveIndex; */
		
		match('{');
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mRCURLY(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = RCURLY;
		/* int _saveIndex; */
		
		match('}');
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mEQUAL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = EQUAL;
		/* int _saveIndex; */
		
		match("==");
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mNOTEQUAL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = NOTEQUAL;
		/* int _saveIndex; */
		
		match("!=");
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mLESSTHANOREQUALTO(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = LESSTHANOREQUALTO;
		/* int _saveIndex; */
		
		match("<=");
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mLESSTHAN(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = LESSTHAN;
		/* int _saveIndex; */
		
		match("<");
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mGREATERTHANOREQUALTO(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = GREATERTHANOREQUALTO;
		/* int _saveIndex; */
		
		match(">=");
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mGREATERTHAN(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = GREATERTHAN;
		/* int _saveIndex; */
		
		match(">");
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mDIVIDE(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = DIVIDE;
		/* int _saveIndex; */
		
		match('/');
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mDIVIDEEQUAL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = DIVIDEEQUAL;
		/* int _saveIndex; */
		
		match("/=");
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mPLUS(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = PLUS;
		/* int _saveIndex; */
		
		match('+');
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mPLUSEQUAL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = PLUSEQUAL;
		/* int _saveIndex; */
		
		match("+=");
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mPLUSPLUS(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = PLUSPLUS;
		/* int _saveIndex; */
		
		match("++");
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mMINUS(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = MINUS;
		/* int _saveIndex; */
		
		match('-');
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mMINUSEQUAL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = MINUSEQUAL;
		/* int _saveIndex; */
		
		match("-=");
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mMINUSMINUS(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = MINUSMINUS;
		/* int _saveIndex; */
		
		match("--");
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mSTAR(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = STAR;
		/* int _saveIndex; */
		
		match('*');
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mTIMESEQUAL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = TIMESEQUAL;
		/* int _saveIndex; */
		
		match("*=");
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mMOD(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = MOD;
		/* int _saveIndex; */
		
		match('%');
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mMODEQUAL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = MODEQUAL;
		/* int _saveIndex; */
		
		match("%=");
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mSHIFTRIGHT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = SHIFTRIGHT;
		/* int _saveIndex; */
		
		match(">>");
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mSHIFTRIGHTEQUAL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = SHIFTRIGHTEQUAL;
		/* int _saveIndex; */
		
		match(">>=");
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mSHIFTLEFT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = SHIFTLEFT;
		/* int _saveIndex; */
		
		match("<<");
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mSHIFTLEFTEQUAL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = SHIFTLEFTEQUAL;
		/* int _saveIndex; */
		
		match("<<=");
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mAND(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = AND;
		/* int _saveIndex; */
		
		match("&&");
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mNOT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = NOT;
		/* int _saveIndex; */
		
		match('!');
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mOR(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = OR;
		/* int _saveIndex; */
		
		match("||");
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mAMPERSAND(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = AMPERSAND;
		/* int _saveIndex; */
		
		match('&');
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mBITWISEANDEQUAL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = BITWISEANDEQUAL;
		/* int _saveIndex; */
		
		match("&=");
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mTILDE(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = TILDE;
		/* int _saveIndex; */
		
		match('~');
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mBITWISEOR(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = BITWISEOR;
		/* int _saveIndex; */
		
		match('|');
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mBITWISEOREQUAL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = BITWISEOREQUAL;
		/* int _saveIndex; */
		
		match("|=");
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mBITWISEXOR(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = BITWISEXOR;
		/* int _saveIndex; */
		
		match('^');
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mBITWISEXOREQUAL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = BITWISEXOREQUAL;
		/* int _saveIndex; */
		
		match("^=");
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	protected final void mDOT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = DOT;
		/* int _saveIndex; */
		
		match('.');
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	protected final void mELLIPSIS(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = ELLIPSIS;
		/* int _saveIndex; */
		
		match("...");
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mPOINTERTOMBR(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = POINTERTOMBR;
		/* int _saveIndex; */
		
		match("->*");
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mDOTMBR(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = DOTMBR;
		/* int _saveIndex; */
		
		match(".*");
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mSCOPE(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = SCOPE;
		/* int _saveIndex; */
		
		match("::");
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	protected final void mIDENT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = IDENT;
		/* int _saveIndex; */
		
		{
		switch ( LA(1)) {
		case 'a':  case 'b':  case 'c':  case 'd':
		case 'e':  case 'f':  case 'g':  case 'h':
		case 'i':  case 'j':  case 'k':  case 'l':
		case 'm':  case 'n':  case 'o':  case 'p':
		case 'q':  case 'r':  case 's':  case 't':
		case 'u':  case 'v':  case 'w':  case 'x':
		case 'y':  case 'z':
		{
			matchRange('a','z');
			break;
		}
		case 'A':  case 'B':  case 'C':  case 'D':
		case 'E':  case 'F':  case 'G':  case 'H':
		case 'I':  case 'J':  case 'K':  case 'L':
		case 'M':  case 'N':  case 'O':  case 'P':
		case 'Q':  case 'R':  case 'S':  case 'T':
		case 'U':  case 'V':  case 'W':  case 'X':
		case 'Y':  case 'Z':
		{
			matchRange('A','Z');
			break;
		}
		case '_':
		{
			match('_');
			break;
		}
		default:
		{
			throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
		}
		}
		}
		{
		_loop122:
		do {
			switch ( LA(1)) {
			case 'a':  case 'b':  case 'c':  case 'd':
			case 'e':  case 'f':  case 'g':  case 'h':
			case 'i':  case 'j':  case 'k':  case 'l':
			case 'm':  case 'n':  case 'o':  case 'p':
			case 'q':  case 'r':  case 's':  case 't':
			case 'u':  case 'v':  case 'w':  case 'x':
			case 'y':  case 'z':
			{
				matchRange('a','z');
				break;
			}
			case 'A':  case 'B':  case 'C':  case 'D':
			case 'E':  case 'F':  case 'G':  case 'H':
			case 'I':  case 'J':  case 'K':  case 'L':
			case 'M':  case 'N':  case 'O':  case 'P':
			case 'Q':  case 'R':  case 'S':  case 'T':
			case 'U':  case 'V':  case 'W':  case 'X':
			case 'Y':  case 'Z':
			{
				matchRange('A','Z');
				break;
			}
			case '0':  case '1':  case '2':  case '3':
			case '4':  case '5':  case '6':  case '7':
			case '8':  case '9':
			{
				matchRange('0','9');
				break;
			}
			case '_':
			{
				match('_');
				break;
			}
			default:
			{
				break _loop122;
			}
			}
		} while (true);
		}
		_ttype = testLiteralsTable(new String(text.getBuffer(),_begin,text.length()-_begin),_ttype);
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
/**
   *  A <TAB> token is returned not only on regular tabs
   *  but also when a TAB is hit after an incomplete variable
   */
	protected final void mTAB(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = TAB;
		/* int _saveIndex; */
		
		{
		switch ( LA(1)) {
		case 'A':  case 'B':  case 'C':  case 'D':
		case 'E':  case 'F':  case 'G':  case 'H':
		case 'I':  case 'J':  case 'K':  case 'L':
		case 'M':  case 'N':  case 'O':  case 'P':
		case 'Q':  case 'R':  case 'S':  case 'T':
		case 'U':  case 'V':  case 'W':  case 'X':
		case 'Y':  case 'Z':  case '_':  case 'a':
		case 'b':  case 'c':  case 'd':  case 'e':
		case 'f':  case 'g':  case 'h':  case 'i':
		case 'j':  case 'k':  case 'l':  case 'm':
		case 'n':  case 'o':  case 'p':  case 'q':
		case 'r':  case 's':  case 't':  case 'u':
		case 'v':  case 'w':  case 'x':  case 'y':
		case 'z':
		{
			mIDENT(false);
			break;
		}
		case '\t':
		{
			break;
		}
		default:
		{
			throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
		}
		}
		}
		match('\t');
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mTAB_IDENT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = TAB_IDENT;
		/* int _saveIndex; */
		
		boolean synPredMatched128 = false;
		if (((_tokenSet_1.member(LA(1))) && (true) && (true))) {
			int _m128 = mark();
			synPredMatched128 = true;
			inputState.guessing++;
			try {
				{
				{
				mIDENT(false);
				}
				match('\t');
				}
			}
			catch (RecognitionException pe) {
				synPredMatched128 = false;
			}
			rewind(_m128);
			inputState.guessing--;
		}
		if ( synPredMatched128 ) {
			mTAB(false);
			if ( inputState.guessing==0 ) {
				_ttype = TAB;
			}
		}
		else {
			boolean synPredMatched130 = false;
			if (((_tokenSet_1.member(LA(1))) && (true) && (true))) {
				int _m130 = mark();
				synPredMatched130 = true;
				inputState.guessing++;
				try {
					{
					match('\t');
					}
				}
				catch (RecognitionException pe) {
					synPredMatched130 = false;
				}
				rewind(_m130);
				inputState.guessing--;
			}
			if ( synPredMatched130 ) {
				mTAB(false);
				if ( inputState.guessing==0 ) {
					_ttype = TAB;
				}
			}
			else if ((_tokenSet_2.member(LA(1))) && (true) && (true)) {
				mIDENT(false);
				if ( inputState.guessing==0 ) {
					_ttype = IDENT;
				}
			}
			else {
				throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
			}
			}
			if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
				_token = makeToken(_ttype);
				_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
			}
			_returnToken = _token;
		}
		
	protected final void mNL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = NL;
		/* int _saveIndex; */
		
		switch ( LA(1)) {
		case '\r':
		{
			match('\r');
			{
			if ((LA(1)=='\n')) {
				match('\n');
			}
			else {
			}
			
			}
			break;
		}
		case '\n':
		{
			match('\n');
			if ( inputState.guessing==0 ) {
				newline();
			}
			break;
		}
		default:
		{
			throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
		}
		}
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mWS(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = WS;
		/* int _saveIndex; */
		
		{
		switch ( LA(1)) {
		case ' ':
		{
			match(' ');
			break;
		}
		case '\u000c':
		{
			match('\f');
			break;
		}
		case '\n':  case '\r':
		{
			mNL(false);
			break;
		}
		case '\\':
		{
			match('\\');
			{
			switch ( LA(1)) {
			case '\r':
			{
				match('\r');
				{
				if ((LA(1)=='\n')) {
					match('\n');
				}
				else {
				}
				
				}
				break;
			}
			case '\n':
			{
				match('\n');
				break;
			}
			default:
			{
				throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
			}
			}
			}
			break;
		}
		default:
		{
			throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
		}
		}
		}
		if ( inputState.guessing==0 ) {
			_ttype = Token.SKIP;
		}
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mCharLiteral(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = CharLiteral;
		/* int _saveIndex; */
		
		match('\'');
		{
		if ((LA(1)=='\\') && (_tokenSet_3.member(LA(2))) && (_tokenSet_4.member(LA(3)))) {
			mEscape(false);
		}
		else if ((_tokenSet_5.member(LA(1))) && (LA(2)=='\'') && (true)) {
			{
			match(_tokenSet_5);
			}
		}
		else {
			throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
		}
		
		}
		match('\'');
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	protected final void mEscape(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = Escape;
		/* int _saveIndex; */
		
		match('\\');
		{
		switch ( LA(1)) {
		case 'a':
		{
			match('a');
			break;
		}
		case 'b':
		{
			match('b');
			break;
		}
		case 'f':
		{
			match('f');
			break;
		}
		case 'n':
		{
			match('n');
			break;
		}
		case 'r':
		{
			match('r');
			break;
		}
		case 't':
		{
			match('t');
			break;
		}
		case 'v':
		{
			match('v');
			break;
		}
		case '"':
		{
			match('"');
			break;
		}
		case '\'':
		{
			match('\'');
			break;
		}
		case '\\':
		{
			match('\\');
			break;
		}
		case '?':
		{
			match('?');
			break;
		}
		case '0':  case '1':  case '2':  case '3':
		{
			{
			matchRange('0','3');
			}
			{
			if (((LA(1) >= '0' && LA(1) <= '9')) && (_tokenSet_6.member(LA(2))) && (true)) {
				mDigit(false);
				{
				if (((LA(1) >= '0' && LA(1) <= '9')) && (_tokenSet_6.member(LA(2))) && (true)) {
					mDigit(false);
				}
				else if ((_tokenSet_6.member(LA(1))) && (true) && (true)) {
				}
				else {
					throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
				}
				
				}
			}
			else if ((_tokenSet_6.member(LA(1))) && (true) && (true)) {
			}
			else {
				throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
			}
			
			}
			break;
		}
		case '4':  case '5':  case '6':  case '7':
		{
			{
			matchRange('4','7');
			}
			{
			if (((LA(1) >= '0' && LA(1) <= '9')) && (_tokenSet_6.member(LA(2))) && (true)) {
				mDigit(false);
			}
			else if ((_tokenSet_6.member(LA(1))) && (true) && (true)) {
			}
			else {
				throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
			}
			
			}
			break;
		}
		case 'x':
		{
			match('x');
			{
			int _cnt153=0;
			_loop153:
			do {
				if (((LA(1) >= '0' && LA(1) <= '9')) && (_tokenSet_6.member(LA(2))) && (true)) {
					mDigit(false);
				}
				else if (((LA(1) >= 'a' && LA(1) <= 'f')) && (_tokenSet_6.member(LA(2))) && (true)) {
					matchRange('a','f');
				}
				else if (((LA(1) >= 'A' && LA(1) <= 'F')) && (_tokenSet_6.member(LA(2))) && (true)) {
					matchRange('A','F');
				}
				else {
					if ( _cnt153>=1 ) { break _loop153; } else {throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());}
				}
				
				_cnt153++;
			} while (true);
			}
			break;
		}
		default:
		{
			throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
		}
		}
		}
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mStringLiteral(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = StringLiteral;
		/* int _saveIndex; */
		
		match('"');
		{
		_loop144:
		do {
			if ((LA(1)=='\\') && (_tokenSet_3.member(LA(2)))) {
				mEscape(false);
			}
			else if ((LA(1)=='\\') && (LA(2)=='\n'||LA(2)=='\r')) {
				{
				if ((LA(1)=='\\') && (LA(2)=='\r') && (LA(3)=='\n')) {
					match("\\\r\n");
				}
				else if ((LA(1)=='\\') && (LA(2)=='\r') && (_tokenSet_6.member(LA(3)))) {
					match("\\\r");
				}
				else if ((LA(1)=='\\') && (LA(2)=='\n')) {
					match("\\\n");
				}
				else {
					throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
				}
				
				}
			}
			else if ((_tokenSet_7.member(LA(1)))) {
				{
				match(_tokenSet_7);
				}
			}
			else {
				break _loop144;
			}
			
		} while (true);
		}
		match('"');
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	protected final void mDigit(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = Digit;
		/* int _saveIndex; */
		
		matchRange('0','9');
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	protected final void mDecimal(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = Decimal;
		/* int _saveIndex; */
		
		{
		int _cnt157=0;
		_loop157:
		do {
			if (((LA(1) >= '0' && LA(1) <= '9'))) {
				matchRange('0','9');
			}
			else {
				if ( _cnt157>=1 ) { break _loop157; } else {throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());}
			}
			
			_cnt157++;
		} while (true);
		}
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	protected final void mLongSuffix(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = LongSuffix;
		/* int _saveIndex; */
		
		switch ( LA(1)) {
		case 'l':
		{
			match('l');
			break;
		}
		case 'L':
		{
			match('L');
			break;
		}
		default:
		{
			throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
		}
		}
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	protected final void mUnsignedSuffix(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = UnsignedSuffix;
		/* int _saveIndex; */
		
		switch ( LA(1)) {
		case 'u':
		{
			match('u');
			break;
		}
		case 'U':
		{
			match('U');
			break;
		}
		default:
		{
			throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
		}
		}
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	protected final void mFloatSuffix(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = FloatSuffix;
		/* int _saveIndex; */
		
		switch ( LA(1)) {
		case 'f':
		{
			match('f');
			break;
		}
		case 'F':
		{
			match('F');
			break;
		}
		default:
		{
			throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
		}
		}
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	protected final void mExponent(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = Exponent;
		/* int _saveIndex; */
		
		{
		switch ( LA(1)) {
		case 'e':
		{
			match('e');
			break;
		}
		case 'E':
		{
			match('E');
			break;
		}
		default:
		{
			throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
		}
		}
		}
		{
		switch ( LA(1)) {
		case '+':
		{
			match('+');
			break;
		}
		case '-':
		{
			match('-');
			break;
		}
		case '0':  case '1':  case '2':  case '3':
		case '4':  case '5':  case '6':  case '7':
		case '8':  case '9':
		{
			break;
		}
		default:
		{
			throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
		}
		}
		}
		{
		int _cnt165=0;
		_loop165:
		do {
			if (((LA(1) >= '0' && LA(1) <= '9'))) {
				mDigit(false);
			}
			else {
				if ( _cnt165>=1 ) { break _loop165; } else {throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());}
			}
			
			_cnt165++;
		} while (true);
		}
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	protected final void mVocabulary(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = Vocabulary;
		/* int _saveIndex; */
		
		matchRange('\3','\377');
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mNUM(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = NUM;
		/* int _saveIndex; */
		
		boolean synPredMatched172 = false;
		if ((((LA(1) >= '0' && LA(1) <= '9')) && (_tokenSet_8.member(LA(2))) && (true))) {
			int _m172 = mark();
			synPredMatched172 = true;
			inputState.guessing++;
			try {
				{
				{
				int _cnt170=0;
				_loop170:
				do {
					if (((LA(1) >= '0' && LA(1) <= '9'))) {
						mDigit(false);
					}
					else {
						if ( _cnt170>=1 ) { break _loop170; } else {throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());}
					}
					
					_cnt170++;
				} while (true);
				}
				{
				switch ( LA(1)) {
				case '.':
				{
					match('.');
					break;
				}
				case 'e':
				{
					match('e');
					break;
				}
				case 'E':
				{
					match('E');
					break;
				}
				default:
				{
					throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
				}
				}
				}
				}
			}
			catch (RecognitionException pe) {
				synPredMatched172 = false;
			}
			rewind(_m172);
			inputState.guessing--;
		}
		if ( synPredMatched172 ) {
			{
			int _cnt174=0;
			_loop174:
			do {
				if (((LA(1) >= '0' && LA(1) <= '9'))) {
					mDigit(false);
				}
				else {
					if ( _cnt174>=1 ) { break _loop174; } else {throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());}
				}
				
				_cnt174++;
			} while (true);
			}
			{
			switch ( LA(1)) {
			case '.':
			{
				match('.');
				{
				_loop177:
				do {
					if (((LA(1) >= '0' && LA(1) <= '9'))) {
						mDigit(false);
					}
					else {
						break _loop177;
					}
					
				} while (true);
				}
				{
				if ((LA(1)=='E'||LA(1)=='e')) {
					mExponent(false);
				}
				else {
				}
				
				}
				if ( inputState.guessing==0 ) {
					_ttype = FLOATONE;
				}
				break;
			}
			case 'E':  case 'e':
			{
				mExponent(false);
				if ( inputState.guessing==0 ) {
					_ttype = FLOATTWO;
				}
				break;
			}
			default:
			{
				throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
			}
			}
			}
			{
			switch ( LA(1)) {
			case 'F':  case 'f':
			{
				mFloatSuffix(false);
				break;
			}
			case 'L':  case 'l':
			{
				mLongSuffix(false);
				break;
			}
			default:
				{
				}
			}
			}
		}
		else {
			boolean synPredMatched181 = false;
			if (((LA(1)=='.') && (LA(2)=='.'))) {
				int _m181 = mark();
				synPredMatched181 = true;
				inputState.guessing++;
				try {
					{
					match("...");
					}
				}
				catch (RecognitionException pe) {
					synPredMatched181 = false;
				}
				rewind(_m181);
				inputState.guessing--;
			}
			if ( synPredMatched181 ) {
				match("...");
				if ( inputState.guessing==0 ) {
					_ttype = ELLIPSIS;
				}
			}
			else {
				boolean synPredMatched196 = false;
				if (((LA(1)=='0') && (LA(2)=='X'||LA(2)=='x'))) {
					int _m196 = mark();
					synPredMatched196 = true;
					inputState.guessing++;
					try {
						{
						match('0');
						{
						switch ( LA(1)) {
						case 'x':
						{
							match('x');
							break;
						}
						case 'X':
						{
							match('X');
							break;
						}
						default:
						{
							throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
						}
						}
						}
						}
					}
					catch (RecognitionException pe) {
						synPredMatched196 = false;
					}
					rewind(_m196);
					inputState.guessing--;
				}
				if ( synPredMatched196 ) {
					match('0');
					{
					switch ( LA(1)) {
					case 'x':
					{
						match('x');
						break;
					}
					case 'X':
					{
						match('X');
						break;
					}
					default:
					{
						throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
					}
					}
					}
					{
					int _cnt199=0;
					_loop199:
					do {
						switch ( LA(1)) {
						case 'a':  case 'b':  case 'c':  case 'd':
						case 'e':  case 'f':
						{
							matchRange('a','f');
							break;
						}
						case 'A':  case 'B':  case 'C':  case 'D':
						case 'E':  case 'F':
						{
							matchRange('A','F');
							break;
						}
						case '0':  case '1':  case '2':  case '3':
						case '4':  case '5':  case '6':  case '7':
						case '8':  case '9':
						{
							mDigit(false);
							break;
						}
						default:
						{
							if ( _cnt199>=1 ) { break _loop199; } else {throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());}
						}
						}
						_cnt199++;
					} while (true);
					}
					{
					_loop201:
					do {
						switch ( LA(1)) {
						case 'L':  case 'l':
						{
							mLongSuffix(false);
							break;
						}
						case 'U':  case 'u':
						{
							mUnsignedSuffix(false);
							break;
						}
						default:
						{
							break _loop201;
						}
						}
					} while (true);
					}
					if ( inputState.guessing==0 ) {
						_ttype = HEXADECIMALINT;
					}
				}
				else if ((LA(1)=='.') && (true)) {
					match('.');
					if ( inputState.guessing==0 ) {
						_ttype = DOT;
					}
					{
					if (((LA(1) >= '0' && LA(1) <= '9'))) {
						{
						int _cnt184=0;
						_loop184:
						do {
							if (((LA(1) >= '0' && LA(1) <= '9'))) {
								mDigit(false);
							}
							else {
								if ( _cnt184>=1 ) { break _loop184; } else {throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());}
							}
							
							_cnt184++;
						} while (true);
						}
						{
						if ((LA(1)=='E'||LA(1)=='e')) {
							mExponent(false);
						}
						else {
						}
						
						}
						if ( inputState.guessing==0 ) {
							_ttype = FLOATONE;
						}
						{
						switch ( LA(1)) {
						case 'F':  case 'f':
						{
							mFloatSuffix(false);
							break;
						}
						case 'L':  case 'l':
						{
							mLongSuffix(false);
							break;
						}
						default:
							{
							}
						}
						}
					}
					else {
					}
					
					}
				}
				else {
					boolean synPredMatched189 = false;
					if (((LA(1)=='0') && (true) && (true))) {
						int _m189 = mark();
						synPredMatched189 = true;
						inputState.guessing++;
						try {
							{
							match('0');
							{
							matchRange('0','7');
							}
							}
						}
						catch (RecognitionException pe) {
							synPredMatched189 = false;
						}
						rewind(_m189);
						inputState.guessing--;
					}
					if ( synPredMatched189 ) {
						match('0');
						{
						_loop191:
						do {
							if (((LA(1) >= '0' && LA(1) <= '7'))) {
								matchRange('0','7');
							}
							else {
								break _loop191;
							}
							
						} while (true);
						}
						{
						_loop193:
						do {
							switch ( LA(1)) {
							case 'L':  case 'l':
							{
								mLongSuffix(false);
								break;
							}
							case 'U':  case 'u':
							{
								mUnsignedSuffix(false);
								break;
							}
							default:
							{
								break _loop193;
							}
							}
						} while (true);
						}
						if ( inputState.guessing==0 ) {
							_ttype = OCTALINT;
						}
					}
					else if (((LA(1) >= '0' && LA(1) <= '9')) && (true) && (true)) {
						{
						switch ( LA(1)) {
						case '0':
						{
							match('0');
							break;
						}
						case '1':  case '2':  case '3':  case '4':
						case '5':  case '6':  case '7':  case '8':
						case '9':
						{
							{
							matchRange('1','9');
							{
							_loop205:
							do {
								if (((LA(1) >= '0' && LA(1) <= '9'))) {
									mDigit(false);
								}
								else {
									break _loop205;
								}
								
							} while (true);
							}
							}
							break;
						}
						default:
						{
							throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
						}
						}
						}
						{
						_loop207:
						do {
							switch ( LA(1)) {
							case 'L':  case 'l':
							{
								mLongSuffix(false);
								break;
							}
							case 'U':  case 'u':
							{
								mUnsignedSuffix(false);
								break;
							}
							default:
							{
								break _loop207;
							}
							}
						} while (true);
						}
						if ( inputState.guessing==0 ) {
							_ttype = DECIMALINT;
						}
					}
					else {
						throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
					}
					}}}
					if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
						_token = makeToken(_ttype);
						_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
					}
					_returnToken = _token;
				}
				
				
				private static final long[] mk_tokenSet_0() {
					long[] data = { 288019269919178752L, 0L, 0L, 0L, 0L};
					return data;
				}
				public static final BitSet _tokenSet_0 = new BitSet(mk_tokenSet_0());
				private static final long[] mk_tokenSet_1() {
					long[] data = { 512L, 576460745995190270L, 0L, 0L, 0L};
					return data;
				}
				public static final BitSet _tokenSet_1 = new BitSet(mk_tokenSet_1());
				private static final long[] mk_tokenSet_2() {
					long[] data = { 0L, 576460745995190270L, 0L, 0L, 0L};
					return data;
				}
				public static final BitSet _tokenSet_2 = new BitSet(mk_tokenSet_2());
				private static final long[] mk_tokenSet_3() {
					long[] data = { -9151595350857875456L, 95772161741946880L, 0L, 0L, 0L};
					return data;
				}
				public static final BitSet _tokenSet_3 = new BitSet(mk_tokenSet_3());
				private static final long[] mk_tokenSet_4() {
					long[] data = { 287949450930814976L, 541165879422L, 0L, 0L, 0L};
					return data;
				}
				public static final BitSet _tokenSet_4 = new BitSet(mk_tokenSet_4());
				private static final long[] mk_tokenSet_5() {
					long[] data = new long[8];
					data[0]=-549755813889L;
					for (int i = 1; i<=3; i++) { data[i]=-1L; }
					return data;
				}
				public static final BitSet _tokenSet_5 = new BitSet(mk_tokenSet_5());
				private static final long[] mk_tokenSet_6() {
					long[] data = new long[8];
					data[0]=-9217L;
					for (int i = 1; i<=3; i++) { data[i]=-1L; }
					return data;
				}
				public static final BitSet _tokenSet_6 = new BitSet(mk_tokenSet_6());
				private static final long[] mk_tokenSet_7() {
					long[] data = new long[8];
					data[0]=-17179878401L;
					data[1]=-268435457L;
					for (int i = 2; i<=3; i++) { data[i]=-1L; }
					return data;
				}
				public static final BitSet _tokenSet_7 = new BitSet(mk_tokenSet_7());
				private static final long[] mk_tokenSet_8() {
					long[] data = { 288019269919178752L, 137438953504L, 0L, 0L, 0L};
					return data;
				}
				public static final BitSet _tokenSet_8 = new BitSet(mk_tokenSet_8());
				
				}
