#!/bin/sh
# ACL:license
#  ----------------------------------------------------------------------
#  This software and ancillary information (herein called "SOFTWARE")
#  called POOMA (Parallel Object-Oriented Methods and Applications) is
#  made available under the terms described here.  The SOFTWARE has been
#  approved for release with associated LA-CC Number LA-CC-98-65.
#  
#  Unless otherwise indicated, this SOFTWARE has been authored by an
#  employee or employees of the University of California, operator of the
#  Los Alamos National Laboratory under Contract No.  W-7405-ENG-36 with
#  the U.S. Department of Energy.  The U.S. Government has rights to use,
#  reproduce, and distribute this SOFTWARE, and to allow others to do so.
#  The public may copy and use this SOFTWARE, FOR NONCOMMERCIAL USE ONLY,
#  without charge, provided that this Notice and any statement of
#  authorship are reproduced on all copies.  Neither the Government nor
#  the University makes any warranty, express or implied, or assumes any
#  liability or responsibility for the use of this SOFTWARE.
#  
#  If SOFTWARE is modified to produce derivative works, such modified
#  SOFTWARE should be clearly marked, so as not to confuse it with the
#  version available from LANL.
#  
#  For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
#  or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
#  ----------------------------------------------------------------------
# ACL:license


cd $1
flist=`ls -1 config/*.suite.mk`

if [ "$flist" = "" ]; then
  echo "Cannot find SUITE file.  SUITE not set."
  exit 1
fi

for f in $flist; do
  echo `basename $f .suite.mk`
  exit
done


# ACL:rcsinfo
#  ----------------------------------------------------------------------
#  $RCSfile: findsuite.sh,v $   $Author: bfh $
#  $Revision: 1.2 $   $Date: 1998/10/26 21:41:18 $
#  ----------------------------------------------------------------------
# ACL:rcsinfo
