// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

#include "Domain/Loc.h"
#include "Domain/Interval.h"
#include "Domain/Range.h"
#include "Domain/SliceInterval.h"
#include "Domain/SliceRange.h"
#include "Domain/Region.h"
#include "Domain/Touches.h"
#include "Domain/Contains.h"
#include "Domain/Split.h"
#include "Domain/Intersect.h"
#include "Engine/BrickEngine.h"
#include "Engine/DynamicEngine.h"
#include "Array/Array.h"
#include "DynamicArray/DynamicArray.h"
#include "Domain/IndirectionList.h"
#include "Pooma/Pooma.h"
#include "Utilities/Tester.h"

#include <iostream>

int main(int argc, char *argv[])
{
  Pooma::initialize(argc,argv);
  Pooma::Tester tester(argc,argv);

  std::cout << "Starting IndirectionList test." << std::endl << std::endl;

  Interval<1> foo(0,6);

  Array<1,int,Brick> klist(foo);


  klist = 1;
  for(int i=1;i<7;i++)
    klist(i) = klist(i-1)+i;
  klist(2)=3;
  klist(5)=12;
  klist(6)=20;
  
  tester.out() << klist << std::endl;

  Interval<1> fff(0,20);

  DynamicArray<double,Dynamic> goo(fff),roo(fff);
  for(int i=0;i<=goo.domain().last();i++)
    goo(i)=roo(i)=i;

  IndirectionList<int> iklist(klist);

  tester.out()  << " iklist.first() = " << iklist.first() << std::endl;
  tester.out()  << " iklist.last() = " << iklist.last() << std::endl;
  tester.out()  << " iklist.size() = " << iklist.size() << std::endl;
  
  tester.out() << "DynamicArray to be altered" << goo << std::endl;

  Range<1> sss(0,3);
	
  goo.destroy(iklist,ShiftUp());

  tester.out() << "after destroy with ShiftUp" << std::endl;
  tester.out() << goo << std::endl;


  roo.destroy(iklist,BackFill());
  tester.out() << "after destroy with BackFill" << std::endl;
  tester.out() << roo << std::endl;

  std::cout << "Finished IndirectionList test." << std::endl << std::endl;
  return 0;
}

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: indirectionlist_test1.cpp,v $   $Author: julianc $
// $Revision: 1.5 $   $Date: 2000/07/24 16:05:25 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
