// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license
//-----------------------------------------------------------------------------
// Grid-based Multi-Patch Array's test 2
//-----------------------------------------------------------------------------

#include "Pooma/Pooma.h"
#include "Pooma/Arrays.h"
#include "Layout/GridLayout.h"
#include "Engine/MultiPatchEngine.h"
//#include "Evaluator/MultiPatchEval.h"
#include "Domain/Grid.h"
#include "Utilities/Tester.h"


int main(int argc, char *argv[])
{
  Pooma::initialize(argc,argv);
  Pooma::Tester tester(argc,argv);

  int i;
  
  // Create the total domain.
  
  Interval<1> domain(12);
  
  // Create the block sizes.
  
  Loc<1> blocks(3), blocks2(4);

  // Create the partitioners.
  
  GridPartition<1> partition(blocks), partition2(blocks2);
  
  Range<1> r(domain[0].first(), domain[0].last()+1,
	     domain[0].size()/blocks[0].first());
  Grid<1> g(r);
  Range<1> r2(domain[0].first(), domain[0].last()+1,
	      domain[0].size()/blocks2[0].first());
  Grid<1> g2(r2);
  GridPartition<1> gp(g),gp2(g2);

  // Create the layouts.
  
  GridLayout<1> layout(domain, partition, ReplicatedTag());
  GridLayout<1> layout2(domain, partition2, ReplicatedTag());
  GridLayout<1> layout3(g, ReplicatedTag());
  GridLayout<1> layout4(g2, ReplicatedTag());
  
  tester.out() << layout << std::endl;

  tester.out() << layout2 << std::endl;

  tester.out() << layout3 << std::endl;

  tester.out() << layout4 << std::endl;

  // Make some GMP arrays and fill them.
  
  Array<1, double, Brick > a(12), ans(12);
  Array<1, double, Brick > ga(12),gans(12);
  Array<1, double, MultiPatch<GridTag,Brick> > bb(layout), cc(layout2);
  Array<1, double, MultiPatch<GridTag,Brick> > gbb(layout3), gcc(layout4);

  for (i = 0; i < 12; i++)
    {
      bb(i) = 1.0 + i;
      cc(i) = -2.3 * i;
      ans(i) = bb(i) + 3.0 * cc(i);

      gbb(i) = 1.0 + i;
      gcc(i) = -2.3 * i;
      gans(i) = gbb(i) + 3.0 * gcc(i);
    }
  
  a = bb + 3.0 * cc;

  ga = gbb + 3.0 * gcc;

  Pooma::blockAndEvaluate();

  for (i = 0; i < 12; i++)
    {
      tester.check(a(i) == ans(i));
    }
      
  int ret = tester.results("gmp_test2");
  Pooma::finalize();
  return ret; 
}

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: gmp_test2.cpp,v $   $Author: luchini $
// $Revision: 1.9 $   $Date: 2000/06/01 18:08:52 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
