// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license
//-----------------------------------------------------------------------------
// Cross context layout test
//-----------------------------------------------------------------------------


#include "Pooma/Pooma.h"
#include "Pooma/Domains.h"
#include "Pooma/GMPArrays.h"
#include "Layout/UniformGridLayout.h"
//#include "Layout/GridLayout.h"
//#include "Layout/SparseTileLayout.h"
#include "Partition/UniformGridPartition.h"
//#include "Partition/GridPartition.h"
//#include "Partition/TilePartition.h"
#include "Utilities/Tester.h"


int main(int argc, char *argv[])
 {
  // Initialize POOMA and output stream, using Tester class
	
  Pooma::initialize(argc, argv);
  Pooma::Tester tester(argc, argv);
  tester.out() << argv[0] << ": UniformGridPartition operations." << std::endl;
  tester.out() << "---------------------------------------------" << std::endl;

  // Create a UniformGridLayout with a non-empty domain and a set of
  // blocks.

  Loc<2> blocks(20,30);
  Interval<2> domain(120, 120);
  tester.out() << "Creating UniformGridLayout with blocks=" << blocks;
  tester.out() << ", domain=" << domain << std::endl;
  UniformGridLayout<2> ugrid1(domain, blocks, ReplicatedTag());
  UniformGridPartition<2> par(Loc<2>(20,30));

  ugrid1.repartition(par);
  ugrid1.repartition(par,DistributedMapper<2>(par));
 
  tester.out() << "Layout = " << ugrid1 << std::endl;
  
  int b = blocks[0].last()*blocks[1].last();
  for ( int j = 0; j < Pooma::contexts(); ++j)
    {
      if(j == Pooma::context()  )
	{
	  tester.out() << " # local domains " << ugrid1.sizeLocal() <<std::endl;
	  tester.check(ugrid1.sizeLocal() == b/Pooma::contexts());
	  tester.out() << " # remote domains " << ugrid1.sizeRemote() <<std::endl;
	  tester.check(ugrid1.sizeRemote() == (Pooma::contexts()-1)*b/Pooma::contexts() );
	}
    }
  tester.out()<<std::endl;

  ugrid1.repartition(par, LocalMapper<2>(par));

 tester.out() << "Layout with LocalMapper = " << ugrid1 << std::endl;
 


  tester.out() << "-------------------------------------------" << std::endl;
  int retval = tester.results("Cross Context Layout tests");
  Pooma::finalize();
  return retval;
}

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: xcontextlayout_test.cpp,v $   $Author: luchini $
// $Revision: 1.13 $   $Date: 2000/06/02 17:39:23 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
