// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

// ----------------------------------------------------------------------
// Member function map() of class UniformMapper
// ----------------------------------------------------------------------

// ----------------------------------------------------------------------
// Include files
// ----------------------------------------------------------------------

#include "Partition/UniformMapper.h"
#include "Pooma/Pooma.h"

// namespace Pooma {

void UniformMapper::map(const List_t& templist) const
{
  // assign the Nodes in the list to contexts in a uniform manner

  int contexts = Pooma::contexts();
  int npc = blocks_m.first() / contexts;
  int remainder = blocks_m.first() % contexts;

  int index = 0;
  for (int c=0; c<contexts; ++c) 
  {
    // put an equal number of Nodes on each context
    for (int i=0; i<npc; ++i)
      templist[index++]->context() = c;
    // handle any remainder
    if (c < remainder)
      templist[index++]->context() = c;
  }

  // assign local ID's and affinity values to local Nodes
  // defer this to ContextMapper base class

  setAffinity(templist);
}

// } // namespace Pooma

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: UniformMapper.cmpl.cpp,v $   $Author: luchini $
// $Revision: 1.3 $   $Date: 2000/06/05 22:42:44 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
