// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license
//-----------------------------------------------------------------------------
// BrickEngine test code
//-----------------------------------------------------------------------------

#include "Pooma/Pooma.h"
#include "Utilities/PAssert.h"
#include "Utilities/Tester.h"
#include "Domain/Interval.h"
#include "Domain/Range.h"
#include "Engine/BrickEngine.h"
#include "Engine/IndirectionEngine.h"
#include "Array/Array.h"

typedef Array<1,double,Brick> Array_t;
typedef Array<1,int,Brick> ArrayIn_t;
typedef Engine<1,double,IndirectionTag<Array_t,ArrayIn_t> > ArrayOut_t;

int main(int argc, char *argv[])
{
  Pooma::initialize(argc,argv);
  Pooma::Tester tester(argc,argv);
#if POOMA_EXCEPTIONS
  try {
#endif
    Interval<1> in(1,20),sh(5);
    Array_t a(in);
    ArrayIn_t h(sh);

    int i;
    for (i=1;i<=20;++i)
    {
      a(i) = i;
    }
    for (i=0;i<5;++i)
    {
      h(i) = 2*i+3;
    }

    ArrayOut_t b(a,h);

    for (i=0;i<5;++i)
    {
      b(i) += 4;
    }

    for (i=0;i<5;++i)
    {
      tester.check(a(h(i)) == h(i) + 4);
    }
#if POOMA_EXCEPTIONS
  }
  catch(const char *err) 
    { 
      tester.exceptionHandler( err );
      tester.set( false );
    }
  catch(const Pooma::Assertion &err)
    { 
      tester.exceptionHandler( err );
      tester.set( false );
    }
#endif    
  int ret = tester.results("indirect_test1");
  Pooma::finalize();
  return ret;
}

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: indirect_test1.cpp,v $   $Author: swhaney $
// $Revision: 1.6 $   $Date: 2000/03/07 13:16:59 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
