<?php

// Require
require_once __DIR__ . '/CaBundle/autoload.php';
require_once __DIR__ . '/ClassMapGenerator/autoload.php';
require_once __DIR__ . '/MetadataMinifier/autoload.php';
require_once __DIR__ . '/Pcre/autoload.php';
require_once __DIR__ . '/Semver/autoload.php';
require_once __DIR__ . '/Spdx/autoload.php';
require_once __DIR__ . '/XdebugHandler/autoload.php';
require_once __DIR__ . '/../JsonSchema/autoload.php';
require_once __DIR__ . '/../Psr/Log/autoload.php';
require_once __DIR__ . '/../React/Promise/autoload.php';
require_once __DIR__ . '/../Seld/JsonLint/autoload.php';
require_once __DIR__ . '/../Seld/Signal/autoload.php';
require_once __DIR__ . '/../Symfony/Component/Console/autoload.php';
require_once __DIR__ . '/../Symfony/Component/Filesystem/autoload.php';
require_once __DIR__ . '/../Symfony/Component/Finder/autoload.php';
require_once __DIR__ . '/../Symfony/Component/Process/autoload.php';

// Suggest

// @codingStandardsIgnoreFile
// @codeCoverageIgnoreStart
// this is an autogenerated file - do not edit
spl_autoload_register(
    function($class) {
        static $classes = null;
        if ($classes === null) {
            $classes = array(
                'composer\\advisory\\auditor' => '/Advisory/Auditor.php',
                'composer\\advisory\\partialsecurityadvisory' => '/Advisory/PartialSecurityAdvisory.php',
                'composer\\advisory\\securityadvisory' => '/Advisory/SecurityAdvisory.php',
                'composer\\autoload\\autoloadgenerator' => '/Autoload/AutoloadGenerator.php',
                'composer\\autoload\\classloader' => '/Autoload/ClassLoader.php',
                'composer\\autoload\\classmapgenerator' => '/Autoload/ClassMapGenerator.php',
                'composer\\autoload\\phpfilecleaner' => '/Autoload/PhpFileCleaner.php',
                'composer\\cache' => '/Cache.php',
                'composer\\command\\aboutcommand' => '/Command/AboutCommand.php',
                'composer\\command\\archivecommand' => '/Command/ArchiveCommand.php',
                'composer\\command\\auditcommand' => '/Command/AuditCommand.php',
                'composer\\command\\basecommand' => '/Command/BaseCommand.php',
                'composer\\command\\basedependencycommand' => '/Command/BaseDependencyCommand.php',
                'composer\\command\\bumpcommand' => '/Command/BumpCommand.php',
                'composer\\command\\checkplatformreqscommand' => '/Command/CheckPlatformReqsCommand.php',
                'composer\\command\\clearcachecommand' => '/Command/ClearCacheCommand.php',
                'composer\\command\\completiontrait' => '/Command/CompletionTrait.php',
                'composer\\command\\configcommand' => '/Command/ConfigCommand.php',
                'composer\\command\\createprojectcommand' => '/Command/CreateProjectCommand.php',
                'composer\\command\\dependscommand' => '/Command/DependsCommand.php',
                'composer\\command\\diagnosecommand' => '/Command/DiagnoseCommand.php',
                'composer\\command\\dumpautoloadcommand' => '/Command/DumpAutoloadCommand.php',
                'composer\\command\\execcommand' => '/Command/ExecCommand.php',
                'composer\\command\\fundcommand' => '/Command/FundCommand.php',
                'composer\\command\\globalcommand' => '/Command/GlobalCommand.php',
                'composer\\command\\homecommand' => '/Command/HomeCommand.php',
                'composer\\command\\initcommand' => '/Command/InitCommand.php',
                'composer\\command\\installcommand' => '/Command/InstallCommand.php',
                'composer\\command\\licensescommand' => '/Command/LicensesCommand.php',
                'composer\\command\\outdatedcommand' => '/Command/OutdatedCommand.php',
                'composer\\command\\packagediscoverytrait' => '/Command/PackageDiscoveryTrait.php',
                'composer\\command\\prohibitscommand' => '/Command/ProhibitsCommand.php',
                'composer\\command\\reinstallcommand' => '/Command/ReinstallCommand.php',
                'composer\\command\\removecommand' => '/Command/RemoveCommand.php',
                'composer\\command\\requirecommand' => '/Command/RequireCommand.php',
                'composer\\command\\runscriptcommand' => '/Command/RunScriptCommand.php',
                'composer\\command\\scriptaliascommand' => '/Command/ScriptAliasCommand.php',
                'composer\\command\\searchcommand' => '/Command/SearchCommand.php',
                'composer\\command\\selfupdatecommand' => '/Command/SelfUpdateCommand.php',
                'composer\\command\\showcommand' => '/Command/ShowCommand.php',
                'composer\\command\\statuscommand' => '/Command/StatusCommand.php',
                'composer\\command\\suggestscommand' => '/Command/SuggestsCommand.php',
                'composer\\command\\updatecommand' => '/Command/UpdateCommand.php',
                'composer\\command\\validatecommand' => '/Command/ValidateCommand.php',
                'composer\\compiler' => '/Compiler.php',
                'composer\\composer' => '/Composer.php',
                'composer\\config' => '/Config.php',
                'composer\\config\\configsourceinterface' => '/Config/ConfigSourceInterface.php',
                'composer\\config\\jsonconfigsource' => '/Config/JsonConfigSource.php',
                'composer\\console\\application' => '/Console/Application.php',
                'composer\\console\\githubactionerror' => '/Console/GithubActionError.php',
                'composer\\console\\htmloutputformatter' => '/Console/HtmlOutputFormatter.php',
                'composer\\console\\input\\inputargument' => '/Console/Input/InputArgument.php',
                'composer\\console\\input\\inputoption' => '/Console/Input/InputOption.php',
                'composer\\dependencyresolver\\decisions' => '/DependencyResolver/Decisions.php',
                'composer\\dependencyresolver\\defaultpolicy' => '/DependencyResolver/DefaultPolicy.php',
                'composer\\dependencyresolver\\genericrule' => '/DependencyResolver/GenericRule.php',
                'composer\\dependencyresolver\\localrepotransaction' => '/DependencyResolver/LocalRepoTransaction.php',
                'composer\\dependencyresolver\\locktransaction' => '/DependencyResolver/LockTransaction.php',
                'composer\\dependencyresolver\\multiconflictrule' => '/DependencyResolver/MultiConflictRule.php',
                'composer\\dependencyresolver\\operation\\installoperation' => '/DependencyResolver/Operation/InstallOperation.php',
                'composer\\dependencyresolver\\operation\\markaliasinstalledoperation' => '/DependencyResolver/Operation/MarkAliasInstalledOperation.php',
                'composer\\dependencyresolver\\operation\\markaliasuninstalledoperation' => '/DependencyResolver/Operation/MarkAliasUninstalledOperation.php',
                'composer\\dependencyresolver\\operation\\operationinterface' => '/DependencyResolver/Operation/OperationInterface.php',
                'composer\\dependencyresolver\\operation\\solveroperation' => '/DependencyResolver/Operation/SolverOperation.php',
                'composer\\dependencyresolver\\operation\\uninstalloperation' => '/DependencyResolver/Operation/UninstallOperation.php',
                'composer\\dependencyresolver\\operation\\updateoperation' => '/DependencyResolver/Operation/UpdateOperation.php',
                'composer\\dependencyresolver\\policyinterface' => '/DependencyResolver/PolicyInterface.php',
                'composer\\dependencyresolver\\pool' => '/DependencyResolver/Pool.php',
                'composer\\dependencyresolver\\poolbuilder' => '/DependencyResolver/PoolBuilder.php',
                'composer\\dependencyresolver\\pooloptimizer' => '/DependencyResolver/PoolOptimizer.php',
                'composer\\dependencyresolver\\problem' => '/DependencyResolver/Problem.php',
                'composer\\dependencyresolver\\request' => '/DependencyResolver/Request.php',
                'composer\\dependencyresolver\\rule' => '/DependencyResolver/Rule.php',
                'composer\\dependencyresolver\\rule2literals' => '/DependencyResolver/Rule2Literals.php',
                'composer\\dependencyresolver\\ruleset' => '/DependencyResolver/RuleSet.php',
                'composer\\dependencyresolver\\rulesetgenerator' => '/DependencyResolver/RuleSetGenerator.php',
                'composer\\dependencyresolver\\rulesetiterator' => '/DependencyResolver/RuleSetIterator.php',
                'composer\\dependencyresolver\\rulewatchchain' => '/DependencyResolver/RuleWatchChain.php',
                'composer\\dependencyresolver\\rulewatchgraph' => '/DependencyResolver/RuleWatchGraph.php',
                'composer\\dependencyresolver\\rulewatchnode' => '/DependencyResolver/RuleWatchNode.php',
                'composer\\dependencyresolver\\solver' => '/DependencyResolver/Solver.php',
                'composer\\dependencyresolver\\solverbugexception' => '/DependencyResolver/SolverBugException.php',
                'composer\\dependencyresolver\\solverproblemsexception' => '/DependencyResolver/SolverProblemsException.php',
                'composer\\dependencyresolver\\transaction' => '/DependencyResolver/Transaction.php',
                'composer\\downloader\\archivedownloader' => '/Downloader/ArchiveDownloader.php',
                'composer\\downloader\\changereportinterface' => '/Downloader/ChangeReportInterface.php',
                'composer\\downloader\\downloaderinterface' => '/Downloader/DownloaderInterface.php',
                'composer\\downloader\\downloadmanager' => '/Downloader/DownloadManager.php',
                'composer\\downloader\\dvcsdownloaderinterface' => '/Downloader/DvcsDownloaderInterface.php',
                'composer\\downloader\\filedownloader' => '/Downloader/FileDownloader.php',
                'composer\\downloader\\filesystemexception' => '/Downloader/FilesystemException.php',
                'composer\\downloader\\fossildownloader' => '/Downloader/FossilDownloader.php',
                'composer\\downloader\\gitdownloader' => '/Downloader/GitDownloader.php',
                'composer\\downloader\\gzipdownloader' => '/Downloader/GzipDownloader.php',
                'composer\\downloader\\hgdownloader' => '/Downloader/HgDownloader.php',
                'composer\\downloader\\maxfilesizeexceededexception' => '/Downloader/MaxFileSizeExceededException.php',
                'composer\\downloader\\pathdownloader' => '/Downloader/PathDownloader.php',
                'composer\\downloader\\perforcedownloader' => '/Downloader/PerforceDownloader.php',
                'composer\\downloader\\phardownloader' => '/Downloader/PharDownloader.php',
                'composer\\downloader\\rardownloader' => '/Downloader/RarDownloader.php',
                'composer\\downloader\\svndownloader' => '/Downloader/SvnDownloader.php',
                'composer\\downloader\\tardownloader' => '/Downloader/TarDownloader.php',
                'composer\\downloader\\transportexception' => '/Downloader/TransportException.php',
                'composer\\downloader\\vcscapabledownloaderinterface' => '/Downloader/VcsCapableDownloaderInterface.php',
                'composer\\downloader\\vcsdownloader' => '/Downloader/VcsDownloader.php',
                'composer\\downloader\\xzdownloader' => '/Downloader/XzDownloader.php',
                'composer\\downloader\\zipdownloader' => '/Downloader/ZipDownloader.php',
                'composer\\eventdispatcher\\event' => '/EventDispatcher/Event.php',
                'composer\\eventdispatcher\\eventdispatcher' => '/EventDispatcher/EventDispatcher.php',
                'composer\\eventdispatcher\\eventsubscriberinterface' => '/EventDispatcher/EventSubscriberInterface.php',
                'composer\\eventdispatcher\\scriptexecutionexception' => '/EventDispatcher/ScriptExecutionException.php',
                'composer\\exception\\irrecoverabledownloadexception' => '/Exception/IrrecoverableDownloadException.php',
                'composer\\exception\\nosslexception' => '/Exception/NoSslException.php',
                'composer\\factory' => '/Factory.php',
                'composer\\filter\\platformrequirementfilter\\ignoreallplatformrequirementfilter' => '/Filter/PlatformRequirementFilter/IgnoreAllPlatformRequirementFilter.php',
                'composer\\filter\\platformrequirementfilter\\ignorelistplatformrequirementfilter' => '/Filter/PlatformRequirementFilter/IgnoreListPlatformRequirementFilter.php',
                'composer\\filter\\platformrequirementfilter\\ignorenothingplatformrequirementfilter' => '/Filter/PlatformRequirementFilter/IgnoreNothingPlatformRequirementFilter.php',
                'composer\\filter\\platformrequirementfilter\\platformrequirementfilterfactory' => '/Filter/PlatformRequirementFilter/PlatformRequirementFilterFactory.php',
                'composer\\filter\\platformrequirementfilter\\platformrequirementfilterinterface' => '/Filter/PlatformRequirementFilter/PlatformRequirementFilterInterface.php',
                'composer\\installedversions' => '/InstalledVersions.php',
                'composer\\installer' => '/Installer.php',
                'composer\\installer\\binaryinstaller' => '/Installer/BinaryInstaller.php',
                'composer\\installer\\binarypresenceinterface' => '/Installer/BinaryPresenceInterface.php',
                'composer\\installer\\installationmanager' => '/Installer/InstallationManager.php',
                'composer\\installer\\installerevent' => '/Installer/InstallerEvent.php',
                'composer\\installer\\installerevents' => '/Installer/InstallerEvents.php',
                'composer\\installer\\installerinterface' => '/Installer/InstallerInterface.php',
                'composer\\installer\\libraryinstaller' => '/Installer/LibraryInstaller.php',
                'composer\\installer\\metapackageinstaller' => '/Installer/MetapackageInstaller.php',
                'composer\\installer\\noopinstaller' => '/Installer/NoopInstaller.php',
                'composer\\installer\\packageevent' => '/Installer/PackageEvent.php',
                'composer\\installer\\packageevents' => '/Installer/PackageEvents.php',
                'composer\\installer\\plugininstaller' => '/Installer/PluginInstaller.php',
                'composer\\installer\\projectinstaller' => '/Installer/ProjectInstaller.php',
                'composer\\installer\\suggestedpackagesreporter' => '/Installer/SuggestedPackagesReporter.php',
                'composer\\io\\baseio' => '/IO/BaseIO.php',
                'composer\\io\\bufferio' => '/IO/BufferIO.php',
                'composer\\io\\consoleio' => '/IO/ConsoleIO.php',
                'composer\\io\\iointerface' => '/IO/IOInterface.php',
                'composer\\io\\nullio' => '/IO/NullIO.php',
                'composer\\json\\jsonfile' => '/Json/JsonFile.php',
                'composer\\json\\jsonformatter' => '/Json/JsonFormatter.php',
                'composer\\json\\jsonmanipulator' => '/Json/JsonManipulator.php',
                'composer\\json\\jsonvalidationexception' => '/Json/JsonValidationException.php',
                'composer\\package\\aliaspackage' => '/Package/AliasPackage.php',
                'composer\\package\\archiver\\archivablefilesfilter' => '/Package/Archiver/ArchivableFilesFilter.php',
                'composer\\package\\archiver\\archivablefilesfinder' => '/Package/Archiver/ArchivableFilesFinder.php',
                'composer\\package\\archiver\\archivemanager' => '/Package/Archiver/ArchiveManager.php',
                'composer\\package\\archiver\\archiverinterface' => '/Package/Archiver/ArchiverInterface.php',
                'composer\\package\\archiver\\baseexcludefilter' => '/Package/Archiver/BaseExcludeFilter.php',
                'composer\\package\\archiver\\composerexcludefilter' => '/Package/Archiver/ComposerExcludeFilter.php',
                'composer\\package\\archiver\\gitexcludefilter' => '/Package/Archiver/GitExcludeFilter.php',
                'composer\\package\\archiver\\phararchiver' => '/Package/Archiver/PharArchiver.php',
                'composer\\package\\archiver\\ziparchiver' => '/Package/Archiver/ZipArchiver.php',
                'composer\\package\\basepackage' => '/Package/BasePackage.php',
                'composer\\package\\comparer\\comparer' => '/Package/Comparer/Comparer.php',
                'composer\\package\\completealiaspackage' => '/Package/CompleteAliasPackage.php',
                'composer\\package\\completepackage' => '/Package/CompletePackage.php',
                'composer\\package\\completepackageinterface' => '/Package/CompletePackageInterface.php',
                'composer\\package\\dumper\\arraydumper' => '/Package/Dumper/ArrayDumper.php',
                'composer\\package\\link' => '/Package/Link.php',
                'composer\\package\\loader\\arrayloader' => '/Package/Loader/ArrayLoader.php',
                'composer\\package\\loader\\invalidpackageexception' => '/Package/Loader/InvalidPackageException.php',
                'composer\\package\\loader\\jsonloader' => '/Package/Loader/JsonLoader.php',
                'composer\\package\\loader\\loaderinterface' => '/Package/Loader/LoaderInterface.php',
                'composer\\package\\loader\\rootpackageloader' => '/Package/Loader/RootPackageLoader.php',
                'composer\\package\\loader\\validatingarrayloader' => '/Package/Loader/ValidatingArrayLoader.php',
                'composer\\package\\locker' => '/Package/Locker.php',
                'composer\\package\\package' => '/Package/Package.php',
                'composer\\package\\packageinterface' => '/Package/PackageInterface.php',
                'composer\\package\\rootaliaspackage' => '/Package/RootAliasPackage.php',
                'composer\\package\\rootpackage' => '/Package/RootPackage.php',
                'composer\\package\\rootpackageinterface' => '/Package/RootPackageInterface.php',
                'composer\\package\\version\\stabilityfilter' => '/Package/Version/StabilityFilter.php',
                'composer\\package\\version\\versionbumper' => '/Package/Version/VersionBumper.php',
                'composer\\package\\version\\versionguesser' => '/Package/Version/VersionGuesser.php',
                'composer\\package\\version\\versionparser' => '/Package/Version/VersionParser.php',
                'composer\\package\\version\\versionselector' => '/Package/Version/VersionSelector.php',
                'composer\\partialcomposer' => '/PartialComposer.php',
                'composer\\phpstan\\configreturntypeextension' => '/PHPStan/ConfigReturnTypeExtension.php',
                'composer\\phpstan\\rulereasondatareturntypeextension' => '/PHPStan/RuleReasonDataReturnTypeExtension.php',
                'composer\\platform\\hhvmdetector' => '/Platform/HhvmDetector.php',
                'composer\\platform\\runtime' => '/Platform/Runtime.php',
                'composer\\platform\\version' => '/Platform/Version.php',
                'composer\\plugin\\capability\\capability' => '/Plugin/Capability/Capability.php',
                'composer\\plugin\\capability\\commandprovider' => '/Plugin/Capability/CommandProvider.php',
                'composer\\plugin\\capable' => '/Plugin/Capable.php',
                'composer\\plugin\\commandevent' => '/Plugin/CommandEvent.php',
                'composer\\plugin\\pluginblockedexception' => '/Plugin/PluginBlockedException.php',
                'composer\\plugin\\pluginevents' => '/Plugin/PluginEvents.php',
                'composer\\plugin\\plugininterface' => '/Plugin/PluginInterface.php',
                'composer\\plugin\\pluginmanager' => '/Plugin/PluginManager.php',
                'composer\\plugin\\postfiledownloadevent' => '/Plugin/PostFileDownloadEvent.php',
                'composer\\plugin\\precommandrunevent' => '/Plugin/PreCommandRunEvent.php',
                'composer\\plugin\\prefiledownloadevent' => '/Plugin/PreFileDownloadEvent.php',
                'composer\\plugin\\prepoolcreateevent' => '/Plugin/PrePoolCreateEvent.php',
                'composer\\question\\strictconfirmationquestion' => '/Question/StrictConfirmationQuestion.php',
                'composer\\repository\\advisoryproviderinterface' => '/Repository/AdvisoryProviderInterface.php',
                'composer\\repository\\arrayrepository' => '/Repository/ArrayRepository.php',
                'composer\\repository\\artifactrepository' => '/Repository/ArtifactRepository.php',
                'composer\\repository\\canonicalpackagestrait' => '/Repository/CanonicalPackagesTrait.php',
                'composer\\repository\\composerrepository' => '/Repository/ComposerRepository.php',
                'composer\\repository\\compositerepository' => '/Repository/CompositeRepository.php',
                'composer\\repository\\configurablerepositoryinterface' => '/Repository/ConfigurableRepositoryInterface.php',
                'composer\\repository\\filesystemrepository' => '/Repository/FilesystemRepository.php',
                'composer\\repository\\filterrepository' => '/Repository/FilterRepository.php',
                'composer\\repository\\installedarrayrepository' => '/Repository/InstalledArrayRepository.php',
                'composer\\repository\\installedfilesystemrepository' => '/Repository/InstalledFilesystemRepository.php',
                'composer\\repository\\installedrepository' => '/Repository/InstalledRepository.php',
                'composer\\repository\\installedrepositoryinterface' => '/Repository/InstalledRepositoryInterface.php',
                'composer\\repository\\invalidrepositoryexception' => '/Repository/InvalidRepositoryException.php',
                'composer\\repository\\lockarrayrepository' => '/Repository/LockArrayRepository.php',
                'composer\\repository\\packagerepository' => '/Repository/PackageRepository.php',
                'composer\\repository\\pathrepository' => '/Repository/PathRepository.php',
                'composer\\repository\\pearrepository' => '/Repository/PearRepository.php',
                'composer\\repository\\platformrepository' => '/Repository/PlatformRepository.php',
                'composer\\repository\\repositoryfactory' => '/Repository/RepositoryFactory.php',
                'composer\\repository\\repositoryinterface' => '/Repository/RepositoryInterface.php',
                'composer\\repository\\repositorymanager' => '/Repository/RepositoryManager.php',
                'composer\\repository\\repositorysecurityexception' => '/Repository/RepositorySecurityException.php',
                'composer\\repository\\repositoryset' => '/Repository/RepositorySet.php',
                'composer\\repository\\repositoryutils' => '/Repository/RepositoryUtils.php',
                'composer\\repository\\rootpackagerepository' => '/Repository/RootPackageRepository.php',
                'composer\\repository\\vcs\\fossildriver' => '/Repository/Vcs/FossilDriver.php',
                'composer\\repository\\vcs\\gitbitbucketdriver' => '/Repository/Vcs/GitBitbucketDriver.php',
                'composer\\repository\\vcs\\gitdriver' => '/Repository/Vcs/GitDriver.php',
                'composer\\repository\\vcs\\githubdriver' => '/Repository/Vcs/GitHubDriver.php',
                'composer\\repository\\vcs\\gitlabdriver' => '/Repository/Vcs/GitLabDriver.php',
                'composer\\repository\\vcs\\hgdriver' => '/Repository/Vcs/HgDriver.php',
                'composer\\repository\\vcs\\perforcedriver' => '/Repository/Vcs/PerforceDriver.php',
                'composer\\repository\\vcs\\svndriver' => '/Repository/Vcs/SvnDriver.php',
                'composer\\repository\\vcs\\vcsdriver' => '/Repository/Vcs/VcsDriver.php',
                'composer\\repository\\vcs\\vcsdriverinterface' => '/Repository/Vcs/VcsDriverInterface.php',
                'composer\\repository\\vcsrepository' => '/Repository/VcsRepository.php',
                'composer\\repository\\versioncacheinterface' => '/Repository/VersionCacheInterface.php',
                'composer\\repository\\writablearrayrepository' => '/Repository/WritableArrayRepository.php',
                'composer\\repository\\writablerepositoryinterface' => '/Repository/WritableRepositoryInterface.php',
                'composer\\script\\event' => '/Script/Event.php',
                'composer\\script\\scriptevents' => '/Script/ScriptEvents.php',
                'composer\\selfupdate\\keys' => '/SelfUpdate/Keys.php',
                'composer\\selfupdate\\versions' => '/SelfUpdate/Versions.php',
                'composer\\util\\authhelper' => '/Util/AuthHelper.php',
                'composer\\util\\bitbucket' => '/Util/Bitbucket.php',
                'composer\\util\\composermirror' => '/Util/ComposerMirror.php',
                'composer\\util\\configvalidator' => '/Util/ConfigValidator.php',
                'composer\\util\\errorhandler' => '/Util/ErrorHandler.php',
                'composer\\util\\filesystem' => '/Util/Filesystem.php',
                'composer\\util\\git' => '/Util/Git.php',
                'composer\\util\\github' => '/Util/GitHub.php',
                'composer\\util\\gitlab' => '/Util/GitLab.php',
                'composer\\util\\hg' => '/Util/Hg.php',
                'composer\\util\\http\\curldownloader' => '/Util/Http/CurlDownloader.php',
                'composer\\util\\http\\curlresponse' => '/Util/Http/CurlResponse.php',
                'composer\\util\\http\\proxyhelper' => '/Util/Http/ProxyHelper.php',
                'composer\\util\\http\\proxymanager' => '/Util/Http/ProxyManager.php',
                'composer\\util\\http\\requestproxy' => '/Util/Http/RequestProxy.php',
                'composer\\util\\http\\response' => '/Util/Http/Response.php',
                'composer\\util\\httpdownloader' => '/Util/HttpDownloader.php',
                'composer\\util\\inihelper' => '/Util/IniHelper.php',
                'composer\\util\\loop' => '/Util/Loop.php',
                'composer\\util\\metadataminifier' => '/Util/MetadataMinifier.php',
                'composer\\util\\noproxypattern' => '/Util/NoProxyPattern.php',
                'composer\\util\\packageinfo' => '/Util/PackageInfo.php',
                'composer\\util\\packagesorter' => '/Util/PackageSorter.php',
                'composer\\util\\perforce' => '/Util/Perforce.php',
                'composer\\util\\platform' => '/Util/Platform.php',
                'composer\\util\\processexecutor' => '/Util/ProcessExecutor.php',
                'composer\\util\\remotefilesystem' => '/Util/RemoteFilesystem.php',
                'composer\\util\\silencer' => '/Util/Silencer.php',
                'composer\\util\\streamcontextfactory' => '/Util/StreamContextFactory.php',
                'composer\\util\\svn' => '/Util/Svn.php',
                'composer\\util\\synchelper' => '/Util/SyncHelper.php',
                'composer\\util\\tar' => '/Util/Tar.php',
                'composer\\util\\tlshelper' => '/Util/TlsHelper.php',
                'composer\\util\\url' => '/Util/Url.php',
                'composer\\util\\zip' => '/Util/Zip.php'
            );
        }
        $cn = strtolower($class);
        if (isset($classes[$cn])) {
            require __DIR__ . $classes[$cn];
        }
    },
    true,
    false
);
// @codeCoverageIgnoreEnd

// Files
