
package WSNotification::Elements::GetMessages;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'http://docs.oasis-open.org/wsn/b-2' }

__PACKAGE__->__set_name('GetMessages');
__PACKAGE__->__set_nillable();
__PACKAGE__->__set_minOccurs();
__PACKAGE__->__set_maxOccurs();
__PACKAGE__->__set_ref();

use base qw(
    SOAP::WSDL::XSD::Typelib::Element
    SOAP::WSDL::XSD::Typelib::ComplexType
);

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %MaximumNumber_of :ATTR(:get<MaximumNumber>);

__PACKAGE__->_factory(
    [ qw(        MaximumNumber

    ) ],
    {
        'MaximumNumber' => \%MaximumNumber_of,
    },
    {
        'MaximumNumber' => 'SOAP::WSDL::XSD::Typelib::Builtin::nonNegativeInteger',
    },
    {

        'MaximumNumber' => 'MaximumNumber',
    }
);

} # end BLOCK







} # end of BLOCK



1;


=pod

=head1 NAME

WSNotification::Elements::GetMessages

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
GetMessages from the namespace http://docs.oasis-open.org/wsn/b-2.







=head1 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * MaximumNumber

 $element->set_MaximumNumber($data);
 $element->get_MaximumNumber();





=back


=head1 METHODS

=head2 new

 my $element = WSNotification::Elements::GetMessages->new($data);

Constructor. The following data structure may be passed to new():

 {
   MaximumNumber =>  $some_value, # nonNegativeInteger
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

