TYPE=TRIGGERS
triggers='CREATE DEFINER=`root`@`localhost` TRIGGER event_insert_trigger AFTER INSERT ON Events\nFOR EACH ROW\n  BEGIN\n\n  INSERT INTO Events_Hour (EventId,MonitorId,StartDateTime,DiskSpace) VALUES (NEW.Id,NEW.MonitorId,NEW.StartDateTime,0);\n  INSERT INTO Events_Day (EventId,MonitorId,StartDateTime,DiskSpace) VALUES (NEW.Id,NEW.MonitorId,NEW.StartDateTime,0);\n  INSERT INTO Events_Week (EventId,MonitorId,StartDateTime,DiskSpace) VALUES (NEW.Id,NEW.MonitorId,NEW.StartDateTime,0);\n  INSERT INTO Events_Month (EventId,MonitorId,StartDateTime,DiskSpace) VALUES (NEW.Id,NEW.MonitorId,NEW.StartDateTime,0);\n  INSERT INTO Event_Summaries (MonitorId,HourEvents,DayEvents,WeekEvents,MonthEvents,TotalEvents) VALUES (NEW.MonitorId,1,1,1,1,1) ON DUPLICATE KEY\n  UPDATE \n  HourEvents = COALESCE(HourEvents,0)+1,\n  DayEvents = COALESCE(DayEvents,0)+1,\n  WeekEvents = COALESCE(WeekEvents,0)+1,\n  MonthEvents = COALESCE(MonthEvents,0)+1,\n  TotalEvents = COALESCE(TotalEvents,0)+1;\nEND' 'CREATE DEFINER=`root`@`localhost` TRIGGER event_update_trigger AFTER UPDATE ON Events \nFOR EACH ROW\nBEGIN\n  declare diff BIGINT default 0;\n\n  set diff = COALESCE(NEW.DiskSpace,0) - COALESCE(OLD.DiskSpace,0);\n  IF ( NEW.StorageId = OLD.StorageID ) THEN\n    IF ( diff ) THEN\n      UPDATE Storage SET DiskSpace = GREATEST(COALESCE(DiskSpace,0) + diff,0) WHERE Storage.Id = OLD.StorageId;\n    END IF;\n  ELSE\n    IF ( NEW.DiskSpace ) THEN\n      UPDATE Storage SET DiskSpace = COALESCE(DiskSpace,0) + NEW.DiskSpace WHERE Storage.Id = NEW.StorageId;\n    END IF;\n    IF ( OLD.DiskSpace ) THEN\n      UPDATE Storage SET DiskSpace = GREATEST(COALESCE(DiskSpace,0) - OLD.DiskSpace,0) WHERE Storage.Id = OLD.StorageId;\n    END IF;\n  END IF;\n\n  UPDATE Events_Hour SET DiskSpace=NEW.DiskSpace WHERE EventId=NEW.Id;\n  UPDATE Events_Day SET DiskSpace=NEW.DiskSpace WHERE EventId=NEW.Id;\n  UPDATE Events_Week SET DiskSpace=NEW.DiskSpace WHERE EventId=NEW.Id;\n  UPDATE Events_Month SET DiskSpace=NEW.DiskSpace WHERE EventId=NEW.Id;\n\n  IF ( NEW.Archived != OLD.Archived ) THEN\n    IF ( NEW.Archived ) THEN\n      INSERT INTO Events_Archived (EventId,MonitorId,DiskSpace) VALUES (NEW.Id,NEW.MonitorId,NEW.DiskSpace);\n      INSERT INTO Event_Summaries (MonitorId,ArchivedEvents,ArchivedEventDiskSpace) VALUES (NEW.MonitorId,1,NEW.DiskSpace) ON DUPLICATE KEY\n        UPDATE ArchivedEvents = COALESCE(ArchivedEvents,0)+1, ArchivedEventDiskSpace = COALESCE(ArchivedEventDiskSpace,0) + COALESCE(NEW.DiskSpace,0);\n    ELSEIF ( OLD.Archived ) THEN\n      DELETE FROM Events_Archived WHERE EventId=OLD.Id;\n      UPDATE Event_Summaries\n        SET\n          ArchivedEvents = GREATEST(COALESCE(ArchivedEvents,0)-1,0),\n          ArchivedEventDiskSpace = GREATEST(COALESCE(ArchivedEventDiskSpace,0) - COALESCE(OLD.DiskSpace,0),0)\n        WHERE Event_Summaries.MonitorId=OLD.MonitorId;\n    ELSE\n      IF ( OLD.DiskSpace != NEW.DiskSpace ) THEN\n        UPDATE Events_Archived SET DiskSpace=NEW.DiskSpace WHERE EventId=NEW.Id;\n        UPDATE Event_Summaries SET\n          ArchivedEventDiskSpace = GREATEST(COALESCE(ArchivedEventDiskSpace,0) - COALESCE(OLD.DiskSpace,0) + COALESCE(NEW.DiskSpace,0),0)\n          WHERE Event_Summaries.MonitorId=OLD.MonitorId;\n      END IF;\n    END IF;\n  ELSEIF ( NEW.Archived AND diff ) THEN\n    UPDATE Events_Archived SET DiskSpace=NEW.DiskSpace WHERE EventId=NEW.Id;\n  END IF;\n\n  IF ( diff ) THEN\n    UPDATE Event_Summaries\n      SET\n        TotalEventDiskSpace = GREATEST(COALESCE(TotalEventDiskSpace,0) - COALESCE(OLD.DiskSpace,0) + COALESCE(NEW.DiskSpace,0),0)\n      WHERE Event_Summaries.MonitorId=OLD.MonitorId;\n  END IF;\n\nEND' 'CREATE DEFINER=`root`@`localhost` TRIGGER event_delete_trigger BEFORE DELETE ON Events\nFOR EACH ROW\nBEGIN\n  IF ( OLD.DiskSpace ) THEN\n    UPDATE Storage SET DiskSpace = GREATEST(COALESCE(DiskSpace,0) - COALESCE(OLD.DiskSpace,0),0) WHERE Storage.Id = OLD.StorageId;\n  END IF;\n  DELETE FROM Events_Hour WHERE EventId=OLD.Id;\n  DELETE FROM Events_Day WHERE EventId=OLD.Id;\n  DELETE FROM Events_Week WHERE EventId=OLD.Id;\n  DELETE FROM Events_Month WHERE EventId=OLD.Id;\n  IF ( OLD.Archived ) THEN\n    DELETE FROM Events_Archived WHERE EventId=OLD.Id;\n    UPDATE Event_Summaries SET\n      ArchivedEvents = GREATEST(COALESCE(ArchivedEvents,1) - 1,0),\n      ArchivedEventDiskSpace = GREATEST(COALESCE(ArchivedEventDiskSpace,0) - COALESCE(OLD.DiskSpace,0),0),\n      TotalEvents = GREATEST(COALESCE(TotalEvents,1) - 1,0),\n      TotalEventDiskSpace = GREATEST(COALESCE(TotalEventDiskSpace,0) - COALESCE(OLD.DiskSpace,0),0)\n      WHERE Event_Summaries.MonitorId=OLD.MonitorId;\n  ELSE\n    UPDATE Event_Summaries SET\n    TotalEvents = GREATEST(COALESCE(TotalEvents,1)-1,0),\n    TotalEventDiskSpace=GREATEST(COALESCE(TotalEventDiskSpace,0)-COALESCE(OLD.DiskSpace,0),0)\n    WHERE Event_Summaries.MonitorId=OLD.MonitorId;\n  END IF;\nEND'
sql_modes=1411383296 1411383296 1411383296
definers='root@localhost' 'root@localhost' 'root@localhost'
client_cs_names='utf8mb4' 'utf8mb4' 'utf8mb4'
connection_cl_names='utf8mb4_general_ci' 'utf8mb4_general_ci' 'utf8mb4_general_ci'
db_cl_names='utf8mb4_general_ci' 'utf8mb4_general_ci' 'utf8mb4_general_ci'
created=1716263974905751 1716263974870051 1716263974964138
