<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head>
<meta content="text/html; charset=ISO-8859-1" http-equiv="Content-Type" />
<!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>Ngociation de contenu - Serveur Apache HTTP Version 2.4</title>
<link href="./style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="./style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="./style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="./style/css/prettify.css" />
<script src="./style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="./images/favicon.ico" rel="shortcut icon" /></head>
<body id="manual-page"><div id="page-header">
<p class="menu"><a href="./mod/">Modules</a> | <a href="./mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="./glossary.html">Glossaire</a> | <a href="./sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.4</p>
<img alt="" src="./images/feather.png" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="./images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="./">Version 2.4</a></div><div id="page-content"><div id="preamble"><h1>Ngociation de contenu</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="./en/content-negotiation.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="./fr/content-negotiation.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="./ja/content-negotiation.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="./ko/content-negotiation.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a> |
<a href="./tr/content-negotiation.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div>


    <p>Apache HTTPD supporte la ngociation de
    contenu telle qu'elle est dcrite
    dans la spcification HTTP/1.1. Il peut choisir la meilleure reprsentation
    d'une ressource en fonction des prfrences du navigateur pour ce qui
    concerne le type de media, les langages, le jeu de caractres et son
    encodage. Il implmente aussi quelques fonctionnalits pour traiter de
    manire plus intelligente les requtes en provenance de navigateurs qui
    envoient des informations de ngociation incompltes.</p>

    <p>La ngociation de contenu est assure par le module
    <code class="module"><a href="./mod/mod_negotiation.html">mod_negotiation</a></code> qui est compil par dfaut
    dans le serveur.</p>
</div>
<div id="quickview"><a href="https://www.apache.org/foundation/contributing.html" class="badge"><img src="https://www.apache.org/images/SupportApache-small.png" alt="Support Apache!" /></a><ul id="toc"><li><img alt="" src="./images/down.gif" /> <a href="#about"> propos de la ngociation de contenu</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#negotiation">La ngociation avec httpd</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#methods">Les mthodes de ngociation</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#better">Ajustement des valeurs de qualit</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#extensions">Extensions  la ngociation de contenu
transparente</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#naming">Remarques  propos des liens hypertextes et des
conventions de nommage</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#caching">Remarque sur la mise en cache</a></li>
</ul><h3>Voir aussi</h3><ul class="seealso"><li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="about" id="about"> propos de la ngociation de contenu</a></h2>

    <p>Une ressource peut tre disponible selon diffrentes reprsentations.
    Par exemple, elle peut tre disponible en diffrents langages ou pour
    diffrents types de mdia, ou une combinaison des deux.
    Pour faire le meilleur choix, on peut fournir  l'utilisateur une page
    d'index, et le laisser choisir. Cependant, le serveur peut souvent faire
    ce choix automatiquement. Ceci est possible car les navigateurs peuvent
    envoyer des informations sur les
    reprsentations qu'ils prfrent  l'intrieur de chaque requte.
    Par exemple, un navigateur peut indiquer
    qu'il prfre voir les informations en franais, mais qu'en cas
    d'impossibilit l'anglais peut convenir. Les navigateurs indiquent leurs
    prfrences  l'aide d'en-ttes dans la requte. Pour ne demander que des
    reprsentations en franais, le navigateur peut utiliser l'en-tte :</p>

<div class="example"><p><code>Accept-Language: fr</code></p></div>

    <p>Notez qu'il ne sera tenu compte de cette prfrence que s'il existe un
    choix de reprsentations et que ces dernires varient en fonction
    du langage.</p>

    <p> titre d'exemple d'une requte plus complexe, ce navigateur a t
    configur pour accepter le franais et l'anglais, avec une prfrence pour
    le franais, et accepter diffrents types de mdia, avec une prfrence
    pour HTML par rapport  au texte plat ("plain text") ou autres types de fichiers texte, et
    avec une prfrence pour GIF ou JPEG par rapport  tout autre type de
    mdia, mais autorisant tout autre type de mdia en dernier ressort :</p>

<div class="example"><p><code>
  Accept-Language: fr; q=1.0, en; q=0.5<br />
  Accept: text/html; q=1.0, text/*; q=0.8, image/gif; q=0.6, image/jpeg; q=0.6, image/*; q=0.5, */*; q=0.1
</code></p></div>

    <p>httpd supporte la ngociation de contenu "server driven" (telle qu'elle
    est dfinie dans la spcification HTTP/1.1), o c'est le serveur qui
    dcide quelle est la meilleure reprsentation  retourner pour la ressource
    demande. Il supporte entirement les en-ttes de requte
    <code>Accept</code>, <code>Accept-Language</code>,
    <code>Accept-Charset</code> et <code>Accept-Encoding</code>.
    httpd supporte aussi la ngociation de contenu transparente, qui est un
    protocole de ngociation exprimental dfini dans les RFC 2295 et 2296.
    Il ne supporte pas la ngociation de fonctionnalit (feature negotiation)
    telle qu'elle est dfinie dans ces RFCs.</p>

    <p>Une <strong>ressource</strong> est une entit conceptuelle identifie
    par une URI (RFC 2396). Un serveur HTTP comme le serveur HTTP Apache
    propose l'accs  des
    <strong>reprsentations</strong> de la ressource  l'intrieur de son
    espace de nommage, chaque reprsentation tant compose d'une squence
    d'octets avec la dfinition d'un type de media, d'un jeu de caractres,
    d'un encodage, etc... A un instant donn, chaque ressource peut tre
    associe avec zro, une ou plusieurs reprsentations. Si plusieurs
    reprsentations sont disponibles, la ressource est qualifie de
    <strong>ngociable</strong> et chacune de ses reprsentations se nomme
    <strong>variante</strong>. Les diffrences entre les
    variantes disponibles d'une ressource ngociable constituent les
    <strong>dimensions</strong> de la ngociation.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="negotiation" id="negotiation">La ngociation avec httpd</a></h2>

    <p>Afin de ngocier une ressource, on doit fournir au serveur des
    informations  propos de chacune des variantes. Il y a deux manires
    d'accomplir ceci :</p>

    <ul>
      <li>Utiliser une liste de correspondances de type ("type-map") (<em>c'est  dire</em>
      un fichier <code>*.var</code>) qui nomme explicitement les fichiers
      contenant les variantes, ou</li>

      <li>Utiliser une recherche "multivues", o le serveur effectue une
      recherche de correspondance sur un motif de nom de fichier implicite et
      fait son choix parmi les diffrents rsultats.</li>
    </ul>

   <h3><a name="type-map" id="type-map">Utilisation d'un fichier de
   correspondances de types (type-map)</a></h3>

    <p>Une liste de correspondances de types est un document associ au
    gestionnaire <code>type-map</code> (ou, dans un souci de compatibilit
    ascendante avec des configurations de httpd plus anciennes, le
    <a class="glossarylink" href="./glossary.html#type mime" title="voir glossaire">type MIME</a>
    <code>application/x-type-map</code>). Notez que pour utiliser cette
    fonctionnalit, vous devez, dans le fichier de configuration, dfinir un
    gestionnaire qui associe un suffixe de fichier  une <code>type-map</code>;
    ce qui se fait simplement en ajoutant</p>

<pre class="prettyprint lang-config">AddHandler type-map .var</pre>


    <p>dans le fichier de configuration du serveur.</p>

    <p>Les fichiers de correspondances de types doivent possder le mme nom que
    la ressource qu'ils dcrivent, avec pour extension
    <code>.var</code>. Dans l'exemple ci-dessous, la ressource a pour
    nom <code>foo</code>, et le fichier de correspondances se nomme donc
    <code>foo.var</code>.</p>

    <p>Ce fichier doit comporter une entre pour chaque variante
    disponible; chaque entre consiste en une ligne contigu d'en-ttes au
    format HTTP. les entres sont spares par des lignes vides. Les lignes
    vides  l'intrieur d'une entre sont interdites. Par convention, le
    fichier de correspondances de types dbute par une entre concernant l'entit
    considre dans son ensemble (bien que ce ne soit pas obligatoire, et
    ignor si prsent). Un exemple de fichier de
    correspondance de types est fourni
    ci-dessous.</p>

    <p>Les URIs de ce fichier sont relatifs  la localisation du fichier
    de correspondances de types. En gnral, ces fichiers se trouveront dans le
    mme rpertoire que le fichier de correspondances de types, mais ce
    n'est pas obligatoire. Vous pouvez utiliser des URIs absolus ou
    relatifs pour tout fichier situ sur le mme serveur que le fichier
    de correspondances.</p>

<div class="example"><p><code>
  URI: foo<br />
<br />
  URI: foo.en.html<br />
  Content-type: text/html<br />
  Content-language: en<br />
<br />
  URI: foo.fr.de.html<br />
  Content-type: text/html;charset=iso-8859-2<br />
  Content-language: fr, de<br />
</code></p></div>

    <p>Notez aussi qu'un fichier de correspondances de types prend le pas sur
    les extensions de noms de fichiers, mme si les Multivues sont actives.
    Si les variantes sont de qualits diffrentes, on doit l'indiquer
     l'aide du paramtre "qs"  la suite du type de mdia, comme pour cette
    image
    (disponible aux formats JPEG, GIF, ou ASCII-art) : </p>

<div class="example"><p><code>
  URI: foo<br />
<br />
  URI: foo.jpeg<br />
  Content-type: image/jpeg; qs=0.8<br />
<br />
  URI: foo.gif<br />
  Content-type: image/gif; qs=0.5<br />
<br />
  URI: foo.txt<br />
  Content-type: text/plain; qs=0.01<br />
</code></p></div>

    <p>Les valeurs de qs peuvent varier de 0.000  1.000. Notez que toute
    variante possdant une valeur de qs de 0.000 ne sera jamais choisie.
    Les variantes qui n'ont pas de paramtre qs dfini se voient attribuer
    une valeur de 1.0. Le paramtre qs indique la qualit relative de la
    variante compare  celle des autres variantes disponibles, sans tenir
    compte des capacits du client. Par exemple, un fichier JPEG possde
    en gnral une qualit suprieure  celle d'un fichier ASCII s'il
    reprsente une photographie. Cependant, si la ressource reprsente est
     un ASCII art original, la reprsentation ASCII sera de meilleure qualit
    que la reprsentation JPEG. Ainsi une valeur de qs est associe  une
    variante en fonction de la nature de la ressource qu'elle reprsente.</p>

    <p>La liste complte des en-ttes reconnus est disponible dans la
    documentation sur les <a href="mod/mod_negotiation.html#typemaps">correspondances de types du
    module mod_negotiation</a>.</p>


<h3><a name="multiviews" id="multiviews">Multivues (option Multiviews)</a></h3>

    <p><code>MultiViews</code> est une option qui s'applique  un rpertoire,
    ce qui signifie qu'elle peut tre active  l'aide d'une directive
    <code class="directive"><a href="./mod/core.html#options">Options</a></code>  l'intrieur d'une section
    <code class="directive"><a href="./mod/core.html#directory">&lt;Directory&gt;</a></code>, <code class="directive"><a href="./mod/core.html#location">&lt;Location&gt;</a></code> ou <code class="directive"><a href="./mod/core.html#files">&lt;Files&gt;</a></code> dans
    <code>httpd.conf</code>, ou (si <code class="directive"><a href="./mod/core.html#allowoverride">AllowOverride</a></code> est correctement positionne) dans
    des fichiers
    <code>.htaccess</code>. Notez que <code>Options All</code>
    n'active pas <code>MultiViews</code>; vous devez activer cette option en
    la nommant explicitement.</p>

    <p>L'effet de <code>MultiViews</code> est le suivant : si le serveur reoit
    une requte pour <code>/tel/rpertoire/foo</code>, si
    <code>MultiViews</code> est active pour
    <code>/tel/rpertoire</code>, et si
    <code>/tel/rpertoire/foo</code> n'existe <em>pas</em>, le serveur parcourt
    le rpertoire  la recherche de fichiers nomms foo.*, et simule
    littralement une correspondance de types (type map) qui liste tous ces
    fichiers, en leur associant les mmes types de mdia et encodages de
    contenu qu'ils auraient eu si le client avait demand l'accs  l'un
    d'entre eux par son nom. Il choisit ensuite ce qui correspond le mieux
    aux besoins du client.</p>

    <p><code>MultiViews</code> peut aussi s'appliquer  la recherche du fichier
    nomm par la directive <code class="directive"><a href="./mod/mod_dir.html#directoryindex">DirectoryIndex</a></code>, si le serveur tente d'indexer
    un rpertoire. Si les fichiers de configuration spcifient</p>
<pre class="prettyprint lang-config">DirectoryIndex index</pre>

    <p>le serveur va choisir entre <code>index.html</code>
    et <code>index.html3</code> si les deux fichiers sont prsents. Si aucun
    n'est prsent, mais <code>index.cgi</code> existe,
    le serveur l'excutera.</p>

    <p>Si, parcequ'elle n'est pas reconnue par <code>mod_mime</code>,
    l'extension d'un des fichiers du rpertoire ne permet pas de
    dterminer son jeu de caractres, son type de contenu, son langage, ou son
    encodage,  alors
    le rsultat dpendra de la dfinition de la directive <code class="directive"><a href="./mod/mod_mime.html#multiviewsmatch">MultiViewsMatch</a></code>. Cette directive dtermine
    si les gestionnaires (handlers), les filtres, et autres types d'extensions
    peuvent participer  la ngociation MultiVues.</p>

</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="methods" id="methods">Les mthodes de ngociation</a></h2>

    <p>Une fois obtenue la liste des variantes pour une ressource donne,
    httpd dispose de deux mthodes pour choisir la meilleure variante 
    retourner, s'il y a lieu, soit  partir d'un fichier de
    correspondances de types, soit en se basant sur les noms de fichiers du
    rpertoire. Il n'est pas ncessaire de connatre en dtails comment la
    ngociation fonctionne rellement pour pouvoir utiliser les fonctionnalits
    de ngociation de contenu de httpd. La suite de ce document explique
    cependant les mthodes utilises pour ceux ou celles qui sont
    intresss(es). </p>

    <p>Il existe deux mthodes de ngociation :</p>

    <ol>
      <li><strong>La ngociation effectue par le serveur selon l'algorithme
      de httpd</strong> est normalement utilise. l'algorithme de
      httpd est
      expliqu plus en dtails ci-dessous. Quand cet algorithme est utilis,
      httpd peut parfois "bricoler" le facteur de qualit (qs) d'une dimension
      particulire afin d'obtenir un meilleur rsultat.
      La manire dont httpd peut modifier les facteurs de qualit est
      explique plus en dtails ci-dessous.</li>

      <li><strong>La ngociation de contenu transparente</strong> est utilise
      quand le navigateur le demande explicitement selon le mcanisme dfini
      dans la RFC 2295. Cette mthode de ngociation donne au navigateur le
      contrle total du choix de la meilleure variante; le rsultat dpend
      cependant de la spcificit des algorithmes utiliss par le navigateur.
      Au cours du processus de ngociation transparente, le navigateur peut
      demander  httpd d'excuter l'"algorithme de slection de variante 
      distance" dfini dans la RFC 2296.</li>
    </ol>

<h3><a name="dimensions" id="dimensions">Les dimensions de la ngociation</a></h3>

    <table>
      
      <tr valign="top">
        <th>Dimension</th>

        <th>Notes</th>
      </tr>

      <tr valign="top">
        <td>Type de mdia</td>

        <td>Le navigateur affiche ses prfrences  l'aide du champ d'en-tte
	<code>Accept</code>. Chaque type de mdia peut se voir associ un facteur de
	qualit. La description de la variante peut aussi avoir un facteur de
	qualit (le paramtre "qs").</td>
      </tr>

      <tr valign="top">
        <td>Langage</td>

        <td>Le navigateur affiche ses prfrences  l'aide du champ d'en-tte
        <code>Accept-Language</code>. Chaque langue peut se voir associ un facteur de
	qualit. Les variantes peuvent tre associes avec zro, un ou
	plusieurs langages.</td>
      </tr>

      <tr valign="top">
        <td>Encoding</td>

        <td>Le navigateur affiche ses prfrences  l'aide du champ d'en-tte
        <code>Accept-Encoding</code>. Chaque encodage peut se voir associ un facteur de
	qualit.</td>
      </tr>

      <tr valign="top">
        <td>Charset</td>

        <td>Le navigateur affiche ses prfrences  l'aide du champ d'en-tte
        <code>Accept-Charset</code>. Chaque jeu de caractre peut se voir associ un facteur de
	qualit. Les variantes peuvent prciser un jeu de caractres comme
	paramtre du type de mdia.</td>
      </tr>
    </table>


<h3><a name="algorithm" id="algorithm">L'algorithme de ngociation de
httpd</a></h3>

    <p>httpd peut utiliser l'algorithme suivant pour choisir la "meilleure"
    variante (s'il y en a une)  retourner au navigateur. Cet algorithme n'est pas
    configurable. Il fonctionne comme suit :</p>

    <ol>
      <li>En premier lieu, pour chaque dimension de la ngociation, consulter
      le champ d'en-tte <em>Accept*</em> appropri et assigner une qualit 
      chaque variante. Si l'en-tte <em>Accept*</em> pour toute dimension
      implique que la variante n'est pas acceptable, liminer cette dernire.
      S'il ne reste plus de variante, aller  l'tape 4.</li>

      <li>
        Choisir la "meilleure" variante par limination. Chacun des tests
	suivants est effectu dans cet ordre. Toute variante non slectionne
	 l'issue d'un test est limine. Aprs chaque test, s'il reste une
	seule variante, choisir cette dernire comme celle qui correspond le
	mieux puis aller  l'tape 3. S'il reste plusieurs variantes, passer
	au test suivant.

        <ol>
          <li>Multiplier le facteur de qualit de l'en-tte
	  <code>Accept</code> par le facteur de qualit "qs" pour le type de
	  mdia de ces variantes, et choisir la variante qui possde la valeur
	  la plus importante.</li>

          <li>Slectionner les variantes qui possdent le facteur de qualit
	  de langage le plus haut.</li>

          <li>Slectionner les variantes dont le langage correspond le mieux,
          en se basant sur l'ordre des langages de l'en-tte
          <code>Accept-Language</code> (s'il existe), ou de la directive
	  <code>LanguagePriority</code> (si elle existe).</li>

          <li>Slectionner les variantes possdant le paramtre de mdia
	  "level" le plus lev (utilis pour prciser la version des types de
	  mdia text/html).</li>

          <li>Slectionner les variantes possdant le paramtre de mdia
	  "charset" (jeu de caractres) qui correspond le mieux, en se basant
	  sur la ligne d'en-tte <code>Accept-Charset</code> . Le jeu de
	  caractres ISO-8859-1 est acceptable sauf s'il est explicitement
	  exclus. Les variantes avec un type de mdia <code>text/*</code>
          mais non explicitement associes avec un jeu de caractres
	  particulier sont supposes tre en ISO-8859-1.</li>

          <li>Slectionner les variantes dont le paramtre de mdia "charset"
	  associ n'est <em>pas</em> ISO-8859-1. S'il n'en existe pas,
	  slectionner toutes les variantes.</li>

          <li>Slectionner les variantes avec le meilleur encodage. S'il existe
	  des variantes avec un encodage acceptable pour le client,
	  slectionner celles-ci. Sinon, s'il existe des variantes encodes et
	  des variantes non encodes, ne slectionner que les variantes non
	  encodes. Si toutes les variantes sont encodes ou si aucune
	  ne l'est, slectionner toutes les variantes.</li>

          <li>Slectionner les variantes dont le contenu a la longueur
	  la plus courte.</li>

          <li>Slectionner la premire des variantes restantes. Il s'agira
	  soit de la premire variante liste dans le fichier de
	  correspondances de types, soit, quand les variantes sont lues depuis
	  le rpertoire, la premire par ordre alphabtique quand elles sont
	  tries selon le code ASCII.</li>
        </ol>
      </li>

      <li>L'algorithme a maintenant slectionn une variante considre comme
      la "meilleure", il la retourne donc au client en guise de rponse.
      L'en-tte HTTP <code>Vary</code> de la rponse est renseign de faon 
      indiquer les dimensions de la ngociation (les navigateurs et les caches
      peuvent utiliser cette information lors de la mise en cache de la
      ressource).  Travail termin.</li>

      <li>Le passage par cette tape signifie qu'aucune variante n'a t
      slectionne (parcequ'aucune n'est acceptable pour le navigateur).
      Envoyer une rponse avec un code de statut 406 (qui signifie "Aucune
      reprsentation acceptable") et un corps comportant un document HTML qui
      affiche les variantes disponibles. Renseigner aussi l'en-tte HTTP
      <code>Vary</code> de faon  indiquer les dimensions de la variante.</li>
    </ol>

</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="better" id="better">Ajustement des valeurs de qualit</a></h2>

    <p>Parfois httpd modifie les valeurs de qualit par rapport  celles qui
    dcouleraient d'une stricte interprtation de l'algorithme de ngociation
    de httpd ci-dessus, ceci pour amliorer les rsultats de l'algorithme pour
    les navigateurs qui envoient des informations incompltes ou inappropries.
    Certains des navigateurs les plus populaires envoient des informations dans
    l'en-tte <code>Accept</code> qui, sans ce traitement, provoqueraient la
    slection d'une variante inapproprie dans de nombreux cas. Quand un
    navigateur envoie des informations compltes et correctes ces ajustements
    ne sont pas effectus.</p>

<h3><a name="wildcards" id="wildcards">Types de mdia et caractres gnriques</a></h3>

    <p>L'en-tte de requte <code>Accept:</code> indique les types de mdia
    souhaits. Il peut aussi contenir des types de mdia avec caractres
    gnriques, comme "image/*" ou "*/*" o * correspond  n'importe quelle
    chane de caractres. Ainsi une requte contenant :</p>

<div class="example"><p><code>Accept: image/*, */*</code></p></div>

    <p>indiquerait que tout type de mdia est acceptable, avec une prfrence
    pour les types commenant par "image/".
    Certains navigateurs ajoutent par dfaut des types de mdia avec caractres
    gnriques aux types explicitement nomms qu'ils peuvent grer.
    Par exemple :</p>

<div class="example"><p><code>
  Accept: text/html, text/plain, image/gif, image/jpeg, */*
</code></p></div>
    <p>Ceci indique que les types explicitement lists sont prfrs, mais
    qu'une reprsentation avec un type diffrent de ces derniers conviendra
    aussi.  Les valeurs de qualits explicites,
    afin de prciser ce que veut vraiment le navigateur, s'utilisent
    comme suit :</p>
<div class="example"><p><code>
  Accept: text/html, text/plain, image/gif, image/jpeg, */*; q=0.01
</code></p></div>
    <p>Les types explicites n'ont pas de facteur de qualit, la valeur par
    dfaut de leur prfrence est donc de 1.0 (la plus haute). Le type avec
    caractres gnriques */* se voit attribuer une prfrence basse de 0.01,
    si bien que les types autres que ceux explicitement lists ne seront retourns
    que s'il n'existe pas de variante correspondant  un type explicitement
    list.</p>

    <p>Si l'en-tte <code>Accept:</code> ne contient <em>pas</em> aucun
    facteur de qualit, httpd positionne la valeur de qualit de
    "*/*", si present,  0.01 pour simuler l'effet dsir. Il positionne aussi
    la valeur de qualit des types avec caractres gnriques au format
    "type/*"  0.02 (ils sont donc prfrs  ceux correspondant  "*/*"). Si
    un type de mdia dans l'en-tte <code>Accept:</code> contient un facteur de
    qualit, ces valeurs spciales ne seront <em>pas</em> appliques, de faon
     ce que les requtes de navigateurs qui envoient les informations
    explicites  prendre en compte fonctionnent comme souhait.</p>


<h3><a name="exceptions" id="exceptions">Exceptions dans la ngociation du
langage</a></h3>

    <p>A partir de la version 2.0 de httpd, certaines exceptions ont t
    ajoutes  l'algorithme de ngociation afin de mnager une issue de secours
    quand la ngociation ne trouve aucun langage correspondant.</p>

    <p>Quand un client demande une page sur votre serveur, si ce dernier ne
    parvient pas  trouver une page dont la langue corresponde  l'en-tte
    <code>Accept-language</code> envoy par le navigateur, il enverra au client
    une rponse "Aucune variante acceptable" ou "Plusieurs choix possibles".
    Pour viter ces
    messages d'erreur, il est possible de configurer httpd de faon  ce que,
    dans ces cas, il ignore l'en-tte <code>Accept-language</code> et fournisse
    tout de mme un document, mme s'il ne correspond pas exactement  la
    demande explicite du client. La directive <code class="directive"><a href="./mod/mod_negotiation.html#forcelanguagepriority">ForceLanguagePriority</a></code>
    peut tre utilise pour viter ces messages d'erreur et leur substituer une
    page dont le langage sera dtermin en fonction du contenu de la directive
    <code class="directive"><a href="./mod/mod_negotiation.html#languagepriority">LanguagePriority</a></code>.</p>

    <p>Le serveur va aussi essayer d'tendre sa recherche de correspondance aux
    sous-ensembles de langages quand aucune correspondance exacte ne peut tre
    trouve. Par exemple, si un client demande des documents possdant le
    langage <code>en-GB</code>, c'est  dire anglais britannique, le standard
    HTTP/1.1 n'autorise normalement pas le serveur  faire correspondre cette
    demande  un document dont le langage est simplement <code>en</code>.
    (Notez qu'inclure <code>en-GB</code> et non <code>en</code> dans l'en-tte
    <code>Accept-Language</code> constitue une quasi-erreur de configuration,
    car il est trs peu probable qu'un lecteur qui comprend l'anglais
    britannique, ne comprenne pas l'anglais en gnral. Malheureusement, de
    nombreux clients ont rellement des configurations par dfaut de ce type.)
    Cependant, si aucune autre correspondance de langage n'est possible, et que le
    serveur est sur le point de retourner une erreur "Aucune variable
    acceptable" ou de choisir le langage dfini par la directive <code class="directive"><a href="./mod/mod_negotiation.html#languagepriority">LanguagePriority</a></code>, le serveur ignorera
    la spcification du sous-ensemble de langage et associera la demande en
    <code>en-GB</code>  des documents en <code>en</code>.  Implicitement,
    httpd ajoute le langage parent  la liste de langues accepts par le
    client avec une valeur de qualit trs basse. Notez cependant que si le
    client demande "en-GB; q=0.9, fr; q=0.8", et le serveur dispose de
    documents estampills "en" et "fr", alors c'est le document "fr" qui sera
    retourn, tout ceci dans un souci de compatibilit avec la spcification
    HTTP/1.1 et afin de fonctionner efficacement avec les clients
    correctement configurs.</p>

    <p>Pour supporter les techniques avances (comme les cookies ou les chemins
    d'URL spciaux) afin de dterminer le langage prfr de l'utilisateur, le
    module <code class="module"><a href="./mod/mod_negotiation.html">mod_negotiation</a></code> reconnat la
    <a href="env.html">variable d'environnement</a>
    <code>prefer-language</code>
    depuis la version 2.0.47 de httpd. Si elle est dfinie et contient un
    symbole de langage appropri, <code class="module"><a href="./mod/mod_negotiation.html">mod_negotiation</a></code> va essayer
    de slectionner une variante correspondante. S'il n'existe pas de telle
    variante, le processus normal de ngociation sera lanc.</p>

    <div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">SetEnvIf Cookie "language=(.+)" prefer-language=$1
Header append Vary cookie</pre>
</div>

</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="extensions" id="extensions">Extensions  la ngociation de contenu
transparente</a></h2>

<p>httpd tend le protocole de ngociation de contenu transparente (RFC
2295) comme suit. Un nouvel lment <code>{encodage ..}</code> est utilis dans
les listes de variantes pour marquer celles qui ne sont disponibles qu'avec un
encodage de contenu spcifique. L'implmentation de l'algorithme
RVSA/1.0 (RFC 2296) est tendue  la reconnaissance de variantes encodes dans
la liste, et  leur utilisation en tant que variantes candidates  partir du
moment o leur encodage satisfait au contenu de l'en-tte de requte
<code>Accept-Encoding</code>. L'implmentation RVSA/1.0 n'arrondit pas les
facteurs de qualit calculs  5 dcimales avant d'avoir choisi la meilleure
variante.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="naming" id="naming">Remarques  propos des liens hypertextes et des
conventions de nommage</a></h2>

    <p>Si vous utilisez la ngociation de langage, vous avez le choix entre
    diffrentes conventions de nommage, car les fichiers peuvent possder
    plusieurs extensions, et l'ordre dans lequel ces dernires apparaissent
    est en gnral sans rapport (voir la documentation sur le module <a href="mod/mod_mime.html#multipleext">mod_mime</a>
    pour plus de dtails).</p>

    <p>Un fichier type possde une extension lie au type MIME
    (<em>par exemple</em>, <code>html</code>), mais parfois aussi une
    extension lie  l'encodage (<em>par exemple</em>, <code>gz</code>),
    et bien sr une extension lie au langage
    (<em>par exemple</em>, <code>en</code>) quand plusieurs variantes de
    langage sont disponibles pour ce fichier.</p>

    <p>Exemples :</p>

    <ul>
      <li>foo.en.html</li>

      <li>foo.html.en</li>

      <li>foo.en.html.gz</li>
    </ul>

    <p>Ci-dessous d'autres exemples de noms de fichiers avec des liens
    hypertextes valides et invalides :</p>

    <table class="bordered">
      
      <tr>
        <th>Nom fichier</th>

        <th>lien valide</th>

        <th>Lien invalide</th>
      </tr>

      <tr>
        <td><em>foo.html.en</em></td>

        <td>foo<br />
         foo.html</td>

        <td>-</td>
      </tr>

      <tr>
        <td><em>foo.en.html</em></td>

        <td>foo</td>

        <td>foo.html</td>
      </tr>

      <tr>
        <td><em>foo.html.en.gz</em></td>

        <td>foo<br />
         foo.html</td>

        <td>foo.gz<br />
         foo.html.gz</td>
      </tr>

      <tr>
        <td><em>foo.en.html.gz</em></td>

        <td>foo</td>

        <td>foo.html<br />
         foo.html.gz<br />
         foo.gz</td>
      </tr>

      <tr>
        <td><em>foo.gz.html.en</em></td>

        <td>foo<br />
         foo.gz<br />
         foo.gz.html</td>

        <td>foo.html</td>
      </tr>

      <tr>
        <td><em>foo.html.gz.en</em></td>

        <td>foo<br />
         foo.html<br />
         foo.html.gz</td>

        <td>foo.gz</td>
      </tr>
    </table>

    <p>En regardant la table ci-dessus, vous remarquerez qu'il est toujours
    possible d'utiliser le nom de fichier sans extension dans un lien
    (<em>par exemple</em>, <code>foo</code>). L'avantage est de pouvoir
    dissimuler le type rel du fichier associ  un document et de pouvoir
    le modifier
    ultrieurement, <em>par exemple</em>, de <code>html</code> 
    <code>shtml</code> ou <code>cgi</code> sans avoir 
    mettre  jour aucun lien.</p>

    <p>Si vous souhaitez continuer  utiliser un type MIME dans vos liens
    (<em>par exemple </em> <code>foo.html</code>), l'extension lie au langage
    (y compris une extension lie  l'encodage s'il en existe une)
    doit se trouver  droite de l'extension lie au type MIME
    (<em>par exemple</em>, <code>foo.html.en</code>).</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="caching" id="caching">Remarque sur la mise en cache</a></h2>

    <p>Quand un cache stocke une reprsentation, il l'associe avec l'URL de la
    requte. Lorsque cette URL est  nouveau demande, le cache peut utiliser
    la reprsentation stocke. Cependant, si la ressource est ngociable au
    niveau du serveur, il se peut que seule la premire variante demande soit
    mise en cache et de ce fait, la correspondance positive du cache peut
    entraner une rponse inapproprie. Pour
    viter ceci, httpd marque par
    dfaut toutes les rponses qui sont retournes aprs une ngociation de
    contenu comme "non-cachables" par les clients HTTP/1.0. httpd supporte
    aussi les fonctionnalits du protocole HTTP/1.1 afin de permettre la mise
    en cache des rponses ngocies.</p>

    <p>Pour les requtes en provenance d'un client compatible HTTP/1.0
    (un navigateur ou un cache), la directive <code class="directive"><a href="./mod/mod_negotiation.html#cachenegotiateddocs">CacheNegotiatedDocs</a></code> peut tre utilise
    pour permettre la mise en cache des rponses qui ont fait l'objet d'une
    ngociation. Cette directive peut intervenir dans la configuration au
    niveau du serveur ou de l'hte virtuel, et n'accepte aucun argument. Elle
    n'a aucun effet sur les requtes en provenance de clients HTTP/1.1.</p>

    <p>Pour les clients HTTP/1.1, httpd envoie un en-tte de rponse HTTP
    <code>Vary</code> afin d'indiquer les dimensions de la ngociation pour
    cette rponse. Les caches peuvent
    utiliser cette information afin de dterminer
    si une requte peut tre servie  partir de la copie locale. Pour inciter
    un cache  utiliser la copie locale sans tenir compte des dimensions de la
    ngociation, dfinissez la
    <a href="env.html#special">variable d'environnement</a>
    <code>force-no-vary</code>.</p>

</div></div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="./en/content-negotiation.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="./fr/content-negotiation.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="./ja/content-negotiation.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="./ko/content-negotiation.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a> |
<a href="./tr/content-negotiation.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="./images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/content-negotiation.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2017 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="./mod/">Modules</a> | <a href="./mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="./glossary.html">Glossaire</a> | <a href="./sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>