/*
 *  Trivial factorization test
 */

/*===
0 --> 0 (prime)
1 --> 1 (prime)
2 --> 2 (prime)
3 --> 3 (prime)
4 --> 2x2
5 --> 5 (prime)
6 --> 2x3
7 --> 7 (prime)
8 --> 2x2x2
9 --> 3x3
10 --> 2x5
11 --> 11 (prime)
12 --> 2x2x3
13 --> 13 (prime)
14 --> 2x7
15 --> 3x5
16 --> 2x2x2x2
17 --> 17 (prime)
18 --> 2x3x3
19 --> 19 (prime)
20 --> 2x2x5
21 --> 3x7
22 --> 2x11
23 --> 23 (prime)
24 --> 2x2x2x3
25 --> 5x5
26 --> 2x13
27 --> 3x3x3
28 --> 2x2x7
29 --> 29 (prime)
30 --> 2x3x5
31 --> 31 (prime)
32 --> 2x2x2x2x2
33 --> 3x11
34 --> 2x17
35 --> 5x7
36 --> 2x2x3x3
37 --> 37 (prime)
38 --> 2x19
39 --> 3x13
40 --> 2x2x2x5
41 --> 41 (prime)
42 --> 2x3x7
43 --> 43 (prime)
44 --> 2x2x11
45 --> 3x3x5
46 --> 2x23
47 --> 47 (prime)
48 --> 2x2x2x2x3
49 --> 7x7
50 --> 2x5x5
51 --> 3x17
52 --> 2x2x13
53 --> 53 (prime)
54 --> 2x3x3x3
55 --> 5x11
56 --> 2x2x2x7
57 --> 3x19
58 --> 2x29
59 --> 59 (prime)
60 --> 2x2x3x5
61 --> 61 (prime)
62 --> 2x31
63 --> 3x3x7
64 --> 2x2x2x2x2x2
65 --> 5x13
66 --> 2x3x11
67 --> 67 (prime)
68 --> 2x2x17
69 --> 3x23
70 --> 2x5x7
71 --> 71 (prime)
72 --> 2x2x2x3x3
73 --> 73 (prime)
74 --> 2x37
75 --> 3x5x5
76 --> 2x2x19
77 --> 7x11
78 --> 2x3x13
79 --> 79 (prime)
80 --> 2x2x2x2x5
81 --> 3x3x3x3
82 --> 2x41
83 --> 83 (prime)
84 --> 2x2x3x7
85 --> 5x17
86 --> 2x43
87 --> 3x29
88 --> 2x2x2x11
89 --> 89 (prime)
90 --> 2x3x3x5
91 --> 7x13
92 --> 2x2x23
93 --> 3x31
94 --> 2x47
95 --> 5x19
96 --> 2x2x2x2x2x3
97 --> 97 (prime)
98 --> 2x7x7
99 --> 3x3x11
100 --> 2x2x5x5
101 --> 101 (prime)
102 --> 2x3x17
103 --> 103 (prime)
104 --> 2x2x2x13
105 --> 3x5x7
106 --> 2x53
107 --> 107 (prime)
108 --> 2x2x3x3x3
109 --> 109 (prime)
110 --> 2x5x11
111 --> 3x37
112 --> 2x2x2x2x7
113 --> 113 (prime)
114 --> 2x3x19
115 --> 5x23
116 --> 2x2x29
117 --> 3x3x13
118 --> 2x59
119 --> 7x17
120 --> 2x2x2x3x5
121 --> 11x11
122 --> 2x61
123 --> 3x41
124 --> 2x2x31
125 --> 5x5x5
126 --> 2x3x3x7
127 --> 127 (prime)
128 --> 2x2x2x2x2x2x2
129 --> 3x43
130 --> 2x5x13
131 --> 131 (prime)
132 --> 2x2x3x11
133 --> 7x19
134 --> 2x67
135 --> 3x3x3x5
136 --> 2x2x2x17
137 --> 137 (prime)
138 --> 2x3x23
139 --> 139 (prime)
140 --> 2x2x5x7
141 --> 3x47
142 --> 2x71
143 --> 11x13
144 --> 2x2x2x2x3x3
145 --> 5x29
146 --> 2x73
147 --> 3x7x7
148 --> 2x2x37
149 --> 149 (prime)
150 --> 2x3x5x5
151 --> 151 (prime)
152 --> 2x2x2x19
153 --> 3x3x17
154 --> 2x7x11
155 --> 5x31
156 --> 2x2x3x13
157 --> 157 (prime)
158 --> 2x79
159 --> 3x53
160 --> 2x2x2x2x2x5
161 --> 7x23
162 --> 2x3x3x3x3
163 --> 163 (prime)
164 --> 2x2x41
165 --> 3x5x11
166 --> 2x83
167 --> 167 (prime)
168 --> 2x2x2x3x7
169 --> 13x13
170 --> 2x5x17
171 --> 3x3x19
172 --> 2x2x43
173 --> 173 (prime)
174 --> 2x3x29
175 --> 5x5x7
176 --> 2x2x2x2x11
177 --> 3x59
178 --> 2x89
179 --> 179 (prime)
180 --> 2x2x3x3x5
181 --> 181 (prime)
182 --> 2x7x13
183 --> 3x61
184 --> 2x2x2x23
185 --> 5x37
186 --> 2x3x31
187 --> 11x17
188 --> 2x2x47
189 --> 3x3x3x7
190 --> 2x5x19
191 --> 191 (prime)
192 --> 2x2x2x2x2x2x3
193 --> 193 (prime)
194 --> 2x97
195 --> 3x5x13
196 --> 2x2x7x7
197 --> 197 (prime)
198 --> 2x3x3x11
199 --> 199 (prime)
200 --> 2x2x2x5x5
201 --> 3x67
202 --> 2x101
203 --> 7x29
204 --> 2x2x3x17
205 --> 5x41
206 --> 2x103
207 --> 3x3x23
208 --> 2x2x2x2x13
209 --> 11x19
210 --> 2x3x5x7
211 --> 211 (prime)
212 --> 2x2x53
213 --> 3x71
214 --> 2x107
215 --> 5x43
216 --> 2x2x2x3x3x3
217 --> 7x31
218 --> 2x109
219 --> 3x73
220 --> 2x2x5x11
221 --> 13x17
222 --> 2x3x37
223 --> 223 (prime)
224 --> 2x2x2x2x2x7
225 --> 3x3x5x5
226 --> 2x113
227 --> 227 (prime)
228 --> 2x2x3x19
229 --> 229 (prime)
230 --> 2x5x23
231 --> 3x7x11
232 --> 2x2x2x29
233 --> 233 (prime)
234 --> 2x3x3x13
235 --> 5x47
236 --> 2x2x59
237 --> 3x79
238 --> 2x7x17
239 --> 239 (prime)
240 --> 2x2x2x2x3x5
241 --> 241 (prime)
242 --> 2x11x11
243 --> 3x3x3x3x3
244 --> 2x2x61
245 --> 5x7x7
246 --> 2x3x41
247 --> 13x19
248 --> 2x2x2x31
249 --> 3x83
250 --> 2x5x5x5
251 --> 251 (prime)
252 --> 2x2x3x3x7
253 --> 11x23
254 --> 2x127
255 --> 3x5x17
256 --> 2x2x2x2x2x2x2x2
257 --> 257 (prime)
258 --> 2x3x43
259 --> 7x37
260 --> 2x2x5x13
261 --> 3x3x29
262 --> 2x131
263 --> 263 (prime)
264 --> 2x2x2x3x11
265 --> 5x53
266 --> 2x7x19
267 --> 3x89
268 --> 2x2x67
269 --> 269 (prime)
270 --> 2x3x3x3x5
271 --> 271 (prime)
272 --> 2x2x2x2x17
273 --> 3x7x13
274 --> 2x137
275 --> 5x5x11
276 --> 2x2x3x23
277 --> 277 (prime)
278 --> 2x139
279 --> 3x3x31
280 --> 2x2x2x5x7
281 --> 281 (prime)
282 --> 2x3x47
283 --> 283 (prime)
284 --> 2x2x71
285 --> 3x5x19
286 --> 2x11x13
287 --> 7x41
288 --> 2x2x2x2x2x3x3
289 --> 17x17
290 --> 2x5x29
291 --> 3x97
292 --> 2x2x73
293 --> 293 (prime)
294 --> 2x3x7x7
295 --> 5x59
296 --> 2x2x2x37
297 --> 3x3x3x11
298 --> 2x149
299 --> 13x23
300 --> 2x2x3x5x5
301 --> 7x43
302 --> 2x151
303 --> 3x101
304 --> 2x2x2x2x19
305 --> 5x61
306 --> 2x3x3x17
307 --> 307 (prime)
308 --> 2x2x7x11
309 --> 3x103
310 --> 2x5x31
311 --> 311 (prime)
312 --> 2x2x2x3x13
313 --> 313 (prime)
314 --> 2x157
315 --> 3x3x5x7
316 --> 2x2x79
317 --> 317 (prime)
318 --> 2x3x53
319 --> 11x29
320 --> 2x2x2x2x2x2x5
321 --> 3x107
322 --> 2x7x23
323 --> 17x19
324 --> 2x2x3x3x3x3
325 --> 5x5x13
326 --> 2x163
327 --> 3x109
328 --> 2x2x2x41
329 --> 7x47
330 --> 2x3x5x11
331 --> 331 (prime)
332 --> 2x2x83
333 --> 3x3x37
334 --> 2x167
335 --> 5x67
336 --> 2x2x2x2x3x7
337 --> 337 (prime)
338 --> 2x13x13
339 --> 3x113
340 --> 2x2x5x17
341 --> 11x31
342 --> 2x3x3x19
343 --> 7x7x7
344 --> 2x2x2x43
345 --> 3x5x23
346 --> 2x173
347 --> 347 (prime)
348 --> 2x2x3x29
349 --> 349 (prime)
350 --> 2x5x5x7
351 --> 3x3x3x13
352 --> 2x2x2x2x2x11
353 --> 353 (prime)
354 --> 2x3x59
355 --> 5x71
356 --> 2x2x89
357 --> 3x7x17
358 --> 2x179
359 --> 359 (prime)
360 --> 2x2x2x3x3x5
361 --> 19x19
362 --> 2x181
363 --> 3x11x11
364 --> 2x2x7x13
365 --> 5x73
366 --> 2x3x61
367 --> 367 (prime)
368 --> 2x2x2x2x23
369 --> 3x3x41
370 --> 2x5x37
371 --> 7x53
372 --> 2x2x3x31
373 --> 373 (prime)
374 --> 2x11x17
375 --> 3x5x5x5
376 --> 2x2x2x47
377 --> 13x29
378 --> 2x3x3x3x7
379 --> 379 (prime)
380 --> 2x2x5x19
381 --> 3x127
382 --> 2x191
383 --> 383 (prime)
384 --> 2x2x2x2x2x2x2x3
385 --> 5x7x11
386 --> 2x193
387 --> 3x3x43
388 --> 2x2x97
389 --> 389 (prime)
390 --> 2x3x5x13
391 --> 17x23
392 --> 2x2x2x7x7
393 --> 3x131
394 --> 2x197
395 --> 5x79
396 --> 2x2x3x3x11
397 --> 397 (prime)
398 --> 2x199
399 --> 3x7x19
400 --> 2x2x2x2x5x5
401 --> 401 (prime)
402 --> 2x3x67
403 --> 13x31
404 --> 2x2x101
405 --> 3x3x3x3x5
406 --> 2x7x29
407 --> 11x37
408 --> 2x2x2x3x17
409 --> 409 (prime)
410 --> 2x5x41
411 --> 3x137
412 --> 2x2x103
413 --> 7x59
414 --> 2x3x3x23
415 --> 5x83
416 --> 2x2x2x2x2x13
417 --> 3x139
418 --> 2x11x19
419 --> 419 (prime)
420 --> 2x2x3x5x7
421 --> 421 (prime)
422 --> 2x211
423 --> 3x3x47
424 --> 2x2x2x53
425 --> 5x5x17
426 --> 2x3x71
427 --> 7x61
428 --> 2x2x107
429 --> 3x11x13
430 --> 2x5x43
431 --> 431 (prime)
432 --> 2x2x2x2x3x3x3
433 --> 433 (prime)
434 --> 2x7x31
435 --> 3x5x29
436 --> 2x2x109
437 --> 19x23
438 --> 2x3x73
439 --> 439 (prime)
440 --> 2x2x2x5x11
441 --> 3x3x7x7
442 --> 2x13x17
443 --> 443 (prime)
444 --> 2x2x3x37
445 --> 5x89
446 --> 2x223
447 --> 3x149
448 --> 2x2x2x2x2x2x7
449 --> 449 (prime)
450 --> 2x3x3x5x5
451 --> 11x41
452 --> 2x2x113
453 --> 3x151
454 --> 2x227
455 --> 5x7x13
456 --> 2x2x2x3x19
457 --> 457 (prime)
458 --> 2x229
459 --> 3x3x3x17
460 --> 2x2x5x23
461 --> 461 (prime)
462 --> 2x3x7x11
463 --> 463 (prime)
464 --> 2x2x2x2x29
465 --> 3x5x31
466 --> 2x233
467 --> 467 (prime)
468 --> 2x2x3x3x13
469 --> 7x67
470 --> 2x5x47
471 --> 3x157
472 --> 2x2x2x59
473 --> 11x43
474 --> 2x3x79
475 --> 5x5x19
476 --> 2x2x7x17
477 --> 3x3x53
478 --> 2x239
479 --> 479 (prime)
480 --> 2x2x2x2x2x3x5
481 --> 13x37
482 --> 2x241
483 --> 3x7x23
484 --> 2x2x11x11
485 --> 5x97
486 --> 2x3x3x3x3x3
487 --> 487 (prime)
488 --> 2x2x2x61
489 --> 3x163
490 --> 2x5x7x7
491 --> 491 (prime)
492 --> 2x2x3x41
493 --> 17x29
494 --> 2x13x19
495 --> 3x3x5x11
496 --> 2x2x2x2x31
497 --> 7x71
498 --> 2x3x83
499 --> 499 (prime)
500 --> 2x2x5x5x5
501 --> 3x167
502 --> 2x251
503 --> 503 (prime)
504 --> 2x2x2x3x3x7
505 --> 5x101
506 --> 2x11x23
507 --> 3x13x13
508 --> 2x2x127
509 --> 509 (prime)
510 --> 2x3x5x17
511 --> 7x73
512 --> 2x2x2x2x2x2x2x2x2
513 --> 3x3x3x19
514 --> 2x257
515 --> 5x103
516 --> 2x2x3x43
517 --> 11x47
518 --> 2x7x37
519 --> 3x173
520 --> 2x2x2x5x13
521 --> 521 (prime)
522 --> 2x3x3x29
523 --> 523 (prime)
524 --> 2x2x131
525 --> 3x5x5x7
526 --> 2x263
527 --> 17x31
528 --> 2x2x2x2x3x11
529 --> 23x23
530 --> 2x5x53
531 --> 3x3x59
532 --> 2x2x7x19
533 --> 13x41
534 --> 2x3x89
535 --> 5x107
536 --> 2x2x2x67
537 --> 3x179
538 --> 2x269
539 --> 7x7x11
540 --> 2x2x3x3x3x5
541 --> 541 (prime)
542 --> 2x271
543 --> 3x181
544 --> 2x2x2x2x2x17
545 --> 5x109
546 --> 2x3x7x13
547 --> 547 (prime)
548 --> 2x2x137
549 --> 3x3x61
550 --> 2x5x5x11
551 --> 19x29
552 --> 2x2x2x3x23
553 --> 7x79
554 --> 2x277
555 --> 3x5x37
556 --> 2x2x139
557 --> 557 (prime)
558 --> 2x3x3x31
559 --> 13x43
560 --> 2x2x2x2x5x7
561 --> 3x11x17
562 --> 2x281
563 --> 563 (prime)
564 --> 2x2x3x47
565 --> 5x113
566 --> 2x283
567 --> 3x3x3x3x7
568 --> 2x2x2x71
569 --> 569 (prime)
570 --> 2x3x5x19
571 --> 571 (prime)
572 --> 2x2x11x13
573 --> 3x191
574 --> 2x7x41
575 --> 5x5x23
576 --> 2x2x2x2x2x2x3x3
577 --> 577 (prime)
578 --> 2x17x17
579 --> 3x193
580 --> 2x2x5x29
581 --> 7x83
582 --> 2x3x97
583 --> 11x53
584 --> 2x2x2x73
585 --> 3x3x5x13
586 --> 2x293
587 --> 587 (prime)
588 --> 2x2x3x7x7
589 --> 19x31
590 --> 2x5x59
591 --> 3x197
592 --> 2x2x2x2x37
593 --> 593 (prime)
594 --> 2x3x3x3x11
595 --> 5x7x17
596 --> 2x2x149
597 --> 3x199
598 --> 2x13x23
599 --> 599 (prime)
600 --> 2x2x2x3x5x5
601 --> 601 (prime)
602 --> 2x7x43
603 --> 3x3x67
604 --> 2x2x151
605 --> 5x11x11
606 --> 2x3x101
607 --> 607 (prime)
608 --> 2x2x2x2x2x19
609 --> 3x7x29
610 --> 2x5x61
611 --> 13x47
612 --> 2x2x3x3x17
613 --> 613 (prime)
614 --> 2x307
615 --> 3x5x41
616 --> 2x2x2x7x11
617 --> 617 (prime)
618 --> 2x3x103
619 --> 619 (prime)
620 --> 2x2x5x31
621 --> 3x3x3x23
622 --> 2x311
623 --> 7x89
624 --> 2x2x2x2x3x13
625 --> 5x5x5x5
626 --> 2x313
627 --> 3x11x19
628 --> 2x2x157
629 --> 17x37
630 --> 2x3x3x5x7
631 --> 631 (prime)
632 --> 2x2x2x79
633 --> 3x211
634 --> 2x317
635 --> 5x127
636 --> 2x2x3x53
637 --> 7x7x13
638 --> 2x11x29
639 --> 3x3x71
640 --> 2x2x2x2x2x2x2x5
641 --> 641 (prime)
642 --> 2x3x107
643 --> 643 (prime)
644 --> 2x2x7x23
645 --> 3x5x43
646 --> 2x17x19
647 --> 647 (prime)
648 --> 2x2x2x3x3x3x3
649 --> 11x59
650 --> 2x5x5x13
651 --> 3x7x31
652 --> 2x2x163
653 --> 653 (prime)
654 --> 2x3x109
655 --> 5x131
656 --> 2x2x2x2x41
657 --> 3x3x73
658 --> 2x7x47
659 --> 659 (prime)
660 --> 2x2x3x5x11
661 --> 661 (prime)
662 --> 2x331
663 --> 3x13x17
664 --> 2x2x2x83
665 --> 5x7x19
666 --> 2x3x3x37
667 --> 23x29
668 --> 2x2x167
669 --> 3x223
670 --> 2x5x67
671 --> 11x61
672 --> 2x2x2x2x2x3x7
673 --> 673 (prime)
674 --> 2x337
675 --> 3x3x3x5x5
676 --> 2x2x13x13
677 --> 677 (prime)
678 --> 2x3x113
679 --> 7x97
680 --> 2x2x2x5x17
681 --> 3x227
682 --> 2x11x31
683 --> 683 (prime)
684 --> 2x2x3x3x19
685 --> 5x137
686 --> 2x7x7x7
687 --> 3x229
688 --> 2x2x2x2x43
689 --> 13x53
690 --> 2x3x5x23
691 --> 691 (prime)
692 --> 2x2x173
693 --> 3x3x7x11
694 --> 2x347
695 --> 5x139
696 --> 2x2x2x3x29
697 --> 17x41
698 --> 2x349
699 --> 3x233
700 --> 2x2x5x5x7
701 --> 701 (prime)
702 --> 2x3x3x3x13
703 --> 19x37
704 --> 2x2x2x2x2x2x11
705 --> 3x5x47
706 --> 2x353
707 --> 7x101
708 --> 2x2x3x59
709 --> 709 (prime)
710 --> 2x5x71
711 --> 3x3x79
712 --> 2x2x2x89
713 --> 23x31
714 --> 2x3x7x17
715 --> 5x11x13
716 --> 2x2x179
717 --> 3x239
718 --> 2x359
719 --> 719 (prime)
720 --> 2x2x2x2x3x3x5
721 --> 7x103
722 --> 2x19x19
723 --> 3x241
724 --> 2x2x181
725 --> 5x5x29
726 --> 2x3x11x11
727 --> 727 (prime)
728 --> 2x2x2x7x13
729 --> 3x3x3x3x3x3
730 --> 2x5x73
731 --> 17x43
732 --> 2x2x3x61
733 --> 733 (prime)
734 --> 2x367
735 --> 3x5x7x7
736 --> 2x2x2x2x2x23
737 --> 11x67
738 --> 2x3x3x41
739 --> 739 (prime)
740 --> 2x2x5x37
741 --> 3x13x19
742 --> 2x7x53
743 --> 743 (prime)
744 --> 2x2x2x3x31
745 --> 5x149
746 --> 2x373
747 --> 3x3x83
748 --> 2x2x11x17
749 --> 7x107
750 --> 2x3x5x5x5
751 --> 751 (prime)
752 --> 2x2x2x2x47
753 --> 3x251
754 --> 2x13x29
755 --> 5x151
756 --> 2x2x3x3x3x7
757 --> 757 (prime)
758 --> 2x379
759 --> 3x11x23
760 --> 2x2x2x5x19
761 --> 761 (prime)
762 --> 2x3x127
763 --> 7x109
764 --> 2x2x191
765 --> 3x3x5x17
766 --> 2x383
767 --> 13x59
768 --> 2x2x2x2x2x2x2x2x3
769 --> 769 (prime)
770 --> 2x5x7x11
771 --> 3x257
772 --> 2x2x193
773 --> 773 (prime)
774 --> 2x3x3x43
775 --> 5x5x31
776 --> 2x2x2x97
777 --> 3x7x37
778 --> 2x389
779 --> 19x41
780 --> 2x2x3x5x13
781 --> 11x71
782 --> 2x17x23
783 --> 3x3x3x29
784 --> 2x2x2x2x7x7
785 --> 5x157
786 --> 2x3x131
787 --> 787 (prime)
788 --> 2x2x197
789 --> 3x263
790 --> 2x5x79
791 --> 7x113
792 --> 2x2x2x3x3x11
793 --> 13x61
794 --> 2x397
795 --> 3x5x53
796 --> 2x2x199
797 --> 797 (prime)
798 --> 2x3x7x19
799 --> 17x47
800 --> 2x2x2x2x2x5x5
801 --> 3x3x89
802 --> 2x401
803 --> 11x73
804 --> 2x2x3x67
805 --> 5x7x23
806 --> 2x13x31
807 --> 3x269
808 --> 2x2x2x101
809 --> 809 (prime)
810 --> 2x3x3x3x3x5
811 --> 811 (prime)
812 --> 2x2x7x29
813 --> 3x271
814 --> 2x11x37
815 --> 5x163
816 --> 2x2x2x2x3x17
817 --> 19x43
818 --> 2x409
819 --> 3x3x7x13
820 --> 2x2x5x41
821 --> 821 (prime)
822 --> 2x3x137
823 --> 823 (prime)
824 --> 2x2x2x103
825 --> 3x5x5x11
826 --> 2x7x59
827 --> 827 (prime)
828 --> 2x2x3x3x23
829 --> 829 (prime)
830 --> 2x5x83
831 --> 3x277
832 --> 2x2x2x2x2x2x13
833 --> 7x7x17
834 --> 2x3x139
835 --> 5x167
836 --> 2x2x11x19
837 --> 3x3x3x31
838 --> 2x419
839 --> 839 (prime)
840 --> 2x2x2x3x5x7
841 --> 29x29
842 --> 2x421
843 --> 3x281
844 --> 2x2x211
845 --> 5x13x13
846 --> 2x3x3x47
847 --> 7x11x11
848 --> 2x2x2x2x53
849 --> 3x283
850 --> 2x5x5x17
851 --> 23x37
852 --> 2x2x3x71
853 --> 853 (prime)
854 --> 2x7x61
855 --> 3x3x5x19
856 --> 2x2x2x107
857 --> 857 (prime)
858 --> 2x3x11x13
859 --> 859 (prime)
860 --> 2x2x5x43
861 --> 3x7x41
862 --> 2x431
863 --> 863 (prime)
864 --> 2x2x2x2x2x3x3x3
865 --> 5x173
866 --> 2x433
867 --> 3x17x17
868 --> 2x2x7x31
869 --> 11x79
870 --> 2x3x5x29
871 --> 13x67
872 --> 2x2x2x109
873 --> 3x3x97
874 --> 2x19x23
875 --> 5x5x5x7
876 --> 2x2x3x73
877 --> 877 (prime)
878 --> 2x439
879 --> 3x293
880 --> 2x2x2x2x5x11
881 --> 881 (prime)
882 --> 2x3x3x7x7
883 --> 883 (prime)
884 --> 2x2x13x17
885 --> 3x5x59
886 --> 2x443
887 --> 887 (prime)
888 --> 2x2x2x3x37
889 --> 7x127
890 --> 2x5x89
891 --> 3x3x3x3x11
892 --> 2x2x223
893 --> 19x47
894 --> 2x3x149
895 --> 5x179
896 --> 2x2x2x2x2x2x2x7
897 --> 3x13x23
898 --> 2x449
899 --> 29x31
900 --> 2x2x3x3x5x5
901 --> 17x53
902 --> 2x11x41
903 --> 3x7x43
904 --> 2x2x2x113
905 --> 5x181
906 --> 2x3x151
907 --> 907 (prime)
908 --> 2x2x227
909 --> 3x3x101
910 --> 2x5x7x13
911 --> 911 (prime)
912 --> 2x2x2x2x3x19
913 --> 11x83
914 --> 2x457
915 --> 3x5x61
916 --> 2x2x229
917 --> 7x131
918 --> 2x3x3x3x17
919 --> 919 (prime)
920 --> 2x2x2x5x23
921 --> 3x307
922 --> 2x461
923 --> 13x71
924 --> 2x2x3x7x11
925 --> 5x5x37
926 --> 2x463
927 --> 3x3x103
928 --> 2x2x2x2x2x29
929 --> 929 (prime)
930 --> 2x3x5x31
931 --> 7x7x19
932 --> 2x2x233
933 --> 3x311
934 --> 2x467
935 --> 5x11x17
936 --> 2x2x2x3x3x13
937 --> 937 (prime)
938 --> 2x7x67
939 --> 3x313
940 --> 2x2x5x47
941 --> 941 (prime)
942 --> 2x3x157
943 --> 23x41
944 --> 2x2x2x2x59
945 --> 3x3x3x5x7
946 --> 2x11x43
947 --> 947 (prime)
948 --> 2x2x3x79
949 --> 13x73
950 --> 2x5x5x19
951 --> 3x317
952 --> 2x2x2x7x17
953 --> 953 (prime)
954 --> 2x3x3x53
955 --> 5x191
956 --> 2x2x239
957 --> 3x11x29
958 --> 2x479
959 --> 7x137
960 --> 2x2x2x2x2x2x3x5
961 --> 31x31
962 --> 2x13x37
963 --> 3x3x107
964 --> 2x2x241
965 --> 5x193
966 --> 2x3x7x23
967 --> 967 (prime)
968 --> 2x2x2x11x11
969 --> 3x17x19
970 --> 2x5x97
971 --> 971 (prime)
972 --> 2x2x3x3x3x3x3
973 --> 7x139
974 --> 2x487
975 --> 3x5x5x13
976 --> 2x2x2x2x61
977 --> 977 (prime)
978 --> 2x3x163
979 --> 11x89
980 --> 2x2x5x7x7
981 --> 3x3x109
982 --> 2x491
983 --> 983 (prime)
984 --> 2x2x2x3x41
985 --> 5x197
986 --> 2x17x29
987 --> 3x7x47
988 --> 2x2x13x19
989 --> 23x43
990 --> 2x3x3x5x11
991 --> 991 (prime)
992 --> 2x2x2x2x2x31
993 --> 3x331
994 --> 2x7x71
995 --> 5x199
996 --> 2x2x3x83
997 --> 997 (prime)
998 --> 2x499
999 --> 3x3x3x37
===*/

function fact(n) {
    var res = [];
    var i;

    if (Math.floor(n) !== n) { throw new Error('must be whole'); }
    if (n <= 2) { return [ n ]; }

    while (n >= 2) {
        for (i = 2; i <= n; i++) {
            if ((n % i) === 0) {
                n = Math.floor(n / i);
                res.push(i);
                break;
            }
        }
    }

    return res;
}

function test() {
    var i, f;
    for (i = 0; i < 1000; i++) {
        f = fact(i);
        print(i, '-->', fact(i).join('x') + (f.length === 1 ? ' (prime)' : ''));
    }
}

try {
    test();
} catch (e) {
    print(e);
}
