
/*
 * Mesa 3-D graphics library
 *
 * Copyright (c) 2014 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

 /*
  * This file is AUTOGENERATED by format_info.py.  Do not edit it
  * manually or commit it into version control.
  */

static const struct gl_format_info format_info[MESA_FORMAT_COUNT] =
{

   {
      .Name = MESA_FORMAT_NONE,
      .StrName = "MESA_FORMAT_NONE",
      .Layout = MESA_FORMAT_LAYOUT_OTHER,
      .BaseFormat = GL_NONE,
      .DataType = GL_NONE,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 1,
      .Swizzle = { 4, 4, 4, 5 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_A8B8G8R8_UNORM,
      .StrName = "MESA_FORMAT_A8B8G8R8_UNORM",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 8,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 3, 2, 1, 0 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 0, 0, 1, 4, 3, 2, 1, 0),
   },
   {
      .Name = MESA_FORMAT_X8B8G8R8_UNORM,
      .StrName = "MESA_FORMAT_X8B8G8R8_UNORM",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGB,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 3, 2, 1, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 0, 0, 1, 4, 3, 2, 1, 5),
   },
   {
      .Name = MESA_FORMAT_R8G8B8A8_UNORM,
      .StrName = "MESA_FORMAT_R8G8B8A8_UNORM",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 8,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 0, 0, 1, 4, 0, 1, 2, 3),
   },
   {
      .Name = MESA_FORMAT_R8G8B8X8_UNORM,
      .StrName = "MESA_FORMAT_R8G8B8X8_UNORM",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGB,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 0, 1, 2, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 0, 0, 1, 4, 0, 1, 2, 5),
   },
   {
      .Name = MESA_FORMAT_B8G8R8A8_UNORM,
      .StrName = "MESA_FORMAT_B8G8R8A8_UNORM",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 8,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 2, 1, 0, 3 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 0, 0, 1, 4, 2, 1, 0, 3),
   },
   {
      .Name = MESA_FORMAT_B8G8R8X8_UNORM,
      .StrName = "MESA_FORMAT_B8G8R8X8_UNORM",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGB,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 2, 1, 0, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 0, 0, 1, 4, 2, 1, 0, 5),
   },
   {
      .Name = MESA_FORMAT_A8R8G8B8_UNORM,
      .StrName = "MESA_FORMAT_A8R8G8B8_UNORM",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 8,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 1, 2, 3, 0 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 0, 0, 1, 4, 1, 2, 3, 0),
   },
   {
      .Name = MESA_FORMAT_X8R8G8B8_UNORM,
      .StrName = "MESA_FORMAT_X8R8G8B8_UNORM",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGB,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 1, 2, 3, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 0, 0, 1, 4, 1, 2, 3, 5),
   },
   {
      .Name = MESA_FORMAT_L16A16_UNORM,
      .StrName = "MESA_FORMAT_L16A16_UNORM",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_LUMINANCE_ALPHA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 16,
      .LuminanceBits = 16, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 0, 0, 0, 1 },
      .ArrayFormat = MESA_ARRAY_FORMAT(2, 0, 0, 1, 2, 0, 0, 0, 1),
   },
   {
      .Name = MESA_FORMAT_A16L16_UNORM,
      .StrName = "MESA_FORMAT_A16L16_UNORM",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_LUMINANCE_ALPHA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 16,
      .LuminanceBits = 16, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 1, 1, 1, 0 },
      .ArrayFormat = MESA_ARRAY_FORMAT(2, 0, 0, 1, 2, 1, 1, 1, 0),
   },
   {
      .Name = MESA_FORMAT_B5G6R5_UNORM,
      .StrName = "MESA_FORMAT_B5G6R5_UNORM",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGB,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 5, .GreenBits = 6, .BlueBits = 5, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 2, 1, 0, 5 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_R5G6B5_UNORM,
      .StrName = "MESA_FORMAT_R5G6B5_UNORM",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGB,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 5, .GreenBits = 6, .BlueBits = 5, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 0, 1, 2, 5 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_B4G4R4A4_UNORM,
      .StrName = "MESA_FORMAT_B4G4R4A4_UNORM",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 4, .GreenBits = 4, .BlueBits = 4, .AlphaBits = 4,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 2, 1, 0, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_B4G4R4X4_UNORM,
      .StrName = "MESA_FORMAT_B4G4R4X4_UNORM",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGB,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 4, .GreenBits = 4, .BlueBits = 4, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 2, 1, 0, 5 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_A4R4G4B4_UNORM,
      .StrName = "MESA_FORMAT_A4R4G4B4_UNORM",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 4, .GreenBits = 4, .BlueBits = 4, .AlphaBits = 4,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 1, 2, 3, 0 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_A1B5G5R5_UNORM,
      .StrName = "MESA_FORMAT_A1B5G5R5_UNORM",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 5, .GreenBits = 5, .BlueBits = 5, .AlphaBits = 1,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 3, 2, 1, 0 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_X1B5G5R5_UNORM,
      .StrName = "MESA_FORMAT_X1B5G5R5_UNORM",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGB,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 5, .GreenBits = 5, .BlueBits = 5, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 3, 2, 1, 5 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_B5G5R5A1_UNORM,
      .StrName = "MESA_FORMAT_B5G5R5A1_UNORM",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 5, .GreenBits = 5, .BlueBits = 5, .AlphaBits = 1,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 2, 1, 0, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_B5G5R5X1_UNORM,
      .StrName = "MESA_FORMAT_B5G5R5X1_UNORM",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGB,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 5, .GreenBits = 5, .BlueBits = 5, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 2, 1, 0, 5 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_A1R5G5B5_UNORM,
      .StrName = "MESA_FORMAT_A1R5G5B5_UNORM",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 5, .GreenBits = 5, .BlueBits = 5, .AlphaBits = 1,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 1, 2, 3, 0 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_L8A8_UNORM,
      .StrName = "MESA_FORMAT_L8A8_UNORM",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_LUMINANCE_ALPHA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 8,
      .LuminanceBits = 8, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 0, 0, 0, 1 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 0, 0, 1, 2, 0, 0, 0, 1),
   },
   {
      .Name = MESA_FORMAT_A8L8_UNORM,
      .StrName = "MESA_FORMAT_A8L8_UNORM",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_LUMINANCE_ALPHA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 8,
      .LuminanceBits = 8, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 1, 1, 1, 0 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 0, 0, 1, 2, 1, 1, 1, 0),
   },
   {
      .Name = MESA_FORMAT_R8G8_UNORM,
      .StrName = "MESA_FORMAT_R8G8_UNORM",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RG,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 0, 1, 4, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 0, 0, 1, 2, 0, 1, 4, 5),
   },
   {
      .Name = MESA_FORMAT_G8R8_UNORM,
      .StrName = "MESA_FORMAT_G8R8_UNORM",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RG,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 1, 0, 4, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 0, 0, 1, 2, 1, 0, 4, 5),
   },
   {
      .Name = MESA_FORMAT_L4A4_UNORM,
      .StrName = "MESA_FORMAT_L4A4_UNORM",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_LUMINANCE_ALPHA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 4,
      .LuminanceBits = 4, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 1,
      .Swizzle = { 0, 0, 0, 1 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_B2G3R3_UNORM,
      .StrName = "MESA_FORMAT_B2G3R3_UNORM",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGB,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 3, .GreenBits = 3, .BlueBits = 2, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 1,
      .Swizzle = { 2, 1, 0, 5 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_R16G16_UNORM,
      .StrName = "MESA_FORMAT_R16G16_UNORM",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RG,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 16, .GreenBits = 16, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 0, 1, 4, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(2, 0, 0, 1, 2, 0, 1, 4, 5),
   },
   {
      .Name = MESA_FORMAT_G16R16_UNORM,
      .StrName = "MESA_FORMAT_G16R16_UNORM",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RG,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 16, .GreenBits = 16, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 1, 0, 4, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(2, 0, 0, 1, 2, 1, 0, 4, 5),
   },
   {
      .Name = MESA_FORMAT_B10G10R10A2_UNORM,
      .StrName = "MESA_FORMAT_B10G10R10A2_UNORM",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 10, .GreenBits = 10, .BlueBits = 10, .AlphaBits = 2,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 2, 1, 0, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_B10G10R10X2_UNORM,
      .StrName = "MESA_FORMAT_B10G10R10X2_UNORM",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGB,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 10, .GreenBits = 10, .BlueBits = 10, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 2, 1, 0, 5 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_R10G10B10A2_UNORM,
      .StrName = "MESA_FORMAT_R10G10B10A2_UNORM",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 10, .GreenBits = 10, .BlueBits = 10, .AlphaBits = 2,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_R10G10B10X2_UNORM,
      .StrName = "MESA_FORMAT_R10G10B10X2_UNORM",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGB,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 10, .GreenBits = 10, .BlueBits = 10, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 0, 1, 2, 5 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_S8_UINT_Z24_UNORM,
      .StrName = "MESA_FORMAT_S8_UINT_Z24_UNORM",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_DEPTH_STENCIL,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 24, .StencilBits = 8,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 0, 1, 6, 6 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_X8_UINT_Z24_UNORM,
      .StrName = "MESA_FORMAT_X8_UINT_Z24_UNORM",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_DEPTH_COMPONENT,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 24, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 0, 6, 6, 6 },
      .ArrayFormat = MESA_ARRAY_FORMAT(3, 0, 0, 1, 2, 0, 6, 6, 6),
   },
   {
      .Name = MESA_FORMAT_Z24_UNORM_S8_UINT,
      .StrName = "MESA_FORMAT_Z24_UNORM_S8_UINT",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_DEPTH_STENCIL,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 24, .StencilBits = 8,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 1, 0, 6, 6 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_Z24_UNORM_X8_UINT,
      .StrName = "MESA_FORMAT_Z24_UNORM_X8_UINT",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_DEPTH_COMPONENT,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 24, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 1, 6, 6, 6 },
      .ArrayFormat = MESA_ARRAY_FORMAT(3, 0, 0, 1, 2, 1, 6, 6, 6),
   },
   {
      .Name = MESA_FORMAT_R3G3B2_UNORM,
      .StrName = "MESA_FORMAT_R3G3B2_UNORM",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGB,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 3, .GreenBits = 3, .BlueBits = 2, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 1,
      .Swizzle = { 0, 1, 2, 5 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_A4B4G4R4_UNORM,
      .StrName = "MESA_FORMAT_A4B4G4R4_UNORM",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 4, .GreenBits = 4, .BlueBits = 4, .AlphaBits = 4,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 3, 2, 1, 0 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_R4G4B4A4_UNORM,
      .StrName = "MESA_FORMAT_R4G4B4A4_UNORM",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 4, .GreenBits = 4, .BlueBits = 4, .AlphaBits = 4,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_R5G5B5A1_UNORM,
      .StrName = "MESA_FORMAT_R5G5B5A1_UNORM",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 5, .GreenBits = 5, .BlueBits = 5, .AlphaBits = 1,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_A2B10G10R10_UNORM,
      .StrName = "MESA_FORMAT_A2B10G10R10_UNORM",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 10, .GreenBits = 10, .BlueBits = 10, .AlphaBits = 2,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 3, 2, 1, 0 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_A2R10G10B10_UNORM,
      .StrName = "MESA_FORMAT_A2R10G10B10_UNORM",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 10, .GreenBits = 10, .BlueBits = 10, .AlphaBits = 2,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 1, 2, 3, 0 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_YCBCR,
      .StrName = "MESA_FORMAT_YCBCR",
      .Layout = MESA_FORMAT_LAYOUT_OTHER,
      .BaseFormat = GL_YCBCR_MESA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_YCBCR_REV,
      .StrName = "MESA_FORMAT_YCBCR_REV",
      .Layout = MESA_FORMAT_LAYOUT_OTHER,
      .BaseFormat = GL_YCBCR_MESA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_A_UNORM8,
      .StrName = "MESA_FORMAT_A_UNORM8",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_ALPHA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 8,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 1,
      .Swizzle = { 4, 4, 4, 0 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 0, 0, 1, 1, 4, 4, 4, 0),
   },
   {
      .Name = MESA_FORMAT_A_UNORM16,
      .StrName = "MESA_FORMAT_A_UNORM16",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_ALPHA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 16,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 4, 4, 4, 0 },
      .ArrayFormat = MESA_ARRAY_FORMAT(2, 0, 0, 1, 1, 4, 4, 4, 0),
   },
   {
      .Name = MESA_FORMAT_L_UNORM8,
      .StrName = "MESA_FORMAT_L_UNORM8",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_LUMINANCE,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 8, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 1,
      .Swizzle = { 0, 0, 0, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 0, 0, 1, 1, 0, 0, 0, 5),
   },
   {
      .Name = MESA_FORMAT_L_UNORM16,
      .StrName = "MESA_FORMAT_L_UNORM16",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_LUMINANCE,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 16, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 0, 0, 0, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(2, 0, 0, 1, 1, 0, 0, 0, 5),
   },
   {
      .Name = MESA_FORMAT_I_UNORM8,
      .StrName = "MESA_FORMAT_I_UNORM8",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_INTENSITY,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 8, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 1,
      .Swizzle = { 0, 0, 0, 0 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 0, 0, 1, 1, 0, 0, 0, 0),
   },
   {
      .Name = MESA_FORMAT_I_UNORM16,
      .StrName = "MESA_FORMAT_I_UNORM16",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_INTENSITY,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 16, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 0, 0, 0, 0 },
      .ArrayFormat = MESA_ARRAY_FORMAT(2, 0, 0, 1, 1, 0, 0, 0, 0),
   },
   {
      .Name = MESA_FORMAT_R_UNORM8,
      .StrName = "MESA_FORMAT_R_UNORM8",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_RED,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 1,
      .Swizzle = { 0, 4, 4, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 0, 0, 1, 1, 0, 4, 4, 5),
   },
   {
      .Name = MESA_FORMAT_R_UNORM16,
      .StrName = "MESA_FORMAT_R_UNORM16",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_RED,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 16, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 0, 4, 4, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(2, 0, 0, 1, 1, 0, 4, 4, 5),
   },
   {
      .Name = MESA_FORMAT_BGR_UNORM8,
      .StrName = "MESA_FORMAT_BGR_UNORM8",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_RGB,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 3,
      .Swizzle = { 2, 1, 0, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 0, 0, 1, 3, 2, 1, 0, 5),
   },
   {
      .Name = MESA_FORMAT_RGB_UNORM8,
      .StrName = "MESA_FORMAT_RGB_UNORM8",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_RGB,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 3,
      .Swizzle = { 0, 1, 2, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 0, 0, 1, 3, 0, 1, 2, 5),
   },
   {
      .Name = MESA_FORMAT_RGBA_UNORM16,
      .StrName = "MESA_FORMAT_RGBA_UNORM16",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 16, .GreenBits = 16, .BlueBits = 16, .AlphaBits = 16,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 8,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = MESA_ARRAY_FORMAT(2, 0, 0, 1, 4, 0, 1, 2, 3),
   },
   {
      .Name = MESA_FORMAT_RGBX_UNORM16,
      .StrName = "MESA_FORMAT_RGBX_UNORM16",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_RGB,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 16, .GreenBits = 16, .BlueBits = 16, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 8,
      .Swizzle = { 0, 1, 2, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(2, 0, 0, 1, 4, 0, 1, 2, 5),
   },
   {
      .Name = MESA_FORMAT_Z_UNORM16,
      .StrName = "MESA_FORMAT_Z_UNORM16",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_DEPTH_COMPONENT,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 16, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 0, 6, 6, 6 },
      .ArrayFormat = MESA_ARRAY_FORMAT(2, 0, 0, 1, 1, 0, 6, 6, 6),
   },
   {
      .Name = MESA_FORMAT_Z_UNORM32,
      .StrName = "MESA_FORMAT_Z_UNORM32",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_DEPTH_COMPONENT,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 32, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 0, 6, 6, 6 },
      .ArrayFormat = MESA_ARRAY_FORMAT(4, 0, 0, 1, 1, 0, 6, 6, 6),
   },
   {
      .Name = MESA_FORMAT_S_UINT8,
      .StrName = "MESA_FORMAT_S_UINT8",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_STENCIL_INDEX,
      .DataType = GL_UNSIGNED_INT,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 8,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 1,
      .Swizzle = { 6, 0, 6, 6 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 0, 0, 0, 1, 6, 0, 6, 6),
   },
   {
      .Name = MESA_FORMAT_A8B8G8R8_SNORM,
      .StrName = "MESA_FORMAT_A8B8G8R8_SNORM",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGBA,
      .DataType = GL_SIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 8,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 3, 2, 1, 0 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 1, 0, 1, 4, 3, 2, 1, 0),
   },
   {
      .Name = MESA_FORMAT_X8B8G8R8_SNORM,
      .StrName = "MESA_FORMAT_X8B8G8R8_SNORM",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGB,
      .DataType = GL_SIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 3, 2, 1, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 1, 0, 1, 4, 3, 2, 1, 5),
   },
   {
      .Name = MESA_FORMAT_R8G8B8A8_SNORM,
      .StrName = "MESA_FORMAT_R8G8B8A8_SNORM",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGBA,
      .DataType = GL_SIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 8,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 1, 0, 1, 4, 0, 1, 2, 3),
   },
   {
      .Name = MESA_FORMAT_R8G8B8X8_SNORM,
      .StrName = "MESA_FORMAT_R8G8B8X8_SNORM",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGB,
      .DataType = GL_SIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 0, 1, 2, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 1, 0, 1, 4, 0, 1, 2, 5),
   },
   {
      .Name = MESA_FORMAT_R16G16_SNORM,
      .StrName = "MESA_FORMAT_R16G16_SNORM",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RG,
      .DataType = GL_SIGNED_NORMALIZED,
      .RedBits = 16, .GreenBits = 16, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 0, 1, 4, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(2, 1, 0, 1, 2, 0, 1, 4, 5),
   },
   {
      .Name = MESA_FORMAT_G16R16_SNORM,
      .StrName = "MESA_FORMAT_G16R16_SNORM",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RG,
      .DataType = GL_SIGNED_NORMALIZED,
      .RedBits = 16, .GreenBits = 16, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 1, 0, 4, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(2, 1, 0, 1, 2, 1, 0, 4, 5),
   },
   {
      .Name = MESA_FORMAT_R8G8_SNORM,
      .StrName = "MESA_FORMAT_R8G8_SNORM",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RG,
      .DataType = GL_SIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 0, 1, 4, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 1, 0, 1, 2, 0, 1, 4, 5),
   },
   {
      .Name = MESA_FORMAT_G8R8_SNORM,
      .StrName = "MESA_FORMAT_G8R8_SNORM",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RG,
      .DataType = GL_SIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 1, 0, 4, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 1, 0, 1, 2, 1, 0, 4, 5),
   },
   {
      .Name = MESA_FORMAT_L8A8_SNORM,
      .StrName = "MESA_FORMAT_L8A8_SNORM",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_LUMINANCE_ALPHA,
      .DataType = GL_SIGNED_NORMALIZED,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 8,
      .LuminanceBits = 8, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 0, 0, 0, 1 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 1, 0, 1, 2, 0, 0, 0, 1),
   },
   {
      .Name = MESA_FORMAT_A8L8_SNORM,
      .StrName = "MESA_FORMAT_A8L8_SNORM",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_LUMINANCE_ALPHA,
      .DataType = GL_SIGNED_NORMALIZED,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 8,
      .LuminanceBits = 8, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 1, 1, 1, 0 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 1, 0, 1, 2, 1, 1, 1, 0),
   },
   {
      .Name = MESA_FORMAT_A_SNORM8,
      .StrName = "MESA_FORMAT_A_SNORM8",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_ALPHA,
      .DataType = GL_SIGNED_NORMALIZED,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 8,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 1,
      .Swizzle = { 4, 4, 4, 0 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 1, 0, 1, 1, 4, 4, 4, 0),
   },
   {
      .Name = MESA_FORMAT_A_SNORM16,
      .StrName = "MESA_FORMAT_A_SNORM16",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_ALPHA,
      .DataType = GL_SIGNED_NORMALIZED,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 16,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 4, 4, 4, 0 },
      .ArrayFormat = MESA_ARRAY_FORMAT(2, 1, 0, 1, 1, 4, 4, 4, 0),
   },
   {
      .Name = MESA_FORMAT_L_SNORM8,
      .StrName = "MESA_FORMAT_L_SNORM8",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_LUMINANCE,
      .DataType = GL_SIGNED_NORMALIZED,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 8, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 1,
      .Swizzle = { 0, 0, 0, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 1, 0, 1, 1, 0, 0, 0, 5),
   },
   {
      .Name = MESA_FORMAT_L_SNORM16,
      .StrName = "MESA_FORMAT_L_SNORM16",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_LUMINANCE,
      .DataType = GL_SIGNED_NORMALIZED,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 16, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 0, 0, 0, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(2, 1, 0, 1, 1, 0, 0, 0, 5),
   },
   {
      .Name = MESA_FORMAT_I_SNORM8,
      .StrName = "MESA_FORMAT_I_SNORM8",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_INTENSITY,
      .DataType = GL_SIGNED_NORMALIZED,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 8, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 1,
      .Swizzle = { 0, 0, 0, 0 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 1, 0, 1, 1, 0, 0, 0, 0),
   },
   {
      .Name = MESA_FORMAT_I_SNORM16,
      .StrName = "MESA_FORMAT_I_SNORM16",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_INTENSITY,
      .DataType = GL_SIGNED_NORMALIZED,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 16, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 0, 0, 0, 0 },
      .ArrayFormat = MESA_ARRAY_FORMAT(2, 1, 0, 1, 1, 0, 0, 0, 0),
   },
   {
      .Name = MESA_FORMAT_R_SNORM8,
      .StrName = "MESA_FORMAT_R_SNORM8",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_RED,
      .DataType = GL_SIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 1,
      .Swizzle = { 0, 4, 4, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 1, 0, 1, 1, 0, 4, 4, 5),
   },
   {
      .Name = MESA_FORMAT_R_SNORM16,
      .StrName = "MESA_FORMAT_R_SNORM16",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_RED,
      .DataType = GL_SIGNED_NORMALIZED,
      .RedBits = 16, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 0, 4, 4, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(2, 1, 0, 1, 1, 0, 4, 4, 5),
   },
   {
      .Name = MESA_FORMAT_LA_SNORM16,
      .StrName = "MESA_FORMAT_LA_SNORM16",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_LUMINANCE_ALPHA,
      .DataType = GL_SIGNED_NORMALIZED,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 16,
      .LuminanceBits = 16, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 0, 0, 0, 1 },
      .ArrayFormat = MESA_ARRAY_FORMAT(2, 1, 0, 1, 2, 0, 0, 0, 1),
   },
   {
      .Name = MESA_FORMAT_RGB_SNORM16,
      .StrName = "MESA_FORMAT_RGB_SNORM16",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_RGB,
      .DataType = GL_SIGNED_NORMALIZED,
      .RedBits = 16, .GreenBits = 16, .BlueBits = 16, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 6,
      .Swizzle = { 0, 1, 2, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(2, 1, 0, 1, 3, 0, 1, 2, 5),
   },
   {
      .Name = MESA_FORMAT_RGBA_SNORM16,
      .StrName = "MESA_FORMAT_RGBA_SNORM16",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_RGBA,
      .DataType = GL_SIGNED_NORMALIZED,
      .RedBits = 16, .GreenBits = 16, .BlueBits = 16, .AlphaBits = 16,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 8,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = MESA_ARRAY_FORMAT(2, 1, 0, 1, 4, 0, 1, 2, 3),
   },
   {
      .Name = MESA_FORMAT_RGBX_SNORM16,
      .StrName = "MESA_FORMAT_RGBX_SNORM16",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_RGB,
      .DataType = GL_SIGNED_NORMALIZED,
      .RedBits = 16, .GreenBits = 16, .BlueBits = 16, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 8,
      .Swizzle = { 0, 1, 2, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(2, 1, 0, 1, 4, 0, 1, 2, 5),
   },
   {
      .Name = MESA_FORMAT_A8B8G8R8_SRGB,
      .StrName = "MESA_FORMAT_A8B8G8R8_SRGB",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 8,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 1,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 3, 2, 1, 0 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 0, 0, 1, 4, 3, 2, 1, 0),
   },
   {
      .Name = MESA_FORMAT_B8G8R8A8_SRGB,
      .StrName = "MESA_FORMAT_B8G8R8A8_SRGB",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 8,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 1,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 2, 1, 0, 3 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 0, 0, 1, 4, 2, 1, 0, 3),
   },
   {
      .Name = MESA_FORMAT_A8R8G8B8_SRGB,
      .StrName = "MESA_FORMAT_A8R8G8B8_SRGB",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 8,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 1,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 1, 2, 3, 0 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 0, 0, 1, 4, 1, 2, 3, 0),
   },
   {
      .Name = MESA_FORMAT_B8G8R8X8_SRGB,
      .StrName = "MESA_FORMAT_B8G8R8X8_SRGB",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGB,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 1,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 2, 1, 0, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 0, 0, 1, 4, 2, 1, 0, 5),
   },
   {
      .Name = MESA_FORMAT_X8R8G8B8_SRGB,
      .StrName = "MESA_FORMAT_X8R8G8B8_SRGB",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGB,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 1,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 1, 2, 3, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 0, 0, 1, 4, 1, 2, 3, 5),
   },
   {
      .Name = MESA_FORMAT_R8G8B8A8_SRGB,
      .StrName = "MESA_FORMAT_R8G8B8A8_SRGB",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 8,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 1,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 0, 0, 1, 4, 0, 1, 2, 3),
   },
   {
      .Name = MESA_FORMAT_R8G8B8X8_SRGB,
      .StrName = "MESA_FORMAT_R8G8B8X8_SRGB",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGB,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 1,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 0, 1, 2, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 0, 0, 1, 4, 0, 1, 2, 5),
   },
   {
      .Name = MESA_FORMAT_X8B8G8R8_SRGB,
      .StrName = "MESA_FORMAT_X8B8G8R8_SRGB",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGB,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 1,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 3, 2, 1, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 0, 0, 1, 4, 3, 2, 1, 5),
   },
   {
      .Name = MESA_FORMAT_L8A8_SRGB,
      .StrName = "MESA_FORMAT_L8A8_SRGB",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_LUMINANCE_ALPHA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 8,
      .LuminanceBits = 8, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 1,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 0, 0, 0, 1 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 0, 0, 1, 2, 0, 0, 0, 1),
   },
   {
      .Name = MESA_FORMAT_A8L8_SRGB,
      .StrName = "MESA_FORMAT_A8L8_SRGB",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_LUMINANCE_ALPHA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 8,
      .LuminanceBits = 8, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 1,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 1, 1, 1, 0 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 0, 0, 1, 2, 1, 1, 1, 0),
   },
   {
      .Name = MESA_FORMAT_L_SRGB8,
      .StrName = "MESA_FORMAT_L_SRGB8",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_LUMINANCE,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 8, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 1,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 1,
      .Swizzle = { 0, 0, 0, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 0, 0, 1, 1, 0, 0, 0, 5),
   },
   {
      .Name = MESA_FORMAT_BGR_SRGB8,
      .StrName = "MESA_FORMAT_BGR_SRGB8",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_RGB,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 1,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 3,
      .Swizzle = { 2, 1, 0, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 0, 0, 1, 3, 2, 1, 0, 5),
   },
   {
      .Name = MESA_FORMAT_R9G9B9E5_FLOAT,
      .StrName = "MESA_FORMAT_R9G9B9E5_FLOAT",
      .Layout = MESA_FORMAT_LAYOUT_OTHER,
      .BaseFormat = GL_RGB,
      .DataType = GL_FLOAT,
      .RedBits = 9, .GreenBits = 9, .BlueBits = 9, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 0, 1, 2, 5 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_R11G11B10_FLOAT,
      .StrName = "MESA_FORMAT_R11G11B10_FLOAT",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGB,
      .DataType = GL_FLOAT,
      .RedBits = 11, .GreenBits = 11, .BlueBits = 10, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 0, 1, 2, 5 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_Z32_FLOAT_S8X24_UINT,
      .StrName = "MESA_FORMAT_Z32_FLOAT_S8X24_UINT",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_DEPTH_STENCIL,
      .DataType = GL_FLOAT,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 32, .StencilBits = 8,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 8,
      .Swizzle = { 2, 0, 6, 6 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_A_FLOAT16,
      .StrName = "MESA_FORMAT_A_FLOAT16",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_ALPHA,
      .DataType = GL_FLOAT,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 16,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 4, 4, 4, 0 },
      .ArrayFormat = MESA_ARRAY_FORMAT(2, 1, 1, 1, 1, 4, 4, 4, 0),
   },
   {
      .Name = MESA_FORMAT_A_FLOAT32,
      .StrName = "MESA_FORMAT_A_FLOAT32",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_ALPHA,
      .DataType = GL_FLOAT,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 32,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 4, 4, 4, 0 },
      .ArrayFormat = MESA_ARRAY_FORMAT(4, 1, 1, 1, 1, 4, 4, 4, 0),
   },
   {
      .Name = MESA_FORMAT_L_FLOAT16,
      .StrName = "MESA_FORMAT_L_FLOAT16",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_LUMINANCE,
      .DataType = GL_FLOAT,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 16, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 0, 0, 0, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(2, 1, 1, 1, 1, 0, 0, 0, 5),
   },
   {
      .Name = MESA_FORMAT_L_FLOAT32,
      .StrName = "MESA_FORMAT_L_FLOAT32",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_LUMINANCE,
      .DataType = GL_FLOAT,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 32, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 0, 0, 0, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(4, 1, 1, 1, 1, 0, 0, 0, 5),
   },
   {
      .Name = MESA_FORMAT_LA_FLOAT16,
      .StrName = "MESA_FORMAT_LA_FLOAT16",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_LUMINANCE_ALPHA,
      .DataType = GL_FLOAT,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 16,
      .LuminanceBits = 16, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 0, 0, 0, 1 },
      .ArrayFormat = MESA_ARRAY_FORMAT(2, 1, 1, 1, 2, 0, 0, 0, 1),
   },
   {
      .Name = MESA_FORMAT_LA_FLOAT32,
      .StrName = "MESA_FORMAT_LA_FLOAT32",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_LUMINANCE_ALPHA,
      .DataType = GL_FLOAT,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 32,
      .LuminanceBits = 32, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 8,
      .Swizzle = { 0, 0, 0, 1 },
      .ArrayFormat = MESA_ARRAY_FORMAT(4, 1, 1, 1, 2, 0, 0, 0, 1),
   },
   {
      .Name = MESA_FORMAT_I_FLOAT16,
      .StrName = "MESA_FORMAT_I_FLOAT16",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_INTENSITY,
      .DataType = GL_FLOAT,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 16, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 0, 0, 0, 0 },
      .ArrayFormat = MESA_ARRAY_FORMAT(2, 1, 1, 1, 1, 0, 0, 0, 0),
   },
   {
      .Name = MESA_FORMAT_I_FLOAT32,
      .StrName = "MESA_FORMAT_I_FLOAT32",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_INTENSITY,
      .DataType = GL_FLOAT,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 32, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 0, 0, 0, 0 },
      .ArrayFormat = MESA_ARRAY_FORMAT(4, 1, 1, 1, 1, 0, 0, 0, 0),
   },
   {
      .Name = MESA_FORMAT_R_FLOAT16,
      .StrName = "MESA_FORMAT_R_FLOAT16",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_RED,
      .DataType = GL_FLOAT,
      .RedBits = 16, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 0, 4, 4, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(2, 1, 1, 1, 1, 0, 4, 4, 5),
   },
   {
      .Name = MESA_FORMAT_R_FLOAT32,
      .StrName = "MESA_FORMAT_R_FLOAT32",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_RED,
      .DataType = GL_FLOAT,
      .RedBits = 32, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 0, 4, 4, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(4, 1, 1, 1, 1, 0, 4, 4, 5),
   },
   {
      .Name = MESA_FORMAT_RG_FLOAT16,
      .StrName = "MESA_FORMAT_RG_FLOAT16",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_RG,
      .DataType = GL_FLOAT,
      .RedBits = 16, .GreenBits = 16, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 0, 1, 4, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(2, 1, 1, 1, 2, 0, 1, 4, 5),
   },
   {
      .Name = MESA_FORMAT_RG_FLOAT32,
      .StrName = "MESA_FORMAT_RG_FLOAT32",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_RG,
      .DataType = GL_FLOAT,
      .RedBits = 32, .GreenBits = 32, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 8,
      .Swizzle = { 0, 1, 4, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(4, 1, 1, 1, 2, 0, 1, 4, 5),
   },
   {
      .Name = MESA_FORMAT_RGB_FLOAT16,
      .StrName = "MESA_FORMAT_RGB_FLOAT16",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_RGB,
      .DataType = GL_FLOAT,
      .RedBits = 16, .GreenBits = 16, .BlueBits = 16, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 6,
      .Swizzle = { 0, 1, 2, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(2, 1, 1, 1, 3, 0, 1, 2, 5),
   },
   {
      .Name = MESA_FORMAT_RGB_FLOAT32,
      .StrName = "MESA_FORMAT_RGB_FLOAT32",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_RGB,
      .DataType = GL_FLOAT,
      .RedBits = 32, .GreenBits = 32, .BlueBits = 32, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 12,
      .Swizzle = { 0, 1, 2, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(4, 1, 1, 1, 3, 0, 1, 2, 5),
   },
   {
      .Name = MESA_FORMAT_RGBA_FLOAT16,
      .StrName = "MESA_FORMAT_RGBA_FLOAT16",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_RGBA,
      .DataType = GL_FLOAT,
      .RedBits = 16, .GreenBits = 16, .BlueBits = 16, .AlphaBits = 16,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 8,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = MESA_ARRAY_FORMAT(2, 1, 1, 1, 4, 0, 1, 2, 3),
   },
   {
      .Name = MESA_FORMAT_RGBA_FLOAT32,
      .StrName = "MESA_FORMAT_RGBA_FLOAT32",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_RGBA,
      .DataType = GL_FLOAT,
      .RedBits = 32, .GreenBits = 32, .BlueBits = 32, .AlphaBits = 32,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = MESA_ARRAY_FORMAT(4, 1, 1, 1, 4, 0, 1, 2, 3),
   },
   {
      .Name = MESA_FORMAT_RGBX_FLOAT16,
      .StrName = "MESA_FORMAT_RGBX_FLOAT16",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_RGB,
      .DataType = GL_FLOAT,
      .RedBits = 16, .GreenBits = 16, .BlueBits = 16, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 8,
      .Swizzle = { 0, 1, 2, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(2, 1, 1, 1, 4, 0, 1, 2, 5),
   },
   {
      .Name = MESA_FORMAT_RGBX_FLOAT32,
      .StrName = "MESA_FORMAT_RGBX_FLOAT32",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_RGB,
      .DataType = GL_FLOAT,
      .RedBits = 32, .GreenBits = 32, .BlueBits = 32, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(4, 1, 1, 1, 4, 0, 1, 2, 5),
   },
   {
      .Name = MESA_FORMAT_Z_FLOAT32,
      .StrName = "MESA_FORMAT_Z_FLOAT32",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_DEPTH_COMPONENT,
      .DataType = GL_FLOAT,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 32, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 0, 6, 6, 6 },
      .ArrayFormat = MESA_ARRAY_FORMAT(4, 1, 1, 1, 1, 0, 6, 6, 6),
   },
   {
      .Name = MESA_FORMAT_A8B8G8R8_UINT,
      .StrName = "MESA_FORMAT_A8B8G8R8_UINT",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_INT,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 8,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 3, 2, 1, 0 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 0, 0, 0, 4, 3, 2, 1, 0),
   },
   {
      .Name = MESA_FORMAT_A8R8G8B8_UINT,
      .StrName = "MESA_FORMAT_A8R8G8B8_UINT",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_INT,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 8,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 1, 2, 3, 0 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 0, 0, 0, 4, 1, 2, 3, 0),
   },
   {
      .Name = MESA_FORMAT_R8G8B8A8_UINT,
      .StrName = "MESA_FORMAT_R8G8B8A8_UINT",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_INT,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 8,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 0, 0, 0, 4, 0, 1, 2, 3),
   },
   {
      .Name = MESA_FORMAT_B8G8R8A8_UINT,
      .StrName = "MESA_FORMAT_B8G8R8A8_UINT",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_INT,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 8,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 2, 1, 0, 3 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 0, 0, 0, 4, 2, 1, 0, 3),
   },
   {
      .Name = MESA_FORMAT_B10G10R10A2_UINT,
      .StrName = "MESA_FORMAT_B10G10R10A2_UINT",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_INT,
      .RedBits = 10, .GreenBits = 10, .BlueBits = 10, .AlphaBits = 2,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 2, 1, 0, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_R10G10B10A2_UINT,
      .StrName = "MESA_FORMAT_R10G10B10A2_UINT",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_INT,
      .RedBits = 10, .GreenBits = 10, .BlueBits = 10, .AlphaBits = 2,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_A2B10G10R10_UINT,
      .StrName = "MESA_FORMAT_A2B10G10R10_UINT",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_INT,
      .RedBits = 10, .GreenBits = 10, .BlueBits = 10, .AlphaBits = 2,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 3, 2, 1, 0 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_A2R10G10B10_UINT,
      .StrName = "MESA_FORMAT_A2R10G10B10_UINT",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_INT,
      .RedBits = 10, .GreenBits = 10, .BlueBits = 10, .AlphaBits = 2,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 1, 2, 3, 0 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_B5G6R5_UINT,
      .StrName = "MESA_FORMAT_B5G6R5_UINT",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGB,
      .DataType = GL_UNSIGNED_INT,
      .RedBits = 5, .GreenBits = 6, .BlueBits = 5, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 2, 1, 0, 5 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_R5G6B5_UINT,
      .StrName = "MESA_FORMAT_R5G6B5_UINT",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGB,
      .DataType = GL_UNSIGNED_INT,
      .RedBits = 5, .GreenBits = 6, .BlueBits = 5, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 0, 1, 2, 5 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_B2G3R3_UINT,
      .StrName = "MESA_FORMAT_B2G3R3_UINT",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGB,
      .DataType = GL_UNSIGNED_INT,
      .RedBits = 3, .GreenBits = 3, .BlueBits = 2, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 1,
      .Swizzle = { 2, 1, 0, 5 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_R3G3B2_UINT,
      .StrName = "MESA_FORMAT_R3G3B2_UINT",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGB,
      .DataType = GL_UNSIGNED_INT,
      .RedBits = 3, .GreenBits = 3, .BlueBits = 2, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 1,
      .Swizzle = { 0, 1, 2, 5 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_A4B4G4R4_UINT,
      .StrName = "MESA_FORMAT_A4B4G4R4_UINT",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_INT,
      .RedBits = 4, .GreenBits = 4, .BlueBits = 4, .AlphaBits = 4,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 3, 2, 1, 0 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_R4G4B4A4_UINT,
      .StrName = "MESA_FORMAT_R4G4B4A4_UINT",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_INT,
      .RedBits = 4, .GreenBits = 4, .BlueBits = 4, .AlphaBits = 4,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_B4G4R4A4_UINT,
      .StrName = "MESA_FORMAT_B4G4R4A4_UINT",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_INT,
      .RedBits = 4, .GreenBits = 4, .BlueBits = 4, .AlphaBits = 4,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 2, 1, 0, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_A4R4G4B4_UINT,
      .StrName = "MESA_FORMAT_A4R4G4B4_UINT",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_INT,
      .RedBits = 4, .GreenBits = 4, .BlueBits = 4, .AlphaBits = 4,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 1, 2, 3, 0 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_A1B5G5R5_UINT,
      .StrName = "MESA_FORMAT_A1B5G5R5_UINT",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_INT,
      .RedBits = 5, .GreenBits = 5, .BlueBits = 5, .AlphaBits = 1,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 3, 2, 1, 0 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_B5G5R5A1_UINT,
      .StrName = "MESA_FORMAT_B5G5R5A1_UINT",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_INT,
      .RedBits = 5, .GreenBits = 5, .BlueBits = 5, .AlphaBits = 1,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 2, 1, 0, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_A1R5G5B5_UINT,
      .StrName = "MESA_FORMAT_A1R5G5B5_UINT",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_INT,
      .RedBits = 5, .GreenBits = 5, .BlueBits = 5, .AlphaBits = 1,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 1, 2, 3, 0 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_R5G5B5A1_UINT,
      .StrName = "MESA_FORMAT_R5G5B5A1_UINT",
      .Layout = MESA_FORMAT_LAYOUT_PACKED,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_INT,
      .RedBits = 5, .GreenBits = 5, .BlueBits = 5, .AlphaBits = 1,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_A_UINT8,
      .StrName = "MESA_FORMAT_A_UINT8",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_ALPHA,
      .DataType = GL_UNSIGNED_INT,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 8,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 1,
      .Swizzle = { 4, 4, 4, 0 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 0, 0, 0, 1, 4, 4, 4, 0),
   },
   {
      .Name = MESA_FORMAT_A_UINT16,
      .StrName = "MESA_FORMAT_A_UINT16",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_ALPHA,
      .DataType = GL_UNSIGNED_INT,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 16,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 4, 4, 4, 0 },
      .ArrayFormat = MESA_ARRAY_FORMAT(2, 0, 0, 0, 1, 4, 4, 4, 0),
   },
   {
      .Name = MESA_FORMAT_A_UINT32,
      .StrName = "MESA_FORMAT_A_UINT32",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_ALPHA,
      .DataType = GL_UNSIGNED_INT,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 32,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 4, 4, 4, 0 },
      .ArrayFormat = MESA_ARRAY_FORMAT(4, 0, 0, 0, 1, 4, 4, 4, 0),
   },
   {
      .Name = MESA_FORMAT_A_SINT8,
      .StrName = "MESA_FORMAT_A_SINT8",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_ALPHA,
      .DataType = GL_INT,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 8,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 1,
      .Swizzle = { 4, 4, 4, 0 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 1, 0, 0, 1, 4, 4, 4, 0),
   },
   {
      .Name = MESA_FORMAT_A_SINT16,
      .StrName = "MESA_FORMAT_A_SINT16",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_ALPHA,
      .DataType = GL_INT,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 16,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 4, 4, 4, 0 },
      .ArrayFormat = MESA_ARRAY_FORMAT(2, 1, 0, 0, 1, 4, 4, 4, 0),
   },
   {
      .Name = MESA_FORMAT_A_SINT32,
      .StrName = "MESA_FORMAT_A_SINT32",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_ALPHA,
      .DataType = GL_INT,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 32,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 4, 4, 4, 0 },
      .ArrayFormat = MESA_ARRAY_FORMAT(4, 1, 0, 0, 1, 4, 4, 4, 0),
   },
   {
      .Name = MESA_FORMAT_I_UINT8,
      .StrName = "MESA_FORMAT_I_UINT8",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_INTENSITY,
      .DataType = GL_UNSIGNED_INT,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 8, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 1,
      .Swizzle = { 0, 0, 0, 0 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 0, 0, 0, 1, 0, 0, 0, 0),
   },
   {
      .Name = MESA_FORMAT_I_UINT16,
      .StrName = "MESA_FORMAT_I_UINT16",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_INTENSITY,
      .DataType = GL_UNSIGNED_INT,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 16, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 0, 0, 0, 0 },
      .ArrayFormat = MESA_ARRAY_FORMAT(2, 0, 0, 0, 1, 0, 0, 0, 0),
   },
   {
      .Name = MESA_FORMAT_I_UINT32,
      .StrName = "MESA_FORMAT_I_UINT32",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_INTENSITY,
      .DataType = GL_UNSIGNED_INT,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 32, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 0, 0, 0, 0 },
      .ArrayFormat = MESA_ARRAY_FORMAT(4, 0, 0, 0, 1, 0, 0, 0, 0),
   },
   {
      .Name = MESA_FORMAT_I_SINT8,
      .StrName = "MESA_FORMAT_I_SINT8",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_INTENSITY,
      .DataType = GL_INT,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 8, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 1,
      .Swizzle = { 0, 0, 0, 0 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 1, 0, 0, 1, 0, 0, 0, 0),
   },
   {
      .Name = MESA_FORMAT_I_SINT16,
      .StrName = "MESA_FORMAT_I_SINT16",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_INTENSITY,
      .DataType = GL_INT,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 16, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 0, 0, 0, 0 },
      .ArrayFormat = MESA_ARRAY_FORMAT(2, 1, 0, 0, 1, 0, 0, 0, 0),
   },
   {
      .Name = MESA_FORMAT_I_SINT32,
      .StrName = "MESA_FORMAT_I_SINT32",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_INTENSITY,
      .DataType = GL_INT,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 32, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 0, 0, 0, 0 },
      .ArrayFormat = MESA_ARRAY_FORMAT(4, 1, 0, 0, 1, 0, 0, 0, 0),
   },
   {
      .Name = MESA_FORMAT_L_UINT8,
      .StrName = "MESA_FORMAT_L_UINT8",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_LUMINANCE,
      .DataType = GL_UNSIGNED_INT,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 8, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 1,
      .Swizzle = { 0, 0, 0, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 0, 0, 0, 1, 0, 0, 0, 5),
   },
   {
      .Name = MESA_FORMAT_L_UINT16,
      .StrName = "MESA_FORMAT_L_UINT16",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_LUMINANCE,
      .DataType = GL_UNSIGNED_INT,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 16, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 0, 0, 0, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(2, 0, 0, 0, 1, 0, 0, 0, 5),
   },
   {
      .Name = MESA_FORMAT_L_UINT32,
      .StrName = "MESA_FORMAT_L_UINT32",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_LUMINANCE,
      .DataType = GL_UNSIGNED_INT,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 32, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 0, 0, 0, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(4, 0, 0, 0, 1, 0, 0, 0, 5),
   },
   {
      .Name = MESA_FORMAT_L_SINT8,
      .StrName = "MESA_FORMAT_L_SINT8",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_LUMINANCE,
      .DataType = GL_INT,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 8, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 1,
      .Swizzle = { 0, 0, 0, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 1, 0, 0, 1, 0, 0, 0, 5),
   },
   {
      .Name = MESA_FORMAT_L_SINT16,
      .StrName = "MESA_FORMAT_L_SINT16",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_LUMINANCE,
      .DataType = GL_INT,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 16, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 0, 0, 0, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(2, 1, 0, 0, 1, 0, 0, 0, 5),
   },
   {
      .Name = MESA_FORMAT_L_SINT32,
      .StrName = "MESA_FORMAT_L_SINT32",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_LUMINANCE,
      .DataType = GL_INT,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 32, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 0, 0, 0, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(4, 1, 0, 0, 1, 0, 0, 0, 5),
   },
   {
      .Name = MESA_FORMAT_LA_UINT8,
      .StrName = "MESA_FORMAT_LA_UINT8",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_LUMINANCE_ALPHA,
      .DataType = GL_UNSIGNED_INT,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 8,
      .LuminanceBits = 8, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 0, 0, 0, 1 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 0, 0, 0, 2, 0, 0, 0, 1),
   },
   {
      .Name = MESA_FORMAT_LA_UINT16,
      .StrName = "MESA_FORMAT_LA_UINT16",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_LUMINANCE_ALPHA,
      .DataType = GL_UNSIGNED_INT,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 16,
      .LuminanceBits = 16, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 0, 0, 0, 1 },
      .ArrayFormat = MESA_ARRAY_FORMAT(2, 0, 0, 0, 2, 0, 0, 0, 1),
   },
   {
      .Name = MESA_FORMAT_LA_UINT32,
      .StrName = "MESA_FORMAT_LA_UINT32",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_LUMINANCE_ALPHA,
      .DataType = GL_UNSIGNED_INT,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 32,
      .LuminanceBits = 32, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 8,
      .Swizzle = { 0, 0, 0, 1 },
      .ArrayFormat = MESA_ARRAY_FORMAT(4, 0, 0, 0, 2, 0, 0, 0, 1),
   },
   {
      .Name = MESA_FORMAT_LA_SINT8,
      .StrName = "MESA_FORMAT_LA_SINT8",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_LUMINANCE_ALPHA,
      .DataType = GL_INT,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 8,
      .LuminanceBits = 8, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 0, 0, 0, 1 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 1, 0, 0, 2, 0, 0, 0, 1),
   },
   {
      .Name = MESA_FORMAT_LA_SINT16,
      .StrName = "MESA_FORMAT_LA_SINT16",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_LUMINANCE_ALPHA,
      .DataType = GL_INT,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 16,
      .LuminanceBits = 16, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 0, 0, 0, 1 },
      .ArrayFormat = MESA_ARRAY_FORMAT(2, 1, 0, 0, 2, 0, 0, 0, 1),
   },
   {
      .Name = MESA_FORMAT_LA_SINT32,
      .StrName = "MESA_FORMAT_LA_SINT32",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_LUMINANCE_ALPHA,
      .DataType = GL_INT,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 32,
      .LuminanceBits = 32, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 8,
      .Swizzle = { 0, 0, 0, 1 },
      .ArrayFormat = MESA_ARRAY_FORMAT(4, 1, 0, 0, 2, 0, 0, 0, 1),
   },
   {
      .Name = MESA_FORMAT_R_UINT8,
      .StrName = "MESA_FORMAT_R_UINT8",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_RED,
      .DataType = GL_UNSIGNED_INT,
      .RedBits = 8, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 1,
      .Swizzle = { 0, 4, 4, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 0, 0, 0, 1, 0, 4, 4, 5),
   },
   {
      .Name = MESA_FORMAT_R_UINT16,
      .StrName = "MESA_FORMAT_R_UINT16",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_RED,
      .DataType = GL_UNSIGNED_INT,
      .RedBits = 16, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 0, 4, 4, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(2, 0, 0, 0, 1, 0, 4, 4, 5),
   },
   {
      .Name = MESA_FORMAT_R_UINT32,
      .StrName = "MESA_FORMAT_R_UINT32",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_RED,
      .DataType = GL_UNSIGNED_INT,
      .RedBits = 32, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 0, 4, 4, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(4, 0, 0, 0, 1, 0, 4, 4, 5),
   },
   {
      .Name = MESA_FORMAT_R_SINT8,
      .StrName = "MESA_FORMAT_R_SINT8",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_RED,
      .DataType = GL_INT,
      .RedBits = 8, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 1,
      .Swizzle = { 0, 4, 4, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 1, 0, 0, 1, 0, 4, 4, 5),
   },
   {
      .Name = MESA_FORMAT_R_SINT16,
      .StrName = "MESA_FORMAT_R_SINT16",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_RED,
      .DataType = GL_INT,
      .RedBits = 16, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 0, 4, 4, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(2, 1, 0, 0, 1, 0, 4, 4, 5),
   },
   {
      .Name = MESA_FORMAT_R_SINT32,
      .StrName = "MESA_FORMAT_R_SINT32",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_RED,
      .DataType = GL_INT,
      .RedBits = 32, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 0, 4, 4, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(4, 1, 0, 0, 1, 0, 4, 4, 5),
   },
   {
      .Name = MESA_FORMAT_RG_UINT8,
      .StrName = "MESA_FORMAT_RG_UINT8",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_RG,
      .DataType = GL_UNSIGNED_INT,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 0, 1, 4, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 0, 0, 0, 2, 0, 1, 4, 5),
   },
   {
      .Name = MESA_FORMAT_RG_UINT16,
      .StrName = "MESA_FORMAT_RG_UINT16",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_RG,
      .DataType = GL_UNSIGNED_INT,
      .RedBits = 16, .GreenBits = 16, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 0, 1, 4, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(2, 0, 0, 0, 2, 0, 1, 4, 5),
   },
   {
      .Name = MESA_FORMAT_RG_UINT32,
      .StrName = "MESA_FORMAT_RG_UINT32",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_RG,
      .DataType = GL_UNSIGNED_INT,
      .RedBits = 32, .GreenBits = 32, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 8,
      .Swizzle = { 0, 1, 4, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(4, 0, 0, 0, 2, 0, 1, 4, 5),
   },
   {
      .Name = MESA_FORMAT_RG_SINT8,
      .StrName = "MESA_FORMAT_RG_SINT8",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_RG,
      .DataType = GL_INT,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 2,
      .Swizzle = { 0, 1, 4, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 1, 0, 0, 2, 0, 1, 4, 5),
   },
   {
      .Name = MESA_FORMAT_RG_SINT16,
      .StrName = "MESA_FORMAT_RG_SINT16",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_RG,
      .DataType = GL_INT,
      .RedBits = 16, .GreenBits = 16, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 0, 1, 4, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(2, 1, 0, 0, 2, 0, 1, 4, 5),
   },
   {
      .Name = MESA_FORMAT_RG_SINT32,
      .StrName = "MESA_FORMAT_RG_SINT32",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_RG,
      .DataType = GL_INT,
      .RedBits = 32, .GreenBits = 32, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 8,
      .Swizzle = { 0, 1, 4, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(4, 1, 0, 0, 2, 0, 1, 4, 5),
   },
   {
      .Name = MESA_FORMAT_RGB_UINT8,
      .StrName = "MESA_FORMAT_RGB_UINT8",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_RGB,
      .DataType = GL_UNSIGNED_INT,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 3,
      .Swizzle = { 0, 1, 2, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 0, 0, 0, 3, 0, 1, 2, 5),
   },
   {
      .Name = MESA_FORMAT_RGB_UINT16,
      .StrName = "MESA_FORMAT_RGB_UINT16",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_RGB,
      .DataType = GL_UNSIGNED_INT,
      .RedBits = 16, .GreenBits = 16, .BlueBits = 16, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 6,
      .Swizzle = { 0, 1, 2, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(2, 0, 0, 0, 3, 0, 1, 2, 5),
   },
   {
      .Name = MESA_FORMAT_RGB_UINT32,
      .StrName = "MESA_FORMAT_RGB_UINT32",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_RGB,
      .DataType = GL_UNSIGNED_INT,
      .RedBits = 32, .GreenBits = 32, .BlueBits = 32, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 12,
      .Swizzle = { 0, 1, 2, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(4, 0, 0, 0, 3, 0, 1, 2, 5),
   },
   {
      .Name = MESA_FORMAT_RGB_SINT8,
      .StrName = "MESA_FORMAT_RGB_SINT8",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_RGB,
      .DataType = GL_INT,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 3,
      .Swizzle = { 0, 1, 2, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 1, 0, 0, 3, 0, 1, 2, 5),
   },
   {
      .Name = MESA_FORMAT_RGB_SINT16,
      .StrName = "MESA_FORMAT_RGB_SINT16",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_RGB,
      .DataType = GL_INT,
      .RedBits = 16, .GreenBits = 16, .BlueBits = 16, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 6,
      .Swizzle = { 0, 1, 2, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(2, 1, 0, 0, 3, 0, 1, 2, 5),
   },
   {
      .Name = MESA_FORMAT_RGB_SINT32,
      .StrName = "MESA_FORMAT_RGB_SINT32",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_RGB,
      .DataType = GL_INT,
      .RedBits = 32, .GreenBits = 32, .BlueBits = 32, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 12,
      .Swizzle = { 0, 1, 2, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(4, 1, 0, 0, 3, 0, 1, 2, 5),
   },
   {
      .Name = MESA_FORMAT_RGBA_UINT8,
      .StrName = "MESA_FORMAT_RGBA_UINT8",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_INT,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 8,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 0, 0, 0, 4, 0, 1, 2, 3),
   },
   {
      .Name = MESA_FORMAT_RGBA_UINT16,
      .StrName = "MESA_FORMAT_RGBA_UINT16",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_INT,
      .RedBits = 16, .GreenBits = 16, .BlueBits = 16, .AlphaBits = 16,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 8,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = MESA_ARRAY_FORMAT(2, 0, 0, 0, 4, 0, 1, 2, 3),
   },
   {
      .Name = MESA_FORMAT_RGBA_UINT32,
      .StrName = "MESA_FORMAT_RGBA_UINT32",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_INT,
      .RedBits = 32, .GreenBits = 32, .BlueBits = 32, .AlphaBits = 32,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = MESA_ARRAY_FORMAT(4, 0, 0, 0, 4, 0, 1, 2, 3),
   },
   {
      .Name = MESA_FORMAT_RGBA_SINT8,
      .StrName = "MESA_FORMAT_RGBA_SINT8",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_RGBA,
      .DataType = GL_INT,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 8,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 1, 0, 0, 4, 0, 1, 2, 3),
   },
   {
      .Name = MESA_FORMAT_RGBA_SINT16,
      .StrName = "MESA_FORMAT_RGBA_SINT16",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_RGBA,
      .DataType = GL_INT,
      .RedBits = 16, .GreenBits = 16, .BlueBits = 16, .AlphaBits = 16,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 8,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = MESA_ARRAY_FORMAT(2, 1, 0, 0, 4, 0, 1, 2, 3),
   },
   {
      .Name = MESA_FORMAT_RGBA_SINT32,
      .StrName = "MESA_FORMAT_RGBA_SINT32",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_RGBA,
      .DataType = GL_INT,
      .RedBits = 32, .GreenBits = 32, .BlueBits = 32, .AlphaBits = 32,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = MESA_ARRAY_FORMAT(4, 1, 0, 0, 4, 0, 1, 2, 3),
   },
   {
      .Name = MESA_FORMAT_RGBX_UINT8,
      .StrName = "MESA_FORMAT_RGBX_UINT8",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_RGB,
      .DataType = GL_UNSIGNED_INT,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 0, 1, 2, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 0, 0, 0, 4, 0, 1, 2, 5),
   },
   {
      .Name = MESA_FORMAT_RGBX_UINT16,
      .StrName = "MESA_FORMAT_RGBX_UINT16",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_RGB,
      .DataType = GL_UNSIGNED_INT,
      .RedBits = 16, .GreenBits = 16, .BlueBits = 16, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 8,
      .Swizzle = { 0, 1, 2, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(2, 0, 0, 0, 4, 0, 1, 2, 5),
   },
   {
      .Name = MESA_FORMAT_RGBX_UINT32,
      .StrName = "MESA_FORMAT_RGBX_UINT32",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_RGB,
      .DataType = GL_UNSIGNED_INT,
      .RedBits = 32, .GreenBits = 32, .BlueBits = 32, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(4, 0, 0, 0, 4, 0, 1, 2, 5),
   },
   {
      .Name = MESA_FORMAT_RGBX_SINT8,
      .StrName = "MESA_FORMAT_RGBX_SINT8",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_RGB,
      .DataType = GL_INT,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 4,
      .Swizzle = { 0, 1, 2, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(1, 1, 0, 0, 4, 0, 1, 2, 5),
   },
   {
      .Name = MESA_FORMAT_RGBX_SINT16,
      .StrName = "MESA_FORMAT_RGBX_SINT16",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_RGB,
      .DataType = GL_INT,
      .RedBits = 16, .GreenBits = 16, .BlueBits = 16, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 8,
      .Swizzle = { 0, 1, 2, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(2, 1, 0, 0, 4, 0, 1, 2, 5),
   },
   {
      .Name = MESA_FORMAT_RGBX_SINT32,
      .StrName = "MESA_FORMAT_RGBX_SINT32",
      .Layout = MESA_FORMAT_LAYOUT_ARRAY,
      .BaseFormat = GL_RGB,
      .DataType = GL_INT,
      .RedBits = 32, .GreenBits = 32, .BlueBits = 32, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 1, .BlockHeight = 1, .BlockDepth = 1,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 5 },
      .ArrayFormat = MESA_ARRAY_FORMAT(4, 1, 0, 0, 4, 0, 1, 2, 5),
   },
   {
      .Name = MESA_FORMAT_RGB_DXT1,
      .StrName = "MESA_FORMAT_RGB_DXT1",
      .Layout = MESA_FORMAT_LAYOUT_S3TC,
      .BaseFormat = GL_RGB,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 4, .GreenBits = 4, .BlueBits = 4, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 4, .BlockHeight = 4, .BlockDepth = 1,
      .BytesPerBlock = 8,
      .Swizzle = { 0, 1, 2, 5 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_RGBA_DXT1,
      .StrName = "MESA_FORMAT_RGBA_DXT1",
      .Layout = MESA_FORMAT_LAYOUT_S3TC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 4, .GreenBits = 4, .BlueBits = 4, .AlphaBits = 4,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 4, .BlockHeight = 4, .BlockDepth = 1,
      .BytesPerBlock = 8,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_RGBA_DXT3,
      .StrName = "MESA_FORMAT_RGBA_DXT3",
      .Layout = MESA_FORMAT_LAYOUT_S3TC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 4, .GreenBits = 4, .BlueBits = 4, .AlphaBits = 4,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 4, .BlockHeight = 4, .BlockDepth = 1,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_RGBA_DXT5,
      .StrName = "MESA_FORMAT_RGBA_DXT5",
      .Layout = MESA_FORMAT_LAYOUT_S3TC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 4, .GreenBits = 4, .BlueBits = 4, .AlphaBits = 4,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 4, .BlockHeight = 4, .BlockDepth = 1,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_SRGB_DXT1,
      .StrName = "MESA_FORMAT_SRGB_DXT1",
      .Layout = MESA_FORMAT_LAYOUT_S3TC,
      .BaseFormat = GL_RGB,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 4, .GreenBits = 4, .BlueBits = 4, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 1,
      .BlockWidth = 4, .BlockHeight = 4, .BlockDepth = 1,
      .BytesPerBlock = 8,
      .Swizzle = { 0, 1, 2, 5 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_SRGBA_DXT1,
      .StrName = "MESA_FORMAT_SRGBA_DXT1",
      .Layout = MESA_FORMAT_LAYOUT_S3TC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 4, .GreenBits = 4, .BlueBits = 4, .AlphaBits = 4,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 1,
      .BlockWidth = 4, .BlockHeight = 4, .BlockDepth = 1,
      .BytesPerBlock = 8,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_SRGBA_DXT3,
      .StrName = "MESA_FORMAT_SRGBA_DXT3",
      .Layout = MESA_FORMAT_LAYOUT_S3TC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 4, .GreenBits = 4, .BlueBits = 4, .AlphaBits = 4,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 1,
      .BlockWidth = 4, .BlockHeight = 4, .BlockDepth = 1,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_SRGBA_DXT5,
      .StrName = "MESA_FORMAT_SRGBA_DXT5",
      .Layout = MESA_FORMAT_LAYOUT_S3TC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 4, .GreenBits = 4, .BlueBits = 4, .AlphaBits = 4,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 1,
      .BlockWidth = 4, .BlockHeight = 4, .BlockDepth = 1,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_RGB_FXT1,
      .StrName = "MESA_FORMAT_RGB_FXT1",
      .Layout = MESA_FORMAT_LAYOUT_FXT1,
      .BaseFormat = GL_RGB,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 4, .GreenBits = 4, .BlueBits = 4, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 8, .BlockHeight = 4, .BlockDepth = 1,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 5 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_RGBA_FXT1,
      .StrName = "MESA_FORMAT_RGBA_FXT1",
      .Layout = MESA_FORMAT_LAYOUT_FXT1,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 4, .GreenBits = 4, .BlueBits = 4, .AlphaBits = 1,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 8, .BlockHeight = 4, .BlockDepth = 1,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_R_RGTC1_UNORM,
      .StrName = "MESA_FORMAT_R_RGTC1_UNORM",
      .Layout = MESA_FORMAT_LAYOUT_RGTC,
      .BaseFormat = GL_RED,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 4, .BlockHeight = 4, .BlockDepth = 1,
      .BytesPerBlock = 8,
      .Swizzle = { 0, 4, 4, 5 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_R_RGTC1_SNORM,
      .StrName = "MESA_FORMAT_R_RGTC1_SNORM",
      .Layout = MESA_FORMAT_LAYOUT_RGTC,
      .BaseFormat = GL_RED,
      .DataType = GL_SIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 4, .BlockHeight = 4, .BlockDepth = 1,
      .BytesPerBlock = 8,
      .Swizzle = { 0, 4, 4, 5 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_RG_RGTC2_UNORM,
      .StrName = "MESA_FORMAT_RG_RGTC2_UNORM",
      .Layout = MESA_FORMAT_LAYOUT_RGTC,
      .BaseFormat = GL_RG,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 4, .BlockHeight = 4, .BlockDepth = 1,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 4, 5 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_RG_RGTC2_SNORM,
      .StrName = "MESA_FORMAT_RG_RGTC2_SNORM",
      .Layout = MESA_FORMAT_LAYOUT_RGTC,
      .BaseFormat = GL_RG,
      .DataType = GL_SIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 4, .BlockHeight = 4, .BlockDepth = 1,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 4, 5 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_L_LATC1_UNORM,
      .StrName = "MESA_FORMAT_L_LATC1_UNORM",
      .Layout = MESA_FORMAT_LAYOUT_LATC,
      .BaseFormat = GL_LUMINANCE,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 8, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 4, .BlockHeight = 4, .BlockDepth = 1,
      .BytesPerBlock = 8,
      .Swizzle = { 0, 0, 0, 5 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_L_LATC1_SNORM,
      .StrName = "MESA_FORMAT_L_LATC1_SNORM",
      .Layout = MESA_FORMAT_LAYOUT_LATC,
      .BaseFormat = GL_LUMINANCE,
      .DataType = GL_SIGNED_NORMALIZED,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 8, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 4, .BlockHeight = 4, .BlockDepth = 1,
      .BytesPerBlock = 8,
      .Swizzle = { 0, 0, 0, 5 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_LA_LATC2_UNORM,
      .StrName = "MESA_FORMAT_LA_LATC2_UNORM",
      .Layout = MESA_FORMAT_LAYOUT_LATC,
      .BaseFormat = GL_LUMINANCE_ALPHA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 8,
      .LuminanceBits = 8, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 4, .BlockHeight = 4, .BlockDepth = 1,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 0, 0, 1 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_LA_LATC2_SNORM,
      .StrName = "MESA_FORMAT_LA_LATC2_SNORM",
      .Layout = MESA_FORMAT_LAYOUT_LATC,
      .BaseFormat = GL_LUMINANCE_ALPHA,
      .DataType = GL_SIGNED_NORMALIZED,
      .RedBits = 0, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 8,
      .LuminanceBits = 8, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 4, .BlockHeight = 4, .BlockDepth = 1,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 0, 0, 1 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_ETC1_RGB8,
      .StrName = "MESA_FORMAT_ETC1_RGB8",
      .Layout = MESA_FORMAT_LAYOUT_ETC1,
      .BaseFormat = GL_RGB,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 4, .BlockHeight = 4, .BlockDepth = 1,
      .BytesPerBlock = 8,
      .Swizzle = { 0, 1, 2, 5 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_ETC2_RGB8,
      .StrName = "MESA_FORMAT_ETC2_RGB8",
      .Layout = MESA_FORMAT_LAYOUT_ETC2,
      .BaseFormat = GL_RGB,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 4, .BlockHeight = 4, .BlockDepth = 1,
      .BytesPerBlock = 8,
      .Swizzle = { 0, 1, 2, 5 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_ETC2_SRGB8,
      .StrName = "MESA_FORMAT_ETC2_SRGB8",
      .Layout = MESA_FORMAT_LAYOUT_ETC2,
      .BaseFormat = GL_RGB,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 1,
      .BlockWidth = 4, .BlockHeight = 4, .BlockDepth = 1,
      .BytesPerBlock = 8,
      .Swizzle = { 0, 1, 2, 5 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_ETC2_RGBA8_EAC,
      .StrName = "MESA_FORMAT_ETC2_RGBA8_EAC",
      .Layout = MESA_FORMAT_LAYOUT_ETC2,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 8,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 4, .BlockHeight = 4, .BlockDepth = 1,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_ETC2_SRGB8_ALPHA8_EAC,
      .StrName = "MESA_FORMAT_ETC2_SRGB8_ALPHA8_EAC",
      .Layout = MESA_FORMAT_LAYOUT_ETC2,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 8,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 1,
      .BlockWidth = 4, .BlockHeight = 4, .BlockDepth = 1,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_ETC2_R11_EAC,
      .StrName = "MESA_FORMAT_ETC2_R11_EAC",
      .Layout = MESA_FORMAT_LAYOUT_ETC2,
      .BaseFormat = GL_RED,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 11, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 4, .BlockHeight = 4, .BlockDepth = 1,
      .BytesPerBlock = 8,
      .Swizzle = { 0, 4, 4, 5 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_ETC2_RG11_EAC,
      .StrName = "MESA_FORMAT_ETC2_RG11_EAC",
      .Layout = MESA_FORMAT_LAYOUT_ETC2,
      .BaseFormat = GL_RG,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 11, .GreenBits = 11, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 4, .BlockHeight = 4, .BlockDepth = 1,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 4, 5 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_ETC2_SIGNED_R11_EAC,
      .StrName = "MESA_FORMAT_ETC2_SIGNED_R11_EAC",
      .Layout = MESA_FORMAT_LAYOUT_ETC2,
      .BaseFormat = GL_RED,
      .DataType = GL_SIGNED_NORMALIZED,
      .RedBits = 11, .GreenBits = 0, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 4, .BlockHeight = 4, .BlockDepth = 1,
      .BytesPerBlock = 8,
      .Swizzle = { 0, 4, 4, 5 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_ETC2_SIGNED_RG11_EAC,
      .StrName = "MESA_FORMAT_ETC2_SIGNED_RG11_EAC",
      .Layout = MESA_FORMAT_LAYOUT_ETC2,
      .BaseFormat = GL_RG,
      .DataType = GL_SIGNED_NORMALIZED,
      .RedBits = 11, .GreenBits = 11, .BlueBits = 0, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 4, .BlockHeight = 4, .BlockDepth = 1,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 4, 5 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_ETC2_RGB8_PUNCHTHROUGH_ALPHA1,
      .StrName = "MESA_FORMAT_ETC2_RGB8_PUNCHTHROUGH_ALPHA1",
      .Layout = MESA_FORMAT_LAYOUT_ETC2,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 1,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 4, .BlockHeight = 4, .BlockDepth = 1,
      .BytesPerBlock = 8,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_ETC2_SRGB8_PUNCHTHROUGH_ALPHA1,
      .StrName = "MESA_FORMAT_ETC2_SRGB8_PUNCHTHROUGH_ALPHA1",
      .Layout = MESA_FORMAT_LAYOUT_ETC2,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 1,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 1,
      .BlockWidth = 4, .BlockHeight = 4, .BlockDepth = 1,
      .BytesPerBlock = 8,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_BPTC_RGBA_UNORM,
      .StrName = "MESA_FORMAT_BPTC_RGBA_UNORM",
      .Layout = MESA_FORMAT_LAYOUT_BPTC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 8,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 4, .BlockHeight = 4, .BlockDepth = 1,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_BPTC_SRGB_ALPHA_UNORM,
      .StrName = "MESA_FORMAT_BPTC_SRGB_ALPHA_UNORM",
      .Layout = MESA_FORMAT_LAYOUT_BPTC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 8,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 1,
      .BlockWidth = 4, .BlockHeight = 4, .BlockDepth = 1,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_BPTC_RGB_SIGNED_FLOAT,
      .StrName = "MESA_FORMAT_BPTC_RGB_SIGNED_FLOAT",
      .Layout = MESA_FORMAT_LAYOUT_BPTC,
      .BaseFormat = GL_RGB,
      .DataType = GL_FLOAT,
      .RedBits = 16, .GreenBits = 16, .BlueBits = 16, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 4, .BlockHeight = 4, .BlockDepth = 1,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 5 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_BPTC_RGB_UNSIGNED_FLOAT,
      .StrName = "MESA_FORMAT_BPTC_RGB_UNSIGNED_FLOAT",
      .Layout = MESA_FORMAT_LAYOUT_BPTC,
      .BaseFormat = GL_RGB,
      .DataType = GL_FLOAT,
      .RedBits = 16, .GreenBits = 16, .BlueBits = 16, .AlphaBits = 0,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 4, .BlockHeight = 4, .BlockDepth = 1,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 5 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_RGBA_ASTC_4x4,
      .StrName = "MESA_FORMAT_RGBA_ASTC_4x4",
      .Layout = MESA_FORMAT_LAYOUT_ASTC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 16, .GreenBits = 16, .BlueBits = 16, .AlphaBits = 16,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 4, .BlockHeight = 4, .BlockDepth = 1,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_RGBA_ASTC_5x4,
      .StrName = "MESA_FORMAT_RGBA_ASTC_5x4",
      .Layout = MESA_FORMAT_LAYOUT_ASTC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 16, .GreenBits = 16, .BlueBits = 16, .AlphaBits = 16,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 5, .BlockHeight = 4, .BlockDepth = 1,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_RGBA_ASTC_5x5,
      .StrName = "MESA_FORMAT_RGBA_ASTC_5x5",
      .Layout = MESA_FORMAT_LAYOUT_ASTC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 16, .GreenBits = 16, .BlueBits = 16, .AlphaBits = 16,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 5, .BlockHeight = 5, .BlockDepth = 1,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_RGBA_ASTC_6x5,
      .StrName = "MESA_FORMAT_RGBA_ASTC_6x5",
      .Layout = MESA_FORMAT_LAYOUT_ASTC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 16, .GreenBits = 16, .BlueBits = 16, .AlphaBits = 16,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 6, .BlockHeight = 5, .BlockDepth = 1,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_RGBA_ASTC_6x6,
      .StrName = "MESA_FORMAT_RGBA_ASTC_6x6",
      .Layout = MESA_FORMAT_LAYOUT_ASTC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 16, .GreenBits = 16, .BlueBits = 16, .AlphaBits = 16,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 6, .BlockHeight = 6, .BlockDepth = 1,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_RGBA_ASTC_8x5,
      .StrName = "MESA_FORMAT_RGBA_ASTC_8x5",
      .Layout = MESA_FORMAT_LAYOUT_ASTC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 16, .GreenBits = 16, .BlueBits = 16, .AlphaBits = 16,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 8, .BlockHeight = 5, .BlockDepth = 1,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_RGBA_ASTC_8x6,
      .StrName = "MESA_FORMAT_RGBA_ASTC_8x6",
      .Layout = MESA_FORMAT_LAYOUT_ASTC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 16, .GreenBits = 16, .BlueBits = 16, .AlphaBits = 16,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 8, .BlockHeight = 6, .BlockDepth = 1,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_RGBA_ASTC_8x8,
      .StrName = "MESA_FORMAT_RGBA_ASTC_8x8",
      .Layout = MESA_FORMAT_LAYOUT_ASTC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 16, .GreenBits = 16, .BlueBits = 16, .AlphaBits = 16,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 8, .BlockHeight = 8, .BlockDepth = 1,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_RGBA_ASTC_10x5,
      .StrName = "MESA_FORMAT_RGBA_ASTC_10x5",
      .Layout = MESA_FORMAT_LAYOUT_ASTC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 16, .GreenBits = 16, .BlueBits = 16, .AlphaBits = 16,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 10, .BlockHeight = 5, .BlockDepth = 1,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_RGBA_ASTC_10x6,
      .StrName = "MESA_FORMAT_RGBA_ASTC_10x6",
      .Layout = MESA_FORMAT_LAYOUT_ASTC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 16, .GreenBits = 16, .BlueBits = 16, .AlphaBits = 16,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 10, .BlockHeight = 6, .BlockDepth = 1,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_RGBA_ASTC_10x8,
      .StrName = "MESA_FORMAT_RGBA_ASTC_10x8",
      .Layout = MESA_FORMAT_LAYOUT_ASTC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 16, .GreenBits = 16, .BlueBits = 16, .AlphaBits = 16,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 10, .BlockHeight = 8, .BlockDepth = 1,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_RGBA_ASTC_10x10,
      .StrName = "MESA_FORMAT_RGBA_ASTC_10x10",
      .Layout = MESA_FORMAT_LAYOUT_ASTC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 16, .GreenBits = 16, .BlueBits = 16, .AlphaBits = 16,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 10, .BlockHeight = 10, .BlockDepth = 1,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_RGBA_ASTC_12x10,
      .StrName = "MESA_FORMAT_RGBA_ASTC_12x10",
      .Layout = MESA_FORMAT_LAYOUT_ASTC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 16, .GreenBits = 16, .BlueBits = 16, .AlphaBits = 16,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 12, .BlockHeight = 10, .BlockDepth = 1,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_RGBA_ASTC_12x12,
      .StrName = "MESA_FORMAT_RGBA_ASTC_12x12",
      .Layout = MESA_FORMAT_LAYOUT_ASTC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 16, .GreenBits = 16, .BlueBits = 16, .AlphaBits = 16,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 12, .BlockHeight = 12, .BlockDepth = 1,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_SRGB8_ALPHA8_ASTC_4x4,
      .StrName = "MESA_FORMAT_SRGB8_ALPHA8_ASTC_4x4",
      .Layout = MESA_FORMAT_LAYOUT_ASTC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 8,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 1,
      .BlockWidth = 4, .BlockHeight = 4, .BlockDepth = 1,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_SRGB8_ALPHA8_ASTC_5x4,
      .StrName = "MESA_FORMAT_SRGB8_ALPHA8_ASTC_5x4",
      .Layout = MESA_FORMAT_LAYOUT_ASTC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 8,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 1,
      .BlockWidth = 5, .BlockHeight = 4, .BlockDepth = 1,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_SRGB8_ALPHA8_ASTC_5x5,
      .StrName = "MESA_FORMAT_SRGB8_ALPHA8_ASTC_5x5",
      .Layout = MESA_FORMAT_LAYOUT_ASTC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 8,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 1,
      .BlockWidth = 5, .BlockHeight = 5, .BlockDepth = 1,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_SRGB8_ALPHA8_ASTC_6x5,
      .StrName = "MESA_FORMAT_SRGB8_ALPHA8_ASTC_6x5",
      .Layout = MESA_FORMAT_LAYOUT_ASTC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 8,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 1,
      .BlockWidth = 6, .BlockHeight = 5, .BlockDepth = 1,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_SRGB8_ALPHA8_ASTC_6x6,
      .StrName = "MESA_FORMAT_SRGB8_ALPHA8_ASTC_6x6",
      .Layout = MESA_FORMAT_LAYOUT_ASTC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 8,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 1,
      .BlockWidth = 6, .BlockHeight = 6, .BlockDepth = 1,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_SRGB8_ALPHA8_ASTC_8x5,
      .StrName = "MESA_FORMAT_SRGB8_ALPHA8_ASTC_8x5",
      .Layout = MESA_FORMAT_LAYOUT_ASTC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 8,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 1,
      .BlockWidth = 8, .BlockHeight = 5, .BlockDepth = 1,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_SRGB8_ALPHA8_ASTC_8x6,
      .StrName = "MESA_FORMAT_SRGB8_ALPHA8_ASTC_8x6",
      .Layout = MESA_FORMAT_LAYOUT_ASTC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 8,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 1,
      .BlockWidth = 8, .BlockHeight = 6, .BlockDepth = 1,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_SRGB8_ALPHA8_ASTC_8x8,
      .StrName = "MESA_FORMAT_SRGB8_ALPHA8_ASTC_8x8",
      .Layout = MESA_FORMAT_LAYOUT_ASTC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 8,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 1,
      .BlockWidth = 8, .BlockHeight = 8, .BlockDepth = 1,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_SRGB8_ALPHA8_ASTC_10x5,
      .StrName = "MESA_FORMAT_SRGB8_ALPHA8_ASTC_10x5",
      .Layout = MESA_FORMAT_LAYOUT_ASTC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 8,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 1,
      .BlockWidth = 10, .BlockHeight = 5, .BlockDepth = 1,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_SRGB8_ALPHA8_ASTC_10x6,
      .StrName = "MESA_FORMAT_SRGB8_ALPHA8_ASTC_10x6",
      .Layout = MESA_FORMAT_LAYOUT_ASTC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 8,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 1,
      .BlockWidth = 10, .BlockHeight = 6, .BlockDepth = 1,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_SRGB8_ALPHA8_ASTC_10x8,
      .StrName = "MESA_FORMAT_SRGB8_ALPHA8_ASTC_10x8",
      .Layout = MESA_FORMAT_LAYOUT_ASTC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 8,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 1,
      .BlockWidth = 10, .BlockHeight = 8, .BlockDepth = 1,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_SRGB8_ALPHA8_ASTC_10x10,
      .StrName = "MESA_FORMAT_SRGB8_ALPHA8_ASTC_10x10",
      .Layout = MESA_FORMAT_LAYOUT_ASTC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 8,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 1,
      .BlockWidth = 10, .BlockHeight = 10, .BlockDepth = 1,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_SRGB8_ALPHA8_ASTC_12x10,
      .StrName = "MESA_FORMAT_SRGB8_ALPHA8_ASTC_12x10",
      .Layout = MESA_FORMAT_LAYOUT_ASTC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 8,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 1,
      .BlockWidth = 12, .BlockHeight = 10, .BlockDepth = 1,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_SRGB8_ALPHA8_ASTC_12x12,
      .StrName = "MESA_FORMAT_SRGB8_ALPHA8_ASTC_12x12",
      .Layout = MESA_FORMAT_LAYOUT_ASTC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 8,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 1,
      .BlockWidth = 12, .BlockHeight = 12, .BlockDepth = 1,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_RGBA_ASTC_3x3x3,
      .StrName = "MESA_FORMAT_RGBA_ASTC_3x3x3",
      .Layout = MESA_FORMAT_LAYOUT_ASTC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 16, .GreenBits = 16, .BlueBits = 16, .AlphaBits = 16,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 3, .BlockHeight = 3, .BlockDepth = 3,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_RGBA_ASTC_4x3x3,
      .StrName = "MESA_FORMAT_RGBA_ASTC_4x3x3",
      .Layout = MESA_FORMAT_LAYOUT_ASTC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 16, .GreenBits = 16, .BlueBits = 16, .AlphaBits = 16,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 4, .BlockHeight = 3, .BlockDepth = 3,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_RGBA_ASTC_4x4x3,
      .StrName = "MESA_FORMAT_RGBA_ASTC_4x4x3",
      .Layout = MESA_FORMAT_LAYOUT_ASTC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 16, .GreenBits = 16, .BlueBits = 16, .AlphaBits = 16,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 4, .BlockHeight = 4, .BlockDepth = 3,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_RGBA_ASTC_4x4x4,
      .StrName = "MESA_FORMAT_RGBA_ASTC_4x4x4",
      .Layout = MESA_FORMAT_LAYOUT_ASTC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 16, .GreenBits = 16, .BlueBits = 16, .AlphaBits = 16,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 4, .BlockHeight = 4, .BlockDepth = 4,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_RGBA_ASTC_5x4x4,
      .StrName = "MESA_FORMAT_RGBA_ASTC_5x4x4",
      .Layout = MESA_FORMAT_LAYOUT_ASTC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 16, .GreenBits = 16, .BlueBits = 16, .AlphaBits = 16,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 5, .BlockHeight = 4, .BlockDepth = 4,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_RGBA_ASTC_5x5x4,
      .StrName = "MESA_FORMAT_RGBA_ASTC_5x5x4",
      .Layout = MESA_FORMAT_LAYOUT_ASTC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 16, .GreenBits = 16, .BlueBits = 16, .AlphaBits = 16,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 5, .BlockHeight = 5, .BlockDepth = 4,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_RGBA_ASTC_5x5x5,
      .StrName = "MESA_FORMAT_RGBA_ASTC_5x5x5",
      .Layout = MESA_FORMAT_LAYOUT_ASTC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 16, .GreenBits = 16, .BlueBits = 16, .AlphaBits = 16,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 5, .BlockHeight = 5, .BlockDepth = 5,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_RGBA_ASTC_6x5x5,
      .StrName = "MESA_FORMAT_RGBA_ASTC_6x5x5",
      .Layout = MESA_FORMAT_LAYOUT_ASTC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 16, .GreenBits = 16, .BlueBits = 16, .AlphaBits = 16,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 6, .BlockHeight = 5, .BlockDepth = 5,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_RGBA_ASTC_6x6x5,
      .StrName = "MESA_FORMAT_RGBA_ASTC_6x6x5",
      .Layout = MESA_FORMAT_LAYOUT_ASTC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 16, .GreenBits = 16, .BlueBits = 16, .AlphaBits = 16,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 6, .BlockHeight = 6, .BlockDepth = 5,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_RGBA_ASTC_6x6x6,
      .StrName = "MESA_FORMAT_RGBA_ASTC_6x6x6",
      .Layout = MESA_FORMAT_LAYOUT_ASTC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 16, .GreenBits = 16, .BlueBits = 16, .AlphaBits = 16,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 0,
      .BlockWidth = 6, .BlockHeight = 6, .BlockDepth = 6,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_SRGB8_ALPHA8_ASTC_3x3x3,
      .StrName = "MESA_FORMAT_SRGB8_ALPHA8_ASTC_3x3x3",
      .Layout = MESA_FORMAT_LAYOUT_ASTC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 8,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 1,
      .BlockWidth = 3, .BlockHeight = 3, .BlockDepth = 3,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_SRGB8_ALPHA8_ASTC_4x3x3,
      .StrName = "MESA_FORMAT_SRGB8_ALPHA8_ASTC_4x3x3",
      .Layout = MESA_FORMAT_LAYOUT_ASTC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 8,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 1,
      .BlockWidth = 4, .BlockHeight = 3, .BlockDepth = 3,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_SRGB8_ALPHA8_ASTC_4x4x3,
      .StrName = "MESA_FORMAT_SRGB8_ALPHA8_ASTC_4x4x3",
      .Layout = MESA_FORMAT_LAYOUT_ASTC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 8,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 1,
      .BlockWidth = 4, .BlockHeight = 4, .BlockDepth = 3,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_SRGB8_ALPHA8_ASTC_4x4x4,
      .StrName = "MESA_FORMAT_SRGB8_ALPHA8_ASTC_4x4x4",
      .Layout = MESA_FORMAT_LAYOUT_ASTC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 8,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 1,
      .BlockWidth = 4, .BlockHeight = 4, .BlockDepth = 4,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_SRGB8_ALPHA8_ASTC_5x4x4,
      .StrName = "MESA_FORMAT_SRGB8_ALPHA8_ASTC_5x4x4",
      .Layout = MESA_FORMAT_LAYOUT_ASTC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 8,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 1,
      .BlockWidth = 5, .BlockHeight = 4, .BlockDepth = 4,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_SRGB8_ALPHA8_ASTC_5x5x4,
      .StrName = "MESA_FORMAT_SRGB8_ALPHA8_ASTC_5x5x4",
      .Layout = MESA_FORMAT_LAYOUT_ASTC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 8,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 1,
      .BlockWidth = 5, .BlockHeight = 5, .BlockDepth = 4,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_SRGB8_ALPHA8_ASTC_5x5x5,
      .StrName = "MESA_FORMAT_SRGB8_ALPHA8_ASTC_5x5x5",
      .Layout = MESA_FORMAT_LAYOUT_ASTC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 8,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 1,
      .BlockWidth = 5, .BlockHeight = 5, .BlockDepth = 5,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_SRGB8_ALPHA8_ASTC_6x5x5,
      .StrName = "MESA_FORMAT_SRGB8_ALPHA8_ASTC_6x5x5",
      .Layout = MESA_FORMAT_LAYOUT_ASTC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 8,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 1,
      .BlockWidth = 6, .BlockHeight = 5, .BlockDepth = 5,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_SRGB8_ALPHA8_ASTC_6x6x5,
      .StrName = "MESA_FORMAT_SRGB8_ALPHA8_ASTC_6x6x5",
      .Layout = MESA_FORMAT_LAYOUT_ASTC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 8,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 1,
      .BlockWidth = 6, .BlockHeight = 6, .BlockDepth = 5,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
   {
      .Name = MESA_FORMAT_SRGB8_ALPHA8_ASTC_6x6x6,
      .StrName = "MESA_FORMAT_SRGB8_ALPHA8_ASTC_6x6x6",
      .Layout = MESA_FORMAT_LAYOUT_ASTC,
      .BaseFormat = GL_RGBA,
      .DataType = GL_UNSIGNED_NORMALIZED,
      .RedBits = 8, .GreenBits = 8, .BlueBits = 8, .AlphaBits = 8,
      .LuminanceBits = 0, .IntensityBits = 0, .DepthBits = 0, .StencilBits = 0,
      .IsSRGBFormat = 1,
      .BlockWidth = 6, .BlockHeight = 6, .BlockDepth = 6,
      .BytesPerBlock = 16,
      .Swizzle = { 0, 1, 2, 3 },
      .ArrayFormat = 0,
   },
};
