// Copyright 2012-2015 The Rust Project Developers. See the COPYRIGHT
// file at the top-level directory of this distribution and at
// http://rust-lang.org/COPYRIGHT.
//
// Licensed under the Apache License, Version 2.0 <LICENSE-APACHE or
// http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your
// option. This file may not be copied, modified, or distributed
// except according to those terms.

// NOTE: The following code was generated by "scripts/unicode.py", do not edit directly

#![allow(missing_docs, non_upper_case_globals, non_snake_case)]

/// The version of [Unicode](http://www.unicode.org/)
/// that this version of unicode-normalization is based on.
pub const UNICODE_VERSION: (u64, u64, u64) = (9, 0, 0);

pub mod normalization {

pub struct Slice {
  pub offset: u16,
  pub length: u16,
}
    // Canonical decompositions
    pub  const canonical_table: &'static [(char, Slice)] = &[
        ('\u{c0}', Slice { offset: 0, length: 2 }),
        ('\u{c1}', Slice { offset: 2, length: 2 }),
        ('\u{c2}', Slice { offset: 4, length: 2 }),
        ('\u{c3}', Slice { offset: 6, length: 2 }),
        ('\u{c4}', Slice { offset: 8, length: 2 }),
        ('\u{c5}', Slice { offset: 10, length: 2 }),
        ('\u{c7}', Slice { offset: 12, length: 2 }),
        ('\u{c8}', Slice { offset: 14, length: 2 }),
        ('\u{c9}', Slice { offset: 16, length: 2 }),
        ('\u{ca}', Slice { offset: 18, length: 2 }),
        ('\u{cb}', Slice { offset: 20, length: 2 }),
        ('\u{cc}', Slice { offset: 22, length: 2 }),
        ('\u{cd}', Slice { offset: 24, length: 2 }),
        ('\u{ce}', Slice { offset: 26, length: 2 }),
        ('\u{cf}', Slice { offset: 28, length: 2 }),
        ('\u{d1}', Slice { offset: 30, length: 2 }),
        ('\u{d2}', Slice { offset: 32, length: 2 }),
        ('\u{d3}', Slice { offset: 34, length: 2 }),
        ('\u{d4}', Slice { offset: 36, length: 2 }),
        ('\u{d5}', Slice { offset: 38, length: 2 }),
        ('\u{d6}', Slice { offset: 40, length: 2 }),
        ('\u{d9}', Slice { offset: 42, length: 2 }),
        ('\u{da}', Slice { offset: 44, length: 2 }),
        ('\u{db}', Slice { offset: 46, length: 2 }),
        ('\u{dc}', Slice { offset: 48, length: 2 }),
        ('\u{dd}', Slice { offset: 50, length: 2 }),
        ('\u{e0}', Slice { offset: 52, length: 2 }),
        ('\u{e1}', Slice { offset: 54, length: 2 }),
        ('\u{e2}', Slice { offset: 56, length: 2 }),
        ('\u{e3}', Slice { offset: 58, length: 2 }),
        ('\u{e4}', Slice { offset: 60, length: 2 }),
        ('\u{e5}', Slice { offset: 62, length: 2 }),
        ('\u{e7}', Slice { offset: 64, length: 2 }),
        ('\u{e8}', Slice { offset: 66, length: 2 }),
        ('\u{e9}', Slice { offset: 68, length: 2 }),
        ('\u{ea}', Slice { offset: 70, length: 2 }),
        ('\u{eb}', Slice { offset: 72, length: 2 }),
        ('\u{ec}', Slice { offset: 74, length: 2 }),
        ('\u{ed}', Slice { offset: 76, length: 2 }),
        ('\u{ee}', Slice { offset: 78, length: 2 }),
        ('\u{ef}', Slice { offset: 80, length: 2 }),
        ('\u{f1}', Slice { offset: 82, length: 2 }),
        ('\u{f2}', Slice { offset: 84, length: 2 }),
        ('\u{f3}', Slice { offset: 86, length: 2 }),
        ('\u{f4}', Slice { offset: 88, length: 2 }),
        ('\u{f5}', Slice { offset: 90, length: 2 }),
        ('\u{f6}', Slice { offset: 92, length: 2 }),
        ('\u{f9}', Slice { offset: 94, length: 2 }),
        ('\u{fa}', Slice { offset: 96, length: 2 }),
        ('\u{fb}', Slice { offset: 98, length: 2 }),
        ('\u{fc}', Slice { offset: 100, length: 2 }),
        ('\u{fd}', Slice { offset: 102, length: 2 }),
        ('\u{ff}', Slice { offset: 104, length: 2 }),
        ('\u{100}', Slice { offset: 106, length: 2 }),
        ('\u{101}', Slice { offset: 108, length: 2 }),
        ('\u{102}', Slice { offset: 110, length: 2 }),
        ('\u{103}', Slice { offset: 112, length: 2 }),
        ('\u{104}', Slice { offset: 114, length: 2 }),
        ('\u{105}', Slice { offset: 116, length: 2 }),
        ('\u{106}', Slice { offset: 118, length: 2 }),
        ('\u{107}', Slice { offset: 120, length: 2 }),
        ('\u{108}', Slice { offset: 122, length: 2 }),
        ('\u{109}', Slice { offset: 124, length: 2 }),
        ('\u{10a}', Slice { offset: 126, length: 2 }),
        ('\u{10b}', Slice { offset: 128, length: 2 }),
        ('\u{10c}', Slice { offset: 130, length: 2 }),
        ('\u{10d}', Slice { offset: 132, length: 2 }),
        ('\u{10e}', Slice { offset: 134, length: 2 }),
        ('\u{10f}', Slice { offset: 136, length: 2 }),
        ('\u{112}', Slice { offset: 138, length: 2 }),
        ('\u{113}', Slice { offset: 140, length: 2 }),
        ('\u{114}', Slice { offset: 142, length: 2 }),
        ('\u{115}', Slice { offset: 144, length: 2 }),
        ('\u{116}', Slice { offset: 146, length: 2 }),
        ('\u{117}', Slice { offset: 148, length: 2 }),
        ('\u{118}', Slice { offset: 150, length: 2 }),
        ('\u{119}', Slice { offset: 152, length: 2 }),
        ('\u{11a}', Slice { offset: 154, length: 2 }),
        ('\u{11b}', Slice { offset: 156, length: 2 }),
        ('\u{11c}', Slice { offset: 158, length: 2 }),
        ('\u{11d}', Slice { offset: 160, length: 2 }),
        ('\u{11e}', Slice { offset: 162, length: 2 }),
        ('\u{11f}', Slice { offset: 164, length: 2 }),
        ('\u{120}', Slice { offset: 166, length: 2 }),
        ('\u{121}', Slice { offset: 168, length: 2 }),
        ('\u{122}', Slice { offset: 170, length: 2 }),
        ('\u{123}', Slice { offset: 172, length: 2 }),
        ('\u{124}', Slice { offset: 174, length: 2 }),
        ('\u{125}', Slice { offset: 176, length: 2 }),
        ('\u{128}', Slice { offset: 178, length: 2 }),
        ('\u{129}', Slice { offset: 180, length: 2 }),
        ('\u{12a}', Slice { offset: 182, length: 2 }),
        ('\u{12b}', Slice { offset: 184, length: 2 }),
        ('\u{12c}', Slice { offset: 186, length: 2 }),
        ('\u{12d}', Slice { offset: 188, length: 2 }),
        ('\u{12e}', Slice { offset: 190, length: 2 }),
        ('\u{12f}', Slice { offset: 192, length: 2 }),
        ('\u{130}', Slice { offset: 194, length: 2 }),
        ('\u{134}', Slice { offset: 196, length: 2 }),
        ('\u{135}', Slice { offset: 198, length: 2 }),
        ('\u{136}', Slice { offset: 200, length: 2 }),
        ('\u{137}', Slice { offset: 202, length: 2 }),
        ('\u{139}', Slice { offset: 204, length: 2 }),
        ('\u{13a}', Slice { offset: 206, length: 2 }),
        ('\u{13b}', Slice { offset: 208, length: 2 }),
        ('\u{13c}', Slice { offset: 210, length: 2 }),
        ('\u{13d}', Slice { offset: 212, length: 2 }),
        ('\u{13e}', Slice { offset: 214, length: 2 }),
        ('\u{143}', Slice { offset: 216, length: 2 }),
        ('\u{144}', Slice { offset: 218, length: 2 }),
        ('\u{145}', Slice { offset: 220, length: 2 }),
        ('\u{146}', Slice { offset: 222, length: 2 }),
        ('\u{147}', Slice { offset: 224, length: 2 }),
        ('\u{148}', Slice { offset: 226, length: 2 }),
        ('\u{14c}', Slice { offset: 228, length: 2 }),
        ('\u{14d}', Slice { offset: 230, length: 2 }),
        ('\u{14e}', Slice { offset: 232, length: 2 }),
        ('\u{14f}', Slice { offset: 234, length: 2 }),
        ('\u{150}', Slice { offset: 236, length: 2 }),
        ('\u{151}', Slice { offset: 238, length: 2 }),
        ('\u{154}', Slice { offset: 240, length: 2 }),
        ('\u{155}', Slice { offset: 242, length: 2 }),
        ('\u{156}', Slice { offset: 244, length: 2 }),
        ('\u{157}', Slice { offset: 246, length: 2 }),
        ('\u{158}', Slice { offset: 248, length: 2 }),
        ('\u{159}', Slice { offset: 250, length: 2 }),
        ('\u{15a}', Slice { offset: 252, length: 2 }),
        ('\u{15b}', Slice { offset: 254, length: 2 }),
        ('\u{15c}', Slice { offset: 256, length: 2 }),
        ('\u{15d}', Slice { offset: 258, length: 2 }),
        ('\u{15e}', Slice { offset: 260, length: 2 }),
        ('\u{15f}', Slice { offset: 262, length: 2 }),
        ('\u{160}', Slice { offset: 264, length: 2 }),
        ('\u{161}', Slice { offset: 266, length: 2 }),
        ('\u{162}', Slice { offset: 268, length: 2 }),
        ('\u{163}', Slice { offset: 270, length: 2 }),
        ('\u{164}', Slice { offset: 272, length: 2 }),
        ('\u{165}', Slice { offset: 274, length: 2 }),
        ('\u{168}', Slice { offset: 276, length: 2 }),
        ('\u{169}', Slice { offset: 278, length: 2 }),
        ('\u{16a}', Slice { offset: 280, length: 2 }),
        ('\u{16b}', Slice { offset: 282, length: 2 }),
        ('\u{16c}', Slice { offset: 284, length: 2 }),
        ('\u{16d}', Slice { offset: 286, length: 2 }),
        ('\u{16e}', Slice { offset: 288, length: 2 }),
        ('\u{16f}', Slice { offset: 290, length: 2 }),
        ('\u{170}', Slice { offset: 292, length: 2 }),
        ('\u{171}', Slice { offset: 294, length: 2 }),
        ('\u{172}', Slice { offset: 296, length: 2 }),
        ('\u{173}', Slice { offset: 298, length: 2 }),
        ('\u{174}', Slice { offset: 300, length: 2 }),
        ('\u{175}', Slice { offset: 302, length: 2 }),
        ('\u{176}', Slice { offset: 304, length: 2 }),
        ('\u{177}', Slice { offset: 306, length: 2 }),
        ('\u{178}', Slice { offset: 308, length: 2 }),
        ('\u{179}', Slice { offset: 310, length: 2 }),
        ('\u{17a}', Slice { offset: 312, length: 2 }),
        ('\u{17b}', Slice { offset: 314, length: 2 }),
        ('\u{17c}', Slice { offset: 316, length: 2 }),
        ('\u{17d}', Slice { offset: 318, length: 2 }),
        ('\u{17e}', Slice { offset: 320, length: 2 }),
        ('\u{1a0}', Slice { offset: 322, length: 2 }),
        ('\u{1a1}', Slice { offset: 324, length: 2 }),
        ('\u{1af}', Slice { offset: 326, length: 2 }),
        ('\u{1b0}', Slice { offset: 328, length: 2 }),
        ('\u{1cd}', Slice { offset: 330, length: 2 }),
        ('\u{1ce}', Slice { offset: 332, length: 2 }),
        ('\u{1cf}', Slice { offset: 334, length: 2 }),
        ('\u{1d0}', Slice { offset: 336, length: 2 }),
        ('\u{1d1}', Slice { offset: 338, length: 2 }),
        ('\u{1d2}', Slice { offset: 340, length: 2 }),
        ('\u{1d3}', Slice { offset: 342, length: 2 }),
        ('\u{1d4}', Slice { offset: 344, length: 2 }),
        ('\u{1d5}', Slice { offset: 346, length: 2 }),
        ('\u{1d6}', Slice { offset: 348, length: 2 }),
        ('\u{1d7}', Slice { offset: 350, length: 2 }),
        ('\u{1d8}', Slice { offset: 352, length: 2 }),
        ('\u{1d9}', Slice { offset: 354, length: 2 }),
        ('\u{1da}', Slice { offset: 356, length: 2 }),
        ('\u{1db}', Slice { offset: 358, length: 2 }),
        ('\u{1dc}', Slice { offset: 360, length: 2 }),
        ('\u{1de}', Slice { offset: 362, length: 2 }),
        ('\u{1df}', Slice { offset: 364, length: 2 }),
        ('\u{1e0}', Slice { offset: 366, length: 2 }),
        ('\u{1e1}', Slice { offset: 368, length: 2 }),
        ('\u{1e2}', Slice { offset: 370, length: 2 }),
        ('\u{1e3}', Slice { offset: 372, length: 2 }),
        ('\u{1e6}', Slice { offset: 374, length: 2 }),
        ('\u{1e7}', Slice { offset: 376, length: 2 }),
        ('\u{1e8}', Slice { offset: 378, length: 2 }),
        ('\u{1e9}', Slice { offset: 380, length: 2 }),
        ('\u{1ea}', Slice { offset: 382, length: 2 }),
        ('\u{1eb}', Slice { offset: 384, length: 2 }),
        ('\u{1ec}', Slice { offset: 386, length: 2 }),
        ('\u{1ed}', Slice { offset: 388, length: 2 }),
        ('\u{1ee}', Slice { offset: 390, length: 2 }),
        ('\u{1ef}', Slice { offset: 392, length: 2 }),
        ('\u{1f0}', Slice { offset: 394, length: 2 }),
        ('\u{1f4}', Slice { offset: 396, length: 2 }),
        ('\u{1f5}', Slice { offset: 398, length: 2 }),
        ('\u{1f8}', Slice { offset: 400, length: 2 }),
        ('\u{1f9}', Slice { offset: 402, length: 2 }),
        ('\u{1fa}', Slice { offset: 404, length: 2 }),
        ('\u{1fb}', Slice { offset: 406, length: 2 }),
        ('\u{1fc}', Slice { offset: 408, length: 2 }),
        ('\u{1fd}', Slice { offset: 410, length: 2 }),
        ('\u{1fe}', Slice { offset: 412, length: 2 }),
        ('\u{1ff}', Slice { offset: 414, length: 2 }),
        ('\u{200}', Slice { offset: 416, length: 2 }),
        ('\u{201}', Slice { offset: 418, length: 2 }),
        ('\u{202}', Slice { offset: 420, length: 2 }),
        ('\u{203}', Slice { offset: 422, length: 2 }),
        ('\u{204}', Slice { offset: 424, length: 2 }),
        ('\u{205}', Slice { offset: 426, length: 2 }),
        ('\u{206}', Slice { offset: 428, length: 2 }),
        ('\u{207}', Slice { offset: 430, length: 2 }),
        ('\u{208}', Slice { offset: 432, length: 2 }),
        ('\u{209}', Slice { offset: 434, length: 2 }),
        ('\u{20a}', Slice { offset: 436, length: 2 }),
        ('\u{20b}', Slice { offset: 438, length: 2 }),
        ('\u{20c}', Slice { offset: 440, length: 2 }),
        ('\u{20d}', Slice { offset: 442, length: 2 }),
        ('\u{20e}', Slice { offset: 444, length: 2 }),
        ('\u{20f}', Slice { offset: 446, length: 2 }),
        ('\u{210}', Slice { offset: 448, length: 2 }),
        ('\u{211}', Slice { offset: 450, length: 2 }),
        ('\u{212}', Slice { offset: 452, length: 2 }),
        ('\u{213}', Slice { offset: 454, length: 2 }),
        ('\u{214}', Slice { offset: 456, length: 2 }),
        ('\u{215}', Slice { offset: 458, length: 2 }),
        ('\u{216}', Slice { offset: 460, length: 2 }),
        ('\u{217}', Slice { offset: 462, length: 2 }),
        ('\u{218}', Slice { offset: 464, length: 2 }),
        ('\u{219}', Slice { offset: 466, length: 2 }),
        ('\u{21a}', Slice { offset: 468, length: 2 }),
        ('\u{21b}', Slice { offset: 470, length: 2 }),
        ('\u{21e}', Slice { offset: 472, length: 2 }),
        ('\u{21f}', Slice { offset: 474, length: 2 }),
        ('\u{226}', Slice { offset: 476, length: 2 }),
        ('\u{227}', Slice { offset: 478, length: 2 }),
        ('\u{228}', Slice { offset: 480, length: 2 }),
        ('\u{229}', Slice { offset: 482, length: 2 }),
        ('\u{22a}', Slice { offset: 484, length: 2 }),
        ('\u{22b}', Slice { offset: 486, length: 2 }),
        ('\u{22c}', Slice { offset: 488, length: 2 }),
        ('\u{22d}', Slice { offset: 490, length: 2 }),
        ('\u{22e}', Slice { offset: 492, length: 2 }),
        ('\u{22f}', Slice { offset: 494, length: 2 }),
        ('\u{230}', Slice { offset: 496, length: 2 }),
        ('\u{231}', Slice { offset: 498, length: 2 }),
        ('\u{232}', Slice { offset: 500, length: 2 }),
        ('\u{233}', Slice { offset: 502, length: 2 }),
        ('\u{340}', Slice { offset: 504, length: 1 }),
        ('\u{341}', Slice { offset: 505, length: 1 }),
        ('\u{343}', Slice { offset: 506, length: 1 }),
        ('\u{344}', Slice { offset: 507, length: 2 }),
        ('\u{374}', Slice { offset: 509, length: 1 }),
        ('\u{37e}', Slice { offset: 510, length: 1 }),
        ('\u{385}', Slice { offset: 511, length: 2 }),
        ('\u{386}', Slice { offset: 513, length: 2 }),
        ('\u{387}', Slice { offset: 515, length: 1 }),
        ('\u{388}', Slice { offset: 516, length: 2 }),
        ('\u{389}', Slice { offset: 518, length: 2 }),
        ('\u{38a}', Slice { offset: 520, length: 2 }),
        ('\u{38c}', Slice { offset: 522, length: 2 }),
        ('\u{38e}', Slice { offset: 524, length: 2 }),
        ('\u{38f}', Slice { offset: 526, length: 2 }),
        ('\u{390}', Slice { offset: 528, length: 2 }),
        ('\u{3aa}', Slice { offset: 530, length: 2 }),
        ('\u{3ab}', Slice { offset: 532, length: 2 }),
        ('\u{3ac}', Slice { offset: 534, length: 2 }),
        ('\u{3ad}', Slice { offset: 536, length: 2 }),
        ('\u{3ae}', Slice { offset: 538, length: 2 }),
        ('\u{3af}', Slice { offset: 540, length: 2 }),
        ('\u{3b0}', Slice { offset: 542, length: 2 }),
        ('\u{3ca}', Slice { offset: 544, length: 2 }),
        ('\u{3cb}', Slice { offset: 546, length: 2 }),
        ('\u{3cc}', Slice { offset: 548, length: 2 }),
        ('\u{3cd}', Slice { offset: 550, length: 2 }),
        ('\u{3ce}', Slice { offset: 552, length: 2 }),
        ('\u{3d3}', Slice { offset: 554, length: 2 }),
        ('\u{3d4}', Slice { offset: 556, length: 2 }),
        ('\u{400}', Slice { offset: 558, length: 2 }),
        ('\u{401}', Slice { offset: 560, length: 2 }),
        ('\u{403}', Slice { offset: 562, length: 2 }),
        ('\u{407}', Slice { offset: 564, length: 2 }),
        ('\u{40c}', Slice { offset: 566, length: 2 }),
        ('\u{40d}', Slice { offset: 568, length: 2 }),
        ('\u{40e}', Slice { offset: 570, length: 2 }),
        ('\u{419}', Slice { offset: 572, length: 2 }),
        ('\u{439}', Slice { offset: 574, length: 2 }),
        ('\u{450}', Slice { offset: 576, length: 2 }),
        ('\u{451}', Slice { offset: 578, length: 2 }),
        ('\u{453}', Slice { offset: 580, length: 2 }),
        ('\u{457}', Slice { offset: 582, length: 2 }),
        ('\u{45c}', Slice { offset: 584, length: 2 }),
        ('\u{45d}', Slice { offset: 586, length: 2 }),
        ('\u{45e}', Slice { offset: 588, length: 2 }),
        ('\u{476}', Slice { offset: 590, length: 2 }),
        ('\u{477}', Slice { offset: 592, length: 2 }),
        ('\u{4c1}', Slice { offset: 594, length: 2 }),
        ('\u{4c2}', Slice { offset: 596, length: 2 }),
        ('\u{4d0}', Slice { offset: 598, length: 2 }),
        ('\u{4d1}', Slice { offset: 600, length: 2 }),
        ('\u{4d2}', Slice { offset: 602, length: 2 }),
        ('\u{4d3}', Slice { offset: 604, length: 2 }),
        ('\u{4d6}', Slice { offset: 606, length: 2 }),
        ('\u{4d7}', Slice { offset: 608, length: 2 }),
        ('\u{4da}', Slice { offset: 610, length: 2 }),
        ('\u{4db}', Slice { offset: 612, length: 2 }),
        ('\u{4dc}', Slice { offset: 614, length: 2 }),
        ('\u{4dd}', Slice { offset: 616, length: 2 }),
        ('\u{4de}', Slice { offset: 618, length: 2 }),
        ('\u{4df}', Slice { offset: 620, length: 2 }),
        ('\u{4e2}', Slice { offset: 622, length: 2 }),
        ('\u{4e3}', Slice { offset: 624, length: 2 }),
        ('\u{4e4}', Slice { offset: 626, length: 2 }),
        ('\u{4e5}', Slice { offset: 628, length: 2 }),
        ('\u{4e6}', Slice { offset: 630, length: 2 }),
        ('\u{4e7}', Slice { offset: 632, length: 2 }),
        ('\u{4ea}', Slice { offset: 634, length: 2 }),
        ('\u{4eb}', Slice { offset: 636, length: 2 }),
        ('\u{4ec}', Slice { offset: 638, length: 2 }),
        ('\u{4ed}', Slice { offset: 640, length: 2 }),
        ('\u{4ee}', Slice { offset: 642, length: 2 }),
        ('\u{4ef}', Slice { offset: 644, length: 2 }),
        ('\u{4f0}', Slice { offset: 646, length: 2 }),
        ('\u{4f1}', Slice { offset: 648, length: 2 }),
        ('\u{4f2}', Slice { offset: 650, length: 2 }),
        ('\u{4f3}', Slice { offset: 652, length: 2 }),
        ('\u{4f4}', Slice { offset: 654, length: 2 }),
        ('\u{4f5}', Slice { offset: 656, length: 2 }),
        ('\u{4f8}', Slice { offset: 658, length: 2 }),
        ('\u{4f9}', Slice { offset: 660, length: 2 }),
        ('\u{622}', Slice { offset: 662, length: 2 }),
        ('\u{623}', Slice { offset: 664, length: 2 }),
        ('\u{624}', Slice { offset: 666, length: 2 }),
        ('\u{625}', Slice { offset: 668, length: 2 }),
        ('\u{626}', Slice { offset: 670, length: 2 }),
        ('\u{6c0}', Slice { offset: 672, length: 2 }),
        ('\u{6c2}', Slice { offset: 674, length: 2 }),
        ('\u{6d3}', Slice { offset: 676, length: 2 }),
        ('\u{929}', Slice { offset: 678, length: 2 }),
        ('\u{931}', Slice { offset: 680, length: 2 }),
        ('\u{934}', Slice { offset: 682, length: 2 }),
        ('\u{958}', Slice { offset: 684, length: 2 }),
        ('\u{959}', Slice { offset: 686, length: 2 }),
        ('\u{95a}', Slice { offset: 688, length: 2 }),
        ('\u{95b}', Slice { offset: 690, length: 2 }),
        ('\u{95c}', Slice { offset: 692, length: 2 }),
        ('\u{95d}', Slice { offset: 694, length: 2 }),
        ('\u{95e}', Slice { offset: 696, length: 2 }),
        ('\u{95f}', Slice { offset: 698, length: 2 }),
        ('\u{9cb}', Slice { offset: 700, length: 2 }),
        ('\u{9cc}', Slice { offset: 702, length: 2 }),
        ('\u{9dc}', Slice { offset: 704, length: 2 }),
        ('\u{9dd}', Slice { offset: 706, length: 2 }),
        ('\u{9df}', Slice { offset: 708, length: 2 }),
        ('\u{a33}', Slice { offset: 710, length: 2 }),
        ('\u{a36}', Slice { offset: 712, length: 2 }),
        ('\u{a59}', Slice { offset: 714, length: 2 }),
        ('\u{a5a}', Slice { offset: 716, length: 2 }),
        ('\u{a5b}', Slice { offset: 718, length: 2 }),
        ('\u{a5e}', Slice { offset: 720, length: 2 }),
        ('\u{b48}', Slice { offset: 722, length: 2 }),
        ('\u{b4b}', Slice { offset: 724, length: 2 }),
        ('\u{b4c}', Slice { offset: 726, length: 2 }),
        ('\u{b5c}', Slice { offset: 728, length: 2 }),
        ('\u{b5d}', Slice { offset: 730, length: 2 }),
        ('\u{b94}', Slice { offset: 732, length: 2 }),
        ('\u{bca}', Slice { offset: 734, length: 2 }),
        ('\u{bcb}', Slice { offset: 736, length: 2 }),
        ('\u{bcc}', Slice { offset: 738, length: 2 }),
        ('\u{c48}', Slice { offset: 740, length: 2 }),
        ('\u{cc0}', Slice { offset: 742, length: 2 }),
        ('\u{cc7}', Slice { offset: 744, length: 2 }),
        ('\u{cc8}', Slice { offset: 746, length: 2 }),
        ('\u{cca}', Slice { offset: 748, length: 2 }),
        ('\u{ccb}', Slice { offset: 750, length: 2 }),
        ('\u{d4a}', Slice { offset: 752, length: 2 }),
        ('\u{d4b}', Slice { offset: 754, length: 2 }),
        ('\u{d4c}', Slice { offset: 756, length: 2 }),
        ('\u{dda}', Slice { offset: 758, length: 2 }),
        ('\u{ddc}', Slice { offset: 760, length: 2 }),
        ('\u{ddd}', Slice { offset: 762, length: 2 }),
        ('\u{dde}', Slice { offset: 764, length: 2 }),
        ('\u{f43}', Slice { offset: 766, length: 2 }),
        ('\u{f4d}', Slice { offset: 768, length: 2 }),
        ('\u{f52}', Slice { offset: 770, length: 2 }),
        ('\u{f57}', Slice { offset: 772, length: 2 }),
        ('\u{f5c}', Slice { offset: 774, length: 2 }),
        ('\u{f69}', Slice { offset: 776, length: 2 }),
        ('\u{f73}', Slice { offset: 778, length: 2 }),
        ('\u{f75}', Slice { offset: 780, length: 2 }),
        ('\u{f76}', Slice { offset: 782, length: 2 }),
        ('\u{f78}', Slice { offset: 784, length: 2 }),
        ('\u{f81}', Slice { offset: 786, length: 2 }),
        ('\u{f93}', Slice { offset: 788, length: 2 }),
        ('\u{f9d}', Slice { offset: 790, length: 2 }),
        ('\u{fa2}', Slice { offset: 792, length: 2 }),
        ('\u{fa7}', Slice { offset: 794, length: 2 }),
        ('\u{fac}', Slice { offset: 796, length: 2 }),
        ('\u{fb9}', Slice { offset: 798, length: 2 }),
        ('\u{1026}', Slice { offset: 800, length: 2 }),
        ('\u{1b06}', Slice { offset: 802, length: 2 }),
        ('\u{1b08}', Slice { offset: 804, length: 2 }),
        ('\u{1b0a}', Slice { offset: 806, length: 2 }),
        ('\u{1b0c}', Slice { offset: 808, length: 2 }),
        ('\u{1b0e}', Slice { offset: 810, length: 2 }),
        ('\u{1b12}', Slice { offset: 812, length: 2 }),
        ('\u{1b3b}', Slice { offset: 814, length: 2 }),
        ('\u{1b3d}', Slice { offset: 816, length: 2 }),
        ('\u{1b40}', Slice { offset: 818, length: 2 }),
        ('\u{1b41}', Slice { offset: 820, length: 2 }),
        ('\u{1b43}', Slice { offset: 822, length: 2 }),
        ('\u{1e00}', Slice { offset: 824, length: 2 }),
        ('\u{1e01}', Slice { offset: 826, length: 2 }),
        ('\u{1e02}', Slice { offset: 828, length: 2 }),
        ('\u{1e03}', Slice { offset: 830, length: 2 }),
        ('\u{1e04}', Slice { offset: 832, length: 2 }),
        ('\u{1e05}', Slice { offset: 834, length: 2 }),
        ('\u{1e06}', Slice { offset: 836, length: 2 }),
        ('\u{1e07}', Slice { offset: 838, length: 2 }),
        ('\u{1e08}', Slice { offset: 840, length: 2 }),
        ('\u{1e09}', Slice { offset: 842, length: 2 }),
        ('\u{1e0a}', Slice { offset: 844, length: 2 }),
        ('\u{1e0b}', Slice { offset: 846, length: 2 }),
        ('\u{1e0c}', Slice { offset: 848, length: 2 }),
        ('\u{1e0d}', Slice { offset: 850, length: 2 }),
        ('\u{1e0e}', Slice { offset: 852, length: 2 }),
        ('\u{1e0f}', Slice { offset: 854, length: 2 }),
        ('\u{1e10}', Slice { offset: 856, length: 2 }),
        ('\u{1e11}', Slice { offset: 858, length: 2 }),
        ('\u{1e12}', Slice { offset: 860, length: 2 }),
        ('\u{1e13}', Slice { offset: 862, length: 2 }),
        ('\u{1e14}', Slice { offset: 864, length: 2 }),
        ('\u{1e15}', Slice { offset: 866, length: 2 }),
        ('\u{1e16}', Slice { offset: 868, length: 2 }),
        ('\u{1e17}', Slice { offset: 870, length: 2 }),
        ('\u{1e18}', Slice { offset: 872, length: 2 }),
        ('\u{1e19}', Slice { offset: 874, length: 2 }),
        ('\u{1e1a}', Slice { offset: 876, length: 2 }),
        ('\u{1e1b}', Slice { offset: 878, length: 2 }),
        ('\u{1e1c}', Slice { offset: 880, length: 2 }),
        ('\u{1e1d}', Slice { offset: 882, length: 2 }),
        ('\u{1e1e}', Slice { offset: 884, length: 2 }),
        ('\u{1e1f}', Slice { offset: 886, length: 2 }),
        ('\u{1e20}', Slice { offset: 888, length: 2 }),
        ('\u{1e21}', Slice { offset: 890, length: 2 }),
        ('\u{1e22}', Slice { offset: 892, length: 2 }),
        ('\u{1e23}', Slice { offset: 894, length: 2 }),
        ('\u{1e24}', Slice { offset: 896, length: 2 }),
        ('\u{1e25}', Slice { offset: 898, length: 2 }),
        ('\u{1e26}', Slice { offset: 900, length: 2 }),
        ('\u{1e27}', Slice { offset: 902, length: 2 }),
        ('\u{1e28}', Slice { offset: 904, length: 2 }),
        ('\u{1e29}', Slice { offset: 906, length: 2 }),
        ('\u{1e2a}', Slice { offset: 908, length: 2 }),
        ('\u{1e2b}', Slice { offset: 910, length: 2 }),
        ('\u{1e2c}', Slice { offset: 912, length: 2 }),
        ('\u{1e2d}', Slice { offset: 914, length: 2 }),
        ('\u{1e2e}', Slice { offset: 916, length: 2 }),
        ('\u{1e2f}', Slice { offset: 918, length: 2 }),
        ('\u{1e30}', Slice { offset: 920, length: 2 }),
        ('\u{1e31}', Slice { offset: 922, length: 2 }),
        ('\u{1e32}', Slice { offset: 924, length: 2 }),
        ('\u{1e33}', Slice { offset: 926, length: 2 }),
        ('\u{1e34}', Slice { offset: 928, length: 2 }),
        ('\u{1e35}', Slice { offset: 930, length: 2 }),
        ('\u{1e36}', Slice { offset: 932, length: 2 }),
        ('\u{1e37}', Slice { offset: 934, length: 2 }),
        ('\u{1e38}', Slice { offset: 936, length: 2 }),
        ('\u{1e39}', Slice { offset: 938, length: 2 }),
        ('\u{1e3a}', Slice { offset: 940, length: 2 }),
        ('\u{1e3b}', Slice { offset: 942, length: 2 }),
        ('\u{1e3c}', Slice { offset: 944, length: 2 }),
        ('\u{1e3d}', Slice { offset: 946, length: 2 }),
        ('\u{1e3e}', Slice { offset: 948, length: 2 }),
        ('\u{1e3f}', Slice { offset: 950, length: 2 }),
        ('\u{1e40}', Slice { offset: 952, length: 2 }),
        ('\u{1e41}', Slice { offset: 954, length: 2 }),
        ('\u{1e42}', Slice { offset: 956, length: 2 }),
        ('\u{1e43}', Slice { offset: 958, length: 2 }),
        ('\u{1e44}', Slice { offset: 960, length: 2 }),
        ('\u{1e45}', Slice { offset: 962, length: 2 }),
        ('\u{1e46}', Slice { offset: 964, length: 2 }),
        ('\u{1e47}', Slice { offset: 966, length: 2 }),
        ('\u{1e48}', Slice { offset: 968, length: 2 }),
        ('\u{1e49}', Slice { offset: 970, length: 2 }),
        ('\u{1e4a}', Slice { offset: 972, length: 2 }),
        ('\u{1e4b}', Slice { offset: 974, length: 2 }),
        ('\u{1e4c}', Slice { offset: 976, length: 2 }),
        ('\u{1e4d}', Slice { offset: 978, length: 2 }),
        ('\u{1e4e}', Slice { offset: 980, length: 2 }),
        ('\u{1e4f}', Slice { offset: 982, length: 2 }),
        ('\u{1e50}', Slice { offset: 984, length: 2 }),
        ('\u{1e51}', Slice { offset: 986, length: 2 }),
        ('\u{1e52}', Slice { offset: 988, length: 2 }),
        ('\u{1e53}', Slice { offset: 990, length: 2 }),
        ('\u{1e54}', Slice { offset: 992, length: 2 }),
        ('\u{1e55}', Slice { offset: 994, length: 2 }),
        ('\u{1e56}', Slice { offset: 996, length: 2 }),
        ('\u{1e57}', Slice { offset: 998, length: 2 }),
        ('\u{1e58}', Slice { offset: 1000, length: 2 }),
        ('\u{1e59}', Slice { offset: 1002, length: 2 }),
        ('\u{1e5a}', Slice { offset: 1004, length: 2 }),
        ('\u{1e5b}', Slice { offset: 1006, length: 2 }),
        ('\u{1e5c}', Slice { offset: 1008, length: 2 }),
        ('\u{1e5d}', Slice { offset: 1010, length: 2 }),
        ('\u{1e5e}', Slice { offset: 1012, length: 2 }),
        ('\u{1e5f}', Slice { offset: 1014, length: 2 }),
        ('\u{1e60}', Slice { offset: 1016, length: 2 }),
        ('\u{1e61}', Slice { offset: 1018, length: 2 }),
        ('\u{1e62}', Slice { offset: 1020, length: 2 }),
        ('\u{1e63}', Slice { offset: 1022, length: 2 }),
        ('\u{1e64}', Slice { offset: 1024, length: 2 }),
        ('\u{1e65}', Slice { offset: 1026, length: 2 }),
        ('\u{1e66}', Slice { offset: 1028, length: 2 }),
        ('\u{1e67}', Slice { offset: 1030, length: 2 }),
        ('\u{1e68}', Slice { offset: 1032, length: 2 }),
        ('\u{1e69}', Slice { offset: 1034, length: 2 }),
        ('\u{1e6a}', Slice { offset: 1036, length: 2 }),
        ('\u{1e6b}', Slice { offset: 1038, length: 2 }),
        ('\u{1e6c}', Slice { offset: 1040, length: 2 }),
        ('\u{1e6d}', Slice { offset: 1042, length: 2 }),
        ('\u{1e6e}', Slice { offset: 1044, length: 2 }),
        ('\u{1e6f}', Slice { offset: 1046, length: 2 }),
        ('\u{1e70}', Slice { offset: 1048, length: 2 }),
        ('\u{1e71}', Slice { offset: 1050, length: 2 }),
        ('\u{1e72}', Slice { offset: 1052, length: 2 }),
        ('\u{1e73}', Slice { offset: 1054, length: 2 }),
        ('\u{1e74}', Slice { offset: 1056, length: 2 }),
        ('\u{1e75}', Slice { offset: 1058, length: 2 }),
        ('\u{1e76}', Slice { offset: 1060, length: 2 }),
        ('\u{1e77}', Slice { offset: 1062, length: 2 }),
        ('\u{1e78}', Slice { offset: 1064, length: 2 }),
        ('\u{1e79}', Slice { offset: 1066, length: 2 }),
        ('\u{1e7a}', Slice { offset: 1068, length: 2 }),
        ('\u{1e7b}', Slice { offset: 1070, length: 2 }),
        ('\u{1e7c}', Slice { offset: 1072, length: 2 }),
        ('\u{1e7d}', Slice { offset: 1074, length: 2 }),
        ('\u{1e7e}', Slice { offset: 1076, length: 2 }),
        ('\u{1e7f}', Slice { offset: 1078, length: 2 }),
        ('\u{1e80}', Slice { offset: 1080, length: 2 }),
        ('\u{1e81}', Slice { offset: 1082, length: 2 }),
        ('\u{1e82}', Slice { offset: 1084, length: 2 }),
        ('\u{1e83}', Slice { offset: 1086, length: 2 }),
        ('\u{1e84}', Slice { offset: 1088, length: 2 }),
        ('\u{1e85}', Slice { offset: 1090, length: 2 }),
        ('\u{1e86}', Slice { offset: 1092, length: 2 }),
        ('\u{1e87}', Slice { offset: 1094, length: 2 }),
        ('\u{1e88}', Slice { offset: 1096, length: 2 }),
        ('\u{1e89}', Slice { offset: 1098, length: 2 }),
        ('\u{1e8a}', Slice { offset: 1100, length: 2 }),
        ('\u{1e8b}', Slice { offset: 1102, length: 2 }),
        ('\u{1e8c}', Slice { offset: 1104, length: 2 }),
        ('\u{1e8d}', Slice { offset: 1106, length: 2 }),
        ('\u{1e8e}', Slice { offset: 1108, length: 2 }),
        ('\u{1e8f}', Slice { offset: 1110, length: 2 }),
        ('\u{1e90}', Slice { offset: 1112, length: 2 }),
        ('\u{1e91}', Slice { offset: 1114, length: 2 }),
        ('\u{1e92}', Slice { offset: 1116, length: 2 }),
        ('\u{1e93}', Slice { offset: 1118, length: 2 }),
        ('\u{1e94}', Slice { offset: 1120, length: 2 }),
        ('\u{1e95}', Slice { offset: 1122, length: 2 }),
        ('\u{1e96}', Slice { offset: 1124, length: 2 }),
        ('\u{1e97}', Slice { offset: 1126, length: 2 }),
        ('\u{1e98}', Slice { offset: 1128, length: 2 }),
        ('\u{1e99}', Slice { offset: 1130, length: 2 }),
        ('\u{1e9b}', Slice { offset: 1132, length: 2 }),
        ('\u{1ea0}', Slice { offset: 1134, length: 2 }),
        ('\u{1ea1}', Slice { offset: 1136, length: 2 }),
        ('\u{1ea2}', Slice { offset: 1138, length: 2 }),
        ('\u{1ea3}', Slice { offset: 1140, length: 2 }),
        ('\u{1ea4}', Slice { offset: 1142, length: 2 }),
        ('\u{1ea5}', Slice { offset: 1144, length: 2 }),
        ('\u{1ea6}', Slice { offset: 1146, length: 2 }),
        ('\u{1ea7}', Slice { offset: 1148, length: 2 }),
        ('\u{1ea8}', Slice { offset: 1150, length: 2 }),
        ('\u{1ea9}', Slice { offset: 1152, length: 2 }),
        ('\u{1eaa}', Slice { offset: 1154, length: 2 }),
        ('\u{1eab}', Slice { offset: 1156, length: 2 }),
        ('\u{1eac}', Slice { offset: 1158, length: 2 }),
        ('\u{1ead}', Slice { offset: 1160, length: 2 }),
        ('\u{1eae}', Slice { offset: 1162, length: 2 }),
        ('\u{1eaf}', Slice { offset: 1164, length: 2 }),
        ('\u{1eb0}', Slice { offset: 1166, length: 2 }),
        ('\u{1eb1}', Slice { offset: 1168, length: 2 }),
        ('\u{1eb2}', Slice { offset: 1170, length: 2 }),
        ('\u{1eb3}', Slice { offset: 1172, length: 2 }),
        ('\u{1eb4}', Slice { offset: 1174, length: 2 }),
        ('\u{1eb5}', Slice { offset: 1176, length: 2 }),
        ('\u{1eb6}', Slice { offset: 1178, length: 2 }),
        ('\u{1eb7}', Slice { offset: 1180, length: 2 }),
        ('\u{1eb8}', Slice { offset: 1182, length: 2 }),
        ('\u{1eb9}', Slice { offset: 1184, length: 2 }),
        ('\u{1eba}', Slice { offset: 1186, length: 2 }),
        ('\u{1ebb}', Slice { offset: 1188, length: 2 }),
        ('\u{1ebc}', Slice { offset: 1190, length: 2 }),
        ('\u{1ebd}', Slice { offset: 1192, length: 2 }),
        ('\u{1ebe}', Slice { offset: 1194, length: 2 }),
        ('\u{1ebf}', Slice { offset: 1196, length: 2 }),
        ('\u{1ec0}', Slice { offset: 1198, length: 2 }),
        ('\u{1ec1}', Slice { offset: 1200, length: 2 }),
        ('\u{1ec2}', Slice { offset: 1202, length: 2 }),
        ('\u{1ec3}', Slice { offset: 1204, length: 2 }),
        ('\u{1ec4}', Slice { offset: 1206, length: 2 }),
        ('\u{1ec5}', Slice { offset: 1208, length: 2 }),
        ('\u{1ec6}', Slice { offset: 1210, length: 2 }),
        ('\u{1ec7}', Slice { offset: 1212, length: 2 }),
        ('\u{1ec8}', Slice { offset: 1214, length: 2 }),
        ('\u{1ec9}', Slice { offset: 1216, length: 2 }),
        ('\u{1eca}', Slice { offset: 1218, length: 2 }),
        ('\u{1ecb}', Slice { offset: 1220, length: 2 }),
        ('\u{1ecc}', Slice { offset: 1222, length: 2 }),
        ('\u{1ecd}', Slice { offset: 1224, length: 2 }),
        ('\u{1ece}', Slice { offset: 1226, length: 2 }),
        ('\u{1ecf}', Slice { offset: 1228, length: 2 }),
        ('\u{1ed0}', Slice { offset: 1230, length: 2 }),
        ('\u{1ed1}', Slice { offset: 1232, length: 2 }),
        ('\u{1ed2}', Slice { offset: 1234, length: 2 }),
        ('\u{1ed3}', Slice { offset: 1236, length: 2 }),
        ('\u{1ed4}', Slice { offset: 1238, length: 2 }),
        ('\u{1ed5}', Slice { offset: 1240, length: 2 }),
        ('\u{1ed6}', Slice { offset: 1242, length: 2 }),
        ('\u{1ed7}', Slice { offset: 1244, length: 2 }),
        ('\u{1ed8}', Slice { offset: 1246, length: 2 }),
        ('\u{1ed9}', Slice { offset: 1248, length: 2 }),
        ('\u{1eda}', Slice { offset: 1250, length: 2 }),
        ('\u{1edb}', Slice { offset: 1252, length: 2 }),
        ('\u{1edc}', Slice { offset: 1254, length: 2 }),
        ('\u{1edd}', Slice { offset: 1256, length: 2 }),
        ('\u{1ede}', Slice { offset: 1258, length: 2 }),
        ('\u{1edf}', Slice { offset: 1260, length: 2 }),
        ('\u{1ee0}', Slice { offset: 1262, length: 2 }),
        ('\u{1ee1}', Slice { offset: 1264, length: 2 }),
        ('\u{1ee2}', Slice { offset: 1266, length: 2 }),
        ('\u{1ee3}', Slice { offset: 1268, length: 2 }),
        ('\u{1ee4}', Slice { offset: 1270, length: 2 }),
        ('\u{1ee5}', Slice { offset: 1272, length: 2 }),
        ('\u{1ee6}', Slice { offset: 1274, length: 2 }),
        ('\u{1ee7}', Slice { offset: 1276, length: 2 }),
        ('\u{1ee8}', Slice { offset: 1278, length: 2 }),
        ('\u{1ee9}', Slice { offset: 1280, length: 2 }),
        ('\u{1eea}', Slice { offset: 1282, length: 2 }),
        ('\u{1eeb}', Slice { offset: 1284, length: 2 }),
        ('\u{1eec}', Slice { offset: 1286, length: 2 }),
        ('\u{1eed}', Slice { offset: 1288, length: 2 }),
        ('\u{1eee}', Slice { offset: 1290, length: 2 }),
        ('\u{1eef}', Slice { offset: 1292, length: 2 }),
        ('\u{1ef0}', Slice { offset: 1294, length: 2 }),
        ('\u{1ef1}', Slice { offset: 1296, length: 2 }),
        ('\u{1ef2}', Slice { offset: 1298, length: 2 }),
        ('\u{1ef3}', Slice { offset: 1300, length: 2 }),
        ('\u{1ef4}', Slice { offset: 1302, length: 2 }),
        ('\u{1ef5}', Slice { offset: 1304, length: 2 }),
        ('\u{1ef6}', Slice { offset: 1306, length: 2 }),
        ('\u{1ef7}', Slice { offset: 1308, length: 2 }),
        ('\u{1ef8}', Slice { offset: 1310, length: 2 }),
        ('\u{1ef9}', Slice { offset: 1312, length: 2 }),
        ('\u{1f00}', Slice { offset: 1314, length: 2 }),
        ('\u{1f01}', Slice { offset: 1316, length: 2 }),
        ('\u{1f02}', Slice { offset: 1318, length: 2 }),
        ('\u{1f03}', Slice { offset: 1320, length: 2 }),
        ('\u{1f04}', Slice { offset: 1322, length: 2 }),
        ('\u{1f05}', Slice { offset: 1324, length: 2 }),
        ('\u{1f06}', Slice { offset: 1326, length: 2 }),
        ('\u{1f07}', Slice { offset: 1328, length: 2 }),
        ('\u{1f08}', Slice { offset: 1330, length: 2 }),
        ('\u{1f09}', Slice { offset: 1332, length: 2 }),
        ('\u{1f0a}', Slice { offset: 1334, length: 2 }),
        ('\u{1f0b}', Slice { offset: 1336, length: 2 }),
        ('\u{1f0c}', Slice { offset: 1338, length: 2 }),
        ('\u{1f0d}', Slice { offset: 1340, length: 2 }),
        ('\u{1f0e}', Slice { offset: 1342, length: 2 }),
        ('\u{1f0f}', Slice { offset: 1344, length: 2 }),
        ('\u{1f10}', Slice { offset: 1346, length: 2 }),
        ('\u{1f11}', Slice { offset: 1348, length: 2 }),
        ('\u{1f12}', Slice { offset: 1350, length: 2 }),
        ('\u{1f13}', Slice { offset: 1352, length: 2 }),
        ('\u{1f14}', Slice { offset: 1354, length: 2 }),
        ('\u{1f15}', Slice { offset: 1356, length: 2 }),
        ('\u{1f18}', Slice { offset: 1358, length: 2 }),
        ('\u{1f19}', Slice { offset: 1360, length: 2 }),
        ('\u{1f1a}', Slice { offset: 1362, length: 2 }),
        ('\u{1f1b}', Slice { offset: 1364, length: 2 }),
        ('\u{1f1c}', Slice { offset: 1366, length: 2 }),
        ('\u{1f1d}', Slice { offset: 1368, length: 2 }),
        ('\u{1f20}', Slice { offset: 1370, length: 2 }),
        ('\u{1f21}', Slice { offset: 1372, length: 2 }),
        ('\u{1f22}', Slice { offset: 1374, length: 2 }),
        ('\u{1f23}', Slice { offset: 1376, length: 2 }),
        ('\u{1f24}', Slice { offset: 1378, length: 2 }),
        ('\u{1f25}', Slice { offset: 1380, length: 2 }),
        ('\u{1f26}', Slice { offset: 1382, length: 2 }),
        ('\u{1f27}', Slice { offset: 1384, length: 2 }),
        ('\u{1f28}', Slice { offset: 1386, length: 2 }),
        ('\u{1f29}', Slice { offset: 1388, length: 2 }),
        ('\u{1f2a}', Slice { offset: 1390, length: 2 }),
        ('\u{1f2b}', Slice { offset: 1392, length: 2 }),
        ('\u{1f2c}', Slice { offset: 1394, length: 2 }),
        ('\u{1f2d}', Slice { offset: 1396, length: 2 }),
        ('\u{1f2e}', Slice { offset: 1398, length: 2 }),
        ('\u{1f2f}', Slice { offset: 1400, length: 2 }),
        ('\u{1f30}', Slice { offset: 1402, length: 2 }),
        ('\u{1f31}', Slice { offset: 1404, length: 2 }),
        ('\u{1f32}', Slice { offset: 1406, length: 2 }),
        ('\u{1f33}', Slice { offset: 1408, length: 2 }),
        ('\u{1f34}', Slice { offset: 1410, length: 2 }),
        ('\u{1f35}', Slice { offset: 1412, length: 2 }),
        ('\u{1f36}', Slice { offset: 1414, length: 2 }),
        ('\u{1f37}', Slice { offset: 1416, length: 2 }),
        ('\u{1f38}', Slice { offset: 1418, length: 2 }),
        ('\u{1f39}', Slice { offset: 1420, length: 2 }),
        ('\u{1f3a}', Slice { offset: 1422, length: 2 }),
        ('\u{1f3b}', Slice { offset: 1424, length: 2 }),
        ('\u{1f3c}', Slice { offset: 1426, length: 2 }),
        ('\u{1f3d}', Slice { offset: 1428, length: 2 }),
        ('\u{1f3e}', Slice { offset: 1430, length: 2 }),
        ('\u{1f3f}', Slice { offset: 1432, length: 2 }),
        ('\u{1f40}', Slice { offset: 1434, length: 2 }),
        ('\u{1f41}', Slice { offset: 1436, length: 2 }),
        ('\u{1f42}', Slice { offset: 1438, length: 2 }),
        ('\u{1f43}', Slice { offset: 1440, length: 2 }),
        ('\u{1f44}', Slice { offset: 1442, length: 2 }),
        ('\u{1f45}', Slice { offset: 1444, length: 2 }),
        ('\u{1f48}', Slice { offset: 1446, length: 2 }),
        ('\u{1f49}', Slice { offset: 1448, length: 2 }),
        ('\u{1f4a}', Slice { offset: 1450, length: 2 }),
        ('\u{1f4b}', Slice { offset: 1452, length: 2 }),
        ('\u{1f4c}', Slice { offset: 1454, length: 2 }),
        ('\u{1f4d}', Slice { offset: 1456, length: 2 }),
        ('\u{1f50}', Slice { offset: 1458, length: 2 }),
        ('\u{1f51}', Slice { offset: 1460, length: 2 }),
        ('\u{1f52}', Slice { offset: 1462, length: 2 }),
        ('\u{1f53}', Slice { offset: 1464, length: 2 }),
        ('\u{1f54}', Slice { offset: 1466, length: 2 }),
        ('\u{1f55}', Slice { offset: 1468, length: 2 }),
        ('\u{1f56}', Slice { offset: 1470, length: 2 }),
        ('\u{1f57}', Slice { offset: 1472, length: 2 }),
        ('\u{1f59}', Slice { offset: 1474, length: 2 }),
        ('\u{1f5b}', Slice { offset: 1476, length: 2 }),
        ('\u{1f5d}', Slice { offset: 1478, length: 2 }),
        ('\u{1f5f}', Slice { offset: 1480, length: 2 }),
        ('\u{1f60}', Slice { offset: 1482, length: 2 }),
        ('\u{1f61}', Slice { offset: 1484, length: 2 }),
        ('\u{1f62}', Slice { offset: 1486, length: 2 }),
        ('\u{1f63}', Slice { offset: 1488, length: 2 }),
        ('\u{1f64}', Slice { offset: 1490, length: 2 }),
        ('\u{1f65}', Slice { offset: 1492, length: 2 }),
        ('\u{1f66}', Slice { offset: 1494, length: 2 }),
        ('\u{1f67}', Slice { offset: 1496, length: 2 }),
        ('\u{1f68}', Slice { offset: 1498, length: 2 }),
        ('\u{1f69}', Slice { offset: 1500, length: 2 }),
        ('\u{1f6a}', Slice { offset: 1502, length: 2 }),
        ('\u{1f6b}', Slice { offset: 1504, length: 2 }),
        ('\u{1f6c}', Slice { offset: 1506, length: 2 }),
        ('\u{1f6d}', Slice { offset: 1508, length: 2 }),
        ('\u{1f6e}', Slice { offset: 1510, length: 2 }),
        ('\u{1f6f}', Slice { offset: 1512, length: 2 }),
        ('\u{1f70}', Slice { offset: 1514, length: 2 }),
        ('\u{1f71}', Slice { offset: 1516, length: 1 }),
        ('\u{1f72}', Slice { offset: 1517, length: 2 }),
        ('\u{1f73}', Slice { offset: 1519, length: 1 }),
        ('\u{1f74}', Slice { offset: 1520, length: 2 }),
        ('\u{1f75}', Slice { offset: 1522, length: 1 }),
        ('\u{1f76}', Slice { offset: 1523, length: 2 }),
        ('\u{1f77}', Slice { offset: 1525, length: 1 }),
        ('\u{1f78}', Slice { offset: 1526, length: 2 }),
        ('\u{1f79}', Slice { offset: 1528, length: 1 }),
        ('\u{1f7a}', Slice { offset: 1529, length: 2 }),
        ('\u{1f7b}', Slice { offset: 1531, length: 1 }),
        ('\u{1f7c}', Slice { offset: 1532, length: 2 }),
        ('\u{1f7d}', Slice { offset: 1534, length: 1 }),
        ('\u{1f80}', Slice { offset: 1535, length: 2 }),
        ('\u{1f81}', Slice { offset: 1537, length: 2 }),
        ('\u{1f82}', Slice { offset: 1539, length: 2 }),
        ('\u{1f83}', Slice { offset: 1541, length: 2 }),
        ('\u{1f84}', Slice { offset: 1543, length: 2 }),
        ('\u{1f85}', Slice { offset: 1545, length: 2 }),
        ('\u{1f86}', Slice { offset: 1547, length: 2 }),
        ('\u{1f87}', Slice { offset: 1549, length: 2 }),
        ('\u{1f88}', Slice { offset: 1551, length: 2 }),
        ('\u{1f89}', Slice { offset: 1553, length: 2 }),
        ('\u{1f8a}', Slice { offset: 1555, length: 2 }),
        ('\u{1f8b}', Slice { offset: 1557, length: 2 }),
        ('\u{1f8c}', Slice { offset: 1559, length: 2 }),
        ('\u{1f8d}', Slice { offset: 1561, length: 2 }),
        ('\u{1f8e}', Slice { offset: 1563, length: 2 }),
        ('\u{1f8f}', Slice { offset: 1565, length: 2 }),
        ('\u{1f90}', Slice { offset: 1567, length: 2 }),
        ('\u{1f91}', Slice { offset: 1569, length: 2 }),
        ('\u{1f92}', Slice { offset: 1571, length: 2 }),
        ('\u{1f93}', Slice { offset: 1573, length: 2 }),
        ('\u{1f94}', Slice { offset: 1575, length: 2 }),
        ('\u{1f95}', Slice { offset: 1577, length: 2 }),
        ('\u{1f96}', Slice { offset: 1579, length: 2 }),
        ('\u{1f97}', Slice { offset: 1581, length: 2 }),
        ('\u{1f98}', Slice { offset: 1583, length: 2 }),
        ('\u{1f99}', Slice { offset: 1585, length: 2 }),
        ('\u{1f9a}', Slice { offset: 1587, length: 2 }),
        ('\u{1f9b}', Slice { offset: 1589, length: 2 }),
        ('\u{1f9c}', Slice { offset: 1591, length: 2 }),
        ('\u{1f9d}', Slice { offset: 1593, length: 2 }),
        ('\u{1f9e}', Slice { offset: 1595, length: 2 }),
        ('\u{1f9f}', Slice { offset: 1597, length: 2 }),
        ('\u{1fa0}', Slice { offset: 1599, length: 2 }),
        ('\u{1fa1}', Slice { offset: 1601, length: 2 }),
        ('\u{1fa2}', Slice { offset: 1603, length: 2 }),
        ('\u{1fa3}', Slice { offset: 1605, length: 2 }),
        ('\u{1fa4}', Slice { offset: 1607, length: 2 }),
        ('\u{1fa5}', Slice { offset: 1609, length: 2 }),
        ('\u{1fa6}', Slice { offset: 1611, length: 2 }),
        ('\u{1fa7}', Slice { offset: 1613, length: 2 }),
        ('\u{1fa8}', Slice { offset: 1615, length: 2 }),
        ('\u{1fa9}', Slice { offset: 1617, length: 2 }),
        ('\u{1faa}', Slice { offset: 1619, length: 2 }),
        ('\u{1fab}', Slice { offset: 1621, length: 2 }),
        ('\u{1fac}', Slice { offset: 1623, length: 2 }),
        ('\u{1fad}', Slice { offset: 1625, length: 2 }),
        ('\u{1fae}', Slice { offset: 1627, length: 2 }),
        ('\u{1faf}', Slice { offset: 1629, length: 2 }),
        ('\u{1fb0}', Slice { offset: 1631, length: 2 }),
        ('\u{1fb1}', Slice { offset: 1633, length: 2 }),
        ('\u{1fb2}', Slice { offset: 1635, length: 2 }),
        ('\u{1fb3}', Slice { offset: 1637, length: 2 }),
        ('\u{1fb4}', Slice { offset: 1639, length: 2 }),
        ('\u{1fb6}', Slice { offset: 1641, length: 2 }),
        ('\u{1fb7}', Slice { offset: 1643, length: 2 }),
        ('\u{1fb8}', Slice { offset: 1645, length: 2 }),
        ('\u{1fb9}', Slice { offset: 1647, length: 2 }),
        ('\u{1fba}', Slice { offset: 1649, length: 2 }),
        ('\u{1fbb}', Slice { offset: 1651, length: 1 }),
        ('\u{1fbc}', Slice { offset: 1652, length: 2 }),
        ('\u{1fbe}', Slice { offset: 1654, length: 1 }),
        ('\u{1fc1}', Slice { offset: 1655, length: 2 }),
        ('\u{1fc2}', Slice { offset: 1657, length: 2 }),
        ('\u{1fc3}', Slice { offset: 1659, length: 2 }),
        ('\u{1fc4}', Slice { offset: 1661, length: 2 }),
        ('\u{1fc6}', Slice { offset: 1663, length: 2 }),
        ('\u{1fc7}', Slice { offset: 1665, length: 2 }),
        ('\u{1fc8}', Slice { offset: 1667, length: 2 }),
        ('\u{1fc9}', Slice { offset: 1669, length: 1 }),
        ('\u{1fca}', Slice { offset: 1670, length: 2 }),
        ('\u{1fcb}', Slice { offset: 1672, length: 1 }),
        ('\u{1fcc}', Slice { offset: 1673, length: 2 }),
        ('\u{1fcd}', Slice { offset: 1675, length: 2 }),
        ('\u{1fce}', Slice { offset: 1677, length: 2 }),
        ('\u{1fcf}', Slice { offset: 1679, length: 2 }),
        ('\u{1fd0}', Slice { offset: 1681, length: 2 }),
        ('\u{1fd1}', Slice { offset: 1683, length: 2 }),
        ('\u{1fd2}', Slice { offset: 1685, length: 2 }),
        ('\u{1fd3}', Slice { offset: 1687, length: 1 }),
        ('\u{1fd6}', Slice { offset: 1688, length: 2 }),
        ('\u{1fd7}', Slice { offset: 1690, length: 2 }),
        ('\u{1fd8}', Slice { offset: 1692, length: 2 }),
        ('\u{1fd9}', Slice { offset: 1694, length: 2 }),
        ('\u{1fda}', Slice { offset: 1696, length: 2 }),
        ('\u{1fdb}', Slice { offset: 1698, length: 1 }),
        ('\u{1fdd}', Slice { offset: 1699, length: 2 }),
        ('\u{1fde}', Slice { offset: 1701, length: 2 }),
        ('\u{1fdf}', Slice { offset: 1703, length: 2 }),
        ('\u{1fe0}', Slice { offset: 1705, length: 2 }),
        ('\u{1fe1}', Slice { offset: 1707, length: 2 }),
        ('\u{1fe2}', Slice { offset: 1709, length: 2 }),
        ('\u{1fe3}', Slice { offset: 1711, length: 1 }),
        ('\u{1fe4}', Slice { offset: 1712, length: 2 }),
        ('\u{1fe5}', Slice { offset: 1714, length: 2 }),
        ('\u{1fe6}', Slice { offset: 1716, length: 2 }),
        ('\u{1fe7}', Slice { offset: 1718, length: 2 }),
        ('\u{1fe8}', Slice { offset: 1720, length: 2 }),
        ('\u{1fe9}', Slice { offset: 1722, length: 2 }),
        ('\u{1fea}', Slice { offset: 1724, length: 2 }),
        ('\u{1feb}', Slice { offset: 1726, length: 1 }),
        ('\u{1fec}', Slice { offset: 1727, length: 2 }),
        ('\u{1fed}', Slice { offset: 1729, length: 2 }),
        ('\u{1fee}', Slice { offset: 1731, length: 1 }),
        ('\u{1fef}', Slice { offset: 1732, length: 1 }),
        ('\u{1ff2}', Slice { offset: 1733, length: 2 }),
        ('\u{1ff3}', Slice { offset: 1735, length: 2 }),
        ('\u{1ff4}', Slice { offset: 1737, length: 2 }),
        ('\u{1ff6}', Slice { offset: 1739, length: 2 }),
        ('\u{1ff7}', Slice { offset: 1741, length: 2 }),
        ('\u{1ff8}', Slice { offset: 1743, length: 2 }),
        ('\u{1ff9}', Slice { offset: 1745, length: 1 }),
        ('\u{1ffa}', Slice { offset: 1746, length: 2 }),
        ('\u{1ffb}', Slice { offset: 1748, length: 1 }),
        ('\u{1ffc}', Slice { offset: 1749, length: 2 }),
        ('\u{1ffd}', Slice { offset: 1751, length: 1 }),
        ('\u{2000}', Slice { offset: 1752, length: 1 }),
        ('\u{2001}', Slice { offset: 1753, length: 1 }),
        ('\u{2126}', Slice { offset: 1754, length: 1 }),
        ('\u{212a}', Slice { offset: 1755, length: 1 }),
        ('\u{212b}', Slice { offset: 1756, length: 1 }),
        ('\u{219a}', Slice { offset: 1757, length: 2 }),
        ('\u{219b}', Slice { offset: 1759, length: 2 }),
        ('\u{21ae}', Slice { offset: 1761, length: 2 }),
        ('\u{21cd}', Slice { offset: 1763, length: 2 }),
        ('\u{21ce}', Slice { offset: 1765, length: 2 }),
        ('\u{21cf}', Slice { offset: 1767, length: 2 }),
        ('\u{2204}', Slice { offset: 1769, length: 2 }),
        ('\u{2209}', Slice { offset: 1771, length: 2 }),
        ('\u{220c}', Slice { offset: 1773, length: 2 }),
        ('\u{2224}', Slice { offset: 1775, length: 2 }),
        ('\u{2226}', Slice { offset: 1777, length: 2 }),
        ('\u{2241}', Slice { offset: 1779, length: 2 }),
        ('\u{2244}', Slice { offset: 1781, length: 2 }),
        ('\u{2247}', Slice { offset: 1783, length: 2 }),
        ('\u{2249}', Slice { offset: 1785, length: 2 }),
        ('\u{2260}', Slice { offset: 1787, length: 2 }),
        ('\u{2262}', Slice { offset: 1789, length: 2 }),
        ('\u{226d}', Slice { offset: 1791, length: 2 }),
        ('\u{226e}', Slice { offset: 1793, length: 2 }),
        ('\u{226f}', Slice { offset: 1795, length: 2 }),
        ('\u{2270}', Slice { offset: 1797, length: 2 }),
        ('\u{2271}', Slice { offset: 1799, length: 2 }),
        ('\u{2274}', Slice { offset: 1801, length: 2 }),
        ('\u{2275}', Slice { offset: 1803, length: 2 }),
        ('\u{2278}', Slice { offset: 1805, length: 2 }),
        ('\u{2279}', Slice { offset: 1807, length: 2 }),
        ('\u{2280}', Slice { offset: 1809, length: 2 }),
        ('\u{2281}', Slice { offset: 1811, length: 2 }),
        ('\u{2284}', Slice { offset: 1813, length: 2 }),
        ('\u{2285}', Slice { offset: 1815, length: 2 }),
        ('\u{2288}', Slice { offset: 1817, length: 2 }),
        ('\u{2289}', Slice { offset: 1819, length: 2 }),
        ('\u{22ac}', Slice { offset: 1821, length: 2 }),
        ('\u{22ad}', Slice { offset: 1823, length: 2 }),
        ('\u{22ae}', Slice { offset: 1825, length: 2 }),
        ('\u{22af}', Slice { offset: 1827, length: 2 }),
        ('\u{22e0}', Slice { offset: 1829, length: 2 }),
        ('\u{22e1}', Slice { offset: 1831, length: 2 }),
        ('\u{22e2}', Slice { offset: 1833, length: 2 }),
        ('\u{22e3}', Slice { offset: 1835, length: 2 }),
        ('\u{22ea}', Slice { offset: 1837, length: 2 }),
        ('\u{22eb}', Slice { offset: 1839, length: 2 }),
        ('\u{22ec}', Slice { offset: 1841, length: 2 }),
        ('\u{22ed}', Slice { offset: 1843, length: 2 }),
        ('\u{2329}', Slice { offset: 1845, length: 1 }),
        ('\u{232a}', Slice { offset: 1846, length: 1 }),
        ('\u{2adc}', Slice { offset: 1847, length: 2 }),
        ('\u{304c}', Slice { offset: 1849, length: 2 }),
        ('\u{304e}', Slice { offset: 1851, length: 2 }),
        ('\u{3050}', Slice { offset: 1853, length: 2 }),
        ('\u{3052}', Slice { offset: 1855, length: 2 }),
        ('\u{3054}', Slice { offset: 1857, length: 2 }),
        ('\u{3056}', Slice { offset: 1859, length: 2 }),
        ('\u{3058}', Slice { offset: 1861, length: 2 }),
        ('\u{305a}', Slice { offset: 1863, length: 2 }),
        ('\u{305c}', Slice { offset: 1865, length: 2 }),
        ('\u{305e}', Slice { offset: 1867, length: 2 }),
        ('\u{3060}', Slice { offset: 1869, length: 2 }),
        ('\u{3062}', Slice { offset: 1871, length: 2 }),
        ('\u{3065}', Slice { offset: 1873, length: 2 }),
        ('\u{3067}', Slice { offset: 1875, length: 2 }),
        ('\u{3069}', Slice { offset: 1877, length: 2 }),
        ('\u{3070}', Slice { offset: 1879, length: 2 }),
        ('\u{3071}', Slice { offset: 1881, length: 2 }),
        ('\u{3073}', Slice { offset: 1883, length: 2 }),
        ('\u{3074}', Slice { offset: 1885, length: 2 }),
        ('\u{3076}', Slice { offset: 1887, length: 2 }),
        ('\u{3077}', Slice { offset: 1889, length: 2 }),
        ('\u{3079}', Slice { offset: 1891, length: 2 }),
        ('\u{307a}', Slice { offset: 1893, length: 2 }),
        ('\u{307c}', Slice { offset: 1895, length: 2 }),
        ('\u{307d}', Slice { offset: 1897, length: 2 }),
        ('\u{3094}', Slice { offset: 1899, length: 2 }),
        ('\u{309e}', Slice { offset: 1901, length: 2 }),
        ('\u{30ac}', Slice { offset: 1903, length: 2 }),
        ('\u{30ae}', Slice { offset: 1905, length: 2 }),
        ('\u{30b0}', Slice { offset: 1907, length: 2 }),
        ('\u{30b2}', Slice { offset: 1909, length: 2 }),
        ('\u{30b4}', Slice { offset: 1911, length: 2 }),
        ('\u{30b6}', Slice { offset: 1913, length: 2 }),
        ('\u{30b8}', Slice { offset: 1915, length: 2 }),
        ('\u{30ba}', Slice { offset: 1917, length: 2 }),
        ('\u{30bc}', Slice { offset: 1919, length: 2 }),
        ('\u{30be}', Slice { offset: 1921, length: 2 }),
        ('\u{30c0}', Slice { offset: 1923, length: 2 }),
        ('\u{30c2}', Slice { offset: 1925, length: 2 }),
        ('\u{30c5}', Slice { offset: 1927, length: 2 }),
        ('\u{30c7}', Slice { offset: 1929, length: 2 }),
        ('\u{30c9}', Slice { offset: 1931, length: 2 }),
        ('\u{30d0}', Slice { offset: 1933, length: 2 }),
        ('\u{30d1}', Slice { offset: 1935, length: 2 }),
        ('\u{30d3}', Slice { offset: 1937, length: 2 }),
        ('\u{30d4}', Slice { offset: 1939, length: 2 }),
        ('\u{30d6}', Slice { offset: 1941, length: 2 }),
        ('\u{30d7}', Slice { offset: 1943, length: 2 }),
        ('\u{30d9}', Slice { offset: 1945, length: 2 }),
        ('\u{30da}', Slice { offset: 1947, length: 2 }),
        ('\u{30dc}', Slice { offset: 1949, length: 2 }),
        ('\u{30dd}', Slice { offset: 1951, length: 2 }),
        ('\u{30f4}', Slice { offset: 1953, length: 2 }),
        ('\u{30f7}', Slice { offset: 1955, length: 2 }),
        ('\u{30f8}', Slice { offset: 1957, length: 2 }),
        ('\u{30f9}', Slice { offset: 1959, length: 2 }),
        ('\u{30fa}', Slice { offset: 1961, length: 2 }),
        ('\u{30fe}', Slice { offset: 1963, length: 2 }),
        ('\u{f900}', Slice { offset: 1965, length: 1 }),
        ('\u{f901}', Slice { offset: 1966, length: 1 }),
        ('\u{f902}', Slice { offset: 1967, length: 1 }),
        ('\u{f903}', Slice { offset: 1968, length: 1 }),
        ('\u{f904}', Slice { offset: 1969, length: 1 }),
        ('\u{f905}', Slice { offset: 1970, length: 1 }),
        ('\u{f906}', Slice { offset: 1971, length: 1 }),
        ('\u{f907}', Slice { offset: 1972, length: 1 }),
        ('\u{f908}', Slice { offset: 1972, length: 1 }),
        ('\u{f909}', Slice { offset: 1973, length: 1 }),
        ('\u{f90a}', Slice { offset: 1974, length: 1 }),
        ('\u{f90b}', Slice { offset: 1975, length: 1 }),
        ('\u{f90c}', Slice { offset: 1976, length: 1 }),
        ('\u{f90d}', Slice { offset: 1977, length: 1 }),
        ('\u{f90e}', Slice { offset: 1978, length: 1 }),
        ('\u{f90f}', Slice { offset: 1979, length: 1 }),
        ('\u{f910}', Slice { offset: 1980, length: 1 }),
        ('\u{f911}', Slice { offset: 1981, length: 1 }),
        ('\u{f912}', Slice { offset: 1982, length: 1 }),
        ('\u{f913}', Slice { offset: 1983, length: 1 }),
        ('\u{f914}', Slice { offset: 1984, length: 1 }),
        ('\u{f915}', Slice { offset: 1985, length: 1 }),
        ('\u{f916}', Slice { offset: 1986, length: 1 }),
        ('\u{f917}', Slice { offset: 1987, length: 1 }),
        ('\u{f918}', Slice { offset: 1988, length: 1 }),
        ('\u{f919}', Slice { offset: 1989, length: 1 }),
        ('\u{f91a}', Slice { offset: 1990, length: 1 }),
        ('\u{f91b}', Slice { offset: 1991, length: 1 }),
        ('\u{f91c}', Slice { offset: 1992, length: 1 }),
        ('\u{f91d}', Slice { offset: 1993, length: 1 }),
        ('\u{f91e}', Slice { offset: 1994, length: 1 }),
        ('\u{f91f}', Slice { offset: 1995, length: 1 }),
        ('\u{f920}', Slice { offset: 1996, length: 1 }),
        ('\u{f921}', Slice { offset: 1997, length: 1 }),
        ('\u{f922}', Slice { offset: 1998, length: 1 }),
        ('\u{f923}', Slice { offset: 1999, length: 1 }),
        ('\u{f924}', Slice { offset: 2000, length: 1 }),
        ('\u{f925}', Slice { offset: 2001, length: 1 }),
        ('\u{f926}', Slice { offset: 2002, length: 1 }),
        ('\u{f927}', Slice { offset: 2003, length: 1 }),
        ('\u{f928}', Slice { offset: 2004, length: 1 }),
        ('\u{f929}', Slice { offset: 2005, length: 1 }),
        ('\u{f92a}', Slice { offset: 2006, length: 1 }),
        ('\u{f92b}', Slice { offset: 2007, length: 1 }),
        ('\u{f92c}', Slice { offset: 2008, length: 1 }),
        ('\u{f92d}', Slice { offset: 2009, length: 1 }),
        ('\u{f92e}', Slice { offset: 2010, length: 1 }),
        ('\u{f92f}', Slice { offset: 2011, length: 1 }),
        ('\u{f930}', Slice { offset: 2012, length: 1 }),
        ('\u{f931}', Slice { offset: 2013, length: 1 }),
        ('\u{f932}', Slice { offset: 2014, length: 1 }),
        ('\u{f933}', Slice { offset: 2015, length: 1 }),
        ('\u{f934}', Slice { offset: 2016, length: 1 }),
        ('\u{f935}', Slice { offset: 2017, length: 1 }),
        ('\u{f936}', Slice { offset: 2018, length: 1 }),
        ('\u{f937}', Slice { offset: 2019, length: 1 }),
        ('\u{f938}', Slice { offset: 2020, length: 1 }),
        ('\u{f939}', Slice { offset: 2021, length: 1 }),
        ('\u{f93a}', Slice { offset: 2022, length: 1 }),
        ('\u{f93b}', Slice { offset: 2023, length: 1 }),
        ('\u{f93c}', Slice { offset: 2024, length: 1 }),
        ('\u{f93d}', Slice { offset: 2025, length: 1 }),
        ('\u{f93e}', Slice { offset: 2026, length: 1 }),
        ('\u{f93f}', Slice { offset: 2027, length: 1 }),
        ('\u{f940}', Slice { offset: 2028, length: 1 }),
        ('\u{f941}', Slice { offset: 2029, length: 1 }),
        ('\u{f942}', Slice { offset: 2030, length: 1 }),
        ('\u{f943}', Slice { offset: 2031, length: 1 }),
        ('\u{f944}', Slice { offset: 2032, length: 1 }),
        ('\u{f945}', Slice { offset: 2033, length: 1 }),
        ('\u{f946}', Slice { offset: 2034, length: 1 }),
        ('\u{f947}', Slice { offset: 2035, length: 1 }),
        ('\u{f948}', Slice { offset: 2036, length: 1 }),
        ('\u{f949}', Slice { offset: 2037, length: 1 }),
        ('\u{f94a}', Slice { offset: 2038, length: 1 }),
        ('\u{f94b}', Slice { offset: 2039, length: 1 }),
        ('\u{f94c}', Slice { offset: 2040, length: 1 }),
        ('\u{f94d}', Slice { offset: 2041, length: 1 }),
        ('\u{f94e}', Slice { offset: 2042, length: 1 }),
        ('\u{f94f}', Slice { offset: 2043, length: 1 }),
        ('\u{f950}', Slice { offset: 2044, length: 1 }),
        ('\u{f951}', Slice { offset: 2045, length: 1 }),
        ('\u{f952}', Slice { offset: 2046, length: 1 }),
        ('\u{f953}', Slice { offset: 2047, length: 1 }),
        ('\u{f954}', Slice { offset: 2048, length: 1 }),
        ('\u{f955}', Slice { offset: 2049, length: 1 }),
        ('\u{f956}', Slice { offset: 2050, length: 1 }),
        ('\u{f957}', Slice { offset: 2051, length: 1 }),
        ('\u{f958}', Slice { offset: 2052, length: 1 }),
        ('\u{f959}', Slice { offset: 2053, length: 1 }),
        ('\u{f95a}', Slice { offset: 2054, length: 1 }),
        ('\u{f95b}', Slice { offset: 2055, length: 1 }),
        ('\u{f95c}', Slice { offset: 1984, length: 1 }),
        ('\u{f95d}', Slice { offset: 2056, length: 1 }),
        ('\u{f95e}', Slice { offset: 2057, length: 1 }),
        ('\u{f95f}', Slice { offset: 2058, length: 1 }),
        ('\u{f960}', Slice { offset: 2059, length: 1 }),
        ('\u{f961}', Slice { offset: 2060, length: 1 }),
        ('\u{f962}', Slice { offset: 2061, length: 1 }),
        ('\u{f963}', Slice { offset: 2062, length: 1 }),
        ('\u{f964}', Slice { offset: 2063, length: 1 }),
        ('\u{f965}', Slice { offset: 2064, length: 1 }),
        ('\u{f966}', Slice { offset: 2065, length: 1 }),
        ('\u{f967}', Slice { offset: 2066, length: 1 }),
        ('\u{f968}', Slice { offset: 2067, length: 1 }),
        ('\u{f969}', Slice { offset: 2068, length: 1 }),
        ('\u{f96a}', Slice { offset: 2069, length: 1 }),
        ('\u{f96b}', Slice { offset: 2070, length: 1 }),
        ('\u{f96c}', Slice { offset: 2071, length: 1 }),
        ('\u{f96d}', Slice { offset: 2072, length: 1 }),
        ('\u{f96e}', Slice { offset: 2073, length: 1 }),
        ('\u{f96f}', Slice { offset: 2074, length: 1 }),
        ('\u{f970}', Slice { offset: 2075, length: 1 }),
        ('\u{f971}', Slice { offset: 2076, length: 1 }),
        ('\u{f972}', Slice { offset: 2077, length: 1 }),
        ('\u{f973}', Slice { offset: 2078, length: 1 }),
        ('\u{f974}', Slice { offset: 2079, length: 1 }),
        ('\u{f975}', Slice { offset: 2080, length: 1 }),
        ('\u{f976}', Slice { offset: 2081, length: 1 }),
        ('\u{f977}', Slice { offset: 2082, length: 1 }),
        ('\u{f978}', Slice { offset: 2083, length: 1 }),
        ('\u{f979}', Slice { offset: 2084, length: 1 }),
        ('\u{f97a}', Slice { offset: 2085, length: 1 }),
        ('\u{f97b}', Slice { offset: 2086, length: 1 }),
        ('\u{f97c}', Slice { offset: 2087, length: 1 }),
        ('\u{f97d}', Slice { offset: 2088, length: 1 }),
        ('\u{f97e}', Slice { offset: 2089, length: 1 }),
        ('\u{f97f}', Slice { offset: 2090, length: 1 }),
        ('\u{f980}', Slice { offset: 2091, length: 1 }),
        ('\u{f981}', Slice { offset: 2092, length: 1 }),
        ('\u{f982}', Slice { offset: 2093, length: 1 }),
        ('\u{f983}', Slice { offset: 2094, length: 1 }),
        ('\u{f984}', Slice { offset: 2095, length: 1 }),
        ('\u{f985}', Slice { offset: 2096, length: 1 }),
        ('\u{f986}', Slice { offset: 2097, length: 1 }),
        ('\u{f987}', Slice { offset: 2098, length: 1 }),
        ('\u{f988}', Slice { offset: 2099, length: 1 }),
        ('\u{f989}', Slice { offset: 2100, length: 1 }),
        ('\u{f98a}', Slice { offset: 2101, length: 1 }),
        ('\u{f98b}', Slice { offset: 2102, length: 1 }),
        ('\u{f98c}', Slice { offset: 2103, length: 1 }),
        ('\u{f98d}', Slice { offset: 2104, length: 1 }),
        ('\u{f98e}', Slice { offset: 2105, length: 1 }),
        ('\u{f98f}', Slice { offset: 2106, length: 1 }),
        ('\u{f990}', Slice { offset: 2107, length: 1 }),
        ('\u{f991}', Slice { offset: 2108, length: 1 }),
        ('\u{f992}', Slice { offset: 2109, length: 1 }),
        ('\u{f993}', Slice { offset: 2110, length: 1 }),
        ('\u{f994}', Slice { offset: 2111, length: 1 }),
        ('\u{f995}', Slice { offset: 2112, length: 1 }),
        ('\u{f996}', Slice { offset: 2113, length: 1 }),
        ('\u{f997}', Slice { offset: 2114, length: 1 }),
        ('\u{f998}', Slice { offset: 2115, length: 1 }),
        ('\u{f999}', Slice { offset: 2116, length: 1 }),
        ('\u{f99a}', Slice { offset: 2117, length: 1 }),
        ('\u{f99b}', Slice { offset: 2118, length: 1 }),
        ('\u{f99c}', Slice { offset: 2119, length: 1 }),
        ('\u{f99d}', Slice { offset: 2120, length: 1 }),
        ('\u{f99e}', Slice { offset: 2121, length: 1 }),
        ('\u{f99f}', Slice { offset: 2122, length: 1 }),
        ('\u{f9a0}', Slice { offset: 2123, length: 1 }),
        ('\u{f9a1}', Slice { offset: 2074, length: 1 }),
        ('\u{f9a2}', Slice { offset: 2124, length: 1 }),
        ('\u{f9a3}', Slice { offset: 2125, length: 1 }),
        ('\u{f9a4}', Slice { offset: 2126, length: 1 }),
        ('\u{f9a5}', Slice { offset: 2127, length: 1 }),
        ('\u{f9a6}', Slice { offset: 2128, length: 1 }),
        ('\u{f9a7}', Slice { offset: 2129, length: 1 }),
        ('\u{f9a8}', Slice { offset: 2130, length: 1 }),
        ('\u{f9a9}', Slice { offset: 2131, length: 1 }),
        ('\u{f9aa}', Slice { offset: 2058, length: 1 }),
        ('\u{f9ab}', Slice { offset: 2132, length: 1 }),
        ('\u{f9ac}', Slice { offset: 2133, length: 1 }),
        ('\u{f9ad}', Slice { offset: 2134, length: 1 }),
        ('\u{f9ae}', Slice { offset: 2135, length: 1 }),
        ('\u{f9af}', Slice { offset: 2136, length: 1 }),
        ('\u{f9b0}', Slice { offset: 2137, length: 1 }),
        ('\u{f9b1}', Slice { offset: 2138, length: 1 }),
        ('\u{f9b2}', Slice { offset: 2139, length: 1 }),
        ('\u{f9b3}', Slice { offset: 2140, length: 1 }),
        ('\u{f9b4}', Slice { offset: 2141, length: 1 }),
        ('\u{f9b5}', Slice { offset: 2142, length: 1 }),
        ('\u{f9b6}', Slice { offset: 2143, length: 1 }),
        ('\u{f9b7}', Slice { offset: 2144, length: 1 }),
        ('\u{f9b8}', Slice { offset: 2145, length: 1 }),
        ('\u{f9b9}', Slice { offset: 2146, length: 1 }),
        ('\u{f9ba}', Slice { offset: 2147, length: 1 }),
        ('\u{f9bb}', Slice { offset: 2148, length: 1 }),
        ('\u{f9bc}', Slice { offset: 2149, length: 1 }),
        ('\u{f9bd}', Slice { offset: 2150, length: 1 }),
        ('\u{f9be}', Slice { offset: 2151, length: 1 }),
        ('\u{f9bf}', Slice { offset: 1984, length: 1 }),
        ('\u{f9c0}', Slice { offset: 2152, length: 1 }),
        ('\u{f9c1}', Slice { offset: 2153, length: 1 }),
        ('\u{f9c2}', Slice { offset: 2154, length: 1 }),
        ('\u{f9c3}', Slice { offset: 2155, length: 1 }),
        ('\u{f9c4}', Slice { offset: 2156, length: 1 }),
        ('\u{f9c5}', Slice { offset: 2157, length: 1 }),
        ('\u{f9c6}', Slice { offset: 2158, length: 1 }),
        ('\u{f9c7}', Slice { offset: 2159, length: 1 }),
        ('\u{f9c8}', Slice { offset: 2160, length: 1 }),
        ('\u{f9c9}', Slice { offset: 2161, length: 1 }),
        ('\u{f9ca}', Slice { offset: 2162, length: 1 }),
        ('\u{f9cb}', Slice { offset: 2163, length: 1 }),
        ('\u{f9cc}', Slice { offset: 2164, length: 1 }),
        ('\u{f9cd}', Slice { offset: 2165, length: 1 }),
        ('\u{f9ce}', Slice { offset: 2166, length: 1 }),
        ('\u{f9cf}', Slice { offset: 2167, length: 1 }),
        ('\u{f9d0}', Slice { offset: 2168, length: 1 }),
        ('\u{f9d1}', Slice { offset: 2169, length: 1 }),
        ('\u{f9d2}', Slice { offset: 2170, length: 1 }),
        ('\u{f9d3}', Slice { offset: 2171, length: 1 }),
        ('\u{f9d4}', Slice { offset: 2172, length: 1 }),
        ('\u{f9d5}', Slice { offset: 2173, length: 1 }),
        ('\u{f9d6}', Slice { offset: 2174, length: 1 }),
        ('\u{f9d7}', Slice { offset: 2175, length: 1 }),
        ('\u{f9d8}', Slice { offset: 2176, length: 1 }),
        ('\u{f9d9}', Slice { offset: 2177, length: 1 }),
        ('\u{f9da}', Slice { offset: 2178, length: 1 }),
        ('\u{f9db}', Slice { offset: 2060, length: 1 }),
        ('\u{f9dc}', Slice { offset: 2179, length: 1 }),
        ('\u{f9dd}', Slice { offset: 2180, length: 1 }),
        ('\u{f9de}', Slice { offset: 2181, length: 1 }),
        ('\u{f9df}', Slice { offset: 2182, length: 1 }),
        ('\u{f9e0}', Slice { offset: 2183, length: 1 }),
        ('\u{f9e1}', Slice { offset: 2184, length: 1 }),
        ('\u{f9e2}', Slice { offset: 2185, length: 1 }),
        ('\u{f9e3}', Slice { offset: 2186, length: 1 }),
        ('\u{f9e4}', Slice { offset: 2187, length: 1 }),
        ('\u{f9e5}', Slice { offset: 2188, length: 1 }),
        ('\u{f9e6}', Slice { offset: 2189, length: 1 }),
        ('\u{f9e7}', Slice { offset: 2190, length: 1 }),
        ('\u{f9e8}', Slice { offset: 2191, length: 1 }),
        ('\u{f9e9}', Slice { offset: 2192, length: 1 }),
        ('\u{f9ea}', Slice { offset: 2193, length: 1 }),
        ('\u{f9eb}', Slice { offset: 2194, length: 1 }),
        ('\u{f9ec}', Slice { offset: 2195, length: 1 }),
        ('\u{f9ed}', Slice { offset: 2196, length: 1 }),
        ('\u{f9ee}', Slice { offset: 2197, length: 1 }),
        ('\u{f9ef}', Slice { offset: 2198, length: 1 }),
        ('\u{f9f0}', Slice { offset: 2199, length: 1 }),
        ('\u{f9f1}', Slice { offset: 2200, length: 1 }),
        ('\u{f9f2}', Slice { offset: 2201, length: 1 }),
        ('\u{f9f3}', Slice { offset: 2202, length: 1 }),
        ('\u{f9f4}', Slice { offset: 2203, length: 1 }),
        ('\u{f9f5}', Slice { offset: 2204, length: 1 }),
        ('\u{f9f6}', Slice { offset: 2205, length: 1 }),
        ('\u{f9f7}', Slice { offset: 2206, length: 1 }),
        ('\u{f9f8}', Slice { offset: 2207, length: 1 }),
        ('\u{f9f9}', Slice { offset: 2208, length: 1 }),
        ('\u{f9fa}', Slice { offset: 2209, length: 1 }),
        ('\u{f9fb}', Slice { offset: 2210, length: 1 }),
        ('\u{f9fc}', Slice { offset: 2211, length: 1 }),
        ('\u{f9fd}', Slice { offset: 2212, length: 1 }),
        ('\u{f9fe}', Slice { offset: 2213, length: 1 }),
        ('\u{f9ff}', Slice { offset: 2214, length: 1 }),
        ('\u{fa00}', Slice { offset: 2215, length: 1 }),
        ('\u{fa01}', Slice { offset: 2216, length: 1 }),
        ('\u{fa02}', Slice { offset: 2217, length: 1 }),
        ('\u{fa03}', Slice { offset: 2218, length: 1 }),
        ('\u{fa04}', Slice { offset: 2219, length: 1 }),
        ('\u{fa05}', Slice { offset: 2220, length: 1 }),
        ('\u{fa06}', Slice { offset: 2221, length: 1 }),
        ('\u{fa07}', Slice { offset: 2222, length: 1 }),
        ('\u{fa08}', Slice { offset: 2223, length: 1 }),
        ('\u{fa09}', Slice { offset: 2224, length: 1 }),
        ('\u{fa0a}', Slice { offset: 2225, length: 1 }),
        ('\u{fa0b}', Slice { offset: 2226, length: 1 }),
        ('\u{fa0c}', Slice { offset: 2227, length: 1 }),
        ('\u{fa0d}', Slice { offset: 2228, length: 1 }),
        ('\u{fa10}', Slice { offset: 2229, length: 1 }),
        ('\u{fa12}', Slice { offset: 2230, length: 1 }),
        ('\u{fa15}', Slice { offset: 2231, length: 1 }),
        ('\u{fa16}', Slice { offset: 2232, length: 1 }),
        ('\u{fa17}', Slice { offset: 2233, length: 1 }),
        ('\u{fa18}', Slice { offset: 2234, length: 1 }),
        ('\u{fa19}', Slice { offset: 2235, length: 1 }),
        ('\u{fa1a}', Slice { offset: 2236, length: 1 }),
        ('\u{fa1b}', Slice { offset: 2237, length: 1 }),
        ('\u{fa1c}', Slice { offset: 2238, length: 1 }),
        ('\u{fa1d}', Slice { offset: 2239, length: 1 }),
        ('\u{fa1e}', Slice { offset: 2240, length: 1 }),
        ('\u{fa20}', Slice { offset: 2241, length: 1 }),
        ('\u{fa22}', Slice { offset: 2242, length: 1 }),
        ('\u{fa25}', Slice { offset: 2243, length: 1 }),
        ('\u{fa26}', Slice { offset: 2244, length: 1 }),
        ('\u{fa2a}', Slice { offset: 2245, length: 1 }),
        ('\u{fa2b}', Slice { offset: 2246, length: 1 }),
        ('\u{fa2c}', Slice { offset: 2247, length: 1 }),
        ('\u{fa2d}', Slice { offset: 2248, length: 1 }),
        ('\u{fa2e}', Slice { offset: 2249, length: 1 }),
        ('\u{fa2f}', Slice { offset: 2250, length: 1 }),
        ('\u{fa30}', Slice { offset: 2251, length: 1 }),
        ('\u{fa31}', Slice { offset: 2252, length: 1 }),
        ('\u{fa32}', Slice { offset: 2253, length: 1 }),
        ('\u{fa33}', Slice { offset: 2254, length: 1 }),
        ('\u{fa34}', Slice { offset: 2255, length: 1 }),
        ('\u{fa35}', Slice { offset: 2256, length: 1 }),
        ('\u{fa36}', Slice { offset: 2257, length: 1 }),
        ('\u{fa37}', Slice { offset: 2258, length: 1 }),
        ('\u{fa38}', Slice { offset: 2259, length: 1 }),
        ('\u{fa39}', Slice { offset: 2260, length: 1 }),
        ('\u{fa3a}', Slice { offset: 2261, length: 1 }),
        ('\u{fa3b}', Slice { offset: 2262, length: 1 }),
        ('\u{fa3c}', Slice { offset: 2263, length: 1 }),
        ('\u{fa3d}', Slice { offset: 2264, length: 1 }),
        ('\u{fa3e}', Slice { offset: 2265, length: 1 }),
        ('\u{fa3f}', Slice { offset: 2266, length: 1 }),
        ('\u{fa40}', Slice { offset: 2267, length: 1 }),
        ('\u{fa41}', Slice { offset: 2268, length: 1 }),
        ('\u{fa42}', Slice { offset: 2269, length: 1 }),
        ('\u{fa43}', Slice { offset: 2270, length: 1 }),
        ('\u{fa44}', Slice { offset: 2271, length: 1 }),
        ('\u{fa45}', Slice { offset: 2272, length: 1 }),
        ('\u{fa46}', Slice { offset: 2273, length: 1 }),
        ('\u{fa47}', Slice { offset: 2274, length: 1 }),
        ('\u{fa48}', Slice { offset: 2275, length: 1 }),
        ('\u{fa49}', Slice { offset: 2276, length: 1 }),
        ('\u{fa4a}', Slice { offset: 2277, length: 1 }),
        ('\u{fa4b}', Slice { offset: 2278, length: 1 }),
        ('\u{fa4c}', Slice { offset: 2279, length: 1 }),
        ('\u{fa4d}', Slice { offset: 2280, length: 1 }),
        ('\u{fa4e}', Slice { offset: 2281, length: 1 }),
        ('\u{fa4f}', Slice { offset: 2282, length: 1 }),
        ('\u{fa50}', Slice { offset: 2283, length: 1 }),
        ('\u{fa51}', Slice { offset: 2284, length: 1 }),
        ('\u{fa52}', Slice { offset: 2285, length: 1 }),
        ('\u{fa53}', Slice { offset: 2286, length: 1 }),
        ('\u{fa54}', Slice { offset: 2287, length: 1 }),
        ('\u{fa55}', Slice { offset: 2288, length: 1 }),
        ('\u{fa56}', Slice { offset: 2289, length: 1 }),
        ('\u{fa57}', Slice { offset: 2113, length: 1 }),
        ('\u{fa58}', Slice { offset: 2290, length: 1 }),
        ('\u{fa59}', Slice { offset: 2291, length: 1 }),
        ('\u{fa5a}', Slice { offset: 2292, length: 1 }),
        ('\u{fa5b}', Slice { offset: 2293, length: 1 }),
        ('\u{fa5c}', Slice { offset: 2294, length: 1 }),
        ('\u{fa5d}', Slice { offset: 2295, length: 1 }),
        ('\u{fa5e}', Slice { offset: 2295, length: 1 }),
        ('\u{fa5f}', Slice { offset: 2296, length: 1 }),
        ('\u{fa60}', Slice { offset: 2297, length: 1 }),
        ('\u{fa61}', Slice { offset: 2298, length: 1 }),
        ('\u{fa62}', Slice { offset: 2299, length: 1 }),
        ('\u{fa63}', Slice { offset: 2300, length: 1 }),
        ('\u{fa64}', Slice { offset: 2301, length: 1 }),
        ('\u{fa65}', Slice { offset: 2302, length: 1 }),
        ('\u{fa66}', Slice { offset: 2303, length: 1 }),
        ('\u{fa67}', Slice { offset: 2243, length: 1 }),
        ('\u{fa68}', Slice { offset: 2304, length: 1 }),
        ('\u{fa69}', Slice { offset: 2305, length: 1 }),
        ('\u{fa6a}', Slice { offset: 2306, length: 1 }),
        ('\u{fa6b}', Slice { offset: 2307, length: 1 }),
        ('\u{fa6c}', Slice { offset: 2308, length: 1 }),
        ('\u{fa6d}', Slice { offset: 2309, length: 1 }),
        ('\u{fa70}', Slice { offset: 2310, length: 1 }),
        ('\u{fa71}', Slice { offset: 2311, length: 1 }),
        ('\u{fa72}', Slice { offset: 2312, length: 1 }),
        ('\u{fa73}', Slice { offset: 2313, length: 1 }),
        ('\u{fa74}', Slice { offset: 2314, length: 1 }),
        ('\u{fa75}', Slice { offset: 2315, length: 1 }),
        ('\u{fa76}', Slice { offset: 2316, length: 1 }),
        ('\u{fa77}', Slice { offset: 2317, length: 1 }),
        ('\u{fa78}', Slice { offset: 2257, length: 1 }),
        ('\u{fa79}', Slice { offset: 2318, length: 1 }),
        ('\u{fa7a}', Slice { offset: 2319, length: 1 }),
        ('\u{fa7b}', Slice { offset: 2320, length: 1 }),
        ('\u{fa7c}', Slice { offset: 2229, length: 1 }),
        ('\u{fa7d}', Slice { offset: 2321, length: 1 }),
        ('\u{fa7e}', Slice { offset: 2322, length: 1 }),
        ('\u{fa7f}', Slice { offset: 2323, length: 1 }),
        ('\u{fa80}', Slice { offset: 2324, length: 1 }),
        ('\u{fa81}', Slice { offset: 2325, length: 1 }),
        ('\u{fa82}', Slice { offset: 2326, length: 1 }),
        ('\u{fa83}', Slice { offset: 2327, length: 1 }),
        ('\u{fa84}', Slice { offset: 2328, length: 1 }),
        ('\u{fa85}', Slice { offset: 2329, length: 1 }),
        ('\u{fa86}', Slice { offset: 2330, length: 1 }),
        ('\u{fa87}', Slice { offset: 2331, length: 1 }),
        ('\u{fa88}', Slice { offset: 2332, length: 1 }),
        ('\u{fa89}', Slice { offset: 2266, length: 1 }),
        ('\u{fa8a}', Slice { offset: 2333, length: 1 }),
        ('\u{fa8b}', Slice { offset: 2267, length: 1 }),
        ('\u{fa8c}', Slice { offset: 2334, length: 1 }),
        ('\u{fa8d}', Slice { offset: 2335, length: 1 }),
        ('\u{fa8e}', Slice { offset: 2336, length: 1 }),
        ('\u{fa8f}', Slice { offset: 2337, length: 1 }),
        ('\u{fa90}', Slice { offset: 2338, length: 1 }),
        ('\u{fa91}', Slice { offset: 2230, length: 1 }),
        ('\u{fa92}', Slice { offset: 2005, length: 1 }),
        ('\u{fa93}', Slice { offset: 2339, length: 1 }),
        ('\u{fa94}', Slice { offset: 2340, length: 1 }),
        ('\u{fa95}', Slice { offset: 2341, length: 1 }),
        ('\u{fa96}', Slice { offset: 2075, length: 1 }),
        ('\u{fa97}', Slice { offset: 2162, length: 1 }),
        ('\u{fa98}', Slice { offset: 2342, length: 1 }),
        ('\u{fa99}', Slice { offset: 2343, length: 1 }),
        ('\u{fa9a}', Slice { offset: 2274, length: 1 }),
        ('\u{fa9b}', Slice { offset: 2344, length: 1 }),
        ('\u{fa9c}', Slice { offset: 2275, length: 1 }),
        ('\u{fa9d}', Slice { offset: 2345, length: 1 }),
        ('\u{fa9e}', Slice { offset: 2346, length: 1 }),
        ('\u{fa9f}', Slice { offset: 2347, length: 1 }),
        ('\u{faa0}', Slice { offset: 2232, length: 1 }),
        ('\u{faa1}', Slice { offset: 2348, length: 1 }),
        ('\u{faa2}', Slice { offset: 2349, length: 1 }),
        ('\u{faa3}', Slice { offset: 2350, length: 1 }),
        ('\u{faa4}', Slice { offset: 2351, length: 1 }),
        ('\u{faa5}', Slice { offset: 2352, length: 1 }),
        ('\u{faa6}', Slice { offset: 2233, length: 1 }),
        ('\u{faa7}', Slice { offset: 2353, length: 1 }),
        ('\u{faa8}', Slice { offset: 2354, length: 1 }),
        ('\u{faa9}', Slice { offset: 2355, length: 1 }),
        ('\u{faaa}', Slice { offset: 2356, length: 1 }),
        ('\u{faab}', Slice { offset: 2357, length: 1 }),
        ('\u{faac}', Slice { offset: 2358, length: 1 }),
        ('\u{faad}', Slice { offset: 2289, length: 1 }),
        ('\u{faae}', Slice { offset: 2359, length: 1 }),
        ('\u{faaf}', Slice { offset: 2360, length: 1 }),
        ('\u{fab0}', Slice { offset: 2113, length: 1 }),
        ('\u{fab1}', Slice { offset: 2361, length: 1 }),
        ('\u{fab2}', Slice { offset: 2293, length: 1 }),
        ('\u{fab3}', Slice { offset: 2362, length: 1 }),
        ('\u{fab4}', Slice { offset: 2363, length: 1 }),
        ('\u{fab5}', Slice { offset: 2364, length: 1 }),
        ('\u{fab6}', Slice { offset: 2365, length: 1 }),
        ('\u{fab7}', Slice { offset: 2366, length: 1 }),
        ('\u{fab8}', Slice { offset: 2298, length: 1 }),
        ('\u{fab9}', Slice { offset: 2367, length: 1 }),
        ('\u{faba}', Slice { offset: 2242, length: 1 }),
        ('\u{fabb}', Slice { offset: 2368, length: 1 }),
        ('\u{fabc}', Slice { offset: 2299, length: 1 }),
        ('\u{fabd}', Slice { offset: 2056, length: 1 }),
        ('\u{fabe}', Slice { offset: 2369, length: 1 }),
        ('\u{fabf}', Slice { offset: 2300, length: 1 }),
        ('\u{fac0}', Slice { offset: 2370, length: 1 }),
        ('\u{fac1}', Slice { offset: 2302, length: 1 }),
        ('\u{fac2}', Slice { offset: 2371, length: 1 }),
        ('\u{fac3}', Slice { offset: 2372, length: 1 }),
        ('\u{fac4}', Slice { offset: 2373, length: 1 }),
        ('\u{fac5}', Slice { offset: 2374, length: 1 }),
        ('\u{fac6}', Slice { offset: 2375, length: 1 }),
        ('\u{fac7}', Slice { offset: 2304, length: 1 }),
        ('\u{fac8}', Slice { offset: 2238, length: 1 }),
        ('\u{fac9}', Slice { offset: 2376, length: 1 }),
        ('\u{faca}', Slice { offset: 2305, length: 1 }),
        ('\u{facb}', Slice { offset: 2377, length: 1 }),
        ('\u{facc}', Slice { offset: 2306, length: 1 }),
        ('\u{facd}', Slice { offset: 2378, length: 1 }),
        ('\u{face}', Slice { offset: 1972, length: 1 }),
        ('\u{facf}', Slice { offset: 2379, length: 1 }),
        ('\u{fad0}', Slice { offset: 2380, length: 1 }),
        ('\u{fad1}', Slice { offset: 2381, length: 1 }),
        ('\u{fad2}', Slice { offset: 2382, length: 1 }),
        ('\u{fad3}', Slice { offset: 2383, length: 1 }),
        ('\u{fad4}', Slice { offset: 2384, length: 1 }),
        ('\u{fad5}', Slice { offset: 2385, length: 1 }),
        ('\u{fad6}', Slice { offset: 2386, length: 1 }),
        ('\u{fad7}', Slice { offset: 2387, length: 1 }),
        ('\u{fad8}', Slice { offset: 2388, length: 1 }),
        ('\u{fad9}', Slice { offset: 2389, length: 1 }),
        ('\u{fb1d}', Slice { offset: 2390, length: 2 }),
        ('\u{fb1f}', Slice { offset: 2392, length: 2 }),
        ('\u{fb2a}', Slice { offset: 2394, length: 2 }),
        ('\u{fb2b}', Slice { offset: 2396, length: 2 }),
        ('\u{fb2c}', Slice { offset: 2398, length: 2 }),
        ('\u{fb2d}', Slice { offset: 2400, length: 2 }),
        ('\u{fb2e}', Slice { offset: 2402, length: 2 }),
        ('\u{fb2f}', Slice { offset: 2404, length: 2 }),
        ('\u{fb30}', Slice { offset: 2406, length: 2 }),
        ('\u{fb31}', Slice { offset: 2408, length: 2 }),
        ('\u{fb32}', Slice { offset: 2410, length: 2 }),
        ('\u{fb33}', Slice { offset: 2412, length: 2 }),
        ('\u{fb34}', Slice { offset: 2414, length: 2 }),
        ('\u{fb35}', Slice { offset: 2416, length: 2 }),
        ('\u{fb36}', Slice { offset: 2418, length: 2 }),
        ('\u{fb38}', Slice { offset: 2420, length: 2 }),
        ('\u{fb39}', Slice { offset: 2422, length: 2 }),
        ('\u{fb3a}', Slice { offset: 2424, length: 2 }),
        ('\u{fb3b}', Slice { offset: 2426, length: 2 }),
        ('\u{fb3c}', Slice { offset: 2428, length: 2 }),
        ('\u{fb3e}', Slice { offset: 2430, length: 2 }),
        ('\u{fb40}', Slice { offset: 2432, length: 2 }),
        ('\u{fb41}', Slice { offset: 2434, length: 2 }),
        ('\u{fb43}', Slice { offset: 2436, length: 2 }),
        ('\u{fb44}', Slice { offset: 2438, length: 2 }),
        ('\u{fb46}', Slice { offset: 2440, length: 2 }),
        ('\u{fb47}', Slice { offset: 2442, length: 2 }),
        ('\u{fb48}', Slice { offset: 2444, length: 2 }),
        ('\u{fb49}', Slice { offset: 2446, length: 2 }),
        ('\u{fb4a}', Slice { offset: 2448, length: 2 }),
        ('\u{fb4b}', Slice { offset: 2450, length: 2 }),
        ('\u{fb4c}', Slice { offset: 2452, length: 2 }),
        ('\u{fb4d}', Slice { offset: 2454, length: 2 }),
        ('\u{fb4e}', Slice { offset: 2456, length: 2 }),
        ('\u{1109a}', Slice { offset: 2458, length: 2 }),
        ('\u{1109c}', Slice { offset: 2460, length: 2 }),
        ('\u{110ab}', Slice { offset: 2462, length: 2 }),
        ('\u{1112e}', Slice { offset: 2464, length: 2 }),
        ('\u{1112f}', Slice { offset: 2466, length: 2 }),
        ('\u{1134b}', Slice { offset: 2468, length: 2 }),
        ('\u{1134c}', Slice { offset: 2470, length: 2 }),
        ('\u{114bb}', Slice { offset: 2472, length: 2 }),
        ('\u{114bc}', Slice { offset: 2474, length: 2 }),
        ('\u{114be}', Slice { offset: 2476, length: 2 }),
        ('\u{115ba}', Slice { offset: 2478, length: 2 }),
        ('\u{115bb}', Slice { offset: 2480, length: 2 }),
        ('\u{1d15e}', Slice { offset: 2482, length: 2 }),
        ('\u{1d15f}', Slice { offset: 2484, length: 2 }),
        ('\u{1d160}', Slice { offset: 2486, length: 2 }),
        ('\u{1d161}', Slice { offset: 2488, length: 2 }),
        ('\u{1d162}', Slice { offset: 2490, length: 2 }),
        ('\u{1d163}', Slice { offset: 2492, length: 2 }),
        ('\u{1d164}', Slice { offset: 2494, length: 2 }),
        ('\u{1d1bb}', Slice { offset: 2496, length: 2 }),
        ('\u{1d1bc}', Slice { offset: 2498, length: 2 }),
        ('\u{1d1bd}', Slice { offset: 2500, length: 2 }),
        ('\u{1d1be}', Slice { offset: 2502, length: 2 }),
        ('\u{1d1bf}', Slice { offset: 2504, length: 2 }),
        ('\u{1d1c0}', Slice { offset: 2506, length: 2 }),
        ('\u{2f800}', Slice { offset: 2508, length: 1 }),
        ('\u{2f801}', Slice { offset: 2509, length: 1 }),
        ('\u{2f802}', Slice { offset: 2510, length: 1 }),
        ('\u{2f803}', Slice { offset: 2511, length: 1 }),
        ('\u{2f804}', Slice { offset: 2512, length: 1 }),
        ('\u{2f805}', Slice { offset: 2251, length: 1 }),
        ('\u{2f806}', Slice { offset: 2513, length: 1 }),
        ('\u{2f807}', Slice { offset: 2514, length: 1 }),
        ('\u{2f808}', Slice { offset: 2515, length: 1 }),
        ('\u{2f809}', Slice { offset: 2516, length: 1 }),
        ('\u{2f80a}', Slice { offset: 2252, length: 1 }),
        ('\u{2f80b}', Slice { offset: 2517, length: 1 }),
        ('\u{2f80c}', Slice { offset: 2518, length: 1 }),
        ('\u{2f80d}', Slice { offset: 2519, length: 1 }),
        ('\u{2f80e}', Slice { offset: 2253, length: 1 }),
        ('\u{2f80f}', Slice { offset: 2520, length: 1 }),
        ('\u{2f810}', Slice { offset: 2521, length: 1 }),
        ('\u{2f811}', Slice { offset: 2522, length: 1 }),
        ('\u{2f812}', Slice { offset: 2523, length: 1 }),
        ('\u{2f813}', Slice { offset: 2524, length: 1 }),
        ('\u{2f814}', Slice { offset: 2525, length: 1 }),
        ('\u{2f815}', Slice { offset: 2526, length: 1 }),
        ('\u{2f816}', Slice { offset: 2527, length: 1 }),
        ('\u{2f817}', Slice { offset: 2528, length: 1 }),
        ('\u{2f818}', Slice { offset: 2529, length: 1 }),
        ('\u{2f819}', Slice { offset: 2530, length: 1 }),
        ('\u{2f81a}', Slice { offset: 2531, length: 1 }),
        ('\u{2f81b}', Slice { offset: 2311, length: 1 }),
        ('\u{2f81c}', Slice { offset: 2532, length: 1 }),
        ('\u{2f81d}', Slice { offset: 2533, length: 1 }),
        ('\u{2f81e}', Slice { offset: 2534, length: 1 }),
        ('\u{2f81f}', Slice { offset: 2535, length: 1 }),
        ('\u{2f820}', Slice { offset: 2536, length: 1 }),
        ('\u{2f821}', Slice { offset: 2537, length: 1 }),
        ('\u{2f822}', Slice { offset: 2538, length: 1 }),
        ('\u{2f823}', Slice { offset: 2539, length: 1 }),
        ('\u{2f824}', Slice { offset: 2540, length: 1 }),
        ('\u{2f825}', Slice { offset: 2316, length: 1 }),
        ('\u{2f826}', Slice { offset: 2254, length: 1 }),
        ('\u{2f827}', Slice { offset: 2255, length: 1 }),
        ('\u{2f828}', Slice { offset: 2317, length: 1 }),
        ('\u{2f829}', Slice { offset: 2541, length: 1 }),
        ('\u{2f82a}', Slice { offset: 2542, length: 1 }),
        ('\u{2f82b}', Slice { offset: 2062, length: 1 }),
        ('\u{2f82c}', Slice { offset: 2543, length: 1 }),
        ('\u{2f82d}', Slice { offset: 2256, length: 1 }),
        ('\u{2f82e}', Slice { offset: 2544, length: 1 }),
        ('\u{2f82f}', Slice { offset: 2545, length: 1 }),
        ('\u{2f830}', Slice { offset: 2546, length: 1 }),
        ('\u{2f831}', Slice { offset: 2547, length: 1 }),
        ('\u{2f832}', Slice { offset: 2547, length: 1 }),
        ('\u{2f833}', Slice { offset: 2547, length: 1 }),
        ('\u{2f834}', Slice { offset: 2548, length: 1 }),
        ('\u{2f835}', Slice { offset: 2549, length: 1 }),
        ('\u{2f836}', Slice { offset: 2550, length: 1 }),
        ('\u{2f837}', Slice { offset: 2551, length: 1 }),
        ('\u{2f838}', Slice { offset: 2552, length: 1 }),
        ('\u{2f839}', Slice { offset: 2553, length: 1 }),
        ('\u{2f83a}', Slice { offset: 2554, length: 1 }),
        ('\u{2f83b}', Slice { offset: 2555, length: 1 }),
        ('\u{2f83c}', Slice { offset: 2556, length: 1 }),
        ('\u{2f83d}', Slice { offset: 2557, length: 1 }),
        ('\u{2f83e}', Slice { offset: 2558, length: 1 }),
        ('\u{2f83f}', Slice { offset: 2559, length: 1 }),
        ('\u{2f840}', Slice { offset: 2560, length: 1 }),
        ('\u{2f841}', Slice { offset: 2561, length: 1 }),
        ('\u{2f842}', Slice { offset: 2562, length: 1 }),
        ('\u{2f843}', Slice { offset: 2563, length: 1 }),
        ('\u{2f844}', Slice { offset: 2564, length: 1 }),
        ('\u{2f845}', Slice { offset: 2565, length: 1 }),
        ('\u{2f846}', Slice { offset: 2565, length: 1 }),
        ('\u{2f847}', Slice { offset: 2319, length: 1 }),
        ('\u{2f848}', Slice { offset: 2566, length: 1 }),
        ('\u{2f849}', Slice { offset: 2567, length: 1 }),
        ('\u{2f84a}', Slice { offset: 2568, length: 1 }),
        ('\u{2f84b}', Slice { offset: 2569, length: 1 }),
        ('\u{2f84c}', Slice { offset: 2258, length: 1 }),
        ('\u{2f84d}', Slice { offset: 2570, length: 1 }),
        ('\u{2f84e}', Slice { offset: 2571, length: 1 }),
        ('\u{2f84f}', Slice { offset: 2572, length: 1 }),
        ('\u{2f850}', Slice { offset: 2215, length: 1 }),
        ('\u{2f851}', Slice { offset: 2573, length: 1 }),
        ('\u{2f852}', Slice { offset: 2574, length: 1 }),
        ('\u{2f853}', Slice { offset: 2575, length: 1 }),
        ('\u{2f854}', Slice { offset: 2576, length: 1 }),
        ('\u{2f855}', Slice { offset: 2577, length: 1 }),
        ('\u{2f856}', Slice { offset: 2578, length: 1 }),
        ('\u{2f857}', Slice { offset: 2579, length: 1 }),
        ('\u{2f858}', Slice { offset: 2580, length: 1 }),
        ('\u{2f859}', Slice { offset: 2581, length: 1 }),
        ('\u{2f85a}', Slice { offset: 2582, length: 1 }),
        ('\u{2f85b}', Slice { offset: 2583, length: 1 }),
        ('\u{2f85c}', Slice { offset: 2584, length: 1 }),
        ('\u{2f85d}', Slice { offset: 2585, length: 1 }),
        ('\u{2f85e}', Slice { offset: 2586, length: 1 }),
        ('\u{2f85f}', Slice { offset: 2587, length: 1 }),
        ('\u{2f860}', Slice { offset: 2588, length: 1 }),
        ('\u{2f861}', Slice { offset: 2589, length: 1 }),
        ('\u{2f862}', Slice { offset: 2590, length: 1 }),
        ('\u{2f863}', Slice { offset: 2591, length: 1 }),
        ('\u{2f864}', Slice { offset: 2592, length: 1 }),
        ('\u{2f865}', Slice { offset: 2593, length: 1 }),
        ('\u{2f866}', Slice { offset: 2594, length: 1 }),
        ('\u{2f867}', Slice { offset: 2595, length: 1 }),
        ('\u{2f868}', Slice { offset: 2596, length: 1 }),
        ('\u{2f869}', Slice { offset: 2597, length: 1 }),
        ('\u{2f86a}', Slice { offset: 2598, length: 1 }),
        ('\u{2f86b}', Slice { offset: 2598, length: 1 }),
        ('\u{2f86c}', Slice { offset: 2599, length: 1 }),
        ('\u{2f86d}', Slice { offset: 2600, length: 1 }),
        ('\u{2f86e}', Slice { offset: 2601, length: 1 }),
        ('\u{2f86f}', Slice { offset: 2058, length: 1 }),
        ('\u{2f870}', Slice { offset: 2602, length: 1 }),
        ('\u{2f871}', Slice { offset: 2603, length: 1 }),
        ('\u{2f872}', Slice { offset: 2604, length: 1 }),
        ('\u{2f873}', Slice { offset: 2605, length: 1 }),
        ('\u{2f874}', Slice { offset: 2606, length: 1 }),
        ('\u{2f875}', Slice { offset: 2607, length: 1 }),
        ('\u{2f876}', Slice { offset: 2608, length: 1 }),
        ('\u{2f877}', Slice { offset: 2609, length: 1 }),
        ('\u{2f878}', Slice { offset: 2263, length: 1 }),
        ('\u{2f879}', Slice { offset: 2610, length: 1 }),
        ('\u{2f87a}', Slice { offset: 2611, length: 1 }),
        ('\u{2f87b}', Slice { offset: 2612, length: 1 }),
        ('\u{2f87c}', Slice { offset: 2613, length: 1 }),
        ('\u{2f87d}', Slice { offset: 2614, length: 1 }),
        ('\u{2f87e}', Slice { offset: 2615, length: 1 }),
        ('\u{2f87f}', Slice { offset: 2616, length: 1 }),
        ('\u{2f880}', Slice { offset: 2617, length: 1 }),
        ('\u{2f881}', Slice { offset: 2618, length: 1 }),
        ('\u{2f882}', Slice { offset: 2619, length: 1 }),
        ('\u{2f883}', Slice { offset: 2620, length: 1 }),
        ('\u{2f884}', Slice { offset: 2621, length: 1 }),
        ('\u{2f885}', Slice { offset: 2622, length: 1 }),
        ('\u{2f886}', Slice { offset: 2623, length: 1 }),
        ('\u{2f887}', Slice { offset: 2624, length: 1 }),
        ('\u{2f888}', Slice { offset: 2625, length: 1 }),
        ('\u{2f889}', Slice { offset: 2626, length: 1 }),
        ('\u{2f88a}', Slice { offset: 2627, length: 1 }),
        ('\u{2f88b}', Slice { offset: 2628, length: 1 }),
        ('\u{2f88c}', Slice { offset: 2629, length: 1 }),
        ('\u{2f88d}', Slice { offset: 2630, length: 1 }),
        ('\u{2f88e}', Slice { offset: 2004, length: 1 }),
        ('\u{2f88f}', Slice { offset: 2631, length: 1 }),
        ('\u{2f890}', Slice { offset: 2632, length: 1 }),
        ('\u{2f891}', Slice { offset: 2633, length: 1 }),
        ('\u{2f892}', Slice { offset: 2633, length: 1 }),
        ('\u{2f893}', Slice { offset: 2634, length: 1 }),
        ('\u{2f894}', Slice { offset: 2635, length: 1 }),
        ('\u{2f895}', Slice { offset: 2635, length: 1 }),
        ('\u{2f896}', Slice { offset: 2636, length: 1 }),
        ('\u{2f897}', Slice { offset: 2637, length: 1 }),
        ('\u{2f898}', Slice { offset: 2638, length: 1 }),
        ('\u{2f899}', Slice { offset: 2639, length: 1 }),
        ('\u{2f89a}', Slice { offset: 2640, length: 1 }),
        ('\u{2f89b}', Slice { offset: 2641, length: 1 }),
        ('\u{2f89c}', Slice { offset: 2642, length: 1 }),
        ('\u{2f89d}', Slice { offset: 2643, length: 1 }),
        ('\u{2f89e}', Slice { offset: 2644, length: 1 }),
        ('\u{2f89f}', Slice { offset: 2645, length: 1 }),
        ('\u{2f8a0}', Slice { offset: 2646, length: 1 }),
        ('\u{2f8a1}', Slice { offset: 2647, length: 1 }),
        ('\u{2f8a2}', Slice { offset: 2648, length: 1 }),
        ('\u{2f8a3}', Slice { offset: 2264, length: 1 }),
        ('\u{2f8a4}', Slice { offset: 2649, length: 1 }),
        ('\u{2f8a5}', Slice { offset: 2650, length: 1 }),
        ('\u{2f8a6}', Slice { offset: 2651, length: 1 }),
        ('\u{2f8a7}', Slice { offset: 2652, length: 1 }),
        ('\u{2f8a8}', Slice { offset: 2331, length: 1 }),
        ('\u{2f8a9}', Slice { offset: 2652, length: 1 }),
        ('\u{2f8aa}', Slice { offset: 2653, length: 1 }),
        ('\u{2f8ab}', Slice { offset: 2266, length: 1 }),
        ('\u{2f8ac}', Slice { offset: 2654, length: 1 }),
        ('\u{2f8ad}', Slice { offset: 2655, length: 1 }),
        ('\u{2f8ae}', Slice { offset: 2656, length: 1 }),
        ('\u{2f8af}', Slice { offset: 2657, length: 1 }),
        ('\u{2f8b0}', Slice { offset: 2267, length: 1 }),
        ('\u{2f8b1}', Slice { offset: 1977, length: 1 }),
        ('\u{2f8b2}', Slice { offset: 2658, length: 1 }),
        ('\u{2f8b3}', Slice { offset: 2659, length: 1 }),
        ('\u{2f8b4}', Slice { offset: 2660, length: 1 }),
        ('\u{2f8b5}', Slice { offset: 2661, length: 1 }),
        ('\u{2f8b6}', Slice { offset: 2662, length: 1 }),
        ('\u{2f8b7}', Slice { offset: 2663, length: 1 }),
        ('\u{2f8b8}', Slice { offset: 2664, length: 1 }),
        ('\u{2f8b9}', Slice { offset: 2665, length: 1 }),
        ('\u{2f8ba}', Slice { offset: 2666, length: 1 }),
        ('\u{2f8bb}', Slice { offset: 2667, length: 1 }),
        ('\u{2f8bc}', Slice { offset: 2668, length: 1 }),
        ('\u{2f8bd}', Slice { offset: 2669, length: 1 }),
        ('\u{2f8be}', Slice { offset: 2670, length: 1 }),
        ('\u{2f8bf}', Slice { offset: 2671, length: 1 }),
        ('\u{2f8c0}', Slice { offset: 2672, length: 1 }),
        ('\u{2f8c1}', Slice { offset: 2673, length: 1 }),
        ('\u{2f8c2}', Slice { offset: 2674, length: 1 }),
        ('\u{2f8c3}', Slice { offset: 2675, length: 1 }),
        ('\u{2f8c4}', Slice { offset: 2676, length: 1 }),
        ('\u{2f8c5}', Slice { offset: 2677, length: 1 }),
        ('\u{2f8c6}', Slice { offset: 2678, length: 1 }),
        ('\u{2f8c7}', Slice { offset: 2679, length: 1 }),
        ('\u{2f8c8}', Slice { offset: 2268, length: 1 }),
        ('\u{2f8c9}', Slice { offset: 2680, length: 1 }),
        ('\u{2f8ca}', Slice { offset: 2681, length: 1 }),
        ('\u{2f8cb}', Slice { offset: 2682, length: 1 }),
        ('\u{2f8cc}', Slice { offset: 2683, length: 1 }),
        ('\u{2f8cd}', Slice { offset: 2684, length: 1 }),
        ('\u{2f8ce}', Slice { offset: 2685, length: 1 }),
        ('\u{2f8cf}', Slice { offset: 2270, length: 1 }),
        ('\u{2f8d0}', Slice { offset: 2686, length: 1 }),
        ('\u{2f8d1}', Slice { offset: 2687, length: 1 }),
        ('\u{2f8d2}', Slice { offset: 2688, length: 1 }),
        ('\u{2f8d3}', Slice { offset: 2689, length: 1 }),
        ('\u{2f8d4}', Slice { offset: 2690, length: 1 }),
        ('\u{2f8d5}', Slice { offset: 2691, length: 1 }),
        ('\u{2f8d6}', Slice { offset: 2692, length: 1 }),
        ('\u{2f8d7}', Slice { offset: 2693, length: 1 }),
        ('\u{2f8d8}', Slice { offset: 2005, length: 1 }),
        ('\u{2f8d9}', Slice { offset: 2339, length: 1 }),
        ('\u{2f8da}', Slice { offset: 2694, length: 1 }),
        ('\u{2f8db}', Slice { offset: 2695, length: 1 }),
        ('\u{2f8dc}', Slice { offset: 2696, length: 1 }),
        ('\u{2f8dd}', Slice { offset: 2697, length: 1 }),
        ('\u{2f8de}', Slice { offset: 2698, length: 1 }),
        ('\u{2f8df}', Slice { offset: 2699, length: 1 }),
        ('\u{2f8e0}', Slice { offset: 2700, length: 1 }),
        ('\u{2f8e1}', Slice { offset: 2701, length: 1 }),
        ('\u{2f8e2}', Slice { offset: 2271, length: 1 }),
        ('\u{2f8e3}', Slice { offset: 2702, length: 1 }),
        ('\u{2f8e4}', Slice { offset: 2703, length: 1 }),
        ('\u{2f8e5}', Slice { offset: 2704, length: 1 }),
        ('\u{2f8e6}', Slice { offset: 2705, length: 1 }),
        ('\u{2f8e7}', Slice { offset: 2382, length: 1 }),
        ('\u{2f8e8}', Slice { offset: 2706, length: 1 }),
        ('\u{2f8e9}', Slice { offset: 2707, length: 1 }),
        ('\u{2f8ea}', Slice { offset: 2708, length: 1 }),
        ('\u{2f8eb}', Slice { offset: 2709, length: 1 }),
        ('\u{2f8ec}', Slice { offset: 2710, length: 1 }),
        ('\u{2f8ed}', Slice { offset: 2711, length: 1 }),
        ('\u{2f8ee}', Slice { offset: 2712, length: 1 }),
        ('\u{2f8ef}', Slice { offset: 2713, length: 1 }),
        ('\u{2f8f0}', Slice { offset: 2714, length: 1 }),
        ('\u{2f8f1}', Slice { offset: 2715, length: 1 }),
        ('\u{2f8f2}', Slice { offset: 2716, length: 1 }),
        ('\u{2f8f3}', Slice { offset: 2717, length: 1 }),
        ('\u{2f8f4}', Slice { offset: 2718, length: 1 }),
        ('\u{2f8f5}', Slice { offset: 2075, length: 1 }),
        ('\u{2f8f6}', Slice { offset: 2719, length: 1 }),
        ('\u{2f8f7}', Slice { offset: 2720, length: 1 }),
        ('\u{2f8f8}', Slice { offset: 2721, length: 1 }),
        ('\u{2f8f9}', Slice { offset: 2722, length: 1 }),
        ('\u{2f8fa}', Slice { offset: 2723, length: 1 }),
        ('\u{2f8fb}', Slice { offset: 2724, length: 1 }),
        ('\u{2f8fc}', Slice { offset: 2725, length: 1 }),
        ('\u{2f8fd}', Slice { offset: 2726, length: 1 }),
        ('\u{2f8fe}', Slice { offset: 2727, length: 1 }),
        ('\u{2f8ff}', Slice { offset: 2728, length: 1 }),
        ('\u{2f900}', Slice { offset: 2729, length: 1 }),
        ('\u{2f901}', Slice { offset: 2272, length: 1 }),
        ('\u{2f902}', Slice { offset: 2162, length: 1 }),
        ('\u{2f903}', Slice { offset: 2730, length: 1 }),
        ('\u{2f904}', Slice { offset: 2731, length: 1 }),
        ('\u{2f905}', Slice { offset: 2732, length: 1 }),
        ('\u{2f906}', Slice { offset: 2733, length: 1 }),
        ('\u{2f907}', Slice { offset: 2734, length: 1 }),
        ('\u{2f908}', Slice { offset: 2735, length: 1 }),
        ('\u{2f909}', Slice { offset: 2736, length: 1 }),
        ('\u{2f90a}', Slice { offset: 2737, length: 1 }),
        ('\u{2f90b}', Slice { offset: 2343, length: 1 }),
        ('\u{2f90c}', Slice { offset: 2738, length: 1 }),
        ('\u{2f90d}', Slice { offset: 2739, length: 1 }),
        ('\u{2f90e}', Slice { offset: 2740, length: 1 }),
        ('\u{2f90f}', Slice { offset: 2741, length: 1 }),
        ('\u{2f910}', Slice { offset: 2742, length: 1 }),
        ('\u{2f911}', Slice { offset: 2743, length: 1 }),
        ('\u{2f912}', Slice { offset: 2744, length: 1 }),
        ('\u{2f913}', Slice { offset: 2745, length: 1 }),
        ('\u{2f914}', Slice { offset: 2344, length: 1 }),
        ('\u{2f915}', Slice { offset: 2746, length: 1 }),
        ('\u{2f916}', Slice { offset: 2747, length: 1 }),
        ('\u{2f917}', Slice { offset: 2748, length: 1 }),
        ('\u{2f918}', Slice { offset: 2749, length: 1 }),
        ('\u{2f919}', Slice { offset: 2750, length: 1 }),
        ('\u{2f91a}', Slice { offset: 2751, length: 1 }),
        ('\u{2f91b}', Slice { offset: 2752, length: 1 }),
        ('\u{2f91c}', Slice { offset: 2753, length: 1 }),
        ('\u{2f91d}', Slice { offset: 2754, length: 1 }),
        ('\u{2f91e}', Slice { offset: 2755, length: 1 }),
        ('\u{2f91f}', Slice { offset: 2756, length: 1 }),
        ('\u{2f920}', Slice { offset: 2757, length: 1 }),
        ('\u{2f921}', Slice { offset: 2346, length: 1 }),
        ('\u{2f922}', Slice { offset: 2758, length: 1 }),
        ('\u{2f923}', Slice { offset: 2759, length: 1 }),
        ('\u{2f924}', Slice { offset: 2760, length: 1 }),
        ('\u{2f925}', Slice { offset: 2761, length: 1 }),
        ('\u{2f926}', Slice { offset: 2762, length: 1 }),
        ('\u{2f927}', Slice { offset: 2763, length: 1 }),
        ('\u{2f928}', Slice { offset: 2764, length: 1 }),
        ('\u{2f929}', Slice { offset: 2765, length: 1 }),
        ('\u{2f92a}', Slice { offset: 2766, length: 1 }),
        ('\u{2f92b}', Slice { offset: 2767, length: 1 }),
        ('\u{2f92c}', Slice { offset: 2768, length: 1 }),
        ('\u{2f92d}', Slice { offset: 2768, length: 1 }),
        ('\u{2f92e}', Slice { offset: 2769, length: 1 }),
        ('\u{2f92f}', Slice { offset: 2770, length: 1 }),
        ('\u{2f930}', Slice { offset: 2348, length: 1 }),
        ('\u{2f931}', Slice { offset: 2771, length: 1 }),
        ('\u{2f932}', Slice { offset: 2772, length: 1 }),
        ('\u{2f933}', Slice { offset: 2773, length: 1 }),
        ('\u{2f934}', Slice { offset: 2774, length: 1 }),
        ('\u{2f935}', Slice { offset: 2775, length: 1 }),
        ('\u{2f936}', Slice { offset: 2776, length: 1 }),
        ('\u{2f937}', Slice { offset: 2777, length: 1 }),
        ('\u{2f938}', Slice { offset: 2061, length: 1 }),
        ('\u{2f939}', Slice { offset: 2778, length: 1 }),
        ('\u{2f93a}', Slice { offset: 2779, length: 1 }),
        ('\u{2f93b}', Slice { offset: 2780, length: 1 }),
        ('\u{2f93c}', Slice { offset: 2781, length: 1 }),
        ('\u{2f93d}', Slice { offset: 2782, length: 1 }),
        ('\u{2f93e}', Slice { offset: 2783, length: 1 }),
        ('\u{2f93f}', Slice { offset: 2784, length: 1 }),
        ('\u{2f940}', Slice { offset: 2354, length: 1 }),
        ('\u{2f941}', Slice { offset: 2785, length: 1 }),
        ('\u{2f942}', Slice { offset: 2786, length: 1 }),
        ('\u{2f943}', Slice { offset: 2787, length: 1 }),
        ('\u{2f944}', Slice { offset: 2788, length: 1 }),
        ('\u{2f945}', Slice { offset: 2789, length: 1 }),
        ('\u{2f946}', Slice { offset: 2790, length: 1 }),
        ('\u{2f947}', Slice { offset: 2790, length: 1 }),
        ('\u{2f948}', Slice { offset: 2355, length: 1 }),
        ('\u{2f949}', Slice { offset: 2384, length: 1 }),
        ('\u{2f94a}', Slice { offset: 2791, length: 1 }),
        ('\u{2f94b}', Slice { offset: 2792, length: 1 }),
        ('\u{2f94c}', Slice { offset: 2793, length: 1 }),
        ('\u{2f94d}', Slice { offset: 2794, length: 1 }),
        ('\u{2f94e}', Slice { offset: 2795, length: 1 }),
        ('\u{2f94f}', Slice { offset: 2023, length: 1 }),
        ('\u{2f950}', Slice { offset: 2357, length: 1 }),
        ('\u{2f951}', Slice { offset: 2796, length: 1 }),
        ('\u{2f952}', Slice { offset: 2797, length: 1 }),
        ('\u{2f953}', Slice { offset: 2283, length: 1 }),
        ('\u{2f954}', Slice { offset: 2798, length: 1 }),
        ('\u{2f955}', Slice { offset: 2799, length: 1 }),
        ('\u{2f956}', Slice { offset: 2237, length: 1 }),
        ('\u{2f957}', Slice { offset: 2800, length: 1 }),
        ('\u{2f958}', Slice { offset: 2801, length: 1 }),
        ('\u{2f959}', Slice { offset: 2287, length: 1 }),
        ('\u{2f95a}', Slice { offset: 2802, length: 1 }),
        ('\u{2f95b}', Slice { offset: 2803, length: 1 }),
        ('\u{2f95c}', Slice { offset: 2804, length: 1 }),
        ('\u{2f95d}', Slice { offset: 2805, length: 1 }),
        ('\u{2f95e}', Slice { offset: 2805, length: 1 }),
        ('\u{2f95f}', Slice { offset: 2806, length: 1 }),
        ('\u{2f960}', Slice { offset: 2807, length: 1 }),
        ('\u{2f961}', Slice { offset: 2808, length: 1 }),
        ('\u{2f962}', Slice { offset: 2809, length: 1 }),
        ('\u{2f963}', Slice { offset: 2810, length: 1 }),
        ('\u{2f964}', Slice { offset: 2811, length: 1 }),
        ('\u{2f965}', Slice { offset: 2812, length: 1 }),
        ('\u{2f966}', Slice { offset: 2813, length: 1 }),
        ('\u{2f967}', Slice { offset: 2814, length: 1 }),
        ('\u{2f968}', Slice { offset: 2815, length: 1 }),
        ('\u{2f969}', Slice { offset: 2816, length: 1 }),
        ('\u{2f96a}', Slice { offset: 2817, length: 1 }),
        ('\u{2f96b}', Slice { offset: 2818, length: 1 }),
        ('\u{2f96c}', Slice { offset: 2819, length: 1 }),
        ('\u{2f96d}', Slice { offset: 2820, length: 1 }),
        ('\u{2f96e}', Slice { offset: 2821, length: 1 }),
        ('\u{2f96f}', Slice { offset: 2822, length: 1 }),
        ('\u{2f970}', Slice { offset: 2823, length: 1 }),
        ('\u{2f971}', Slice { offset: 2824, length: 1 }),
        ('\u{2f972}', Slice { offset: 2825, length: 1 }),
        ('\u{2f973}', Slice { offset: 2826, length: 1 }),
        ('\u{2f974}', Slice { offset: 2827, length: 1 }),
        ('\u{2f975}', Slice { offset: 2828, length: 1 }),
        ('\u{2f976}', Slice { offset: 2829, length: 1 }),
        ('\u{2f977}', Slice { offset: 2830, length: 1 }),
        ('\u{2f978}', Slice { offset: 2831, length: 1 }),
        ('\u{2f979}', Slice { offset: 2832, length: 1 }),
        ('\u{2f97a}', Slice { offset: 2293, length: 1 }),
        ('\u{2f97b}', Slice { offset: 2833, length: 1 }),
        ('\u{2f97c}', Slice { offset: 2834, length: 1 }),
        ('\u{2f97d}', Slice { offset: 2835, length: 1 }),
        ('\u{2f97e}', Slice { offset: 2836, length: 1 }),
        ('\u{2f97f}', Slice { offset: 2837, length: 1 }),
        ('\u{2f980}', Slice { offset: 2838, length: 1 }),
        ('\u{2f981}', Slice { offset: 2839, length: 1 }),
        ('\u{2f982}', Slice { offset: 2840, length: 1 }),
        ('\u{2f983}', Slice { offset: 2841, length: 1 }),
        ('\u{2f984}', Slice { offset: 2842, length: 1 }),
        ('\u{2f985}', Slice { offset: 2843, length: 1 }),
        ('\u{2f986}', Slice { offset: 2844, length: 1 }),
        ('\u{2f987}', Slice { offset: 2845, length: 1 }),
        ('\u{2f988}', Slice { offset: 2846, length: 1 }),
        ('\u{2f989}', Slice { offset: 2847, length: 1 }),
        ('\u{2f98a}', Slice { offset: 2848, length: 1 }),
        ('\u{2f98b}', Slice { offset: 2634, length: 1 }),
        ('\u{2f98c}', Slice { offset: 2849, length: 1 }),
        ('\u{2f98d}', Slice { offset: 2850, length: 1 }),
        ('\u{2f98e}', Slice { offset: 2851, length: 1 }),
        ('\u{2f98f}', Slice { offset: 2852, length: 1 }),
        ('\u{2f990}', Slice { offset: 2853, length: 1 }),
        ('\u{2f991}', Slice { offset: 2854, length: 1 }),
        ('\u{2f992}', Slice { offset: 2855, length: 1 }),
        ('\u{2f993}', Slice { offset: 2856, length: 1 }),
        ('\u{2f994}', Slice { offset: 2857, length: 1 }),
        ('\u{2f995}', Slice { offset: 2858, length: 1 }),
        ('\u{2f996}', Slice { offset: 2859, length: 1 }),
        ('\u{2f997}', Slice { offset: 2860, length: 1 }),
        ('\u{2f998}', Slice { offset: 2079, length: 1 }),
        ('\u{2f999}', Slice { offset: 2861, length: 1 }),
        ('\u{2f99a}', Slice { offset: 2862, length: 1 }),
        ('\u{2f99b}', Slice { offset: 2863, length: 1 }),
        ('\u{2f99c}', Slice { offset: 2864, length: 1 }),
        ('\u{2f99d}', Slice { offset: 2865, length: 1 }),
        ('\u{2f99e}', Slice { offset: 2866, length: 1 }),
        ('\u{2f99f}', Slice { offset: 2296, length: 1 }),
        ('\u{2f9a0}', Slice { offset: 2867, length: 1 }),
        ('\u{2f9a1}', Slice { offset: 2868, length: 1 }),
        ('\u{2f9a2}', Slice { offset: 2869, length: 1 }),
        ('\u{2f9a3}', Slice { offset: 2870, length: 1 }),
        ('\u{2f9a4}', Slice { offset: 2871, length: 1 }),
        ('\u{2f9a5}', Slice { offset: 2872, length: 1 }),
        ('\u{2f9a6}', Slice { offset: 2873, length: 1 }),
        ('\u{2f9a7}', Slice { offset: 2874, length: 1 }),
        ('\u{2f9a8}', Slice { offset: 2875, length: 1 }),
        ('\u{2f9a9}', Slice { offset: 2876, length: 1 }),
        ('\u{2f9aa}', Slice { offset: 2877, length: 1 }),
        ('\u{2f9ab}', Slice { offset: 2878, length: 1 }),
        ('\u{2f9ac}', Slice { offset: 2879, length: 1 }),
        ('\u{2f9ad}', Slice { offset: 2880, length: 1 }),
        ('\u{2f9ae}', Slice { offset: 2881, length: 1 }),
        ('\u{2f9af}', Slice { offset: 2882, length: 1 }),
        ('\u{2f9b0}', Slice { offset: 2883, length: 1 }),
        ('\u{2f9b1}', Slice { offset: 2884, length: 1 }),
        ('\u{2f9b2}', Slice { offset: 2885, length: 1 }),
        ('\u{2f9b3}', Slice { offset: 2886, length: 1 }),
        ('\u{2f9b4}', Slice { offset: 2018, length: 1 }),
        ('\u{2f9b5}', Slice { offset: 2887, length: 1 }),
        ('\u{2f9b6}', Slice { offset: 2888, length: 1 }),
        ('\u{2f9b7}', Slice { offset: 2889, length: 1 }),
        ('\u{2f9b8}', Slice { offset: 2890, length: 1 }),
        ('\u{2f9b9}', Slice { offset: 2891, length: 1 }),
        ('\u{2f9ba}', Slice { offset: 2892, length: 1 }),
        ('\u{2f9bb}', Slice { offset: 2364, length: 1 }),
        ('\u{2f9bc}', Slice { offset: 2893, length: 1 }),
        ('\u{2f9bd}', Slice { offset: 2894, length: 1 }),
        ('\u{2f9be}', Slice { offset: 2895, length: 1 }),
        ('\u{2f9bf}', Slice { offset: 2896, length: 1 }),
        ('\u{2f9c0}', Slice { offset: 2897, length: 1 }),
        ('\u{2f9c1}', Slice { offset: 2898, length: 1 }),
        ('\u{2f9c2}', Slice { offset: 2899, length: 1 }),
        ('\u{2f9c3}', Slice { offset: 2900, length: 1 }),
        ('\u{2f9c4}', Slice { offset: 2901, length: 1 }),
        ('\u{2f9c5}', Slice { offset: 2902, length: 1 }),
        ('\u{2f9c6}', Slice { offset: 2903, length: 1 }),
        ('\u{2f9c7}', Slice { offset: 2904, length: 1 }),
        ('\u{2f9c8}', Slice { offset: 2905, length: 1 }),
        ('\u{2f9c9}', Slice { offset: 2906, length: 1 }),
        ('\u{2f9ca}', Slice { offset: 2907, length: 1 }),
        ('\u{2f9cb}', Slice { offset: 2908, length: 1 }),
        ('\u{2f9cc}', Slice { offset: 2909, length: 1 }),
        ('\u{2f9cd}', Slice { offset: 2910, length: 1 }),
        ('\u{2f9ce}', Slice { offset: 2911, length: 1 }),
        ('\u{2f9cf}', Slice { offset: 2912, length: 1 }),
        ('\u{2f9d0}', Slice { offset: 2369, length: 1 }),
        ('\u{2f9d1}', Slice { offset: 2370, length: 1 }),
        ('\u{2f9d2}', Slice { offset: 2913, length: 1 }),
        ('\u{2f9d3}', Slice { offset: 2914, length: 1 }),
        ('\u{2f9d4}', Slice { offset: 2915, length: 1 }),
        ('\u{2f9d5}', Slice { offset: 2916, length: 1 }),
        ('\u{2f9d6}', Slice { offset: 2917, length: 1 }),
        ('\u{2f9d7}', Slice { offset: 2918, length: 1 }),
        ('\u{2f9d8}', Slice { offset: 2919, length: 1 }),
        ('\u{2f9d9}', Slice { offset: 2920, length: 1 }),
        ('\u{2f9da}', Slice { offset: 2921, length: 1 }),
        ('\u{2f9db}', Slice { offset: 2922, length: 1 }),
        ('\u{2f9dc}', Slice { offset: 2923, length: 1 }),
        ('\u{2f9dd}', Slice { offset: 2924, length: 1 }),
        ('\u{2f9de}', Slice { offset: 2925, length: 1 }),
        ('\u{2f9df}', Slice { offset: 2371, length: 1 }),
        ('\u{2f9e0}', Slice { offset: 2926, length: 1 }),
        ('\u{2f9e1}', Slice { offset: 2927, length: 1 }),
        ('\u{2f9e2}', Slice { offset: 2928, length: 1 }),
        ('\u{2f9e3}', Slice { offset: 2929, length: 1 }),
        ('\u{2f9e4}', Slice { offset: 2930, length: 1 }),
        ('\u{2f9e5}', Slice { offset: 2931, length: 1 }),
        ('\u{2f9e6}', Slice { offset: 2932, length: 1 }),
        ('\u{2f9e7}', Slice { offset: 2933, length: 1 }),
        ('\u{2f9e8}', Slice { offset: 2934, length: 1 }),
        ('\u{2f9e9}', Slice { offset: 2935, length: 1 }),
        ('\u{2f9ea}', Slice { offset: 2936, length: 1 }),
        ('\u{2f9eb}', Slice { offset: 2937, length: 1 }),
        ('\u{2f9ec}', Slice { offset: 2938, length: 1 }),
        ('\u{2f9ed}', Slice { offset: 2939, length: 1 }),
        ('\u{2f9ee}', Slice { offset: 2940, length: 1 }),
        ('\u{2f9ef}', Slice { offset: 2941, length: 1 }),
        ('\u{2f9f0}', Slice { offset: 2942, length: 1 }),
        ('\u{2f9f1}', Slice { offset: 2943, length: 1 }),
        ('\u{2f9f2}', Slice { offset: 2944, length: 1 }),
        ('\u{2f9f3}', Slice { offset: 2945, length: 1 }),
        ('\u{2f9f4}', Slice { offset: 2946, length: 1 }),
        ('\u{2f9f5}', Slice { offset: 2947, length: 1 }),
        ('\u{2f9f6}', Slice { offset: 2948, length: 1 }),
        ('\u{2f9f7}', Slice { offset: 2949, length: 1 }),
        ('\u{2f9f8}', Slice { offset: 2950, length: 1 }),
        ('\u{2f9f9}', Slice { offset: 2951, length: 1 }),
        ('\u{2f9fa}', Slice { offset: 2952, length: 1 }),
        ('\u{2f9fb}', Slice { offset: 2953, length: 1 }),
        ('\u{2f9fc}', Slice { offset: 2954, length: 1 }),
        ('\u{2f9fd}', Slice { offset: 2955, length: 1 }),
        ('\u{2f9fe}', Slice { offset: 2377, length: 1 }),
        ('\u{2f9ff}', Slice { offset: 2377, length: 1 }),
        ('\u{2fa00}', Slice { offset: 2956, length: 1 }),
        ('\u{2fa01}', Slice { offset: 2957, length: 1 }),
        ('\u{2fa02}', Slice { offset: 2958, length: 1 }),
        ('\u{2fa03}', Slice { offset: 2959, length: 1 }),
        ('\u{2fa04}', Slice { offset: 2960, length: 1 }),
        ('\u{2fa05}', Slice { offset: 2961, length: 1 }),
        ('\u{2fa06}', Slice { offset: 2962, length: 1 }),
        ('\u{2fa07}', Slice { offset: 2963, length: 1 }),
        ('\u{2fa08}', Slice { offset: 2964, length: 1 }),
        ('\u{2fa09}', Slice { offset: 2965, length: 1 }),
        ('\u{2fa0a}', Slice { offset: 2378, length: 1 }),
        ('\u{2fa0b}', Slice { offset: 2966, length: 1 }),
        ('\u{2fa0c}', Slice { offset: 2967, length: 1 }),
        ('\u{2fa0d}', Slice { offset: 2968, length: 1 }),
        ('\u{2fa0e}', Slice { offset: 2969, length: 1 }),
        ('\u{2fa0f}', Slice { offset: 2970, length: 1 }),
        ('\u{2fa10}', Slice { offset: 2971, length: 1 }),
        ('\u{2fa11}', Slice { offset: 2972, length: 1 }),
        ('\u{2fa12}', Slice { offset: 2973, length: 1 }),
        ('\u{2fa13}', Slice { offset: 2974, length: 1 }),
        ('\u{2fa14}', Slice { offset: 2975, length: 1 }),
        ('\u{2fa15}', Slice { offset: 2976, length: 1 }),
        ('\u{2fa16}', Slice { offset: 2977, length: 1 }),
        ('\u{2fa17}', Slice { offset: 2978, length: 1 }),
        ('\u{2fa18}', Slice { offset: 2979, length: 1 }),
        ('\u{2fa19}', Slice { offset: 2980, length: 1 }),
        ('\u{2fa1a}', Slice { offset: 2981, length: 1 }),
        ('\u{2fa1b}', Slice { offset: 2982, length: 1 }),
        ('\u{2fa1c}', Slice { offset: 2983, length: 1 }),
        ('\u{2fa1d}', Slice { offset: 2984, length: 1 }),

    ];

    pub  const canonical_table_STRTAB: &'static [char] = &[
        '\u{41}', '\u{300}',
        '\u{41}', '\u{301}',
        '\u{41}', '\u{302}',
        '\u{41}', '\u{303}',
        '\u{41}', '\u{308}',
        '\u{41}', '\u{30a}',
        '\u{43}', '\u{327}',
        '\u{45}', '\u{300}',
        '\u{45}', '\u{301}',
        '\u{45}', '\u{302}',
        '\u{45}', '\u{308}',
        '\u{49}', '\u{300}',
        '\u{49}', '\u{301}',
        '\u{49}', '\u{302}',
        '\u{49}', '\u{308}',
        '\u{4e}', '\u{303}',
        '\u{4f}', '\u{300}',
        '\u{4f}', '\u{301}',
        '\u{4f}', '\u{302}',
        '\u{4f}', '\u{303}',
        '\u{4f}', '\u{308}',
        '\u{55}', '\u{300}',
        '\u{55}', '\u{301}',
        '\u{55}', '\u{302}',
        '\u{55}', '\u{308}',
        '\u{59}', '\u{301}',
        '\u{61}', '\u{300}',
        '\u{61}', '\u{301}',
        '\u{61}', '\u{302}',
        '\u{61}', '\u{303}',
        '\u{61}', '\u{308}',
        '\u{61}', '\u{30a}',
        '\u{63}', '\u{327}',
        '\u{65}', '\u{300}',
        '\u{65}', '\u{301}',
        '\u{65}', '\u{302}',
        '\u{65}', '\u{308}',
        '\u{69}', '\u{300}',
        '\u{69}', '\u{301}',
        '\u{69}', '\u{302}',
        '\u{69}', '\u{308}',
        '\u{6e}', '\u{303}',
        '\u{6f}', '\u{300}',
        '\u{6f}', '\u{301}',
        '\u{6f}', '\u{302}',
        '\u{6f}', '\u{303}',
        '\u{6f}', '\u{308}',
        '\u{75}', '\u{300}',
        '\u{75}', '\u{301}',
        '\u{75}', '\u{302}',
        '\u{75}', '\u{308}',
        '\u{79}', '\u{301}',
        '\u{79}', '\u{308}',
        '\u{41}', '\u{304}',
        '\u{61}', '\u{304}',
        '\u{41}', '\u{306}',
        '\u{61}', '\u{306}',
        '\u{41}', '\u{328}',
        '\u{61}', '\u{328}',
        '\u{43}', '\u{301}',
        '\u{63}', '\u{301}',
        '\u{43}', '\u{302}',
        '\u{63}', '\u{302}',
        '\u{43}', '\u{307}',
        '\u{63}', '\u{307}',
        '\u{43}', '\u{30c}',
        '\u{63}', '\u{30c}',
        '\u{44}', '\u{30c}',
        '\u{64}', '\u{30c}',
        '\u{45}', '\u{304}',
        '\u{65}', '\u{304}',
        '\u{45}', '\u{306}',
        '\u{65}', '\u{306}',
        '\u{45}', '\u{307}',
        '\u{65}', '\u{307}',
        '\u{45}', '\u{328}',
        '\u{65}', '\u{328}',
        '\u{45}', '\u{30c}',
        '\u{65}', '\u{30c}',
        '\u{47}', '\u{302}',
        '\u{67}', '\u{302}',
        '\u{47}', '\u{306}',
        '\u{67}', '\u{306}',
        '\u{47}', '\u{307}',
        '\u{67}', '\u{307}',
        '\u{47}', '\u{327}',
        '\u{67}', '\u{327}',
        '\u{48}', '\u{302}',
        '\u{68}', '\u{302}',
        '\u{49}', '\u{303}',
        '\u{69}', '\u{303}',
        '\u{49}', '\u{304}',
        '\u{69}', '\u{304}',
        '\u{49}', '\u{306}',
        '\u{69}', '\u{306}',
        '\u{49}', '\u{328}',
        '\u{69}', '\u{328}',
        '\u{49}', '\u{307}',
        '\u{4a}', '\u{302}',
        '\u{6a}', '\u{302}',
        '\u{4b}', '\u{327}',
        '\u{6b}', '\u{327}',
        '\u{4c}', '\u{301}',
        '\u{6c}', '\u{301}',
        '\u{4c}', '\u{327}',
        '\u{6c}', '\u{327}',
        '\u{4c}', '\u{30c}',
        '\u{6c}', '\u{30c}',
        '\u{4e}', '\u{301}',
        '\u{6e}', '\u{301}',
        '\u{4e}', '\u{327}',
        '\u{6e}', '\u{327}',
        '\u{4e}', '\u{30c}',
        '\u{6e}', '\u{30c}',
        '\u{4f}', '\u{304}',
        '\u{6f}', '\u{304}',
        '\u{4f}', '\u{306}',
        '\u{6f}', '\u{306}',
        '\u{4f}', '\u{30b}',
        '\u{6f}', '\u{30b}',
        '\u{52}', '\u{301}',
        '\u{72}', '\u{301}',
        '\u{52}', '\u{327}',
        '\u{72}', '\u{327}',
        '\u{52}', '\u{30c}',
        '\u{72}', '\u{30c}',
        '\u{53}', '\u{301}',
        '\u{73}', '\u{301}',
        '\u{53}', '\u{302}',
        '\u{73}', '\u{302}',
        '\u{53}', '\u{327}',
        '\u{73}', '\u{327}',
        '\u{53}', '\u{30c}',
        '\u{73}', '\u{30c}',
        '\u{54}', '\u{327}',
        '\u{74}', '\u{327}',
        '\u{54}', '\u{30c}',
        '\u{74}', '\u{30c}',
        '\u{55}', '\u{303}',
        '\u{75}', '\u{303}',
        '\u{55}', '\u{304}',
        '\u{75}', '\u{304}',
        '\u{55}', '\u{306}',
        '\u{75}', '\u{306}',
        '\u{55}', '\u{30a}',
        '\u{75}', '\u{30a}',
        '\u{55}', '\u{30b}',
        '\u{75}', '\u{30b}',
        '\u{55}', '\u{328}',
        '\u{75}', '\u{328}',
        '\u{57}', '\u{302}',
        '\u{77}', '\u{302}',
        '\u{59}', '\u{302}',
        '\u{79}', '\u{302}',
        '\u{59}', '\u{308}',
        '\u{5a}', '\u{301}',
        '\u{7a}', '\u{301}',
        '\u{5a}', '\u{307}',
        '\u{7a}', '\u{307}',
        '\u{5a}', '\u{30c}',
        '\u{7a}', '\u{30c}',
        '\u{4f}', '\u{31b}',
        '\u{6f}', '\u{31b}',
        '\u{55}', '\u{31b}',
        '\u{75}', '\u{31b}',
        '\u{41}', '\u{30c}',
        '\u{61}', '\u{30c}',
        '\u{49}', '\u{30c}',
        '\u{69}', '\u{30c}',
        '\u{4f}', '\u{30c}',
        '\u{6f}', '\u{30c}',
        '\u{55}', '\u{30c}',
        '\u{75}', '\u{30c}',
        '\u{dc}', '\u{304}',
        '\u{fc}', '\u{304}',
        '\u{dc}', '\u{301}',
        '\u{fc}', '\u{301}',
        '\u{dc}', '\u{30c}',
        '\u{fc}', '\u{30c}',
        '\u{dc}', '\u{300}',
        '\u{fc}', '\u{300}',
        '\u{c4}', '\u{304}',
        '\u{e4}', '\u{304}',
        '\u{226}', '\u{304}',
        '\u{227}', '\u{304}',
        '\u{c6}', '\u{304}',
        '\u{e6}', '\u{304}',
        '\u{47}', '\u{30c}',
        '\u{67}', '\u{30c}',
        '\u{4b}', '\u{30c}',
        '\u{6b}', '\u{30c}',
        '\u{4f}', '\u{328}',
        '\u{6f}', '\u{328}',
        '\u{1ea}', '\u{304}',
        '\u{1eb}', '\u{304}',
        '\u{1b7}', '\u{30c}',
        '\u{292}', '\u{30c}',
        '\u{6a}', '\u{30c}',
        '\u{47}', '\u{301}',
        '\u{67}', '\u{301}',
        '\u{4e}', '\u{300}',
        '\u{6e}', '\u{300}',
        '\u{c5}', '\u{301}',
        '\u{e5}', '\u{301}',
        '\u{c6}', '\u{301}',
        '\u{e6}', '\u{301}',
        '\u{d8}', '\u{301}',
        '\u{f8}', '\u{301}',
        '\u{41}', '\u{30f}',
        '\u{61}', '\u{30f}',
        '\u{41}', '\u{311}',
        '\u{61}', '\u{311}',
        '\u{45}', '\u{30f}',
        '\u{65}', '\u{30f}',
        '\u{45}', '\u{311}',
        '\u{65}', '\u{311}',
        '\u{49}', '\u{30f}',
        '\u{69}', '\u{30f}',
        '\u{49}', '\u{311}',
        '\u{69}', '\u{311}',
        '\u{4f}', '\u{30f}',
        '\u{6f}', '\u{30f}',
        '\u{4f}', '\u{311}',
        '\u{6f}', '\u{311}',
        '\u{52}', '\u{30f}',
        '\u{72}', '\u{30f}',
        '\u{52}', '\u{311}',
        '\u{72}', '\u{311}',
        '\u{55}', '\u{30f}',
        '\u{75}', '\u{30f}',
        '\u{55}', '\u{311}',
        '\u{75}', '\u{311}',
        '\u{53}', '\u{326}',
        '\u{73}', '\u{326}',
        '\u{54}', '\u{326}',
        '\u{74}', '\u{326}',
        '\u{48}', '\u{30c}',
        '\u{68}', '\u{30c}',
        '\u{41}', '\u{307}',
        '\u{61}', '\u{307}',
        '\u{45}', '\u{327}',
        '\u{65}', '\u{327}',
        '\u{d6}', '\u{304}',
        '\u{f6}', '\u{304}',
        '\u{d5}', '\u{304}',
        '\u{f5}', '\u{304}',
        '\u{4f}', '\u{307}',
        '\u{6f}', '\u{307}',
        '\u{22e}', '\u{304}',
        '\u{22f}', '\u{304}',
        '\u{59}', '\u{304}',
        '\u{79}', '\u{304}',
        '\u{300}',
        '\u{301}',
        '\u{313}',
        '\u{308}', '\u{301}',
        '\u{2b9}',
        '\u{3b}',
        '\u{a8}', '\u{301}',
        '\u{391}', '\u{301}',
        '\u{b7}',
        '\u{395}', '\u{301}',
        '\u{397}', '\u{301}',
        '\u{399}', '\u{301}',
        '\u{39f}', '\u{301}',
        '\u{3a5}', '\u{301}',
        '\u{3a9}', '\u{301}',
        '\u{3ca}', '\u{301}',
        '\u{399}', '\u{308}',
        '\u{3a5}', '\u{308}',
        '\u{3b1}', '\u{301}',
        '\u{3b5}', '\u{301}',
        '\u{3b7}', '\u{301}',
        '\u{3b9}', '\u{301}',
        '\u{3cb}', '\u{301}',
        '\u{3b9}', '\u{308}',
        '\u{3c5}', '\u{308}',
        '\u{3bf}', '\u{301}',
        '\u{3c5}', '\u{301}',
        '\u{3c9}', '\u{301}',
        '\u{3d2}', '\u{301}',
        '\u{3d2}', '\u{308}',
        '\u{415}', '\u{300}',
        '\u{415}', '\u{308}',
        '\u{413}', '\u{301}',
        '\u{406}', '\u{308}',
        '\u{41a}', '\u{301}',
        '\u{418}', '\u{300}',
        '\u{423}', '\u{306}',
        '\u{418}', '\u{306}',
        '\u{438}', '\u{306}',
        '\u{435}', '\u{300}',
        '\u{435}', '\u{308}',
        '\u{433}', '\u{301}',
        '\u{456}', '\u{308}',
        '\u{43a}', '\u{301}',
        '\u{438}', '\u{300}',
        '\u{443}', '\u{306}',
        '\u{474}', '\u{30f}',
        '\u{475}', '\u{30f}',
        '\u{416}', '\u{306}',
        '\u{436}', '\u{306}',
        '\u{410}', '\u{306}',
        '\u{430}', '\u{306}',
        '\u{410}', '\u{308}',
        '\u{430}', '\u{308}',
        '\u{415}', '\u{306}',
        '\u{435}', '\u{306}',
        '\u{4d8}', '\u{308}',
        '\u{4d9}', '\u{308}',
        '\u{416}', '\u{308}',
        '\u{436}', '\u{308}',
        '\u{417}', '\u{308}',
        '\u{437}', '\u{308}',
        '\u{418}', '\u{304}',
        '\u{438}', '\u{304}',
        '\u{418}', '\u{308}',
        '\u{438}', '\u{308}',
        '\u{41e}', '\u{308}',
        '\u{43e}', '\u{308}',
        '\u{4e8}', '\u{308}',
        '\u{4e9}', '\u{308}',
        '\u{42d}', '\u{308}',
        '\u{44d}', '\u{308}',
        '\u{423}', '\u{304}',
        '\u{443}', '\u{304}',
        '\u{423}', '\u{308}',
        '\u{443}', '\u{308}',
        '\u{423}', '\u{30b}',
        '\u{443}', '\u{30b}',
        '\u{427}', '\u{308}',
        '\u{447}', '\u{308}',
        '\u{42b}', '\u{308}',
        '\u{44b}', '\u{308}',
        '\u{627}', '\u{653}',
        '\u{627}', '\u{654}',
        '\u{648}', '\u{654}',
        '\u{627}', '\u{655}',
        '\u{64a}', '\u{654}',
        '\u{6d5}', '\u{654}',
        '\u{6c1}', '\u{654}',
        '\u{6d2}', '\u{654}',
        '\u{928}', '\u{93c}',
        '\u{930}', '\u{93c}',
        '\u{933}', '\u{93c}',
        '\u{915}', '\u{93c}',
        '\u{916}', '\u{93c}',
        '\u{917}', '\u{93c}',
        '\u{91c}', '\u{93c}',
        '\u{921}', '\u{93c}',
        '\u{922}', '\u{93c}',
        '\u{92b}', '\u{93c}',
        '\u{92f}', '\u{93c}',
        '\u{9c7}', '\u{9be}',
        '\u{9c7}', '\u{9d7}',
        '\u{9a1}', '\u{9bc}',
        '\u{9a2}', '\u{9bc}',
        '\u{9af}', '\u{9bc}',
        '\u{a32}', '\u{a3c}',
        '\u{a38}', '\u{a3c}',
        '\u{a16}', '\u{a3c}',
        '\u{a17}', '\u{a3c}',
        '\u{a1c}', '\u{a3c}',
        '\u{a2b}', '\u{a3c}',
        '\u{b47}', '\u{b56}',
        '\u{b47}', '\u{b3e}',
        '\u{b47}', '\u{b57}',
        '\u{b21}', '\u{b3c}',
        '\u{b22}', '\u{b3c}',
        '\u{b92}', '\u{bd7}',
        '\u{bc6}', '\u{bbe}',
        '\u{bc7}', '\u{bbe}',
        '\u{bc6}', '\u{bd7}',
        '\u{c46}', '\u{c56}',
        '\u{cbf}', '\u{cd5}',
        '\u{cc6}', '\u{cd5}',
        '\u{cc6}', '\u{cd6}',
        '\u{cc6}', '\u{cc2}',
        '\u{cca}', '\u{cd5}',
        '\u{d46}', '\u{d3e}',
        '\u{d47}', '\u{d3e}',
        '\u{d46}', '\u{d57}',
        '\u{dd9}', '\u{dca}',
        '\u{dd9}', '\u{dcf}',
        '\u{ddc}', '\u{dca}',
        '\u{dd9}', '\u{ddf}',
        '\u{f42}', '\u{fb7}',
        '\u{f4c}', '\u{fb7}',
        '\u{f51}', '\u{fb7}',
        '\u{f56}', '\u{fb7}',
        '\u{f5b}', '\u{fb7}',
        '\u{f40}', '\u{fb5}',
        '\u{f71}', '\u{f72}',
        '\u{f71}', '\u{f74}',
        '\u{fb2}', '\u{f80}',
        '\u{fb3}', '\u{f80}',
        '\u{f71}', '\u{f80}',
        '\u{f92}', '\u{fb7}',
        '\u{f9c}', '\u{fb7}',
        '\u{fa1}', '\u{fb7}',
        '\u{fa6}', '\u{fb7}',
        '\u{fab}', '\u{fb7}',
        '\u{f90}', '\u{fb5}',
        '\u{1025}', '\u{102e}',
        '\u{1b05}', '\u{1b35}',
        '\u{1b07}', '\u{1b35}',
        '\u{1b09}', '\u{1b35}',
        '\u{1b0b}', '\u{1b35}',
        '\u{1b0d}', '\u{1b35}',
        '\u{1b11}', '\u{1b35}',
        '\u{1b3a}', '\u{1b35}',
        '\u{1b3c}', '\u{1b35}',
        '\u{1b3e}', '\u{1b35}',
        '\u{1b3f}', '\u{1b35}',
        '\u{1b42}', '\u{1b35}',
        '\u{41}', '\u{325}',
        '\u{61}', '\u{325}',
        '\u{42}', '\u{307}',
        '\u{62}', '\u{307}',
        '\u{42}', '\u{323}',
        '\u{62}', '\u{323}',
        '\u{42}', '\u{331}',
        '\u{62}', '\u{331}',
        '\u{c7}', '\u{301}',
        '\u{e7}', '\u{301}',
        '\u{44}', '\u{307}',
        '\u{64}', '\u{307}',
        '\u{44}', '\u{323}',
        '\u{64}', '\u{323}',
        '\u{44}', '\u{331}',
        '\u{64}', '\u{331}',
        '\u{44}', '\u{327}',
        '\u{64}', '\u{327}',
        '\u{44}', '\u{32d}',
        '\u{64}', '\u{32d}',
        '\u{112}', '\u{300}',
        '\u{113}', '\u{300}',
        '\u{112}', '\u{301}',
        '\u{113}', '\u{301}',
        '\u{45}', '\u{32d}',
        '\u{65}', '\u{32d}',
        '\u{45}', '\u{330}',
        '\u{65}', '\u{330}',
        '\u{228}', '\u{306}',
        '\u{229}', '\u{306}',
        '\u{46}', '\u{307}',
        '\u{66}', '\u{307}',
        '\u{47}', '\u{304}',
        '\u{67}', '\u{304}',
        '\u{48}', '\u{307}',
        '\u{68}', '\u{307}',
        '\u{48}', '\u{323}',
        '\u{68}', '\u{323}',
        '\u{48}', '\u{308}',
        '\u{68}', '\u{308}',
        '\u{48}', '\u{327}',
        '\u{68}', '\u{327}',
        '\u{48}', '\u{32e}',
        '\u{68}', '\u{32e}',
        '\u{49}', '\u{330}',
        '\u{69}', '\u{330}',
        '\u{cf}', '\u{301}',
        '\u{ef}', '\u{301}',
        '\u{4b}', '\u{301}',
        '\u{6b}', '\u{301}',
        '\u{4b}', '\u{323}',
        '\u{6b}', '\u{323}',
        '\u{4b}', '\u{331}',
        '\u{6b}', '\u{331}',
        '\u{4c}', '\u{323}',
        '\u{6c}', '\u{323}',
        '\u{1e36}', '\u{304}',
        '\u{1e37}', '\u{304}',
        '\u{4c}', '\u{331}',
        '\u{6c}', '\u{331}',
        '\u{4c}', '\u{32d}',
        '\u{6c}', '\u{32d}',
        '\u{4d}', '\u{301}',
        '\u{6d}', '\u{301}',
        '\u{4d}', '\u{307}',
        '\u{6d}', '\u{307}',
        '\u{4d}', '\u{323}',
        '\u{6d}', '\u{323}',
        '\u{4e}', '\u{307}',
        '\u{6e}', '\u{307}',
        '\u{4e}', '\u{323}',
        '\u{6e}', '\u{323}',
        '\u{4e}', '\u{331}',
        '\u{6e}', '\u{331}',
        '\u{4e}', '\u{32d}',
        '\u{6e}', '\u{32d}',
        '\u{d5}', '\u{301}',
        '\u{f5}', '\u{301}',
        '\u{d5}', '\u{308}',
        '\u{f5}', '\u{308}',
        '\u{14c}', '\u{300}',
        '\u{14d}', '\u{300}',
        '\u{14c}', '\u{301}',
        '\u{14d}', '\u{301}',
        '\u{50}', '\u{301}',
        '\u{70}', '\u{301}',
        '\u{50}', '\u{307}',
        '\u{70}', '\u{307}',
        '\u{52}', '\u{307}',
        '\u{72}', '\u{307}',
        '\u{52}', '\u{323}',
        '\u{72}', '\u{323}',
        '\u{1e5a}', '\u{304}',
        '\u{1e5b}', '\u{304}',
        '\u{52}', '\u{331}',
        '\u{72}', '\u{331}',
        '\u{53}', '\u{307}',
        '\u{73}', '\u{307}',
        '\u{53}', '\u{323}',
        '\u{73}', '\u{323}',
        '\u{15a}', '\u{307}',
        '\u{15b}', '\u{307}',
        '\u{160}', '\u{307}',
        '\u{161}', '\u{307}',
        '\u{1e62}', '\u{307}',
        '\u{1e63}', '\u{307}',
        '\u{54}', '\u{307}',
        '\u{74}', '\u{307}',
        '\u{54}', '\u{323}',
        '\u{74}', '\u{323}',
        '\u{54}', '\u{331}',
        '\u{74}', '\u{331}',
        '\u{54}', '\u{32d}',
        '\u{74}', '\u{32d}',
        '\u{55}', '\u{324}',
        '\u{75}', '\u{324}',
        '\u{55}', '\u{330}',
        '\u{75}', '\u{330}',
        '\u{55}', '\u{32d}',
        '\u{75}', '\u{32d}',
        '\u{168}', '\u{301}',
        '\u{169}', '\u{301}',
        '\u{16a}', '\u{308}',
        '\u{16b}', '\u{308}',
        '\u{56}', '\u{303}',
        '\u{76}', '\u{303}',
        '\u{56}', '\u{323}',
        '\u{76}', '\u{323}',
        '\u{57}', '\u{300}',
        '\u{77}', '\u{300}',
        '\u{57}', '\u{301}',
        '\u{77}', '\u{301}',
        '\u{57}', '\u{308}',
        '\u{77}', '\u{308}',
        '\u{57}', '\u{307}',
        '\u{77}', '\u{307}',
        '\u{57}', '\u{323}',
        '\u{77}', '\u{323}',
        '\u{58}', '\u{307}',
        '\u{78}', '\u{307}',
        '\u{58}', '\u{308}',
        '\u{78}', '\u{308}',
        '\u{59}', '\u{307}',
        '\u{79}', '\u{307}',
        '\u{5a}', '\u{302}',
        '\u{7a}', '\u{302}',
        '\u{5a}', '\u{323}',
        '\u{7a}', '\u{323}',
        '\u{5a}', '\u{331}',
        '\u{7a}', '\u{331}',
        '\u{68}', '\u{331}',
        '\u{74}', '\u{308}',
        '\u{77}', '\u{30a}',
        '\u{79}', '\u{30a}',
        '\u{17f}', '\u{307}',
        '\u{41}', '\u{323}',
        '\u{61}', '\u{323}',
        '\u{41}', '\u{309}',
        '\u{61}', '\u{309}',
        '\u{c2}', '\u{301}',
        '\u{e2}', '\u{301}',
        '\u{c2}', '\u{300}',
        '\u{e2}', '\u{300}',
        '\u{c2}', '\u{309}',
        '\u{e2}', '\u{309}',
        '\u{c2}', '\u{303}',
        '\u{e2}', '\u{303}',
        '\u{1ea0}', '\u{302}',
        '\u{1ea1}', '\u{302}',
        '\u{102}', '\u{301}',
        '\u{103}', '\u{301}',
        '\u{102}', '\u{300}',
        '\u{103}', '\u{300}',
        '\u{102}', '\u{309}',
        '\u{103}', '\u{309}',
        '\u{102}', '\u{303}',
        '\u{103}', '\u{303}',
        '\u{1ea0}', '\u{306}',
        '\u{1ea1}', '\u{306}',
        '\u{45}', '\u{323}',
        '\u{65}', '\u{323}',
        '\u{45}', '\u{309}',
        '\u{65}', '\u{309}',
        '\u{45}', '\u{303}',
        '\u{65}', '\u{303}',
        '\u{ca}', '\u{301}',
        '\u{ea}', '\u{301}',
        '\u{ca}', '\u{300}',
        '\u{ea}', '\u{300}',
        '\u{ca}', '\u{309}',
        '\u{ea}', '\u{309}',
        '\u{ca}', '\u{303}',
        '\u{ea}', '\u{303}',
        '\u{1eb8}', '\u{302}',
        '\u{1eb9}', '\u{302}',
        '\u{49}', '\u{309}',
        '\u{69}', '\u{309}',
        '\u{49}', '\u{323}',
        '\u{69}', '\u{323}',
        '\u{4f}', '\u{323}',
        '\u{6f}', '\u{323}',
        '\u{4f}', '\u{309}',
        '\u{6f}', '\u{309}',
        '\u{d4}', '\u{301}',
        '\u{f4}', '\u{301}',
        '\u{d4}', '\u{300}',
        '\u{f4}', '\u{300}',
        '\u{d4}', '\u{309}',
        '\u{f4}', '\u{309}',
        '\u{d4}', '\u{303}',
        '\u{f4}', '\u{303}',
        '\u{1ecc}', '\u{302}',
        '\u{1ecd}', '\u{302}',
        '\u{1a0}', '\u{301}',
        '\u{1a1}', '\u{301}',
        '\u{1a0}', '\u{300}',
        '\u{1a1}', '\u{300}',
        '\u{1a0}', '\u{309}',
        '\u{1a1}', '\u{309}',
        '\u{1a0}', '\u{303}',
        '\u{1a1}', '\u{303}',
        '\u{1a0}', '\u{323}',
        '\u{1a1}', '\u{323}',
        '\u{55}', '\u{323}',
        '\u{75}', '\u{323}',
        '\u{55}', '\u{309}',
        '\u{75}', '\u{309}',
        '\u{1af}', '\u{301}',
        '\u{1b0}', '\u{301}',
        '\u{1af}', '\u{300}',
        '\u{1b0}', '\u{300}',
        '\u{1af}', '\u{309}',
        '\u{1b0}', '\u{309}',
        '\u{1af}', '\u{303}',
        '\u{1b0}', '\u{303}',
        '\u{1af}', '\u{323}',
        '\u{1b0}', '\u{323}',
        '\u{59}', '\u{300}',
        '\u{79}', '\u{300}',
        '\u{59}', '\u{323}',
        '\u{79}', '\u{323}',
        '\u{59}', '\u{309}',
        '\u{79}', '\u{309}',
        '\u{59}', '\u{303}',
        '\u{79}', '\u{303}',
        '\u{3b1}', '\u{313}',
        '\u{3b1}', '\u{314}',
        '\u{1f00}', '\u{300}',
        '\u{1f01}', '\u{300}',
        '\u{1f00}', '\u{301}',
        '\u{1f01}', '\u{301}',
        '\u{1f00}', '\u{342}',
        '\u{1f01}', '\u{342}',
        '\u{391}', '\u{313}',
        '\u{391}', '\u{314}',
        '\u{1f08}', '\u{300}',
        '\u{1f09}', '\u{300}',
        '\u{1f08}', '\u{301}',
        '\u{1f09}', '\u{301}',
        '\u{1f08}', '\u{342}',
        '\u{1f09}', '\u{342}',
        '\u{3b5}', '\u{313}',
        '\u{3b5}', '\u{314}',
        '\u{1f10}', '\u{300}',
        '\u{1f11}', '\u{300}',
        '\u{1f10}', '\u{301}',
        '\u{1f11}', '\u{301}',
        '\u{395}', '\u{313}',
        '\u{395}', '\u{314}',
        '\u{1f18}', '\u{300}',
        '\u{1f19}', '\u{300}',
        '\u{1f18}', '\u{301}',
        '\u{1f19}', '\u{301}',
        '\u{3b7}', '\u{313}',
        '\u{3b7}', '\u{314}',
        '\u{1f20}', '\u{300}',
        '\u{1f21}', '\u{300}',
        '\u{1f20}', '\u{301}',
        '\u{1f21}', '\u{301}',
        '\u{1f20}', '\u{342}',
        '\u{1f21}', '\u{342}',
        '\u{397}', '\u{313}',
        '\u{397}', '\u{314}',
        '\u{1f28}', '\u{300}',
        '\u{1f29}', '\u{300}',
        '\u{1f28}', '\u{301}',
        '\u{1f29}', '\u{301}',
        '\u{1f28}', '\u{342}',
        '\u{1f29}', '\u{342}',
        '\u{3b9}', '\u{313}',
        '\u{3b9}', '\u{314}',
        '\u{1f30}', '\u{300}',
        '\u{1f31}', '\u{300}',
        '\u{1f30}', '\u{301}',
        '\u{1f31}', '\u{301}',
        '\u{1f30}', '\u{342}',
        '\u{1f31}', '\u{342}',
        '\u{399}', '\u{313}',
        '\u{399}', '\u{314}',
        '\u{1f38}', '\u{300}',
        '\u{1f39}', '\u{300}',
        '\u{1f38}', '\u{301}',
        '\u{1f39}', '\u{301}',
        '\u{1f38}', '\u{342}',
        '\u{1f39}', '\u{342}',
        '\u{3bf}', '\u{313}',
        '\u{3bf}', '\u{314}',
        '\u{1f40}', '\u{300}',
        '\u{1f41}', '\u{300}',
        '\u{1f40}', '\u{301}',
        '\u{1f41}', '\u{301}',
        '\u{39f}', '\u{313}',
        '\u{39f}', '\u{314}',
        '\u{1f48}', '\u{300}',
        '\u{1f49}', '\u{300}',
        '\u{1f48}', '\u{301}',
        '\u{1f49}', '\u{301}',
        '\u{3c5}', '\u{313}',
        '\u{3c5}', '\u{314}',
        '\u{1f50}', '\u{300}',
        '\u{1f51}', '\u{300}',
        '\u{1f50}', '\u{301}',
        '\u{1f51}', '\u{301}',
        '\u{1f50}', '\u{342}',
        '\u{1f51}', '\u{342}',
        '\u{3a5}', '\u{314}',
        '\u{1f59}', '\u{300}',
        '\u{1f59}', '\u{301}',
        '\u{1f59}', '\u{342}',
        '\u{3c9}', '\u{313}',
        '\u{3c9}', '\u{314}',
        '\u{1f60}', '\u{300}',
        '\u{1f61}', '\u{300}',
        '\u{1f60}', '\u{301}',
        '\u{1f61}', '\u{301}',
        '\u{1f60}', '\u{342}',
        '\u{1f61}', '\u{342}',
        '\u{3a9}', '\u{313}',
        '\u{3a9}', '\u{314}',
        '\u{1f68}', '\u{300}',
        '\u{1f69}', '\u{300}',
        '\u{1f68}', '\u{301}',
        '\u{1f69}', '\u{301}',
        '\u{1f68}', '\u{342}',
        '\u{1f69}', '\u{342}',
        '\u{3b1}', '\u{300}',
        '\u{3ac}',
        '\u{3b5}', '\u{300}',
        '\u{3ad}',
        '\u{3b7}', '\u{300}',
        '\u{3ae}',
        '\u{3b9}', '\u{300}',
        '\u{3af}',
        '\u{3bf}', '\u{300}',
        '\u{3cc}',
        '\u{3c5}', '\u{300}',
        '\u{3cd}',
        '\u{3c9}', '\u{300}',
        '\u{3ce}',
        '\u{1f00}', '\u{345}',
        '\u{1f01}', '\u{345}',
        '\u{1f02}', '\u{345}',
        '\u{1f03}', '\u{345}',
        '\u{1f04}', '\u{345}',
        '\u{1f05}', '\u{345}',
        '\u{1f06}', '\u{345}',
        '\u{1f07}', '\u{345}',
        '\u{1f08}', '\u{345}',
        '\u{1f09}', '\u{345}',
        '\u{1f0a}', '\u{345}',
        '\u{1f0b}', '\u{345}',
        '\u{1f0c}', '\u{345}',
        '\u{1f0d}', '\u{345}',
        '\u{1f0e}', '\u{345}',
        '\u{1f0f}', '\u{345}',
        '\u{1f20}', '\u{345}',
        '\u{1f21}', '\u{345}',
        '\u{1f22}', '\u{345}',
        '\u{1f23}', '\u{345}',
        '\u{1f24}', '\u{345}',
        '\u{1f25}', '\u{345}',
        '\u{1f26}', '\u{345}',
        '\u{1f27}', '\u{345}',
        '\u{1f28}', '\u{345}',
        '\u{1f29}', '\u{345}',
        '\u{1f2a}', '\u{345}',
        '\u{1f2b}', '\u{345}',
        '\u{1f2c}', '\u{345}',
        '\u{1f2d}', '\u{345}',
        '\u{1f2e}', '\u{345}',
        '\u{1f2f}', '\u{345}',
        '\u{1f60}', '\u{345}',
        '\u{1f61}', '\u{345}',
        '\u{1f62}', '\u{345}',
        '\u{1f63}', '\u{345}',
        '\u{1f64}', '\u{345}',
        '\u{1f65}', '\u{345}',
        '\u{1f66}', '\u{345}',
        '\u{1f67}', '\u{345}',
        '\u{1f68}', '\u{345}',
        '\u{1f69}', '\u{345}',
        '\u{1f6a}', '\u{345}',
        '\u{1f6b}', '\u{345}',
        '\u{1f6c}', '\u{345}',
        '\u{1f6d}', '\u{345}',
        '\u{1f6e}', '\u{345}',
        '\u{1f6f}', '\u{345}',
        '\u{3b1}', '\u{306}',
        '\u{3b1}', '\u{304}',
        '\u{1f70}', '\u{345}',
        '\u{3b1}', '\u{345}',
        '\u{3ac}', '\u{345}',
        '\u{3b1}', '\u{342}',
        '\u{1fb6}', '\u{345}',
        '\u{391}', '\u{306}',
        '\u{391}', '\u{304}',
        '\u{391}', '\u{300}',
        '\u{386}',
        '\u{391}', '\u{345}',
        '\u{3b9}',
        '\u{a8}', '\u{342}',
        '\u{1f74}', '\u{345}',
        '\u{3b7}', '\u{345}',
        '\u{3ae}', '\u{345}',
        '\u{3b7}', '\u{342}',
        '\u{1fc6}', '\u{345}',
        '\u{395}', '\u{300}',
        '\u{388}',
        '\u{397}', '\u{300}',
        '\u{389}',
        '\u{397}', '\u{345}',
        '\u{1fbf}', '\u{300}',
        '\u{1fbf}', '\u{301}',
        '\u{1fbf}', '\u{342}',
        '\u{3b9}', '\u{306}',
        '\u{3b9}', '\u{304}',
        '\u{3ca}', '\u{300}',
        '\u{390}',
        '\u{3b9}', '\u{342}',
        '\u{3ca}', '\u{342}',
        '\u{399}', '\u{306}',
        '\u{399}', '\u{304}',
        '\u{399}', '\u{300}',
        '\u{38a}',
        '\u{1ffe}', '\u{300}',
        '\u{1ffe}', '\u{301}',
        '\u{1ffe}', '\u{342}',
        '\u{3c5}', '\u{306}',
        '\u{3c5}', '\u{304}',
        '\u{3cb}', '\u{300}',
        '\u{3b0}',
        '\u{3c1}', '\u{313}',
        '\u{3c1}', '\u{314}',
        '\u{3c5}', '\u{342}',
        '\u{3cb}', '\u{342}',
        '\u{3a5}', '\u{306}',
        '\u{3a5}', '\u{304}',
        '\u{3a5}', '\u{300}',
        '\u{38e}',
        '\u{3a1}', '\u{314}',
        '\u{a8}', '\u{300}',
        '\u{385}',
        '\u{60}',
        '\u{1f7c}', '\u{345}',
        '\u{3c9}', '\u{345}',
        '\u{3ce}', '\u{345}',
        '\u{3c9}', '\u{342}',
        '\u{1ff6}', '\u{345}',
        '\u{39f}', '\u{300}',
        '\u{38c}',
        '\u{3a9}', '\u{300}',
        '\u{38f}',
        '\u{3a9}', '\u{345}',
        '\u{b4}',
        '\u{2002}',
        '\u{2003}',
        '\u{3a9}',
        '\u{4b}',
        '\u{c5}',
        '\u{2190}', '\u{338}',
        '\u{2192}', '\u{338}',
        '\u{2194}', '\u{338}',
        '\u{21d0}', '\u{338}',
        '\u{21d4}', '\u{338}',
        '\u{21d2}', '\u{338}',
        '\u{2203}', '\u{338}',
        '\u{2208}', '\u{338}',
        '\u{220b}', '\u{338}',
        '\u{2223}', '\u{338}',
        '\u{2225}', '\u{338}',
        '\u{223c}', '\u{338}',
        '\u{2243}', '\u{338}',
        '\u{2245}', '\u{338}',
        '\u{2248}', '\u{338}',
        '\u{3d}', '\u{338}',
        '\u{2261}', '\u{338}',
        '\u{224d}', '\u{338}',
        '\u{3c}', '\u{338}',
        '\u{3e}', '\u{338}',
        '\u{2264}', '\u{338}',
        '\u{2265}', '\u{338}',
        '\u{2272}', '\u{338}',
        '\u{2273}', '\u{338}',
        '\u{2276}', '\u{338}',
        '\u{2277}', '\u{338}',
        '\u{227a}', '\u{338}',
        '\u{227b}', '\u{338}',
        '\u{2282}', '\u{338}',
        '\u{2283}', '\u{338}',
        '\u{2286}', '\u{338}',
        '\u{2287}', '\u{338}',
        '\u{22a2}', '\u{338}',
        '\u{22a8}', '\u{338}',
        '\u{22a9}', '\u{338}',
        '\u{22ab}', '\u{338}',
        '\u{227c}', '\u{338}',
        '\u{227d}', '\u{338}',
        '\u{2291}', '\u{338}',
        '\u{2292}', '\u{338}',
        '\u{22b2}', '\u{338}',
        '\u{22b3}', '\u{338}',
        '\u{22b4}', '\u{338}',
        '\u{22b5}', '\u{338}',
        '\u{3008}',
        '\u{3009}',
        '\u{2add}', '\u{338}',
        '\u{304b}', '\u{3099}',
        '\u{304d}', '\u{3099}',
        '\u{304f}', '\u{3099}',
        '\u{3051}', '\u{3099}',
        '\u{3053}', '\u{3099}',
        '\u{3055}', '\u{3099}',
        '\u{3057}', '\u{3099}',
        '\u{3059}', '\u{3099}',
        '\u{305b}', '\u{3099}',
        '\u{305d}', '\u{3099}',
        '\u{305f}', '\u{3099}',
        '\u{3061}', '\u{3099}',
        '\u{3064}', '\u{3099}',
        '\u{3066}', '\u{3099}',
        '\u{3068}', '\u{3099}',
        '\u{306f}', '\u{3099}',
        '\u{306f}', '\u{309a}',
        '\u{3072}', '\u{3099}',
        '\u{3072}', '\u{309a}',
        '\u{3075}', '\u{3099}',
        '\u{3075}', '\u{309a}',
        '\u{3078}', '\u{3099}',
        '\u{3078}', '\u{309a}',
        '\u{307b}', '\u{3099}',
        '\u{307b}', '\u{309a}',
        '\u{3046}', '\u{3099}',
        '\u{309d}', '\u{3099}',
        '\u{30ab}', '\u{3099}',
        '\u{30ad}', '\u{3099}',
        '\u{30af}', '\u{3099}',
        '\u{30b1}', '\u{3099}',
        '\u{30b3}', '\u{3099}',
        '\u{30b5}', '\u{3099}',
        '\u{30b7}', '\u{3099}',
        '\u{30b9}', '\u{3099}',
        '\u{30bb}', '\u{3099}',
        '\u{30bd}', '\u{3099}',
        '\u{30bf}', '\u{3099}',
        '\u{30c1}', '\u{3099}',
        '\u{30c4}', '\u{3099}',
        '\u{30c6}', '\u{3099}',
        '\u{30c8}', '\u{3099}',
        '\u{30cf}', '\u{3099}',
        '\u{30cf}', '\u{309a}',
        '\u{30d2}', '\u{3099}',
        '\u{30d2}', '\u{309a}',
        '\u{30d5}', '\u{3099}',
        '\u{30d5}', '\u{309a}',
        '\u{30d8}', '\u{3099}',
        '\u{30d8}', '\u{309a}',
        '\u{30db}', '\u{3099}',
        '\u{30db}', '\u{309a}',
        '\u{30a6}', '\u{3099}',
        '\u{30ef}', '\u{3099}',
        '\u{30f0}', '\u{3099}',
        '\u{30f1}', '\u{3099}',
        '\u{30f2}', '\u{3099}',
        '\u{30fd}', '\u{3099}',
        '\u{8c48}',
        '\u{66f4}',
        '\u{8eca}',
        '\u{8cc8}',
        '\u{6ed1}',
        '\u{4e32}',
        '\u{53e5}',
        '\u{9f9c}',
        '\u{5951}',
        '\u{91d1}',
        '\u{5587}',
        '\u{5948}',
        '\u{61f6}',
        '\u{7669}',
        '\u{7f85}',
        '\u{863f}',
        '\u{87ba}',
        '\u{88f8}',
        '\u{908f}',
        '\u{6a02}',
        '\u{6d1b}',
        '\u{70d9}',
        '\u{73de}',
        '\u{843d}',
        '\u{916a}',
        '\u{99f1}',
        '\u{4e82}',
        '\u{5375}',
        '\u{6b04}',
        '\u{721b}',
        '\u{862d}',
        '\u{9e1e}',
        '\u{5d50}',
        '\u{6feb}',
        '\u{85cd}',
        '\u{8964}',
        '\u{62c9}',
        '\u{81d8}',
        '\u{881f}',
        '\u{5eca}',
        '\u{6717}',
        '\u{6d6a}',
        '\u{72fc}',
        '\u{90ce}',
        '\u{4f86}',
        '\u{51b7}',
        '\u{52de}',
        '\u{64c4}',
        '\u{6ad3}',
        '\u{7210}',
        '\u{76e7}',
        '\u{8001}',
        '\u{8606}',
        '\u{865c}',
        '\u{8def}',
        '\u{9732}',
        '\u{9b6f}',
        '\u{9dfa}',
        '\u{788c}',
        '\u{797f}',
        '\u{7da0}',
        '\u{83c9}',
        '\u{9304}',
        '\u{9e7f}',
        '\u{8ad6}',
        '\u{58df}',
        '\u{5f04}',
        '\u{7c60}',
        '\u{807e}',
        '\u{7262}',
        '\u{78ca}',
        '\u{8cc2}',
        '\u{96f7}',
        '\u{58d8}',
        '\u{5c62}',
        '\u{6a13}',
        '\u{6dda}',
        '\u{6f0f}',
        '\u{7d2f}',
        '\u{7e37}',
        '\u{964b}',
        '\u{52d2}',
        '\u{808b}',
        '\u{51dc}',
        '\u{51cc}',
        '\u{7a1c}',
        '\u{7dbe}',
        '\u{83f1}',
        '\u{9675}',
        '\u{8b80}',
        '\u{62cf}',
        '\u{8afe}',
        '\u{4e39}',
        '\u{5be7}',
        '\u{6012}',
        '\u{7387}',
        '\u{7570}',
        '\u{5317}',
        '\u{78fb}',
        '\u{4fbf}',
        '\u{5fa9}',
        '\u{4e0d}',
        '\u{6ccc}',
        '\u{6578}',
        '\u{7d22}',
        '\u{53c3}',
        '\u{585e}',
        '\u{7701}',
        '\u{8449}',
        '\u{8aaa}',
        '\u{6bba}',
        '\u{8fb0}',
        '\u{6c88}',
        '\u{62fe}',
        '\u{82e5}',
        '\u{63a0}',
        '\u{7565}',
        '\u{4eae}',
        '\u{5169}',
        '\u{51c9}',
        '\u{6881}',
        '\u{7ce7}',
        '\u{826f}',
        '\u{8ad2}',
        '\u{91cf}',
        '\u{52f5}',
        '\u{5442}',
        '\u{5973}',
        '\u{5eec}',
        '\u{65c5}',
        '\u{6ffe}',
        '\u{792a}',
        '\u{95ad}',
        '\u{9a6a}',
        '\u{9e97}',
        '\u{9ece}',
        '\u{529b}',
        '\u{66c6}',
        '\u{6b77}',
        '\u{8f62}',
        '\u{5e74}',
        '\u{6190}',
        '\u{6200}',
        '\u{649a}',
        '\u{6f23}',
        '\u{7149}',
        '\u{7489}',
        '\u{79ca}',
        '\u{7df4}',
        '\u{806f}',
        '\u{8f26}',
        '\u{84ee}',
        '\u{9023}',
        '\u{934a}',
        '\u{5217}',
        '\u{52a3}',
        '\u{54bd}',
        '\u{70c8}',
        '\u{88c2}',
        '\u{5ec9}',
        '\u{5ff5}',
        '\u{637b}',
        '\u{6bae}',
        '\u{7c3e}',
        '\u{7375}',
        '\u{4ee4}',
        '\u{56f9}',
        '\u{5dba}',
        '\u{601c}',
        '\u{73b2}',
        '\u{7469}',
        '\u{7f9a}',
        '\u{8046}',
        '\u{9234}',
        '\u{96f6}',
        '\u{9748}',
        '\u{9818}',
        '\u{4f8b}',
        '\u{79ae}',
        '\u{91b4}',
        '\u{96b8}',
        '\u{60e1}',
        '\u{4e86}',
        '\u{50da}',
        '\u{5bee}',
        '\u{5c3f}',
        '\u{6599}',
        '\u{71ce}',
        '\u{7642}',
        '\u{84fc}',
        '\u{907c}',
        '\u{9f8d}',
        '\u{6688}',
        '\u{962e}',
        '\u{5289}',
        '\u{677b}',
        '\u{67f3}',
        '\u{6d41}',
        '\u{6e9c}',
        '\u{7409}',
        '\u{7559}',
        '\u{786b}',
        '\u{7d10}',
        '\u{985e}',
        '\u{516d}',
        '\u{622e}',
        '\u{9678}',
        '\u{502b}',
        '\u{5d19}',
        '\u{6dea}',
        '\u{8f2a}',
        '\u{5f8b}',
        '\u{6144}',
        '\u{6817}',
        '\u{9686}',
        '\u{5229}',
        '\u{540f}',
        '\u{5c65}',
        '\u{6613}',
        '\u{674e}',
        '\u{68a8}',
        '\u{6ce5}',
        '\u{7406}',
        '\u{75e2}',
        '\u{7f79}',
        '\u{88cf}',
        '\u{88e1}',
        '\u{91cc}',
        '\u{96e2}',
        '\u{533f}',
        '\u{6eba}',
        '\u{541d}',
        '\u{71d0}',
        '\u{7498}',
        '\u{85fa}',
        '\u{96a3}',
        '\u{9c57}',
        '\u{9e9f}',
        '\u{6797}',
        '\u{6dcb}',
        '\u{81e8}',
        '\u{7acb}',
        '\u{7b20}',
        '\u{7c92}',
        '\u{72c0}',
        '\u{7099}',
        '\u{8b58}',
        '\u{4ec0}',
        '\u{8336}',
        '\u{523a}',
        '\u{5207}',
        '\u{5ea6}',
        '\u{62d3}',
        '\u{7cd6}',
        '\u{5b85}',
        '\u{6d1e}',
        '\u{66b4}',
        '\u{8f3b}',
        '\u{884c}',
        '\u{964d}',
        '\u{898b}',
        '\u{5ed3}',
        '\u{5140}',
        '\u{55c0}',
        '\u{585a}',
        '\u{6674}',
        '\u{51de}',
        '\u{732a}',
        '\u{76ca}',
        '\u{793c}',
        '\u{795e}',
        '\u{7965}',
        '\u{798f}',
        '\u{9756}',
        '\u{7cbe}',
        '\u{7fbd}',
        '\u{8612}',
        '\u{8af8}',
        '\u{9038}',
        '\u{90fd}',
        '\u{98ef}',
        '\u{98fc}',
        '\u{9928}',
        '\u{9db4}',
        '\u{90de}',
        '\u{96b7}',
        '\u{4fae}',
        '\u{50e7}',
        '\u{514d}',
        '\u{52c9}',
        '\u{52e4}',
        '\u{5351}',
        '\u{559d}',
        '\u{5606}',
        '\u{5668}',
        '\u{5840}',
        '\u{58a8}',
        '\u{5c64}',
        '\u{5c6e}',
        '\u{6094}',
        '\u{6168}',
        '\u{618e}',
        '\u{61f2}',
        '\u{654f}',
        '\u{65e2}',
        '\u{6691}',
        '\u{6885}',
        '\u{6d77}',
        '\u{6e1a}',
        '\u{6f22}',
        '\u{716e}',
        '\u{722b}',
        '\u{7422}',
        '\u{7891}',
        '\u{793e}',
        '\u{7949}',
        '\u{7948}',
        '\u{7950}',
        '\u{7956}',
        '\u{795d}',
        '\u{798d}',
        '\u{798e}',
        '\u{7a40}',
        '\u{7a81}',
        '\u{7bc0}',
        '\u{7e09}',
        '\u{7e41}',
        '\u{7f72}',
        '\u{8005}',
        '\u{81ed}',
        '\u{8279}',
        '\u{8457}',
        '\u{8910}',
        '\u{8996}',
        '\u{8b01}',
        '\u{8b39}',
        '\u{8cd3}',
        '\u{8d08}',
        '\u{8fb6}',
        '\u{96e3}',
        '\u{97ff}',
        '\u{983b}',
        '\u{6075}',
        '\u{242ee}',
        '\u{8218}',
        '\u{4e26}',
        '\u{51b5}',
        '\u{5168}',
        '\u{4f80}',
        '\u{5145}',
        '\u{5180}',
        '\u{52c7}',
        '\u{52fa}',
        '\u{5555}',
        '\u{5599}',
        '\u{55e2}',
        '\u{58b3}',
        '\u{5944}',
        '\u{5954}',
        '\u{5a62}',
        '\u{5b28}',
        '\u{5ed2}',
        '\u{5ed9}',
        '\u{5f69}',
        '\u{5fad}',
        '\u{60d8}',
        '\u{614e}',
        '\u{6108}',
        '\u{6160}',
        '\u{6234}',
        '\u{63c4}',
        '\u{641c}',
        '\u{6452}',
        '\u{6556}',
        '\u{671b}',
        '\u{6756}',
        '\u{6b79}',
        '\u{6edb}',
        '\u{6ecb}',
        '\u{701e}',
        '\u{77a7}',
        '\u{7235}',
        '\u{72af}',
        '\u{7471}',
        '\u{7506}',
        '\u{753b}',
        '\u{761d}',
        '\u{761f}',
        '\u{76db}',
        '\u{76f4}',
        '\u{774a}',
        '\u{7740}',
        '\u{78cc}',
        '\u{7ab1}',
        '\u{7c7b}',
        '\u{7d5b}',
        '\u{7f3e}',
        '\u{8352}',
        '\u{83ef}',
        '\u{8779}',
        '\u{8941}',
        '\u{8986}',
        '\u{8abf}',
        '\u{8acb}',
        '\u{8aed}',
        '\u{8b8a}',
        '\u{8f38}',
        '\u{9072}',
        '\u{9199}',
        '\u{9276}',
        '\u{967c}',
        '\u{97db}',
        '\u{980b}',
        '\u{9b12}',
        '\u{2284a}',
        '\u{22844}',
        '\u{233d5}',
        '\u{3b9d}',
        '\u{4018}',
        '\u{4039}',
        '\u{25249}',
        '\u{25cd0}',
        '\u{27ed3}',
        '\u{9f43}',
        '\u{9f8e}',
        '\u{5d9}', '\u{5b4}',
        '\u{5f2}', '\u{5b7}',
        '\u{5e9}', '\u{5c1}',
        '\u{5e9}', '\u{5c2}',
        '\u{fb49}', '\u{5c1}',
        '\u{fb49}', '\u{5c2}',
        '\u{5d0}', '\u{5b7}',
        '\u{5d0}', '\u{5b8}',
        '\u{5d0}', '\u{5bc}',
        '\u{5d1}', '\u{5bc}',
        '\u{5d2}', '\u{5bc}',
        '\u{5d3}', '\u{5bc}',
        '\u{5d4}', '\u{5bc}',
        '\u{5d5}', '\u{5bc}',
        '\u{5d6}', '\u{5bc}',
        '\u{5d8}', '\u{5bc}',
        '\u{5d9}', '\u{5bc}',
        '\u{5da}', '\u{5bc}',
        '\u{5db}', '\u{5bc}',
        '\u{5dc}', '\u{5bc}',
        '\u{5de}', '\u{5bc}',
        '\u{5e0}', '\u{5bc}',
        '\u{5e1}', '\u{5bc}',
        '\u{5e3}', '\u{5bc}',
        '\u{5e4}', '\u{5bc}',
        '\u{5e6}', '\u{5bc}',
        '\u{5e7}', '\u{5bc}',
        '\u{5e8}', '\u{5bc}',
        '\u{5e9}', '\u{5bc}',
        '\u{5ea}', '\u{5bc}',
        '\u{5d5}', '\u{5b9}',
        '\u{5d1}', '\u{5bf}',
        '\u{5db}', '\u{5bf}',
        '\u{5e4}', '\u{5bf}',
        '\u{11099}', '\u{110ba}',
        '\u{1109b}', '\u{110ba}',
        '\u{110a5}', '\u{110ba}',
        '\u{11131}', '\u{11127}',
        '\u{11132}', '\u{11127}',
        '\u{11347}', '\u{1133e}',
        '\u{11347}', '\u{11357}',
        '\u{114b9}', '\u{114ba}',
        '\u{114b9}', '\u{114b0}',
        '\u{114b9}', '\u{114bd}',
        '\u{115b8}', '\u{115af}',
        '\u{115b9}', '\u{115af}',
        '\u{1d157}', '\u{1d165}',
        '\u{1d158}', '\u{1d165}',
        '\u{1d15f}', '\u{1d16e}',
        '\u{1d15f}', '\u{1d16f}',
        '\u{1d15f}', '\u{1d170}',
        '\u{1d15f}', '\u{1d171}',
        '\u{1d15f}', '\u{1d172}',
        '\u{1d1b9}', '\u{1d165}',
        '\u{1d1ba}', '\u{1d165}',
        '\u{1d1bb}', '\u{1d16e}',
        '\u{1d1bc}', '\u{1d16e}',
        '\u{1d1bb}', '\u{1d16f}',
        '\u{1d1bc}', '\u{1d16f}',
        '\u{4e3d}',
        '\u{4e38}',
        '\u{4e41}',
        '\u{20122}',
        '\u{4f60}',
        '\u{4fbb}',
        '\u{5002}',
        '\u{507a}',
        '\u{5099}',
        '\u{50cf}',
        '\u{349e}',
        '\u{2063a}',
        '\u{5154}',
        '\u{5164}',
        '\u{5177}',
        '\u{2051c}',
        '\u{34b9}',
        '\u{5167}',
        '\u{518d}',
        '\u{2054b}',
        '\u{5197}',
        '\u{51a4}',
        '\u{4ecc}',
        '\u{51ac}',
        '\u{291df}',
        '\u{51f5}',
        '\u{5203}',
        '\u{34df}',
        '\u{523b}',
        '\u{5246}',
        '\u{5272}',
        '\u{5277}',
        '\u{3515}',
        '\u{5305}',
        '\u{5306}',
        '\u{5349}',
        '\u{535a}',
        '\u{5373}',
        '\u{537d}',
        '\u{537f}',
        '\u{20a2c}',
        '\u{7070}',
        '\u{53ca}',
        '\u{53df}',
        '\u{20b63}',
        '\u{53eb}',
        '\u{53f1}',
        '\u{5406}',
        '\u{549e}',
        '\u{5438}',
        '\u{5448}',
        '\u{5468}',
        '\u{54a2}',
        '\u{54f6}',
        '\u{5510}',
        '\u{5553}',
        '\u{5563}',
        '\u{5584}',
        '\u{55ab}',
        '\u{55b3}',
        '\u{55c2}',
        '\u{5716}',
        '\u{5717}',
        '\u{5651}',
        '\u{5674}',
        '\u{58ee}',
        '\u{57ce}',
        '\u{57f4}',
        '\u{580d}',
        '\u{578b}',
        '\u{5832}',
        '\u{5831}',
        '\u{58ac}',
        '\u{214e4}',
        '\u{58f2}',
        '\u{58f7}',
        '\u{5906}',
        '\u{591a}',
        '\u{5922}',
        '\u{5962}',
        '\u{216a8}',
        '\u{216ea}',
        '\u{59ec}',
        '\u{5a1b}',
        '\u{5a27}',
        '\u{59d8}',
        '\u{5a66}',
        '\u{36ee}',
        '\u{36fc}',
        '\u{5b08}',
        '\u{5b3e}',
        '\u{219c8}',
        '\u{5bc3}',
        '\u{5bd8}',
        '\u{5bf3}',
        '\u{21b18}',
        '\u{5bff}',
        '\u{5c06}',
        '\u{5f53}',
        '\u{5c22}',
        '\u{3781}',
        '\u{5c60}',
        '\u{5cc0}',
        '\u{5c8d}',
        '\u{21de4}',
        '\u{5d43}',
        '\u{21de6}',
        '\u{5d6e}',
        '\u{5d6b}',
        '\u{5d7c}',
        '\u{5de1}',
        '\u{5de2}',
        '\u{382f}',
        '\u{5dfd}',
        '\u{5e28}',
        '\u{5e3d}',
        '\u{5e69}',
        '\u{3862}',
        '\u{22183}',
        '\u{387c}',
        '\u{5eb0}',
        '\u{5eb3}',
        '\u{5eb6}',
        '\u{2a392}',
        '\u{5efe}',
        '\u{22331}',
        '\u{8201}',
        '\u{5f22}',
        '\u{38c7}',
        '\u{232b8}',
        '\u{261da}',
        '\u{5f62}',
        '\u{5f6b}',
        '\u{38e3}',
        '\u{5f9a}',
        '\u{5fcd}',
        '\u{5fd7}',
        '\u{5ff9}',
        '\u{6081}',
        '\u{393a}',
        '\u{391c}',
        '\u{226d4}',
        '\u{60c7}',
        '\u{6148}',
        '\u{614c}',
        '\u{617a}',
        '\u{61b2}',
        '\u{61a4}',
        '\u{61af}',
        '\u{61de}',
        '\u{6210}',
        '\u{621b}',
        '\u{625d}',
        '\u{62b1}',
        '\u{62d4}',
        '\u{6350}',
        '\u{22b0c}',
        '\u{633d}',
        '\u{62fc}',
        '\u{6368}',
        '\u{6383}',
        '\u{63e4}',
        '\u{22bf1}',
        '\u{6422}',
        '\u{63c5}',
        '\u{63a9}',
        '\u{3a2e}',
        '\u{6469}',
        '\u{647e}',
        '\u{649d}',
        '\u{6477}',
        '\u{3a6c}',
        '\u{656c}',
        '\u{2300a}',
        '\u{65e3}',
        '\u{66f8}',
        '\u{6649}',
        '\u{3b19}',
        '\u{3b08}',
        '\u{3ae4}',
        '\u{5192}',
        '\u{5195}',
        '\u{6700}',
        '\u{669c}',
        '\u{80ad}',
        '\u{43d9}',
        '\u{6721}',
        '\u{675e}',
        '\u{6753}',
        '\u{233c3}',
        '\u{3b49}',
        '\u{67fa}',
        '\u{6785}',
        '\u{6852}',
        '\u{2346d}',
        '\u{688e}',
        '\u{681f}',
        '\u{6914}',
        '\u{6942}',
        '\u{69a3}',
        '\u{69ea}',
        '\u{6aa8}',
        '\u{236a3}',
        '\u{6adb}',
        '\u{3c18}',
        '\u{6b21}',
        '\u{238a7}',
        '\u{6b54}',
        '\u{3c4e}',
        '\u{6b72}',
        '\u{6b9f}',
        '\u{6bbb}',
        '\u{23a8d}',
        '\u{21d0b}',
        '\u{23afa}',
        '\u{6c4e}',
        '\u{23cbc}',
        '\u{6cbf}',
        '\u{6ccd}',
        '\u{6c67}',
        '\u{6d16}',
        '\u{6d3e}',
        '\u{6d69}',
        '\u{6d78}',
        '\u{6d85}',
        '\u{23d1e}',
        '\u{6d34}',
        '\u{6e2f}',
        '\u{6e6e}',
        '\u{3d33}',
        '\u{6ec7}',
        '\u{23ed1}',
        '\u{6df9}',
        '\u{6f6e}',
        '\u{23f5e}',
        '\u{23f8e}',
        '\u{6fc6}',
        '\u{7039}',
        '\u{701b}',
        '\u{3d96}',
        '\u{704a}',
        '\u{707d}',
        '\u{7077}',
        '\u{70ad}',
        '\u{20525}',
        '\u{7145}',
        '\u{24263}',
        '\u{719c}',
        '\u{243ab}',
        '\u{7228}',
        '\u{7250}',
        '\u{24608}',
        '\u{7280}',
        '\u{7295}',
        '\u{24735}',
        '\u{24814}',
        '\u{737a}',
        '\u{738b}',
        '\u{3eac}',
        '\u{73a5}',
        '\u{3eb8}',
        '\u{7447}',
        '\u{745c}',
        '\u{7485}',
        '\u{74ca}',
        '\u{3f1b}',
        '\u{7524}',
        '\u{24c36}',
        '\u{753e}',
        '\u{24c92}',
        '\u{2219f}',
        '\u{7610}',
        '\u{24fa1}',
        '\u{24fb8}',
        '\u{25044}',
        '\u{3ffc}',
        '\u{4008}',
        '\u{250f3}',
        '\u{250f2}',
        '\u{25119}',
        '\u{25133}',
        '\u{771e}',
        '\u{771f}',
        '\u{778b}',
        '\u{4046}',
        '\u{4096}',
        '\u{2541d}',
        '\u{784e}',
        '\u{40e3}',
        '\u{25626}',
        '\u{2569a}',
        '\u{256c5}',
        '\u{79eb}',
        '\u{412f}',
        '\u{7a4a}',
        '\u{7a4f}',
        '\u{2597c}',
        '\u{25aa7}',
        '\u{7aee}',
        '\u{4202}',
        '\u{25bab}',
        '\u{7bc6}',
        '\u{7bc9}',
        '\u{4227}',
        '\u{25c80}',
        '\u{7cd2}',
        '\u{42a0}',
        '\u{7ce8}',
        '\u{7ce3}',
        '\u{7d00}',
        '\u{25f86}',
        '\u{7d63}',
        '\u{4301}',
        '\u{7dc7}',
        '\u{7e02}',
        '\u{7e45}',
        '\u{4334}',
        '\u{26228}',
        '\u{26247}',
        '\u{4359}',
        '\u{262d9}',
        '\u{7f7a}',
        '\u{2633e}',
        '\u{7f95}',
        '\u{7ffa}',
        '\u{264da}',
        '\u{26523}',
        '\u{8060}',
        '\u{265a8}',
        '\u{8070}',
        '\u{2335f}',
        '\u{43d5}',
        '\u{80b2}',
        '\u{8103}',
        '\u{440b}',
        '\u{813e}',
        '\u{5ab5}',
        '\u{267a7}',
        '\u{267b5}',
        '\u{23393}',
        '\u{2339c}',
        '\u{8204}',
        '\u{8f9e}',
        '\u{446b}',
        '\u{8291}',
        '\u{828b}',
        '\u{829d}',
        '\u{52b3}',
        '\u{82b1}',
        '\u{82b3}',
        '\u{82bd}',
        '\u{82e6}',
        '\u{26b3c}',
        '\u{831d}',
        '\u{8363}',
        '\u{83ad}',
        '\u{8323}',
        '\u{83bd}',
        '\u{83e7}',
        '\u{8353}',
        '\u{83ca}',
        '\u{83cc}',
        '\u{83dc}',
        '\u{26c36}',
        '\u{26d6b}',
        '\u{26cd5}',
        '\u{452b}',
        '\u{84f1}',
        '\u{84f3}',
        '\u{8516}',
        '\u{273ca}',
        '\u{8564}',
        '\u{26f2c}',
        '\u{455d}',
        '\u{4561}',
        '\u{26fb1}',
        '\u{270d2}',
        '\u{456b}',
        '\u{8650}',
        '\u{8667}',
        '\u{8669}',
        '\u{86a9}',
        '\u{8688}',
        '\u{870e}',
        '\u{86e2}',
        '\u{8728}',
        '\u{876b}',
        '\u{8786}',
        '\u{45d7}',
        '\u{87e1}',
        '\u{8801}',
        '\u{45f9}',
        '\u{8860}',
        '\u{8863}',
        '\u{27667}',
        '\u{88d7}',
        '\u{88de}',
        '\u{4635}',
        '\u{88fa}',
        '\u{34bb}',
        '\u{278ae}',
        '\u{27966}',
        '\u{46be}',
        '\u{46c7}',
        '\u{8aa0}',
        '\u{8c55}',
        '\u{27ca8}',
        '\u{8cab}',
        '\u{8cc1}',
        '\u{8d1b}',
        '\u{8d77}',
        '\u{27f2f}',
        '\u{20804}',
        '\u{8dcb}',
        '\u{8dbc}',
        '\u{8df0}',
        '\u{208de}',
        '\u{8ed4}',
        '\u{285d2}',
        '\u{285ed}',
        '\u{9094}',
        '\u{90f1}',
        '\u{9111}',
        '\u{2872e}',
        '\u{911b}',
        '\u{9238}',
        '\u{92d7}',
        '\u{92d8}',
        '\u{927c}',
        '\u{93f9}',
        '\u{9415}',
        '\u{28bfa}',
        '\u{958b}',
        '\u{4995}',
        '\u{95b7}',
        '\u{28d77}',
        '\u{49e6}',
        '\u{96c3}',
        '\u{5db2}',
        '\u{9723}',
        '\u{29145}',
        '\u{2921a}',
        '\u{4a6e}',
        '\u{4a76}',
        '\u{97e0}',
        '\u{2940a}',
        '\u{4ab2}',
        '\u{29496}',
        '\u{9829}',
        '\u{295b6}',
        '\u{98e2}',
        '\u{4b33}',
        '\u{9929}',
        '\u{99a7}',
        '\u{99c2}',
        '\u{99fe}',
        '\u{4bce}',
        '\u{29b30}',
        '\u{9c40}',
        '\u{9cfd}',
        '\u{4cce}',
        '\u{4ced}',
        '\u{9d67}',
        '\u{2a0ce}',
        '\u{4cf8}',
        '\u{2a105}',
        '\u{2a20e}',
        '\u{2a291}',
        '\u{9ebb}',
        '\u{4d56}',
        '\u{9ef9}',
        '\u{9efe}',
        '\u{9f05}',
        '\u{9f0f}',
        '\u{9f16}',
        '\u{9f3b}',
        '\u{2a600}',

    ];

    // Compatibility decompositions
    pub  const compatibility_table: &'static [(char, Slice)] = &[
        ('\u{a0}', Slice { offset: 0, length: 1 }),
        ('\u{a8}', Slice { offset: 1, length: 2 }),
        ('\u{aa}', Slice { offset: 3, length: 1 }),
        ('\u{af}', Slice { offset: 4, length: 2 }),
        ('\u{b2}', Slice { offset: 6, length: 1 }),
        ('\u{b3}', Slice { offset: 7, length: 1 }),
        ('\u{b4}', Slice { offset: 8, length: 2 }),
        ('\u{b5}', Slice { offset: 10, length: 1 }),
        ('\u{b8}', Slice { offset: 11, length: 2 }),
        ('\u{b9}', Slice { offset: 13, length: 1 }),
        ('\u{ba}', Slice { offset: 14, length: 1 }),
        ('\u{bc}', Slice { offset: 15, length: 3 }),
        ('\u{bd}', Slice { offset: 18, length: 3 }),
        ('\u{be}', Slice { offset: 21, length: 3 }),
        ('\u{132}', Slice { offset: 24, length: 2 }),
        ('\u{133}', Slice { offset: 26, length: 2 }),
        ('\u{13f}', Slice { offset: 28, length: 2 }),
        ('\u{140}', Slice { offset: 30, length: 2 }),
        ('\u{149}', Slice { offset: 32, length: 2 }),
        ('\u{17f}', Slice { offset: 34, length: 1 }),
        ('\u{1c4}', Slice { offset: 35, length: 2 }),
        ('\u{1c5}', Slice { offset: 37, length: 2 }),
        ('\u{1c6}', Slice { offset: 39, length: 2 }),
        ('\u{1c7}', Slice { offset: 41, length: 2 }),
        ('\u{1c8}', Slice { offset: 43, length: 2 }),
        ('\u{1c9}', Slice { offset: 45, length: 2 }),
        ('\u{1ca}', Slice { offset: 47, length: 2 }),
        ('\u{1cb}', Slice { offset: 49, length: 2 }),
        ('\u{1cc}', Slice { offset: 51, length: 2 }),
        ('\u{1f1}', Slice { offset: 53, length: 2 }),
        ('\u{1f2}', Slice { offset: 55, length: 2 }),
        ('\u{1f3}', Slice { offset: 57, length: 2 }),
        ('\u{2b0}', Slice { offset: 59, length: 1 }),
        ('\u{2b1}', Slice { offset: 60, length: 1 }),
        ('\u{2b2}', Slice { offset: 61, length: 1 }),
        ('\u{2b3}', Slice { offset: 62, length: 1 }),
        ('\u{2b4}', Slice { offset: 63, length: 1 }),
        ('\u{2b5}', Slice { offset: 64, length: 1 }),
        ('\u{2b6}', Slice { offset: 65, length: 1 }),
        ('\u{2b7}', Slice { offset: 66, length: 1 }),
        ('\u{2b8}', Slice { offset: 67, length: 1 }),
        ('\u{2d8}', Slice { offset: 68, length: 2 }),
        ('\u{2d9}', Slice { offset: 70, length: 2 }),
        ('\u{2da}', Slice { offset: 72, length: 2 }),
        ('\u{2db}', Slice { offset: 74, length: 2 }),
        ('\u{2dc}', Slice { offset: 76, length: 2 }),
        ('\u{2dd}', Slice { offset: 78, length: 2 }),
        ('\u{2e0}', Slice { offset: 80, length: 1 }),
        ('\u{2e1}', Slice { offset: 81, length: 1 }),
        ('\u{2e2}', Slice { offset: 34, length: 1 }),
        ('\u{2e3}', Slice { offset: 82, length: 1 }),
        ('\u{2e4}', Slice { offset: 83, length: 1 }),
        ('\u{37a}', Slice { offset: 84, length: 2 }),
        ('\u{384}', Slice { offset: 8, length: 2 }),
        ('\u{3d0}', Slice { offset: 86, length: 1 }),
        ('\u{3d1}', Slice { offset: 87, length: 1 }),
        ('\u{3d2}', Slice { offset: 88, length: 1 }),
        ('\u{3d5}', Slice { offset: 89, length: 1 }),
        ('\u{3d6}', Slice { offset: 90, length: 1 }),
        ('\u{3f0}', Slice { offset: 91, length: 1 }),
        ('\u{3f1}', Slice { offset: 92, length: 1 }),
        ('\u{3f2}', Slice { offset: 93, length: 1 }),
        ('\u{3f4}', Slice { offset: 94, length: 1 }),
        ('\u{3f5}', Slice { offset: 95, length: 1 }),
        ('\u{3f9}', Slice { offset: 96, length: 1 }),
        ('\u{587}', Slice { offset: 97, length: 2 }),
        ('\u{675}', Slice { offset: 99, length: 2 }),
        ('\u{676}', Slice { offset: 101, length: 2 }),
        ('\u{677}', Slice { offset: 103, length: 2 }),
        ('\u{678}', Slice { offset: 105, length: 2 }),
        ('\u{e33}', Slice { offset: 107, length: 2 }),
        ('\u{eb3}', Slice { offset: 109, length: 2 }),
        ('\u{edc}', Slice { offset: 111, length: 2 }),
        ('\u{edd}', Slice { offset: 113, length: 2 }),
        ('\u{f0c}', Slice { offset: 115, length: 1 }),
        ('\u{f77}', Slice { offset: 116, length: 2 }),
        ('\u{f79}', Slice { offset: 118, length: 2 }),
        ('\u{10fc}', Slice { offset: 120, length: 1 }),
        ('\u{1d2c}', Slice { offset: 121, length: 1 }),
        ('\u{1d2d}', Slice { offset: 122, length: 1 }),
        ('\u{1d2e}', Slice { offset: 123, length: 1 }),
        ('\u{1d30}', Slice { offset: 124, length: 1 }),
        ('\u{1d31}', Slice { offset: 125, length: 1 }),
        ('\u{1d32}', Slice { offset: 126, length: 1 }),
        ('\u{1d33}', Slice { offset: 127, length: 1 }),
        ('\u{1d34}', Slice { offset: 128, length: 1 }),
        ('\u{1d35}', Slice { offset: 129, length: 1 }),
        ('\u{1d36}', Slice { offset: 130, length: 1 }),
        ('\u{1d37}', Slice { offset: 131, length: 1 }),
        ('\u{1d38}', Slice { offset: 132, length: 1 }),
        ('\u{1d39}', Slice { offset: 133, length: 1 }),
        ('\u{1d3a}', Slice { offset: 134, length: 1 }),
        ('\u{1d3c}', Slice { offset: 135, length: 1 }),
        ('\u{1d3d}', Slice { offset: 136, length: 1 }),
        ('\u{1d3e}', Slice { offset: 137, length: 1 }),
        ('\u{1d3f}', Slice { offset: 138, length: 1 }),
        ('\u{1d40}', Slice { offset: 139, length: 1 }),
        ('\u{1d41}', Slice { offset: 140, length: 1 }),
        ('\u{1d42}', Slice { offset: 141, length: 1 }),
        ('\u{1d43}', Slice { offset: 3, length: 1 }),
        ('\u{1d44}', Slice { offset: 142, length: 1 }),
        ('\u{1d45}', Slice { offset: 143, length: 1 }),
        ('\u{1d46}', Slice { offset: 144, length: 1 }),
        ('\u{1d47}', Slice { offset: 145, length: 1 }),
        ('\u{1d48}', Slice { offset: 146, length: 1 }),
        ('\u{1d49}', Slice { offset: 147, length: 1 }),
        ('\u{1d4a}', Slice { offset: 148, length: 1 }),
        ('\u{1d4b}', Slice { offset: 149, length: 1 }),
        ('\u{1d4c}', Slice { offset: 150, length: 1 }),
        ('\u{1d4d}', Slice { offset: 151, length: 1 }),
        ('\u{1d4f}', Slice { offset: 152, length: 1 }),
        ('\u{1d50}', Slice { offset: 153, length: 1 }),
        ('\u{1d51}', Slice { offset: 154, length: 1 }),
        ('\u{1d52}', Slice { offset: 14, length: 1 }),
        ('\u{1d53}', Slice { offset: 155, length: 1 }),
        ('\u{1d54}', Slice { offset: 156, length: 1 }),
        ('\u{1d55}', Slice { offset: 157, length: 1 }),
        ('\u{1d56}', Slice { offset: 158, length: 1 }),
        ('\u{1d57}', Slice { offset: 159, length: 1 }),
        ('\u{1d58}', Slice { offset: 160, length: 1 }),
        ('\u{1d59}', Slice { offset: 161, length: 1 }),
        ('\u{1d5a}', Slice { offset: 162, length: 1 }),
        ('\u{1d5b}', Slice { offset: 163, length: 1 }),
        ('\u{1d5c}', Slice { offset: 164, length: 1 }),
        ('\u{1d5d}', Slice { offset: 86, length: 1 }),
        ('\u{1d5e}', Slice { offset: 165, length: 1 }),
        ('\u{1d5f}', Slice { offset: 166, length: 1 }),
        ('\u{1d60}', Slice { offset: 89, length: 1 }),
        ('\u{1d61}', Slice { offset: 167, length: 1 }),
        ('\u{1d62}', Slice { offset: 168, length: 1 }),
        ('\u{1d63}', Slice { offset: 62, length: 1 }),
        ('\u{1d64}', Slice { offset: 160, length: 1 }),
        ('\u{1d65}', Slice { offset: 163, length: 1 }),
        ('\u{1d66}', Slice { offset: 86, length: 1 }),
        ('\u{1d67}', Slice { offset: 165, length: 1 }),
        ('\u{1d68}', Slice { offset: 92, length: 1 }),
        ('\u{1d69}', Slice { offset: 89, length: 1 }),
        ('\u{1d6a}', Slice { offset: 167, length: 1 }),
        ('\u{1d78}', Slice { offset: 169, length: 1 }),
        ('\u{1d9b}', Slice { offset: 170, length: 1 }),
        ('\u{1d9c}', Slice { offset: 171, length: 1 }),
        ('\u{1d9d}', Slice { offset: 172, length: 1 }),
        ('\u{1d9e}', Slice { offset: 173, length: 1 }),
        ('\u{1d9f}', Slice { offset: 150, length: 1 }),
        ('\u{1da0}', Slice { offset: 174, length: 1 }),
        ('\u{1da1}', Slice { offset: 175, length: 1 }),
        ('\u{1da2}', Slice { offset: 176, length: 1 }),
        ('\u{1da3}', Slice { offset: 177, length: 1 }),
        ('\u{1da4}', Slice { offset: 178, length: 1 }),
        ('\u{1da5}', Slice { offset: 179, length: 1 }),
        ('\u{1da6}', Slice { offset: 180, length: 1 }),
        ('\u{1da7}', Slice { offset: 181, length: 1 }),
        ('\u{1da8}', Slice { offset: 182, length: 1 }),
        ('\u{1da9}', Slice { offset: 183, length: 1 }),
        ('\u{1daa}', Slice { offset: 184, length: 1 }),
        ('\u{1dab}', Slice { offset: 185, length: 1 }),
        ('\u{1dac}', Slice { offset: 186, length: 1 }),
        ('\u{1dad}', Slice { offset: 187, length: 1 }),
        ('\u{1dae}', Slice { offset: 188, length: 1 }),
        ('\u{1daf}', Slice { offset: 189, length: 1 }),
        ('\u{1db0}', Slice { offset: 190, length: 1 }),
        ('\u{1db1}', Slice { offset: 191, length: 1 }),
        ('\u{1db2}', Slice { offset: 192, length: 1 }),
        ('\u{1db3}', Slice { offset: 193, length: 1 }),
        ('\u{1db4}', Slice { offset: 194, length: 1 }),
        ('\u{1db5}', Slice { offset: 195, length: 1 }),
        ('\u{1db6}', Slice { offset: 196, length: 1 }),
        ('\u{1db7}', Slice { offset: 197, length: 1 }),
        ('\u{1db8}', Slice { offset: 198, length: 1 }),
        ('\u{1db9}', Slice { offset: 199, length: 1 }),
        ('\u{1dba}', Slice { offset: 200, length: 1 }),
        ('\u{1dbb}', Slice { offset: 201, length: 1 }),
        ('\u{1dbc}', Slice { offset: 202, length: 1 }),
        ('\u{1dbd}', Slice { offset: 203, length: 1 }),
        ('\u{1dbe}', Slice { offset: 204, length: 1 }),
        ('\u{1dbf}', Slice { offset: 87, length: 1 }),
        ('\u{1e9a}', Slice { offset: 205, length: 2 }),
        ('\u{1fbd}', Slice { offset: 207, length: 2 }),
        ('\u{1fbf}', Slice { offset: 207, length: 2 }),
        ('\u{1fc0}', Slice { offset: 209, length: 2 }),
        ('\u{1ffe}', Slice { offset: 211, length: 2 }),
        ('\u{2002}', Slice { offset: 0, length: 1 }),
        ('\u{2003}', Slice { offset: 0, length: 1 }),
        ('\u{2004}', Slice { offset: 0, length: 1 }),
        ('\u{2005}', Slice { offset: 0, length: 1 }),
        ('\u{2006}', Slice { offset: 0, length: 1 }),
        ('\u{2007}', Slice { offset: 0, length: 1 }),
        ('\u{2008}', Slice { offset: 0, length: 1 }),
        ('\u{2009}', Slice { offset: 0, length: 1 }),
        ('\u{200a}', Slice { offset: 0, length: 1 }),
        ('\u{2011}', Slice { offset: 213, length: 1 }),
        ('\u{2017}', Slice { offset: 214, length: 2 }),
        ('\u{2024}', Slice { offset: 216, length: 1 }),
        ('\u{2025}', Slice { offset: 217, length: 2 }),
        ('\u{2026}', Slice { offset: 219, length: 3 }),
        ('\u{202f}', Slice { offset: 0, length: 1 }),
        ('\u{2033}', Slice { offset: 222, length: 2 }),
        ('\u{2034}', Slice { offset: 224, length: 3 }),
        ('\u{2036}', Slice { offset: 227, length: 2 }),
        ('\u{2037}', Slice { offset: 229, length: 3 }),
        ('\u{203c}', Slice { offset: 232, length: 2 }),
        ('\u{203e}', Slice { offset: 234, length: 2 }),
        ('\u{2047}', Slice { offset: 236, length: 2 }),
        ('\u{2048}', Slice { offset: 238, length: 2 }),
        ('\u{2049}', Slice { offset: 240, length: 2 }),
        ('\u{2057}', Slice { offset: 242, length: 4 }),
        ('\u{205f}', Slice { offset: 0, length: 1 }),
        ('\u{2070}', Slice { offset: 246, length: 1 }),
        ('\u{2071}', Slice { offset: 168, length: 1 }),
        ('\u{2074}', Slice { offset: 247, length: 1 }),
        ('\u{2075}', Slice { offset: 248, length: 1 }),
        ('\u{2076}', Slice { offset: 249, length: 1 }),
        ('\u{2077}', Slice { offset: 250, length: 1 }),
        ('\u{2078}', Slice { offset: 251, length: 1 }),
        ('\u{2079}', Slice { offset: 252, length: 1 }),
        ('\u{207a}', Slice { offset: 253, length: 1 }),
        ('\u{207b}', Slice { offset: 254, length: 1 }),
        ('\u{207c}', Slice { offset: 255, length: 1 }),
        ('\u{207d}', Slice { offset: 256, length: 1 }),
        ('\u{207e}', Slice { offset: 257, length: 1 }),
        ('\u{207f}', Slice { offset: 258, length: 1 }),
        ('\u{2080}', Slice { offset: 246, length: 1 }),
        ('\u{2081}', Slice { offset: 13, length: 1 }),
        ('\u{2082}', Slice { offset: 6, length: 1 }),
        ('\u{2083}', Slice { offset: 7, length: 1 }),
        ('\u{2084}', Slice { offset: 247, length: 1 }),
        ('\u{2085}', Slice { offset: 248, length: 1 }),
        ('\u{2086}', Slice { offset: 249, length: 1 }),
        ('\u{2087}', Slice { offset: 250, length: 1 }),
        ('\u{2088}', Slice { offset: 251, length: 1 }),
        ('\u{2089}', Slice { offset: 252, length: 1 }),
        ('\u{208a}', Slice { offset: 253, length: 1 }),
        ('\u{208b}', Slice { offset: 254, length: 1 }),
        ('\u{208c}', Slice { offset: 255, length: 1 }),
        ('\u{208d}', Slice { offset: 256, length: 1 }),
        ('\u{208e}', Slice { offset: 257, length: 1 }),
        ('\u{2090}', Slice { offset: 3, length: 1 }),
        ('\u{2091}', Slice { offset: 147, length: 1 }),
        ('\u{2092}', Slice { offset: 14, length: 1 }),
        ('\u{2093}', Slice { offset: 82, length: 1 }),
        ('\u{2094}', Slice { offset: 148, length: 1 }),
        ('\u{2095}', Slice { offset: 59, length: 1 }),
        ('\u{2096}', Slice { offset: 152, length: 1 }),
        ('\u{2097}', Slice { offset: 81, length: 1 }),
        ('\u{2098}', Slice { offset: 153, length: 1 }),
        ('\u{2099}', Slice { offset: 258, length: 1 }),
        ('\u{209a}', Slice { offset: 158, length: 1 }),
        ('\u{209b}', Slice { offset: 34, length: 1 }),
        ('\u{209c}', Slice { offset: 159, length: 1 }),
        ('\u{20a8}', Slice { offset: 259, length: 2 }),
        ('\u{2100}', Slice { offset: 261, length: 3 }),
        ('\u{2101}', Slice { offset: 264, length: 3 }),
        ('\u{2102}', Slice { offset: 267, length: 1 }),
        ('\u{2103}', Slice { offset: 268, length: 2 }),
        ('\u{2105}', Slice { offset: 270, length: 3 }),
        ('\u{2106}', Slice { offset: 273, length: 3 }),
        ('\u{2107}', Slice { offset: 276, length: 1 }),
        ('\u{2109}', Slice { offset: 277, length: 2 }),
        ('\u{210a}', Slice { offset: 151, length: 1 }),
        ('\u{210b}', Slice { offset: 128, length: 1 }),
        ('\u{210c}', Slice { offset: 128, length: 1 }),
        ('\u{210d}', Slice { offset: 128, length: 1 }),
        ('\u{210e}', Slice { offset: 59, length: 1 }),
        ('\u{210f}', Slice { offset: 279, length: 1 }),
        ('\u{2110}', Slice { offset: 129, length: 1 }),
        ('\u{2111}', Slice { offset: 129, length: 1 }),
        ('\u{2112}', Slice { offset: 132, length: 1 }),
        ('\u{2113}', Slice { offset: 81, length: 1 }),
        ('\u{2115}', Slice { offset: 134, length: 1 }),
        ('\u{2116}', Slice { offset: 280, length: 2 }),
        ('\u{2119}', Slice { offset: 137, length: 1 }),
        ('\u{211a}', Slice { offset: 282, length: 1 }),
        ('\u{211b}', Slice { offset: 138, length: 1 }),
        ('\u{211c}', Slice { offset: 138, length: 1 }),
        ('\u{211d}', Slice { offset: 138, length: 1 }),
        ('\u{2120}', Slice { offset: 283, length: 2 }),
        ('\u{2121}', Slice { offset: 285, length: 3 }),
        ('\u{2122}', Slice { offset: 288, length: 2 }),
        ('\u{2124}', Slice { offset: 290, length: 1 }),
        ('\u{2128}', Slice { offset: 290, length: 1 }),
        ('\u{212c}', Slice { offset: 123, length: 1 }),
        ('\u{212d}', Slice { offset: 267, length: 1 }),
        ('\u{212f}', Slice { offset: 147, length: 1 }),
        ('\u{2130}', Slice { offset: 125, length: 1 }),
        ('\u{2131}', Slice { offset: 291, length: 1 }),
        ('\u{2133}', Slice { offset: 133, length: 1 }),
        ('\u{2134}', Slice { offset: 14, length: 1 }),
        ('\u{2135}', Slice { offset: 292, length: 1 }),
        ('\u{2136}', Slice { offset: 293, length: 1 }),
        ('\u{2137}', Slice { offset: 294, length: 1 }),
        ('\u{2138}', Slice { offset: 295, length: 1 }),
        ('\u{2139}', Slice { offset: 168, length: 1 }),
        ('\u{213b}', Slice { offset: 296, length: 3 }),
        ('\u{213c}', Slice { offset: 90, length: 1 }),
        ('\u{213d}', Slice { offset: 165, length: 1 }),
        ('\u{213e}', Slice { offset: 299, length: 1 }),
        ('\u{213f}', Slice { offset: 300, length: 1 }),
        ('\u{2140}', Slice { offset: 301, length: 1 }),
        ('\u{2145}', Slice { offset: 124, length: 1 }),
        ('\u{2146}', Slice { offset: 146, length: 1 }),
        ('\u{2147}', Slice { offset: 147, length: 1 }),
        ('\u{2148}', Slice { offset: 168, length: 1 }),
        ('\u{2149}', Slice { offset: 61, length: 1 }),
        ('\u{2150}', Slice { offset: 302, length: 3 }),
        ('\u{2151}', Slice { offset: 305, length: 3 }),
        ('\u{2152}', Slice { offset: 308, length: 4 }),
        ('\u{2153}', Slice { offset: 312, length: 3 }),
        ('\u{2154}', Slice { offset: 315, length: 3 }),
        ('\u{2155}', Slice { offset: 318, length: 3 }),
        ('\u{2156}', Slice { offset: 321, length: 3 }),
        ('\u{2157}', Slice { offset: 324, length: 3 }),
        ('\u{2158}', Slice { offset: 327, length: 3 }),
        ('\u{2159}', Slice { offset: 330, length: 3 }),
        ('\u{215a}', Slice { offset: 333, length: 3 }),
        ('\u{215b}', Slice { offset: 336, length: 3 }),
        ('\u{215c}', Slice { offset: 339, length: 3 }),
        ('\u{215d}', Slice { offset: 342, length: 3 }),
        ('\u{215e}', Slice { offset: 345, length: 3 }),
        ('\u{215f}', Slice { offset: 348, length: 2 }),
        ('\u{2160}', Slice { offset: 129, length: 1 }),
        ('\u{2161}', Slice { offset: 350, length: 2 }),
        ('\u{2162}', Slice { offset: 352, length: 3 }),
        ('\u{2163}', Slice { offset: 355, length: 2 }),
        ('\u{2164}', Slice { offset: 357, length: 1 }),
        ('\u{2165}', Slice { offset: 358, length: 2 }),
        ('\u{2166}', Slice { offset: 360, length: 3 }),
        ('\u{2167}', Slice { offset: 363, length: 4 }),
        ('\u{2168}', Slice { offset: 367, length: 2 }),
        ('\u{2169}', Slice { offset: 369, length: 1 }),
        ('\u{216a}', Slice { offset: 370, length: 2 }),
        ('\u{216b}', Slice { offset: 372, length: 3 }),
        ('\u{216c}', Slice { offset: 132, length: 1 }),
        ('\u{216d}', Slice { offset: 267, length: 1 }),
        ('\u{216e}', Slice { offset: 124, length: 1 }),
        ('\u{216f}', Slice { offset: 133, length: 1 }),
        ('\u{2170}', Slice { offset: 168, length: 1 }),
        ('\u{2171}', Slice { offset: 375, length: 2 }),
        ('\u{2172}', Slice { offset: 377, length: 3 }),
        ('\u{2173}', Slice { offset: 380, length: 2 }),
        ('\u{2174}', Slice { offset: 163, length: 1 }),
        ('\u{2175}', Slice { offset: 382, length: 2 }),
        ('\u{2176}', Slice { offset: 384, length: 3 }),
        ('\u{2177}', Slice { offset: 387, length: 4 }),
        ('\u{2178}', Slice { offset: 391, length: 2 }),
        ('\u{2179}', Slice { offset: 82, length: 1 }),
        ('\u{217a}', Slice { offset: 393, length: 2 }),
        ('\u{217b}', Slice { offset: 395, length: 3 }),
        ('\u{217c}', Slice { offset: 81, length: 1 }),
        ('\u{217d}', Slice { offset: 171, length: 1 }),
        ('\u{217e}', Slice { offset: 146, length: 1 }),
        ('\u{217f}', Slice { offset: 153, length: 1 }),
        ('\u{2189}', Slice { offset: 398, length: 3 }),
        ('\u{222c}', Slice { offset: 401, length: 2 }),
        ('\u{222d}', Slice { offset: 403, length: 3 }),
        ('\u{222f}', Slice { offset: 406, length: 2 }),
        ('\u{2230}', Slice { offset: 408, length: 3 }),
        ('\u{2460}', Slice { offset: 13, length: 1 }),
        ('\u{2461}', Slice { offset: 6, length: 1 }),
        ('\u{2462}', Slice { offset: 7, length: 1 }),
        ('\u{2463}', Slice { offset: 247, length: 1 }),
        ('\u{2464}', Slice { offset: 248, length: 1 }),
        ('\u{2465}', Slice { offset: 249, length: 1 }),
        ('\u{2466}', Slice { offset: 250, length: 1 }),
        ('\u{2467}', Slice { offset: 251, length: 1 }),
        ('\u{2468}', Slice { offset: 252, length: 1 }),
        ('\u{2469}', Slice { offset: 411, length: 2 }),
        ('\u{246a}', Slice { offset: 413, length: 2 }),
        ('\u{246b}', Slice { offset: 415, length: 2 }),
        ('\u{246c}', Slice { offset: 417, length: 2 }),
        ('\u{246d}', Slice { offset: 419, length: 2 }),
        ('\u{246e}', Slice { offset: 421, length: 2 }),
        ('\u{246f}', Slice { offset: 423, length: 2 }),
        ('\u{2470}', Slice { offset: 425, length: 2 }),
        ('\u{2471}', Slice { offset: 427, length: 2 }),
        ('\u{2472}', Slice { offset: 429, length: 2 }),
        ('\u{2473}', Slice { offset: 431, length: 2 }),
        ('\u{2474}', Slice { offset: 433, length: 3 }),
        ('\u{2475}', Slice { offset: 436, length: 3 }),
        ('\u{2476}', Slice { offset: 439, length: 3 }),
        ('\u{2477}', Slice { offset: 442, length: 3 }),
        ('\u{2478}', Slice { offset: 445, length: 3 }),
        ('\u{2479}', Slice { offset: 448, length: 3 }),
        ('\u{247a}', Slice { offset: 451, length: 3 }),
        ('\u{247b}', Slice { offset: 454, length: 3 }),
        ('\u{247c}', Slice { offset: 457, length: 3 }),
        ('\u{247d}', Slice { offset: 460, length: 4 }),
        ('\u{247e}', Slice { offset: 464, length: 4 }),
        ('\u{247f}', Slice { offset: 468, length: 4 }),
        ('\u{2480}', Slice { offset: 472, length: 4 }),
        ('\u{2481}', Slice { offset: 476, length: 4 }),
        ('\u{2482}', Slice { offset: 480, length: 4 }),
        ('\u{2483}', Slice { offset: 484, length: 4 }),
        ('\u{2484}', Slice { offset: 488, length: 4 }),
        ('\u{2485}', Slice { offset: 492, length: 4 }),
        ('\u{2486}', Slice { offset: 496, length: 4 }),
        ('\u{2487}', Slice { offset: 500, length: 4 }),
        ('\u{2488}', Slice { offset: 504, length: 2 }),
        ('\u{2489}', Slice { offset: 506, length: 2 }),
        ('\u{248a}', Slice { offset: 508, length: 2 }),
        ('\u{248b}', Slice { offset: 510, length: 2 }),
        ('\u{248c}', Slice { offset: 512, length: 2 }),
        ('\u{248d}', Slice { offset: 514, length: 2 }),
        ('\u{248e}', Slice { offset: 516, length: 2 }),
        ('\u{248f}', Slice { offset: 518, length: 2 }),
        ('\u{2490}', Slice { offset: 520, length: 2 }),
        ('\u{2491}', Slice { offset: 522, length: 3 }),
        ('\u{2492}', Slice { offset: 525, length: 3 }),
        ('\u{2493}', Slice { offset: 528, length: 3 }),
        ('\u{2494}', Slice { offset: 531, length: 3 }),
        ('\u{2495}', Slice { offset: 534, length: 3 }),
        ('\u{2496}', Slice { offset: 537, length: 3 }),
        ('\u{2497}', Slice { offset: 540, length: 3 }),
        ('\u{2498}', Slice { offset: 543, length: 3 }),
        ('\u{2499}', Slice { offset: 546, length: 3 }),
        ('\u{249a}', Slice { offset: 549, length: 3 }),
        ('\u{249b}', Slice { offset: 552, length: 3 }),
        ('\u{249c}', Slice { offset: 555, length: 3 }),
        ('\u{249d}', Slice { offset: 558, length: 3 }),
        ('\u{249e}', Slice { offset: 561, length: 3 }),
        ('\u{249f}', Slice { offset: 564, length: 3 }),
        ('\u{24a0}', Slice { offset: 567, length: 3 }),
        ('\u{24a1}', Slice { offset: 570, length: 3 }),
        ('\u{24a2}', Slice { offset: 573, length: 3 }),
        ('\u{24a3}', Slice { offset: 576, length: 3 }),
        ('\u{24a4}', Slice { offset: 579, length: 3 }),
        ('\u{24a5}', Slice { offset: 582, length: 3 }),
        ('\u{24a6}', Slice { offset: 585, length: 3 }),
        ('\u{24a7}', Slice { offset: 588, length: 3 }),
        ('\u{24a8}', Slice { offset: 591, length: 3 }),
        ('\u{24a9}', Slice { offset: 594, length: 3 }),
        ('\u{24aa}', Slice { offset: 597, length: 3 }),
        ('\u{24ab}', Slice { offset: 600, length: 3 }),
        ('\u{24ac}', Slice { offset: 603, length: 3 }),
        ('\u{24ad}', Slice { offset: 606, length: 3 }),
        ('\u{24ae}', Slice { offset: 609, length: 3 }),
        ('\u{24af}', Slice { offset: 612, length: 3 }),
        ('\u{24b0}', Slice { offset: 615, length: 3 }),
        ('\u{24b1}', Slice { offset: 618, length: 3 }),
        ('\u{24b2}', Slice { offset: 621, length: 3 }),
        ('\u{24b3}', Slice { offset: 624, length: 3 }),
        ('\u{24b4}', Slice { offset: 627, length: 3 }),
        ('\u{24b5}', Slice { offset: 630, length: 3 }),
        ('\u{24b6}', Slice { offset: 121, length: 1 }),
        ('\u{24b7}', Slice { offset: 123, length: 1 }),
        ('\u{24b8}', Slice { offset: 267, length: 1 }),
        ('\u{24b9}', Slice { offset: 124, length: 1 }),
        ('\u{24ba}', Slice { offset: 125, length: 1 }),
        ('\u{24bb}', Slice { offset: 291, length: 1 }),
        ('\u{24bc}', Slice { offset: 127, length: 1 }),
        ('\u{24bd}', Slice { offset: 128, length: 1 }),
        ('\u{24be}', Slice { offset: 129, length: 1 }),
        ('\u{24bf}', Slice { offset: 130, length: 1 }),
        ('\u{24c0}', Slice { offset: 131, length: 1 }),
        ('\u{24c1}', Slice { offset: 132, length: 1 }),
        ('\u{24c2}', Slice { offset: 133, length: 1 }),
        ('\u{24c3}', Slice { offset: 134, length: 1 }),
        ('\u{24c4}', Slice { offset: 135, length: 1 }),
        ('\u{24c5}', Slice { offset: 137, length: 1 }),
        ('\u{24c6}', Slice { offset: 282, length: 1 }),
        ('\u{24c7}', Slice { offset: 138, length: 1 }),
        ('\u{24c8}', Slice { offset: 633, length: 1 }),
        ('\u{24c9}', Slice { offset: 139, length: 1 }),
        ('\u{24ca}', Slice { offset: 140, length: 1 }),
        ('\u{24cb}', Slice { offset: 357, length: 1 }),
        ('\u{24cc}', Slice { offset: 141, length: 1 }),
        ('\u{24cd}', Slice { offset: 369, length: 1 }),
        ('\u{24ce}', Slice { offset: 634, length: 1 }),
        ('\u{24cf}', Slice { offset: 290, length: 1 }),
        ('\u{24d0}', Slice { offset: 3, length: 1 }),
        ('\u{24d1}', Slice { offset: 145, length: 1 }),
        ('\u{24d2}', Slice { offset: 171, length: 1 }),
        ('\u{24d3}', Slice { offset: 146, length: 1 }),
        ('\u{24d4}', Slice { offset: 147, length: 1 }),
        ('\u{24d5}', Slice { offset: 174, length: 1 }),
        ('\u{24d6}', Slice { offset: 151, length: 1 }),
        ('\u{24d7}', Slice { offset: 59, length: 1 }),
        ('\u{24d8}', Slice { offset: 168, length: 1 }),
        ('\u{24d9}', Slice { offset: 61, length: 1 }),
        ('\u{24da}', Slice { offset: 152, length: 1 }),
        ('\u{24db}', Slice { offset: 81, length: 1 }),
        ('\u{24dc}', Slice { offset: 153, length: 1 }),
        ('\u{24dd}', Slice { offset: 258, length: 1 }),
        ('\u{24de}', Slice { offset: 14, length: 1 }),
        ('\u{24df}', Slice { offset: 158, length: 1 }),
        ('\u{24e0}', Slice { offset: 635, length: 1 }),
        ('\u{24e1}', Slice { offset: 62, length: 1 }),
        ('\u{24e2}', Slice { offset: 34, length: 1 }),
        ('\u{24e3}', Slice { offset: 159, length: 1 }),
        ('\u{24e4}', Slice { offset: 160, length: 1 }),
        ('\u{24e5}', Slice { offset: 163, length: 1 }),
        ('\u{24e6}', Slice { offset: 66, length: 1 }),
        ('\u{24e7}', Slice { offset: 82, length: 1 }),
        ('\u{24e8}', Slice { offset: 67, length: 1 }),
        ('\u{24e9}', Slice { offset: 201, length: 1 }),
        ('\u{24ea}', Slice { offset: 246, length: 1 }),
        ('\u{2a0c}', Slice { offset: 636, length: 4 }),
        ('\u{2a74}', Slice { offset: 640, length: 3 }),
        ('\u{2a75}', Slice { offset: 643, length: 2 }),
        ('\u{2a76}', Slice { offset: 645, length: 3 }),
        ('\u{2c7c}', Slice { offset: 61, length: 1 }),
        ('\u{2c7d}', Slice { offset: 357, length: 1 }),
        ('\u{2d6f}', Slice { offset: 648, length: 1 }),
        ('\u{2e9f}', Slice { offset: 649, length: 1 }),
        ('\u{2ef3}', Slice { offset: 650, length: 1 }),
        ('\u{2f00}', Slice { offset: 651, length: 1 }),
        ('\u{2f01}', Slice { offset: 652, length: 1 }),
        ('\u{2f02}', Slice { offset: 653, length: 1 }),
        ('\u{2f03}', Slice { offset: 654, length: 1 }),
        ('\u{2f04}', Slice { offset: 655, length: 1 }),
        ('\u{2f05}', Slice { offset: 656, length: 1 }),
        ('\u{2f06}', Slice { offset: 657, length: 1 }),
        ('\u{2f07}', Slice { offset: 658, length: 1 }),
        ('\u{2f08}', Slice { offset: 659, length: 1 }),
        ('\u{2f09}', Slice { offset: 660, length: 1 }),
        ('\u{2f0a}', Slice { offset: 661, length: 1 }),
        ('\u{2f0b}', Slice { offset: 662, length: 1 }),
        ('\u{2f0c}', Slice { offset: 663, length: 1 }),
        ('\u{2f0d}', Slice { offset: 664, length: 1 }),
        ('\u{2f0e}', Slice { offset: 665, length: 1 }),
        ('\u{2f0f}', Slice { offset: 666, length: 1 }),
        ('\u{2f10}', Slice { offset: 667, length: 1 }),
        ('\u{2f11}', Slice { offset: 668, length: 1 }),
        ('\u{2f12}', Slice { offset: 669, length: 1 }),
        ('\u{2f13}', Slice { offset: 670, length: 1 }),
        ('\u{2f14}', Slice { offset: 671, length: 1 }),
        ('\u{2f15}', Slice { offset: 672, length: 1 }),
        ('\u{2f16}', Slice { offset: 673, length: 1 }),
        ('\u{2f17}', Slice { offset: 674, length: 1 }),
        ('\u{2f18}', Slice { offset: 675, length: 1 }),
        ('\u{2f19}', Slice { offset: 676, length: 1 }),
        ('\u{2f1a}', Slice { offset: 677, length: 1 }),
        ('\u{2f1b}', Slice { offset: 678, length: 1 }),
        ('\u{2f1c}', Slice { offset: 679, length: 1 }),
        ('\u{2f1d}', Slice { offset: 680, length: 1 }),
        ('\u{2f1e}', Slice { offset: 681, length: 1 }),
        ('\u{2f1f}', Slice { offset: 682, length: 1 }),
        ('\u{2f20}', Slice { offset: 683, length: 1 }),
        ('\u{2f21}', Slice { offset: 684, length: 1 }),
        ('\u{2f22}', Slice { offset: 685, length: 1 }),
        ('\u{2f23}', Slice { offset: 686, length: 1 }),
        ('\u{2f24}', Slice { offset: 687, length: 1 }),
        ('\u{2f25}', Slice { offset: 688, length: 1 }),
        ('\u{2f26}', Slice { offset: 689, length: 1 }),
        ('\u{2f27}', Slice { offset: 690, length: 1 }),
        ('\u{2f28}', Slice { offset: 691, length: 1 }),
        ('\u{2f29}', Slice { offset: 692, length: 1 }),
        ('\u{2f2a}', Slice { offset: 693, length: 1 }),
        ('\u{2f2b}', Slice { offset: 694, length: 1 }),
        ('\u{2f2c}', Slice { offset: 695, length: 1 }),
        ('\u{2f2d}', Slice { offset: 696, length: 1 }),
        ('\u{2f2e}', Slice { offset: 697, length: 1 }),
        ('\u{2f2f}', Slice { offset: 698, length: 1 }),
        ('\u{2f30}', Slice { offset: 699, length: 1 }),
        ('\u{2f31}', Slice { offset: 700, length: 1 }),
        ('\u{2f32}', Slice { offset: 701, length: 1 }),
        ('\u{2f33}', Slice { offset: 702, length: 1 }),
        ('\u{2f34}', Slice { offset: 703, length: 1 }),
        ('\u{2f35}', Slice { offset: 704, length: 1 }),
        ('\u{2f36}', Slice { offset: 705, length: 1 }),
        ('\u{2f37}', Slice { offset: 706, length: 1 }),
        ('\u{2f38}', Slice { offset: 707, length: 1 }),
        ('\u{2f39}', Slice { offset: 708, length: 1 }),
        ('\u{2f3a}', Slice { offset: 709, length: 1 }),
        ('\u{2f3b}', Slice { offset: 710, length: 1 }),
        ('\u{2f3c}', Slice { offset: 711, length: 1 }),
        ('\u{2f3d}', Slice { offset: 712, length: 1 }),
        ('\u{2f3e}', Slice { offset: 713, length: 1 }),
        ('\u{2f3f}', Slice { offset: 714, length: 1 }),
        ('\u{2f40}', Slice { offset: 715, length: 1 }),
        ('\u{2f41}', Slice { offset: 716, length: 1 }),
        ('\u{2f42}', Slice { offset: 717, length: 1 }),
        ('\u{2f43}', Slice { offset: 718, length: 1 }),
        ('\u{2f44}', Slice { offset: 719, length: 1 }),
        ('\u{2f45}', Slice { offset: 720, length: 1 }),
        ('\u{2f46}', Slice { offset: 721, length: 1 }),
        ('\u{2f47}', Slice { offset: 722, length: 1 }),
        ('\u{2f48}', Slice { offset: 723, length: 1 }),
        ('\u{2f49}', Slice { offset: 724, length: 1 }),
        ('\u{2f4a}', Slice { offset: 725, length: 1 }),
        ('\u{2f4b}', Slice { offset: 726, length: 1 }),
        ('\u{2f4c}', Slice { offset: 727, length: 1 }),
        ('\u{2f4d}', Slice { offset: 728, length: 1 }),
        ('\u{2f4e}', Slice { offset: 729, length: 1 }),
        ('\u{2f4f}', Slice { offset: 730, length: 1 }),
        ('\u{2f50}', Slice { offset: 731, length: 1 }),
        ('\u{2f51}', Slice { offset: 732, length: 1 }),
        ('\u{2f52}', Slice { offset: 733, length: 1 }),
        ('\u{2f53}', Slice { offset: 734, length: 1 }),
        ('\u{2f54}', Slice { offset: 735, length: 1 }),
        ('\u{2f55}', Slice { offset: 736, length: 1 }),
        ('\u{2f56}', Slice { offset: 737, length: 1 }),
        ('\u{2f57}', Slice { offset: 738, length: 1 }),
        ('\u{2f58}', Slice { offset: 739, length: 1 }),
        ('\u{2f59}', Slice { offset: 740, length: 1 }),
        ('\u{2f5a}', Slice { offset: 741, length: 1 }),
        ('\u{2f5b}', Slice { offset: 742, length: 1 }),
        ('\u{2f5c}', Slice { offset: 743, length: 1 }),
        ('\u{2f5d}', Slice { offset: 744, length: 1 }),
        ('\u{2f5e}', Slice { offset: 745, length: 1 }),
        ('\u{2f5f}', Slice { offset: 746, length: 1 }),
        ('\u{2f60}', Slice { offset: 747, length: 1 }),
        ('\u{2f61}', Slice { offset: 748, length: 1 }),
        ('\u{2f62}', Slice { offset: 749, length: 1 }),
        ('\u{2f63}', Slice { offset: 750, length: 1 }),
        ('\u{2f64}', Slice { offset: 751, length: 1 }),
        ('\u{2f65}', Slice { offset: 752, length: 1 }),
        ('\u{2f66}', Slice { offset: 753, length: 1 }),
        ('\u{2f67}', Slice { offset: 754, length: 1 }),
        ('\u{2f68}', Slice { offset: 755, length: 1 }),
        ('\u{2f69}', Slice { offset: 756, length: 1 }),
        ('\u{2f6a}', Slice { offset: 757, length: 1 }),
        ('\u{2f6b}', Slice { offset: 758, length: 1 }),
        ('\u{2f6c}', Slice { offset: 759, length: 1 }),
        ('\u{2f6d}', Slice { offset: 760, length: 1 }),
        ('\u{2f6e}', Slice { offset: 761, length: 1 }),
        ('\u{2f6f}', Slice { offset: 762, length: 1 }),
        ('\u{2f70}', Slice { offset: 763, length: 1 }),
        ('\u{2f71}', Slice { offset: 764, length: 1 }),
        ('\u{2f72}', Slice { offset: 765, length: 1 }),
        ('\u{2f73}', Slice { offset: 766, length: 1 }),
        ('\u{2f74}', Slice { offset: 767, length: 1 }),
        ('\u{2f75}', Slice { offset: 768, length: 1 }),
        ('\u{2f76}', Slice { offset: 769, length: 1 }),
        ('\u{2f77}', Slice { offset: 770, length: 1 }),
        ('\u{2f78}', Slice { offset: 771, length: 1 }),
        ('\u{2f79}', Slice { offset: 772, length: 1 }),
        ('\u{2f7a}', Slice { offset: 773, length: 1 }),
        ('\u{2f7b}', Slice { offset: 774, length: 1 }),
        ('\u{2f7c}', Slice { offset: 775, length: 1 }),
        ('\u{2f7d}', Slice { offset: 776, length: 1 }),
        ('\u{2f7e}', Slice { offset: 777, length: 1 }),
        ('\u{2f7f}', Slice { offset: 778, length: 1 }),
        ('\u{2f80}', Slice { offset: 779, length: 1 }),
        ('\u{2f81}', Slice { offset: 780, length: 1 }),
        ('\u{2f82}', Slice { offset: 781, length: 1 }),
        ('\u{2f83}', Slice { offset: 782, length: 1 }),
        ('\u{2f84}', Slice { offset: 783, length: 1 }),
        ('\u{2f85}', Slice { offset: 784, length: 1 }),
        ('\u{2f86}', Slice { offset: 785, length: 1 }),
        ('\u{2f87}', Slice { offset: 786, length: 1 }),
        ('\u{2f88}', Slice { offset: 787, length: 1 }),
        ('\u{2f89}', Slice { offset: 788, length: 1 }),
        ('\u{2f8a}', Slice { offset: 789, length: 1 }),
        ('\u{2f8b}', Slice { offset: 790, length: 1 }),
        ('\u{2f8c}', Slice { offset: 791, length: 1 }),
        ('\u{2f8d}', Slice { offset: 792, length: 1 }),
        ('\u{2f8e}', Slice { offset: 793, length: 1 }),
        ('\u{2f8f}', Slice { offset: 794, length: 1 }),
        ('\u{2f90}', Slice { offset: 795, length: 1 }),
        ('\u{2f91}', Slice { offset: 796, length: 1 }),
        ('\u{2f92}', Slice { offset: 797, length: 1 }),
        ('\u{2f93}', Slice { offset: 798, length: 1 }),
        ('\u{2f94}', Slice { offset: 799, length: 1 }),
        ('\u{2f95}', Slice { offset: 800, length: 1 }),
        ('\u{2f96}', Slice { offset: 801, length: 1 }),
        ('\u{2f97}', Slice { offset: 802, length: 1 }),
        ('\u{2f98}', Slice { offset: 803, length: 1 }),
        ('\u{2f99}', Slice { offset: 804, length: 1 }),
        ('\u{2f9a}', Slice { offset: 805, length: 1 }),
        ('\u{2f9b}', Slice { offset: 806, length: 1 }),
        ('\u{2f9c}', Slice { offset: 807, length: 1 }),
        ('\u{2f9d}', Slice { offset: 808, length: 1 }),
        ('\u{2f9e}', Slice { offset: 809, length: 1 }),
        ('\u{2f9f}', Slice { offset: 810, length: 1 }),
        ('\u{2fa0}', Slice { offset: 811, length: 1 }),
        ('\u{2fa1}', Slice { offset: 812, length: 1 }),
        ('\u{2fa2}', Slice { offset: 813, length: 1 }),
        ('\u{2fa3}', Slice { offset: 814, length: 1 }),
        ('\u{2fa4}', Slice { offset: 815, length: 1 }),
        ('\u{2fa5}', Slice { offset: 816, length: 1 }),
        ('\u{2fa6}', Slice { offset: 817, length: 1 }),
        ('\u{2fa7}', Slice { offset: 818, length: 1 }),
        ('\u{2fa8}', Slice { offset: 819, length: 1 }),
        ('\u{2fa9}', Slice { offset: 820, length: 1 }),
        ('\u{2faa}', Slice { offset: 821, length: 1 }),
        ('\u{2fab}', Slice { offset: 822, length: 1 }),
        ('\u{2fac}', Slice { offset: 823, length: 1 }),
        ('\u{2fad}', Slice { offset: 824, length: 1 }),
        ('\u{2fae}', Slice { offset: 825, length: 1 }),
        ('\u{2faf}', Slice { offset: 826, length: 1 }),
        ('\u{2fb0}', Slice { offset: 827, length: 1 }),
        ('\u{2fb1}', Slice { offset: 828, length: 1 }),
        ('\u{2fb2}', Slice { offset: 829, length: 1 }),
        ('\u{2fb3}', Slice { offset: 830, length: 1 }),
        ('\u{2fb4}', Slice { offset: 831, length: 1 }),
        ('\u{2fb5}', Slice { offset: 832, length: 1 }),
        ('\u{2fb6}', Slice { offset: 833, length: 1 }),
        ('\u{2fb7}', Slice { offset: 834, length: 1 }),
        ('\u{2fb8}', Slice { offset: 835, length: 1 }),
        ('\u{2fb9}', Slice { offset: 836, length: 1 }),
        ('\u{2fba}', Slice { offset: 837, length: 1 }),
        ('\u{2fbb}', Slice { offset: 838, length: 1 }),
        ('\u{2fbc}', Slice { offset: 839, length: 1 }),
        ('\u{2fbd}', Slice { offset: 840, length: 1 }),
        ('\u{2fbe}', Slice { offset: 841, length: 1 }),
        ('\u{2fbf}', Slice { offset: 842, length: 1 }),
        ('\u{2fc0}', Slice { offset: 843, length: 1 }),
        ('\u{2fc1}', Slice { offset: 844, length: 1 }),
        ('\u{2fc2}', Slice { offset: 845, length: 1 }),
        ('\u{2fc3}', Slice { offset: 846, length: 1 }),
        ('\u{2fc4}', Slice { offset: 847, length: 1 }),
        ('\u{2fc5}', Slice { offset: 848, length: 1 }),
        ('\u{2fc6}', Slice { offset: 849, length: 1 }),
        ('\u{2fc7}', Slice { offset: 850, length: 1 }),
        ('\u{2fc8}', Slice { offset: 851, length: 1 }),
        ('\u{2fc9}', Slice { offset: 852, length: 1 }),
        ('\u{2fca}', Slice { offset: 853, length: 1 }),
        ('\u{2fcb}', Slice { offset: 854, length: 1 }),
        ('\u{2fcc}', Slice { offset: 855, length: 1 }),
        ('\u{2fcd}', Slice { offset: 856, length: 1 }),
        ('\u{2fce}', Slice { offset: 857, length: 1 }),
        ('\u{2fcf}', Slice { offset: 858, length: 1 }),
        ('\u{2fd0}', Slice { offset: 859, length: 1 }),
        ('\u{2fd1}', Slice { offset: 860, length: 1 }),
        ('\u{2fd2}', Slice { offset: 861, length: 1 }),
        ('\u{2fd3}', Slice { offset: 862, length: 1 }),
        ('\u{2fd4}', Slice { offset: 863, length: 1 }),
        ('\u{2fd5}', Slice { offset: 864, length: 1 }),
        ('\u{3000}', Slice { offset: 0, length: 1 }),
        ('\u{3036}', Slice { offset: 865, length: 1 }),
        ('\u{3038}', Slice { offset: 674, length: 1 }),
        ('\u{3039}', Slice { offset: 866, length: 1 }),
        ('\u{303a}', Slice { offset: 867, length: 1 }),
        ('\u{309b}', Slice { offset: 868, length: 2 }),
        ('\u{309c}', Slice { offset: 870, length: 2 }),
        ('\u{309f}', Slice { offset: 872, length: 2 }),
        ('\u{30ff}', Slice { offset: 874, length: 2 }),
        ('\u{3131}', Slice { offset: 876, length: 1 }),
        ('\u{3132}', Slice { offset: 877, length: 1 }),
        ('\u{3133}', Slice { offset: 878, length: 1 }),
        ('\u{3134}', Slice { offset: 879, length: 1 }),
        ('\u{3135}', Slice { offset: 880, length: 1 }),
        ('\u{3136}', Slice { offset: 881, length: 1 }),
        ('\u{3137}', Slice { offset: 882, length: 1 }),
        ('\u{3138}', Slice { offset: 883, length: 1 }),
        ('\u{3139}', Slice { offset: 884, length: 1 }),
        ('\u{313a}', Slice { offset: 885, length: 1 }),
        ('\u{313b}', Slice { offset: 886, length: 1 }),
        ('\u{313c}', Slice { offset: 887, length: 1 }),
        ('\u{313d}', Slice { offset: 888, length: 1 }),
        ('\u{313e}', Slice { offset: 889, length: 1 }),
        ('\u{313f}', Slice { offset: 890, length: 1 }),
        ('\u{3140}', Slice { offset: 891, length: 1 }),
        ('\u{3141}', Slice { offset: 892, length: 1 }),
        ('\u{3142}', Slice { offset: 893, length: 1 }),
        ('\u{3143}', Slice { offset: 894, length: 1 }),
        ('\u{3144}', Slice { offset: 895, length: 1 }),
        ('\u{3145}', Slice { offset: 896, length: 1 }),
        ('\u{3146}', Slice { offset: 897, length: 1 }),
        ('\u{3147}', Slice { offset: 898, length: 1 }),
        ('\u{3148}', Slice { offset: 899, length: 1 }),
        ('\u{3149}', Slice { offset: 900, length: 1 }),
        ('\u{314a}', Slice { offset: 901, length: 1 }),
        ('\u{314b}', Slice { offset: 902, length: 1 }),
        ('\u{314c}', Slice { offset: 903, length: 1 }),
        ('\u{314d}', Slice { offset: 904, length: 1 }),
        ('\u{314e}', Slice { offset: 905, length: 1 }),
        ('\u{314f}', Slice { offset: 906, length: 1 }),
        ('\u{3150}', Slice { offset: 907, length: 1 }),
        ('\u{3151}', Slice { offset: 908, length: 1 }),
        ('\u{3152}', Slice { offset: 909, length: 1 }),
        ('\u{3153}', Slice { offset: 910, length: 1 }),
        ('\u{3154}', Slice { offset: 911, length: 1 }),
        ('\u{3155}', Slice { offset: 912, length: 1 }),
        ('\u{3156}', Slice { offset: 913, length: 1 }),
        ('\u{3157}', Slice { offset: 914, length: 1 }),
        ('\u{3158}', Slice { offset: 915, length: 1 }),
        ('\u{3159}', Slice { offset: 916, length: 1 }),
        ('\u{315a}', Slice { offset: 917, length: 1 }),
        ('\u{315b}', Slice { offset: 918, length: 1 }),
        ('\u{315c}', Slice { offset: 919, length: 1 }),
        ('\u{315d}', Slice { offset: 920, length: 1 }),
        ('\u{315e}', Slice { offset: 921, length: 1 }),
        ('\u{315f}', Slice { offset: 922, length: 1 }),
        ('\u{3160}', Slice { offset: 923, length: 1 }),
        ('\u{3161}', Slice { offset: 924, length: 1 }),
        ('\u{3162}', Slice { offset: 925, length: 1 }),
        ('\u{3163}', Slice { offset: 926, length: 1 }),
        ('\u{3164}', Slice { offset: 927, length: 1 }),
        ('\u{3165}', Slice { offset: 928, length: 1 }),
        ('\u{3166}', Slice { offset: 929, length: 1 }),
        ('\u{3167}', Slice { offset: 930, length: 1 }),
        ('\u{3168}', Slice { offset: 931, length: 1 }),
        ('\u{3169}', Slice { offset: 932, length: 1 }),
        ('\u{316a}', Slice { offset: 933, length: 1 }),
        ('\u{316b}', Slice { offset: 934, length: 1 }),
        ('\u{316c}', Slice { offset: 935, length: 1 }),
        ('\u{316d}', Slice { offset: 936, length: 1 }),
        ('\u{316e}', Slice { offset: 937, length: 1 }),
        ('\u{316f}', Slice { offset: 938, length: 1 }),
        ('\u{3170}', Slice { offset: 939, length: 1 }),
        ('\u{3171}', Slice { offset: 940, length: 1 }),
        ('\u{3172}', Slice { offset: 941, length: 1 }),
        ('\u{3173}', Slice { offset: 942, length: 1 }),
        ('\u{3174}', Slice { offset: 943, length: 1 }),
        ('\u{3175}', Slice { offset: 944, length: 1 }),
        ('\u{3176}', Slice { offset: 945, length: 1 }),
        ('\u{3177}', Slice { offset: 946, length: 1 }),
        ('\u{3178}', Slice { offset: 947, length: 1 }),
        ('\u{3179}', Slice { offset: 948, length: 1 }),
        ('\u{317a}', Slice { offset: 949, length: 1 }),
        ('\u{317b}', Slice { offset: 950, length: 1 }),
        ('\u{317c}', Slice { offset: 951, length: 1 }),
        ('\u{317d}', Slice { offset: 952, length: 1 }),
        ('\u{317e}', Slice { offset: 953, length: 1 }),
        ('\u{317f}', Slice { offset: 954, length: 1 }),
        ('\u{3180}', Slice { offset: 955, length: 1 }),
        ('\u{3181}', Slice { offset: 956, length: 1 }),
        ('\u{3182}', Slice { offset: 957, length: 1 }),
        ('\u{3183}', Slice { offset: 958, length: 1 }),
        ('\u{3184}', Slice { offset: 959, length: 1 }),
        ('\u{3185}', Slice { offset: 960, length: 1 }),
        ('\u{3186}', Slice { offset: 961, length: 1 }),
        ('\u{3187}', Slice { offset: 962, length: 1 }),
        ('\u{3188}', Slice { offset: 963, length: 1 }),
        ('\u{3189}', Slice { offset: 964, length: 1 }),
        ('\u{318a}', Slice { offset: 965, length: 1 }),
        ('\u{318b}', Slice { offset: 966, length: 1 }),
        ('\u{318c}', Slice { offset: 967, length: 1 }),
        ('\u{318d}', Slice { offset: 968, length: 1 }),
        ('\u{318e}', Slice { offset: 969, length: 1 }),
        ('\u{3192}', Slice { offset: 651, length: 1 }),
        ('\u{3193}', Slice { offset: 657, length: 1 }),
        ('\u{3194}', Slice { offset: 970, length: 1 }),
        ('\u{3195}', Slice { offset: 971, length: 1 }),
        ('\u{3196}', Slice { offset: 972, length: 1 }),
        ('\u{3197}', Slice { offset: 973, length: 1 }),
        ('\u{3198}', Slice { offset: 974, length: 1 }),
        ('\u{3199}', Slice { offset: 975, length: 1 }),
        ('\u{319a}', Slice { offset: 655, length: 1 }),
        ('\u{319b}', Slice { offset: 976, length: 1 }),
        ('\u{319c}', Slice { offset: 977, length: 1 }),
        ('\u{319d}', Slice { offset: 978, length: 1 }),
        ('\u{319e}', Slice { offset: 979, length: 1 }),
        ('\u{319f}', Slice { offset: 659, length: 1 }),
        ('\u{3200}', Slice { offset: 980, length: 3 }),
        ('\u{3201}', Slice { offset: 983, length: 3 }),
        ('\u{3202}', Slice { offset: 986, length: 3 }),
        ('\u{3203}', Slice { offset: 989, length: 3 }),
        ('\u{3204}', Slice { offset: 992, length: 3 }),
        ('\u{3205}', Slice { offset: 995, length: 3 }),
        ('\u{3206}', Slice { offset: 998, length: 3 }),
        ('\u{3207}', Slice { offset: 1001, length: 3 }),
        ('\u{3208}', Slice { offset: 1004, length: 3 }),
        ('\u{3209}', Slice { offset: 1007, length: 3 }),
        ('\u{320a}', Slice { offset: 1010, length: 3 }),
        ('\u{320b}', Slice { offset: 1013, length: 3 }),
        ('\u{320c}', Slice { offset: 1016, length: 3 }),
        ('\u{320d}', Slice { offset: 1019, length: 3 }),
        ('\u{320e}', Slice { offset: 1022, length: 4 }),
        ('\u{320f}', Slice { offset: 1026, length: 4 }),
        ('\u{3210}', Slice { offset: 1030, length: 4 }),
        ('\u{3211}', Slice { offset: 1034, length: 4 }),
        ('\u{3212}', Slice { offset: 1038, length: 4 }),
        ('\u{3213}', Slice { offset: 1042, length: 4 }),
        ('\u{3214}', Slice { offset: 1046, length: 4 }),
        ('\u{3215}', Slice { offset: 1050, length: 4 }),
        ('\u{3216}', Slice { offset: 1054, length: 4 }),
        ('\u{3217}', Slice { offset: 1058, length: 4 }),
        ('\u{3218}', Slice { offset: 1062, length: 4 }),
        ('\u{3219}', Slice { offset: 1066, length: 4 }),
        ('\u{321a}', Slice { offset: 1070, length: 4 }),
        ('\u{321b}', Slice { offset: 1074, length: 4 }),
        ('\u{321c}', Slice { offset: 1078, length: 4 }),
        ('\u{321d}', Slice { offset: 1082, length: 7 }),
        ('\u{321e}', Slice { offset: 1089, length: 6 }),
        ('\u{3220}', Slice { offset: 1095, length: 3 }),
        ('\u{3221}', Slice { offset: 1098, length: 3 }),
        ('\u{3222}', Slice { offset: 1101, length: 3 }),
        ('\u{3223}', Slice { offset: 1104, length: 3 }),
        ('\u{3224}', Slice { offset: 1107, length: 3 }),
        ('\u{3225}', Slice { offset: 1110, length: 3 }),
        ('\u{3226}', Slice { offset: 1113, length: 3 }),
        ('\u{3227}', Slice { offset: 1116, length: 3 }),
        ('\u{3228}', Slice { offset: 1119, length: 3 }),
        ('\u{3229}', Slice { offset: 1122, length: 3 }),
        ('\u{322a}', Slice { offset: 1125, length: 3 }),
        ('\u{322b}', Slice { offset: 1128, length: 3 }),
        ('\u{322c}', Slice { offset: 1131, length: 3 }),
        ('\u{322d}', Slice { offset: 1134, length: 3 }),
        ('\u{322e}', Slice { offset: 1137, length: 3 }),
        ('\u{322f}', Slice { offset: 1140, length: 3 }),
        ('\u{3230}', Slice { offset: 1143, length: 3 }),
        ('\u{3231}', Slice { offset: 1146, length: 3 }),
        ('\u{3232}', Slice { offset: 1149, length: 3 }),
        ('\u{3233}', Slice { offset: 1152, length: 3 }),
        ('\u{3234}', Slice { offset: 1155, length: 3 }),
        ('\u{3235}', Slice { offset: 1158, length: 3 }),
        ('\u{3236}', Slice { offset: 1161, length: 3 }),
        ('\u{3237}', Slice { offset: 1164, length: 3 }),
        ('\u{3238}', Slice { offset: 1167, length: 3 }),
        ('\u{3239}', Slice { offset: 1170, length: 3 }),
        ('\u{323a}', Slice { offset: 1173, length: 3 }),
        ('\u{323b}', Slice { offset: 1176, length: 3 }),
        ('\u{323c}', Slice { offset: 1179, length: 3 }),
        ('\u{323d}', Slice { offset: 1182, length: 3 }),
        ('\u{323e}', Slice { offset: 1185, length: 3 }),
        ('\u{323f}', Slice { offset: 1188, length: 3 }),
        ('\u{3240}', Slice { offset: 1191, length: 3 }),
        ('\u{3241}', Slice { offset: 1194, length: 3 }),
        ('\u{3242}', Slice { offset: 1197, length: 3 }),
        ('\u{3243}', Slice { offset: 1200, length: 3 }),
        ('\u{3244}', Slice { offset: 1203, length: 1 }),
        ('\u{3245}', Slice { offset: 1204, length: 1 }),
        ('\u{3246}', Slice { offset: 717, length: 1 }),
        ('\u{3247}', Slice { offset: 1205, length: 1 }),
        ('\u{3250}', Slice { offset: 1206, length: 3 }),
        ('\u{3251}', Slice { offset: 1209, length: 2 }),
        ('\u{3252}', Slice { offset: 1211, length: 2 }),
        ('\u{3253}', Slice { offset: 1213, length: 2 }),
        ('\u{3254}', Slice { offset: 1215, length: 2 }),
        ('\u{3255}', Slice { offset: 1217, length: 2 }),
        ('\u{3256}', Slice { offset: 1219, length: 2 }),
        ('\u{3257}', Slice { offset: 1221, length: 2 }),
        ('\u{3258}', Slice { offset: 1223, length: 2 }),
        ('\u{3259}', Slice { offset: 1225, length: 2 }),
        ('\u{325a}', Slice { offset: 1227, length: 2 }),
        ('\u{325b}', Slice { offset: 1229, length: 2 }),
        ('\u{325c}', Slice { offset: 1231, length: 2 }),
        ('\u{325d}', Slice { offset: 1233, length: 2 }),
        ('\u{325e}', Slice { offset: 1235, length: 2 }),
        ('\u{325f}', Slice { offset: 1237, length: 2 }),
        ('\u{3260}', Slice { offset: 876, length: 1 }),
        ('\u{3261}', Slice { offset: 879, length: 1 }),
        ('\u{3262}', Slice { offset: 882, length: 1 }),
        ('\u{3263}', Slice { offset: 884, length: 1 }),
        ('\u{3264}', Slice { offset: 892, length: 1 }),
        ('\u{3265}', Slice { offset: 893, length: 1 }),
        ('\u{3266}', Slice { offset: 896, length: 1 }),
        ('\u{3267}', Slice { offset: 898, length: 1 }),
        ('\u{3268}', Slice { offset: 899, length: 1 }),
        ('\u{3269}', Slice { offset: 901, length: 1 }),
        ('\u{326a}', Slice { offset: 902, length: 1 }),
        ('\u{326b}', Slice { offset: 903, length: 1 }),
        ('\u{326c}', Slice { offset: 904, length: 1 }),
        ('\u{326d}', Slice { offset: 905, length: 1 }),
        ('\u{326e}', Slice { offset: 1239, length: 2 }),
        ('\u{326f}', Slice { offset: 1241, length: 2 }),
        ('\u{3270}', Slice { offset: 1243, length: 2 }),
        ('\u{3271}', Slice { offset: 1245, length: 2 }),
        ('\u{3272}', Slice { offset: 1247, length: 2 }),
        ('\u{3273}', Slice { offset: 1249, length: 2 }),
        ('\u{3274}', Slice { offset: 1251, length: 2 }),
        ('\u{3275}', Slice { offset: 1253, length: 2 }),
        ('\u{3276}', Slice { offset: 1255, length: 2 }),
        ('\u{3277}', Slice { offset: 1257, length: 2 }),
        ('\u{3278}', Slice { offset: 1259, length: 2 }),
        ('\u{3279}', Slice { offset: 1261, length: 2 }),
        ('\u{327a}', Slice { offset: 1263, length: 2 }),
        ('\u{327b}', Slice { offset: 1265, length: 2 }),
        ('\u{327c}', Slice { offset: 1267, length: 5 }),
        ('\u{327d}', Slice { offset: 1272, length: 4 }),
        ('\u{327e}', Slice { offset: 1276, length: 2 }),
        ('\u{3280}', Slice { offset: 651, length: 1 }),
        ('\u{3281}', Slice { offset: 657, length: 1 }),
        ('\u{3282}', Slice { offset: 970, length: 1 }),
        ('\u{3283}', Slice { offset: 971, length: 1 }),
        ('\u{3284}', Slice { offset: 1278, length: 1 }),
        ('\u{3285}', Slice { offset: 1279, length: 1 }),
        ('\u{3286}', Slice { offset: 1280, length: 1 }),
        ('\u{3287}', Slice { offset: 662, length: 1 }),
        ('\u{3288}', Slice { offset: 1281, length: 1 }),
        ('\u{3289}', Slice { offset: 674, length: 1 }),
        ('\u{328a}', Slice { offset: 724, length: 1 }),
        ('\u{328b}', Slice { offset: 736, length: 1 }),
        ('\u{328c}', Slice { offset: 735, length: 1 }),
        ('\u{328d}', Slice { offset: 725, length: 1 }),
        ('\u{328e}', Slice { offset: 817, length: 1 }),
        ('\u{328f}', Slice { offset: 682, length: 1 }),
        ('\u{3290}', Slice { offset: 722, length: 1 }),
        ('\u{3291}', Slice { offset: 1282, length: 1 }),
        ('\u{3292}', Slice { offset: 1283, length: 1 }),
        ('\u{3293}', Slice { offset: 1284, length: 1 }),
        ('\u{3294}', Slice { offset: 1285, length: 1 }),
        ('\u{3295}', Slice { offset: 1286, length: 1 }),
        ('\u{3296}', Slice { offset: 1287, length: 1 }),
        ('\u{3297}', Slice { offset: 1288, length: 1 }),
        ('\u{3298}', Slice { offset: 1289, length: 1 }),
        ('\u{3299}', Slice { offset: 1290, length: 1 }),
        ('\u{329a}', Slice { offset: 1291, length: 1 }),
        ('\u{329b}', Slice { offset: 688, length: 1 }),
        ('\u{329c}', Slice { offset: 1292, length: 1 }),
        ('\u{329d}', Slice { offset: 1293, length: 1 }),
        ('\u{329e}', Slice { offset: 1294, length: 1 }),
        ('\u{329f}', Slice { offset: 1295, length: 1 }),
        ('\u{32a0}', Slice { offset: 1296, length: 1 }),
        ('\u{32a1}', Slice { offset: 1297, length: 1 }),
        ('\u{32a2}', Slice { offset: 1298, length: 1 }),
        ('\u{32a3}', Slice { offset: 1299, length: 1 }),
        ('\u{32a4}', Slice { offset: 972, length: 1 }),
        ('\u{32a5}', Slice { offset: 973, length: 1 }),
        ('\u{32a6}', Slice { offset: 974, length: 1 }),
        ('\u{32a7}', Slice { offset: 1300, length: 1 }),
        ('\u{32a8}', Slice { offset: 1301, length: 1 }),
        ('\u{32a9}', Slice { offset: 1302, length: 1 }),
        ('\u{32aa}', Slice { offset: 1303, length: 1 }),
        ('\u{32ab}', Slice { offset: 1304, length: 1 }),
        ('\u{32ac}', Slice { offset: 1305, length: 1 }),
        ('\u{32ad}', Slice { offset: 1306, length: 1 }),
        ('\u{32ae}', Slice { offset: 1307, length: 1 }),
        ('\u{32af}', Slice { offset: 1308, length: 1 }),
        ('\u{32b0}', Slice { offset: 1309, length: 1 }),
        ('\u{32b1}', Slice { offset: 1310, length: 2 }),
        ('\u{32b2}', Slice { offset: 1312, length: 2 }),
        ('\u{32b3}', Slice { offset: 1314, length: 2 }),
        ('\u{32b4}', Slice { offset: 1316, length: 2 }),
        ('\u{32b5}', Slice { offset: 1318, length: 2 }),
        ('\u{32b6}', Slice { offset: 1320, length: 2 }),
        ('\u{32b7}', Slice { offset: 1322, length: 2 }),
        ('\u{32b8}', Slice { offset: 1324, length: 2 }),
        ('\u{32b9}', Slice { offset: 1326, length: 2 }),
        ('\u{32ba}', Slice { offset: 1328, length: 2 }),
        ('\u{32bb}', Slice { offset: 1330, length: 2 }),
        ('\u{32bc}', Slice { offset: 1332, length: 2 }),
        ('\u{32bd}', Slice { offset: 1334, length: 2 }),
        ('\u{32be}', Slice { offset: 1336, length: 2 }),
        ('\u{32bf}', Slice { offset: 1338, length: 2 }),
        ('\u{32c0}', Slice { offset: 1340, length: 2 }),
        ('\u{32c1}', Slice { offset: 1342, length: 2 }),
        ('\u{32c2}', Slice { offset: 1344, length: 2 }),
        ('\u{32c3}', Slice { offset: 1346, length: 2 }),
        ('\u{32c4}', Slice { offset: 1348, length: 2 }),
        ('\u{32c5}', Slice { offset: 1350, length: 2 }),
        ('\u{32c6}', Slice { offset: 1352, length: 2 }),
        ('\u{32c7}', Slice { offset: 1354, length: 2 }),
        ('\u{32c8}', Slice { offset: 1356, length: 2 }),
        ('\u{32c9}', Slice { offset: 1358, length: 3 }),
        ('\u{32ca}', Slice { offset: 1361, length: 3 }),
        ('\u{32cb}', Slice { offset: 1364, length: 3 }),
        ('\u{32cc}', Slice { offset: 1367, length: 2 }),
        ('\u{32cd}', Slice { offset: 1369, length: 3 }),
        ('\u{32ce}', Slice { offset: 1372, length: 2 }),
        ('\u{32cf}', Slice { offset: 1374, length: 3 }),
        ('\u{32d0}', Slice { offset: 1377, length: 1 }),
        ('\u{32d1}', Slice { offset: 1378, length: 1 }),
        ('\u{32d2}', Slice { offset: 1379, length: 1 }),
        ('\u{32d3}', Slice { offset: 1380, length: 1 }),
        ('\u{32d4}', Slice { offset: 1381, length: 1 }),
        ('\u{32d5}', Slice { offset: 1382, length: 1 }),
        ('\u{32d6}', Slice { offset: 1383, length: 1 }),
        ('\u{32d7}', Slice { offset: 1384, length: 1 }),
        ('\u{32d8}', Slice { offset: 1385, length: 1 }),
        ('\u{32d9}', Slice { offset: 1386, length: 1 }),
        ('\u{32da}', Slice { offset: 1387, length: 1 }),
        ('\u{32db}', Slice { offset: 1388, length: 1 }),
        ('\u{32dc}', Slice { offset: 1389, length: 1 }),
        ('\u{32dd}', Slice { offset: 1390, length: 1 }),
        ('\u{32de}', Slice { offset: 1391, length: 1 }),
        ('\u{32df}', Slice { offset: 1392, length: 1 }),
        ('\u{32e0}', Slice { offset: 1393, length: 1 }),
        ('\u{32e1}', Slice { offset: 1394, length: 1 }),
        ('\u{32e2}', Slice { offset: 1395, length: 1 }),
        ('\u{32e3}', Slice { offset: 1396, length: 1 }),
        ('\u{32e4}', Slice { offset: 1397, length: 1 }),
        ('\u{32e5}', Slice { offset: 1398, length: 1 }),
        ('\u{32e6}', Slice { offset: 1399, length: 1 }),
        ('\u{32e7}', Slice { offset: 1400, length: 1 }),
        ('\u{32e8}', Slice { offset: 1401, length: 1 }),
        ('\u{32e9}', Slice { offset: 1402, length: 1 }),
        ('\u{32ea}', Slice { offset: 1403, length: 1 }),
        ('\u{32eb}', Slice { offset: 1404, length: 1 }),
        ('\u{32ec}', Slice { offset: 1405, length: 1 }),
        ('\u{32ed}', Slice { offset: 1406, length: 1 }),
        ('\u{32ee}', Slice { offset: 1407, length: 1 }),
        ('\u{32ef}', Slice { offset: 1408, length: 1 }),
        ('\u{32f0}', Slice { offset: 1409, length: 1 }),
        ('\u{32f1}', Slice { offset: 1410, length: 1 }),
        ('\u{32f2}', Slice { offset: 1411, length: 1 }),
        ('\u{32f3}', Slice { offset: 1412, length: 1 }),
        ('\u{32f4}', Slice { offset: 1413, length: 1 }),
        ('\u{32f5}', Slice { offset: 1414, length: 1 }),
        ('\u{32f6}', Slice { offset: 1415, length: 1 }),
        ('\u{32f7}', Slice { offset: 1416, length: 1 }),
        ('\u{32f8}', Slice { offset: 1417, length: 1 }),
        ('\u{32f9}', Slice { offset: 1418, length: 1 }),
        ('\u{32fa}', Slice { offset: 1419, length: 1 }),
        ('\u{32fb}', Slice { offset: 1420, length: 1 }),
        ('\u{32fc}', Slice { offset: 1421, length: 1 }),
        ('\u{32fd}', Slice { offset: 1422, length: 1 }),
        ('\u{32fe}', Slice { offset: 1423, length: 1 }),
        ('\u{3300}', Slice { offset: 1424, length: 4 }),
        ('\u{3301}', Slice { offset: 1428, length: 4 }),
        ('\u{3302}', Slice { offset: 1432, length: 4 }),
        ('\u{3303}', Slice { offset: 1436, length: 3 }),
        ('\u{3304}', Slice { offset: 1439, length: 4 }),
        ('\u{3305}', Slice { offset: 1443, length: 3 }),
        ('\u{3306}', Slice { offset: 1446, length: 3 }),
        ('\u{3307}', Slice { offset: 1449, length: 5 }),
        ('\u{3308}', Slice { offset: 1454, length: 4 }),
        ('\u{3309}', Slice { offset: 1458, length: 3 }),
        ('\u{330a}', Slice { offset: 1461, length: 3 }),
        ('\u{330b}', Slice { offset: 1464, length: 3 }),
        ('\u{330c}', Slice { offset: 1467, length: 4 }),
        ('\u{330d}', Slice { offset: 1471, length: 4 }),
        ('\u{330e}', Slice { offset: 1475, length: 3 }),
        ('\u{330f}', Slice { offset: 1478, length: 3 }),
        ('\u{3310}', Slice { offset: 1481, length: 2 }),
        ('\u{3311}', Slice { offset: 1483, length: 3 }),
        ('\u{3312}', Slice { offset: 1486, length: 4 }),
        ('\u{3313}', Slice { offset: 1490, length: 4 }),
        ('\u{3314}', Slice { offset: 1494, length: 2 }),
        ('\u{3315}', Slice { offset: 1496, length: 5 }),
        ('\u{3316}', Slice { offset: 1501, length: 6 }),
        ('\u{3317}', Slice { offset: 1507, length: 5 }),
        ('\u{3318}', Slice { offset: 1512, length: 3 }),
        ('\u{3319}', Slice { offset: 1515, length: 5 }),
        ('\u{331a}', Slice { offset: 1520, length: 5 }),
        ('\u{331b}', Slice { offset: 1525, length: 4 }),
        ('\u{331c}', Slice { offset: 1529, length: 3 }),
        ('\u{331d}', Slice { offset: 1532, length: 3 }),
        ('\u{331e}', Slice { offset: 1535, length: 3 }),
        ('\u{331f}', Slice { offset: 1538, length: 4 }),
        ('\u{3320}', Slice { offset: 1542, length: 5 }),
        ('\u{3321}', Slice { offset: 1547, length: 4 }),
        ('\u{3322}', Slice { offset: 1551, length: 3 }),
        ('\u{3323}', Slice { offset: 1554, length: 3 }),
        ('\u{3324}', Slice { offset: 1557, length: 3 }),
        ('\u{3325}', Slice { offset: 1560, length: 2 }),
        ('\u{3326}', Slice { offset: 1562, length: 2 }),
        ('\u{3327}', Slice { offset: 1564, length: 2 }),
        ('\u{3328}', Slice { offset: 1566, length: 2 }),
        ('\u{3329}', Slice { offset: 1568, length: 3 }),
        ('\u{332a}', Slice { offset: 1571, length: 3 }),
        ('\u{332b}', Slice { offset: 1574, length: 5 }),
        ('\u{332c}', Slice { offset: 1579, length: 3 }),
        ('\u{332d}', Slice { offset: 1582, length: 4 }),
        ('\u{332e}', Slice { offset: 1586, length: 5 }),
        ('\u{332f}', Slice { offset: 1591, length: 3 }),
        ('\u{3330}', Slice { offset: 1594, length: 2 }),
        ('\u{3331}', Slice { offset: 1596, length: 2 }),
        ('\u{3332}', Slice { offset: 1598, length: 5 }),
        ('\u{3333}', Slice { offset: 1603, length: 4 }),
        ('\u{3334}', Slice { offset: 1607, length: 5 }),
        ('\u{3335}', Slice { offset: 1612, length: 3 }),
        ('\u{3336}', Slice { offset: 1615, length: 5 }),
        ('\u{3337}', Slice { offset: 1620, length: 2 }),
        ('\u{3338}', Slice { offset: 1622, length: 3 }),
        ('\u{3339}', Slice { offset: 1625, length: 3 }),
        ('\u{333a}', Slice { offset: 1628, length: 3 }),
        ('\u{333b}', Slice { offset: 1631, length: 3 }),
        ('\u{333c}', Slice { offset: 1634, length: 3 }),
        ('\u{333d}', Slice { offset: 1637, length: 4 }),
        ('\u{333e}', Slice { offset: 1641, length: 3 }),
        ('\u{333f}', Slice { offset: 1644, length: 2 }),
        ('\u{3340}', Slice { offset: 1646, length: 3 }),
        ('\u{3341}', Slice { offset: 1649, length: 3 }),
        ('\u{3342}', Slice { offset: 1652, length: 3 }),
        ('\u{3343}', Slice { offset: 1655, length: 4 }),
        ('\u{3344}', Slice { offset: 1659, length: 3 }),
        ('\u{3345}', Slice { offset: 1662, length: 3 }),
        ('\u{3346}', Slice { offset: 1665, length: 3 }),
        ('\u{3347}', Slice { offset: 1668, length: 5 }),
        ('\u{3348}', Slice { offset: 1673, length: 4 }),
        ('\u{3349}', Slice { offset: 1677, length: 2 }),
        ('\u{334a}', Slice { offset: 1679, length: 5 }),
        ('\u{334b}', Slice { offset: 1684, length: 2 }),
        ('\u{334c}', Slice { offset: 1686, length: 4 }),
        ('\u{334d}', Slice { offset: 1690, length: 4 }),
        ('\u{334e}', Slice { offset: 1694, length: 3 }),
        ('\u{334f}', Slice { offset: 1697, length: 3 }),
        ('\u{3350}', Slice { offset: 1700, length: 3 }),
        ('\u{3351}', Slice { offset: 1703, length: 4 }),
        ('\u{3352}', Slice { offset: 1707, length: 2 }),
        ('\u{3353}', Slice { offset: 1709, length: 3 }),
        ('\u{3354}', Slice { offset: 1712, length: 4 }),
        ('\u{3355}', Slice { offset: 1716, length: 2 }),
        ('\u{3356}', Slice { offset: 1718, length: 5 }),
        ('\u{3357}', Slice { offset: 1723, length: 3 }),
        ('\u{3358}', Slice { offset: 1726, length: 2 }),
        ('\u{3359}', Slice { offset: 1728, length: 2 }),
        ('\u{335a}', Slice { offset: 1730, length: 2 }),
        ('\u{335b}', Slice { offset: 1732, length: 2 }),
        ('\u{335c}', Slice { offset: 1734, length: 2 }),
        ('\u{335d}', Slice { offset: 1736, length: 2 }),
        ('\u{335e}', Slice { offset: 1738, length: 2 }),
        ('\u{335f}', Slice { offset: 1740, length: 2 }),
        ('\u{3360}', Slice { offset: 1742, length: 2 }),
        ('\u{3361}', Slice { offset: 1744, length: 2 }),
        ('\u{3362}', Slice { offset: 1746, length: 3 }),
        ('\u{3363}', Slice { offset: 1749, length: 3 }),
        ('\u{3364}', Slice { offset: 1752, length: 3 }),
        ('\u{3365}', Slice { offset: 1755, length: 3 }),
        ('\u{3366}', Slice { offset: 1758, length: 3 }),
        ('\u{3367}', Slice { offset: 1761, length: 3 }),
        ('\u{3368}', Slice { offset: 1764, length: 3 }),
        ('\u{3369}', Slice { offset: 1767, length: 3 }),
        ('\u{336a}', Slice { offset: 1770, length: 3 }),
        ('\u{336b}', Slice { offset: 1773, length: 3 }),
        ('\u{336c}', Slice { offset: 1776, length: 3 }),
        ('\u{336d}', Slice { offset: 1779, length: 3 }),
        ('\u{336e}', Slice { offset: 1782, length: 3 }),
        ('\u{336f}', Slice { offset: 1785, length: 3 }),
        ('\u{3370}', Slice { offset: 1788, length: 3 }),
        ('\u{3371}', Slice { offset: 1791, length: 3 }),
        ('\u{3372}', Slice { offset: 1794, length: 2 }),
        ('\u{3373}', Slice { offset: 1796, length: 2 }),
        ('\u{3374}', Slice { offset: 1798, length: 3 }),
        ('\u{3375}', Slice { offset: 1801, length: 2 }),
        ('\u{3376}', Slice { offset: 1803, length: 2 }),
        ('\u{3377}', Slice { offset: 1805, length: 2 }),
        ('\u{3378}', Slice { offset: 1807, length: 3 }),
        ('\u{3379}', Slice { offset: 1810, length: 3 }),
        ('\u{337a}', Slice { offset: 1813, length: 2 }),
        ('\u{337b}', Slice { offset: 1815, length: 2 }),
        ('\u{337c}', Slice { offset: 1817, length: 2 }),
        ('\u{337d}', Slice { offset: 1819, length: 2 }),
        ('\u{337e}', Slice { offset: 1821, length: 2 }),
        ('\u{337f}', Slice { offset: 1823, length: 4 }),
        ('\u{3380}', Slice { offset: 1827, length: 2 }),
        ('\u{3381}', Slice { offset: 1829, length: 2 }),
        ('\u{3382}', Slice { offset: 1831, length: 2 }),
        ('\u{3383}', Slice { offset: 1833, length: 2 }),
        ('\u{3384}', Slice { offset: 1835, length: 2 }),
        ('\u{3385}', Slice { offset: 1837, length: 2 }),
        ('\u{3386}', Slice { offset: 1839, length: 2 }),
        ('\u{3387}', Slice { offset: 1841, length: 2 }),
        ('\u{3388}', Slice { offset: 1843, length: 3 }),
        ('\u{3389}', Slice { offset: 1846, length: 4 }),
        ('\u{338a}', Slice { offset: 1850, length: 2 }),
        ('\u{338b}', Slice { offset: 1852, length: 2 }),
        ('\u{338c}', Slice { offset: 1854, length: 2 }),
        ('\u{338d}', Slice { offset: 1856, length: 2 }),
        ('\u{338e}', Slice { offset: 1858, length: 2 }),
        ('\u{338f}', Slice { offset: 1860, length: 2 }),
        ('\u{3390}', Slice { offset: 1862, length: 2 }),
        ('\u{3391}', Slice { offset: 1864, length: 3 }),
        ('\u{3392}', Slice { offset: 1867, length: 3 }),
        ('\u{3393}', Slice { offset: 1870, length: 3 }),
        ('\u{3394}', Slice { offset: 1873, length: 3 }),
        ('\u{3395}', Slice { offset: 1876, length: 2 }),
        ('\u{3396}', Slice { offset: 1878, length: 2 }),
        ('\u{3397}', Slice { offset: 1880, length: 2 }),
        ('\u{3398}', Slice { offset: 1882, length: 2 }),
        ('\u{3399}', Slice { offset: 1884, length: 2 }),
        ('\u{339a}', Slice { offset: 1886, length: 2 }),
        ('\u{339b}', Slice { offset: 1888, length: 2 }),
        ('\u{339c}', Slice { offset: 1890, length: 2 }),
        ('\u{339d}', Slice { offset: 1892, length: 2 }),
        ('\u{339e}', Slice { offset: 1894, length: 2 }),
        ('\u{339f}', Slice { offset: 1896, length: 3 }),
        ('\u{33a0}', Slice { offset: 1899, length: 3 }),
        ('\u{33a1}', Slice { offset: 1902, length: 2 }),
        ('\u{33a2}', Slice { offset: 1904, length: 3 }),
        ('\u{33a3}', Slice { offset: 1907, length: 3 }),
        ('\u{33a4}', Slice { offset: 1910, length: 3 }),
        ('\u{33a5}', Slice { offset: 1913, length: 2 }),
        ('\u{33a6}', Slice { offset: 1915, length: 3 }),
        ('\u{33a7}', Slice { offset: 1918, length: 3 }),
        ('\u{33a8}', Slice { offset: 1921, length: 4 }),
        ('\u{33a9}', Slice { offset: 1925, length: 2 }),
        ('\u{33aa}', Slice { offset: 1927, length: 3 }),
        ('\u{33ab}', Slice { offset: 1930, length: 3 }),
        ('\u{33ac}', Slice { offset: 1933, length: 3 }),
        ('\u{33ad}', Slice { offset: 1936, length: 3 }),
        ('\u{33ae}', Slice { offset: 1939, length: 5 }),
        ('\u{33af}', Slice { offset: 1944, length: 6 }),
        ('\u{33b0}', Slice { offset: 1950, length: 2 }),
        ('\u{33b1}', Slice { offset: 1952, length: 2 }),
        ('\u{33b2}', Slice { offset: 1954, length: 2 }),
        ('\u{33b3}', Slice { offset: 1956, length: 2 }),
        ('\u{33b4}', Slice { offset: 1958, length: 2 }),
        ('\u{33b5}', Slice { offset: 1960, length: 2 }),
        ('\u{33b6}', Slice { offset: 1962, length: 2 }),
        ('\u{33b7}', Slice { offset: 1964, length: 2 }),
        ('\u{33b8}', Slice { offset: 1966, length: 2 }),
        ('\u{33b9}', Slice { offset: 1968, length: 2 }),
        ('\u{33ba}', Slice { offset: 1970, length: 2 }),
        ('\u{33bb}', Slice { offset: 1972, length: 2 }),
        ('\u{33bc}', Slice { offset: 1974, length: 2 }),
        ('\u{33bd}', Slice { offset: 1976, length: 2 }),
        ('\u{33be}', Slice { offset: 1978, length: 2 }),
        ('\u{33bf}', Slice { offset: 1980, length: 2 }),
        ('\u{33c0}', Slice { offset: 1982, length: 2 }),
        ('\u{33c1}', Slice { offset: 1984, length: 2 }),
        ('\u{33c2}', Slice { offset: 1986, length: 4 }),
        ('\u{33c3}', Slice { offset: 1990, length: 2 }),
        ('\u{33c4}', Slice { offset: 1992, length: 2 }),
        ('\u{33c5}', Slice { offset: 1994, length: 2 }),
        ('\u{33c6}', Slice { offset: 1996, length: 4 }),
        ('\u{33c7}', Slice { offset: 2000, length: 3 }),
        ('\u{33c8}', Slice { offset: 2003, length: 2 }),
        ('\u{33c9}', Slice { offset: 2005, length: 2 }),
        ('\u{33ca}', Slice { offset: 2007, length: 2 }),
        ('\u{33cb}', Slice { offset: 2009, length: 2 }),
        ('\u{33cc}', Slice { offset: 2011, length: 2 }),
        ('\u{33cd}', Slice { offset: 2013, length: 2 }),
        ('\u{33ce}', Slice { offset: 2015, length: 2 }),
        ('\u{33cf}', Slice { offset: 2017, length: 2 }),
        ('\u{33d0}', Slice { offset: 2019, length: 2 }),
        ('\u{33d1}', Slice { offset: 2021, length: 2 }),
        ('\u{33d2}', Slice { offset: 2023, length: 3 }),
        ('\u{33d3}', Slice { offset: 2026, length: 2 }),
        ('\u{33d4}', Slice { offset: 2028, length: 2 }),
        ('\u{33d5}', Slice { offset: 2030, length: 3 }),
        ('\u{33d6}', Slice { offset: 2033, length: 3 }),
        ('\u{33d7}', Slice { offset: 2036, length: 2 }),
        ('\u{33d8}', Slice { offset: 2038, length: 4 }),
        ('\u{33d9}', Slice { offset: 2042, length: 3 }),
        ('\u{33da}', Slice { offset: 2045, length: 2 }),
        ('\u{33db}', Slice { offset: 2047, length: 2 }),
        ('\u{33dc}', Slice { offset: 2049, length: 2 }),
        ('\u{33dd}', Slice { offset: 2051, length: 2 }),
        ('\u{33de}', Slice { offset: 2053, length: 3 }),
        ('\u{33df}', Slice { offset: 2056, length: 3 }),
        ('\u{33e0}', Slice { offset: 2059, length: 2 }),
        ('\u{33e1}', Slice { offset: 2061, length: 2 }),
        ('\u{33e2}', Slice { offset: 2063, length: 2 }),
        ('\u{33e3}', Slice { offset: 2065, length: 2 }),
        ('\u{33e4}', Slice { offset: 2067, length: 2 }),
        ('\u{33e5}', Slice { offset: 2069, length: 2 }),
        ('\u{33e6}', Slice { offset: 2071, length: 2 }),
        ('\u{33e7}', Slice { offset: 2073, length: 2 }),
        ('\u{33e8}', Slice { offset: 2075, length: 2 }),
        ('\u{33e9}', Slice { offset: 2077, length: 3 }),
        ('\u{33ea}', Slice { offset: 2080, length: 3 }),
        ('\u{33eb}', Slice { offset: 2083, length: 3 }),
        ('\u{33ec}', Slice { offset: 2086, length: 3 }),
        ('\u{33ed}', Slice { offset: 2089, length: 3 }),
        ('\u{33ee}', Slice { offset: 2092, length: 3 }),
        ('\u{33ef}', Slice { offset: 2095, length: 3 }),
        ('\u{33f0}', Slice { offset: 2098, length: 3 }),
        ('\u{33f1}', Slice { offset: 2101, length: 3 }),
        ('\u{33f2}', Slice { offset: 2104, length: 3 }),
        ('\u{33f3}', Slice { offset: 2107, length: 3 }),
        ('\u{33f4}', Slice { offset: 2110, length: 3 }),
        ('\u{33f5}', Slice { offset: 2113, length: 3 }),
        ('\u{33f6}', Slice { offset: 2116, length: 3 }),
        ('\u{33f7}', Slice { offset: 2119, length: 3 }),
        ('\u{33f8}', Slice { offset: 2122, length: 3 }),
        ('\u{33f9}', Slice { offset: 2125, length: 3 }),
        ('\u{33fa}', Slice { offset: 2128, length: 3 }),
        ('\u{33fb}', Slice { offset: 2131, length: 3 }),
        ('\u{33fc}', Slice { offset: 2134, length: 3 }),
        ('\u{33fd}', Slice { offset: 2137, length: 3 }),
        ('\u{33fe}', Slice { offset: 2140, length: 3 }),
        ('\u{33ff}', Slice { offset: 2143, length: 3 }),
        ('\u{a69c}', Slice { offset: 2146, length: 1 }),
        ('\u{a69d}', Slice { offset: 2147, length: 1 }),
        ('\u{a770}', Slice { offset: 2148, length: 1 }),
        ('\u{a7f8}', Slice { offset: 2149, length: 1 }),
        ('\u{a7f9}', Slice { offset: 2150, length: 1 }),
        ('\u{ab5c}', Slice { offset: 2151, length: 1 }),
        ('\u{ab5d}', Slice { offset: 2152, length: 1 }),
        ('\u{ab5e}', Slice { offset: 2153, length: 1 }),
        ('\u{ab5f}', Slice { offset: 2154, length: 1 }),
        ('\u{fb00}', Slice { offset: 2155, length: 2 }),
        ('\u{fb01}', Slice { offset: 2157, length: 2 }),
        ('\u{fb02}', Slice { offset: 2159, length: 2 }),
        ('\u{fb03}', Slice { offset: 2161, length: 3 }),
        ('\u{fb04}', Slice { offset: 2164, length: 3 }),
        ('\u{fb05}', Slice { offset: 2167, length: 2 }),
        ('\u{fb06}', Slice { offset: 2169, length: 2 }),
        ('\u{fb13}', Slice { offset: 2171, length: 2 }),
        ('\u{fb14}', Slice { offset: 2173, length: 2 }),
        ('\u{fb15}', Slice { offset: 2175, length: 2 }),
        ('\u{fb16}', Slice { offset: 2177, length: 2 }),
        ('\u{fb17}', Slice { offset: 2179, length: 2 }),
        ('\u{fb20}', Slice { offset: 2181, length: 1 }),
        ('\u{fb21}', Slice { offset: 292, length: 1 }),
        ('\u{fb22}', Slice { offset: 295, length: 1 }),
        ('\u{fb23}', Slice { offset: 2182, length: 1 }),
        ('\u{fb24}', Slice { offset: 2183, length: 1 }),
        ('\u{fb25}', Slice { offset: 2184, length: 1 }),
        ('\u{fb26}', Slice { offset: 2185, length: 1 }),
        ('\u{fb27}', Slice { offset: 2186, length: 1 }),
        ('\u{fb28}', Slice { offset: 2187, length: 1 }),
        ('\u{fb29}', Slice { offset: 253, length: 1 }),
        ('\u{fb4f}', Slice { offset: 2188, length: 2 }),
        ('\u{fb50}', Slice { offset: 2190, length: 1 }),
        ('\u{fb51}', Slice { offset: 2190, length: 1 }),
        ('\u{fb52}', Slice { offset: 2191, length: 1 }),
        ('\u{fb53}', Slice { offset: 2191, length: 1 }),
        ('\u{fb54}', Slice { offset: 2191, length: 1 }),
        ('\u{fb55}', Slice { offset: 2191, length: 1 }),
        ('\u{fb56}', Slice { offset: 2192, length: 1 }),
        ('\u{fb57}', Slice { offset: 2192, length: 1 }),
        ('\u{fb58}', Slice { offset: 2192, length: 1 }),
        ('\u{fb59}', Slice { offset: 2192, length: 1 }),
        ('\u{fb5a}', Slice { offset: 2193, length: 1 }),
        ('\u{fb5b}', Slice { offset: 2193, length: 1 }),
        ('\u{fb5c}', Slice { offset: 2193, length: 1 }),
        ('\u{fb5d}', Slice { offset: 2193, length: 1 }),
        ('\u{fb5e}', Slice { offset: 2194, length: 1 }),
        ('\u{fb5f}', Slice { offset: 2194, length: 1 }),
        ('\u{fb60}', Slice { offset: 2194, length: 1 }),
        ('\u{fb61}', Slice { offset: 2194, length: 1 }),
        ('\u{fb62}', Slice { offset: 2195, length: 1 }),
        ('\u{fb63}', Slice { offset: 2195, length: 1 }),
        ('\u{fb64}', Slice { offset: 2195, length: 1 }),
        ('\u{fb65}', Slice { offset: 2195, length: 1 }),
        ('\u{fb66}', Slice { offset: 2196, length: 1 }),
        ('\u{fb67}', Slice { offset: 2196, length: 1 }),
        ('\u{fb68}', Slice { offset: 2196, length: 1 }),
        ('\u{fb69}', Slice { offset: 2196, length: 1 }),
        ('\u{fb6a}', Slice { offset: 2197, length: 1 }),
        ('\u{fb6b}', Slice { offset: 2197, length: 1 }),
        ('\u{fb6c}', Slice { offset: 2197, length: 1 }),
        ('\u{fb6d}', Slice { offset: 2197, length: 1 }),
        ('\u{fb6e}', Slice { offset: 2198, length: 1 }),
        ('\u{fb6f}', Slice { offset: 2198, length: 1 }),
        ('\u{fb70}', Slice { offset: 2198, length: 1 }),
        ('\u{fb71}', Slice { offset: 2198, length: 1 }),
        ('\u{fb72}', Slice { offset: 2199, length: 1 }),
        ('\u{fb73}', Slice { offset: 2199, length: 1 }),
        ('\u{fb74}', Slice { offset: 2199, length: 1 }),
        ('\u{fb75}', Slice { offset: 2199, length: 1 }),
        ('\u{fb76}', Slice { offset: 2200, length: 1 }),
        ('\u{fb77}', Slice { offset: 2200, length: 1 }),
        ('\u{fb78}', Slice { offset: 2200, length: 1 }),
        ('\u{fb79}', Slice { offset: 2200, length: 1 }),
        ('\u{fb7a}', Slice { offset: 2201, length: 1 }),
        ('\u{fb7b}', Slice { offset: 2201, length: 1 }),
        ('\u{fb7c}', Slice { offset: 2201, length: 1 }),
        ('\u{fb7d}', Slice { offset: 2201, length: 1 }),
        ('\u{fb7e}', Slice { offset: 2202, length: 1 }),
        ('\u{fb7f}', Slice { offset: 2202, length: 1 }),
        ('\u{fb80}', Slice { offset: 2202, length: 1 }),
        ('\u{fb81}', Slice { offset: 2202, length: 1 }),
        ('\u{fb82}', Slice { offset: 2203, length: 1 }),
        ('\u{fb83}', Slice { offset: 2203, length: 1 }),
        ('\u{fb84}', Slice { offset: 2204, length: 1 }),
        ('\u{fb85}', Slice { offset: 2204, length: 1 }),
        ('\u{fb86}', Slice { offset: 2205, length: 1 }),
        ('\u{fb87}', Slice { offset: 2205, length: 1 }),
        ('\u{fb88}', Slice { offset: 2206, length: 1 }),
        ('\u{fb89}', Slice { offset: 2206, length: 1 }),
        ('\u{fb8a}', Slice { offset: 2207, length: 1 }),
        ('\u{fb8b}', Slice { offset: 2207, length: 1 }),
        ('\u{fb8c}', Slice { offset: 2208, length: 1 }),
        ('\u{fb8d}', Slice { offset: 2208, length: 1 }),
        ('\u{fb8e}', Slice { offset: 2209, length: 1 }),
        ('\u{fb8f}', Slice { offset: 2209, length: 1 }),
        ('\u{fb90}', Slice { offset: 2209, length: 1 }),
        ('\u{fb91}', Slice { offset: 2209, length: 1 }),
        ('\u{fb92}', Slice { offset: 2210, length: 1 }),
        ('\u{fb93}', Slice { offset: 2210, length: 1 }),
        ('\u{fb94}', Slice { offset: 2210, length: 1 }),
        ('\u{fb95}', Slice { offset: 2210, length: 1 }),
        ('\u{fb96}', Slice { offset: 2211, length: 1 }),
        ('\u{fb97}', Slice { offset: 2211, length: 1 }),
        ('\u{fb98}', Slice { offset: 2211, length: 1 }),
        ('\u{fb99}', Slice { offset: 2211, length: 1 }),
        ('\u{fb9a}', Slice { offset: 2212, length: 1 }),
        ('\u{fb9b}', Slice { offset: 2212, length: 1 }),
        ('\u{fb9c}', Slice { offset: 2212, length: 1 }),
        ('\u{fb9d}', Slice { offset: 2212, length: 1 }),
        ('\u{fb9e}', Slice { offset: 2213, length: 1 }),
        ('\u{fb9f}', Slice { offset: 2213, length: 1 }),
        ('\u{fba0}', Slice { offset: 2214, length: 1 }),
        ('\u{fba1}', Slice { offset: 2214, length: 1 }),
        ('\u{fba2}', Slice { offset: 2214, length: 1 }),
        ('\u{fba3}', Slice { offset: 2214, length: 1 }),
        ('\u{fba4}', Slice { offset: 2215, length: 1 }),
        ('\u{fba5}', Slice { offset: 2215, length: 1 }),
        ('\u{fba6}', Slice { offset: 2216, length: 1 }),
        ('\u{fba7}', Slice { offset: 2216, length: 1 }),
        ('\u{fba8}', Slice { offset: 2216, length: 1 }),
        ('\u{fba9}', Slice { offset: 2216, length: 1 }),
        ('\u{fbaa}', Slice { offset: 2217, length: 1 }),
        ('\u{fbab}', Slice { offset: 2217, length: 1 }),
        ('\u{fbac}', Slice { offset: 2217, length: 1 }),
        ('\u{fbad}', Slice { offset: 2217, length: 1 }),
        ('\u{fbae}', Slice { offset: 2218, length: 1 }),
        ('\u{fbaf}', Slice { offset: 2218, length: 1 }),
        ('\u{fbb0}', Slice { offset: 2219, length: 1 }),
        ('\u{fbb1}', Slice { offset: 2219, length: 1 }),
        ('\u{fbd3}', Slice { offset: 2220, length: 1 }),
        ('\u{fbd4}', Slice { offset: 2220, length: 1 }),
        ('\u{fbd5}', Slice { offset: 2220, length: 1 }),
        ('\u{fbd6}', Slice { offset: 2220, length: 1 }),
        ('\u{fbd7}', Slice { offset: 2221, length: 1 }),
        ('\u{fbd8}', Slice { offset: 2221, length: 1 }),
        ('\u{fbd9}', Slice { offset: 2222, length: 1 }),
        ('\u{fbda}', Slice { offset: 2222, length: 1 }),
        ('\u{fbdb}', Slice { offset: 2223, length: 1 }),
        ('\u{fbdc}', Slice { offset: 2223, length: 1 }),
        ('\u{fbdd}', Slice { offset: 2224, length: 1 }),
        ('\u{fbde}', Slice { offset: 2225, length: 1 }),
        ('\u{fbdf}', Slice { offset: 2225, length: 1 }),
        ('\u{fbe0}', Slice { offset: 2226, length: 1 }),
        ('\u{fbe1}', Slice { offset: 2226, length: 1 }),
        ('\u{fbe2}', Slice { offset: 2227, length: 1 }),
        ('\u{fbe3}', Slice { offset: 2227, length: 1 }),
        ('\u{fbe4}', Slice { offset: 2228, length: 1 }),
        ('\u{fbe5}', Slice { offset: 2228, length: 1 }),
        ('\u{fbe6}', Slice { offset: 2228, length: 1 }),
        ('\u{fbe7}', Slice { offset: 2228, length: 1 }),
        ('\u{fbe8}', Slice { offset: 2229, length: 1 }),
        ('\u{fbe9}', Slice { offset: 2229, length: 1 }),
        ('\u{fbea}', Slice { offset: 2230, length: 2 }),
        ('\u{fbeb}', Slice { offset: 2230, length: 2 }),
        ('\u{fbec}', Slice { offset: 2232, length: 2 }),
        ('\u{fbed}', Slice { offset: 2232, length: 2 }),
        ('\u{fbee}', Slice { offset: 2234, length: 2 }),
        ('\u{fbef}', Slice { offset: 2234, length: 2 }),
        ('\u{fbf0}', Slice { offset: 2236, length: 2 }),
        ('\u{fbf1}', Slice { offset: 2236, length: 2 }),
        ('\u{fbf2}', Slice { offset: 2238, length: 2 }),
        ('\u{fbf3}', Slice { offset: 2238, length: 2 }),
        ('\u{fbf4}', Slice { offset: 2240, length: 2 }),
        ('\u{fbf5}', Slice { offset: 2240, length: 2 }),
        ('\u{fbf6}', Slice { offset: 2242, length: 2 }),
        ('\u{fbf7}', Slice { offset: 2242, length: 2 }),
        ('\u{fbf8}', Slice { offset: 2242, length: 2 }),
        ('\u{fbf9}', Slice { offset: 2244, length: 2 }),
        ('\u{fbfa}', Slice { offset: 2244, length: 2 }),
        ('\u{fbfb}', Slice { offset: 2244, length: 2 }),
        ('\u{fbfc}', Slice { offset: 2246, length: 1 }),
        ('\u{fbfd}', Slice { offset: 2246, length: 1 }),
        ('\u{fbfe}', Slice { offset: 2246, length: 1 }),
        ('\u{fbff}', Slice { offset: 2246, length: 1 }),
        ('\u{fc00}', Slice { offset: 2247, length: 2 }),
        ('\u{fc01}', Slice { offset: 2249, length: 2 }),
        ('\u{fc02}', Slice { offset: 2251, length: 2 }),
        ('\u{fc03}', Slice { offset: 2244, length: 2 }),
        ('\u{fc04}', Slice { offset: 2253, length: 2 }),
        ('\u{fc05}', Slice { offset: 2255, length: 2 }),
        ('\u{fc06}', Slice { offset: 2257, length: 2 }),
        ('\u{fc07}', Slice { offset: 2259, length: 2 }),
        ('\u{fc08}', Slice { offset: 2261, length: 2 }),
        ('\u{fc09}', Slice { offset: 2263, length: 2 }),
        ('\u{fc0a}', Slice { offset: 2265, length: 2 }),
        ('\u{fc0b}', Slice { offset: 2267, length: 2 }),
        ('\u{fc0c}', Slice { offset: 2269, length: 2 }),
        ('\u{fc0d}', Slice { offset: 2271, length: 2 }),
        ('\u{fc0e}', Slice { offset: 2273, length: 2 }),
        ('\u{fc0f}', Slice { offset: 2275, length: 2 }),
        ('\u{fc10}', Slice { offset: 2277, length: 2 }),
        ('\u{fc11}', Slice { offset: 2279, length: 2 }),
        ('\u{fc12}', Slice { offset: 2281, length: 2 }),
        ('\u{fc13}', Slice { offset: 2283, length: 2 }),
        ('\u{fc14}', Slice { offset: 2285, length: 2 }),
        ('\u{fc15}', Slice { offset: 2287, length: 2 }),
        ('\u{fc16}', Slice { offset: 2289, length: 2 }),
        ('\u{fc17}', Slice { offset: 2291, length: 2 }),
        ('\u{fc18}', Slice { offset: 2293, length: 2 }),
        ('\u{fc19}', Slice { offset: 2295, length: 2 }),
        ('\u{fc1a}', Slice { offset: 2297, length: 2 }),
        ('\u{fc1b}', Slice { offset: 2299, length: 2 }),
        ('\u{fc1c}', Slice { offset: 2301, length: 2 }),
        ('\u{fc1d}', Slice { offset: 2303, length: 2 }),
        ('\u{fc1e}', Slice { offset: 2305, length: 2 }),
        ('\u{fc1f}', Slice { offset: 2307, length: 2 }),
        ('\u{fc20}', Slice { offset: 2309, length: 2 }),
        ('\u{fc21}', Slice { offset: 2311, length: 2 }),
        ('\u{fc22}', Slice { offset: 2313, length: 2 }),
        ('\u{fc23}', Slice { offset: 2315, length: 2 }),
        ('\u{fc24}', Slice { offset: 2317, length: 2 }),
        ('\u{fc25}', Slice { offset: 2319, length: 2 }),
        ('\u{fc26}', Slice { offset: 2321, length: 2 }),
        ('\u{fc27}', Slice { offset: 2323, length: 2 }),
        ('\u{fc28}', Slice { offset: 2325, length: 2 }),
        ('\u{fc29}', Slice { offset: 2327, length: 2 }),
        ('\u{fc2a}', Slice { offset: 2329, length: 2 }),
        ('\u{fc2b}', Slice { offset: 2331, length: 2 }),
        ('\u{fc2c}', Slice { offset: 2333, length: 2 }),
        ('\u{fc2d}', Slice { offset: 2335, length: 2 }),
        ('\u{fc2e}', Slice { offset: 2337, length: 2 }),
        ('\u{fc2f}', Slice { offset: 2339, length: 2 }),
        ('\u{fc30}', Slice { offset: 2341, length: 2 }),
        ('\u{fc31}', Slice { offset: 2343, length: 2 }),
        ('\u{fc32}', Slice { offset: 2345, length: 2 }),
        ('\u{fc33}', Slice { offset: 2347, length: 2 }),
        ('\u{fc34}', Slice { offset: 2349, length: 2 }),
        ('\u{fc35}', Slice { offset: 2351, length: 2 }),
        ('\u{fc36}', Slice { offset: 2353, length: 2 }),
        ('\u{fc37}', Slice { offset: 2355, length: 2 }),
        ('\u{fc38}', Slice { offset: 2357, length: 2 }),
        ('\u{fc39}', Slice { offset: 2359, length: 2 }),
        ('\u{fc3a}', Slice { offset: 2361, length: 2 }),
        ('\u{fc3b}', Slice { offset: 2363, length: 2 }),
        ('\u{fc3c}', Slice { offset: 2365, length: 2 }),
        ('\u{fc3d}', Slice { offset: 2367, length: 2 }),
        ('\u{fc3e}', Slice { offset: 2369, length: 2 }),
        ('\u{fc3f}', Slice { offset: 2371, length: 2 }),
        ('\u{fc40}', Slice { offset: 2373, length: 2 }),
        ('\u{fc41}', Slice { offset: 2375, length: 2 }),
        ('\u{fc42}', Slice { offset: 2377, length: 2 }),
        ('\u{fc43}', Slice { offset: 2379, length: 2 }),
        ('\u{fc44}', Slice { offset: 2381, length: 2 }),
        ('\u{fc45}', Slice { offset: 2383, length: 2 }),
        ('\u{fc46}', Slice { offset: 2385, length: 2 }),
        ('\u{fc47}', Slice { offset: 2387, length: 2 }),
        ('\u{fc48}', Slice { offset: 2389, length: 2 }),
        ('\u{fc49}', Slice { offset: 2391, length: 2 }),
        ('\u{fc4a}', Slice { offset: 2393, length: 2 }),
        ('\u{fc4b}', Slice { offset: 2395, length: 2 }),
        ('\u{fc4c}', Slice { offset: 2397, length: 2 }),
        ('\u{fc4d}', Slice { offset: 2399, length: 2 }),
        ('\u{fc4e}', Slice { offset: 2401, length: 2 }),
        ('\u{fc4f}', Slice { offset: 2403, length: 2 }),
        ('\u{fc50}', Slice { offset: 2405, length: 2 }),
        ('\u{fc51}', Slice { offset: 2407, length: 2 }),
        ('\u{fc52}', Slice { offset: 2409, length: 2 }),
        ('\u{fc53}', Slice { offset: 2411, length: 2 }),
        ('\u{fc54}', Slice { offset: 2413, length: 2 }),
        ('\u{fc55}', Slice { offset: 2415, length: 2 }),
        ('\u{fc56}', Slice { offset: 2417, length: 2 }),
        ('\u{fc57}', Slice { offset: 2419, length: 2 }),
        ('\u{fc58}', Slice { offset: 2421, length: 2 }),
        ('\u{fc59}', Slice { offset: 2423, length: 2 }),
        ('\u{fc5a}', Slice { offset: 2425, length: 2 }),
        ('\u{fc5b}', Slice { offset: 2427, length: 2 }),
        ('\u{fc5c}', Slice { offset: 2429, length: 2 }),
        ('\u{fc5d}', Slice { offset: 2431, length: 2 }),
        ('\u{fc5e}', Slice { offset: 2433, length: 3 }),
        ('\u{fc5f}', Slice { offset: 2436, length: 3 }),
        ('\u{fc60}', Slice { offset: 2439, length: 3 }),
        ('\u{fc61}', Slice { offset: 2442, length: 3 }),
        ('\u{fc62}', Slice { offset: 2445, length: 3 }),
        ('\u{fc63}', Slice { offset: 2448, length: 3 }),
        ('\u{fc64}', Slice { offset: 2451, length: 2 }),
        ('\u{fc65}', Slice { offset: 2453, length: 2 }),
        ('\u{fc66}', Slice { offset: 2251, length: 2 }),
        ('\u{fc67}', Slice { offset: 2455, length: 2 }),
        ('\u{fc68}', Slice { offset: 2244, length: 2 }),
        ('\u{fc69}', Slice { offset: 2253, length: 2 }),
        ('\u{fc6a}', Slice { offset: 2457, length: 2 }),
        ('\u{fc6b}', Slice { offset: 2459, length: 2 }),
        ('\u{fc6c}', Slice { offset: 2261, length: 2 }),
        ('\u{fc6d}', Slice { offset: 2461, length: 2 }),
        ('\u{fc6e}', Slice { offset: 2263, length: 2 }),
        ('\u{fc6f}', Slice { offset: 2265, length: 2 }),
        ('\u{fc70}', Slice { offset: 2463, length: 2 }),
        ('\u{fc71}', Slice { offset: 2465, length: 2 }),
        ('\u{fc72}', Slice { offset: 2273, length: 2 }),
        ('\u{fc73}', Slice { offset: 2467, length: 2 }),
        ('\u{fc74}', Slice { offset: 2275, length: 2 }),
        ('\u{fc75}', Slice { offset: 2277, length: 2 }),
        ('\u{fc76}', Slice { offset: 2469, length: 2 }),
        ('\u{fc77}', Slice { offset: 2471, length: 2 }),
        ('\u{fc78}', Slice { offset: 2281, length: 2 }),
        ('\u{fc79}', Slice { offset: 2473, length: 2 }),
        ('\u{fc7a}', Slice { offset: 2283, length: 2 }),
        ('\u{fc7b}', Slice { offset: 2285, length: 2 }),
        ('\u{fc7c}', Slice { offset: 2343, length: 2 }),
        ('\u{fc7d}', Slice { offset: 2345, length: 2 }),
        ('\u{fc7e}', Slice { offset: 2351, length: 2 }),
        ('\u{fc7f}', Slice { offset: 2353, length: 2 }),
        ('\u{fc80}', Slice { offset: 2355, length: 2 }),
        ('\u{fc81}', Slice { offset: 2363, length: 2 }),
        ('\u{fc82}', Slice { offset: 2365, length: 2 }),
        ('\u{fc83}', Slice { offset: 2367, length: 2 }),
        ('\u{fc84}', Slice { offset: 2369, length: 2 }),
        ('\u{fc85}', Slice { offset: 2377, length: 2 }),
        ('\u{fc86}', Slice { offset: 2379, length: 2 }),
        ('\u{fc87}', Slice { offset: 2381, length: 2 }),
        ('\u{fc88}', Slice { offset: 2475, length: 2 }),
        ('\u{fc89}', Slice { offset: 2389, length: 2 }),
        ('\u{fc8a}', Slice { offset: 2477, length: 2 }),
        ('\u{fc8b}', Slice { offset: 2479, length: 2 }),
        ('\u{fc8c}', Slice { offset: 2401, length: 2 }),
        ('\u{fc8d}', Slice { offset: 2481, length: 2 }),
        ('\u{fc8e}', Slice { offset: 2403, length: 2 }),
        ('\u{fc8f}', Slice { offset: 2405, length: 2 }),
        ('\u{fc90}', Slice { offset: 2431, length: 2 }),
        ('\u{fc91}', Slice { offset: 2483, length: 2 }),
        ('\u{fc92}', Slice { offset: 2485, length: 2 }),
        ('\u{fc93}', Slice { offset: 2421, length: 2 }),
        ('\u{fc94}', Slice { offset: 2487, length: 2 }),
        ('\u{fc95}', Slice { offset: 2423, length: 2 }),
        ('\u{fc96}', Slice { offset: 2425, length: 2 }),
        ('\u{fc97}', Slice { offset: 2247, length: 2 }),
        ('\u{fc98}', Slice { offset: 2249, length: 2 }),
        ('\u{fc99}', Slice { offset: 2489, length: 2 }),
        ('\u{fc9a}', Slice { offset: 2251, length: 2 }),
        ('\u{fc9b}', Slice { offset: 2491, length: 2 }),
        ('\u{fc9c}', Slice { offset: 2255, length: 2 }),
        ('\u{fc9d}', Slice { offset: 2257, length: 2 }),
        ('\u{fc9e}', Slice { offset: 2259, length: 2 }),
        ('\u{fc9f}', Slice { offset: 2261, length: 2 }),
        ('\u{fca0}', Slice { offset: 2493, length: 2 }),
        ('\u{fca1}', Slice { offset: 2267, length: 2 }),
        ('\u{fca2}', Slice { offset: 2269, length: 2 }),
        ('\u{fca3}', Slice { offset: 2271, length: 2 }),
        ('\u{fca4}', Slice { offset: 2273, length: 2 }),
        ('\u{fca5}', Slice { offset: 2495, length: 2 }),
        ('\u{fca6}', Slice { offset: 2281, length: 2 }),
        ('\u{fca7}', Slice { offset: 2287, length: 2 }),
        ('\u{fca8}', Slice { offset: 2289, length: 2 }),
        ('\u{fca9}', Slice { offset: 2291, length: 2 }),
        ('\u{fcaa}', Slice { offset: 2293, length: 2 }),
        ('\u{fcab}', Slice { offset: 2295, length: 2 }),
        ('\u{fcac}', Slice { offset: 2299, length: 2 }),
        ('\u{fcad}', Slice { offset: 2301, length: 2 }),
        ('\u{fcae}', Slice { offset: 2303, length: 2 }),
        ('\u{fcaf}', Slice { offset: 2305, length: 2 }),
        ('\u{fcb0}', Slice { offset: 2307, length: 2 }),
        ('\u{fcb1}', Slice { offset: 2309, length: 2 }),
        ('\u{fcb2}', Slice { offset: 2497, length: 2 }),
        ('\u{fcb3}', Slice { offset: 2311, length: 2 }),
        ('\u{fcb4}', Slice { offset: 2313, length: 2 }),
        ('\u{fcb5}', Slice { offset: 2315, length: 2 }),
        ('\u{fcb6}', Slice { offset: 2317, length: 2 }),
        ('\u{fcb7}', Slice { offset: 2319, length: 2 }),
        ('\u{fcb8}', Slice { offset: 2321, length: 2 }),
        ('\u{fcb9}', Slice { offset: 2325, length: 2 }),
        ('\u{fcba}', Slice { offset: 2327, length: 2 }),
        ('\u{fcbb}', Slice { offset: 2329, length: 2 }),
        ('\u{fcbc}', Slice { offset: 2331, length: 2 }),
        ('\u{fcbd}', Slice { offset: 2333, length: 2 }),
        ('\u{fcbe}', Slice { offset: 2335, length: 2 }),
        ('\u{fcbf}', Slice { offset: 2337, length: 2 }),
        ('\u{fcc0}', Slice { offset: 2339, length: 2 }),
        ('\u{fcc1}', Slice { offset: 2341, length: 2 }),
        ('\u{fcc2}', Slice { offset: 2347, length: 2 }),
        ('\u{fcc3}', Slice { offset: 2349, length: 2 }),
        ('\u{fcc4}', Slice { offset: 2357, length: 2 }),
        ('\u{fcc5}', Slice { offset: 2359, length: 2 }),
        ('\u{fcc6}', Slice { offset: 2361, length: 2 }),
        ('\u{fcc7}', Slice { offset: 2363, length: 2 }),
        ('\u{fcc8}', Slice { offset: 2365, length: 2 }),
        ('\u{fcc9}', Slice { offset: 2371, length: 2 }),
        ('\u{fcca}', Slice { offset: 2373, length: 2 }),
        ('\u{fccb}', Slice { offset: 2375, length: 2 }),
        ('\u{fccc}', Slice { offset: 2377, length: 2 }),
        ('\u{fccd}', Slice { offset: 2499, length: 2 }),
        ('\u{fcce}', Slice { offset: 2383, length: 2 }),
        ('\u{fccf}', Slice { offset: 2385, length: 2 }),
        ('\u{fcd0}', Slice { offset: 2387, length: 2 }),
        ('\u{fcd1}', Slice { offset: 2389, length: 2 }),
        ('\u{fcd2}', Slice { offset: 2395, length: 2 }),
        ('\u{fcd3}', Slice { offset: 2397, length: 2 }),
        ('\u{fcd4}', Slice { offset: 2399, length: 2 }),
        ('\u{fcd5}', Slice { offset: 2401, length: 2 }),
        ('\u{fcd6}', Slice { offset: 2501, length: 2 }),
        ('\u{fcd7}', Slice { offset: 2407, length: 2 }),
        ('\u{fcd8}', Slice { offset: 2409, length: 2 }),
        ('\u{fcd9}', Slice { offset: 2503, length: 2 }),
        ('\u{fcda}', Slice { offset: 2415, length: 2 }),
        ('\u{fcdb}', Slice { offset: 2417, length: 2 }),
        ('\u{fcdc}', Slice { offset: 2419, length: 2 }),
        ('\u{fcdd}', Slice { offset: 2421, length: 2 }),
        ('\u{fcde}', Slice { offset: 2505, length: 2 }),
        ('\u{fcdf}', Slice { offset: 2251, length: 2 }),
        ('\u{fce0}', Slice { offset: 2491, length: 2 }),
        ('\u{fce1}', Slice { offset: 2261, length: 2 }),
        ('\u{fce2}', Slice { offset: 2493, length: 2 }),
        ('\u{fce3}', Slice { offset: 2273, length: 2 }),
        ('\u{fce4}', Slice { offset: 2495, length: 2 }),
        ('\u{fce5}', Slice { offset: 2281, length: 2 }),
        ('\u{fce6}', Slice { offset: 2507, length: 2 }),
        ('\u{fce7}', Slice { offset: 2307, length: 2 }),
        ('\u{fce8}', Slice { offset: 2509, length: 2 }),
        ('\u{fce9}', Slice { offset: 2511, length: 2 }),
        ('\u{fcea}', Slice { offset: 2513, length: 2 }),
        ('\u{fceb}', Slice { offset: 2363, length: 2 }),
        ('\u{fcec}', Slice { offset: 2365, length: 2 }),
        ('\u{fced}', Slice { offset: 2377, length: 2 }),
        ('\u{fcee}', Slice { offset: 2401, length: 2 }),
        ('\u{fcef}', Slice { offset: 2501, length: 2 }),
        ('\u{fcf0}', Slice { offset: 2421, length: 2 }),
        ('\u{fcf1}', Slice { offset: 2505, length: 2 }),
        ('\u{fcf2}', Slice { offset: 2515, length: 3 }),
        ('\u{fcf3}', Slice { offset: 2518, length: 3 }),
        ('\u{fcf4}', Slice { offset: 2521, length: 3 }),
        ('\u{fcf5}', Slice { offset: 2524, length: 2 }),
        ('\u{fcf6}', Slice { offset: 2526, length: 2 }),
        ('\u{fcf7}', Slice { offset: 2528, length: 2 }),
        ('\u{fcf8}', Slice { offset: 2530, length: 2 }),
        ('\u{fcf9}', Slice { offset: 2532, length: 2 }),
        ('\u{fcfa}', Slice { offset: 2534, length: 2 }),
        ('\u{fcfb}', Slice { offset: 2536, length: 2 }),
        ('\u{fcfc}', Slice { offset: 2538, length: 2 }),
        ('\u{fcfd}', Slice { offset: 2540, length: 2 }),
        ('\u{fcfe}', Slice { offset: 2542, length: 2 }),
        ('\u{fcff}', Slice { offset: 2544, length: 2 }),
        ('\u{fd00}', Slice { offset: 2546, length: 2 }),
        ('\u{fd01}', Slice { offset: 2548, length: 2 }),
        ('\u{fd02}', Slice { offset: 2550, length: 2 }),
        ('\u{fd03}', Slice { offset: 2552, length: 2 }),
        ('\u{fd04}', Slice { offset: 2554, length: 2 }),
        ('\u{fd05}', Slice { offset: 2556, length: 2 }),
        ('\u{fd06}', Slice { offset: 2558, length: 2 }),
        ('\u{fd07}', Slice { offset: 2560, length: 2 }),
        ('\u{fd08}', Slice { offset: 2562, length: 2 }),
        ('\u{fd09}', Slice { offset: 2564, length: 2 }),
        ('\u{fd0a}', Slice { offset: 2566, length: 2 }),
        ('\u{fd0b}', Slice { offset: 2568, length: 2 }),
        ('\u{fd0c}', Slice { offset: 2511, length: 2 }),
        ('\u{fd0d}', Slice { offset: 2570, length: 2 }),
        ('\u{fd0e}', Slice { offset: 2572, length: 2 }),
        ('\u{fd0f}', Slice { offset: 2574, length: 2 }),
        ('\u{fd10}', Slice { offset: 2576, length: 2 }),
        ('\u{fd11}', Slice { offset: 2524, length: 2 }),
        ('\u{fd12}', Slice { offset: 2526, length: 2 }),
        ('\u{fd13}', Slice { offset: 2528, length: 2 }),
        ('\u{fd14}', Slice { offset: 2530, length: 2 }),
        ('\u{fd15}', Slice { offset: 2532, length: 2 }),
        ('\u{fd16}', Slice { offset: 2534, length: 2 }),
        ('\u{fd17}', Slice { offset: 2536, length: 2 }),
        ('\u{fd18}', Slice { offset: 2538, length: 2 }),
        ('\u{fd19}', Slice { offset: 2540, length: 2 }),
        ('\u{fd1a}', Slice { offset: 2542, length: 2 }),
        ('\u{fd1b}', Slice { offset: 2544, length: 2 }),
        ('\u{fd1c}', Slice { offset: 2546, length: 2 }),
        ('\u{fd1d}', Slice { offset: 2548, length: 2 }),
        ('\u{fd1e}', Slice { offset: 2550, length: 2 }),
        ('\u{fd1f}', Slice { offset: 2552, length: 2 }),
        ('\u{fd20}', Slice { offset: 2554, length: 2 }),
        ('\u{fd21}', Slice { offset: 2556, length: 2 }),
        ('\u{fd22}', Slice { offset: 2558, length: 2 }),
        ('\u{fd23}', Slice { offset: 2560, length: 2 }),
        ('\u{fd24}', Slice { offset: 2562, length: 2 }),
        ('\u{fd25}', Slice { offset: 2564, length: 2 }),
        ('\u{fd26}', Slice { offset: 2566, length: 2 }),
        ('\u{fd27}', Slice { offset: 2568, length: 2 }),
        ('\u{fd28}', Slice { offset: 2511, length: 2 }),
        ('\u{fd29}', Slice { offset: 2570, length: 2 }),
        ('\u{fd2a}', Slice { offset: 2572, length: 2 }),
        ('\u{fd2b}', Slice { offset: 2574, length: 2 }),
        ('\u{fd2c}', Slice { offset: 2576, length: 2 }),
        ('\u{fd2d}', Slice { offset: 2564, length: 2 }),
        ('\u{fd2e}', Slice { offset: 2566, length: 2 }),
        ('\u{fd2f}', Slice { offset: 2568, length: 2 }),
        ('\u{fd30}', Slice { offset: 2511, length: 2 }),
        ('\u{fd31}', Slice { offset: 2509, length: 2 }),
        ('\u{fd32}', Slice { offset: 2513, length: 2 }),
        ('\u{fd33}', Slice { offset: 2323, length: 2 }),
        ('\u{fd34}', Slice { offset: 2301, length: 2 }),
        ('\u{fd35}', Slice { offset: 2303, length: 2 }),
        ('\u{fd36}', Slice { offset: 2305, length: 2 }),
        ('\u{fd37}', Slice { offset: 2564, length: 2 }),
        ('\u{fd38}', Slice { offset: 2566, length: 2 }),
        ('\u{fd39}', Slice { offset: 2568, length: 2 }),
        ('\u{fd3a}', Slice { offset: 2323, length: 2 }),
        ('\u{fd3b}', Slice { offset: 2325, length: 2 }),
        ('\u{fd3c}', Slice { offset: 2578, length: 2 }),
        ('\u{fd3d}', Slice { offset: 2578, length: 2 }),
        ('\u{fd50}', Slice { offset: 2580, length: 3 }),
        ('\u{fd51}', Slice { offset: 2583, length: 3 }),
        ('\u{fd52}', Slice { offset: 2583, length: 3 }),
        ('\u{fd53}', Slice { offset: 2586, length: 3 }),
        ('\u{fd54}', Slice { offset: 2589, length: 3 }),
        ('\u{fd55}', Slice { offset: 2592, length: 3 }),
        ('\u{fd56}', Slice { offset: 2595, length: 3 }),
        ('\u{fd57}', Slice { offset: 2598, length: 3 }),
        ('\u{fd58}', Slice { offset: 2601, length: 3 }),
        ('\u{fd59}', Slice { offset: 2601, length: 3 }),
        ('\u{fd5a}', Slice { offset: 2604, length: 3 }),
        ('\u{fd5b}', Slice { offset: 2607, length: 3 }),
        ('\u{fd5c}', Slice { offset: 2610, length: 3 }),
        ('\u{fd5d}', Slice { offset: 2613, length: 3 }),
        ('\u{fd5e}', Slice { offset: 2616, length: 3 }),
        ('\u{fd5f}', Slice { offset: 2619, length: 3 }),
        ('\u{fd60}', Slice { offset: 2619, length: 3 }),
        ('\u{fd61}', Slice { offset: 2622, length: 3 }),
        ('\u{fd62}', Slice { offset: 2625, length: 3 }),
        ('\u{fd63}', Slice { offset: 2625, length: 3 }),
        ('\u{fd64}', Slice { offset: 2628, length: 3 }),
        ('\u{fd65}', Slice { offset: 2628, length: 3 }),
        ('\u{fd66}', Slice { offset: 2631, length: 3 }),
        ('\u{fd67}', Slice { offset: 2634, length: 3 }),
        ('\u{fd68}', Slice { offset: 2634, length: 3 }),
        ('\u{fd69}', Slice { offset: 2637, length: 3 }),
        ('\u{fd6a}', Slice { offset: 2640, length: 3 }),
        ('\u{fd6b}', Slice { offset: 2640, length: 3 }),
        ('\u{fd6c}', Slice { offset: 2643, length: 3 }),
        ('\u{fd6d}', Slice { offset: 2643, length: 3 }),
        ('\u{fd6e}', Slice { offset: 2646, length: 3 }),
        ('\u{fd6f}', Slice { offset: 2649, length: 3 }),
        ('\u{fd70}', Slice { offset: 2649, length: 3 }),
        ('\u{fd71}', Slice { offset: 2652, length: 3 }),
        ('\u{fd72}', Slice { offset: 2652, length: 3 }),
        ('\u{fd73}', Slice { offset: 2655, length: 3 }),
        ('\u{fd74}', Slice { offset: 2658, length: 3 }),
        ('\u{fd75}', Slice { offset: 2661, length: 3 }),
        ('\u{fd76}', Slice { offset: 2664, length: 3 }),
        ('\u{fd77}', Slice { offset: 2664, length: 3 }),
        ('\u{fd78}', Slice { offset: 2667, length: 3 }),
        ('\u{fd79}', Slice { offset: 2670, length: 3 }),
        ('\u{fd7a}', Slice { offset: 2673, length: 3 }),
        ('\u{fd7b}', Slice { offset: 2676, length: 3 }),
        ('\u{fd7c}', Slice { offset: 2679, length: 3 }),
        ('\u{fd7d}', Slice { offset: 2679, length: 3 }),
        ('\u{fd7e}', Slice { offset: 2682, length: 3 }),
        ('\u{fd7f}', Slice { offset: 2685, length: 3 }),
        ('\u{fd80}', Slice { offset: 2688, length: 3 }),
        ('\u{fd81}', Slice { offset: 2691, length: 3 }),
        ('\u{fd82}', Slice { offset: 2694, length: 3 }),
        ('\u{fd83}', Slice { offset: 2697, length: 3 }),
        ('\u{fd84}', Slice { offset: 2697, length: 3 }),
        ('\u{fd85}', Slice { offset: 2700, length: 3 }),
        ('\u{fd86}', Slice { offset: 2700, length: 3 }),
        ('\u{fd87}', Slice { offset: 2703, length: 3 }),
        ('\u{fd88}', Slice { offset: 2703, length: 3 }),
        ('\u{fd89}', Slice { offset: 2706, length: 3 }),
        ('\u{fd8a}', Slice { offset: 2709, length: 3 }),
        ('\u{fd8b}', Slice { offset: 2712, length: 3 }),
        ('\u{fd8c}', Slice { offset: 2715, length: 3 }),
        ('\u{fd8d}', Slice { offset: 2718, length: 3 }),
        ('\u{fd8e}', Slice { offset: 2721, length: 3 }),
        ('\u{fd8f}', Slice { offset: 2724, length: 3 }),
        ('\u{fd92}', Slice { offset: 2727, length: 3 }),
        ('\u{fd93}', Slice { offset: 2730, length: 3 }),
        ('\u{fd94}', Slice { offset: 2733, length: 3 }),
        ('\u{fd95}', Slice { offset: 2736, length: 3 }),
        ('\u{fd96}', Slice { offset: 2739, length: 3 }),
        ('\u{fd97}', Slice { offset: 2742, length: 3 }),
        ('\u{fd98}', Slice { offset: 2742, length: 3 }),
        ('\u{fd99}', Slice { offset: 2745, length: 3 }),
        ('\u{fd9a}', Slice { offset: 2748, length: 3 }),
        ('\u{fd9b}', Slice { offset: 2751, length: 3 }),
        ('\u{fd9c}', Slice { offset: 2754, length: 3 }),
        ('\u{fd9d}', Slice { offset: 2754, length: 3 }),
        ('\u{fd9e}', Slice { offset: 2757, length: 3 }),
        ('\u{fd9f}', Slice { offset: 2760, length: 3 }),
        ('\u{fda0}', Slice { offset: 2763, length: 3 }),
        ('\u{fda1}', Slice { offset: 2766, length: 3 }),
        ('\u{fda2}', Slice { offset: 2769, length: 3 }),
        ('\u{fda3}', Slice { offset: 2772, length: 3 }),
        ('\u{fda4}', Slice { offset: 2775, length: 3 }),
        ('\u{fda5}', Slice { offset: 2778, length: 3 }),
        ('\u{fda6}', Slice { offset: 2781, length: 3 }),
        ('\u{fda7}', Slice { offset: 2784, length: 3 }),
        ('\u{fda8}', Slice { offset: 2787, length: 3 }),
        ('\u{fda9}', Slice { offset: 2790, length: 3 }),
        ('\u{fdaa}', Slice { offset: 2793, length: 3 }),
        ('\u{fdab}', Slice { offset: 2796, length: 3 }),
        ('\u{fdac}', Slice { offset: 2799, length: 3 }),
        ('\u{fdad}', Slice { offset: 2802, length: 3 }),
        ('\u{fdae}', Slice { offset: 2805, length: 3 }),
        ('\u{fdaf}', Slice { offset: 2808, length: 3 }),
        ('\u{fdb0}', Slice { offset: 2811, length: 3 }),
        ('\u{fdb1}', Slice { offset: 2814, length: 3 }),
        ('\u{fdb2}', Slice { offset: 2817, length: 3 }),
        ('\u{fdb3}', Slice { offset: 2820, length: 3 }),
        ('\u{fdb4}', Slice { offset: 2682, length: 3 }),
        ('\u{fdb5}', Slice { offset: 2688, length: 3 }),
        ('\u{fdb6}', Slice { offset: 2823, length: 3 }),
        ('\u{fdb7}', Slice { offset: 2826, length: 3 }),
        ('\u{fdb8}', Slice { offset: 2829, length: 3 }),
        ('\u{fdb9}', Slice { offset: 2832, length: 3 }),
        ('\u{fdba}', Slice { offset: 2835, length: 3 }),
        ('\u{fdbb}', Slice { offset: 2838, length: 3 }),
        ('\u{fdbc}', Slice { offset: 2835, length: 3 }),
        ('\u{fdbd}', Slice { offset: 2829, length: 3 }),
        ('\u{fdbe}', Slice { offset: 2841, length: 3 }),
        ('\u{fdbf}', Slice { offset: 2844, length: 3 }),
        ('\u{fdc0}', Slice { offset: 2847, length: 3 }),
        ('\u{fdc1}', Slice { offset: 2850, length: 3 }),
        ('\u{fdc2}', Slice { offset: 2853, length: 3 }),
        ('\u{fdc3}', Slice { offset: 2838, length: 3 }),
        ('\u{fdc4}', Slice { offset: 2661, length: 3 }),
        ('\u{fdc5}', Slice { offset: 2631, length: 3 }),
        ('\u{fdc6}', Slice { offset: 2856, length: 3 }),
        ('\u{fdc7}', Slice { offset: 2859, length: 3 }),
        ('\u{fdf0}', Slice { offset: 2862, length: 3 }),
        ('\u{fdf1}', Slice { offset: 2865, length: 3 }),
        ('\u{fdf2}', Slice { offset: 2868, length: 4 }),
        ('\u{fdf3}', Slice { offset: 2872, length: 4 }),
        ('\u{fdf4}', Slice { offset: 2876, length: 4 }),
        ('\u{fdf5}', Slice { offset: 2880, length: 4 }),
        ('\u{fdf6}', Slice { offset: 2884, length: 4 }),
        ('\u{fdf7}', Slice { offset: 2888, length: 4 }),
        ('\u{fdf8}', Slice { offset: 2892, length: 4 }),
        ('\u{fdf9}', Slice { offset: 2896, length: 3 }),
        ('\u{fdfa}', Slice { offset: 2899, length: 18 }),
        ('\u{fdfb}', Slice { offset: 2917, length: 8 }),
        ('\u{fdfc}', Slice { offset: 2925, length: 4 }),
        ('\u{fe10}', Slice { offset: 2929, length: 1 }),
        ('\u{fe11}', Slice { offset: 2930, length: 1 }),
        ('\u{fe12}', Slice { offset: 2931, length: 1 }),
        ('\u{fe13}', Slice { offset: 2932, length: 1 }),
        ('\u{fe14}', Slice { offset: 2933, length: 1 }),
        ('\u{fe15}', Slice { offset: 2934, length: 1 }),
        ('\u{fe16}', Slice { offset: 2935, length: 1 }),
        ('\u{fe17}', Slice { offset: 2936, length: 1 }),
        ('\u{fe18}', Slice { offset: 2937, length: 1 }),
        ('\u{fe19}', Slice { offset: 2938, length: 1 }),
        ('\u{fe30}', Slice { offset: 2939, length: 1 }),
        ('\u{fe31}', Slice { offset: 2940, length: 1 }),
        ('\u{fe32}', Slice { offset: 2941, length: 1 }),
        ('\u{fe33}', Slice { offset: 2942, length: 1 }),
        ('\u{fe34}', Slice { offset: 2942, length: 1 }),
        ('\u{fe35}', Slice { offset: 256, length: 1 }),
        ('\u{fe36}', Slice { offset: 257, length: 1 }),
        ('\u{fe37}', Slice { offset: 2943, length: 1 }),
        ('\u{fe38}', Slice { offset: 2944, length: 1 }),
        ('\u{fe39}', Slice { offset: 2945, length: 1 }),
        ('\u{fe3a}', Slice { offset: 2946, length: 1 }),
        ('\u{fe3b}', Slice { offset: 2947, length: 1 }),
        ('\u{fe3c}', Slice { offset: 2948, length: 1 }),
        ('\u{fe3d}', Slice { offset: 2949, length: 1 }),
        ('\u{fe3e}', Slice { offset: 2950, length: 1 }),
        ('\u{fe3f}', Slice { offset: 2951, length: 1 }),
        ('\u{fe40}', Slice { offset: 2952, length: 1 }),
        ('\u{fe41}', Slice { offset: 2953, length: 1 }),
        ('\u{fe42}', Slice { offset: 2954, length: 1 }),
        ('\u{fe43}', Slice { offset: 2955, length: 1 }),
        ('\u{fe44}', Slice { offset: 2956, length: 1 }),
        ('\u{fe47}', Slice { offset: 2957, length: 1 }),
        ('\u{fe48}', Slice { offset: 2958, length: 1 }),
        ('\u{fe49}', Slice { offset: 2959, length: 1 }),
        ('\u{fe4a}', Slice { offset: 2959, length: 1 }),
        ('\u{fe4b}', Slice { offset: 2959, length: 1 }),
        ('\u{fe4c}', Slice { offset: 2959, length: 1 }),
        ('\u{fe4d}', Slice { offset: 2942, length: 1 }),
        ('\u{fe4e}', Slice { offset: 2942, length: 1 }),
        ('\u{fe4f}', Slice { offset: 2942, length: 1 }),
        ('\u{fe50}', Slice { offset: 2929, length: 1 }),
        ('\u{fe51}', Slice { offset: 2930, length: 1 }),
        ('\u{fe52}', Slice { offset: 216, length: 1 }),
        ('\u{fe54}', Slice { offset: 2933, length: 1 }),
        ('\u{fe55}', Slice { offset: 2932, length: 1 }),
        ('\u{fe56}', Slice { offset: 2935, length: 1 }),
        ('\u{fe57}', Slice { offset: 2934, length: 1 }),
        ('\u{fe58}', Slice { offset: 2940, length: 1 }),
        ('\u{fe59}', Slice { offset: 256, length: 1 }),
        ('\u{fe5a}', Slice { offset: 257, length: 1 }),
        ('\u{fe5b}', Slice { offset: 2943, length: 1 }),
        ('\u{fe5c}', Slice { offset: 2944, length: 1 }),
        ('\u{fe5d}', Slice { offset: 2945, length: 1 }),
        ('\u{fe5e}', Slice { offset: 2946, length: 1 }),
        ('\u{fe5f}', Slice { offset: 2960, length: 1 }),
        ('\u{fe60}', Slice { offset: 2961, length: 1 }),
        ('\u{fe61}', Slice { offset: 2962, length: 1 }),
        ('\u{fe62}', Slice { offset: 253, length: 1 }),
        ('\u{fe63}', Slice { offset: 2963, length: 1 }),
        ('\u{fe64}', Slice { offset: 2964, length: 1 }),
        ('\u{fe65}', Slice { offset: 2965, length: 1 }),
        ('\u{fe66}', Slice { offset: 255, length: 1 }),
        ('\u{fe68}', Slice { offset: 2966, length: 1 }),
        ('\u{fe69}', Slice { offset: 2967, length: 1 }),
        ('\u{fe6a}', Slice { offset: 2968, length: 1 }),
        ('\u{fe6b}', Slice { offset: 2969, length: 1 }),
        ('\u{fe70}', Slice { offset: 2970, length: 2 }),
        ('\u{fe71}', Slice { offset: 2972, length: 2 }),
        ('\u{fe72}', Slice { offset: 2974, length: 2 }),
        ('\u{fe74}', Slice { offset: 2976, length: 2 }),
        ('\u{fe76}', Slice { offset: 2978, length: 2 }),
        ('\u{fe77}', Slice { offset: 2980, length: 2 }),
        ('\u{fe78}', Slice { offset: 2982, length: 2 }),
        ('\u{fe79}', Slice { offset: 2984, length: 2 }),
        ('\u{fe7a}', Slice { offset: 2986, length: 2 }),
        ('\u{fe7b}', Slice { offset: 2988, length: 2 }),
        ('\u{fe7c}', Slice { offset: 2990, length: 2 }),
        ('\u{fe7d}', Slice { offset: 2992, length: 2 }),
        ('\u{fe7e}', Slice { offset: 2994, length: 2 }),
        ('\u{fe7f}', Slice { offset: 2996, length: 2 }),
        ('\u{fe80}', Slice { offset: 2998, length: 1 }),
        ('\u{fe81}', Slice { offset: 2999, length: 1 }),
        ('\u{fe82}', Slice { offset: 2999, length: 1 }),
        ('\u{fe83}', Slice { offset: 3000, length: 1 }),
        ('\u{fe84}', Slice { offset: 3000, length: 1 }),
        ('\u{fe85}', Slice { offset: 3001, length: 1 }),
        ('\u{fe86}', Slice { offset: 3001, length: 1 }),
        ('\u{fe87}', Slice { offset: 3002, length: 1 }),
        ('\u{fe88}', Slice { offset: 3002, length: 1 }),
        ('\u{fe89}', Slice { offset: 3003, length: 1 }),
        ('\u{fe8a}', Slice { offset: 3003, length: 1 }),
        ('\u{fe8b}', Slice { offset: 3003, length: 1 }),
        ('\u{fe8c}', Slice { offset: 3003, length: 1 }),
        ('\u{fe8d}', Slice { offset: 3004, length: 1 }),
        ('\u{fe8e}', Slice { offset: 3004, length: 1 }),
        ('\u{fe8f}', Slice { offset: 3005, length: 1 }),
        ('\u{fe90}', Slice { offset: 3005, length: 1 }),
        ('\u{fe91}', Slice { offset: 3005, length: 1 }),
        ('\u{fe92}', Slice { offset: 3005, length: 1 }),
        ('\u{fe93}', Slice { offset: 3006, length: 1 }),
        ('\u{fe94}', Slice { offset: 3006, length: 1 }),
        ('\u{fe95}', Slice { offset: 3007, length: 1 }),
        ('\u{fe96}', Slice { offset: 3007, length: 1 }),
        ('\u{fe97}', Slice { offset: 3007, length: 1 }),
        ('\u{fe98}', Slice { offset: 3007, length: 1 }),
        ('\u{fe99}', Slice { offset: 3008, length: 1 }),
        ('\u{fe9a}', Slice { offset: 3008, length: 1 }),
        ('\u{fe9b}', Slice { offset: 3008, length: 1 }),
        ('\u{fe9c}', Slice { offset: 3008, length: 1 }),
        ('\u{fe9d}', Slice { offset: 3009, length: 1 }),
        ('\u{fe9e}', Slice { offset: 3009, length: 1 }),
        ('\u{fe9f}', Slice { offset: 3009, length: 1 }),
        ('\u{fea0}', Slice { offset: 3009, length: 1 }),
        ('\u{fea1}', Slice { offset: 3010, length: 1 }),
        ('\u{fea2}', Slice { offset: 3010, length: 1 }),
        ('\u{fea3}', Slice { offset: 3010, length: 1 }),
        ('\u{fea4}', Slice { offset: 3010, length: 1 }),
        ('\u{fea5}', Slice { offset: 3011, length: 1 }),
        ('\u{fea6}', Slice { offset: 3011, length: 1 }),
        ('\u{fea7}', Slice { offset: 3011, length: 1 }),
        ('\u{fea8}', Slice { offset: 3011, length: 1 }),
        ('\u{fea9}', Slice { offset: 3012, length: 1 }),
        ('\u{feaa}', Slice { offset: 3012, length: 1 }),
        ('\u{feab}', Slice { offset: 3013, length: 1 }),
        ('\u{feac}', Slice { offset: 3013, length: 1 }),
        ('\u{fead}', Slice { offset: 3014, length: 1 }),
        ('\u{feae}', Slice { offset: 3014, length: 1 }),
        ('\u{feaf}', Slice { offset: 3015, length: 1 }),
        ('\u{feb0}', Slice { offset: 3015, length: 1 }),
        ('\u{feb1}', Slice { offset: 3016, length: 1 }),
        ('\u{feb2}', Slice { offset: 3016, length: 1 }),
        ('\u{feb3}', Slice { offset: 3016, length: 1 }),
        ('\u{feb4}', Slice { offset: 3016, length: 1 }),
        ('\u{feb5}', Slice { offset: 3017, length: 1 }),
        ('\u{feb6}', Slice { offset: 3017, length: 1 }),
        ('\u{feb7}', Slice { offset: 3017, length: 1 }),
        ('\u{feb8}', Slice { offset: 3017, length: 1 }),
        ('\u{feb9}', Slice { offset: 3018, length: 1 }),
        ('\u{feba}', Slice { offset: 3018, length: 1 }),
        ('\u{febb}', Slice { offset: 3018, length: 1 }),
        ('\u{febc}', Slice { offset: 3018, length: 1 }),
        ('\u{febd}', Slice { offset: 3019, length: 1 }),
        ('\u{febe}', Slice { offset: 3019, length: 1 }),
        ('\u{febf}', Slice { offset: 3019, length: 1 }),
        ('\u{fec0}', Slice { offset: 3019, length: 1 }),
        ('\u{fec1}', Slice { offset: 3020, length: 1 }),
        ('\u{fec2}', Slice { offset: 3020, length: 1 }),
        ('\u{fec3}', Slice { offset: 3020, length: 1 }),
        ('\u{fec4}', Slice { offset: 3020, length: 1 }),
        ('\u{fec5}', Slice { offset: 3021, length: 1 }),
        ('\u{fec6}', Slice { offset: 3021, length: 1 }),
        ('\u{fec7}', Slice { offset: 3021, length: 1 }),
        ('\u{fec8}', Slice { offset: 3021, length: 1 }),
        ('\u{fec9}', Slice { offset: 3022, length: 1 }),
        ('\u{feca}', Slice { offset: 3022, length: 1 }),
        ('\u{fecb}', Slice { offset: 3022, length: 1 }),
        ('\u{fecc}', Slice { offset: 3022, length: 1 }),
        ('\u{fecd}', Slice { offset: 3023, length: 1 }),
        ('\u{fece}', Slice { offset: 3023, length: 1 }),
        ('\u{fecf}', Slice { offset: 3023, length: 1 }),
        ('\u{fed0}', Slice { offset: 3023, length: 1 }),
        ('\u{fed1}', Slice { offset: 3024, length: 1 }),
        ('\u{fed2}', Slice { offset: 3024, length: 1 }),
        ('\u{fed3}', Slice { offset: 3024, length: 1 }),
        ('\u{fed4}', Slice { offset: 3024, length: 1 }),
        ('\u{fed5}', Slice { offset: 3025, length: 1 }),
        ('\u{fed6}', Slice { offset: 3025, length: 1 }),
        ('\u{fed7}', Slice { offset: 3025, length: 1 }),
        ('\u{fed8}', Slice { offset: 3025, length: 1 }),
        ('\u{fed9}', Slice { offset: 3026, length: 1 }),
        ('\u{feda}', Slice { offset: 3026, length: 1 }),
        ('\u{fedb}', Slice { offset: 3026, length: 1 }),
        ('\u{fedc}', Slice { offset: 3026, length: 1 }),
        ('\u{fedd}', Slice { offset: 3027, length: 1 }),
        ('\u{fede}', Slice { offset: 3027, length: 1 }),
        ('\u{fedf}', Slice { offset: 3027, length: 1 }),
        ('\u{fee0}', Slice { offset: 3027, length: 1 }),
        ('\u{fee1}', Slice { offset: 3028, length: 1 }),
        ('\u{fee2}', Slice { offset: 3028, length: 1 }),
        ('\u{fee3}', Slice { offset: 3028, length: 1 }),
        ('\u{fee4}', Slice { offset: 3028, length: 1 }),
        ('\u{fee5}', Slice { offset: 3029, length: 1 }),
        ('\u{fee6}', Slice { offset: 3029, length: 1 }),
        ('\u{fee7}', Slice { offset: 3029, length: 1 }),
        ('\u{fee8}', Slice { offset: 3029, length: 1 }),
        ('\u{fee9}', Slice { offset: 3030, length: 1 }),
        ('\u{feea}', Slice { offset: 3030, length: 1 }),
        ('\u{feeb}', Slice { offset: 3030, length: 1 }),
        ('\u{feec}', Slice { offset: 3030, length: 1 }),
        ('\u{feed}', Slice { offset: 3031, length: 1 }),
        ('\u{feee}', Slice { offset: 3031, length: 1 }),
        ('\u{feef}', Slice { offset: 2229, length: 1 }),
        ('\u{fef0}', Slice { offset: 2229, length: 1 }),
        ('\u{fef1}', Slice { offset: 3032, length: 1 }),
        ('\u{fef2}', Slice { offset: 3032, length: 1 }),
        ('\u{fef3}', Slice { offset: 3032, length: 1 }),
        ('\u{fef4}', Slice { offset: 3032, length: 1 }),
        ('\u{fef5}', Slice { offset: 3033, length: 2 }),
        ('\u{fef6}', Slice { offset: 3033, length: 2 }),
        ('\u{fef7}', Slice { offset: 3035, length: 2 }),
        ('\u{fef8}', Slice { offset: 3035, length: 2 }),
        ('\u{fef9}', Slice { offset: 3037, length: 2 }),
        ('\u{fefa}', Slice { offset: 3037, length: 2 }),
        ('\u{fefb}', Slice { offset: 3039, length: 2 }),
        ('\u{fefc}', Slice { offset: 3039, length: 2 }),
        ('\u{ff01}', Slice { offset: 2934, length: 1 }),
        ('\u{ff02}', Slice { offset: 3041, length: 1 }),
        ('\u{ff03}', Slice { offset: 2960, length: 1 }),
        ('\u{ff04}', Slice { offset: 2967, length: 1 }),
        ('\u{ff05}', Slice { offset: 2968, length: 1 }),
        ('\u{ff06}', Slice { offset: 2961, length: 1 }),
        ('\u{ff07}', Slice { offset: 3042, length: 1 }),
        ('\u{ff08}', Slice { offset: 256, length: 1 }),
        ('\u{ff09}', Slice { offset: 257, length: 1 }),
        ('\u{ff0a}', Slice { offset: 2962, length: 1 }),
        ('\u{ff0b}', Slice { offset: 253, length: 1 }),
        ('\u{ff0c}', Slice { offset: 2929, length: 1 }),
        ('\u{ff0d}', Slice { offset: 2963, length: 1 }),
        ('\u{ff0e}', Slice { offset: 216, length: 1 }),
        ('\u{ff0f}', Slice { offset: 3043, length: 1 }),
        ('\u{ff10}', Slice { offset: 246, length: 1 }),
        ('\u{ff11}', Slice { offset: 13, length: 1 }),
        ('\u{ff12}', Slice { offset: 6, length: 1 }),
        ('\u{ff13}', Slice { offset: 7, length: 1 }),
        ('\u{ff14}', Slice { offset: 247, length: 1 }),
        ('\u{ff15}', Slice { offset: 248, length: 1 }),
        ('\u{ff16}', Slice { offset: 249, length: 1 }),
        ('\u{ff17}', Slice { offset: 250, length: 1 }),
        ('\u{ff18}', Slice { offset: 251, length: 1 }),
        ('\u{ff19}', Slice { offset: 252, length: 1 }),
        ('\u{ff1a}', Slice { offset: 2932, length: 1 }),
        ('\u{ff1b}', Slice { offset: 2933, length: 1 }),
        ('\u{ff1c}', Slice { offset: 2964, length: 1 }),
        ('\u{ff1d}', Slice { offset: 255, length: 1 }),
        ('\u{ff1e}', Slice { offset: 2965, length: 1 }),
        ('\u{ff1f}', Slice { offset: 2935, length: 1 }),
        ('\u{ff20}', Slice { offset: 2969, length: 1 }),
        ('\u{ff21}', Slice { offset: 121, length: 1 }),
        ('\u{ff22}', Slice { offset: 123, length: 1 }),
        ('\u{ff23}', Slice { offset: 267, length: 1 }),
        ('\u{ff24}', Slice { offset: 124, length: 1 }),
        ('\u{ff25}', Slice { offset: 125, length: 1 }),
        ('\u{ff26}', Slice { offset: 291, length: 1 }),
        ('\u{ff27}', Slice { offset: 127, length: 1 }),
        ('\u{ff28}', Slice { offset: 128, length: 1 }),
        ('\u{ff29}', Slice { offset: 129, length: 1 }),
        ('\u{ff2a}', Slice { offset: 130, length: 1 }),
        ('\u{ff2b}', Slice { offset: 131, length: 1 }),
        ('\u{ff2c}', Slice { offset: 132, length: 1 }),
        ('\u{ff2d}', Slice { offset: 133, length: 1 }),
        ('\u{ff2e}', Slice { offset: 134, length: 1 }),
        ('\u{ff2f}', Slice { offset: 135, length: 1 }),
        ('\u{ff30}', Slice { offset: 137, length: 1 }),
        ('\u{ff31}', Slice { offset: 282, length: 1 }),
        ('\u{ff32}', Slice { offset: 138, length: 1 }),
        ('\u{ff33}', Slice { offset: 633, length: 1 }),
        ('\u{ff34}', Slice { offset: 139, length: 1 }),
        ('\u{ff35}', Slice { offset: 140, length: 1 }),
        ('\u{ff36}', Slice { offset: 357, length: 1 }),
        ('\u{ff37}', Slice { offset: 141, length: 1 }),
        ('\u{ff38}', Slice { offset: 369, length: 1 }),
        ('\u{ff39}', Slice { offset: 634, length: 1 }),
        ('\u{ff3a}', Slice { offset: 290, length: 1 }),
        ('\u{ff3b}', Slice { offset: 2957, length: 1 }),
        ('\u{ff3c}', Slice { offset: 2966, length: 1 }),
        ('\u{ff3d}', Slice { offset: 2958, length: 1 }),
        ('\u{ff3e}', Slice { offset: 3044, length: 1 }),
        ('\u{ff3f}', Slice { offset: 2942, length: 1 }),
        ('\u{ff40}', Slice { offset: 3045, length: 1 }),
        ('\u{ff41}', Slice { offset: 3, length: 1 }),
        ('\u{ff42}', Slice { offset: 145, length: 1 }),
        ('\u{ff43}', Slice { offset: 171, length: 1 }),
        ('\u{ff44}', Slice { offset: 146, length: 1 }),
        ('\u{ff45}', Slice { offset: 147, length: 1 }),
        ('\u{ff46}', Slice { offset: 174, length: 1 }),
        ('\u{ff47}', Slice { offset: 151, length: 1 }),
        ('\u{ff48}', Slice { offset: 59, length: 1 }),
        ('\u{ff49}', Slice { offset: 168, length: 1 }),
        ('\u{ff4a}', Slice { offset: 61, length: 1 }),
        ('\u{ff4b}', Slice { offset: 152, length: 1 }),
        ('\u{ff4c}', Slice { offset: 81, length: 1 }),
        ('\u{ff4d}', Slice { offset: 153, length: 1 }),
        ('\u{ff4e}', Slice { offset: 258, length: 1 }),
        ('\u{ff4f}', Slice { offset: 14, length: 1 }),
        ('\u{ff50}', Slice { offset: 158, length: 1 }),
        ('\u{ff51}', Slice { offset: 635, length: 1 }),
        ('\u{ff52}', Slice { offset: 62, length: 1 }),
        ('\u{ff53}', Slice { offset: 34, length: 1 }),
        ('\u{ff54}', Slice { offset: 159, length: 1 }),
        ('\u{ff55}', Slice { offset: 160, length: 1 }),
        ('\u{ff56}', Slice { offset: 163, length: 1 }),
        ('\u{ff57}', Slice { offset: 66, length: 1 }),
        ('\u{ff58}', Slice { offset: 82, length: 1 }),
        ('\u{ff59}', Slice { offset: 67, length: 1 }),
        ('\u{ff5a}', Slice { offset: 201, length: 1 }),
        ('\u{ff5b}', Slice { offset: 2943, length: 1 }),
        ('\u{ff5c}', Slice { offset: 3046, length: 1 }),
        ('\u{ff5d}', Slice { offset: 2944, length: 1 }),
        ('\u{ff5e}', Slice { offset: 3047, length: 1 }),
        ('\u{ff5f}', Slice { offset: 3048, length: 1 }),
        ('\u{ff60}', Slice { offset: 3049, length: 1 }),
        ('\u{ff61}', Slice { offset: 2931, length: 1 }),
        ('\u{ff62}', Slice { offset: 2953, length: 1 }),
        ('\u{ff63}', Slice { offset: 2954, length: 1 }),
        ('\u{ff64}', Slice { offset: 2930, length: 1 }),
        ('\u{ff65}', Slice { offset: 3050, length: 1 }),
        ('\u{ff66}', Slice { offset: 1423, length: 1 }),
        ('\u{ff67}', Slice { offset: 3051, length: 1 }),
        ('\u{ff68}', Slice { offset: 3052, length: 1 }),
        ('\u{ff69}', Slice { offset: 3053, length: 1 }),
        ('\u{ff6a}', Slice { offset: 3054, length: 1 }),
        ('\u{ff6b}', Slice { offset: 3055, length: 1 }),
        ('\u{ff6c}', Slice { offset: 3056, length: 1 }),
        ('\u{ff6d}', Slice { offset: 3057, length: 1 }),
        ('\u{ff6e}', Slice { offset: 3058, length: 1 }),
        ('\u{ff6f}', Slice { offset: 3059, length: 1 }),
        ('\u{ff70}', Slice { offset: 3060, length: 1 }),
        ('\u{ff71}', Slice { offset: 1377, length: 1 }),
        ('\u{ff72}', Slice { offset: 1378, length: 1 }),
        ('\u{ff73}', Slice { offset: 1379, length: 1 }),
        ('\u{ff74}', Slice { offset: 1380, length: 1 }),
        ('\u{ff75}', Slice { offset: 1381, length: 1 }),
        ('\u{ff76}', Slice { offset: 1382, length: 1 }),
        ('\u{ff77}', Slice { offset: 1383, length: 1 }),
        ('\u{ff78}', Slice { offset: 1384, length: 1 }),
        ('\u{ff79}', Slice { offset: 1385, length: 1 }),
        ('\u{ff7a}', Slice { offset: 1386, length: 1 }),
        ('\u{ff7b}', Slice { offset: 1387, length: 1 }),
        ('\u{ff7c}', Slice { offset: 1388, length: 1 }),
        ('\u{ff7d}', Slice { offset: 1389, length: 1 }),
        ('\u{ff7e}', Slice { offset: 1390, length: 1 }),
        ('\u{ff7f}', Slice { offset: 1391, length: 1 }),
        ('\u{ff80}', Slice { offset: 1392, length: 1 }),
        ('\u{ff81}', Slice { offset: 1393, length: 1 }),
        ('\u{ff82}', Slice { offset: 1394, length: 1 }),
        ('\u{ff83}', Slice { offset: 1395, length: 1 }),
        ('\u{ff84}', Slice { offset: 1396, length: 1 }),
        ('\u{ff85}', Slice { offset: 1397, length: 1 }),
        ('\u{ff86}', Slice { offset: 1398, length: 1 }),
        ('\u{ff87}', Slice { offset: 1399, length: 1 }),
        ('\u{ff88}', Slice { offset: 1400, length: 1 }),
        ('\u{ff89}', Slice { offset: 1401, length: 1 }),
        ('\u{ff8a}', Slice { offset: 1402, length: 1 }),
        ('\u{ff8b}', Slice { offset: 1403, length: 1 }),
        ('\u{ff8c}', Slice { offset: 1404, length: 1 }),
        ('\u{ff8d}', Slice { offset: 1405, length: 1 }),
        ('\u{ff8e}', Slice { offset: 1406, length: 1 }),
        ('\u{ff8f}', Slice { offset: 1407, length: 1 }),
        ('\u{ff90}', Slice { offset: 1408, length: 1 }),
        ('\u{ff91}', Slice { offset: 1409, length: 1 }),
        ('\u{ff92}', Slice { offset: 1410, length: 1 }),
        ('\u{ff93}', Slice { offset: 1411, length: 1 }),
        ('\u{ff94}', Slice { offset: 1412, length: 1 }),
        ('\u{ff95}', Slice { offset: 1413, length: 1 }),
        ('\u{ff96}', Slice { offset: 1414, length: 1 }),
        ('\u{ff97}', Slice { offset: 1415, length: 1 }),
        ('\u{ff98}', Slice { offset: 1416, length: 1 }),
        ('\u{ff99}', Slice { offset: 1417, length: 1 }),
        ('\u{ff9a}', Slice { offset: 1418, length: 1 }),
        ('\u{ff9b}', Slice { offset: 1419, length: 1 }),
        ('\u{ff9c}', Slice { offset: 1420, length: 1 }),
        ('\u{ff9d}', Slice { offset: 3061, length: 1 }),
        ('\u{ff9e}', Slice { offset: 3062, length: 1 }),
        ('\u{ff9f}', Slice { offset: 3063, length: 1 }),
        ('\u{ffa0}', Slice { offset: 3064, length: 1 }),
        ('\u{ffa1}', Slice { offset: 3065, length: 1 }),
        ('\u{ffa2}', Slice { offset: 3066, length: 1 }),
        ('\u{ffa3}', Slice { offset: 3067, length: 1 }),
        ('\u{ffa4}', Slice { offset: 3068, length: 1 }),
        ('\u{ffa5}', Slice { offset: 3069, length: 1 }),
        ('\u{ffa6}', Slice { offset: 3070, length: 1 }),
        ('\u{ffa7}', Slice { offset: 3071, length: 1 }),
        ('\u{ffa8}', Slice { offset: 3072, length: 1 }),
        ('\u{ffa9}', Slice { offset: 3073, length: 1 }),
        ('\u{ffaa}', Slice { offset: 3074, length: 1 }),
        ('\u{ffab}', Slice { offset: 3075, length: 1 }),
        ('\u{ffac}', Slice { offset: 3076, length: 1 }),
        ('\u{ffad}', Slice { offset: 3077, length: 1 }),
        ('\u{ffae}', Slice { offset: 3078, length: 1 }),
        ('\u{ffaf}', Slice { offset: 3079, length: 1 }),
        ('\u{ffb0}', Slice { offset: 3080, length: 1 }),
        ('\u{ffb1}', Slice { offset: 3081, length: 1 }),
        ('\u{ffb2}', Slice { offset: 3082, length: 1 }),
        ('\u{ffb3}', Slice { offset: 3083, length: 1 }),
        ('\u{ffb4}', Slice { offset: 3084, length: 1 }),
        ('\u{ffb5}', Slice { offset: 3085, length: 1 }),
        ('\u{ffb6}', Slice { offset: 3086, length: 1 }),
        ('\u{ffb7}', Slice { offset: 3087, length: 1 }),
        ('\u{ffb8}', Slice { offset: 3088, length: 1 }),
        ('\u{ffb9}', Slice { offset: 3089, length: 1 }),
        ('\u{ffba}', Slice { offset: 3090, length: 1 }),
        ('\u{ffbb}', Slice { offset: 3091, length: 1 }),
        ('\u{ffbc}', Slice { offset: 3092, length: 1 }),
        ('\u{ffbd}', Slice { offset: 3093, length: 1 }),
        ('\u{ffbe}', Slice { offset: 3094, length: 1 }),
        ('\u{ffc2}', Slice { offset: 3095, length: 1 }),
        ('\u{ffc3}', Slice { offset: 3096, length: 1 }),
        ('\u{ffc4}', Slice { offset: 3097, length: 1 }),
        ('\u{ffc5}', Slice { offset: 3098, length: 1 }),
        ('\u{ffc6}', Slice { offset: 3099, length: 1 }),
        ('\u{ffc7}', Slice { offset: 3100, length: 1 }),
        ('\u{ffca}', Slice { offset: 3101, length: 1 }),
        ('\u{ffcb}', Slice { offset: 3102, length: 1 }),
        ('\u{ffcc}', Slice { offset: 3103, length: 1 }),
        ('\u{ffcd}', Slice { offset: 3104, length: 1 }),
        ('\u{ffce}', Slice { offset: 3105, length: 1 }),
        ('\u{ffcf}', Slice { offset: 3106, length: 1 }),
        ('\u{ffd2}', Slice { offset: 3107, length: 1 }),
        ('\u{ffd3}', Slice { offset: 3108, length: 1 }),
        ('\u{ffd4}', Slice { offset: 3109, length: 1 }),
        ('\u{ffd5}', Slice { offset: 3110, length: 1 }),
        ('\u{ffd6}', Slice { offset: 3111, length: 1 }),
        ('\u{ffd7}', Slice { offset: 3112, length: 1 }),
        ('\u{ffda}', Slice { offset: 3113, length: 1 }),
        ('\u{ffdb}', Slice { offset: 3114, length: 1 }),
        ('\u{ffdc}', Slice { offset: 3115, length: 1 }),
        ('\u{ffe0}', Slice { offset: 3116, length: 1 }),
        ('\u{ffe1}', Slice { offset: 3117, length: 1 }),
        ('\u{ffe2}', Slice { offset: 3118, length: 1 }),
        ('\u{ffe3}', Slice { offset: 3119, length: 1 }),
        ('\u{ffe4}', Slice { offset: 3120, length: 1 }),
        ('\u{ffe5}', Slice { offset: 3121, length: 1 }),
        ('\u{ffe6}', Slice { offset: 3122, length: 1 }),
        ('\u{ffe8}', Slice { offset: 3123, length: 1 }),
        ('\u{ffe9}', Slice { offset: 3124, length: 1 }),
        ('\u{ffea}', Slice { offset: 3125, length: 1 }),
        ('\u{ffeb}', Slice { offset: 3126, length: 1 }),
        ('\u{ffec}', Slice { offset: 3127, length: 1 }),
        ('\u{ffed}', Slice { offset: 3128, length: 1 }),
        ('\u{ffee}', Slice { offset: 3129, length: 1 }),
        ('\u{1d400}', Slice { offset: 121, length: 1 }),
        ('\u{1d401}', Slice { offset: 123, length: 1 }),
        ('\u{1d402}', Slice { offset: 267, length: 1 }),
        ('\u{1d403}', Slice { offset: 124, length: 1 }),
        ('\u{1d404}', Slice { offset: 125, length: 1 }),
        ('\u{1d405}', Slice { offset: 291, length: 1 }),
        ('\u{1d406}', Slice { offset: 127, length: 1 }),
        ('\u{1d407}', Slice { offset: 128, length: 1 }),
        ('\u{1d408}', Slice { offset: 129, length: 1 }),
        ('\u{1d409}', Slice { offset: 130, length: 1 }),
        ('\u{1d40a}', Slice { offset: 131, length: 1 }),
        ('\u{1d40b}', Slice { offset: 132, length: 1 }),
        ('\u{1d40c}', Slice { offset: 133, length: 1 }),
        ('\u{1d40d}', Slice { offset: 134, length: 1 }),
        ('\u{1d40e}', Slice { offset: 135, length: 1 }),
        ('\u{1d40f}', Slice { offset: 137, length: 1 }),
        ('\u{1d410}', Slice { offset: 282, length: 1 }),
        ('\u{1d411}', Slice { offset: 138, length: 1 }),
        ('\u{1d412}', Slice { offset: 633, length: 1 }),
        ('\u{1d413}', Slice { offset: 139, length: 1 }),
        ('\u{1d414}', Slice { offset: 140, length: 1 }),
        ('\u{1d415}', Slice { offset: 357, length: 1 }),
        ('\u{1d416}', Slice { offset: 141, length: 1 }),
        ('\u{1d417}', Slice { offset: 369, length: 1 }),
        ('\u{1d418}', Slice { offset: 634, length: 1 }),
        ('\u{1d419}', Slice { offset: 290, length: 1 }),
        ('\u{1d41a}', Slice { offset: 3, length: 1 }),
        ('\u{1d41b}', Slice { offset: 145, length: 1 }),
        ('\u{1d41c}', Slice { offset: 171, length: 1 }),
        ('\u{1d41d}', Slice { offset: 146, length: 1 }),
        ('\u{1d41e}', Slice { offset: 147, length: 1 }),
        ('\u{1d41f}', Slice { offset: 174, length: 1 }),
        ('\u{1d420}', Slice { offset: 151, length: 1 }),
        ('\u{1d421}', Slice { offset: 59, length: 1 }),
        ('\u{1d422}', Slice { offset: 168, length: 1 }),
        ('\u{1d423}', Slice { offset: 61, length: 1 }),
        ('\u{1d424}', Slice { offset: 152, length: 1 }),
        ('\u{1d425}', Slice { offset: 81, length: 1 }),
        ('\u{1d426}', Slice { offset: 153, length: 1 }),
        ('\u{1d427}', Slice { offset: 258, length: 1 }),
        ('\u{1d428}', Slice { offset: 14, length: 1 }),
        ('\u{1d429}', Slice { offset: 158, length: 1 }),
        ('\u{1d42a}', Slice { offset: 635, length: 1 }),
        ('\u{1d42b}', Slice { offset: 62, length: 1 }),
        ('\u{1d42c}', Slice { offset: 34, length: 1 }),
        ('\u{1d42d}', Slice { offset: 159, length: 1 }),
        ('\u{1d42e}', Slice { offset: 160, length: 1 }),
        ('\u{1d42f}', Slice { offset: 163, length: 1 }),
        ('\u{1d430}', Slice { offset: 66, length: 1 }),
        ('\u{1d431}', Slice { offset: 82, length: 1 }),
        ('\u{1d432}', Slice { offset: 67, length: 1 }),
        ('\u{1d433}', Slice { offset: 201, length: 1 }),
        ('\u{1d434}', Slice { offset: 121, length: 1 }),
        ('\u{1d435}', Slice { offset: 123, length: 1 }),
        ('\u{1d436}', Slice { offset: 267, length: 1 }),
        ('\u{1d437}', Slice { offset: 124, length: 1 }),
        ('\u{1d438}', Slice { offset: 125, length: 1 }),
        ('\u{1d439}', Slice { offset: 291, length: 1 }),
        ('\u{1d43a}', Slice { offset: 127, length: 1 }),
        ('\u{1d43b}', Slice { offset: 128, length: 1 }),
        ('\u{1d43c}', Slice { offset: 129, length: 1 }),
        ('\u{1d43d}', Slice { offset: 130, length: 1 }),
        ('\u{1d43e}', Slice { offset: 131, length: 1 }),
        ('\u{1d43f}', Slice { offset: 132, length: 1 }),
        ('\u{1d440}', Slice { offset: 133, length: 1 }),
        ('\u{1d441}', Slice { offset: 134, length: 1 }),
        ('\u{1d442}', Slice { offset: 135, length: 1 }),
        ('\u{1d443}', Slice { offset: 137, length: 1 }),
        ('\u{1d444}', Slice { offset: 282, length: 1 }),
        ('\u{1d445}', Slice { offset: 138, length: 1 }),
        ('\u{1d446}', Slice { offset: 633, length: 1 }),
        ('\u{1d447}', Slice { offset: 139, length: 1 }),
        ('\u{1d448}', Slice { offset: 140, length: 1 }),
        ('\u{1d449}', Slice { offset: 357, length: 1 }),
        ('\u{1d44a}', Slice { offset: 141, length: 1 }),
        ('\u{1d44b}', Slice { offset: 369, length: 1 }),
        ('\u{1d44c}', Slice { offset: 634, length: 1 }),
        ('\u{1d44d}', Slice { offset: 290, length: 1 }),
        ('\u{1d44e}', Slice { offset: 3, length: 1 }),
        ('\u{1d44f}', Slice { offset: 145, length: 1 }),
        ('\u{1d450}', Slice { offset: 171, length: 1 }),
        ('\u{1d451}', Slice { offset: 146, length: 1 }),
        ('\u{1d452}', Slice { offset: 147, length: 1 }),
        ('\u{1d453}', Slice { offset: 174, length: 1 }),
        ('\u{1d454}', Slice { offset: 151, length: 1 }),
        ('\u{1d456}', Slice { offset: 168, length: 1 }),
        ('\u{1d457}', Slice { offset: 61, length: 1 }),
        ('\u{1d458}', Slice { offset: 152, length: 1 }),
        ('\u{1d459}', Slice { offset: 81, length: 1 }),
        ('\u{1d45a}', Slice { offset: 153, length: 1 }),
        ('\u{1d45b}', Slice { offset: 258, length: 1 }),
        ('\u{1d45c}', Slice { offset: 14, length: 1 }),
        ('\u{1d45d}', Slice { offset: 158, length: 1 }),
        ('\u{1d45e}', Slice { offset: 635, length: 1 }),
        ('\u{1d45f}', Slice { offset: 62, length: 1 }),
        ('\u{1d460}', Slice { offset: 34, length: 1 }),
        ('\u{1d461}', Slice { offset: 159, length: 1 }),
        ('\u{1d462}', Slice { offset: 160, length: 1 }),
        ('\u{1d463}', Slice { offset: 163, length: 1 }),
        ('\u{1d464}', Slice { offset: 66, length: 1 }),
        ('\u{1d465}', Slice { offset: 82, length: 1 }),
        ('\u{1d466}', Slice { offset: 67, length: 1 }),
        ('\u{1d467}', Slice { offset: 201, length: 1 }),
        ('\u{1d468}', Slice { offset: 121, length: 1 }),
        ('\u{1d469}', Slice { offset: 123, length: 1 }),
        ('\u{1d46a}', Slice { offset: 267, length: 1 }),
        ('\u{1d46b}', Slice { offset: 124, length: 1 }),
        ('\u{1d46c}', Slice { offset: 125, length: 1 }),
        ('\u{1d46d}', Slice { offset: 291, length: 1 }),
        ('\u{1d46e}', Slice { offset: 127, length: 1 }),
        ('\u{1d46f}', Slice { offset: 128, length: 1 }),
        ('\u{1d470}', Slice { offset: 129, length: 1 }),
        ('\u{1d471}', Slice { offset: 130, length: 1 }),
        ('\u{1d472}', Slice { offset: 131, length: 1 }),
        ('\u{1d473}', Slice { offset: 132, length: 1 }),
        ('\u{1d474}', Slice { offset: 133, length: 1 }),
        ('\u{1d475}', Slice { offset: 134, length: 1 }),
        ('\u{1d476}', Slice { offset: 135, length: 1 }),
        ('\u{1d477}', Slice { offset: 137, length: 1 }),
        ('\u{1d478}', Slice { offset: 282, length: 1 }),
        ('\u{1d479}', Slice { offset: 138, length: 1 }),
        ('\u{1d47a}', Slice { offset: 633, length: 1 }),
        ('\u{1d47b}', Slice { offset: 139, length: 1 }),
        ('\u{1d47c}', Slice { offset: 140, length: 1 }),
        ('\u{1d47d}', Slice { offset: 357, length: 1 }),
        ('\u{1d47e}', Slice { offset: 141, length: 1 }),
        ('\u{1d47f}', Slice { offset: 369, length: 1 }),
        ('\u{1d480}', Slice { offset: 634, length: 1 }),
        ('\u{1d481}', Slice { offset: 290, length: 1 }),
        ('\u{1d482}', Slice { offset: 3, length: 1 }),
        ('\u{1d483}', Slice { offset: 145, length: 1 }),
        ('\u{1d484}', Slice { offset: 171, length: 1 }),
        ('\u{1d485}', Slice { offset: 146, length: 1 }),
        ('\u{1d486}', Slice { offset: 147, length: 1 }),
        ('\u{1d487}', Slice { offset: 174, length: 1 }),
        ('\u{1d488}', Slice { offset: 151, length: 1 }),
        ('\u{1d489}', Slice { offset: 59, length: 1 }),
        ('\u{1d48a}', Slice { offset: 168, length: 1 }),
        ('\u{1d48b}', Slice { offset: 61, length: 1 }),
        ('\u{1d48c}', Slice { offset: 152, length: 1 }),
        ('\u{1d48d}', Slice { offset: 81, length: 1 }),
        ('\u{1d48e}', Slice { offset: 153, length: 1 }),
        ('\u{1d48f}', Slice { offset: 258, length: 1 }),
        ('\u{1d490}', Slice { offset: 14, length: 1 }),
        ('\u{1d491}', Slice { offset: 158, length: 1 }),
        ('\u{1d492}', Slice { offset: 635, length: 1 }),
        ('\u{1d493}', Slice { offset: 62, length: 1 }),
        ('\u{1d494}', Slice { offset: 34, length: 1 }),
        ('\u{1d495}', Slice { offset: 159, length: 1 }),
        ('\u{1d496}', Slice { offset: 160, length: 1 }),
        ('\u{1d497}', Slice { offset: 163, length: 1 }),
        ('\u{1d498}', Slice { offset: 66, length: 1 }),
        ('\u{1d499}', Slice { offset: 82, length: 1 }),
        ('\u{1d49a}', Slice { offset: 67, length: 1 }),
        ('\u{1d49b}', Slice { offset: 201, length: 1 }),
        ('\u{1d49c}', Slice { offset: 121, length: 1 }),
        ('\u{1d49e}', Slice { offset: 267, length: 1 }),
        ('\u{1d49f}', Slice { offset: 124, length: 1 }),
        ('\u{1d4a2}', Slice { offset: 127, length: 1 }),
        ('\u{1d4a5}', Slice { offset: 130, length: 1 }),
        ('\u{1d4a6}', Slice { offset: 131, length: 1 }),
        ('\u{1d4a9}', Slice { offset: 134, length: 1 }),
        ('\u{1d4aa}', Slice { offset: 135, length: 1 }),
        ('\u{1d4ab}', Slice { offset: 137, length: 1 }),
        ('\u{1d4ac}', Slice { offset: 282, length: 1 }),
        ('\u{1d4ae}', Slice { offset: 633, length: 1 }),
        ('\u{1d4af}', Slice { offset: 139, length: 1 }),
        ('\u{1d4b0}', Slice { offset: 140, length: 1 }),
        ('\u{1d4b1}', Slice { offset: 357, length: 1 }),
        ('\u{1d4b2}', Slice { offset: 141, length: 1 }),
        ('\u{1d4b3}', Slice { offset: 369, length: 1 }),
        ('\u{1d4b4}', Slice { offset: 634, length: 1 }),
        ('\u{1d4b5}', Slice { offset: 290, length: 1 }),
        ('\u{1d4b6}', Slice { offset: 3, length: 1 }),
        ('\u{1d4b7}', Slice { offset: 145, length: 1 }),
        ('\u{1d4b8}', Slice { offset: 171, length: 1 }),
        ('\u{1d4b9}', Slice { offset: 146, length: 1 }),
        ('\u{1d4bb}', Slice { offset: 174, length: 1 }),
        ('\u{1d4bd}', Slice { offset: 59, length: 1 }),
        ('\u{1d4be}', Slice { offset: 168, length: 1 }),
        ('\u{1d4bf}', Slice { offset: 61, length: 1 }),
        ('\u{1d4c0}', Slice { offset: 152, length: 1 }),
        ('\u{1d4c1}', Slice { offset: 81, length: 1 }),
        ('\u{1d4c2}', Slice { offset: 153, length: 1 }),
        ('\u{1d4c3}', Slice { offset: 258, length: 1 }),
        ('\u{1d4c5}', Slice { offset: 158, length: 1 }),
        ('\u{1d4c6}', Slice { offset: 635, length: 1 }),
        ('\u{1d4c7}', Slice { offset: 62, length: 1 }),
        ('\u{1d4c8}', Slice { offset: 34, length: 1 }),
        ('\u{1d4c9}', Slice { offset: 159, length: 1 }),
        ('\u{1d4ca}', Slice { offset: 160, length: 1 }),
        ('\u{1d4cb}', Slice { offset: 163, length: 1 }),
        ('\u{1d4cc}', Slice { offset: 66, length: 1 }),
        ('\u{1d4cd}', Slice { offset: 82, length: 1 }),
        ('\u{1d4ce}', Slice { offset: 67, length: 1 }),
        ('\u{1d4cf}', Slice { offset: 201, length: 1 }),
        ('\u{1d4d0}', Slice { offset: 121, length: 1 }),
        ('\u{1d4d1}', Slice { offset: 123, length: 1 }),
        ('\u{1d4d2}', Slice { offset: 267, length: 1 }),
        ('\u{1d4d3}', Slice { offset: 124, length: 1 }),
        ('\u{1d4d4}', Slice { offset: 125, length: 1 }),
        ('\u{1d4d5}', Slice { offset: 291, length: 1 }),
        ('\u{1d4d6}', Slice { offset: 127, length: 1 }),
        ('\u{1d4d7}', Slice { offset: 128, length: 1 }),
        ('\u{1d4d8}', Slice { offset: 129, length: 1 }),
        ('\u{1d4d9}', Slice { offset: 130, length: 1 }),
        ('\u{1d4da}', Slice { offset: 131, length: 1 }),
        ('\u{1d4db}', Slice { offset: 132, length: 1 }),
        ('\u{1d4dc}', Slice { offset: 133, length: 1 }),
        ('\u{1d4dd}', Slice { offset: 134, length: 1 }),
        ('\u{1d4de}', Slice { offset: 135, length: 1 }),
        ('\u{1d4df}', Slice { offset: 137, length: 1 }),
        ('\u{1d4e0}', Slice { offset: 282, length: 1 }),
        ('\u{1d4e1}', Slice { offset: 138, length: 1 }),
        ('\u{1d4e2}', Slice { offset: 633, length: 1 }),
        ('\u{1d4e3}', Slice { offset: 139, length: 1 }),
        ('\u{1d4e4}', Slice { offset: 140, length: 1 }),
        ('\u{1d4e5}', Slice { offset: 357, length: 1 }),
        ('\u{1d4e6}', Slice { offset: 141, length: 1 }),
        ('\u{1d4e7}', Slice { offset: 369, length: 1 }),
        ('\u{1d4e8}', Slice { offset: 634, length: 1 }),
        ('\u{1d4e9}', Slice { offset: 290, length: 1 }),
        ('\u{1d4ea}', Slice { offset: 3, length: 1 }),
        ('\u{1d4eb}', Slice { offset: 145, length: 1 }),
        ('\u{1d4ec}', Slice { offset: 171, length: 1 }),
        ('\u{1d4ed}', Slice { offset: 146, length: 1 }),
        ('\u{1d4ee}', Slice { offset: 147, length: 1 }),
        ('\u{1d4ef}', Slice { offset: 174, length: 1 }),
        ('\u{1d4f0}', Slice { offset: 151, length: 1 }),
        ('\u{1d4f1}', Slice { offset: 59, length: 1 }),
        ('\u{1d4f2}', Slice { offset: 168, length: 1 }),
        ('\u{1d4f3}', Slice { offset: 61, length: 1 }),
        ('\u{1d4f4}', Slice { offset: 152, length: 1 }),
        ('\u{1d4f5}', Slice { offset: 81, length: 1 }),
        ('\u{1d4f6}', Slice { offset: 153, length: 1 }),
        ('\u{1d4f7}', Slice { offset: 258, length: 1 }),
        ('\u{1d4f8}', Slice { offset: 14, length: 1 }),
        ('\u{1d4f9}', Slice { offset: 158, length: 1 }),
        ('\u{1d4fa}', Slice { offset: 635, length: 1 }),
        ('\u{1d4fb}', Slice { offset: 62, length: 1 }),
        ('\u{1d4fc}', Slice { offset: 34, length: 1 }),
        ('\u{1d4fd}', Slice { offset: 159, length: 1 }),
        ('\u{1d4fe}', Slice { offset: 160, length: 1 }),
        ('\u{1d4ff}', Slice { offset: 163, length: 1 }),
        ('\u{1d500}', Slice { offset: 66, length: 1 }),
        ('\u{1d501}', Slice { offset: 82, length: 1 }),
        ('\u{1d502}', Slice { offset: 67, length: 1 }),
        ('\u{1d503}', Slice { offset: 201, length: 1 }),
        ('\u{1d504}', Slice { offset: 121, length: 1 }),
        ('\u{1d505}', Slice { offset: 123, length: 1 }),
        ('\u{1d507}', Slice { offset: 124, length: 1 }),
        ('\u{1d508}', Slice { offset: 125, length: 1 }),
        ('\u{1d509}', Slice { offset: 291, length: 1 }),
        ('\u{1d50a}', Slice { offset: 127, length: 1 }),
        ('\u{1d50d}', Slice { offset: 130, length: 1 }),
        ('\u{1d50e}', Slice { offset: 131, length: 1 }),
        ('\u{1d50f}', Slice { offset: 132, length: 1 }),
        ('\u{1d510}', Slice { offset: 133, length: 1 }),
        ('\u{1d511}', Slice { offset: 134, length: 1 }),
        ('\u{1d512}', Slice { offset: 135, length: 1 }),
        ('\u{1d513}', Slice { offset: 137, length: 1 }),
        ('\u{1d514}', Slice { offset: 282, length: 1 }),
        ('\u{1d516}', Slice { offset: 633, length: 1 }),
        ('\u{1d517}', Slice { offset: 139, length: 1 }),
        ('\u{1d518}', Slice { offset: 140, length: 1 }),
        ('\u{1d519}', Slice { offset: 357, length: 1 }),
        ('\u{1d51a}', Slice { offset: 141, length: 1 }),
        ('\u{1d51b}', Slice { offset: 369, length: 1 }),
        ('\u{1d51c}', Slice { offset: 634, length: 1 }),
        ('\u{1d51e}', Slice { offset: 3, length: 1 }),
        ('\u{1d51f}', Slice { offset: 145, length: 1 }),
        ('\u{1d520}', Slice { offset: 171, length: 1 }),
        ('\u{1d521}', Slice { offset: 146, length: 1 }),
        ('\u{1d522}', Slice { offset: 147, length: 1 }),
        ('\u{1d523}', Slice { offset: 174, length: 1 }),
        ('\u{1d524}', Slice { offset: 151, length: 1 }),
        ('\u{1d525}', Slice { offset: 59, length: 1 }),
        ('\u{1d526}', Slice { offset: 168, length: 1 }),
        ('\u{1d527}', Slice { offset: 61, length: 1 }),
        ('\u{1d528}', Slice { offset: 152, length: 1 }),
        ('\u{1d529}', Slice { offset: 81, length: 1 }),
        ('\u{1d52a}', Slice { offset: 153, length: 1 }),
        ('\u{1d52b}', Slice { offset: 258, length: 1 }),
        ('\u{1d52c}', Slice { offset: 14, length: 1 }),
        ('\u{1d52d}', Slice { offset: 158, length: 1 }),
        ('\u{1d52e}', Slice { offset: 635, length: 1 }),
        ('\u{1d52f}', Slice { offset: 62, length: 1 }),
        ('\u{1d530}', Slice { offset: 34, length: 1 }),
        ('\u{1d531}', Slice { offset: 159, length: 1 }),
        ('\u{1d532}', Slice { offset: 160, length: 1 }),
        ('\u{1d533}', Slice { offset: 163, length: 1 }),
        ('\u{1d534}', Slice { offset: 66, length: 1 }),
        ('\u{1d535}', Slice { offset: 82, length: 1 }),
        ('\u{1d536}', Slice { offset: 67, length: 1 }),
        ('\u{1d537}', Slice { offset: 201, length: 1 }),
        ('\u{1d538}', Slice { offset: 121, length: 1 }),
        ('\u{1d539}', Slice { offset: 123, length: 1 }),
        ('\u{1d53b}', Slice { offset: 124, length: 1 }),
        ('\u{1d53c}', Slice { offset: 125, length: 1 }),
        ('\u{1d53d}', Slice { offset: 291, length: 1 }),
        ('\u{1d53e}', Slice { offset: 127, length: 1 }),
        ('\u{1d540}', Slice { offset: 129, length: 1 }),
        ('\u{1d541}', Slice { offset: 130, length: 1 }),
        ('\u{1d542}', Slice { offset: 131, length: 1 }),
        ('\u{1d543}', Slice { offset: 132, length: 1 }),
        ('\u{1d544}', Slice { offset: 133, length: 1 }),
        ('\u{1d546}', Slice { offset: 135, length: 1 }),
        ('\u{1d54a}', Slice { offset: 633, length: 1 }),
        ('\u{1d54b}', Slice { offset: 139, length: 1 }),
        ('\u{1d54c}', Slice { offset: 140, length: 1 }),
        ('\u{1d54d}', Slice { offset: 357, length: 1 }),
        ('\u{1d54e}', Slice { offset: 141, length: 1 }),
        ('\u{1d54f}', Slice { offset: 369, length: 1 }),
        ('\u{1d550}', Slice { offset: 634, length: 1 }),
        ('\u{1d552}', Slice { offset: 3, length: 1 }),
        ('\u{1d553}', Slice { offset: 145, length: 1 }),
        ('\u{1d554}', Slice { offset: 171, length: 1 }),
        ('\u{1d555}', Slice { offset: 146, length: 1 }),
        ('\u{1d556}', Slice { offset: 147, length: 1 }),
        ('\u{1d557}', Slice { offset: 174, length: 1 }),
        ('\u{1d558}', Slice { offset: 151, length: 1 }),
        ('\u{1d559}', Slice { offset: 59, length: 1 }),
        ('\u{1d55a}', Slice { offset: 168, length: 1 }),
        ('\u{1d55b}', Slice { offset: 61, length: 1 }),
        ('\u{1d55c}', Slice { offset: 152, length: 1 }),
        ('\u{1d55d}', Slice { offset: 81, length: 1 }),
        ('\u{1d55e}', Slice { offset: 153, length: 1 }),
        ('\u{1d55f}', Slice { offset: 258, length: 1 }),
        ('\u{1d560}', Slice { offset: 14, length: 1 }),
        ('\u{1d561}', Slice { offset: 158, length: 1 }),
        ('\u{1d562}', Slice { offset: 635, length: 1 }),
        ('\u{1d563}', Slice { offset: 62, length: 1 }),
        ('\u{1d564}', Slice { offset: 34, length: 1 }),
        ('\u{1d565}', Slice { offset: 159, length: 1 }),
        ('\u{1d566}', Slice { offset: 160, length: 1 }),
        ('\u{1d567}', Slice { offset: 163, length: 1 }),
        ('\u{1d568}', Slice { offset: 66, length: 1 }),
        ('\u{1d569}', Slice { offset: 82, length: 1 }),
        ('\u{1d56a}', Slice { offset: 67, length: 1 }),
        ('\u{1d56b}', Slice { offset: 201, length: 1 }),
        ('\u{1d56c}', Slice { offset: 121, length: 1 }),
        ('\u{1d56d}', Slice { offset: 123, length: 1 }),
        ('\u{1d56e}', Slice { offset: 267, length: 1 }),
        ('\u{1d56f}', Slice { offset: 124, length: 1 }),
        ('\u{1d570}', Slice { offset: 125, length: 1 }),
        ('\u{1d571}', Slice { offset: 291, length: 1 }),
        ('\u{1d572}', Slice { offset: 127, length: 1 }),
        ('\u{1d573}', Slice { offset: 128, length: 1 }),
        ('\u{1d574}', Slice { offset: 129, length: 1 }),
        ('\u{1d575}', Slice { offset: 130, length: 1 }),
        ('\u{1d576}', Slice { offset: 131, length: 1 }),
        ('\u{1d577}', Slice { offset: 132, length: 1 }),
        ('\u{1d578}', Slice { offset: 133, length: 1 }),
        ('\u{1d579}', Slice { offset: 134, length: 1 }),
        ('\u{1d57a}', Slice { offset: 135, length: 1 }),
        ('\u{1d57b}', Slice { offset: 137, length: 1 }),
        ('\u{1d57c}', Slice { offset: 282, length: 1 }),
        ('\u{1d57d}', Slice { offset: 138, length: 1 }),
        ('\u{1d57e}', Slice { offset: 633, length: 1 }),
        ('\u{1d57f}', Slice { offset: 139, length: 1 }),
        ('\u{1d580}', Slice { offset: 140, length: 1 }),
        ('\u{1d581}', Slice { offset: 357, length: 1 }),
        ('\u{1d582}', Slice { offset: 141, length: 1 }),
        ('\u{1d583}', Slice { offset: 369, length: 1 }),
        ('\u{1d584}', Slice { offset: 634, length: 1 }),
        ('\u{1d585}', Slice { offset: 290, length: 1 }),
        ('\u{1d586}', Slice { offset: 3, length: 1 }),
        ('\u{1d587}', Slice { offset: 145, length: 1 }),
        ('\u{1d588}', Slice { offset: 171, length: 1 }),
        ('\u{1d589}', Slice { offset: 146, length: 1 }),
        ('\u{1d58a}', Slice { offset: 147, length: 1 }),
        ('\u{1d58b}', Slice { offset: 174, length: 1 }),
        ('\u{1d58c}', Slice { offset: 151, length: 1 }),
        ('\u{1d58d}', Slice { offset: 59, length: 1 }),
        ('\u{1d58e}', Slice { offset: 168, length: 1 }),
        ('\u{1d58f}', Slice { offset: 61, length: 1 }),
        ('\u{1d590}', Slice { offset: 152, length: 1 }),
        ('\u{1d591}', Slice { offset: 81, length: 1 }),
        ('\u{1d592}', Slice { offset: 153, length: 1 }),
        ('\u{1d593}', Slice { offset: 258, length: 1 }),
        ('\u{1d594}', Slice { offset: 14, length: 1 }),
        ('\u{1d595}', Slice { offset: 158, length: 1 }),
        ('\u{1d596}', Slice { offset: 635, length: 1 }),
        ('\u{1d597}', Slice { offset: 62, length: 1 }),
        ('\u{1d598}', Slice { offset: 34, length: 1 }),
        ('\u{1d599}', Slice { offset: 159, length: 1 }),
        ('\u{1d59a}', Slice { offset: 160, length: 1 }),
        ('\u{1d59b}', Slice { offset: 163, length: 1 }),
        ('\u{1d59c}', Slice { offset: 66, length: 1 }),
        ('\u{1d59d}', Slice { offset: 82, length: 1 }),
        ('\u{1d59e}', Slice { offset: 67, length: 1 }),
        ('\u{1d59f}', Slice { offset: 201, length: 1 }),
        ('\u{1d5a0}', Slice { offset: 121, length: 1 }),
        ('\u{1d5a1}', Slice { offset: 123, length: 1 }),
        ('\u{1d5a2}', Slice { offset: 267, length: 1 }),
        ('\u{1d5a3}', Slice { offset: 124, length: 1 }),
        ('\u{1d5a4}', Slice { offset: 125, length: 1 }),
        ('\u{1d5a5}', Slice { offset: 291, length: 1 }),
        ('\u{1d5a6}', Slice { offset: 127, length: 1 }),
        ('\u{1d5a7}', Slice { offset: 128, length: 1 }),
        ('\u{1d5a8}', Slice { offset: 129, length: 1 }),
        ('\u{1d5a9}', Slice { offset: 130, length: 1 }),
        ('\u{1d5aa}', Slice { offset: 131, length: 1 }),
        ('\u{1d5ab}', Slice { offset: 132, length: 1 }),
        ('\u{1d5ac}', Slice { offset: 133, length: 1 }),
        ('\u{1d5ad}', Slice { offset: 134, length: 1 }),
        ('\u{1d5ae}', Slice { offset: 135, length: 1 }),
        ('\u{1d5af}', Slice { offset: 137, length: 1 }),
        ('\u{1d5b0}', Slice { offset: 282, length: 1 }),
        ('\u{1d5b1}', Slice { offset: 138, length: 1 }),
        ('\u{1d5b2}', Slice { offset: 633, length: 1 }),
        ('\u{1d5b3}', Slice { offset: 139, length: 1 }),
        ('\u{1d5b4}', Slice { offset: 140, length: 1 }),
        ('\u{1d5b5}', Slice { offset: 357, length: 1 }),
        ('\u{1d5b6}', Slice { offset: 141, length: 1 }),
        ('\u{1d5b7}', Slice { offset: 369, length: 1 }),
        ('\u{1d5b8}', Slice { offset: 634, length: 1 }),
        ('\u{1d5b9}', Slice { offset: 290, length: 1 }),
        ('\u{1d5ba}', Slice { offset: 3, length: 1 }),
        ('\u{1d5bb}', Slice { offset: 145, length: 1 }),
        ('\u{1d5bc}', Slice { offset: 171, length: 1 }),
        ('\u{1d5bd}', Slice { offset: 146, length: 1 }),
        ('\u{1d5be}', Slice { offset: 147, length: 1 }),
        ('\u{1d5bf}', Slice { offset: 174, length: 1 }),
        ('\u{1d5c0}', Slice { offset: 151, length: 1 }),
        ('\u{1d5c1}', Slice { offset: 59, length: 1 }),
        ('\u{1d5c2}', Slice { offset: 168, length: 1 }),
        ('\u{1d5c3}', Slice { offset: 61, length: 1 }),
        ('\u{1d5c4}', Slice { offset: 152, length: 1 }),
        ('\u{1d5c5}', Slice { offset: 81, length: 1 }),
        ('\u{1d5c6}', Slice { offset: 153, length: 1 }),
        ('\u{1d5c7}', Slice { offset: 258, length: 1 }),
        ('\u{1d5c8}', Slice { offset: 14, length: 1 }),
        ('\u{1d5c9}', Slice { offset: 158, length: 1 }),
        ('\u{1d5ca}', Slice { offset: 635, length: 1 }),
        ('\u{1d5cb}', Slice { offset: 62, length: 1 }),
        ('\u{1d5cc}', Slice { offset: 34, length: 1 }),
        ('\u{1d5cd}', Slice { offset: 159, length: 1 }),
        ('\u{1d5ce}', Slice { offset: 160, length: 1 }),
        ('\u{1d5cf}', Slice { offset: 163, length: 1 }),
        ('\u{1d5d0}', Slice { offset: 66, length: 1 }),
        ('\u{1d5d1}', Slice { offset: 82, length: 1 }),
        ('\u{1d5d2}', Slice { offset: 67, length: 1 }),
        ('\u{1d5d3}', Slice { offset: 201, length: 1 }),
        ('\u{1d5d4}', Slice { offset: 121, length: 1 }),
        ('\u{1d5d5}', Slice { offset: 123, length: 1 }),
        ('\u{1d5d6}', Slice { offset: 267, length: 1 }),
        ('\u{1d5d7}', Slice { offset: 124, length: 1 }),
        ('\u{1d5d8}', Slice { offset: 125, length: 1 }),
        ('\u{1d5d9}', Slice { offset: 291, length: 1 }),
        ('\u{1d5da}', Slice { offset: 127, length: 1 }),
        ('\u{1d5db}', Slice { offset: 128, length: 1 }),
        ('\u{1d5dc}', Slice { offset: 129, length: 1 }),
        ('\u{1d5dd}', Slice { offset: 130, length: 1 }),
        ('\u{1d5de}', Slice { offset: 131, length: 1 }),
        ('\u{1d5df}', Slice { offset: 132, length: 1 }),
        ('\u{1d5e0}', Slice { offset: 133, length: 1 }),
        ('\u{1d5e1}', Slice { offset: 134, length: 1 }),
        ('\u{1d5e2}', Slice { offset: 135, length: 1 }),
        ('\u{1d5e3}', Slice { offset: 137, length: 1 }),
        ('\u{1d5e4}', Slice { offset: 282, length: 1 }),
        ('\u{1d5e5}', Slice { offset: 138, length: 1 }),
        ('\u{1d5e6}', Slice { offset: 633, length: 1 }),
        ('\u{1d5e7}', Slice { offset: 139, length: 1 }),
        ('\u{1d5e8}', Slice { offset: 140, length: 1 }),
        ('\u{1d5e9}', Slice { offset: 357, length: 1 }),
        ('\u{1d5ea}', Slice { offset: 141, length: 1 }),
        ('\u{1d5eb}', Slice { offset: 369, length: 1 }),
        ('\u{1d5ec}', Slice { offset: 634, length: 1 }),
        ('\u{1d5ed}', Slice { offset: 290, length: 1 }),
        ('\u{1d5ee}', Slice { offset: 3, length: 1 }),
        ('\u{1d5ef}', Slice { offset: 145, length: 1 }),
        ('\u{1d5f0}', Slice { offset: 171, length: 1 }),
        ('\u{1d5f1}', Slice { offset: 146, length: 1 }),
        ('\u{1d5f2}', Slice { offset: 147, length: 1 }),
        ('\u{1d5f3}', Slice { offset: 174, length: 1 }),
        ('\u{1d5f4}', Slice { offset: 151, length: 1 }),
        ('\u{1d5f5}', Slice { offset: 59, length: 1 }),
        ('\u{1d5f6}', Slice { offset: 168, length: 1 }),
        ('\u{1d5f7}', Slice { offset: 61, length: 1 }),
        ('\u{1d5f8}', Slice { offset: 152, length: 1 }),
        ('\u{1d5f9}', Slice { offset: 81, length: 1 }),
        ('\u{1d5fa}', Slice { offset: 153, length: 1 }),
        ('\u{1d5fb}', Slice { offset: 258, length: 1 }),
        ('\u{1d5fc}', Slice { offset: 14, length: 1 }),
        ('\u{1d5fd}', Slice { offset: 158, length: 1 }),
        ('\u{1d5fe}', Slice { offset: 635, length: 1 }),
        ('\u{1d5ff}', Slice { offset: 62, length: 1 }),
        ('\u{1d600}', Slice { offset: 34, length: 1 }),
        ('\u{1d601}', Slice { offset: 159, length: 1 }),
        ('\u{1d602}', Slice { offset: 160, length: 1 }),
        ('\u{1d603}', Slice { offset: 163, length: 1 }),
        ('\u{1d604}', Slice { offset: 66, length: 1 }),
        ('\u{1d605}', Slice { offset: 82, length: 1 }),
        ('\u{1d606}', Slice { offset: 67, length: 1 }),
        ('\u{1d607}', Slice { offset: 201, length: 1 }),
        ('\u{1d608}', Slice { offset: 121, length: 1 }),
        ('\u{1d609}', Slice { offset: 123, length: 1 }),
        ('\u{1d60a}', Slice { offset: 267, length: 1 }),
        ('\u{1d60b}', Slice { offset: 124, length: 1 }),
        ('\u{1d60c}', Slice { offset: 125, length: 1 }),
        ('\u{1d60d}', Slice { offset: 291, length: 1 }),
        ('\u{1d60e}', Slice { offset: 127, length: 1 }),
        ('\u{1d60f}', Slice { offset: 128, length: 1 }),
        ('\u{1d610}', Slice { offset: 129, length: 1 }),
        ('\u{1d611}', Slice { offset: 130, length: 1 }),
        ('\u{1d612}', Slice { offset: 131, length: 1 }),
        ('\u{1d613}', Slice { offset: 132, length: 1 }),
        ('\u{1d614}', Slice { offset: 133, length: 1 }),
        ('\u{1d615}', Slice { offset: 134, length: 1 }),
        ('\u{1d616}', Slice { offset: 135, length: 1 }),
        ('\u{1d617}', Slice { offset: 137, length: 1 }),
        ('\u{1d618}', Slice { offset: 282, length: 1 }),
        ('\u{1d619}', Slice { offset: 138, length: 1 }),
        ('\u{1d61a}', Slice { offset: 633, length: 1 }),
        ('\u{1d61b}', Slice { offset: 139, length: 1 }),
        ('\u{1d61c}', Slice { offset: 140, length: 1 }),
        ('\u{1d61d}', Slice { offset: 357, length: 1 }),
        ('\u{1d61e}', Slice { offset: 141, length: 1 }),
        ('\u{1d61f}', Slice { offset: 369, length: 1 }),
        ('\u{1d620}', Slice { offset: 634, length: 1 }),
        ('\u{1d621}', Slice { offset: 290, length: 1 }),
        ('\u{1d622}', Slice { offset: 3, length: 1 }),
        ('\u{1d623}', Slice { offset: 145, length: 1 }),
        ('\u{1d624}', Slice { offset: 171, length: 1 }),
        ('\u{1d625}', Slice { offset: 146, length: 1 }),
        ('\u{1d626}', Slice { offset: 147, length: 1 }),
        ('\u{1d627}', Slice { offset: 174, length: 1 }),
        ('\u{1d628}', Slice { offset: 151, length: 1 }),
        ('\u{1d629}', Slice { offset: 59, length: 1 }),
        ('\u{1d62a}', Slice { offset: 168, length: 1 }),
        ('\u{1d62b}', Slice { offset: 61, length: 1 }),
        ('\u{1d62c}', Slice { offset: 152, length: 1 }),
        ('\u{1d62d}', Slice { offset: 81, length: 1 }),
        ('\u{1d62e}', Slice { offset: 153, length: 1 }),
        ('\u{1d62f}', Slice { offset: 258, length: 1 }),
        ('\u{1d630}', Slice { offset: 14, length: 1 }),
        ('\u{1d631}', Slice { offset: 158, length: 1 }),
        ('\u{1d632}', Slice { offset: 635, length: 1 }),
        ('\u{1d633}', Slice { offset: 62, length: 1 }),
        ('\u{1d634}', Slice { offset: 34, length: 1 }),
        ('\u{1d635}', Slice { offset: 159, length: 1 }),
        ('\u{1d636}', Slice { offset: 160, length: 1 }),
        ('\u{1d637}', Slice { offset: 163, length: 1 }),
        ('\u{1d638}', Slice { offset: 66, length: 1 }),
        ('\u{1d639}', Slice { offset: 82, length: 1 }),
        ('\u{1d63a}', Slice { offset: 67, length: 1 }),
        ('\u{1d63b}', Slice { offset: 201, length: 1 }),
        ('\u{1d63c}', Slice { offset: 121, length: 1 }),
        ('\u{1d63d}', Slice { offset: 123, length: 1 }),
        ('\u{1d63e}', Slice { offset: 267, length: 1 }),
        ('\u{1d63f}', Slice { offset: 124, length: 1 }),
        ('\u{1d640}', Slice { offset: 125, length: 1 }),
        ('\u{1d641}', Slice { offset: 291, length: 1 }),
        ('\u{1d642}', Slice { offset: 127, length: 1 }),
        ('\u{1d643}', Slice { offset: 128, length: 1 }),
        ('\u{1d644}', Slice { offset: 129, length: 1 }),
        ('\u{1d645}', Slice { offset: 130, length: 1 }),
        ('\u{1d646}', Slice { offset: 131, length: 1 }),
        ('\u{1d647}', Slice { offset: 132, length: 1 }),
        ('\u{1d648}', Slice { offset: 133, length: 1 }),
        ('\u{1d649}', Slice { offset: 134, length: 1 }),
        ('\u{1d64a}', Slice { offset: 135, length: 1 }),
        ('\u{1d64b}', Slice { offset: 137, length: 1 }),
        ('\u{1d64c}', Slice { offset: 282, length: 1 }),
        ('\u{1d64d}', Slice { offset: 138, length: 1 }),
        ('\u{1d64e}', Slice { offset: 633, length: 1 }),
        ('\u{1d64f}', Slice { offset: 139, length: 1 }),
        ('\u{1d650}', Slice { offset: 140, length: 1 }),
        ('\u{1d651}', Slice { offset: 357, length: 1 }),
        ('\u{1d652}', Slice { offset: 141, length: 1 }),
        ('\u{1d653}', Slice { offset: 369, length: 1 }),
        ('\u{1d654}', Slice { offset: 634, length: 1 }),
        ('\u{1d655}', Slice { offset: 290, length: 1 }),
        ('\u{1d656}', Slice { offset: 3, length: 1 }),
        ('\u{1d657}', Slice { offset: 145, length: 1 }),
        ('\u{1d658}', Slice { offset: 171, length: 1 }),
        ('\u{1d659}', Slice { offset: 146, length: 1 }),
        ('\u{1d65a}', Slice { offset: 147, length: 1 }),
        ('\u{1d65b}', Slice { offset: 174, length: 1 }),
        ('\u{1d65c}', Slice { offset: 151, length: 1 }),
        ('\u{1d65d}', Slice { offset: 59, length: 1 }),
        ('\u{1d65e}', Slice { offset: 168, length: 1 }),
        ('\u{1d65f}', Slice { offset: 61, length: 1 }),
        ('\u{1d660}', Slice { offset: 152, length: 1 }),
        ('\u{1d661}', Slice { offset: 81, length: 1 }),
        ('\u{1d662}', Slice { offset: 153, length: 1 }),
        ('\u{1d663}', Slice { offset: 258, length: 1 }),
        ('\u{1d664}', Slice { offset: 14, length: 1 }),
        ('\u{1d665}', Slice { offset: 158, length: 1 }),
        ('\u{1d666}', Slice { offset: 635, length: 1 }),
        ('\u{1d667}', Slice { offset: 62, length: 1 }),
        ('\u{1d668}', Slice { offset: 34, length: 1 }),
        ('\u{1d669}', Slice { offset: 159, length: 1 }),
        ('\u{1d66a}', Slice { offset: 160, length: 1 }),
        ('\u{1d66b}', Slice { offset: 163, length: 1 }),
        ('\u{1d66c}', Slice { offset: 66, length: 1 }),
        ('\u{1d66d}', Slice { offset: 82, length: 1 }),
        ('\u{1d66e}', Slice { offset: 67, length: 1 }),
        ('\u{1d66f}', Slice { offset: 201, length: 1 }),
        ('\u{1d670}', Slice { offset: 121, length: 1 }),
        ('\u{1d671}', Slice { offset: 123, length: 1 }),
        ('\u{1d672}', Slice { offset: 267, length: 1 }),
        ('\u{1d673}', Slice { offset: 124, length: 1 }),
        ('\u{1d674}', Slice { offset: 125, length: 1 }),
        ('\u{1d675}', Slice { offset: 291, length: 1 }),
        ('\u{1d676}', Slice { offset: 127, length: 1 }),
        ('\u{1d677}', Slice { offset: 128, length: 1 }),
        ('\u{1d678}', Slice { offset: 129, length: 1 }),
        ('\u{1d679}', Slice { offset: 130, length: 1 }),
        ('\u{1d67a}', Slice { offset: 131, length: 1 }),
        ('\u{1d67b}', Slice { offset: 132, length: 1 }),
        ('\u{1d67c}', Slice { offset: 133, length: 1 }),
        ('\u{1d67d}', Slice { offset: 134, length: 1 }),
        ('\u{1d67e}', Slice { offset: 135, length: 1 }),
        ('\u{1d67f}', Slice { offset: 137, length: 1 }),
        ('\u{1d680}', Slice { offset: 282, length: 1 }),
        ('\u{1d681}', Slice { offset: 138, length: 1 }),
        ('\u{1d682}', Slice { offset: 633, length: 1 }),
        ('\u{1d683}', Slice { offset: 139, length: 1 }),
        ('\u{1d684}', Slice { offset: 140, length: 1 }),
        ('\u{1d685}', Slice { offset: 357, length: 1 }),
        ('\u{1d686}', Slice { offset: 141, length: 1 }),
        ('\u{1d687}', Slice { offset: 369, length: 1 }),
        ('\u{1d688}', Slice { offset: 634, length: 1 }),
        ('\u{1d689}', Slice { offset: 290, length: 1 }),
        ('\u{1d68a}', Slice { offset: 3, length: 1 }),
        ('\u{1d68b}', Slice { offset: 145, length: 1 }),
        ('\u{1d68c}', Slice { offset: 171, length: 1 }),
        ('\u{1d68d}', Slice { offset: 146, length: 1 }),
        ('\u{1d68e}', Slice { offset: 147, length: 1 }),
        ('\u{1d68f}', Slice { offset: 174, length: 1 }),
        ('\u{1d690}', Slice { offset: 151, length: 1 }),
        ('\u{1d691}', Slice { offset: 59, length: 1 }),
        ('\u{1d692}', Slice { offset: 168, length: 1 }),
        ('\u{1d693}', Slice { offset: 61, length: 1 }),
        ('\u{1d694}', Slice { offset: 152, length: 1 }),
        ('\u{1d695}', Slice { offset: 81, length: 1 }),
        ('\u{1d696}', Slice { offset: 153, length: 1 }),
        ('\u{1d697}', Slice { offset: 258, length: 1 }),
        ('\u{1d698}', Slice { offset: 14, length: 1 }),
        ('\u{1d699}', Slice { offset: 158, length: 1 }),
        ('\u{1d69a}', Slice { offset: 635, length: 1 }),
        ('\u{1d69b}', Slice { offset: 62, length: 1 }),
        ('\u{1d69c}', Slice { offset: 34, length: 1 }),
        ('\u{1d69d}', Slice { offset: 159, length: 1 }),
        ('\u{1d69e}', Slice { offset: 160, length: 1 }),
        ('\u{1d69f}', Slice { offset: 163, length: 1 }),
        ('\u{1d6a0}', Slice { offset: 66, length: 1 }),
        ('\u{1d6a1}', Slice { offset: 82, length: 1 }),
        ('\u{1d6a2}', Slice { offset: 67, length: 1 }),
        ('\u{1d6a3}', Slice { offset: 201, length: 1 }),
        ('\u{1d6a4}', Slice { offset: 3130, length: 1 }),
        ('\u{1d6a5}', Slice { offset: 3131, length: 1 }),
        ('\u{1d6a8}', Slice { offset: 3132, length: 1 }),
        ('\u{1d6a9}', Slice { offset: 3133, length: 1 }),
        ('\u{1d6aa}', Slice { offset: 299, length: 1 }),
        ('\u{1d6ab}', Slice { offset: 3134, length: 1 }),
        ('\u{1d6ac}', Slice { offset: 3135, length: 1 }),
        ('\u{1d6ad}', Slice { offset: 3136, length: 1 }),
        ('\u{1d6ae}', Slice { offset: 3137, length: 1 }),
        ('\u{1d6af}', Slice { offset: 94, length: 1 }),
        ('\u{1d6b0}', Slice { offset: 3138, length: 1 }),
        ('\u{1d6b1}', Slice { offset: 3139, length: 1 }),
        ('\u{1d6b2}', Slice { offset: 3140, length: 1 }),
        ('\u{1d6b3}', Slice { offset: 3141, length: 1 }),
        ('\u{1d6b4}', Slice { offset: 3142, length: 1 }),
        ('\u{1d6b5}', Slice { offset: 3143, length: 1 }),
        ('\u{1d6b6}', Slice { offset: 3144, length: 1 }),
        ('\u{1d6b7}', Slice { offset: 300, length: 1 }),
        ('\u{1d6b8}', Slice { offset: 3145, length: 1 }),
        ('\u{1d6b9}', Slice { offset: 3146, length: 1 }),
        ('\u{1d6ba}', Slice { offset: 96, length: 1 }),
        ('\u{1d6bb}', Slice { offset: 3147, length: 1 }),
        ('\u{1d6bc}', Slice { offset: 88, length: 1 }),
        ('\u{1d6bd}', Slice { offset: 3148, length: 1 }),
        ('\u{1d6be}', Slice { offset: 3149, length: 1 }),
        ('\u{1d6bf}', Slice { offset: 3150, length: 1 }),
        ('\u{1d6c0}', Slice { offset: 3151, length: 1 }),
        ('\u{1d6c1}', Slice { offset: 3152, length: 1 }),
        ('\u{1d6c2}', Slice { offset: 3153, length: 1 }),
        ('\u{1d6c3}', Slice { offset: 86, length: 1 }),
        ('\u{1d6c4}', Slice { offset: 165, length: 1 }),
        ('\u{1d6c5}', Slice { offset: 166, length: 1 }),
        ('\u{1d6c6}', Slice { offset: 95, length: 1 }),
        ('\u{1d6c7}', Slice { offset: 3154, length: 1 }),
        ('\u{1d6c8}', Slice { offset: 3155, length: 1 }),
        ('\u{1d6c9}', Slice { offset: 87, length: 1 }),
        ('\u{1d6ca}', Slice { offset: 3156, length: 1 }),
        ('\u{1d6cb}', Slice { offset: 91, length: 1 }),
        ('\u{1d6cc}', Slice { offset: 3157, length: 1 }),
        ('\u{1d6cd}', Slice { offset: 10, length: 1 }),
        ('\u{1d6ce}', Slice { offset: 3158, length: 1 }),
        ('\u{1d6cf}', Slice { offset: 3159, length: 1 }),
        ('\u{1d6d0}', Slice { offset: 3160, length: 1 }),
        ('\u{1d6d1}', Slice { offset: 90, length: 1 }),
        ('\u{1d6d2}', Slice { offset: 92, length: 1 }),
        ('\u{1d6d3}', Slice { offset: 93, length: 1 }),
        ('\u{1d6d4}', Slice { offset: 3161, length: 1 }),
        ('\u{1d6d5}', Slice { offset: 3162, length: 1 }),
        ('\u{1d6d6}', Slice { offset: 3163, length: 1 }),
        ('\u{1d6d7}', Slice { offset: 89, length: 1 }),
        ('\u{1d6d8}', Slice { offset: 167, length: 1 }),
        ('\u{1d6d9}', Slice { offset: 3164, length: 1 }),
        ('\u{1d6da}', Slice { offset: 3165, length: 1 }),
        ('\u{1d6db}', Slice { offset: 3166, length: 1 }),
        ('\u{1d6dc}', Slice { offset: 3167, length: 1 }),
        ('\u{1d6dd}', Slice { offset: 3168, length: 1 }),
        ('\u{1d6de}', Slice { offset: 3169, length: 1 }),
        ('\u{1d6df}', Slice { offset: 3170, length: 1 }),
        ('\u{1d6e0}', Slice { offset: 3171, length: 1 }),
        ('\u{1d6e1}', Slice { offset: 3172, length: 1 }),
        ('\u{1d6e2}', Slice { offset: 3132, length: 1 }),
        ('\u{1d6e3}', Slice { offset: 3133, length: 1 }),
        ('\u{1d6e4}', Slice { offset: 299, length: 1 }),
        ('\u{1d6e5}', Slice { offset: 3134, length: 1 }),
        ('\u{1d6e6}', Slice { offset: 3135, length: 1 }),
        ('\u{1d6e7}', Slice { offset: 3136, length: 1 }),
        ('\u{1d6e8}', Slice { offset: 3137, length: 1 }),
        ('\u{1d6e9}', Slice { offset: 94, length: 1 }),
        ('\u{1d6ea}', Slice { offset: 3138, length: 1 }),
        ('\u{1d6eb}', Slice { offset: 3139, length: 1 }),
        ('\u{1d6ec}', Slice { offset: 3140, length: 1 }),
        ('\u{1d6ed}', Slice { offset: 3141, length: 1 }),
        ('\u{1d6ee}', Slice { offset: 3142, length: 1 }),
        ('\u{1d6ef}', Slice { offset: 3143, length: 1 }),
        ('\u{1d6f0}', Slice { offset: 3144, length: 1 }),
        ('\u{1d6f1}', Slice { offset: 300, length: 1 }),
        ('\u{1d6f2}', Slice { offset: 3145, length: 1 }),
        ('\u{1d6f3}', Slice { offset: 3146, length: 1 }),
        ('\u{1d6f4}', Slice { offset: 96, length: 1 }),
        ('\u{1d6f5}', Slice { offset: 3147, length: 1 }),
        ('\u{1d6f6}', Slice { offset: 88, length: 1 }),
        ('\u{1d6f7}', Slice { offset: 3148, length: 1 }),
        ('\u{1d6f8}', Slice { offset: 3149, length: 1 }),
        ('\u{1d6f9}', Slice { offset: 3150, length: 1 }),
        ('\u{1d6fa}', Slice { offset: 3151, length: 1 }),
        ('\u{1d6fb}', Slice { offset: 3152, length: 1 }),
        ('\u{1d6fc}', Slice { offset: 3153, length: 1 }),
        ('\u{1d6fd}', Slice { offset: 86, length: 1 }),
        ('\u{1d6fe}', Slice { offset: 165, length: 1 }),
        ('\u{1d6ff}', Slice { offset: 166, length: 1 }),
        ('\u{1d700}', Slice { offset: 95, length: 1 }),
        ('\u{1d701}', Slice { offset: 3154, length: 1 }),
        ('\u{1d702}', Slice { offset: 3155, length: 1 }),
        ('\u{1d703}', Slice { offset: 87, length: 1 }),
        ('\u{1d704}', Slice { offset: 3156, length: 1 }),
        ('\u{1d705}', Slice { offset: 91, length: 1 }),
        ('\u{1d706}', Slice { offset: 3157, length: 1 }),
        ('\u{1d707}', Slice { offset: 10, length: 1 }),
        ('\u{1d708}', Slice { offset: 3158, length: 1 }),
        ('\u{1d709}', Slice { offset: 3159, length: 1 }),
        ('\u{1d70a}', Slice { offset: 3160, length: 1 }),
        ('\u{1d70b}', Slice { offset: 90, length: 1 }),
        ('\u{1d70c}', Slice { offset: 92, length: 1 }),
        ('\u{1d70d}', Slice { offset: 93, length: 1 }),
        ('\u{1d70e}', Slice { offset: 3161, length: 1 }),
        ('\u{1d70f}', Slice { offset: 3162, length: 1 }),
        ('\u{1d710}', Slice { offset: 3163, length: 1 }),
        ('\u{1d711}', Slice { offset: 89, length: 1 }),
        ('\u{1d712}', Slice { offset: 167, length: 1 }),
        ('\u{1d713}', Slice { offset: 3164, length: 1 }),
        ('\u{1d714}', Slice { offset: 3165, length: 1 }),
        ('\u{1d715}', Slice { offset: 3166, length: 1 }),
        ('\u{1d716}', Slice { offset: 3167, length: 1 }),
        ('\u{1d717}', Slice { offset: 3168, length: 1 }),
        ('\u{1d718}', Slice { offset: 3169, length: 1 }),
        ('\u{1d719}', Slice { offset: 3170, length: 1 }),
        ('\u{1d71a}', Slice { offset: 3171, length: 1 }),
        ('\u{1d71b}', Slice { offset: 3172, length: 1 }),
        ('\u{1d71c}', Slice { offset: 3132, length: 1 }),
        ('\u{1d71d}', Slice { offset: 3133, length: 1 }),
        ('\u{1d71e}', Slice { offset: 299, length: 1 }),
        ('\u{1d71f}', Slice { offset: 3134, length: 1 }),
        ('\u{1d720}', Slice { offset: 3135, length: 1 }),
        ('\u{1d721}', Slice { offset: 3136, length: 1 }),
        ('\u{1d722}', Slice { offset: 3137, length: 1 }),
        ('\u{1d723}', Slice { offset: 94, length: 1 }),
        ('\u{1d724}', Slice { offset: 3138, length: 1 }),
        ('\u{1d725}', Slice { offset: 3139, length: 1 }),
        ('\u{1d726}', Slice { offset: 3140, length: 1 }),
        ('\u{1d727}', Slice { offset: 3141, length: 1 }),
        ('\u{1d728}', Slice { offset: 3142, length: 1 }),
        ('\u{1d729}', Slice { offset: 3143, length: 1 }),
        ('\u{1d72a}', Slice { offset: 3144, length: 1 }),
        ('\u{1d72b}', Slice { offset: 300, length: 1 }),
        ('\u{1d72c}', Slice { offset: 3145, length: 1 }),
        ('\u{1d72d}', Slice { offset: 3146, length: 1 }),
        ('\u{1d72e}', Slice { offset: 96, length: 1 }),
        ('\u{1d72f}', Slice { offset: 3147, length: 1 }),
        ('\u{1d730}', Slice { offset: 88, length: 1 }),
        ('\u{1d731}', Slice { offset: 3148, length: 1 }),
        ('\u{1d732}', Slice { offset: 3149, length: 1 }),
        ('\u{1d733}', Slice { offset: 3150, length: 1 }),
        ('\u{1d734}', Slice { offset: 3151, length: 1 }),
        ('\u{1d735}', Slice { offset: 3152, length: 1 }),
        ('\u{1d736}', Slice { offset: 3153, length: 1 }),
        ('\u{1d737}', Slice { offset: 86, length: 1 }),
        ('\u{1d738}', Slice { offset: 165, length: 1 }),
        ('\u{1d739}', Slice { offset: 166, length: 1 }),
        ('\u{1d73a}', Slice { offset: 95, length: 1 }),
        ('\u{1d73b}', Slice { offset: 3154, length: 1 }),
        ('\u{1d73c}', Slice { offset: 3155, length: 1 }),
        ('\u{1d73d}', Slice { offset: 87, length: 1 }),
        ('\u{1d73e}', Slice { offset: 3156, length: 1 }),
        ('\u{1d73f}', Slice { offset: 91, length: 1 }),
        ('\u{1d740}', Slice { offset: 3157, length: 1 }),
        ('\u{1d741}', Slice { offset: 10, length: 1 }),
        ('\u{1d742}', Slice { offset: 3158, length: 1 }),
        ('\u{1d743}', Slice { offset: 3159, length: 1 }),
        ('\u{1d744}', Slice { offset: 3160, length: 1 }),
        ('\u{1d745}', Slice { offset: 90, length: 1 }),
        ('\u{1d746}', Slice { offset: 92, length: 1 }),
        ('\u{1d747}', Slice { offset: 93, length: 1 }),
        ('\u{1d748}', Slice { offset: 3161, length: 1 }),
        ('\u{1d749}', Slice { offset: 3162, length: 1 }),
        ('\u{1d74a}', Slice { offset: 3163, length: 1 }),
        ('\u{1d74b}', Slice { offset: 89, length: 1 }),
        ('\u{1d74c}', Slice { offset: 167, length: 1 }),
        ('\u{1d74d}', Slice { offset: 3164, length: 1 }),
        ('\u{1d74e}', Slice { offset: 3165, length: 1 }),
        ('\u{1d74f}', Slice { offset: 3166, length: 1 }),
        ('\u{1d750}', Slice { offset: 3167, length: 1 }),
        ('\u{1d751}', Slice { offset: 3168, length: 1 }),
        ('\u{1d752}', Slice { offset: 3169, length: 1 }),
        ('\u{1d753}', Slice { offset: 3170, length: 1 }),
        ('\u{1d754}', Slice { offset: 3171, length: 1 }),
        ('\u{1d755}', Slice { offset: 3172, length: 1 }),
        ('\u{1d756}', Slice { offset: 3132, length: 1 }),
        ('\u{1d757}', Slice { offset: 3133, length: 1 }),
        ('\u{1d758}', Slice { offset: 299, length: 1 }),
        ('\u{1d759}', Slice { offset: 3134, length: 1 }),
        ('\u{1d75a}', Slice { offset: 3135, length: 1 }),
        ('\u{1d75b}', Slice { offset: 3136, length: 1 }),
        ('\u{1d75c}', Slice { offset: 3137, length: 1 }),
        ('\u{1d75d}', Slice { offset: 94, length: 1 }),
        ('\u{1d75e}', Slice { offset: 3138, length: 1 }),
        ('\u{1d75f}', Slice { offset: 3139, length: 1 }),
        ('\u{1d760}', Slice { offset: 3140, length: 1 }),
        ('\u{1d761}', Slice { offset: 3141, length: 1 }),
        ('\u{1d762}', Slice { offset: 3142, length: 1 }),
        ('\u{1d763}', Slice { offset: 3143, length: 1 }),
        ('\u{1d764}', Slice { offset: 3144, length: 1 }),
        ('\u{1d765}', Slice { offset: 300, length: 1 }),
        ('\u{1d766}', Slice { offset: 3145, length: 1 }),
        ('\u{1d767}', Slice { offset: 3146, length: 1 }),
        ('\u{1d768}', Slice { offset: 96, length: 1 }),
        ('\u{1d769}', Slice { offset: 3147, length: 1 }),
        ('\u{1d76a}', Slice { offset: 88, length: 1 }),
        ('\u{1d76b}', Slice { offset: 3148, length: 1 }),
        ('\u{1d76c}', Slice { offset: 3149, length: 1 }),
        ('\u{1d76d}', Slice { offset: 3150, length: 1 }),
        ('\u{1d76e}', Slice { offset: 3151, length: 1 }),
        ('\u{1d76f}', Slice { offset: 3152, length: 1 }),
        ('\u{1d770}', Slice { offset: 3153, length: 1 }),
        ('\u{1d771}', Slice { offset: 86, length: 1 }),
        ('\u{1d772}', Slice { offset: 165, length: 1 }),
        ('\u{1d773}', Slice { offset: 166, length: 1 }),
        ('\u{1d774}', Slice { offset: 95, length: 1 }),
        ('\u{1d775}', Slice { offset: 3154, length: 1 }),
        ('\u{1d776}', Slice { offset: 3155, length: 1 }),
        ('\u{1d777}', Slice { offset: 87, length: 1 }),
        ('\u{1d778}', Slice { offset: 3156, length: 1 }),
        ('\u{1d779}', Slice { offset: 91, length: 1 }),
        ('\u{1d77a}', Slice { offset: 3157, length: 1 }),
        ('\u{1d77b}', Slice { offset: 10, length: 1 }),
        ('\u{1d77c}', Slice { offset: 3158, length: 1 }),
        ('\u{1d77d}', Slice { offset: 3159, length: 1 }),
        ('\u{1d77e}', Slice { offset: 3160, length: 1 }),
        ('\u{1d77f}', Slice { offset: 90, length: 1 }),
        ('\u{1d780}', Slice { offset: 92, length: 1 }),
        ('\u{1d781}', Slice { offset: 93, length: 1 }),
        ('\u{1d782}', Slice { offset: 3161, length: 1 }),
        ('\u{1d783}', Slice { offset: 3162, length: 1 }),
        ('\u{1d784}', Slice { offset: 3163, length: 1 }),
        ('\u{1d785}', Slice { offset: 89, length: 1 }),
        ('\u{1d786}', Slice { offset: 167, length: 1 }),
        ('\u{1d787}', Slice { offset: 3164, length: 1 }),
        ('\u{1d788}', Slice { offset: 3165, length: 1 }),
        ('\u{1d789}', Slice { offset: 3166, length: 1 }),
        ('\u{1d78a}', Slice { offset: 3167, length: 1 }),
        ('\u{1d78b}', Slice { offset: 3168, length: 1 }),
        ('\u{1d78c}', Slice { offset: 3169, length: 1 }),
        ('\u{1d78d}', Slice { offset: 3170, length: 1 }),
        ('\u{1d78e}', Slice { offset: 3171, length: 1 }),
        ('\u{1d78f}', Slice { offset: 3172, length: 1 }),
        ('\u{1d790}', Slice { offset: 3132, length: 1 }),
        ('\u{1d791}', Slice { offset: 3133, length: 1 }),
        ('\u{1d792}', Slice { offset: 299, length: 1 }),
        ('\u{1d793}', Slice { offset: 3134, length: 1 }),
        ('\u{1d794}', Slice { offset: 3135, length: 1 }),
        ('\u{1d795}', Slice { offset: 3136, length: 1 }),
        ('\u{1d796}', Slice { offset: 3137, length: 1 }),
        ('\u{1d797}', Slice { offset: 94, length: 1 }),
        ('\u{1d798}', Slice { offset: 3138, length: 1 }),
        ('\u{1d799}', Slice { offset: 3139, length: 1 }),
        ('\u{1d79a}', Slice { offset: 3140, length: 1 }),
        ('\u{1d79b}', Slice { offset: 3141, length: 1 }),
        ('\u{1d79c}', Slice { offset: 3142, length: 1 }),
        ('\u{1d79d}', Slice { offset: 3143, length: 1 }),
        ('\u{1d79e}', Slice { offset: 3144, length: 1 }),
        ('\u{1d79f}', Slice { offset: 300, length: 1 }),
        ('\u{1d7a0}', Slice { offset: 3145, length: 1 }),
        ('\u{1d7a1}', Slice { offset: 3146, length: 1 }),
        ('\u{1d7a2}', Slice { offset: 96, length: 1 }),
        ('\u{1d7a3}', Slice { offset: 3147, length: 1 }),
        ('\u{1d7a4}', Slice { offset: 88, length: 1 }),
        ('\u{1d7a5}', Slice { offset: 3148, length: 1 }),
        ('\u{1d7a6}', Slice { offset: 3149, length: 1 }),
        ('\u{1d7a7}', Slice { offset: 3150, length: 1 }),
        ('\u{1d7a8}', Slice { offset: 3151, length: 1 }),
        ('\u{1d7a9}', Slice { offset: 3152, length: 1 }),
        ('\u{1d7aa}', Slice { offset: 3153, length: 1 }),
        ('\u{1d7ab}', Slice { offset: 86, length: 1 }),
        ('\u{1d7ac}', Slice { offset: 165, length: 1 }),
        ('\u{1d7ad}', Slice { offset: 166, length: 1 }),
        ('\u{1d7ae}', Slice { offset: 95, length: 1 }),
        ('\u{1d7af}', Slice { offset: 3154, length: 1 }),
        ('\u{1d7b0}', Slice { offset: 3155, length: 1 }),
        ('\u{1d7b1}', Slice { offset: 87, length: 1 }),
        ('\u{1d7b2}', Slice { offset: 3156, length: 1 }),
        ('\u{1d7b3}', Slice { offset: 91, length: 1 }),
        ('\u{1d7b4}', Slice { offset: 3157, length: 1 }),
        ('\u{1d7b5}', Slice { offset: 10, length: 1 }),
        ('\u{1d7b6}', Slice { offset: 3158, length: 1 }),
        ('\u{1d7b7}', Slice { offset: 3159, length: 1 }),
        ('\u{1d7b8}', Slice { offset: 3160, length: 1 }),
        ('\u{1d7b9}', Slice { offset: 90, length: 1 }),
        ('\u{1d7ba}', Slice { offset: 92, length: 1 }),
        ('\u{1d7bb}', Slice { offset: 93, length: 1 }),
        ('\u{1d7bc}', Slice { offset: 3161, length: 1 }),
        ('\u{1d7bd}', Slice { offset: 3162, length: 1 }),
        ('\u{1d7be}', Slice { offset: 3163, length: 1 }),
        ('\u{1d7bf}', Slice { offset: 89, length: 1 }),
        ('\u{1d7c0}', Slice { offset: 167, length: 1 }),
        ('\u{1d7c1}', Slice { offset: 3164, length: 1 }),
        ('\u{1d7c2}', Slice { offset: 3165, length: 1 }),
        ('\u{1d7c3}', Slice { offset: 3166, length: 1 }),
        ('\u{1d7c4}', Slice { offset: 3167, length: 1 }),
        ('\u{1d7c5}', Slice { offset: 3168, length: 1 }),
        ('\u{1d7c6}', Slice { offset: 3169, length: 1 }),
        ('\u{1d7c7}', Slice { offset: 3170, length: 1 }),
        ('\u{1d7c8}', Slice { offset: 3171, length: 1 }),
        ('\u{1d7c9}', Slice { offset: 3172, length: 1 }),
        ('\u{1d7ca}', Slice { offset: 3173, length: 1 }),
        ('\u{1d7cb}', Slice { offset: 3174, length: 1 }),
        ('\u{1d7ce}', Slice { offset: 246, length: 1 }),
        ('\u{1d7cf}', Slice { offset: 13, length: 1 }),
        ('\u{1d7d0}', Slice { offset: 6, length: 1 }),
        ('\u{1d7d1}', Slice { offset: 7, length: 1 }),
        ('\u{1d7d2}', Slice { offset: 247, length: 1 }),
        ('\u{1d7d3}', Slice { offset: 248, length: 1 }),
        ('\u{1d7d4}', Slice { offset: 249, length: 1 }),
        ('\u{1d7d5}', Slice { offset: 250, length: 1 }),
        ('\u{1d7d6}', Slice { offset: 251, length: 1 }),
        ('\u{1d7d7}', Slice { offset: 252, length: 1 }),
        ('\u{1d7d8}', Slice { offset: 246, length: 1 }),
        ('\u{1d7d9}', Slice { offset: 13, length: 1 }),
        ('\u{1d7da}', Slice { offset: 6, length: 1 }),
        ('\u{1d7db}', Slice { offset: 7, length: 1 }),
        ('\u{1d7dc}', Slice { offset: 247, length: 1 }),
        ('\u{1d7dd}', Slice { offset: 248, length: 1 }),
        ('\u{1d7de}', Slice { offset: 249, length: 1 }),
        ('\u{1d7df}', Slice { offset: 250, length: 1 }),
        ('\u{1d7e0}', Slice { offset: 251, length: 1 }),
        ('\u{1d7e1}', Slice { offset: 252, length: 1 }),
        ('\u{1d7e2}', Slice { offset: 246, length: 1 }),
        ('\u{1d7e3}', Slice { offset: 13, length: 1 }),
        ('\u{1d7e4}', Slice { offset: 6, length: 1 }),
        ('\u{1d7e5}', Slice { offset: 7, length: 1 }),
        ('\u{1d7e6}', Slice { offset: 247, length: 1 }),
        ('\u{1d7e7}', Slice { offset: 248, length: 1 }),
        ('\u{1d7e8}', Slice { offset: 249, length: 1 }),
        ('\u{1d7e9}', Slice { offset: 250, length: 1 }),
        ('\u{1d7ea}', Slice { offset: 251, length: 1 }),
        ('\u{1d7eb}', Slice { offset: 252, length: 1 }),
        ('\u{1d7ec}', Slice { offset: 246, length: 1 }),
        ('\u{1d7ed}', Slice { offset: 13, length: 1 }),
        ('\u{1d7ee}', Slice { offset: 6, length: 1 }),
        ('\u{1d7ef}', Slice { offset: 7, length: 1 }),
        ('\u{1d7f0}', Slice { offset: 247, length: 1 }),
        ('\u{1d7f1}', Slice { offset: 248, length: 1 }),
        ('\u{1d7f2}', Slice { offset: 249, length: 1 }),
        ('\u{1d7f3}', Slice { offset: 250, length: 1 }),
        ('\u{1d7f4}', Slice { offset: 251, length: 1 }),
        ('\u{1d7f5}', Slice { offset: 252, length: 1 }),
        ('\u{1d7f6}', Slice { offset: 246, length: 1 }),
        ('\u{1d7f7}', Slice { offset: 13, length: 1 }),
        ('\u{1d7f8}', Slice { offset: 6, length: 1 }),
        ('\u{1d7f9}', Slice { offset: 7, length: 1 }),
        ('\u{1d7fa}', Slice { offset: 247, length: 1 }),
        ('\u{1d7fb}', Slice { offset: 248, length: 1 }),
        ('\u{1d7fc}', Slice { offset: 249, length: 1 }),
        ('\u{1d7fd}', Slice { offset: 250, length: 1 }),
        ('\u{1d7fe}', Slice { offset: 251, length: 1 }),
        ('\u{1d7ff}', Slice { offset: 252, length: 1 }),
        ('\u{1ee00}', Slice { offset: 3004, length: 1 }),
        ('\u{1ee01}', Slice { offset: 3005, length: 1 }),
        ('\u{1ee02}', Slice { offset: 3009, length: 1 }),
        ('\u{1ee03}', Slice { offset: 3012, length: 1 }),
        ('\u{1ee05}', Slice { offset: 3031, length: 1 }),
        ('\u{1ee06}', Slice { offset: 3015, length: 1 }),
        ('\u{1ee07}', Slice { offset: 3010, length: 1 }),
        ('\u{1ee08}', Slice { offset: 3020, length: 1 }),
        ('\u{1ee09}', Slice { offset: 3032, length: 1 }),
        ('\u{1ee0a}', Slice { offset: 3026, length: 1 }),
        ('\u{1ee0b}', Slice { offset: 3027, length: 1 }),
        ('\u{1ee0c}', Slice { offset: 3028, length: 1 }),
        ('\u{1ee0d}', Slice { offset: 3029, length: 1 }),
        ('\u{1ee0e}', Slice { offset: 3016, length: 1 }),
        ('\u{1ee0f}', Slice { offset: 3022, length: 1 }),
        ('\u{1ee10}', Slice { offset: 3024, length: 1 }),
        ('\u{1ee11}', Slice { offset: 3018, length: 1 }),
        ('\u{1ee12}', Slice { offset: 3025, length: 1 }),
        ('\u{1ee13}', Slice { offset: 3014, length: 1 }),
        ('\u{1ee14}', Slice { offset: 3017, length: 1 }),
        ('\u{1ee15}', Slice { offset: 3007, length: 1 }),
        ('\u{1ee16}', Slice { offset: 3008, length: 1 }),
        ('\u{1ee17}', Slice { offset: 3011, length: 1 }),
        ('\u{1ee18}', Slice { offset: 3013, length: 1 }),
        ('\u{1ee19}', Slice { offset: 3019, length: 1 }),
        ('\u{1ee1a}', Slice { offset: 3021, length: 1 }),
        ('\u{1ee1b}', Slice { offset: 3023, length: 1 }),
        ('\u{1ee1c}', Slice { offset: 3175, length: 1 }),
        ('\u{1ee1d}', Slice { offset: 2213, length: 1 }),
        ('\u{1ee1e}', Slice { offset: 3176, length: 1 }),
        ('\u{1ee1f}', Slice { offset: 3177, length: 1 }),
        ('\u{1ee21}', Slice { offset: 3005, length: 1 }),
        ('\u{1ee22}', Slice { offset: 3009, length: 1 }),
        ('\u{1ee24}', Slice { offset: 3030, length: 1 }),
        ('\u{1ee27}', Slice { offset: 3010, length: 1 }),
        ('\u{1ee29}', Slice { offset: 3032, length: 1 }),
        ('\u{1ee2a}', Slice { offset: 3026, length: 1 }),
        ('\u{1ee2b}', Slice { offset: 3027, length: 1 }),
        ('\u{1ee2c}', Slice { offset: 3028, length: 1 }),
        ('\u{1ee2d}', Slice { offset: 3029, length: 1 }),
        ('\u{1ee2e}', Slice { offset: 3016, length: 1 }),
        ('\u{1ee2f}', Slice { offset: 3022, length: 1 }),
        ('\u{1ee30}', Slice { offset: 3024, length: 1 }),
        ('\u{1ee31}', Slice { offset: 3018, length: 1 }),
        ('\u{1ee32}', Slice { offset: 3025, length: 1 }),
        ('\u{1ee34}', Slice { offset: 3017, length: 1 }),
        ('\u{1ee35}', Slice { offset: 3007, length: 1 }),
        ('\u{1ee36}', Slice { offset: 3008, length: 1 }),
        ('\u{1ee37}', Slice { offset: 3011, length: 1 }),
        ('\u{1ee39}', Slice { offset: 3019, length: 1 }),
        ('\u{1ee3b}', Slice { offset: 3023, length: 1 }),
        ('\u{1ee42}', Slice { offset: 3009, length: 1 }),
        ('\u{1ee47}', Slice { offset: 3010, length: 1 }),
        ('\u{1ee49}', Slice { offset: 3032, length: 1 }),
        ('\u{1ee4b}', Slice { offset: 3027, length: 1 }),
        ('\u{1ee4d}', Slice { offset: 3029, length: 1 }),
        ('\u{1ee4e}', Slice { offset: 3016, length: 1 }),
        ('\u{1ee4f}', Slice { offset: 3022, length: 1 }),
        ('\u{1ee51}', Slice { offset: 3018, length: 1 }),
        ('\u{1ee52}', Slice { offset: 3025, length: 1 }),
        ('\u{1ee54}', Slice { offset: 3017, length: 1 }),
        ('\u{1ee57}', Slice { offset: 3011, length: 1 }),
        ('\u{1ee59}', Slice { offset: 3019, length: 1 }),
        ('\u{1ee5b}', Slice { offset: 3023, length: 1 }),
        ('\u{1ee5d}', Slice { offset: 2213, length: 1 }),
        ('\u{1ee5f}', Slice { offset: 3177, length: 1 }),
        ('\u{1ee61}', Slice { offset: 3005, length: 1 }),
        ('\u{1ee62}', Slice { offset: 3009, length: 1 }),
        ('\u{1ee64}', Slice { offset: 3030, length: 1 }),
        ('\u{1ee67}', Slice { offset: 3010, length: 1 }),
        ('\u{1ee68}', Slice { offset: 3020, length: 1 }),
        ('\u{1ee69}', Slice { offset: 3032, length: 1 }),
        ('\u{1ee6a}', Slice { offset: 3026, length: 1 }),
        ('\u{1ee6c}', Slice { offset: 3028, length: 1 }),
        ('\u{1ee6d}', Slice { offset: 3029, length: 1 }),
        ('\u{1ee6e}', Slice { offset: 3016, length: 1 }),
        ('\u{1ee6f}', Slice { offset: 3022, length: 1 }),
        ('\u{1ee70}', Slice { offset: 3024, length: 1 }),
        ('\u{1ee71}', Slice { offset: 3018, length: 1 }),
        ('\u{1ee72}', Slice { offset: 3025, length: 1 }),
        ('\u{1ee74}', Slice { offset: 3017, length: 1 }),
        ('\u{1ee75}', Slice { offset: 3007, length: 1 }),
        ('\u{1ee76}', Slice { offset: 3008, length: 1 }),
        ('\u{1ee77}', Slice { offset: 3011, length: 1 }),
        ('\u{1ee79}', Slice { offset: 3019, length: 1 }),
        ('\u{1ee7a}', Slice { offset: 3021, length: 1 }),
        ('\u{1ee7b}', Slice { offset: 3023, length: 1 }),
        ('\u{1ee7c}', Slice { offset: 3175, length: 1 }),
        ('\u{1ee7e}', Slice { offset: 3176, length: 1 }),
        ('\u{1ee80}', Slice { offset: 3004, length: 1 }),
        ('\u{1ee81}', Slice { offset: 3005, length: 1 }),
        ('\u{1ee82}', Slice { offset: 3009, length: 1 }),
        ('\u{1ee83}', Slice { offset: 3012, length: 1 }),
        ('\u{1ee84}', Slice { offset: 3030, length: 1 }),
        ('\u{1ee85}', Slice { offset: 3031, length: 1 }),
        ('\u{1ee86}', Slice { offset: 3015, length: 1 }),
        ('\u{1ee87}', Slice { offset: 3010, length: 1 }),
        ('\u{1ee88}', Slice { offset: 3020, length: 1 }),
        ('\u{1ee89}', Slice { offset: 3032, length: 1 }),
        ('\u{1ee8b}', Slice { offset: 3027, length: 1 }),
        ('\u{1ee8c}', Slice { offset: 3028, length: 1 }),
        ('\u{1ee8d}', Slice { offset: 3029, length: 1 }),
        ('\u{1ee8e}', Slice { offset: 3016, length: 1 }),
        ('\u{1ee8f}', Slice { offset: 3022, length: 1 }),
        ('\u{1ee90}', Slice { offset: 3024, length: 1 }),
        ('\u{1ee91}', Slice { offset: 3018, length: 1 }),
        ('\u{1ee92}', Slice { offset: 3025, length: 1 }),
        ('\u{1ee93}', Slice { offset: 3014, length: 1 }),
        ('\u{1ee94}', Slice { offset: 3017, length: 1 }),
        ('\u{1ee95}', Slice { offset: 3007, length: 1 }),
        ('\u{1ee96}', Slice { offset: 3008, length: 1 }),
        ('\u{1ee97}', Slice { offset: 3011, length: 1 }),
        ('\u{1ee98}', Slice { offset: 3013, length: 1 }),
        ('\u{1ee99}', Slice { offset: 3019, length: 1 }),
        ('\u{1ee9a}', Slice { offset: 3021, length: 1 }),
        ('\u{1ee9b}', Slice { offset: 3023, length: 1 }),
        ('\u{1eea1}', Slice { offset: 3005, length: 1 }),
        ('\u{1eea2}', Slice { offset: 3009, length: 1 }),
        ('\u{1eea3}', Slice { offset: 3012, length: 1 }),
        ('\u{1eea5}', Slice { offset: 3031, length: 1 }),
        ('\u{1eea6}', Slice { offset: 3015, length: 1 }),
        ('\u{1eea7}', Slice { offset: 3010, length: 1 }),
        ('\u{1eea8}', Slice { offset: 3020, length: 1 }),
        ('\u{1eea9}', Slice { offset: 3032, length: 1 }),
        ('\u{1eeab}', Slice { offset: 3027, length: 1 }),
        ('\u{1eeac}', Slice { offset: 3028, length: 1 }),
        ('\u{1eead}', Slice { offset: 3029, length: 1 }),
        ('\u{1eeae}', Slice { offset: 3016, length: 1 }),
        ('\u{1eeaf}', Slice { offset: 3022, length: 1 }),
        ('\u{1eeb0}', Slice { offset: 3024, length: 1 }),
        ('\u{1eeb1}', Slice { offset: 3018, length: 1 }),
        ('\u{1eeb2}', Slice { offset: 3025, length: 1 }),
        ('\u{1eeb3}', Slice { offset: 3014, length: 1 }),
        ('\u{1eeb4}', Slice { offset: 3017, length: 1 }),
        ('\u{1eeb5}', Slice { offset: 3007, length: 1 }),
        ('\u{1eeb6}', Slice { offset: 3008, length: 1 }),
        ('\u{1eeb7}', Slice { offset: 3011, length: 1 }),
        ('\u{1eeb8}', Slice { offset: 3013, length: 1 }),
        ('\u{1eeb9}', Slice { offset: 3019, length: 1 }),
        ('\u{1eeba}', Slice { offset: 3021, length: 1 }),
        ('\u{1eebb}', Slice { offset: 3023, length: 1 }),
        ('\u{1f100}', Slice { offset: 3178, length: 2 }),
        ('\u{1f101}', Slice { offset: 3180, length: 2 }),
        ('\u{1f102}', Slice { offset: 3182, length: 2 }),
        ('\u{1f103}', Slice { offset: 3184, length: 2 }),
        ('\u{1f104}', Slice { offset: 3186, length: 2 }),
        ('\u{1f105}', Slice { offset: 3188, length: 2 }),
        ('\u{1f106}', Slice { offset: 3190, length: 2 }),
        ('\u{1f107}', Slice { offset: 3192, length: 2 }),
        ('\u{1f108}', Slice { offset: 3194, length: 2 }),
        ('\u{1f109}', Slice { offset: 3196, length: 2 }),
        ('\u{1f10a}', Slice { offset: 3198, length: 2 }),
        ('\u{1f110}', Slice { offset: 3200, length: 3 }),
        ('\u{1f111}', Slice { offset: 3203, length: 3 }),
        ('\u{1f112}', Slice { offset: 3206, length: 3 }),
        ('\u{1f113}', Slice { offset: 3209, length: 3 }),
        ('\u{1f114}', Slice { offset: 3212, length: 3 }),
        ('\u{1f115}', Slice { offset: 3215, length: 3 }),
        ('\u{1f116}', Slice { offset: 3218, length: 3 }),
        ('\u{1f117}', Slice { offset: 3221, length: 3 }),
        ('\u{1f118}', Slice { offset: 3224, length: 3 }),
        ('\u{1f119}', Slice { offset: 3227, length: 3 }),
        ('\u{1f11a}', Slice { offset: 3230, length: 3 }),
        ('\u{1f11b}', Slice { offset: 3233, length: 3 }),
        ('\u{1f11c}', Slice { offset: 3236, length: 3 }),
        ('\u{1f11d}', Slice { offset: 3239, length: 3 }),
        ('\u{1f11e}', Slice { offset: 3242, length: 3 }),
        ('\u{1f11f}', Slice { offset: 3245, length: 3 }),
        ('\u{1f120}', Slice { offset: 3248, length: 3 }),
        ('\u{1f121}', Slice { offset: 3251, length: 3 }),
        ('\u{1f122}', Slice { offset: 3254, length: 3 }),
        ('\u{1f123}', Slice { offset: 3257, length: 3 }),
        ('\u{1f124}', Slice { offset: 3260, length: 3 }),
        ('\u{1f125}', Slice { offset: 3263, length: 3 }),
        ('\u{1f126}', Slice { offset: 3266, length: 3 }),
        ('\u{1f127}', Slice { offset: 3269, length: 3 }),
        ('\u{1f128}', Slice { offset: 3272, length: 3 }),
        ('\u{1f129}', Slice { offset: 3275, length: 3 }),
        ('\u{1f12a}', Slice { offset: 3278, length: 3 }),
        ('\u{1f12b}', Slice { offset: 267, length: 1 }),
        ('\u{1f12c}', Slice { offset: 138, length: 1 }),
        ('\u{1f12d}', Slice { offset: 3281, length: 2 }),
        ('\u{1f12e}', Slice { offset: 3283, length: 2 }),
        ('\u{1f130}', Slice { offset: 121, length: 1 }),
        ('\u{1f131}', Slice { offset: 123, length: 1 }),
        ('\u{1f132}', Slice { offset: 267, length: 1 }),
        ('\u{1f133}', Slice { offset: 124, length: 1 }),
        ('\u{1f134}', Slice { offset: 125, length: 1 }),
        ('\u{1f135}', Slice { offset: 291, length: 1 }),
        ('\u{1f136}', Slice { offset: 127, length: 1 }),
        ('\u{1f137}', Slice { offset: 128, length: 1 }),
        ('\u{1f138}', Slice { offset: 129, length: 1 }),
        ('\u{1f139}', Slice { offset: 130, length: 1 }),
        ('\u{1f13a}', Slice { offset: 131, length: 1 }),
        ('\u{1f13b}', Slice { offset: 132, length: 1 }),
        ('\u{1f13c}', Slice { offset: 133, length: 1 }),
        ('\u{1f13d}', Slice { offset: 134, length: 1 }),
        ('\u{1f13e}', Slice { offset: 135, length: 1 }),
        ('\u{1f13f}', Slice { offset: 137, length: 1 }),
        ('\u{1f140}', Slice { offset: 282, length: 1 }),
        ('\u{1f141}', Slice { offset: 138, length: 1 }),
        ('\u{1f142}', Slice { offset: 633, length: 1 }),
        ('\u{1f143}', Slice { offset: 139, length: 1 }),
        ('\u{1f144}', Slice { offset: 140, length: 1 }),
        ('\u{1f145}', Slice { offset: 357, length: 1 }),
        ('\u{1f146}', Slice { offset: 141, length: 1 }),
        ('\u{1f147}', Slice { offset: 369, length: 1 }),
        ('\u{1f148}', Slice { offset: 634, length: 1 }),
        ('\u{1f149}', Slice { offset: 290, length: 1 }),
        ('\u{1f14a}', Slice { offset: 3285, length: 2 }),
        ('\u{1f14b}', Slice { offset: 1968, length: 2 }),
        ('\u{1f14c}', Slice { offset: 3287, length: 2 }),
        ('\u{1f14d}', Slice { offset: 3289, length: 2 }),
        ('\u{1f14e}', Slice { offset: 3291, length: 3 }),
        ('\u{1f14f}', Slice { offset: 3294, length: 2 }),
        ('\u{1f16a}', Slice { offset: 3296, length: 2 }),
        ('\u{1f16b}', Slice { offset: 3298, length: 2 }),
        ('\u{1f190}', Slice { offset: 3300, length: 2 }),
        ('\u{1f200}', Slice { offset: 3302, length: 2 }),
        ('\u{1f201}', Slice { offset: 3304, length: 2 }),
        ('\u{1f202}', Slice { offset: 1387, length: 1 }),
        ('\u{1f210}', Slice { offset: 714, length: 1 }),
        ('\u{1f211}', Slice { offset: 3306, length: 1 }),
        ('\u{1f212}', Slice { offset: 3307, length: 1 }),
        ('\u{1f213}', Slice { offset: 3308, length: 1 }),
        ('\u{1f214}', Slice { offset: 657, length: 1 }),
        ('\u{1f215}', Slice { offset: 3309, length: 1 }),
        ('\u{1f216}', Slice { offset: 3310, length: 1 }),
        ('\u{1f217}', Slice { offset: 978, length: 1 }),
        ('\u{1f218}', Slice { offset: 3311, length: 1 }),
        ('\u{1f219}', Slice { offset: 3312, length: 1 }),
        ('\u{1f21a}', Slice { offset: 3313, length: 1 }),
        ('\u{1f21b}', Slice { offset: 3314, length: 1 }),
        ('\u{1f21c}', Slice { offset: 3315, length: 1 }),
        ('\u{1f21d}', Slice { offset: 3316, length: 1 }),
        ('\u{1f21e}', Slice { offset: 3317, length: 1 }),
        ('\u{1f21f}', Slice { offset: 3318, length: 1 }),
        ('\u{1f220}', Slice { offset: 3319, length: 1 }),
        ('\u{1f221}', Slice { offset: 3320, length: 1 }),
        ('\u{1f222}', Slice { offset: 750, length: 1 }),
        ('\u{1f223}', Slice { offset: 3321, length: 1 }),
        ('\u{1f224}', Slice { offset: 3322, length: 1 }),
        ('\u{1f225}', Slice { offset: 3323, length: 1 }),
        ('\u{1f226}', Slice { offset: 3324, length: 1 }),
        ('\u{1f227}', Slice { offset: 3325, length: 1 }),
        ('\u{1f228}', Slice { offset: 3326, length: 1 }),
        ('\u{1f229}', Slice { offset: 651, length: 1 }),
        ('\u{1f22a}', Slice { offset: 970, length: 1 }),
        ('\u{1f22b}', Slice { offset: 3327, length: 1 }),
        ('\u{1f22c}', Slice { offset: 1300, length: 1 }),
        ('\u{1f22d}', Slice { offset: 973, length: 1 }),
        ('\u{1f22e}', Slice { offset: 1301, length: 1 }),
        ('\u{1f22f}', Slice { offset: 3328, length: 1 }),
        ('\u{1f230}', Slice { offset: 806, length: 1 }),
        ('\u{1f231}', Slice { offset: 3329, length: 1 }),
        ('\u{1f232}', Slice { offset: 3330, length: 1 }),
        ('\u{1f233}', Slice { offset: 3331, length: 1 }),
        ('\u{1f234}', Slice { offset: 3332, length: 1 }),
        ('\u{1f235}', Slice { offset: 3333, length: 1 }),
        ('\u{1f236}', Slice { offset: 1283, length: 1 }),
        ('\u{1f237}', Slice { offset: 724, length: 1 }),
        ('\u{1f238}', Slice { offset: 3334, length: 1 }),
        ('\u{1f239}', Slice { offset: 3335, length: 1 }),
        ('\u{1f23a}', Slice { offset: 3336, length: 1 }),
        ('\u{1f23b}', Slice { offset: 3337, length: 1 }),
        ('\u{1f240}', Slice { offset: 3338, length: 3 }),
        ('\u{1f241}', Slice { offset: 3341, length: 3 }),
        ('\u{1f242}', Slice { offset: 3344, length: 3 }),
        ('\u{1f243}', Slice { offset: 3347, length: 3 }),
        ('\u{1f244}', Slice { offset: 3350, length: 3 }),
        ('\u{1f245}', Slice { offset: 3353, length: 3 }),
        ('\u{1f246}', Slice { offset: 3356, length: 3 }),
        ('\u{1f247}', Slice { offset: 3359, length: 3 }),
        ('\u{1f248}', Slice { offset: 3362, length: 3 }),
        ('\u{1f250}', Slice { offset: 3365, length: 1 }),
        ('\u{1f251}', Slice { offset: 3366, length: 1 }),

    ];

    pub  const compatibility_table_STRTAB: &'static [char] = &[
        '\u{20}',
        '\u{20}', '\u{308}',
        '\u{61}',
        '\u{20}', '\u{304}',
        '\u{32}',
        '\u{33}',
        '\u{20}', '\u{301}',
        '\u{3bc}',
        '\u{20}', '\u{327}',
        '\u{31}',
        '\u{6f}',
        '\u{31}', '\u{2044}', '\u{34}',
        '\u{31}', '\u{2044}', '\u{32}',
        '\u{33}', '\u{2044}', '\u{34}',
        '\u{49}', '\u{4a}',
        '\u{69}', '\u{6a}',
        '\u{4c}', '\u{b7}',
        '\u{6c}', '\u{b7}',
        '\u{2bc}', '\u{6e}',
        '\u{73}',
        '\u{44}', '\u{17d}',
        '\u{44}', '\u{17e}',
        '\u{64}', '\u{17e}',
        '\u{4c}', '\u{4a}',
        '\u{4c}', '\u{6a}',
        '\u{6c}', '\u{6a}',
        '\u{4e}', '\u{4a}',
        '\u{4e}', '\u{6a}',
        '\u{6e}', '\u{6a}',
        '\u{44}', '\u{5a}',
        '\u{44}', '\u{7a}',
        '\u{64}', '\u{7a}',
        '\u{68}',
        '\u{266}',
        '\u{6a}',
        '\u{72}',
        '\u{279}',
        '\u{27b}',
        '\u{281}',
        '\u{77}',
        '\u{79}',
        '\u{20}', '\u{306}',
        '\u{20}', '\u{307}',
        '\u{20}', '\u{30a}',
        '\u{20}', '\u{328}',
        '\u{20}', '\u{303}',
        '\u{20}', '\u{30b}',
        '\u{263}',
        '\u{6c}',
        '\u{78}',
        '\u{295}',
        '\u{20}', '\u{345}',
        '\u{3b2}',
        '\u{3b8}',
        '\u{3a5}',
        '\u{3c6}',
        '\u{3c0}',
        '\u{3ba}',
        '\u{3c1}',
        '\u{3c2}',
        '\u{398}',
        '\u{3b5}',
        '\u{3a3}',
        '\u{565}', '\u{582}',
        '\u{627}', '\u{674}',
        '\u{648}', '\u{674}',
        '\u{6c7}', '\u{674}',
        '\u{64a}', '\u{674}',
        '\u{e4d}', '\u{e32}',
        '\u{ecd}', '\u{eb2}',
        '\u{eab}', '\u{e99}',
        '\u{eab}', '\u{ea1}',
        '\u{f0b}',
        '\u{fb2}', '\u{f81}',
        '\u{fb3}', '\u{f81}',
        '\u{10dc}',
        '\u{41}',
        '\u{c6}',
        '\u{42}',
        '\u{44}',
        '\u{45}',
        '\u{18e}',
        '\u{47}',
        '\u{48}',
        '\u{49}',
        '\u{4a}',
        '\u{4b}',
        '\u{4c}',
        '\u{4d}',
        '\u{4e}',
        '\u{4f}',
        '\u{222}',
        '\u{50}',
        '\u{52}',
        '\u{54}',
        '\u{55}',
        '\u{57}',
        '\u{250}',
        '\u{251}',
        '\u{1d02}',
        '\u{62}',
        '\u{64}',
        '\u{65}',
        '\u{259}',
        '\u{25b}',
        '\u{25c}',
        '\u{67}',
        '\u{6b}',
        '\u{6d}',
        '\u{14b}',
        '\u{254}',
        '\u{1d16}',
        '\u{1d17}',
        '\u{70}',
        '\u{74}',
        '\u{75}',
        '\u{1d1d}',
        '\u{26f}',
        '\u{76}',
        '\u{1d25}',
        '\u{3b3}',
        '\u{3b4}',
        '\u{3c7}',
        '\u{69}',
        '\u{43d}',
        '\u{252}',
        '\u{63}',
        '\u{255}',
        '\u{f0}',
        '\u{66}',
        '\u{25f}',
        '\u{261}',
        '\u{265}',
        '\u{268}',
        '\u{269}',
        '\u{26a}',
        '\u{1d7b}',
        '\u{29d}',
        '\u{26d}',
        '\u{1d85}',
        '\u{29f}',
        '\u{271}',
        '\u{270}',
        '\u{272}',
        '\u{273}',
        '\u{274}',
        '\u{275}',
        '\u{278}',
        '\u{282}',
        '\u{283}',
        '\u{1ab}',
        '\u{289}',
        '\u{28a}',
        '\u{1d1c}',
        '\u{28b}',
        '\u{28c}',
        '\u{7a}',
        '\u{290}',
        '\u{291}',
        '\u{292}',
        '\u{61}', '\u{2be}',
        '\u{20}', '\u{313}',
        '\u{20}', '\u{342}',
        '\u{20}', '\u{314}',
        '\u{2010}',
        '\u{20}', '\u{333}',
        '\u{2e}',
        '\u{2e}', '\u{2e}',
        '\u{2e}', '\u{2e}', '\u{2e}',
        '\u{2032}', '\u{2032}',
        '\u{2032}', '\u{2032}', '\u{2032}',
        '\u{2035}', '\u{2035}',
        '\u{2035}', '\u{2035}', '\u{2035}',
        '\u{21}', '\u{21}',
        '\u{20}', '\u{305}',
        '\u{3f}', '\u{3f}',
        '\u{3f}', '\u{21}',
        '\u{21}', '\u{3f}',
        '\u{2032}', '\u{2032}', '\u{2032}', '\u{2032}',
        '\u{30}',
        '\u{34}',
        '\u{35}',
        '\u{36}',
        '\u{37}',
        '\u{38}',
        '\u{39}',
        '\u{2b}',
        '\u{2212}',
        '\u{3d}',
        '\u{28}',
        '\u{29}',
        '\u{6e}',
        '\u{52}', '\u{73}',
        '\u{61}', '\u{2f}', '\u{63}',
        '\u{61}', '\u{2f}', '\u{73}',
        '\u{43}',
        '\u{b0}', '\u{43}',
        '\u{63}', '\u{2f}', '\u{6f}',
        '\u{63}', '\u{2f}', '\u{75}',
        '\u{190}',
        '\u{b0}', '\u{46}',
        '\u{127}',
        '\u{4e}', '\u{6f}',
        '\u{51}',
        '\u{53}', '\u{4d}',
        '\u{54}', '\u{45}', '\u{4c}',
        '\u{54}', '\u{4d}',
        '\u{5a}',
        '\u{46}',
        '\u{5d0}',
        '\u{5d1}',
        '\u{5d2}',
        '\u{5d3}',
        '\u{46}', '\u{41}', '\u{58}',
        '\u{393}',
        '\u{3a0}',
        '\u{2211}',
        '\u{31}', '\u{2044}', '\u{37}',
        '\u{31}', '\u{2044}', '\u{39}',
        '\u{31}', '\u{2044}', '\u{31}', '\u{30}',
        '\u{31}', '\u{2044}', '\u{33}',
        '\u{32}', '\u{2044}', '\u{33}',
        '\u{31}', '\u{2044}', '\u{35}',
        '\u{32}', '\u{2044}', '\u{35}',
        '\u{33}', '\u{2044}', '\u{35}',
        '\u{34}', '\u{2044}', '\u{35}',
        '\u{31}', '\u{2044}', '\u{36}',
        '\u{35}', '\u{2044}', '\u{36}',
        '\u{31}', '\u{2044}', '\u{38}',
        '\u{33}', '\u{2044}', '\u{38}',
        '\u{35}', '\u{2044}', '\u{38}',
        '\u{37}', '\u{2044}', '\u{38}',
        '\u{31}', '\u{2044}',
        '\u{49}', '\u{49}',
        '\u{49}', '\u{49}', '\u{49}',
        '\u{49}', '\u{56}',
        '\u{56}',
        '\u{56}', '\u{49}',
        '\u{56}', '\u{49}', '\u{49}',
        '\u{56}', '\u{49}', '\u{49}', '\u{49}',
        '\u{49}', '\u{58}',
        '\u{58}',
        '\u{58}', '\u{49}',
        '\u{58}', '\u{49}', '\u{49}',
        '\u{69}', '\u{69}',
        '\u{69}', '\u{69}', '\u{69}',
        '\u{69}', '\u{76}',
        '\u{76}', '\u{69}',
        '\u{76}', '\u{69}', '\u{69}',
        '\u{76}', '\u{69}', '\u{69}', '\u{69}',
        '\u{69}', '\u{78}',
        '\u{78}', '\u{69}',
        '\u{78}', '\u{69}', '\u{69}',
        '\u{30}', '\u{2044}', '\u{33}',
        '\u{222b}', '\u{222b}',
        '\u{222b}', '\u{222b}', '\u{222b}',
        '\u{222e}', '\u{222e}',
        '\u{222e}', '\u{222e}', '\u{222e}',
        '\u{31}', '\u{30}',
        '\u{31}', '\u{31}',
        '\u{31}', '\u{32}',
        '\u{31}', '\u{33}',
        '\u{31}', '\u{34}',
        '\u{31}', '\u{35}',
        '\u{31}', '\u{36}',
        '\u{31}', '\u{37}',
        '\u{31}', '\u{38}',
        '\u{31}', '\u{39}',
        '\u{32}', '\u{30}',
        '\u{28}', '\u{31}', '\u{29}',
        '\u{28}', '\u{32}', '\u{29}',
        '\u{28}', '\u{33}', '\u{29}',
        '\u{28}', '\u{34}', '\u{29}',
        '\u{28}', '\u{35}', '\u{29}',
        '\u{28}', '\u{36}', '\u{29}',
        '\u{28}', '\u{37}', '\u{29}',
        '\u{28}', '\u{38}', '\u{29}',
        '\u{28}', '\u{39}', '\u{29}',
        '\u{28}', '\u{31}', '\u{30}', '\u{29}',
        '\u{28}', '\u{31}', '\u{31}', '\u{29}',
        '\u{28}', '\u{31}', '\u{32}', '\u{29}',
        '\u{28}', '\u{31}', '\u{33}', '\u{29}',
        '\u{28}', '\u{31}', '\u{34}', '\u{29}',
        '\u{28}', '\u{31}', '\u{35}', '\u{29}',
        '\u{28}', '\u{31}', '\u{36}', '\u{29}',
        '\u{28}', '\u{31}', '\u{37}', '\u{29}',
        '\u{28}', '\u{31}', '\u{38}', '\u{29}',
        '\u{28}', '\u{31}', '\u{39}', '\u{29}',
        '\u{28}', '\u{32}', '\u{30}', '\u{29}',
        '\u{31}', '\u{2e}',
        '\u{32}', '\u{2e}',
        '\u{33}', '\u{2e}',
        '\u{34}', '\u{2e}',
        '\u{35}', '\u{2e}',
        '\u{36}', '\u{2e}',
        '\u{37}', '\u{2e}',
        '\u{38}', '\u{2e}',
        '\u{39}', '\u{2e}',
        '\u{31}', '\u{30}', '\u{2e}',
        '\u{31}', '\u{31}', '\u{2e}',
        '\u{31}', '\u{32}', '\u{2e}',
        '\u{31}', '\u{33}', '\u{2e}',
        '\u{31}', '\u{34}', '\u{2e}',
        '\u{31}', '\u{35}', '\u{2e}',
        '\u{31}', '\u{36}', '\u{2e}',
        '\u{31}', '\u{37}', '\u{2e}',
        '\u{31}', '\u{38}', '\u{2e}',
        '\u{31}', '\u{39}', '\u{2e}',
        '\u{32}', '\u{30}', '\u{2e}',
        '\u{28}', '\u{61}', '\u{29}',
        '\u{28}', '\u{62}', '\u{29}',
        '\u{28}', '\u{63}', '\u{29}',
        '\u{28}', '\u{64}', '\u{29}',
        '\u{28}', '\u{65}', '\u{29}',
        '\u{28}', '\u{66}', '\u{29}',
        '\u{28}', '\u{67}', '\u{29}',
        '\u{28}', '\u{68}', '\u{29}',
        '\u{28}', '\u{69}', '\u{29}',
        '\u{28}', '\u{6a}', '\u{29}',
        '\u{28}', '\u{6b}', '\u{29}',
        '\u{28}', '\u{6c}', '\u{29}',
        '\u{28}', '\u{6d}', '\u{29}',
        '\u{28}', '\u{6e}', '\u{29}',
        '\u{28}', '\u{6f}', '\u{29}',
        '\u{28}', '\u{70}', '\u{29}',
        '\u{28}', '\u{71}', '\u{29}',
        '\u{28}', '\u{72}', '\u{29}',
        '\u{28}', '\u{73}', '\u{29}',
        '\u{28}', '\u{74}', '\u{29}',
        '\u{28}', '\u{75}', '\u{29}',
        '\u{28}', '\u{76}', '\u{29}',
        '\u{28}', '\u{77}', '\u{29}',
        '\u{28}', '\u{78}', '\u{29}',
        '\u{28}', '\u{79}', '\u{29}',
        '\u{28}', '\u{7a}', '\u{29}',
        '\u{53}',
        '\u{59}',
        '\u{71}',
        '\u{222b}', '\u{222b}', '\u{222b}', '\u{222b}',
        '\u{3a}', '\u{3a}', '\u{3d}',
        '\u{3d}', '\u{3d}',
        '\u{3d}', '\u{3d}', '\u{3d}',
        '\u{2d61}',
        '\u{6bcd}',
        '\u{9f9f}',
        '\u{4e00}',
        '\u{4e28}',
        '\u{4e36}',
        '\u{4e3f}',
        '\u{4e59}',
        '\u{4e85}',
        '\u{4e8c}',
        '\u{4ea0}',
        '\u{4eba}',
        '\u{513f}',
        '\u{5165}',
        '\u{516b}',
        '\u{5182}',
        '\u{5196}',
        '\u{51ab}',
        '\u{51e0}',
        '\u{51f5}',
        '\u{5200}',
        '\u{529b}',
        '\u{52f9}',
        '\u{5315}',
        '\u{531a}',
        '\u{5338}',
        '\u{5341}',
        '\u{535c}',
        '\u{5369}',
        '\u{5382}',
        '\u{53b6}',
        '\u{53c8}',
        '\u{53e3}',
        '\u{56d7}',
        '\u{571f}',
        '\u{58eb}',
        '\u{5902}',
        '\u{590a}',
        '\u{5915}',
        '\u{5927}',
        '\u{5973}',
        '\u{5b50}',
        '\u{5b80}',
        '\u{5bf8}',
        '\u{5c0f}',
        '\u{5c22}',
        '\u{5c38}',
        '\u{5c6e}',
        '\u{5c71}',
        '\u{5ddb}',
        '\u{5de5}',
        '\u{5df1}',
        '\u{5dfe}',
        '\u{5e72}',
        '\u{5e7a}',
        '\u{5e7f}',
        '\u{5ef4}',
        '\u{5efe}',
        '\u{5f0b}',
        '\u{5f13}',
        '\u{5f50}',
        '\u{5f61}',
        '\u{5f73}',
        '\u{5fc3}',
        '\u{6208}',
        '\u{6236}',
        '\u{624b}',
        '\u{652f}',
        '\u{6534}',
        '\u{6587}',
        '\u{6597}',
        '\u{65a4}',
        '\u{65b9}',
        '\u{65e0}',
        '\u{65e5}',
        '\u{66f0}',
        '\u{6708}',
        '\u{6728}',
        '\u{6b20}',
        '\u{6b62}',
        '\u{6b79}',
        '\u{6bb3}',
        '\u{6bcb}',
        '\u{6bd4}',
        '\u{6bdb}',
        '\u{6c0f}',
        '\u{6c14}',
        '\u{6c34}',
        '\u{706b}',
        '\u{722a}',
        '\u{7236}',
        '\u{723b}',
        '\u{723f}',
        '\u{7247}',
        '\u{7259}',
        '\u{725b}',
        '\u{72ac}',
        '\u{7384}',
        '\u{7389}',
        '\u{74dc}',
        '\u{74e6}',
        '\u{7518}',
        '\u{751f}',
        '\u{7528}',
        '\u{7530}',
        '\u{758b}',
        '\u{7592}',
        '\u{7676}',
        '\u{767d}',
        '\u{76ae}',
        '\u{76bf}',
        '\u{76ee}',
        '\u{77db}',
        '\u{77e2}',
        '\u{77f3}',
        '\u{793a}',
        '\u{79b8}',
        '\u{79be}',
        '\u{7a74}',
        '\u{7acb}',
        '\u{7af9}',
        '\u{7c73}',
        '\u{7cf8}',
        '\u{7f36}',
        '\u{7f51}',
        '\u{7f8a}',
        '\u{7fbd}',
        '\u{8001}',
        '\u{800c}',
        '\u{8012}',
        '\u{8033}',
        '\u{807f}',
        '\u{8089}',
        '\u{81e3}',
        '\u{81ea}',
        '\u{81f3}',
        '\u{81fc}',
        '\u{820c}',
        '\u{821b}',
        '\u{821f}',
        '\u{826e}',
        '\u{8272}',
        '\u{8278}',
        '\u{864d}',
        '\u{866b}',
        '\u{8840}',
        '\u{884c}',
        '\u{8863}',
        '\u{897e}',
        '\u{898b}',
        '\u{89d2}',
        '\u{8a00}',
        '\u{8c37}',
        '\u{8c46}',
        '\u{8c55}',
        '\u{8c78}',
        '\u{8c9d}',
        '\u{8d64}',
        '\u{8d70}',
        '\u{8db3}',
        '\u{8eab}',
        '\u{8eca}',
        '\u{8f9b}',
        '\u{8fb0}',
        '\u{8fb5}',
        '\u{9091}',
        '\u{9149}',
        '\u{91c6}',
        '\u{91cc}',
        '\u{91d1}',
        '\u{9577}',
        '\u{9580}',
        '\u{961c}',
        '\u{96b6}',
        '\u{96b9}',
        '\u{96e8}',
        '\u{9751}',
        '\u{975e}',
        '\u{9762}',
        '\u{9769}',
        '\u{97cb}',
        '\u{97ed}',
        '\u{97f3}',
        '\u{9801}',
        '\u{98a8}',
        '\u{98db}',
        '\u{98df}',
        '\u{9996}',
        '\u{9999}',
        '\u{99ac}',
        '\u{9aa8}',
        '\u{9ad8}',
        '\u{9adf}',
        '\u{9b25}',
        '\u{9b2f}',
        '\u{9b32}',
        '\u{9b3c}',
        '\u{9b5a}',
        '\u{9ce5}',
        '\u{9e75}',
        '\u{9e7f}',
        '\u{9ea5}',
        '\u{9ebb}',
        '\u{9ec3}',
        '\u{9ecd}',
        '\u{9ed1}',
        '\u{9ef9}',
        '\u{9efd}',
        '\u{9f0e}',
        '\u{9f13}',
        '\u{9f20}',
        '\u{9f3b}',
        '\u{9f4a}',
        '\u{9f52}',
        '\u{9f8d}',
        '\u{9f9c}',
        '\u{9fa0}',
        '\u{3012}',
        '\u{5344}',
        '\u{5345}',
        '\u{20}', '\u{3099}',
        '\u{20}', '\u{309a}',
        '\u{3088}', '\u{308a}',
        '\u{30b3}', '\u{30c8}',
        '\u{1100}',
        '\u{1101}',
        '\u{11aa}',
        '\u{1102}',
        '\u{11ac}',
        '\u{11ad}',
        '\u{1103}',
        '\u{1104}',
        '\u{1105}',
        '\u{11b0}',
        '\u{11b1}',
        '\u{11b2}',
        '\u{11b3}',
        '\u{11b4}',
        '\u{11b5}',
        '\u{111a}',
        '\u{1106}',
        '\u{1107}',
        '\u{1108}',
        '\u{1121}',
        '\u{1109}',
        '\u{110a}',
        '\u{110b}',
        '\u{110c}',
        '\u{110d}',
        '\u{110e}',
        '\u{110f}',
        '\u{1110}',
        '\u{1111}',
        '\u{1112}',
        '\u{1161}',
        '\u{1162}',
        '\u{1163}',
        '\u{1164}',
        '\u{1165}',
        '\u{1166}',
        '\u{1167}',
        '\u{1168}',
        '\u{1169}',
        '\u{116a}',
        '\u{116b}',
        '\u{116c}',
        '\u{116d}',
        '\u{116e}',
        '\u{116f}',
        '\u{1170}',
        '\u{1171}',
        '\u{1172}',
        '\u{1173}',
        '\u{1174}',
        '\u{1175}',
        '\u{1160}',
        '\u{1114}',
        '\u{1115}',
        '\u{11c7}',
        '\u{11c8}',
        '\u{11cc}',
        '\u{11ce}',
        '\u{11d3}',
        '\u{11d7}',
        '\u{11d9}',
        '\u{111c}',
        '\u{11dd}',
        '\u{11df}',
        '\u{111d}',
        '\u{111e}',
        '\u{1120}',
        '\u{1122}',
        '\u{1123}',
        '\u{1127}',
        '\u{1129}',
        '\u{112b}',
        '\u{112c}',
        '\u{112d}',
        '\u{112e}',
        '\u{112f}',
        '\u{1132}',
        '\u{1136}',
        '\u{1140}',
        '\u{1147}',
        '\u{114c}',
        '\u{11f1}',
        '\u{11f2}',
        '\u{1157}',
        '\u{1158}',
        '\u{1159}',
        '\u{1184}',
        '\u{1185}',
        '\u{1188}',
        '\u{1191}',
        '\u{1192}',
        '\u{1194}',
        '\u{119e}',
        '\u{11a1}',
        '\u{4e09}',
        '\u{56db}',
        '\u{4e0a}',
        '\u{4e2d}',
        '\u{4e0b}',
        '\u{7532}',
        '\u{4e19}',
        '\u{4e01}',
        '\u{5929}',
        '\u{5730}',
        '\u{28}', '\u{1100}', '\u{29}',
        '\u{28}', '\u{1102}', '\u{29}',
        '\u{28}', '\u{1103}', '\u{29}',
        '\u{28}', '\u{1105}', '\u{29}',
        '\u{28}', '\u{1106}', '\u{29}',
        '\u{28}', '\u{1107}', '\u{29}',
        '\u{28}', '\u{1109}', '\u{29}',
        '\u{28}', '\u{110b}', '\u{29}',
        '\u{28}', '\u{110c}', '\u{29}',
        '\u{28}', '\u{110e}', '\u{29}',
        '\u{28}', '\u{110f}', '\u{29}',
        '\u{28}', '\u{1110}', '\u{29}',
        '\u{28}', '\u{1111}', '\u{29}',
        '\u{28}', '\u{1112}', '\u{29}',
        '\u{28}', '\u{1100}', '\u{1161}', '\u{29}',
        '\u{28}', '\u{1102}', '\u{1161}', '\u{29}',
        '\u{28}', '\u{1103}', '\u{1161}', '\u{29}',
        '\u{28}', '\u{1105}', '\u{1161}', '\u{29}',
        '\u{28}', '\u{1106}', '\u{1161}', '\u{29}',
        '\u{28}', '\u{1107}', '\u{1161}', '\u{29}',
        '\u{28}', '\u{1109}', '\u{1161}', '\u{29}',
        '\u{28}', '\u{110b}', '\u{1161}', '\u{29}',
        '\u{28}', '\u{110c}', '\u{1161}', '\u{29}',
        '\u{28}', '\u{110e}', '\u{1161}', '\u{29}',
        '\u{28}', '\u{110f}', '\u{1161}', '\u{29}',
        '\u{28}', '\u{1110}', '\u{1161}', '\u{29}',
        '\u{28}', '\u{1111}', '\u{1161}', '\u{29}',
        '\u{28}', '\u{1112}', '\u{1161}', '\u{29}',
        '\u{28}', '\u{110c}', '\u{116e}', '\u{29}',
        '\u{28}', '\u{110b}', '\u{1169}', '\u{110c}', '\u{1165}', '\u{11ab}', '\u{29}',
        '\u{28}', '\u{110b}', '\u{1169}', '\u{1112}', '\u{116e}', '\u{29}',
        '\u{28}', '\u{4e00}', '\u{29}',
        '\u{28}', '\u{4e8c}', '\u{29}',
        '\u{28}', '\u{4e09}', '\u{29}',
        '\u{28}', '\u{56db}', '\u{29}',
        '\u{28}', '\u{4e94}', '\u{29}',
        '\u{28}', '\u{516d}', '\u{29}',
        '\u{28}', '\u{4e03}', '\u{29}',
        '\u{28}', '\u{516b}', '\u{29}',
        '\u{28}', '\u{4e5d}', '\u{29}',
        '\u{28}', '\u{5341}', '\u{29}',
        '\u{28}', '\u{6708}', '\u{29}',
        '\u{28}', '\u{706b}', '\u{29}',
        '\u{28}', '\u{6c34}', '\u{29}',
        '\u{28}', '\u{6728}', '\u{29}',
        '\u{28}', '\u{91d1}', '\u{29}',
        '\u{28}', '\u{571f}', '\u{29}',
        '\u{28}', '\u{65e5}', '\u{29}',
        '\u{28}', '\u{682a}', '\u{29}',
        '\u{28}', '\u{6709}', '\u{29}',
        '\u{28}', '\u{793e}', '\u{29}',
        '\u{28}', '\u{540d}', '\u{29}',
        '\u{28}', '\u{7279}', '\u{29}',
        '\u{28}', '\u{8ca1}', '\u{29}',
        '\u{28}', '\u{795d}', '\u{29}',
        '\u{28}', '\u{52b4}', '\u{29}',
        '\u{28}', '\u{4ee3}', '\u{29}',
        '\u{28}', '\u{547c}', '\u{29}',
        '\u{28}', '\u{5b66}', '\u{29}',
        '\u{28}', '\u{76e3}', '\u{29}',
        '\u{28}', '\u{4f01}', '\u{29}',
        '\u{28}', '\u{8cc7}', '\u{29}',
        '\u{28}', '\u{5354}', '\u{29}',
        '\u{28}', '\u{796d}', '\u{29}',
        '\u{28}', '\u{4f11}', '\u{29}',
        '\u{28}', '\u{81ea}', '\u{29}',
        '\u{28}', '\u{81f3}', '\u{29}',
        '\u{554f}',
        '\u{5e7c}',
        '\u{7b8f}',
        '\u{50}', '\u{54}', '\u{45}',
        '\u{32}', '\u{31}',
        '\u{32}', '\u{32}',
        '\u{32}', '\u{33}',
        '\u{32}', '\u{34}',
        '\u{32}', '\u{35}',
        '\u{32}', '\u{36}',
        '\u{32}', '\u{37}',
        '\u{32}', '\u{38}',
        '\u{32}', '\u{39}',
        '\u{33}', '\u{30}',
        '\u{33}', '\u{31}',
        '\u{33}', '\u{32}',
        '\u{33}', '\u{33}',
        '\u{33}', '\u{34}',
        '\u{33}', '\u{35}',
        '\u{1100}', '\u{1161}',
        '\u{1102}', '\u{1161}',
        '\u{1103}', '\u{1161}',
        '\u{1105}', '\u{1161}',
        '\u{1106}', '\u{1161}',
        '\u{1107}', '\u{1161}',
        '\u{1109}', '\u{1161}',
        '\u{110b}', '\u{1161}',
        '\u{110c}', '\u{1161}',
        '\u{110e}', '\u{1161}',
        '\u{110f}', '\u{1161}',
        '\u{1110}', '\u{1161}',
        '\u{1111}', '\u{1161}',
        '\u{1112}', '\u{1161}',
        '\u{110e}', '\u{1161}', '\u{11b7}', '\u{1100}', '\u{1169}',
        '\u{110c}', '\u{116e}', '\u{110b}', '\u{1174}',
        '\u{110b}', '\u{116e}',
        '\u{4e94}',
        '\u{516d}',
        '\u{4e03}',
        '\u{4e5d}',
        '\u{682a}',
        '\u{6709}',
        '\u{793e}',
        '\u{540d}',
        '\u{7279}',
        '\u{8ca1}',
        '\u{795d}',
        '\u{52b4}',
        '\u{79d8}',
        '\u{7537}',
        '\u{9069}',
        '\u{512a}',
        '\u{5370}',
        '\u{6ce8}',
        '\u{9805}',
        '\u{4f11}',
        '\u{5199}',
        '\u{6b63}',
        '\u{5de6}',
        '\u{53f3}',
        '\u{533b}',
        '\u{5b97}',
        '\u{5b66}',
        '\u{76e3}',
        '\u{4f01}',
        '\u{8cc7}',
        '\u{5354}',
        '\u{591c}',
        '\u{33}', '\u{36}',
        '\u{33}', '\u{37}',
        '\u{33}', '\u{38}',
        '\u{33}', '\u{39}',
        '\u{34}', '\u{30}',
        '\u{34}', '\u{31}',
        '\u{34}', '\u{32}',
        '\u{34}', '\u{33}',
        '\u{34}', '\u{34}',
        '\u{34}', '\u{35}',
        '\u{34}', '\u{36}',
        '\u{34}', '\u{37}',
        '\u{34}', '\u{38}',
        '\u{34}', '\u{39}',
        '\u{35}', '\u{30}',
        '\u{31}', '\u{6708}',
        '\u{32}', '\u{6708}',
        '\u{33}', '\u{6708}',
        '\u{34}', '\u{6708}',
        '\u{35}', '\u{6708}',
        '\u{36}', '\u{6708}',
        '\u{37}', '\u{6708}',
        '\u{38}', '\u{6708}',
        '\u{39}', '\u{6708}',
        '\u{31}', '\u{30}', '\u{6708}',
        '\u{31}', '\u{31}', '\u{6708}',
        '\u{31}', '\u{32}', '\u{6708}',
        '\u{48}', '\u{67}',
        '\u{65}', '\u{72}', '\u{67}',
        '\u{65}', '\u{56}',
        '\u{4c}', '\u{54}', '\u{44}',
        '\u{30a2}',
        '\u{30a4}',
        '\u{30a6}',
        '\u{30a8}',
        '\u{30aa}',
        '\u{30ab}',
        '\u{30ad}',
        '\u{30af}',
        '\u{30b1}',
        '\u{30b3}',
        '\u{30b5}',
        '\u{30b7}',
        '\u{30b9}',
        '\u{30bb}',
        '\u{30bd}',
        '\u{30bf}',
        '\u{30c1}',
        '\u{30c4}',
        '\u{30c6}',
        '\u{30c8}',
        '\u{30ca}',
        '\u{30cb}',
        '\u{30cc}',
        '\u{30cd}',
        '\u{30ce}',
        '\u{30cf}',
        '\u{30d2}',
        '\u{30d5}',
        '\u{30d8}',
        '\u{30db}',
        '\u{30de}',
        '\u{30df}',
        '\u{30e0}',
        '\u{30e1}',
        '\u{30e2}',
        '\u{30e4}',
        '\u{30e6}',
        '\u{30e8}',
        '\u{30e9}',
        '\u{30ea}',
        '\u{30eb}',
        '\u{30ec}',
        '\u{30ed}',
        '\u{30ef}',
        '\u{30f0}',
        '\u{30f1}',
        '\u{30f2}',
        '\u{30a2}', '\u{30d1}', '\u{30fc}', '\u{30c8}',
        '\u{30a2}', '\u{30eb}', '\u{30d5}', '\u{30a1}',
        '\u{30a2}', '\u{30f3}', '\u{30da}', '\u{30a2}',
        '\u{30a2}', '\u{30fc}', '\u{30eb}',
        '\u{30a4}', '\u{30cb}', '\u{30f3}', '\u{30b0}',
        '\u{30a4}', '\u{30f3}', '\u{30c1}',
        '\u{30a6}', '\u{30a9}', '\u{30f3}',
        '\u{30a8}', '\u{30b9}', '\u{30af}', '\u{30fc}', '\u{30c9}',
        '\u{30a8}', '\u{30fc}', '\u{30ab}', '\u{30fc}',
        '\u{30aa}', '\u{30f3}', '\u{30b9}',
        '\u{30aa}', '\u{30fc}', '\u{30e0}',
        '\u{30ab}', '\u{30a4}', '\u{30ea}',
        '\u{30ab}', '\u{30e9}', '\u{30c3}', '\u{30c8}',
        '\u{30ab}', '\u{30ed}', '\u{30ea}', '\u{30fc}',
        '\u{30ac}', '\u{30ed}', '\u{30f3}',
        '\u{30ac}', '\u{30f3}', '\u{30de}',
        '\u{30ae}', '\u{30ac}',
        '\u{30ae}', '\u{30cb}', '\u{30fc}',
        '\u{30ad}', '\u{30e5}', '\u{30ea}', '\u{30fc}',
        '\u{30ae}', '\u{30eb}', '\u{30c0}', '\u{30fc}',
        '\u{30ad}', '\u{30ed}',
        '\u{30ad}', '\u{30ed}', '\u{30b0}', '\u{30e9}', '\u{30e0}',
        '\u{30ad}', '\u{30ed}', '\u{30e1}', '\u{30fc}', '\u{30c8}', '\u{30eb}',
        '\u{30ad}', '\u{30ed}', '\u{30ef}', '\u{30c3}', '\u{30c8}',
        '\u{30b0}', '\u{30e9}', '\u{30e0}',
        '\u{30b0}', '\u{30e9}', '\u{30e0}', '\u{30c8}', '\u{30f3}',
        '\u{30af}', '\u{30eb}', '\u{30bc}', '\u{30a4}', '\u{30ed}',
        '\u{30af}', '\u{30ed}', '\u{30fc}', '\u{30cd}',
        '\u{30b1}', '\u{30fc}', '\u{30b9}',
        '\u{30b3}', '\u{30eb}', '\u{30ca}',
        '\u{30b3}', '\u{30fc}', '\u{30dd}',
        '\u{30b5}', '\u{30a4}', '\u{30af}', '\u{30eb}',
        '\u{30b5}', '\u{30f3}', '\u{30c1}', '\u{30fc}', '\u{30e0}',
        '\u{30b7}', '\u{30ea}', '\u{30f3}', '\u{30b0}',
        '\u{30bb}', '\u{30f3}', '\u{30c1}',
        '\u{30bb}', '\u{30f3}', '\u{30c8}',
        '\u{30c0}', '\u{30fc}', '\u{30b9}',
        '\u{30c7}', '\u{30b7}',
        '\u{30c9}', '\u{30eb}',
        '\u{30c8}', '\u{30f3}',
        '\u{30ca}', '\u{30ce}',
        '\u{30ce}', '\u{30c3}', '\u{30c8}',
        '\u{30cf}', '\u{30a4}', '\u{30c4}',
        '\u{30d1}', '\u{30fc}', '\u{30bb}', '\u{30f3}', '\u{30c8}',
        '\u{30d1}', '\u{30fc}', '\u{30c4}',
        '\u{30d0}', '\u{30fc}', '\u{30ec}', '\u{30eb}',
        '\u{30d4}', '\u{30a2}', '\u{30b9}', '\u{30c8}', '\u{30eb}',
        '\u{30d4}', '\u{30af}', '\u{30eb}',
        '\u{30d4}', '\u{30b3}',
        '\u{30d3}', '\u{30eb}',
        '\u{30d5}', '\u{30a1}', '\u{30e9}', '\u{30c3}', '\u{30c9}',
        '\u{30d5}', '\u{30a3}', '\u{30fc}', '\u{30c8}',
        '\u{30d6}', '\u{30c3}', '\u{30b7}', '\u{30a7}', '\u{30eb}',
        '\u{30d5}', '\u{30e9}', '\u{30f3}',
        '\u{30d8}', '\u{30af}', '\u{30bf}', '\u{30fc}', '\u{30eb}',
        '\u{30da}', '\u{30bd}',
        '\u{30da}', '\u{30cb}', '\u{30d2}',
        '\u{30d8}', '\u{30eb}', '\u{30c4}',
        '\u{30da}', '\u{30f3}', '\u{30b9}',
        '\u{30da}', '\u{30fc}', '\u{30b8}',
        '\u{30d9}', '\u{30fc}', '\u{30bf}',
        '\u{30dd}', '\u{30a4}', '\u{30f3}', '\u{30c8}',
        '\u{30dc}', '\u{30eb}', '\u{30c8}',
        '\u{30db}', '\u{30f3}',
        '\u{30dd}', '\u{30f3}', '\u{30c9}',
        '\u{30db}', '\u{30fc}', '\u{30eb}',
        '\u{30db}', '\u{30fc}', '\u{30f3}',
        '\u{30de}', '\u{30a4}', '\u{30af}', '\u{30ed}',
        '\u{30de}', '\u{30a4}', '\u{30eb}',
        '\u{30de}', '\u{30c3}', '\u{30cf}',
        '\u{30de}', '\u{30eb}', '\u{30af}',
        '\u{30de}', '\u{30f3}', '\u{30b7}', '\u{30e7}', '\u{30f3}',
        '\u{30df}', '\u{30af}', '\u{30ed}', '\u{30f3}',
        '\u{30df}', '\u{30ea}',
        '\u{30df}', '\u{30ea}', '\u{30d0}', '\u{30fc}', '\u{30eb}',
        '\u{30e1}', '\u{30ac}',
        '\u{30e1}', '\u{30ac}', '\u{30c8}', '\u{30f3}',
        '\u{30e1}', '\u{30fc}', '\u{30c8}', '\u{30eb}',
        '\u{30e4}', '\u{30fc}', '\u{30c9}',
        '\u{30e4}', '\u{30fc}', '\u{30eb}',
        '\u{30e6}', '\u{30a2}', '\u{30f3}',
        '\u{30ea}', '\u{30c3}', '\u{30c8}', '\u{30eb}',
        '\u{30ea}', '\u{30e9}',
        '\u{30eb}', '\u{30d4}', '\u{30fc}',
        '\u{30eb}', '\u{30fc}', '\u{30d6}', '\u{30eb}',
        '\u{30ec}', '\u{30e0}',
        '\u{30ec}', '\u{30f3}', '\u{30c8}', '\u{30b2}', '\u{30f3}',
        '\u{30ef}', '\u{30c3}', '\u{30c8}',
        '\u{30}', '\u{70b9}',
        '\u{31}', '\u{70b9}',
        '\u{32}', '\u{70b9}',
        '\u{33}', '\u{70b9}',
        '\u{34}', '\u{70b9}',
        '\u{35}', '\u{70b9}',
        '\u{36}', '\u{70b9}',
        '\u{37}', '\u{70b9}',
        '\u{38}', '\u{70b9}',
        '\u{39}', '\u{70b9}',
        '\u{31}', '\u{30}', '\u{70b9}',
        '\u{31}', '\u{31}', '\u{70b9}',
        '\u{31}', '\u{32}', '\u{70b9}',
        '\u{31}', '\u{33}', '\u{70b9}',
        '\u{31}', '\u{34}', '\u{70b9}',
        '\u{31}', '\u{35}', '\u{70b9}',
        '\u{31}', '\u{36}', '\u{70b9}',
        '\u{31}', '\u{37}', '\u{70b9}',
        '\u{31}', '\u{38}', '\u{70b9}',
        '\u{31}', '\u{39}', '\u{70b9}',
        '\u{32}', '\u{30}', '\u{70b9}',
        '\u{32}', '\u{31}', '\u{70b9}',
        '\u{32}', '\u{32}', '\u{70b9}',
        '\u{32}', '\u{33}', '\u{70b9}',
        '\u{32}', '\u{34}', '\u{70b9}',
        '\u{68}', '\u{50}', '\u{61}',
        '\u{64}', '\u{61}',
        '\u{41}', '\u{55}',
        '\u{62}', '\u{61}', '\u{72}',
        '\u{6f}', '\u{56}',
        '\u{70}', '\u{63}',
        '\u{64}', '\u{6d}',
        '\u{64}', '\u{6d}', '\u{b2}',
        '\u{64}', '\u{6d}', '\u{b3}',
        '\u{49}', '\u{55}',
        '\u{5e73}', '\u{6210}',
        '\u{662d}', '\u{548c}',
        '\u{5927}', '\u{6b63}',
        '\u{660e}', '\u{6cbb}',
        '\u{682a}', '\u{5f0f}', '\u{4f1a}', '\u{793e}',
        '\u{70}', '\u{41}',
        '\u{6e}', '\u{41}',
        '\u{3bc}', '\u{41}',
        '\u{6d}', '\u{41}',
        '\u{6b}', '\u{41}',
        '\u{4b}', '\u{42}',
        '\u{4d}', '\u{42}',
        '\u{47}', '\u{42}',
        '\u{63}', '\u{61}', '\u{6c}',
        '\u{6b}', '\u{63}', '\u{61}', '\u{6c}',
        '\u{70}', '\u{46}',
        '\u{6e}', '\u{46}',
        '\u{3bc}', '\u{46}',
        '\u{3bc}', '\u{67}',
        '\u{6d}', '\u{67}',
        '\u{6b}', '\u{67}',
        '\u{48}', '\u{7a}',
        '\u{6b}', '\u{48}', '\u{7a}',
        '\u{4d}', '\u{48}', '\u{7a}',
        '\u{47}', '\u{48}', '\u{7a}',
        '\u{54}', '\u{48}', '\u{7a}',
        '\u{3bc}', '\u{2113}',
        '\u{6d}', '\u{2113}',
        '\u{64}', '\u{2113}',
        '\u{6b}', '\u{2113}',
        '\u{66}', '\u{6d}',
        '\u{6e}', '\u{6d}',
        '\u{3bc}', '\u{6d}',
        '\u{6d}', '\u{6d}',
        '\u{63}', '\u{6d}',
        '\u{6b}', '\u{6d}',
        '\u{6d}', '\u{6d}', '\u{b2}',
        '\u{63}', '\u{6d}', '\u{b2}',
        '\u{6d}', '\u{b2}',
        '\u{6b}', '\u{6d}', '\u{b2}',
        '\u{6d}', '\u{6d}', '\u{b3}',
        '\u{63}', '\u{6d}', '\u{b3}',
        '\u{6d}', '\u{b3}',
        '\u{6b}', '\u{6d}', '\u{b3}',
        '\u{6d}', '\u{2215}', '\u{73}',
        '\u{6d}', '\u{2215}', '\u{73}', '\u{b2}',
        '\u{50}', '\u{61}',
        '\u{6b}', '\u{50}', '\u{61}',
        '\u{4d}', '\u{50}', '\u{61}',
        '\u{47}', '\u{50}', '\u{61}',
        '\u{72}', '\u{61}', '\u{64}',
        '\u{72}', '\u{61}', '\u{64}', '\u{2215}', '\u{73}',
        '\u{72}', '\u{61}', '\u{64}', '\u{2215}', '\u{73}', '\u{b2}',
        '\u{70}', '\u{73}',
        '\u{6e}', '\u{73}',
        '\u{3bc}', '\u{73}',
        '\u{6d}', '\u{73}',
        '\u{70}', '\u{56}',
        '\u{6e}', '\u{56}',
        '\u{3bc}', '\u{56}',
        '\u{6d}', '\u{56}',
        '\u{6b}', '\u{56}',
        '\u{4d}', '\u{56}',
        '\u{70}', '\u{57}',
        '\u{6e}', '\u{57}',
        '\u{3bc}', '\u{57}',
        '\u{6d}', '\u{57}',
        '\u{6b}', '\u{57}',
        '\u{4d}', '\u{57}',
        '\u{6b}', '\u{3a9}',
        '\u{4d}', '\u{3a9}',
        '\u{61}', '\u{2e}', '\u{6d}', '\u{2e}',
        '\u{42}', '\u{71}',
        '\u{63}', '\u{63}',
        '\u{63}', '\u{64}',
        '\u{43}', '\u{2215}', '\u{6b}', '\u{67}',
        '\u{43}', '\u{6f}', '\u{2e}',
        '\u{64}', '\u{42}',
        '\u{47}', '\u{79}',
        '\u{68}', '\u{61}',
        '\u{48}', '\u{50}',
        '\u{69}', '\u{6e}',
        '\u{4b}', '\u{4b}',
        '\u{4b}', '\u{4d}',
        '\u{6b}', '\u{74}',
        '\u{6c}', '\u{6d}',
        '\u{6c}', '\u{6e}',
        '\u{6c}', '\u{6f}', '\u{67}',
        '\u{6c}', '\u{78}',
        '\u{6d}', '\u{62}',
        '\u{6d}', '\u{69}', '\u{6c}',
        '\u{6d}', '\u{6f}', '\u{6c}',
        '\u{50}', '\u{48}',
        '\u{70}', '\u{2e}', '\u{6d}', '\u{2e}',
        '\u{50}', '\u{50}', '\u{4d}',
        '\u{50}', '\u{52}',
        '\u{73}', '\u{72}',
        '\u{53}', '\u{76}',
        '\u{57}', '\u{62}',
        '\u{56}', '\u{2215}', '\u{6d}',
        '\u{41}', '\u{2215}', '\u{6d}',
        '\u{31}', '\u{65e5}',
        '\u{32}', '\u{65e5}',
        '\u{33}', '\u{65e5}',
        '\u{34}', '\u{65e5}',
        '\u{35}', '\u{65e5}',
        '\u{36}', '\u{65e5}',
        '\u{37}', '\u{65e5}',
        '\u{38}', '\u{65e5}',
        '\u{39}', '\u{65e5}',
        '\u{31}', '\u{30}', '\u{65e5}',
        '\u{31}', '\u{31}', '\u{65e5}',
        '\u{31}', '\u{32}', '\u{65e5}',
        '\u{31}', '\u{33}', '\u{65e5}',
        '\u{31}', '\u{34}', '\u{65e5}',
        '\u{31}', '\u{35}', '\u{65e5}',
        '\u{31}', '\u{36}', '\u{65e5}',
        '\u{31}', '\u{37}', '\u{65e5}',
        '\u{31}', '\u{38}', '\u{65e5}',
        '\u{31}', '\u{39}', '\u{65e5}',
        '\u{32}', '\u{30}', '\u{65e5}',
        '\u{32}', '\u{31}', '\u{65e5}',
        '\u{32}', '\u{32}', '\u{65e5}',
        '\u{32}', '\u{33}', '\u{65e5}',
        '\u{32}', '\u{34}', '\u{65e5}',
        '\u{32}', '\u{35}', '\u{65e5}',
        '\u{32}', '\u{36}', '\u{65e5}',
        '\u{32}', '\u{37}', '\u{65e5}',
        '\u{32}', '\u{38}', '\u{65e5}',
        '\u{32}', '\u{39}', '\u{65e5}',
        '\u{33}', '\u{30}', '\u{65e5}',
        '\u{33}', '\u{31}', '\u{65e5}',
        '\u{67}', '\u{61}', '\u{6c}',
        '\u{44a}',
        '\u{44c}',
        '\u{a76f}',
        '\u{126}',
        '\u{153}',
        '\u{a727}',
        '\u{ab37}',
        '\u{26b}',
        '\u{ab52}',
        '\u{66}', '\u{66}',
        '\u{66}', '\u{69}',
        '\u{66}', '\u{6c}',
        '\u{66}', '\u{66}', '\u{69}',
        '\u{66}', '\u{66}', '\u{6c}',
        '\u{17f}', '\u{74}',
        '\u{73}', '\u{74}',
        '\u{574}', '\u{576}',
        '\u{574}', '\u{565}',
        '\u{574}', '\u{56b}',
        '\u{57e}', '\u{576}',
        '\u{574}', '\u{56d}',
        '\u{5e2}',
        '\u{5d4}',
        '\u{5db}',
        '\u{5dc}',
        '\u{5dd}',
        '\u{5e8}',
        '\u{5ea}',
        '\u{5d0}', '\u{5dc}',
        '\u{671}',
        '\u{67b}',
        '\u{67e}',
        '\u{680}',
        '\u{67a}',
        '\u{67f}',
        '\u{679}',
        '\u{6a4}',
        '\u{6a6}',
        '\u{684}',
        '\u{683}',
        '\u{686}',
        '\u{687}',
        '\u{68d}',
        '\u{68c}',
        '\u{68e}',
        '\u{688}',
        '\u{698}',
        '\u{691}',
        '\u{6a9}',
        '\u{6af}',
        '\u{6b3}',
        '\u{6b1}',
        '\u{6ba}',
        '\u{6bb}',
        '\u{6c0}',
        '\u{6c1}',
        '\u{6be}',
        '\u{6d2}',
        '\u{6d3}',
        '\u{6ad}',
        '\u{6c7}',
        '\u{6c6}',
        '\u{6c8}',
        '\u{677}',
        '\u{6cb}',
        '\u{6c5}',
        '\u{6c9}',
        '\u{6d0}',
        '\u{649}',
        '\u{626}', '\u{627}',
        '\u{626}', '\u{6d5}',
        '\u{626}', '\u{648}',
        '\u{626}', '\u{6c7}',
        '\u{626}', '\u{6c6}',
        '\u{626}', '\u{6c8}',
        '\u{626}', '\u{6d0}',
        '\u{626}', '\u{649}',
        '\u{6cc}',
        '\u{626}', '\u{62c}',
        '\u{626}', '\u{62d}',
        '\u{626}', '\u{645}',
        '\u{626}', '\u{64a}',
        '\u{628}', '\u{62c}',
        '\u{628}', '\u{62d}',
        '\u{628}', '\u{62e}',
        '\u{628}', '\u{645}',
        '\u{628}', '\u{649}',
        '\u{628}', '\u{64a}',
        '\u{62a}', '\u{62c}',
        '\u{62a}', '\u{62d}',
        '\u{62a}', '\u{62e}',
        '\u{62a}', '\u{645}',
        '\u{62a}', '\u{649}',
        '\u{62a}', '\u{64a}',
        '\u{62b}', '\u{62c}',
        '\u{62b}', '\u{645}',
        '\u{62b}', '\u{649}',
        '\u{62b}', '\u{64a}',
        '\u{62c}', '\u{62d}',
        '\u{62c}', '\u{645}',
        '\u{62d}', '\u{62c}',
        '\u{62d}', '\u{645}',
        '\u{62e}', '\u{62c}',
        '\u{62e}', '\u{62d}',
        '\u{62e}', '\u{645}',
        '\u{633}', '\u{62c}',
        '\u{633}', '\u{62d}',
        '\u{633}', '\u{62e}',
        '\u{633}', '\u{645}',
        '\u{635}', '\u{62d}',
        '\u{635}', '\u{645}',
        '\u{636}', '\u{62c}',
        '\u{636}', '\u{62d}',
        '\u{636}', '\u{62e}',
        '\u{636}', '\u{645}',
        '\u{637}', '\u{62d}',
        '\u{637}', '\u{645}',
        '\u{638}', '\u{645}',
        '\u{639}', '\u{62c}',
        '\u{639}', '\u{645}',
        '\u{63a}', '\u{62c}',
        '\u{63a}', '\u{645}',
        '\u{641}', '\u{62c}',
        '\u{641}', '\u{62d}',
        '\u{641}', '\u{62e}',
        '\u{641}', '\u{645}',
        '\u{641}', '\u{649}',
        '\u{641}', '\u{64a}',
        '\u{642}', '\u{62d}',
        '\u{642}', '\u{645}',
        '\u{642}', '\u{649}',
        '\u{642}', '\u{64a}',
        '\u{643}', '\u{627}',
        '\u{643}', '\u{62c}',
        '\u{643}', '\u{62d}',
        '\u{643}', '\u{62e}',
        '\u{643}', '\u{644}',
        '\u{643}', '\u{645}',
        '\u{643}', '\u{649}',
        '\u{643}', '\u{64a}',
        '\u{644}', '\u{62c}',
        '\u{644}', '\u{62d}',
        '\u{644}', '\u{62e}',
        '\u{644}', '\u{645}',
        '\u{644}', '\u{649}',
        '\u{644}', '\u{64a}',
        '\u{645}', '\u{62c}',
        '\u{645}', '\u{62d}',
        '\u{645}', '\u{62e}',
        '\u{645}', '\u{645}',
        '\u{645}', '\u{649}',
        '\u{645}', '\u{64a}',
        '\u{646}', '\u{62c}',
        '\u{646}', '\u{62d}',
        '\u{646}', '\u{62e}',
        '\u{646}', '\u{645}',
        '\u{646}', '\u{649}',
        '\u{646}', '\u{64a}',
        '\u{647}', '\u{62c}',
        '\u{647}', '\u{645}',
        '\u{647}', '\u{649}',
        '\u{647}', '\u{64a}',
        '\u{64a}', '\u{62c}',
        '\u{64a}', '\u{62d}',
        '\u{64a}', '\u{62e}',
        '\u{64a}', '\u{645}',
        '\u{64a}', '\u{649}',
        '\u{64a}', '\u{64a}',
        '\u{630}', '\u{670}',
        '\u{631}', '\u{670}',
        '\u{649}', '\u{670}',
        '\u{20}', '\u{64c}', '\u{651}',
        '\u{20}', '\u{64d}', '\u{651}',
        '\u{20}', '\u{64e}', '\u{651}',
        '\u{20}', '\u{64f}', '\u{651}',
        '\u{20}', '\u{650}', '\u{651}',
        '\u{20}', '\u{651}', '\u{670}',
        '\u{626}', '\u{631}',
        '\u{626}', '\u{632}',
        '\u{626}', '\u{646}',
        '\u{628}', '\u{631}',
        '\u{628}', '\u{632}',
        '\u{628}', '\u{646}',
        '\u{62a}', '\u{631}',
        '\u{62a}', '\u{632}',
        '\u{62a}', '\u{646}',
        '\u{62b}', '\u{631}',
        '\u{62b}', '\u{632}',
        '\u{62b}', '\u{646}',
        '\u{645}', '\u{627}',
        '\u{646}', '\u{631}',
        '\u{646}', '\u{632}',
        '\u{646}', '\u{646}',
        '\u{64a}', '\u{631}',
        '\u{64a}', '\u{632}',
        '\u{64a}', '\u{646}',
        '\u{626}', '\u{62e}',
        '\u{626}', '\u{647}',
        '\u{628}', '\u{647}',
        '\u{62a}', '\u{647}',
        '\u{635}', '\u{62e}',
        '\u{644}', '\u{647}',
        '\u{646}', '\u{647}',
        '\u{647}', '\u{670}',
        '\u{64a}', '\u{647}',
        '\u{62b}', '\u{647}',
        '\u{633}', '\u{647}',
        '\u{634}', '\u{645}',
        '\u{634}', '\u{647}',
        '\u{640}', '\u{64e}', '\u{651}',
        '\u{640}', '\u{64f}', '\u{651}',
        '\u{640}', '\u{650}', '\u{651}',
        '\u{637}', '\u{649}',
        '\u{637}', '\u{64a}',
        '\u{639}', '\u{649}',
        '\u{639}', '\u{64a}',
        '\u{63a}', '\u{649}',
        '\u{63a}', '\u{64a}',
        '\u{633}', '\u{649}',
        '\u{633}', '\u{64a}',
        '\u{634}', '\u{649}',
        '\u{634}', '\u{64a}',
        '\u{62d}', '\u{649}',
        '\u{62d}', '\u{64a}',
        '\u{62c}', '\u{649}',
        '\u{62c}', '\u{64a}',
        '\u{62e}', '\u{649}',
        '\u{62e}', '\u{64a}',
        '\u{635}', '\u{649}',
        '\u{635}', '\u{64a}',
        '\u{636}', '\u{649}',
        '\u{636}', '\u{64a}',
        '\u{634}', '\u{62c}',
        '\u{634}', '\u{62d}',
        '\u{634}', '\u{62e}',
        '\u{634}', '\u{631}',
        '\u{633}', '\u{631}',
        '\u{635}', '\u{631}',
        '\u{636}', '\u{631}',
        '\u{627}', '\u{64b}',
        '\u{62a}', '\u{62c}', '\u{645}',
        '\u{62a}', '\u{62d}', '\u{62c}',
        '\u{62a}', '\u{62d}', '\u{645}',
        '\u{62a}', '\u{62e}', '\u{645}',
        '\u{62a}', '\u{645}', '\u{62c}',
        '\u{62a}', '\u{645}', '\u{62d}',
        '\u{62a}', '\u{645}', '\u{62e}',
        '\u{62c}', '\u{645}', '\u{62d}',
        '\u{62d}', '\u{645}', '\u{64a}',
        '\u{62d}', '\u{645}', '\u{649}',
        '\u{633}', '\u{62d}', '\u{62c}',
        '\u{633}', '\u{62c}', '\u{62d}',
        '\u{633}', '\u{62c}', '\u{649}',
        '\u{633}', '\u{645}', '\u{62d}',
        '\u{633}', '\u{645}', '\u{62c}',
        '\u{633}', '\u{645}', '\u{645}',
        '\u{635}', '\u{62d}', '\u{62d}',
        '\u{635}', '\u{645}', '\u{645}',
        '\u{634}', '\u{62d}', '\u{645}',
        '\u{634}', '\u{62c}', '\u{64a}',
        '\u{634}', '\u{645}', '\u{62e}',
        '\u{634}', '\u{645}', '\u{645}',
        '\u{636}', '\u{62d}', '\u{649}',
        '\u{636}', '\u{62e}', '\u{645}',
        '\u{637}', '\u{645}', '\u{62d}',
        '\u{637}', '\u{645}', '\u{645}',
        '\u{637}', '\u{645}', '\u{64a}',
        '\u{639}', '\u{62c}', '\u{645}',
        '\u{639}', '\u{645}', '\u{645}',
        '\u{639}', '\u{645}', '\u{649}',
        '\u{63a}', '\u{645}', '\u{645}',
        '\u{63a}', '\u{645}', '\u{64a}',
        '\u{63a}', '\u{645}', '\u{649}',
        '\u{641}', '\u{62e}', '\u{645}',
        '\u{642}', '\u{645}', '\u{62d}',
        '\u{642}', '\u{645}', '\u{645}',
        '\u{644}', '\u{62d}', '\u{645}',
        '\u{644}', '\u{62d}', '\u{64a}',
        '\u{644}', '\u{62d}', '\u{649}',
        '\u{644}', '\u{62c}', '\u{62c}',
        '\u{644}', '\u{62e}', '\u{645}',
        '\u{644}', '\u{645}', '\u{62d}',
        '\u{645}', '\u{62d}', '\u{62c}',
        '\u{645}', '\u{62d}', '\u{645}',
        '\u{645}', '\u{62d}', '\u{64a}',
        '\u{645}', '\u{62c}', '\u{62d}',
        '\u{645}', '\u{62c}', '\u{645}',
        '\u{645}', '\u{62e}', '\u{62c}',
        '\u{645}', '\u{62e}', '\u{645}',
        '\u{645}', '\u{62c}', '\u{62e}',
        '\u{647}', '\u{645}', '\u{62c}',
        '\u{647}', '\u{645}', '\u{645}',
        '\u{646}', '\u{62d}', '\u{645}',
        '\u{646}', '\u{62d}', '\u{649}',
        '\u{646}', '\u{62c}', '\u{645}',
        '\u{646}', '\u{62c}', '\u{649}',
        '\u{646}', '\u{645}', '\u{64a}',
        '\u{646}', '\u{645}', '\u{649}',
        '\u{64a}', '\u{645}', '\u{645}',
        '\u{628}', '\u{62e}', '\u{64a}',
        '\u{62a}', '\u{62c}', '\u{64a}',
        '\u{62a}', '\u{62c}', '\u{649}',
        '\u{62a}', '\u{62e}', '\u{64a}',
        '\u{62a}', '\u{62e}', '\u{649}',
        '\u{62a}', '\u{645}', '\u{64a}',
        '\u{62a}', '\u{645}', '\u{649}',
        '\u{62c}', '\u{645}', '\u{64a}',
        '\u{62c}', '\u{62d}', '\u{649}',
        '\u{62c}', '\u{645}', '\u{649}',
        '\u{633}', '\u{62e}', '\u{649}',
        '\u{635}', '\u{62d}', '\u{64a}',
        '\u{634}', '\u{62d}', '\u{64a}',
        '\u{636}', '\u{62d}', '\u{64a}',
        '\u{644}', '\u{62c}', '\u{64a}',
        '\u{644}', '\u{645}', '\u{64a}',
        '\u{64a}', '\u{62d}', '\u{64a}',
        '\u{64a}', '\u{62c}', '\u{64a}',
        '\u{64a}', '\u{645}', '\u{64a}',
        '\u{645}', '\u{645}', '\u{64a}',
        '\u{642}', '\u{645}', '\u{64a}',
        '\u{646}', '\u{62d}', '\u{64a}',
        '\u{639}', '\u{645}', '\u{64a}',
        '\u{643}', '\u{645}', '\u{64a}',
        '\u{646}', '\u{62c}', '\u{62d}',
        '\u{645}', '\u{62e}', '\u{64a}',
        '\u{644}', '\u{62c}', '\u{645}',
        '\u{643}', '\u{645}', '\u{645}',
        '\u{62c}', '\u{62d}', '\u{64a}',
        '\u{62d}', '\u{62c}', '\u{64a}',
        '\u{645}', '\u{62c}', '\u{64a}',
        '\u{641}', '\u{645}', '\u{64a}',
        '\u{628}', '\u{62d}', '\u{64a}',
        '\u{633}', '\u{62e}', '\u{64a}',
        '\u{646}', '\u{62c}', '\u{64a}',
        '\u{635}', '\u{644}', '\u{6d2}',
        '\u{642}', '\u{644}', '\u{6d2}',
        '\u{627}', '\u{644}', '\u{644}', '\u{647}',
        '\u{627}', '\u{643}', '\u{628}', '\u{631}',
        '\u{645}', '\u{62d}', '\u{645}', '\u{62f}',
        '\u{635}', '\u{644}', '\u{639}', '\u{645}',
        '\u{631}', '\u{633}', '\u{648}', '\u{644}',
        '\u{639}', '\u{644}', '\u{64a}', '\u{647}',
        '\u{648}', '\u{633}', '\u{644}', '\u{645}',
        '\u{635}', '\u{644}', '\u{649}',
        '\u{635}', '\u{644}', '\u{649}', '\u{20}', '\u{627}', '\u{644}', '\u{644}', '\u{647}', '\u{20}', '\u{639}', '\u{644}', '\u{64a}', '\u{647}', '\u{20}', '\u{648}', '\u{633}', '\u{644}', '\u{645}',
        '\u{62c}', '\u{644}', '\u{20}', '\u{62c}', '\u{644}', '\u{627}', '\u{644}', '\u{647}',
        '\u{631}', '\u{6cc}', '\u{627}', '\u{644}',
        '\u{2c}',
        '\u{3001}',
        '\u{3002}',
        '\u{3a}',
        '\u{3b}',
        '\u{21}',
        '\u{3f}',
        '\u{3016}',
        '\u{3017}',
        '\u{2026}',
        '\u{2025}',
        '\u{2014}',
        '\u{2013}',
        '\u{5f}',
        '\u{7b}',
        '\u{7d}',
        '\u{3014}',
        '\u{3015}',
        '\u{3010}',
        '\u{3011}',
        '\u{300a}',
        '\u{300b}',
        '\u{3008}',
        '\u{3009}',
        '\u{300c}',
        '\u{300d}',
        '\u{300e}',
        '\u{300f}',
        '\u{5b}',
        '\u{5d}',
        '\u{203e}',
        '\u{23}',
        '\u{26}',
        '\u{2a}',
        '\u{2d}',
        '\u{3c}',
        '\u{3e}',
        '\u{5c}',
        '\u{24}',
        '\u{25}',
        '\u{40}',
        '\u{20}', '\u{64b}',
        '\u{640}', '\u{64b}',
        '\u{20}', '\u{64c}',
        '\u{20}', '\u{64d}',
        '\u{20}', '\u{64e}',
        '\u{640}', '\u{64e}',
        '\u{20}', '\u{64f}',
        '\u{640}', '\u{64f}',
        '\u{20}', '\u{650}',
        '\u{640}', '\u{650}',
        '\u{20}', '\u{651}',
        '\u{640}', '\u{651}',
        '\u{20}', '\u{652}',
        '\u{640}', '\u{652}',
        '\u{621}',
        '\u{622}',
        '\u{623}',
        '\u{624}',
        '\u{625}',
        '\u{626}',
        '\u{627}',
        '\u{628}',
        '\u{629}',
        '\u{62a}',
        '\u{62b}',
        '\u{62c}',
        '\u{62d}',
        '\u{62e}',
        '\u{62f}',
        '\u{630}',
        '\u{631}',
        '\u{632}',
        '\u{633}',
        '\u{634}',
        '\u{635}',
        '\u{636}',
        '\u{637}',
        '\u{638}',
        '\u{639}',
        '\u{63a}',
        '\u{641}',
        '\u{642}',
        '\u{643}',
        '\u{644}',
        '\u{645}',
        '\u{646}',
        '\u{647}',
        '\u{648}',
        '\u{64a}',
        '\u{644}', '\u{622}',
        '\u{644}', '\u{623}',
        '\u{644}', '\u{625}',
        '\u{644}', '\u{627}',
        '\u{22}',
        '\u{27}',
        '\u{2f}',
        '\u{5e}',
        '\u{60}',
        '\u{7c}',
        '\u{7e}',
        '\u{2985}',
        '\u{2986}',
        '\u{30fb}',
        '\u{30a1}',
        '\u{30a3}',
        '\u{30a5}',
        '\u{30a7}',
        '\u{30a9}',
        '\u{30e3}',
        '\u{30e5}',
        '\u{30e7}',
        '\u{30c3}',
        '\u{30fc}',
        '\u{30f3}',
        '\u{3099}',
        '\u{309a}',
        '\u{3164}',
        '\u{3131}',
        '\u{3132}',
        '\u{3133}',
        '\u{3134}',
        '\u{3135}',
        '\u{3136}',
        '\u{3137}',
        '\u{3138}',
        '\u{3139}',
        '\u{313a}',
        '\u{313b}',
        '\u{313c}',
        '\u{313d}',
        '\u{313e}',
        '\u{313f}',
        '\u{3140}',
        '\u{3141}',
        '\u{3142}',
        '\u{3143}',
        '\u{3144}',
        '\u{3145}',
        '\u{3146}',
        '\u{3147}',
        '\u{3148}',
        '\u{3149}',
        '\u{314a}',
        '\u{314b}',
        '\u{314c}',
        '\u{314d}',
        '\u{314e}',
        '\u{314f}',
        '\u{3150}',
        '\u{3151}',
        '\u{3152}',
        '\u{3153}',
        '\u{3154}',
        '\u{3155}',
        '\u{3156}',
        '\u{3157}',
        '\u{3158}',
        '\u{3159}',
        '\u{315a}',
        '\u{315b}',
        '\u{315c}',
        '\u{315d}',
        '\u{315e}',
        '\u{315f}',
        '\u{3160}',
        '\u{3161}',
        '\u{3162}',
        '\u{3163}',
        '\u{a2}',
        '\u{a3}',
        '\u{ac}',
        '\u{af}',
        '\u{a6}',
        '\u{a5}',
        '\u{20a9}',
        '\u{2502}',
        '\u{2190}',
        '\u{2191}',
        '\u{2192}',
        '\u{2193}',
        '\u{25a0}',
        '\u{25cb}',
        '\u{131}',
        '\u{237}',
        '\u{391}',
        '\u{392}',
        '\u{394}',
        '\u{395}',
        '\u{396}',
        '\u{397}',
        '\u{399}',
        '\u{39a}',
        '\u{39b}',
        '\u{39c}',
        '\u{39d}',
        '\u{39e}',
        '\u{39f}',
        '\u{3a1}',
        '\u{3f4}',
        '\u{3a4}',
        '\u{3a6}',
        '\u{3a7}',
        '\u{3a8}',
        '\u{3a9}',
        '\u{2207}',
        '\u{3b1}',
        '\u{3b6}',
        '\u{3b7}',
        '\u{3b9}',
        '\u{3bb}',
        '\u{3bd}',
        '\u{3be}',
        '\u{3bf}',
        '\u{3c3}',
        '\u{3c4}',
        '\u{3c5}',
        '\u{3c8}',
        '\u{3c9}',
        '\u{2202}',
        '\u{3f5}',
        '\u{3d1}',
        '\u{3f0}',
        '\u{3d5}',
        '\u{3f1}',
        '\u{3d6}',
        '\u{3dc}',
        '\u{3dd}',
        '\u{66e}',
        '\u{6a1}',
        '\u{66f}',
        '\u{30}', '\u{2e}',
        '\u{30}', '\u{2c}',
        '\u{31}', '\u{2c}',
        '\u{32}', '\u{2c}',
        '\u{33}', '\u{2c}',
        '\u{34}', '\u{2c}',
        '\u{35}', '\u{2c}',
        '\u{36}', '\u{2c}',
        '\u{37}', '\u{2c}',
        '\u{38}', '\u{2c}',
        '\u{39}', '\u{2c}',
        '\u{28}', '\u{41}', '\u{29}',
        '\u{28}', '\u{42}', '\u{29}',
        '\u{28}', '\u{43}', '\u{29}',
        '\u{28}', '\u{44}', '\u{29}',
        '\u{28}', '\u{45}', '\u{29}',
        '\u{28}', '\u{46}', '\u{29}',
        '\u{28}', '\u{47}', '\u{29}',
        '\u{28}', '\u{48}', '\u{29}',
        '\u{28}', '\u{49}', '\u{29}',
        '\u{28}', '\u{4a}', '\u{29}',
        '\u{28}', '\u{4b}', '\u{29}',
        '\u{28}', '\u{4c}', '\u{29}',
        '\u{28}', '\u{4d}', '\u{29}',
        '\u{28}', '\u{4e}', '\u{29}',
        '\u{28}', '\u{4f}', '\u{29}',
        '\u{28}', '\u{50}', '\u{29}',
        '\u{28}', '\u{51}', '\u{29}',
        '\u{28}', '\u{52}', '\u{29}',
        '\u{28}', '\u{53}', '\u{29}',
        '\u{28}', '\u{54}', '\u{29}',
        '\u{28}', '\u{55}', '\u{29}',
        '\u{28}', '\u{56}', '\u{29}',
        '\u{28}', '\u{57}', '\u{29}',
        '\u{28}', '\u{58}', '\u{29}',
        '\u{28}', '\u{59}', '\u{29}',
        '\u{28}', '\u{5a}', '\u{29}',
        '\u{3014}', '\u{53}', '\u{3015}',
        '\u{43}', '\u{44}',
        '\u{57}', '\u{5a}',
        '\u{48}', '\u{56}',
        '\u{53}', '\u{44}',
        '\u{53}', '\u{53}',
        '\u{50}', '\u{50}', '\u{56}',
        '\u{57}', '\u{43}',
        '\u{4d}', '\u{43}',
        '\u{4d}', '\u{44}',
        '\u{44}', '\u{4a}',
        '\u{307b}', '\u{304b}',
        '\u{30b3}', '\u{30b3}',
        '\u{5b57}',
        '\u{53cc}',
        '\u{30c7}',
        '\u{591a}',
        '\u{89e3}',
        '\u{4ea4}',
        '\u{6620}',
        '\u{7121}',
        '\u{6599}',
        '\u{524d}',
        '\u{5f8c}',
        '\u{518d}',
        '\u{65b0}',
        '\u{521d}',
        '\u{7d42}',
        '\u{8ca9}',
        '\u{58f0}',
        '\u{5439}',
        '\u{6f14}',
        '\u{6295}',
        '\u{6355}',
        '\u{904a}',
        '\u{6307}',
        '\u{6253}',
        '\u{7981}',
        '\u{7a7a}',
        '\u{5408}',
        '\u{6e80}',
        '\u{7533}',
        '\u{5272}',
        '\u{55b6}',
        '\u{914d}',
        '\u{3014}', '\u{672c}', '\u{3015}',
        '\u{3014}', '\u{4e09}', '\u{3015}',
        '\u{3014}', '\u{4e8c}', '\u{3015}',
        '\u{3014}', '\u{5b89}', '\u{3015}',
        '\u{3014}', '\u{70b9}', '\u{3015}',
        '\u{3014}', '\u{6253}', '\u{3015}',
        '\u{3014}', '\u{76d7}', '\u{3015}',
        '\u{3014}', '\u{52dd}', '\u{3015}',
        '\u{3014}', '\u{6557}', '\u{3015}',
        '\u{5f97}',
        '\u{53ef}',

    ];

    // Canonical compositions
    pub  const composition_table: &'static [(char, Slice)] = &[
        ('\u{3c}', Slice { offset: 0, length: 1 }),
        ('\u{3d}', Slice { offset: 1, length: 1 }),
        ('\u{3e}', Slice { offset: 2, length: 1 }),
        ('\u{41}', Slice { offset: 3, length: 16 }),
        ('\u{42}', Slice { offset: 19, length: 3 }),
        ('\u{43}', Slice { offset: 22, length: 5 }),
        ('\u{44}', Slice { offset: 27, length: 6 }),
        ('\u{45}', Slice { offset: 33, length: 17 }),
        ('\u{46}', Slice { offset: 50, length: 1 }),
        ('\u{47}', Slice { offset: 51, length: 7 }),
        ('\u{48}', Slice { offset: 58, length: 7 }),
        ('\u{49}', Slice { offset: 65, length: 15 }),
        ('\u{4a}', Slice { offset: 80, length: 1 }),
        ('\u{4b}', Slice { offset: 81, length: 5 }),
        ('\u{4c}', Slice { offset: 86, length: 6 }),
        ('\u{4d}', Slice { offset: 92, length: 3 }),
        ('\u{4e}', Slice { offset: 95, length: 9 }),
        ('\u{4f}', Slice { offset: 104, length: 16 }),
        ('\u{50}', Slice { offset: 120, length: 2 }),
        ('\u{52}', Slice { offset: 122, length: 8 }),
        ('\u{53}', Slice { offset: 130, length: 7 }),
        ('\u{54}', Slice { offset: 137, length: 7 }),
        ('\u{55}', Slice { offset: 144, length: 19 }),
        ('\u{56}', Slice { offset: 163, length: 2 }),
        ('\u{57}', Slice { offset: 165, length: 6 }),
        ('\u{58}', Slice { offset: 171, length: 2 }),
        ('\u{59}', Slice { offset: 173, length: 9 }),
        ('\u{5a}', Slice { offset: 182, length: 6 }),
        ('\u{61}', Slice { offset: 188, length: 16 }),
        ('\u{62}', Slice { offset: 204, length: 3 }),
        ('\u{63}', Slice { offset: 207, length: 5 }),
        ('\u{64}', Slice { offset: 212, length: 6 }),
        ('\u{65}', Slice { offset: 218, length: 17 }),
        ('\u{66}', Slice { offset: 235, length: 1 }),
        ('\u{67}', Slice { offset: 236, length: 7 }),
        ('\u{68}', Slice { offset: 243, length: 8 }),
        ('\u{69}', Slice { offset: 251, length: 14 }),
        ('\u{6a}', Slice { offset: 265, length: 2 }),
        ('\u{6b}', Slice { offset: 267, length: 5 }),
        ('\u{6c}', Slice { offset: 272, length: 6 }),
        ('\u{6d}', Slice { offset: 278, length: 3 }),
        ('\u{6e}', Slice { offset: 281, length: 9 }),
        ('\u{6f}', Slice { offset: 290, length: 16 }),
        ('\u{70}', Slice { offset: 306, length: 2 }),
        ('\u{72}', Slice { offset: 308, length: 8 }),
        ('\u{73}', Slice { offset: 316, length: 7 }),
        ('\u{74}', Slice { offset: 323, length: 8 }),
        ('\u{75}', Slice { offset: 331, length: 19 }),
        ('\u{76}', Slice { offset: 350, length: 2 }),
        ('\u{77}', Slice { offset: 352, length: 7 }),
        ('\u{78}', Slice { offset: 359, length: 2 }),
        ('\u{79}', Slice { offset: 361, length: 10 }),
        ('\u{7a}', Slice { offset: 371, length: 6 }),
        ('\u{a8}', Slice { offset: 377, length: 3 }),
        ('\u{c2}', Slice { offset: 380, length: 4 }),
        ('\u{c4}', Slice { offset: 384, length: 1 }),
        ('\u{c5}', Slice { offset: 385, length: 1 }),
        ('\u{c6}', Slice { offset: 386, length: 2 }),
        ('\u{c7}', Slice { offset: 388, length: 1 }),
        ('\u{ca}', Slice { offset: 389, length: 4 }),
        ('\u{cf}', Slice { offset: 393, length: 1 }),
        ('\u{d4}', Slice { offset: 394, length: 4 }),
        ('\u{d5}', Slice { offset: 398, length: 3 }),
        ('\u{d6}', Slice { offset: 401, length: 1 }),
        ('\u{d8}', Slice { offset: 402, length: 1 }),
        ('\u{dc}', Slice { offset: 403, length: 4 }),
        ('\u{e2}', Slice { offset: 407, length: 4 }),
        ('\u{e4}', Slice { offset: 411, length: 1 }),
        ('\u{e5}', Slice { offset: 412, length: 1 }),
        ('\u{e6}', Slice { offset: 413, length: 2 }),
        ('\u{e7}', Slice { offset: 415, length: 1 }),
        ('\u{ea}', Slice { offset: 416, length: 4 }),
        ('\u{ef}', Slice { offset: 420, length: 1 }),
        ('\u{f4}', Slice { offset: 421, length: 4 }),
        ('\u{f5}', Slice { offset: 425, length: 3 }),
        ('\u{f6}', Slice { offset: 428, length: 1 }),
        ('\u{f8}', Slice { offset: 429, length: 1 }),
        ('\u{fc}', Slice { offset: 430, length: 4 }),
        ('\u{102}', Slice { offset: 434, length: 4 }),
        ('\u{103}', Slice { offset: 438, length: 4 }),
        ('\u{112}', Slice { offset: 442, length: 2 }),
        ('\u{113}', Slice { offset: 444, length: 2 }),
        ('\u{14c}', Slice { offset: 446, length: 2 }),
        ('\u{14d}', Slice { offset: 448, length: 2 }),
        ('\u{15a}', Slice { offset: 450, length: 1 }),
        ('\u{15b}', Slice { offset: 451, length: 1 }),
        ('\u{160}', Slice { offset: 452, length: 1 }),
        ('\u{161}', Slice { offset: 453, length: 1 }),
        ('\u{168}', Slice { offset: 454, length: 1 }),
        ('\u{169}', Slice { offset: 455, length: 1 }),
        ('\u{16a}', Slice { offset: 456, length: 1 }),
        ('\u{16b}', Slice { offset: 457, length: 1 }),
        ('\u{17f}', Slice { offset: 458, length: 1 }),
        ('\u{1a0}', Slice { offset: 459, length: 5 }),
        ('\u{1a1}', Slice { offset: 464, length: 5 }),
        ('\u{1af}', Slice { offset: 469, length: 5 }),
        ('\u{1b0}', Slice { offset: 474, length: 5 }),
        ('\u{1b7}', Slice { offset: 479, length: 1 }),
        ('\u{1ea}', Slice { offset: 480, length: 1 }),
        ('\u{1eb}', Slice { offset: 481, length: 1 }),
        ('\u{226}', Slice { offset: 482, length: 1 }),
        ('\u{227}', Slice { offset: 483, length: 1 }),
        ('\u{228}', Slice { offset: 484, length: 1 }),
        ('\u{229}', Slice { offset: 485, length: 1 }),
        ('\u{22e}', Slice { offset: 486, length: 1 }),
        ('\u{22f}', Slice { offset: 487, length: 1 }),
        ('\u{292}', Slice { offset: 488, length: 1 }),
        ('\u{391}', Slice { offset: 489, length: 7 }),
        ('\u{395}', Slice { offset: 496, length: 4 }),
        ('\u{397}', Slice { offset: 500, length: 5 }),
        ('\u{399}', Slice { offset: 505, length: 7 }),
        ('\u{39f}', Slice { offset: 512, length: 4 }),
        ('\u{3a1}', Slice { offset: 516, length: 1 }),
        ('\u{3a5}', Slice { offset: 517, length: 6 }),
        ('\u{3a9}', Slice { offset: 523, length: 5 }),
        ('\u{3ac}', Slice { offset: 528, length: 1 }),
        ('\u{3ae}', Slice { offset: 529, length: 1 }),
        ('\u{3b1}', Slice { offset: 530, length: 8 }),
        ('\u{3b5}', Slice { offset: 538, length: 4 }),
        ('\u{3b7}', Slice { offset: 542, length: 6 }),
        ('\u{3b9}', Slice { offset: 548, length: 8 }),
        ('\u{3bf}', Slice { offset: 556, length: 4 }),
        ('\u{3c1}', Slice { offset: 560, length: 2 }),
        ('\u{3c5}', Slice { offset: 562, length: 8 }),
        ('\u{3c9}', Slice { offset: 570, length: 6 }),
        ('\u{3ca}', Slice { offset: 576, length: 3 }),
        ('\u{3cb}', Slice { offset: 579, length: 3 }),
        ('\u{3ce}', Slice { offset: 582, length: 1 }),
        ('\u{3d2}', Slice { offset: 583, length: 2 }),
        ('\u{406}', Slice { offset: 585, length: 1 }),
        ('\u{410}', Slice { offset: 586, length: 2 }),
        ('\u{413}', Slice { offset: 588, length: 1 }),
        ('\u{415}', Slice { offset: 589, length: 3 }),
        ('\u{416}', Slice { offset: 592, length: 2 }),
        ('\u{417}', Slice { offset: 594, length: 1 }),
        ('\u{418}', Slice { offset: 595, length: 4 }),
        ('\u{41a}', Slice { offset: 599, length: 1 }),
        ('\u{41e}', Slice { offset: 600, length: 1 }),
        ('\u{423}', Slice { offset: 601, length: 4 }),
        ('\u{427}', Slice { offset: 605, length: 1 }),
        ('\u{42b}', Slice { offset: 606, length: 1 }),
        ('\u{42d}', Slice { offset: 607, length: 1 }),
        ('\u{430}', Slice { offset: 608, length: 2 }),
        ('\u{433}', Slice { offset: 610, length: 1 }),
        ('\u{435}', Slice { offset: 611, length: 3 }),
        ('\u{436}', Slice { offset: 614, length: 2 }),
        ('\u{437}', Slice { offset: 616, length: 1 }),
        ('\u{438}', Slice { offset: 617, length: 4 }),
        ('\u{43a}', Slice { offset: 621, length: 1 }),
        ('\u{43e}', Slice { offset: 622, length: 1 }),
        ('\u{443}', Slice { offset: 623, length: 4 }),
        ('\u{447}', Slice { offset: 627, length: 1 }),
        ('\u{44b}', Slice { offset: 628, length: 1 }),
        ('\u{44d}', Slice { offset: 629, length: 1 }),
        ('\u{456}', Slice { offset: 630, length: 1 }),
        ('\u{474}', Slice { offset: 631, length: 1 }),
        ('\u{475}', Slice { offset: 632, length: 1 }),
        ('\u{4d8}', Slice { offset: 633, length: 1 }),
        ('\u{4d9}', Slice { offset: 634, length: 1 }),
        ('\u{4e8}', Slice { offset: 635, length: 1 }),
        ('\u{4e9}', Slice { offset: 636, length: 1 }),
        ('\u{627}', Slice { offset: 637, length: 3 }),
        ('\u{648}', Slice { offset: 640, length: 1 }),
        ('\u{64a}', Slice { offset: 641, length: 1 }),
        ('\u{6c1}', Slice { offset: 642, length: 1 }),
        ('\u{6d2}', Slice { offset: 643, length: 1 }),
        ('\u{6d5}', Slice { offset: 644, length: 1 }),
        ('\u{928}', Slice { offset: 645, length: 1 }),
        ('\u{930}', Slice { offset: 646, length: 1 }),
        ('\u{933}', Slice { offset: 647, length: 1 }),
        ('\u{9c7}', Slice { offset: 648, length: 2 }),
        ('\u{b47}', Slice { offset: 650, length: 3 }),
        ('\u{b92}', Slice { offset: 653, length: 1 }),
        ('\u{bc6}', Slice { offset: 654, length: 2 }),
        ('\u{bc7}', Slice { offset: 656, length: 1 }),
        ('\u{c46}', Slice { offset: 657, length: 1 }),
        ('\u{cbf}', Slice { offset: 658, length: 1 }),
        ('\u{cc6}', Slice { offset: 659, length: 3 }),
        ('\u{cca}', Slice { offset: 662, length: 1 }),
        ('\u{d46}', Slice { offset: 663, length: 2 }),
        ('\u{d47}', Slice { offset: 665, length: 1 }),
        ('\u{dd9}', Slice { offset: 666, length: 3 }),
        ('\u{ddc}', Slice { offset: 669, length: 1 }),
        ('\u{1025}', Slice { offset: 670, length: 1 }),
        ('\u{1b05}', Slice { offset: 671, length: 1 }),
        ('\u{1b07}', Slice { offset: 672, length: 1 }),
        ('\u{1b09}', Slice { offset: 673, length: 1 }),
        ('\u{1b0b}', Slice { offset: 674, length: 1 }),
        ('\u{1b0d}', Slice { offset: 675, length: 1 }),
        ('\u{1b11}', Slice { offset: 676, length: 1 }),
        ('\u{1b3a}', Slice { offset: 677, length: 1 }),
        ('\u{1b3c}', Slice { offset: 678, length: 1 }),
        ('\u{1b3e}', Slice { offset: 679, length: 1 }),
        ('\u{1b3f}', Slice { offset: 680, length: 1 }),
        ('\u{1b42}', Slice { offset: 681, length: 1 }),
        ('\u{1e36}', Slice { offset: 682, length: 1 }),
        ('\u{1e37}', Slice { offset: 683, length: 1 }),
        ('\u{1e5a}', Slice { offset: 684, length: 1 }),
        ('\u{1e5b}', Slice { offset: 685, length: 1 }),
        ('\u{1e62}', Slice { offset: 686, length: 1 }),
        ('\u{1e63}', Slice { offset: 687, length: 1 }),
        ('\u{1ea0}', Slice { offset: 688, length: 2 }),
        ('\u{1ea1}', Slice { offset: 690, length: 2 }),
        ('\u{1eb8}', Slice { offset: 692, length: 1 }),
        ('\u{1eb9}', Slice { offset: 693, length: 1 }),
        ('\u{1ecc}', Slice { offset: 694, length: 1 }),
        ('\u{1ecd}', Slice { offset: 695, length: 1 }),
        ('\u{1f00}', Slice { offset: 696, length: 4 }),
        ('\u{1f01}', Slice { offset: 700, length: 4 }),
        ('\u{1f02}', Slice { offset: 704, length: 1 }),
        ('\u{1f03}', Slice { offset: 705, length: 1 }),
        ('\u{1f04}', Slice { offset: 706, length: 1 }),
        ('\u{1f05}', Slice { offset: 707, length: 1 }),
        ('\u{1f06}', Slice { offset: 708, length: 1 }),
        ('\u{1f07}', Slice { offset: 709, length: 1 }),
        ('\u{1f08}', Slice { offset: 710, length: 4 }),
        ('\u{1f09}', Slice { offset: 714, length: 4 }),
        ('\u{1f0a}', Slice { offset: 718, length: 1 }),
        ('\u{1f0b}', Slice { offset: 719, length: 1 }),
        ('\u{1f0c}', Slice { offset: 720, length: 1 }),
        ('\u{1f0d}', Slice { offset: 721, length: 1 }),
        ('\u{1f0e}', Slice { offset: 722, length: 1 }),
        ('\u{1f0f}', Slice { offset: 723, length: 1 }),
        ('\u{1f10}', Slice { offset: 724, length: 2 }),
        ('\u{1f11}', Slice { offset: 726, length: 2 }),
        ('\u{1f18}', Slice { offset: 728, length: 2 }),
        ('\u{1f19}', Slice { offset: 730, length: 2 }),
        ('\u{1f20}', Slice { offset: 732, length: 4 }),
        ('\u{1f21}', Slice { offset: 736, length: 4 }),
        ('\u{1f22}', Slice { offset: 740, length: 1 }),
        ('\u{1f23}', Slice { offset: 741, length: 1 }),
        ('\u{1f24}', Slice { offset: 742, length: 1 }),
        ('\u{1f25}', Slice { offset: 743, length: 1 }),
        ('\u{1f26}', Slice { offset: 744, length: 1 }),
        ('\u{1f27}', Slice { offset: 745, length: 1 }),
        ('\u{1f28}', Slice { offset: 746, length: 4 }),
        ('\u{1f29}', Slice { offset: 750, length: 4 }),
        ('\u{1f2a}', Slice { offset: 754, length: 1 }),
        ('\u{1f2b}', Slice { offset: 755, length: 1 }),
        ('\u{1f2c}', Slice { offset: 756, length: 1 }),
        ('\u{1f2d}', Slice { offset: 757, length: 1 }),
        ('\u{1f2e}', Slice { offset: 758, length: 1 }),
        ('\u{1f2f}', Slice { offset: 759, length: 1 }),
        ('\u{1f30}', Slice { offset: 760, length: 3 }),
        ('\u{1f31}', Slice { offset: 763, length: 3 }),
        ('\u{1f38}', Slice { offset: 766, length: 3 }),
        ('\u{1f39}', Slice { offset: 769, length: 3 }),
        ('\u{1f40}', Slice { offset: 772, length: 2 }),
        ('\u{1f41}', Slice { offset: 774, length: 2 }),
        ('\u{1f48}', Slice { offset: 776, length: 2 }),
        ('\u{1f49}', Slice { offset: 778, length: 2 }),
        ('\u{1f50}', Slice { offset: 780, length: 3 }),
        ('\u{1f51}', Slice { offset: 783, length: 3 }),
        ('\u{1f59}', Slice { offset: 786, length: 3 }),
        ('\u{1f60}', Slice { offset: 789, length: 4 }),
        ('\u{1f61}', Slice { offset: 793, length: 4 }),
        ('\u{1f62}', Slice { offset: 797, length: 1 }),
        ('\u{1f63}', Slice { offset: 798, length: 1 }),
        ('\u{1f64}', Slice { offset: 799, length: 1 }),
        ('\u{1f65}', Slice { offset: 800, length: 1 }),
        ('\u{1f66}', Slice { offset: 801, length: 1 }),
        ('\u{1f67}', Slice { offset: 802, length: 1 }),
        ('\u{1f68}', Slice { offset: 803, length: 4 }),
        ('\u{1f69}', Slice { offset: 807, length: 4 }),
        ('\u{1f6a}', Slice { offset: 811, length: 1 }),
        ('\u{1f6b}', Slice { offset: 812, length: 1 }),
        ('\u{1f6c}', Slice { offset: 813, length: 1 }),
        ('\u{1f6d}', Slice { offset: 814, length: 1 }),
        ('\u{1f6e}', Slice { offset: 815, length: 1 }),
        ('\u{1f6f}', Slice { offset: 816, length: 1 }),
        ('\u{1f70}', Slice { offset: 817, length: 1 }),
        ('\u{1f74}', Slice { offset: 818, length: 1 }),
        ('\u{1f7c}', Slice { offset: 819, length: 1 }),
        ('\u{1fb6}', Slice { offset: 820, length: 1 }),
        ('\u{1fbf}', Slice { offset: 821, length: 3 }),
        ('\u{1fc6}', Slice { offset: 824, length: 1 }),
        ('\u{1ff6}', Slice { offset: 825, length: 1 }),
        ('\u{1ffe}', Slice { offset: 826, length: 3 }),
        ('\u{2190}', Slice { offset: 829, length: 1 }),
        ('\u{2192}', Slice { offset: 830, length: 1 }),
        ('\u{2194}', Slice { offset: 831, length: 1 }),
        ('\u{21d0}', Slice { offset: 832, length: 1 }),
        ('\u{21d2}', Slice { offset: 833, length: 1 }),
        ('\u{21d4}', Slice { offset: 834, length: 1 }),
        ('\u{2203}', Slice { offset: 835, length: 1 }),
        ('\u{2208}', Slice { offset: 836, length: 1 }),
        ('\u{220b}', Slice { offset: 837, length: 1 }),
        ('\u{2223}', Slice { offset: 838, length: 1 }),
        ('\u{2225}', Slice { offset: 839, length: 1 }),
        ('\u{223c}', Slice { offset: 840, length: 1 }),
        ('\u{2243}', Slice { offset: 841, length: 1 }),
        ('\u{2245}', Slice { offset: 842, length: 1 }),
        ('\u{2248}', Slice { offset: 843, length: 1 }),
        ('\u{224d}', Slice { offset: 844, length: 1 }),
        ('\u{2261}', Slice { offset: 845, length: 1 }),
        ('\u{2264}', Slice { offset: 846, length: 1 }),
        ('\u{2265}', Slice { offset: 847, length: 1 }),
        ('\u{2272}', Slice { offset: 848, length: 1 }),
        ('\u{2273}', Slice { offset: 849, length: 1 }),
        ('\u{2276}', Slice { offset: 850, length: 1 }),
        ('\u{2277}', Slice { offset: 851, length: 1 }),
        ('\u{227a}', Slice { offset: 852, length: 1 }),
        ('\u{227b}', Slice { offset: 853, length: 1 }),
        ('\u{227c}', Slice { offset: 854, length: 1 }),
        ('\u{227d}', Slice { offset: 855, length: 1 }),
        ('\u{2282}', Slice { offset: 856, length: 1 }),
        ('\u{2283}', Slice { offset: 857, length: 1 }),
        ('\u{2286}', Slice { offset: 858, length: 1 }),
        ('\u{2287}', Slice { offset: 859, length: 1 }),
        ('\u{2291}', Slice { offset: 860, length: 1 }),
        ('\u{2292}', Slice { offset: 861, length: 1 }),
        ('\u{22a2}', Slice { offset: 862, length: 1 }),
        ('\u{22a8}', Slice { offset: 863, length: 1 }),
        ('\u{22a9}', Slice { offset: 864, length: 1 }),
        ('\u{22ab}', Slice { offset: 865, length: 1 }),
        ('\u{22b2}', Slice { offset: 866, length: 1 }),
        ('\u{22b3}', Slice { offset: 867, length: 1 }),
        ('\u{22b4}', Slice { offset: 868, length: 1 }),
        ('\u{22b5}', Slice { offset: 869, length: 1 }),
        ('\u{3046}', Slice { offset: 870, length: 1 }),
        ('\u{304b}', Slice { offset: 871, length: 1 }),
        ('\u{304d}', Slice { offset: 872, length: 1 }),
        ('\u{304f}', Slice { offset: 873, length: 1 }),
        ('\u{3051}', Slice { offset: 874, length: 1 }),
        ('\u{3053}', Slice { offset: 875, length: 1 }),
        ('\u{3055}', Slice { offset: 876, length: 1 }),
        ('\u{3057}', Slice { offset: 877, length: 1 }),
        ('\u{3059}', Slice { offset: 878, length: 1 }),
        ('\u{305b}', Slice { offset: 879, length: 1 }),
        ('\u{305d}', Slice { offset: 880, length: 1 }),
        ('\u{305f}', Slice { offset: 881, length: 1 }),
        ('\u{3061}', Slice { offset: 882, length: 1 }),
        ('\u{3064}', Slice { offset: 883, length: 1 }),
        ('\u{3066}', Slice { offset: 884, length: 1 }),
        ('\u{3068}', Slice { offset: 885, length: 1 }),
        ('\u{306f}', Slice { offset: 886, length: 2 }),
        ('\u{3072}', Slice { offset: 888, length: 2 }),
        ('\u{3075}', Slice { offset: 890, length: 2 }),
        ('\u{3078}', Slice { offset: 892, length: 2 }),
        ('\u{307b}', Slice { offset: 894, length: 2 }),
        ('\u{309d}', Slice { offset: 896, length: 1 }),
        ('\u{30a6}', Slice { offset: 897, length: 1 }),
        ('\u{30ab}', Slice { offset: 898, length: 1 }),
        ('\u{30ad}', Slice { offset: 899, length: 1 }),
        ('\u{30af}', Slice { offset: 900, length: 1 }),
        ('\u{30b1}', Slice { offset: 901, length: 1 }),
        ('\u{30b3}', Slice { offset: 902, length: 1 }),
        ('\u{30b5}', Slice { offset: 903, length: 1 }),
        ('\u{30b7}', Slice { offset: 904, length: 1 }),
        ('\u{30b9}', Slice { offset: 905, length: 1 }),
        ('\u{30bb}', Slice { offset: 906, length: 1 }),
        ('\u{30bd}', Slice { offset: 907, length: 1 }),
        ('\u{30bf}', Slice { offset: 908, length: 1 }),
        ('\u{30c1}', Slice { offset: 909, length: 1 }),
        ('\u{30c4}', Slice { offset: 910, length: 1 }),
        ('\u{30c6}', Slice { offset: 911, length: 1 }),
        ('\u{30c8}', Slice { offset: 912, length: 1 }),
        ('\u{30cf}', Slice { offset: 913, length: 2 }),
        ('\u{30d2}', Slice { offset: 915, length: 2 }),
        ('\u{30d5}', Slice { offset: 917, length: 2 }),
        ('\u{30d8}', Slice { offset: 919, length: 2 }),
        ('\u{30db}', Slice { offset: 921, length: 2 }),
        ('\u{30ef}', Slice { offset: 923, length: 1 }),
        ('\u{30f0}', Slice { offset: 924, length: 1 }),
        ('\u{30f1}', Slice { offset: 925, length: 1 }),
        ('\u{30f2}', Slice { offset: 926, length: 1 }),
        ('\u{30fd}', Slice { offset: 927, length: 1 }),
        ('\u{11099}', Slice { offset: 928, length: 1 }),
        ('\u{1109b}', Slice { offset: 929, length: 1 }),
        ('\u{110a5}', Slice { offset: 930, length: 1 }),
        ('\u{11131}', Slice { offset: 931, length: 1 }),
        ('\u{11132}', Slice { offset: 932, length: 1 }),
        ('\u{11347}', Slice { offset: 933, length: 2 }),
        ('\u{114b9}', Slice { offset: 935, length: 3 }),
        ('\u{115b8}', Slice { offset: 938, length: 1 }),
        ('\u{115b9}', Slice { offset: 939, length: 1 }),

    ];

    pub  const composition_table_STRTAB: &'static [(char, char)] = &[
        ('\u{338}','\u{226e}'),
        ('\u{338}','\u{2260}'),
        ('\u{338}','\u{226f}'),
        ('\u{300}','\u{c0}'), ('\u{301}','\u{c1}'), ('\u{302}','\u{c2}'), ('\u{303}','\u{c3}'), ('\u{304}','\u{100}'), ('\u{306}','\u{102}'), ('\u{307}','\u{226}'), ('\u{308}','\u{c4}'), ('\u{309}','\u{1ea2}'), ('\u{30a}','\u{c5}'), ('\u{30c}','\u{1cd}'), ('\u{30f}','\u{200}'), ('\u{311}','\u{202}'), ('\u{323}','\u{1ea0}'), ('\u{325}','\u{1e00}'), ('\u{328}','\u{104}'),
        ('\u{307}','\u{1e02}'), ('\u{323}','\u{1e04}'), ('\u{331}','\u{1e06}'),
        ('\u{301}','\u{106}'), ('\u{302}','\u{108}'), ('\u{307}','\u{10a}'), ('\u{30c}','\u{10c}'), ('\u{327}','\u{c7}'),
        ('\u{307}','\u{1e0a}'), ('\u{30c}','\u{10e}'), ('\u{323}','\u{1e0c}'), ('\u{327}','\u{1e10}'), ('\u{32d}','\u{1e12}'), ('\u{331}','\u{1e0e}'),
        ('\u{300}','\u{c8}'), ('\u{301}','\u{c9}'), ('\u{302}','\u{ca}'), ('\u{303}','\u{1ebc}'), ('\u{304}','\u{112}'), ('\u{306}','\u{114}'), ('\u{307}','\u{116}'), ('\u{308}','\u{cb}'), ('\u{309}','\u{1eba}'), ('\u{30c}','\u{11a}'), ('\u{30f}','\u{204}'), ('\u{311}','\u{206}'), ('\u{323}','\u{1eb8}'), ('\u{327}','\u{228}'), ('\u{328}','\u{118}'), ('\u{32d}','\u{1e18}'), ('\u{330}','\u{1e1a}'),
        ('\u{307}','\u{1e1e}'),
        ('\u{301}','\u{1f4}'), ('\u{302}','\u{11c}'), ('\u{304}','\u{1e20}'), ('\u{306}','\u{11e}'), ('\u{307}','\u{120}'), ('\u{30c}','\u{1e6}'), ('\u{327}','\u{122}'),
        ('\u{302}','\u{124}'), ('\u{307}','\u{1e22}'), ('\u{308}','\u{1e26}'), ('\u{30c}','\u{21e}'), ('\u{323}','\u{1e24}'), ('\u{327}','\u{1e28}'), ('\u{32e}','\u{1e2a}'),
        ('\u{300}','\u{cc}'), ('\u{301}','\u{cd}'), ('\u{302}','\u{ce}'), ('\u{303}','\u{128}'), ('\u{304}','\u{12a}'), ('\u{306}','\u{12c}'), ('\u{307}','\u{130}'), ('\u{308}','\u{cf}'), ('\u{309}','\u{1ec8}'), ('\u{30c}','\u{1cf}'), ('\u{30f}','\u{208}'), ('\u{311}','\u{20a}'), ('\u{323}','\u{1eca}'), ('\u{328}','\u{12e}'), ('\u{330}','\u{1e2c}'),
        ('\u{302}','\u{134}'),
        ('\u{301}','\u{1e30}'), ('\u{30c}','\u{1e8}'), ('\u{323}','\u{1e32}'), ('\u{327}','\u{136}'), ('\u{331}','\u{1e34}'),
        ('\u{301}','\u{139}'), ('\u{30c}','\u{13d}'), ('\u{323}','\u{1e36}'), ('\u{327}','\u{13b}'), ('\u{32d}','\u{1e3c}'), ('\u{331}','\u{1e3a}'),
        ('\u{301}','\u{1e3e}'), ('\u{307}','\u{1e40}'), ('\u{323}','\u{1e42}'),
        ('\u{300}','\u{1f8}'), ('\u{301}','\u{143}'), ('\u{303}','\u{d1}'), ('\u{307}','\u{1e44}'), ('\u{30c}','\u{147}'), ('\u{323}','\u{1e46}'), ('\u{327}','\u{145}'), ('\u{32d}','\u{1e4a}'), ('\u{331}','\u{1e48}'),
        ('\u{300}','\u{d2}'), ('\u{301}','\u{d3}'), ('\u{302}','\u{d4}'), ('\u{303}','\u{d5}'), ('\u{304}','\u{14c}'), ('\u{306}','\u{14e}'), ('\u{307}','\u{22e}'), ('\u{308}','\u{d6}'), ('\u{309}','\u{1ece}'), ('\u{30b}','\u{150}'), ('\u{30c}','\u{1d1}'), ('\u{30f}','\u{20c}'), ('\u{311}','\u{20e}'), ('\u{31b}','\u{1a0}'), ('\u{323}','\u{1ecc}'), ('\u{328}','\u{1ea}'),
        ('\u{301}','\u{1e54}'), ('\u{307}','\u{1e56}'),
        ('\u{301}','\u{154}'), ('\u{307}','\u{1e58}'), ('\u{30c}','\u{158}'), ('\u{30f}','\u{210}'), ('\u{311}','\u{212}'), ('\u{323}','\u{1e5a}'), ('\u{327}','\u{156}'), ('\u{331}','\u{1e5e}'),
        ('\u{301}','\u{15a}'), ('\u{302}','\u{15c}'), ('\u{307}','\u{1e60}'), ('\u{30c}','\u{160}'), ('\u{323}','\u{1e62}'), ('\u{326}','\u{218}'), ('\u{327}','\u{15e}'),
        ('\u{307}','\u{1e6a}'), ('\u{30c}','\u{164}'), ('\u{323}','\u{1e6c}'), ('\u{326}','\u{21a}'), ('\u{327}','\u{162}'), ('\u{32d}','\u{1e70}'), ('\u{331}','\u{1e6e}'),
        ('\u{300}','\u{d9}'), ('\u{301}','\u{da}'), ('\u{302}','\u{db}'), ('\u{303}','\u{168}'), ('\u{304}','\u{16a}'), ('\u{306}','\u{16c}'), ('\u{308}','\u{dc}'), ('\u{309}','\u{1ee6}'), ('\u{30a}','\u{16e}'), ('\u{30b}','\u{170}'), ('\u{30c}','\u{1d3}'), ('\u{30f}','\u{214}'), ('\u{311}','\u{216}'), ('\u{31b}','\u{1af}'), ('\u{323}','\u{1ee4}'), ('\u{324}','\u{1e72}'), ('\u{328}','\u{172}'), ('\u{32d}','\u{1e76}'), ('\u{330}','\u{1e74}'),
        ('\u{303}','\u{1e7c}'), ('\u{323}','\u{1e7e}'),
        ('\u{300}','\u{1e80}'), ('\u{301}','\u{1e82}'), ('\u{302}','\u{174}'), ('\u{307}','\u{1e86}'), ('\u{308}','\u{1e84}'), ('\u{323}','\u{1e88}'),
        ('\u{307}','\u{1e8a}'), ('\u{308}','\u{1e8c}'),
        ('\u{300}','\u{1ef2}'), ('\u{301}','\u{dd}'), ('\u{302}','\u{176}'), ('\u{303}','\u{1ef8}'), ('\u{304}','\u{232}'), ('\u{307}','\u{1e8e}'), ('\u{308}','\u{178}'), ('\u{309}','\u{1ef6}'), ('\u{323}','\u{1ef4}'),
        ('\u{301}','\u{179}'), ('\u{302}','\u{1e90}'), ('\u{307}','\u{17b}'), ('\u{30c}','\u{17d}'), ('\u{323}','\u{1e92}'), ('\u{331}','\u{1e94}'),
        ('\u{300}','\u{e0}'), ('\u{301}','\u{e1}'), ('\u{302}','\u{e2}'), ('\u{303}','\u{e3}'), ('\u{304}','\u{101}'), ('\u{306}','\u{103}'), ('\u{307}','\u{227}'), ('\u{308}','\u{e4}'), ('\u{309}','\u{1ea3}'), ('\u{30a}','\u{e5}'), ('\u{30c}','\u{1ce}'), ('\u{30f}','\u{201}'), ('\u{311}','\u{203}'), ('\u{323}','\u{1ea1}'), ('\u{325}','\u{1e01}'), ('\u{328}','\u{105}'),
        ('\u{307}','\u{1e03}'), ('\u{323}','\u{1e05}'), ('\u{331}','\u{1e07}'),
        ('\u{301}','\u{107}'), ('\u{302}','\u{109}'), ('\u{307}','\u{10b}'), ('\u{30c}','\u{10d}'), ('\u{327}','\u{e7}'),
        ('\u{307}','\u{1e0b}'), ('\u{30c}','\u{10f}'), ('\u{323}','\u{1e0d}'), ('\u{327}','\u{1e11}'), ('\u{32d}','\u{1e13}'), ('\u{331}','\u{1e0f}'),
        ('\u{300}','\u{e8}'), ('\u{301}','\u{e9}'), ('\u{302}','\u{ea}'), ('\u{303}','\u{1ebd}'), ('\u{304}','\u{113}'), ('\u{306}','\u{115}'), ('\u{307}','\u{117}'), ('\u{308}','\u{eb}'), ('\u{309}','\u{1ebb}'), ('\u{30c}','\u{11b}'), ('\u{30f}','\u{205}'), ('\u{311}','\u{207}'), ('\u{323}','\u{1eb9}'), ('\u{327}','\u{229}'), ('\u{328}','\u{119}'), ('\u{32d}','\u{1e19}'), ('\u{330}','\u{1e1b}'),
        ('\u{307}','\u{1e1f}'),
        ('\u{301}','\u{1f5}'), ('\u{302}','\u{11d}'), ('\u{304}','\u{1e21}'), ('\u{306}','\u{11f}'), ('\u{307}','\u{121}'), ('\u{30c}','\u{1e7}'), ('\u{327}','\u{123}'),
        ('\u{302}','\u{125}'), ('\u{307}','\u{1e23}'), ('\u{308}','\u{1e27}'), ('\u{30c}','\u{21f}'), ('\u{323}','\u{1e25}'), ('\u{327}','\u{1e29}'), ('\u{32e}','\u{1e2b}'), ('\u{331}','\u{1e96}'),
        ('\u{300}','\u{ec}'), ('\u{301}','\u{ed}'), ('\u{302}','\u{ee}'), ('\u{303}','\u{129}'), ('\u{304}','\u{12b}'), ('\u{306}','\u{12d}'), ('\u{308}','\u{ef}'), ('\u{309}','\u{1ec9}'), ('\u{30c}','\u{1d0}'), ('\u{30f}','\u{209}'), ('\u{311}','\u{20b}'), ('\u{323}','\u{1ecb}'), ('\u{328}','\u{12f}'), ('\u{330}','\u{1e2d}'),
        ('\u{302}','\u{135}'), ('\u{30c}','\u{1f0}'),
        ('\u{301}','\u{1e31}'), ('\u{30c}','\u{1e9}'), ('\u{323}','\u{1e33}'), ('\u{327}','\u{137}'), ('\u{331}','\u{1e35}'),
        ('\u{301}','\u{13a}'), ('\u{30c}','\u{13e}'), ('\u{323}','\u{1e37}'), ('\u{327}','\u{13c}'), ('\u{32d}','\u{1e3d}'), ('\u{331}','\u{1e3b}'),
        ('\u{301}','\u{1e3f}'), ('\u{307}','\u{1e41}'), ('\u{323}','\u{1e43}'),
        ('\u{300}','\u{1f9}'), ('\u{301}','\u{144}'), ('\u{303}','\u{f1}'), ('\u{307}','\u{1e45}'), ('\u{30c}','\u{148}'), ('\u{323}','\u{1e47}'), ('\u{327}','\u{146}'), ('\u{32d}','\u{1e4b}'), ('\u{331}','\u{1e49}'),
        ('\u{300}','\u{f2}'), ('\u{301}','\u{f3}'), ('\u{302}','\u{f4}'), ('\u{303}','\u{f5}'), ('\u{304}','\u{14d}'), ('\u{306}','\u{14f}'), ('\u{307}','\u{22f}'), ('\u{308}','\u{f6}'), ('\u{309}','\u{1ecf}'), ('\u{30b}','\u{151}'), ('\u{30c}','\u{1d2}'), ('\u{30f}','\u{20d}'), ('\u{311}','\u{20f}'), ('\u{31b}','\u{1a1}'), ('\u{323}','\u{1ecd}'), ('\u{328}','\u{1eb}'),
        ('\u{301}','\u{1e55}'), ('\u{307}','\u{1e57}'),
        ('\u{301}','\u{155}'), ('\u{307}','\u{1e59}'), ('\u{30c}','\u{159}'), ('\u{30f}','\u{211}'), ('\u{311}','\u{213}'), ('\u{323}','\u{1e5b}'), ('\u{327}','\u{157}'), ('\u{331}','\u{1e5f}'),
        ('\u{301}','\u{15b}'), ('\u{302}','\u{15d}'), ('\u{307}','\u{1e61}'), ('\u{30c}','\u{161}'), ('\u{323}','\u{1e63}'), ('\u{326}','\u{219}'), ('\u{327}','\u{15f}'),
        ('\u{307}','\u{1e6b}'), ('\u{308}','\u{1e97}'), ('\u{30c}','\u{165}'), ('\u{323}','\u{1e6d}'), ('\u{326}','\u{21b}'), ('\u{327}','\u{163}'), ('\u{32d}','\u{1e71}'), ('\u{331}','\u{1e6f}'),
        ('\u{300}','\u{f9}'), ('\u{301}','\u{fa}'), ('\u{302}','\u{fb}'), ('\u{303}','\u{169}'), ('\u{304}','\u{16b}'), ('\u{306}','\u{16d}'), ('\u{308}','\u{fc}'), ('\u{309}','\u{1ee7}'), ('\u{30a}','\u{16f}'), ('\u{30b}','\u{171}'), ('\u{30c}','\u{1d4}'), ('\u{30f}','\u{215}'), ('\u{311}','\u{217}'), ('\u{31b}','\u{1b0}'), ('\u{323}','\u{1ee5}'), ('\u{324}','\u{1e73}'), ('\u{328}','\u{173}'), ('\u{32d}','\u{1e77}'), ('\u{330}','\u{1e75}'),
        ('\u{303}','\u{1e7d}'), ('\u{323}','\u{1e7f}'),
        ('\u{300}','\u{1e81}'), ('\u{301}','\u{1e83}'), ('\u{302}','\u{175}'), ('\u{307}','\u{1e87}'), ('\u{308}','\u{1e85}'), ('\u{30a}','\u{1e98}'), ('\u{323}','\u{1e89}'),
        ('\u{307}','\u{1e8b}'), ('\u{308}','\u{1e8d}'),
        ('\u{300}','\u{1ef3}'), ('\u{301}','\u{fd}'), ('\u{302}','\u{177}'), ('\u{303}','\u{1ef9}'), ('\u{304}','\u{233}'), ('\u{307}','\u{1e8f}'), ('\u{308}','\u{ff}'), ('\u{309}','\u{1ef7}'), ('\u{30a}','\u{1e99}'), ('\u{323}','\u{1ef5}'),
        ('\u{301}','\u{17a}'), ('\u{302}','\u{1e91}'), ('\u{307}','\u{17c}'), ('\u{30c}','\u{17e}'), ('\u{323}','\u{1e93}'), ('\u{331}','\u{1e95}'),
        ('\u{300}','\u{1fed}'), ('\u{301}','\u{385}'), ('\u{342}','\u{1fc1}'),
        ('\u{300}','\u{1ea6}'), ('\u{301}','\u{1ea4}'), ('\u{303}','\u{1eaa}'), ('\u{309}','\u{1ea8}'),
        ('\u{304}','\u{1de}'),
        ('\u{301}','\u{1fa}'),
        ('\u{301}','\u{1fc}'), ('\u{304}','\u{1e2}'),
        ('\u{301}','\u{1e08}'),
        ('\u{300}','\u{1ec0}'), ('\u{301}','\u{1ebe}'), ('\u{303}','\u{1ec4}'), ('\u{309}','\u{1ec2}'),
        ('\u{301}','\u{1e2e}'),
        ('\u{300}','\u{1ed2}'), ('\u{301}','\u{1ed0}'), ('\u{303}','\u{1ed6}'), ('\u{309}','\u{1ed4}'),
        ('\u{301}','\u{1e4c}'), ('\u{304}','\u{22c}'), ('\u{308}','\u{1e4e}'),
        ('\u{304}','\u{22a}'),
        ('\u{301}','\u{1fe}'),
        ('\u{300}','\u{1db}'), ('\u{301}','\u{1d7}'), ('\u{304}','\u{1d5}'), ('\u{30c}','\u{1d9}'),
        ('\u{300}','\u{1ea7}'), ('\u{301}','\u{1ea5}'), ('\u{303}','\u{1eab}'), ('\u{309}','\u{1ea9}'),
        ('\u{304}','\u{1df}'),
        ('\u{301}','\u{1fb}'),
        ('\u{301}','\u{1fd}'), ('\u{304}','\u{1e3}'),
        ('\u{301}','\u{1e09}'),
        ('\u{300}','\u{1ec1}'), ('\u{301}','\u{1ebf}'), ('\u{303}','\u{1ec5}'), ('\u{309}','\u{1ec3}'),
        ('\u{301}','\u{1e2f}'),
        ('\u{300}','\u{1ed3}'), ('\u{301}','\u{1ed1}'), ('\u{303}','\u{1ed7}'), ('\u{309}','\u{1ed5}'),
        ('\u{301}','\u{1e4d}'), ('\u{304}','\u{22d}'), ('\u{308}','\u{1e4f}'),
        ('\u{304}','\u{22b}'),
        ('\u{301}','\u{1ff}'),
        ('\u{300}','\u{1dc}'), ('\u{301}','\u{1d8}'), ('\u{304}','\u{1d6}'), ('\u{30c}','\u{1da}'),
        ('\u{300}','\u{1eb0}'), ('\u{301}','\u{1eae}'), ('\u{303}','\u{1eb4}'), ('\u{309}','\u{1eb2}'),
        ('\u{300}','\u{1eb1}'), ('\u{301}','\u{1eaf}'), ('\u{303}','\u{1eb5}'), ('\u{309}','\u{1eb3}'),
        ('\u{300}','\u{1e14}'), ('\u{301}','\u{1e16}'),
        ('\u{300}','\u{1e15}'), ('\u{301}','\u{1e17}'),
        ('\u{300}','\u{1e50}'), ('\u{301}','\u{1e52}'),
        ('\u{300}','\u{1e51}'), ('\u{301}','\u{1e53}'),
        ('\u{307}','\u{1e64}'),
        ('\u{307}','\u{1e65}'),
        ('\u{307}','\u{1e66}'),
        ('\u{307}','\u{1e67}'),
        ('\u{301}','\u{1e78}'),
        ('\u{301}','\u{1e79}'),
        ('\u{308}','\u{1e7a}'),
        ('\u{308}','\u{1e7b}'),
        ('\u{307}','\u{1e9b}'),
        ('\u{300}','\u{1edc}'), ('\u{301}','\u{1eda}'), ('\u{303}','\u{1ee0}'), ('\u{309}','\u{1ede}'), ('\u{323}','\u{1ee2}'),
        ('\u{300}','\u{1edd}'), ('\u{301}','\u{1edb}'), ('\u{303}','\u{1ee1}'), ('\u{309}','\u{1edf}'), ('\u{323}','\u{1ee3}'),
        ('\u{300}','\u{1eea}'), ('\u{301}','\u{1ee8}'), ('\u{303}','\u{1eee}'), ('\u{309}','\u{1eec}'), ('\u{323}','\u{1ef0}'),
        ('\u{300}','\u{1eeb}'), ('\u{301}','\u{1ee9}'), ('\u{303}','\u{1eef}'), ('\u{309}','\u{1eed}'), ('\u{323}','\u{1ef1}'),
        ('\u{30c}','\u{1ee}'),
        ('\u{304}','\u{1ec}'),
        ('\u{304}','\u{1ed}'),
        ('\u{304}','\u{1e0}'),
        ('\u{304}','\u{1e1}'),
        ('\u{306}','\u{1e1c}'),
        ('\u{306}','\u{1e1d}'),
        ('\u{304}','\u{230}'),
        ('\u{304}','\u{231}'),
        ('\u{30c}','\u{1ef}'),
        ('\u{300}','\u{1fba}'), ('\u{301}','\u{386}'), ('\u{304}','\u{1fb9}'), ('\u{306}','\u{1fb8}'), ('\u{313}','\u{1f08}'), ('\u{314}','\u{1f09}'), ('\u{345}','\u{1fbc}'),
        ('\u{300}','\u{1fc8}'), ('\u{301}','\u{388}'), ('\u{313}','\u{1f18}'), ('\u{314}','\u{1f19}'),
        ('\u{300}','\u{1fca}'), ('\u{301}','\u{389}'), ('\u{313}','\u{1f28}'), ('\u{314}','\u{1f29}'), ('\u{345}','\u{1fcc}'),
        ('\u{300}','\u{1fda}'), ('\u{301}','\u{38a}'), ('\u{304}','\u{1fd9}'), ('\u{306}','\u{1fd8}'), ('\u{308}','\u{3aa}'), ('\u{313}','\u{1f38}'), ('\u{314}','\u{1f39}'),
        ('\u{300}','\u{1ff8}'), ('\u{301}','\u{38c}'), ('\u{313}','\u{1f48}'), ('\u{314}','\u{1f49}'),
        ('\u{314}','\u{1fec}'),
        ('\u{300}','\u{1fea}'), ('\u{301}','\u{38e}'), ('\u{304}','\u{1fe9}'), ('\u{306}','\u{1fe8}'), ('\u{308}','\u{3ab}'), ('\u{314}','\u{1f59}'),
        ('\u{300}','\u{1ffa}'), ('\u{301}','\u{38f}'), ('\u{313}','\u{1f68}'), ('\u{314}','\u{1f69}'), ('\u{345}','\u{1ffc}'),
        ('\u{345}','\u{1fb4}'),
        ('\u{345}','\u{1fc4}'),
        ('\u{300}','\u{1f70}'), ('\u{301}','\u{3ac}'), ('\u{304}','\u{1fb1}'), ('\u{306}','\u{1fb0}'), ('\u{313}','\u{1f00}'), ('\u{314}','\u{1f01}'), ('\u{342}','\u{1fb6}'), ('\u{345}','\u{1fb3}'),
        ('\u{300}','\u{1f72}'), ('\u{301}','\u{3ad}'), ('\u{313}','\u{1f10}'), ('\u{314}','\u{1f11}'),
        ('\u{300}','\u{1f74}'), ('\u{301}','\u{3ae}'), ('\u{313}','\u{1f20}'), ('\u{314}','\u{1f21}'), ('\u{342}','\u{1fc6}'), ('\u{345}','\u{1fc3}'),
        ('\u{300}','\u{1f76}'), ('\u{301}','\u{3af}'), ('\u{304}','\u{1fd1}'), ('\u{306}','\u{1fd0}'), ('\u{308}','\u{3ca}'), ('\u{313}','\u{1f30}'), ('\u{314}','\u{1f31}'), ('\u{342}','\u{1fd6}'),
        ('\u{300}','\u{1f78}'), ('\u{301}','\u{3cc}'), ('\u{313}','\u{1f40}'), ('\u{314}','\u{1f41}'),
        ('\u{313}','\u{1fe4}'), ('\u{314}','\u{1fe5}'),
        ('\u{300}','\u{1f7a}'), ('\u{301}','\u{3cd}'), ('\u{304}','\u{1fe1}'), ('\u{306}','\u{1fe0}'), ('\u{308}','\u{3cb}'), ('\u{313}','\u{1f50}'), ('\u{314}','\u{1f51}'), ('\u{342}','\u{1fe6}'),
        ('\u{300}','\u{1f7c}'), ('\u{301}','\u{3ce}'), ('\u{313}','\u{1f60}'), ('\u{314}','\u{1f61}'), ('\u{342}','\u{1ff6}'), ('\u{345}','\u{1ff3}'),
        ('\u{300}','\u{1fd2}'), ('\u{301}','\u{390}'), ('\u{342}','\u{1fd7}'),
        ('\u{300}','\u{1fe2}'), ('\u{301}','\u{3b0}'), ('\u{342}','\u{1fe7}'),
        ('\u{345}','\u{1ff4}'),
        ('\u{301}','\u{3d3}'), ('\u{308}','\u{3d4}'),
        ('\u{308}','\u{407}'),
        ('\u{306}','\u{4d0}'), ('\u{308}','\u{4d2}'),
        ('\u{301}','\u{403}'),
        ('\u{300}','\u{400}'), ('\u{306}','\u{4d6}'), ('\u{308}','\u{401}'),
        ('\u{306}','\u{4c1}'), ('\u{308}','\u{4dc}'),
        ('\u{308}','\u{4de}'),
        ('\u{300}','\u{40d}'), ('\u{304}','\u{4e2}'), ('\u{306}','\u{419}'), ('\u{308}','\u{4e4}'),
        ('\u{301}','\u{40c}'),
        ('\u{308}','\u{4e6}'),
        ('\u{304}','\u{4ee}'), ('\u{306}','\u{40e}'), ('\u{308}','\u{4f0}'), ('\u{30b}','\u{4f2}'),
        ('\u{308}','\u{4f4}'),
        ('\u{308}','\u{4f8}'),
        ('\u{308}','\u{4ec}'),
        ('\u{306}','\u{4d1}'), ('\u{308}','\u{4d3}'),
        ('\u{301}','\u{453}'),
        ('\u{300}','\u{450}'), ('\u{306}','\u{4d7}'), ('\u{308}','\u{451}'),
        ('\u{306}','\u{4c2}'), ('\u{308}','\u{4dd}'),
        ('\u{308}','\u{4df}'),
        ('\u{300}','\u{45d}'), ('\u{304}','\u{4e3}'), ('\u{306}','\u{439}'), ('\u{308}','\u{4e5}'),
        ('\u{301}','\u{45c}'),
        ('\u{308}','\u{4e7}'),
        ('\u{304}','\u{4ef}'), ('\u{306}','\u{45e}'), ('\u{308}','\u{4f1}'), ('\u{30b}','\u{4f3}'),
        ('\u{308}','\u{4f5}'),
        ('\u{308}','\u{4f9}'),
        ('\u{308}','\u{4ed}'),
        ('\u{308}','\u{457}'),
        ('\u{30f}','\u{476}'),
        ('\u{30f}','\u{477}'),
        ('\u{308}','\u{4da}'),
        ('\u{308}','\u{4db}'),
        ('\u{308}','\u{4ea}'),
        ('\u{308}','\u{4eb}'),
        ('\u{653}','\u{622}'), ('\u{654}','\u{623}'), ('\u{655}','\u{625}'),
        ('\u{654}','\u{624}'),
        ('\u{654}','\u{626}'),
        ('\u{654}','\u{6c2}'),
        ('\u{654}','\u{6d3}'),
        ('\u{654}','\u{6c0}'),
        ('\u{93c}','\u{929}'),
        ('\u{93c}','\u{931}'),
        ('\u{93c}','\u{934}'),
        ('\u{9be}','\u{9cb}'), ('\u{9d7}','\u{9cc}'),
        ('\u{b3e}','\u{b4b}'), ('\u{b56}','\u{b48}'), ('\u{b57}','\u{b4c}'),
        ('\u{bd7}','\u{b94}'),
        ('\u{bbe}','\u{bca}'), ('\u{bd7}','\u{bcc}'),
        ('\u{bbe}','\u{bcb}'),
        ('\u{c56}','\u{c48}'),
        ('\u{cd5}','\u{cc0}'),
        ('\u{cc2}','\u{cca}'), ('\u{cd5}','\u{cc7}'), ('\u{cd6}','\u{cc8}'),
        ('\u{cd5}','\u{ccb}'),
        ('\u{d3e}','\u{d4a}'), ('\u{d57}','\u{d4c}'),
        ('\u{d3e}','\u{d4b}'),
        ('\u{dca}','\u{dda}'), ('\u{dcf}','\u{ddc}'), ('\u{ddf}','\u{dde}'),
        ('\u{dca}','\u{ddd}'),
        ('\u{102e}','\u{1026}'),
        ('\u{1b35}','\u{1b06}'),
        ('\u{1b35}','\u{1b08}'),
        ('\u{1b35}','\u{1b0a}'),
        ('\u{1b35}','\u{1b0c}'),
        ('\u{1b35}','\u{1b0e}'),
        ('\u{1b35}','\u{1b12}'),
        ('\u{1b35}','\u{1b3b}'),
        ('\u{1b35}','\u{1b3d}'),
        ('\u{1b35}','\u{1b40}'),
        ('\u{1b35}','\u{1b41}'),
        ('\u{1b35}','\u{1b43}'),
        ('\u{304}','\u{1e38}'),
        ('\u{304}','\u{1e39}'),
        ('\u{304}','\u{1e5c}'),
        ('\u{304}','\u{1e5d}'),
        ('\u{307}','\u{1e68}'),
        ('\u{307}','\u{1e69}'),
        ('\u{302}','\u{1eac}'), ('\u{306}','\u{1eb6}'),
        ('\u{302}','\u{1ead}'), ('\u{306}','\u{1eb7}'),
        ('\u{302}','\u{1ec6}'),
        ('\u{302}','\u{1ec7}'),
        ('\u{302}','\u{1ed8}'),
        ('\u{302}','\u{1ed9}'),
        ('\u{300}','\u{1f02}'), ('\u{301}','\u{1f04}'), ('\u{342}','\u{1f06}'), ('\u{345}','\u{1f80}'),
        ('\u{300}','\u{1f03}'), ('\u{301}','\u{1f05}'), ('\u{342}','\u{1f07}'), ('\u{345}','\u{1f81}'),
        ('\u{345}','\u{1f82}'),
        ('\u{345}','\u{1f83}'),
        ('\u{345}','\u{1f84}'),
        ('\u{345}','\u{1f85}'),
        ('\u{345}','\u{1f86}'),
        ('\u{345}','\u{1f87}'),
        ('\u{300}','\u{1f0a}'), ('\u{301}','\u{1f0c}'), ('\u{342}','\u{1f0e}'), ('\u{345}','\u{1f88}'),
        ('\u{300}','\u{1f0b}'), ('\u{301}','\u{1f0d}'), ('\u{342}','\u{1f0f}'), ('\u{345}','\u{1f89}'),
        ('\u{345}','\u{1f8a}'),
        ('\u{345}','\u{1f8b}'),
        ('\u{345}','\u{1f8c}'),
        ('\u{345}','\u{1f8d}'),
        ('\u{345}','\u{1f8e}'),
        ('\u{345}','\u{1f8f}'),
        ('\u{300}','\u{1f12}'), ('\u{301}','\u{1f14}'),
        ('\u{300}','\u{1f13}'), ('\u{301}','\u{1f15}'),
        ('\u{300}','\u{1f1a}'), ('\u{301}','\u{1f1c}'),
        ('\u{300}','\u{1f1b}'), ('\u{301}','\u{1f1d}'),
        ('\u{300}','\u{1f22}'), ('\u{301}','\u{1f24}'), ('\u{342}','\u{1f26}'), ('\u{345}','\u{1f90}'),
        ('\u{300}','\u{1f23}'), ('\u{301}','\u{1f25}'), ('\u{342}','\u{1f27}'), ('\u{345}','\u{1f91}'),
        ('\u{345}','\u{1f92}'),
        ('\u{345}','\u{1f93}'),
        ('\u{345}','\u{1f94}'),
        ('\u{345}','\u{1f95}'),
        ('\u{345}','\u{1f96}'),
        ('\u{345}','\u{1f97}'),
        ('\u{300}','\u{1f2a}'), ('\u{301}','\u{1f2c}'), ('\u{342}','\u{1f2e}'), ('\u{345}','\u{1f98}'),
        ('\u{300}','\u{1f2b}'), ('\u{301}','\u{1f2d}'), ('\u{342}','\u{1f2f}'), ('\u{345}','\u{1f99}'),
        ('\u{345}','\u{1f9a}'),
        ('\u{345}','\u{1f9b}'),
        ('\u{345}','\u{1f9c}'),
        ('\u{345}','\u{1f9d}'),
        ('\u{345}','\u{1f9e}'),
        ('\u{345}','\u{1f9f}'),
        ('\u{300}','\u{1f32}'), ('\u{301}','\u{1f34}'), ('\u{342}','\u{1f36}'),
        ('\u{300}','\u{1f33}'), ('\u{301}','\u{1f35}'), ('\u{342}','\u{1f37}'),
        ('\u{300}','\u{1f3a}'), ('\u{301}','\u{1f3c}'), ('\u{342}','\u{1f3e}'),
        ('\u{300}','\u{1f3b}'), ('\u{301}','\u{1f3d}'), ('\u{342}','\u{1f3f}'),
        ('\u{300}','\u{1f42}'), ('\u{301}','\u{1f44}'),
        ('\u{300}','\u{1f43}'), ('\u{301}','\u{1f45}'),
        ('\u{300}','\u{1f4a}'), ('\u{301}','\u{1f4c}'),
        ('\u{300}','\u{1f4b}'), ('\u{301}','\u{1f4d}'),
        ('\u{300}','\u{1f52}'), ('\u{301}','\u{1f54}'), ('\u{342}','\u{1f56}'),
        ('\u{300}','\u{1f53}'), ('\u{301}','\u{1f55}'), ('\u{342}','\u{1f57}'),
        ('\u{300}','\u{1f5b}'), ('\u{301}','\u{1f5d}'), ('\u{342}','\u{1f5f}'),
        ('\u{300}','\u{1f62}'), ('\u{301}','\u{1f64}'), ('\u{342}','\u{1f66}'), ('\u{345}','\u{1fa0}'),
        ('\u{300}','\u{1f63}'), ('\u{301}','\u{1f65}'), ('\u{342}','\u{1f67}'), ('\u{345}','\u{1fa1}'),
        ('\u{345}','\u{1fa2}'),
        ('\u{345}','\u{1fa3}'),
        ('\u{345}','\u{1fa4}'),
        ('\u{345}','\u{1fa5}'),
        ('\u{345}','\u{1fa6}'),
        ('\u{345}','\u{1fa7}'),
        ('\u{300}','\u{1f6a}'), ('\u{301}','\u{1f6c}'), ('\u{342}','\u{1f6e}'), ('\u{345}','\u{1fa8}'),
        ('\u{300}','\u{1f6b}'), ('\u{301}','\u{1f6d}'), ('\u{342}','\u{1f6f}'), ('\u{345}','\u{1fa9}'),
        ('\u{345}','\u{1faa}'),
        ('\u{345}','\u{1fab}'),
        ('\u{345}','\u{1fac}'),
        ('\u{345}','\u{1fad}'),
        ('\u{345}','\u{1fae}'),
        ('\u{345}','\u{1faf}'),
        ('\u{345}','\u{1fb2}'),
        ('\u{345}','\u{1fc2}'),
        ('\u{345}','\u{1ff2}'),
        ('\u{345}','\u{1fb7}'),
        ('\u{300}','\u{1fcd}'), ('\u{301}','\u{1fce}'), ('\u{342}','\u{1fcf}'),
        ('\u{345}','\u{1fc7}'),
        ('\u{345}','\u{1ff7}'),
        ('\u{300}','\u{1fdd}'), ('\u{301}','\u{1fde}'), ('\u{342}','\u{1fdf}'),
        ('\u{338}','\u{219a}'),
        ('\u{338}','\u{219b}'),
        ('\u{338}','\u{21ae}'),
        ('\u{338}','\u{21cd}'),
        ('\u{338}','\u{21cf}'),
        ('\u{338}','\u{21ce}'),
        ('\u{338}','\u{2204}'),
        ('\u{338}','\u{2209}'),
        ('\u{338}','\u{220c}'),
        ('\u{338}','\u{2224}'),
        ('\u{338}','\u{2226}'),
        ('\u{338}','\u{2241}'),
        ('\u{338}','\u{2244}'),
        ('\u{338}','\u{2247}'),
        ('\u{338}','\u{2249}'),
        ('\u{338}','\u{226d}'),
        ('\u{338}','\u{2262}'),
        ('\u{338}','\u{2270}'),
        ('\u{338}','\u{2271}'),
        ('\u{338}','\u{2274}'),
        ('\u{338}','\u{2275}'),
        ('\u{338}','\u{2278}'),
        ('\u{338}','\u{2279}'),
        ('\u{338}','\u{2280}'),
        ('\u{338}','\u{2281}'),
        ('\u{338}','\u{22e0}'),
        ('\u{338}','\u{22e1}'),
        ('\u{338}','\u{2284}'),
        ('\u{338}','\u{2285}'),
        ('\u{338}','\u{2288}'),
        ('\u{338}','\u{2289}'),
        ('\u{338}','\u{22e2}'),
        ('\u{338}','\u{22e3}'),
        ('\u{338}','\u{22ac}'),
        ('\u{338}','\u{22ad}'),
        ('\u{338}','\u{22ae}'),
        ('\u{338}','\u{22af}'),
        ('\u{338}','\u{22ea}'),
        ('\u{338}','\u{22eb}'),
        ('\u{338}','\u{22ec}'),
        ('\u{338}','\u{22ed}'),
        ('\u{3099}','\u{3094}'),
        ('\u{3099}','\u{304c}'),
        ('\u{3099}','\u{304e}'),
        ('\u{3099}','\u{3050}'),
        ('\u{3099}','\u{3052}'),
        ('\u{3099}','\u{3054}'),
        ('\u{3099}','\u{3056}'),
        ('\u{3099}','\u{3058}'),
        ('\u{3099}','\u{305a}'),
        ('\u{3099}','\u{305c}'),
        ('\u{3099}','\u{305e}'),
        ('\u{3099}','\u{3060}'),
        ('\u{3099}','\u{3062}'),
        ('\u{3099}','\u{3065}'),
        ('\u{3099}','\u{3067}'),
        ('\u{3099}','\u{3069}'),
        ('\u{3099}','\u{3070}'), ('\u{309a}','\u{3071}'),
        ('\u{3099}','\u{3073}'), ('\u{309a}','\u{3074}'),
        ('\u{3099}','\u{3076}'), ('\u{309a}','\u{3077}'),
        ('\u{3099}','\u{3079}'), ('\u{309a}','\u{307a}'),
        ('\u{3099}','\u{307c}'), ('\u{309a}','\u{307d}'),
        ('\u{3099}','\u{309e}'),
        ('\u{3099}','\u{30f4}'),
        ('\u{3099}','\u{30ac}'),
        ('\u{3099}','\u{30ae}'),
        ('\u{3099}','\u{30b0}'),
        ('\u{3099}','\u{30b2}'),
        ('\u{3099}','\u{30b4}'),
        ('\u{3099}','\u{30b6}'),
        ('\u{3099}','\u{30b8}'),
        ('\u{3099}','\u{30ba}'),
        ('\u{3099}','\u{30bc}'),
        ('\u{3099}','\u{30be}'),
        ('\u{3099}','\u{30c0}'),
        ('\u{3099}','\u{30c2}'),
        ('\u{3099}','\u{30c5}'),
        ('\u{3099}','\u{30c7}'),
        ('\u{3099}','\u{30c9}'),
        ('\u{3099}','\u{30d0}'), ('\u{309a}','\u{30d1}'),
        ('\u{3099}','\u{30d3}'), ('\u{309a}','\u{30d4}'),
        ('\u{3099}','\u{30d6}'), ('\u{309a}','\u{30d7}'),
        ('\u{3099}','\u{30d9}'), ('\u{309a}','\u{30da}'),
        ('\u{3099}','\u{30dc}'), ('\u{309a}','\u{30dd}'),
        ('\u{3099}','\u{30f7}'),
        ('\u{3099}','\u{30f8}'),
        ('\u{3099}','\u{30f9}'),
        ('\u{3099}','\u{30fa}'),
        ('\u{3099}','\u{30fe}'),
        ('\u{110ba}','\u{1109a}'),
        ('\u{110ba}','\u{1109c}'),
        ('\u{110ba}','\u{110ab}'),
        ('\u{11127}','\u{1112e}'),
        ('\u{11127}','\u{1112f}'),
        ('\u{1133e}','\u{1134b}'), ('\u{11357}','\u{1134c}'),
        ('\u{114b0}','\u{114bc}'), ('\u{114ba}','\u{114bb}'), ('\u{114bd}','\u{114be}'),
        ('\u{115af}','\u{115ba}'),
        ('\u{115af}','\u{115bb}'),

    ];


    fn bsearch_range_value_table(c: char, r: &'static [(char, char, u8)]) -> u8 {
        use std::cmp::Ordering::{Equal, Less, Greater};
        match r.binary_search_by(|&(lo, hi, _)| {
            if lo <= c && c <= hi { Equal }
            else if hi < c { Less }
            else { Greater }
        }) {
            Ok(idx) => {
                let (_, _, result) = r[idx];
                result
            }
            Err(_) => 0
        }
    }

    const combining_class_table: &'static [(char, char, u8)] = &[
        ('\u{300}','\u{314}',230),
        ('\u{315}','\u{315}',232),
        ('\u{316}','\u{319}',220),
        ('\u{31a}','\u{31a}',232),
        ('\u{31b}','\u{31b}',216),
        ('\u{31c}','\u{320}',220),
        ('\u{321}','\u{322}',202),
        ('\u{323}','\u{326}',220),
        ('\u{327}','\u{328}',202),
        ('\u{329}','\u{333}',220),
        ('\u{334}','\u{338}',1),
        ('\u{339}','\u{33c}',220),
        ('\u{33d}','\u{344}',230),
        ('\u{345}','\u{345}',240),
        ('\u{346}','\u{346}',230),
        ('\u{347}','\u{349}',220),
        ('\u{34a}','\u{34c}',230),
        ('\u{34d}','\u{34e}',220),
        ('\u{350}','\u{352}',230),
        ('\u{353}','\u{356}',220),
        ('\u{357}','\u{357}',230),
        ('\u{358}','\u{358}',232),
        ('\u{359}','\u{35a}',220),
        ('\u{35b}','\u{35b}',230),
        ('\u{35c}','\u{35c}',233),
        ('\u{35d}','\u{35e}',234),
        ('\u{35f}','\u{35f}',233),
        ('\u{360}','\u{361}',234),
        ('\u{362}','\u{362}',233),
        ('\u{363}','\u{36f}',230),
        ('\u{483}','\u{487}',230),
        ('\u{591}','\u{591}',220),
        ('\u{592}','\u{595}',230),
        ('\u{596}','\u{596}',220),
        ('\u{597}','\u{599}',230),
        ('\u{59a}','\u{59a}',222),
        ('\u{59b}','\u{59b}',220),
        ('\u{59c}','\u{5a1}',230),
        ('\u{5a2}','\u{5a7}',220),
        ('\u{5a8}','\u{5a9}',230),
        ('\u{5aa}','\u{5aa}',220),
        ('\u{5ab}','\u{5ac}',230),
        ('\u{5ad}','\u{5ad}',222),
        ('\u{5ae}','\u{5ae}',228),
        ('\u{5af}','\u{5af}',230),
        ('\u{5b0}','\u{5b0}',10),
        ('\u{5b1}','\u{5b1}',11),
        ('\u{5b2}','\u{5b2}',12),
        ('\u{5b3}','\u{5b3}',13),
        ('\u{5b4}','\u{5b4}',14),
        ('\u{5b5}','\u{5b5}',15),
        ('\u{5b6}','\u{5b6}',16),
        ('\u{5b7}','\u{5b7}',17),
        ('\u{5b8}','\u{5b8}',18),
        ('\u{5b9}','\u{5ba}',19),
        ('\u{5bb}','\u{5bb}',20),
        ('\u{5bc}','\u{5bc}',21),
        ('\u{5bd}','\u{5bd}',22),
        ('\u{5bf}','\u{5bf}',23),
        ('\u{5c1}','\u{5c1}',24),
        ('\u{5c2}','\u{5c2}',25),
        ('\u{5c4}','\u{5c4}',230),
        ('\u{5c5}','\u{5c5}',220),
        ('\u{5c7}','\u{5c7}',18),
        ('\u{610}','\u{617}',230),
        ('\u{618}','\u{618}',30),
        ('\u{619}','\u{619}',31),
        ('\u{61a}','\u{61a}',32),
        ('\u{64b}','\u{64b}',27),
        ('\u{64c}','\u{64c}',28),
        ('\u{64d}','\u{64d}',29),
        ('\u{64e}','\u{64e}',30),
        ('\u{64f}','\u{64f}',31),
        ('\u{650}','\u{650}',32),
        ('\u{651}','\u{651}',33),
        ('\u{652}','\u{652}',34),
        ('\u{653}','\u{654}',230),
        ('\u{655}','\u{656}',220),
        ('\u{657}','\u{65b}',230),
        ('\u{65c}','\u{65c}',220),
        ('\u{65d}','\u{65e}',230),
        ('\u{65f}','\u{65f}',220),
        ('\u{670}','\u{670}',35),
        ('\u{6d6}','\u{6dc}',230),
        ('\u{6df}','\u{6e2}',230),
        ('\u{6e3}','\u{6e3}',220),
        ('\u{6e4}','\u{6e4}',230),
        ('\u{6e7}','\u{6e8}',230),
        ('\u{6ea}','\u{6ea}',220),
        ('\u{6eb}','\u{6ec}',230),
        ('\u{6ed}','\u{6ed}',220),
        ('\u{711}','\u{711}',36),
        ('\u{730}','\u{730}',230),
        ('\u{731}','\u{731}',220),
        ('\u{732}','\u{733}',230),
        ('\u{734}','\u{734}',220),
        ('\u{735}','\u{736}',230),
        ('\u{737}','\u{739}',220),
        ('\u{73a}','\u{73a}',230),
        ('\u{73b}','\u{73c}',220),
        ('\u{73d}','\u{73d}',230),
        ('\u{73e}','\u{73e}',220),
        ('\u{73f}','\u{741}',230),
        ('\u{742}','\u{742}',220),
        ('\u{743}','\u{743}',230),
        ('\u{744}','\u{744}',220),
        ('\u{745}','\u{745}',230),
        ('\u{746}','\u{746}',220),
        ('\u{747}','\u{747}',230),
        ('\u{748}','\u{748}',220),
        ('\u{749}','\u{74a}',230),
        ('\u{7eb}','\u{7f1}',230),
        ('\u{7f2}','\u{7f2}',220),
        ('\u{7f3}','\u{7f3}',230),
        ('\u{816}','\u{819}',230),
        ('\u{81b}','\u{823}',230),
        ('\u{825}','\u{827}',230),
        ('\u{829}','\u{82d}',230),
        ('\u{859}','\u{85b}',220),
        ('\u{8d4}','\u{8e1}',230),
        ('\u{8e3}','\u{8e3}',220),
        ('\u{8e4}','\u{8e5}',230),
        ('\u{8e6}','\u{8e6}',220),
        ('\u{8e7}','\u{8e8}',230),
        ('\u{8e9}','\u{8e9}',220),
        ('\u{8ea}','\u{8ec}',230),
        ('\u{8ed}','\u{8ef}',220),
        ('\u{8f0}','\u{8f0}',27),
        ('\u{8f1}','\u{8f1}',28),
        ('\u{8f2}','\u{8f2}',29),
        ('\u{8f3}','\u{8f5}',230),
        ('\u{8f6}','\u{8f6}',220),
        ('\u{8f7}','\u{8f8}',230),
        ('\u{8f9}','\u{8fa}',220),
        ('\u{8fb}','\u{8ff}',230),
        ('\u{93c}','\u{93c}',7),
        ('\u{94d}','\u{94d}',9),
        ('\u{951}','\u{951}',230),
        ('\u{952}','\u{952}',220),
        ('\u{953}','\u{954}',230),
        ('\u{9bc}','\u{9bc}',7),
        ('\u{9cd}','\u{9cd}',9),
        ('\u{a3c}','\u{a3c}',7),
        ('\u{a4d}','\u{a4d}',9),
        ('\u{abc}','\u{abc}',7),
        ('\u{acd}','\u{acd}',9),
        ('\u{b3c}','\u{b3c}',7),
        ('\u{b4d}','\u{b4d}',9),
        ('\u{bcd}','\u{bcd}',9),
        ('\u{c4d}','\u{c4d}',9),
        ('\u{c55}','\u{c55}',84),
        ('\u{c56}','\u{c56}',91),
        ('\u{cbc}','\u{cbc}',7),
        ('\u{ccd}','\u{ccd}',9),
        ('\u{d4d}','\u{d4d}',9),
        ('\u{dca}','\u{dca}',9),
        ('\u{e38}','\u{e39}',103),
        ('\u{e3a}','\u{e3a}',9),
        ('\u{e48}','\u{e4b}',107),
        ('\u{eb8}','\u{eb9}',118),
        ('\u{ec8}','\u{ecb}',122),
        ('\u{f18}','\u{f19}',220),
        ('\u{f35}','\u{f35}',220),
        ('\u{f37}','\u{f37}',220),
        ('\u{f39}','\u{f39}',216),
        ('\u{f71}','\u{f71}',129),
        ('\u{f72}','\u{f72}',130),
        ('\u{f74}','\u{f74}',132),
        ('\u{f7a}','\u{f7d}',130),
        ('\u{f80}','\u{f80}',130),
        ('\u{f82}','\u{f83}',230),
        ('\u{f84}','\u{f84}',9),
        ('\u{f86}','\u{f87}',230),
        ('\u{fc6}','\u{fc6}',220),
        ('\u{1037}','\u{1037}',7),
        ('\u{1039}','\u{103a}',9),
        ('\u{108d}','\u{108d}',220),
        ('\u{135d}','\u{135f}',230),
        ('\u{1714}','\u{1714}',9),
        ('\u{1734}','\u{1734}',9),
        ('\u{17d2}','\u{17d2}',9),
        ('\u{17dd}','\u{17dd}',230),
        ('\u{18a9}','\u{18a9}',228),
        ('\u{1939}','\u{1939}',222),
        ('\u{193a}','\u{193a}',230),
        ('\u{193b}','\u{193b}',220),
        ('\u{1a17}','\u{1a17}',230),
        ('\u{1a18}','\u{1a18}',220),
        ('\u{1a60}','\u{1a60}',9),
        ('\u{1a75}','\u{1a7c}',230),
        ('\u{1a7f}','\u{1a7f}',220),
        ('\u{1ab0}','\u{1ab4}',230),
        ('\u{1ab5}','\u{1aba}',220),
        ('\u{1abb}','\u{1abc}',230),
        ('\u{1abd}','\u{1abd}',220),
        ('\u{1b34}','\u{1b34}',7),
        ('\u{1b44}','\u{1b44}',9),
        ('\u{1b6b}','\u{1b6b}',230),
        ('\u{1b6c}','\u{1b6c}',220),
        ('\u{1b6d}','\u{1b73}',230),
        ('\u{1baa}','\u{1bab}',9),
        ('\u{1be6}','\u{1be6}',7),
        ('\u{1bf2}','\u{1bf3}',9),
        ('\u{1c37}','\u{1c37}',7),
        ('\u{1cd0}','\u{1cd2}',230),
        ('\u{1cd4}','\u{1cd4}',1),
        ('\u{1cd5}','\u{1cd9}',220),
        ('\u{1cda}','\u{1cdb}',230),
        ('\u{1cdc}','\u{1cdf}',220),
        ('\u{1ce0}','\u{1ce0}',230),
        ('\u{1ce2}','\u{1ce8}',1),
        ('\u{1ced}','\u{1ced}',220),
        ('\u{1cf4}','\u{1cf4}',230),
        ('\u{1cf8}','\u{1cf9}',230),
        ('\u{1dc0}','\u{1dc1}',230),
        ('\u{1dc2}','\u{1dc2}',220),
        ('\u{1dc3}','\u{1dc9}',230),
        ('\u{1dca}','\u{1dca}',220),
        ('\u{1dcb}','\u{1dcc}',230),
        ('\u{1dcd}','\u{1dcd}',234),
        ('\u{1dce}','\u{1dce}',214),
        ('\u{1dcf}','\u{1dcf}',220),
        ('\u{1dd0}','\u{1dd0}',202),
        ('\u{1dd1}','\u{1df5}',230),
        ('\u{1dfb}','\u{1dfb}',230),
        ('\u{1dfc}','\u{1dfc}',233),
        ('\u{1dfd}','\u{1dfd}',220),
        ('\u{1dfe}','\u{1dfe}',230),
        ('\u{1dff}','\u{1dff}',220),
        ('\u{20d0}','\u{20d1}',230),
        ('\u{20d2}','\u{20d3}',1),
        ('\u{20d4}','\u{20d7}',230),
        ('\u{20d8}','\u{20da}',1),
        ('\u{20db}','\u{20dc}',230),
        ('\u{20e1}','\u{20e1}',230),
        ('\u{20e5}','\u{20e6}',1),
        ('\u{20e7}','\u{20e7}',230),
        ('\u{20e8}','\u{20e8}',220),
        ('\u{20e9}','\u{20e9}',230),
        ('\u{20ea}','\u{20eb}',1),
        ('\u{20ec}','\u{20ef}',220),
        ('\u{20f0}','\u{20f0}',230),
        ('\u{2cef}','\u{2cf1}',230),
        ('\u{2d7f}','\u{2d7f}',9),
        ('\u{2de0}','\u{2dff}',230),
        ('\u{302a}','\u{302a}',218),
        ('\u{302b}','\u{302b}',228),
        ('\u{302c}','\u{302c}',232),
        ('\u{302d}','\u{302d}',222),
        ('\u{302e}','\u{302f}',224),
        ('\u{3099}','\u{309a}',8),
        ('\u{a66f}','\u{a66f}',230),
        ('\u{a674}','\u{a67d}',230),
        ('\u{a69e}','\u{a69f}',230),
        ('\u{a6f0}','\u{a6f1}',230),
        ('\u{a806}','\u{a806}',9),
        ('\u{a8c4}','\u{a8c4}',9),
        ('\u{a8e0}','\u{a8f1}',230),
        ('\u{a92b}','\u{a92d}',220),
        ('\u{a953}','\u{a953}',9),
        ('\u{a9b3}','\u{a9b3}',7),
        ('\u{a9c0}','\u{a9c0}',9),
        ('\u{aab0}','\u{aab0}',230),
        ('\u{aab2}','\u{aab3}',230),
        ('\u{aab4}','\u{aab4}',220),
        ('\u{aab7}','\u{aab8}',230),
        ('\u{aabe}','\u{aabf}',230),
        ('\u{aac1}','\u{aac1}',230),
        ('\u{aaf6}','\u{aaf6}',9),
        ('\u{abed}','\u{abed}',9),
        ('\u{fb1e}','\u{fb1e}',26),
        ('\u{fe20}','\u{fe26}',230),
        ('\u{fe27}','\u{fe2d}',220),
        ('\u{fe2e}','\u{fe2f}',230),
        ('\u{101fd}','\u{101fd}',220),
        ('\u{102e0}','\u{102e0}',220),
        ('\u{10376}','\u{1037a}',230),
        ('\u{10a0d}','\u{10a0d}',220),
        ('\u{10a0f}','\u{10a0f}',230),
        ('\u{10a38}','\u{10a38}',230),
        ('\u{10a39}','\u{10a39}',1),
        ('\u{10a3a}','\u{10a3a}',220),
        ('\u{10a3f}','\u{10a3f}',9),
        ('\u{10ae5}','\u{10ae5}',230),
        ('\u{10ae6}','\u{10ae6}',220),
        ('\u{11046}','\u{11046}',9),
        ('\u{1107f}','\u{1107f}',9),
        ('\u{110b9}','\u{110b9}',9),
        ('\u{110ba}','\u{110ba}',7),
        ('\u{11100}','\u{11102}',230),
        ('\u{11133}','\u{11134}',9),
        ('\u{11173}','\u{11173}',7),
        ('\u{111c0}','\u{111c0}',9),
        ('\u{111ca}','\u{111ca}',7),
        ('\u{11235}','\u{11235}',9),
        ('\u{11236}','\u{11236}',7),
        ('\u{112e9}','\u{112e9}',7),
        ('\u{112ea}','\u{112ea}',9),
        ('\u{1133c}','\u{1133c}',7),
        ('\u{1134d}','\u{1134d}',9),
        ('\u{11366}','\u{1136c}',230),
        ('\u{11370}','\u{11374}',230),
        ('\u{11442}','\u{11442}',9),
        ('\u{11446}','\u{11446}',7),
        ('\u{114c2}','\u{114c2}',9),
        ('\u{114c3}','\u{114c3}',7),
        ('\u{115bf}','\u{115bf}',9),
        ('\u{115c0}','\u{115c0}',7),
        ('\u{1163f}','\u{1163f}',9),
        ('\u{116b6}','\u{116b6}',9),
        ('\u{116b7}','\u{116b7}',7),
        ('\u{1172b}','\u{1172b}',9),
        ('\u{11c3f}','\u{11c3f}',9),
        ('\u{16af0}','\u{16af4}',1),
        ('\u{16b30}','\u{16b36}',230),
        ('\u{1bc9e}','\u{1bc9e}',1),
        ('\u{1d165}','\u{1d166}',216),
        ('\u{1d167}','\u{1d169}',1),
        ('\u{1d16d}','\u{1d16d}',226),
        ('\u{1d16e}','\u{1d172}',216),
        ('\u{1d17b}','\u{1d182}',220),
        ('\u{1d185}','\u{1d189}',230),
        ('\u{1d18a}','\u{1d18b}',220),
        ('\u{1d1aa}','\u{1d1ad}',230),
        ('\u{1d242}','\u{1d244}',230),
        ('\u{1e000}','\u{1e006}',230),
        ('\u{1e008}','\u{1e018}',230),
        ('\u{1e01b}','\u{1e021}',230),
        ('\u{1e023}','\u{1e024}',230),
        ('\u{1e026}','\u{1e02a}',230),
        ('\u{1e8d0}','\u{1e8d6}',220),
        ('\u{1e944}','\u{1e949}',230),
        ('\u{1e94a}','\u{1e94a}',7),

    ];

    pub fn canonical_combining_class(c: char) -> u8 {
        bsearch_range_value_table(c, combining_class_table)
    }

    fn bsearch_range_table(c: char, r: &'static [(char, char)]) -> bool {
        use std::cmp::Ordering::{Equal, Less, Greater};
        r.binary_search_by(|&(lo, hi)| {
             if lo <= c && c <= hi {
                 Equal
             } else if hi < c {
                 Less
             } else {
                 Greater
             }
         })
         .is_ok()
    }

    /// Return whether the given character is a combining mark (`General_Category=Mark`)
    pub fn is_combining_mark(c: char) -> bool {
        bsearch_range_table(c, general_category_mark)
    }

    const general_category_mark: &'static [(char, char)] = &[
        ('\u{300}','\u{36f}'),
        ('\u{483}','\u{489}'),
        ('\u{591}','\u{5bd}'),
        ('\u{5bf}','\u{5bf}'),
        ('\u{5c1}','\u{5c2}'),
        ('\u{5c4}','\u{5c5}'),
        ('\u{5c7}','\u{5c7}'),
        ('\u{610}','\u{61a}'),
        ('\u{64b}','\u{65f}'),
        ('\u{670}','\u{670}'),
        ('\u{6d6}','\u{6dc}'),
        ('\u{6df}','\u{6e4}'),
        ('\u{6e7}','\u{6e8}'),
        ('\u{6ea}','\u{6ed}'),
        ('\u{711}','\u{711}'),
        ('\u{730}','\u{74a}'),
        ('\u{7a6}','\u{7b0}'),
        ('\u{7eb}','\u{7f3}'),
        ('\u{816}','\u{819}'),
        ('\u{81b}','\u{823}'),
        ('\u{825}','\u{827}'),
        ('\u{829}','\u{82d}'),
        ('\u{859}','\u{85b}'),
        ('\u{8d4}','\u{8e1}'),
        ('\u{8e3}','\u{903}'),
        ('\u{93a}','\u{93c}'),
        ('\u{93e}','\u{94f}'),
        ('\u{951}','\u{957}'),
        ('\u{962}','\u{963}'),
        ('\u{981}','\u{983}'),
        ('\u{9bc}','\u{9bc}'),
        ('\u{9be}','\u{9c4}'),
        ('\u{9c7}','\u{9c8}'),
        ('\u{9cb}','\u{9cd}'),
        ('\u{9d7}','\u{9d7}'),
        ('\u{9e2}','\u{9e3}'),
        ('\u{a01}','\u{a03}'),
        ('\u{a3c}','\u{a3c}'),
        ('\u{a3e}','\u{a42}'),
        ('\u{a47}','\u{a48}'),
        ('\u{a4b}','\u{a4d}'),
        ('\u{a51}','\u{a51}'),
        ('\u{a70}','\u{a71}'),
        ('\u{a75}','\u{a75}'),
        ('\u{a81}','\u{a83}'),
        ('\u{abc}','\u{abc}'),
        ('\u{abe}','\u{ac5}'),
        ('\u{ac7}','\u{ac9}'),
        ('\u{acb}','\u{acd}'),
        ('\u{ae2}','\u{ae3}'),
        ('\u{b01}','\u{b03}'),
        ('\u{b3c}','\u{b3c}'),
        ('\u{b3e}','\u{b44}'),
        ('\u{b47}','\u{b48}'),
        ('\u{b4b}','\u{b4d}'),
        ('\u{b56}','\u{b57}'),
        ('\u{b62}','\u{b63}'),
        ('\u{b82}','\u{b82}'),
        ('\u{bbe}','\u{bc2}'),
        ('\u{bc6}','\u{bc8}'),
        ('\u{bca}','\u{bcd}'),
        ('\u{bd7}','\u{bd7}'),
        ('\u{c00}','\u{c03}'),
        ('\u{c3e}','\u{c44}'),
        ('\u{c46}','\u{c48}'),
        ('\u{c4a}','\u{c4d}'),
        ('\u{c55}','\u{c56}'),
        ('\u{c62}','\u{c63}'),
        ('\u{c81}','\u{c83}'),
        ('\u{cbc}','\u{cbc}'),
        ('\u{cbe}','\u{cc4}'),
        ('\u{cc6}','\u{cc8}'),
        ('\u{cca}','\u{ccd}'),
        ('\u{cd5}','\u{cd6}'),
        ('\u{ce2}','\u{ce3}'),
        ('\u{d01}','\u{d03}'),
        ('\u{d3e}','\u{d44}'),
        ('\u{d46}','\u{d48}'),
        ('\u{d4a}','\u{d4d}'),
        ('\u{d57}','\u{d57}'),
        ('\u{d62}','\u{d63}'),
        ('\u{d82}','\u{d83}'),
        ('\u{dca}','\u{dca}'),
        ('\u{dcf}','\u{dd4}'),
        ('\u{dd6}','\u{dd6}'),
        ('\u{dd8}','\u{ddf}'),
        ('\u{df2}','\u{df3}'),
        ('\u{e31}','\u{e31}'),
        ('\u{e34}','\u{e3a}'),
        ('\u{e47}','\u{e4e}'),
        ('\u{eb1}','\u{eb1}'),
        ('\u{eb4}','\u{eb9}'),
        ('\u{ebb}','\u{ebc}'),
        ('\u{ec8}','\u{ecd}'),
        ('\u{f18}','\u{f19}'),
        ('\u{f35}','\u{f35}'),
        ('\u{f37}','\u{f37}'),
        ('\u{f39}','\u{f39}'),
        ('\u{f3e}','\u{f3f}'),
        ('\u{f71}','\u{f84}'),
        ('\u{f86}','\u{f87}'),
        ('\u{f8d}','\u{f97}'),
        ('\u{f99}','\u{fbc}'),
        ('\u{fc6}','\u{fc6}'),
        ('\u{102b}','\u{103e}'),
        ('\u{1056}','\u{1059}'),
        ('\u{105e}','\u{1060}'),
        ('\u{1062}','\u{1064}'),
        ('\u{1067}','\u{106d}'),
        ('\u{1071}','\u{1074}'),
        ('\u{1082}','\u{108d}'),
        ('\u{108f}','\u{108f}'),
        ('\u{109a}','\u{109d}'),
        ('\u{135d}','\u{135f}'),
        ('\u{1712}','\u{1714}'),
        ('\u{1732}','\u{1734}'),
        ('\u{1752}','\u{1753}'),
        ('\u{1772}','\u{1773}'),
        ('\u{17b4}','\u{17d3}'),
        ('\u{17dd}','\u{17dd}'),
        ('\u{180b}','\u{180d}'),
        ('\u{1885}','\u{1886}'),
        ('\u{18a9}','\u{18a9}'),
        ('\u{1920}','\u{192b}'),
        ('\u{1930}','\u{193b}'),
        ('\u{1a17}','\u{1a1b}'),
        ('\u{1a55}','\u{1a5e}'),
        ('\u{1a60}','\u{1a7c}'),
        ('\u{1a7f}','\u{1a7f}'),
        ('\u{1ab0}','\u{1abe}'),
        ('\u{1b00}','\u{1b04}'),
        ('\u{1b34}','\u{1b44}'),
        ('\u{1b6b}','\u{1b73}'),
        ('\u{1b80}','\u{1b82}'),
        ('\u{1ba1}','\u{1bad}'),
        ('\u{1be6}','\u{1bf3}'),
        ('\u{1c24}','\u{1c37}'),
        ('\u{1cd0}','\u{1cd2}'),
        ('\u{1cd4}','\u{1ce8}'),
        ('\u{1ced}','\u{1ced}'),
        ('\u{1cf2}','\u{1cf4}'),
        ('\u{1cf8}','\u{1cf9}'),
        ('\u{1dc0}','\u{1df5}'),
        ('\u{1dfb}','\u{1dff}'),
        ('\u{20d0}','\u{20f0}'),
        ('\u{2cef}','\u{2cf1}'),
        ('\u{2d7f}','\u{2d7f}'),
        ('\u{2de0}','\u{2dff}'),
        ('\u{302a}','\u{302f}'),
        ('\u{3099}','\u{309a}'),
        ('\u{a66f}','\u{a672}'),
        ('\u{a674}','\u{a67d}'),
        ('\u{a69e}','\u{a69f}'),
        ('\u{a6f0}','\u{a6f1}'),
        ('\u{a802}','\u{a802}'),
        ('\u{a806}','\u{a806}'),
        ('\u{a80b}','\u{a80b}'),
        ('\u{a823}','\u{a827}'),
        ('\u{a880}','\u{a881}'),
        ('\u{a8b4}','\u{a8c5}'),
        ('\u{a8e0}','\u{a8f1}'),
        ('\u{a926}','\u{a92d}'),
        ('\u{a947}','\u{a953}'),
        ('\u{a980}','\u{a983}'),
        ('\u{a9b3}','\u{a9c0}'),
        ('\u{a9e5}','\u{a9e5}'),
        ('\u{aa29}','\u{aa36}'),
        ('\u{aa43}','\u{aa43}'),
        ('\u{aa4c}','\u{aa4d}'),
        ('\u{aa7b}','\u{aa7d}'),
        ('\u{aab0}','\u{aab0}'),
        ('\u{aab2}','\u{aab4}'),
        ('\u{aab7}','\u{aab8}'),
        ('\u{aabe}','\u{aabf}'),
        ('\u{aac1}','\u{aac1}'),
        ('\u{aaeb}','\u{aaef}'),
        ('\u{aaf5}','\u{aaf6}'),
        ('\u{abe3}','\u{abea}'),
        ('\u{abec}','\u{abed}'),
        ('\u{fb1e}','\u{fb1e}'),
        ('\u{fe00}','\u{fe0f}'),
        ('\u{fe20}','\u{fe2f}'),
        ('\u{101fd}','\u{101fd}'),
        ('\u{102e0}','\u{102e0}'),
        ('\u{10376}','\u{1037a}'),
        ('\u{10a01}','\u{10a03}'),
        ('\u{10a05}','\u{10a06}'),
        ('\u{10a0c}','\u{10a0f}'),
        ('\u{10a38}','\u{10a3a}'),
        ('\u{10a3f}','\u{10a3f}'),
        ('\u{10ae5}','\u{10ae6}'),
        ('\u{11000}','\u{11002}'),
        ('\u{11038}','\u{11046}'),
        ('\u{1107f}','\u{11082}'),
        ('\u{110b0}','\u{110ba}'),
        ('\u{11100}','\u{11102}'),
        ('\u{11127}','\u{11134}'),
        ('\u{11173}','\u{11173}'),
        ('\u{11180}','\u{11182}'),
        ('\u{111b3}','\u{111c0}'),
        ('\u{111ca}','\u{111cc}'),
        ('\u{1122c}','\u{11237}'),
        ('\u{1123e}','\u{1123e}'),
        ('\u{112df}','\u{112ea}'),
        ('\u{11300}','\u{11303}'),
        ('\u{1133c}','\u{1133c}'),
        ('\u{1133e}','\u{11344}'),
        ('\u{11347}','\u{11348}'),
        ('\u{1134b}','\u{1134d}'),
        ('\u{11357}','\u{11357}'),
        ('\u{11362}','\u{11363}'),
        ('\u{11366}','\u{1136c}'),
        ('\u{11370}','\u{11374}'),
        ('\u{11435}','\u{11446}'),
        ('\u{114b0}','\u{114c3}'),
        ('\u{115af}','\u{115b5}'),
        ('\u{115b8}','\u{115c0}'),
        ('\u{115dc}','\u{115dd}'),
        ('\u{11630}','\u{11640}'),
        ('\u{116ab}','\u{116b7}'),
        ('\u{1171d}','\u{1172b}'),
        ('\u{11c2f}','\u{11c36}'),
        ('\u{11c38}','\u{11c3f}'),
        ('\u{11c92}','\u{11ca7}'),
        ('\u{11ca9}','\u{11cb6}'),
        ('\u{16af0}','\u{16af4}'),
        ('\u{16b30}','\u{16b36}'),
        ('\u{16f51}','\u{16f7e}'),
        ('\u{16f8f}','\u{16f92}'),
        ('\u{1bc9d}','\u{1bc9e}'),
        ('\u{1d165}','\u{1d169}'),
        ('\u{1d16d}','\u{1d172}'),
        ('\u{1d17b}','\u{1d182}'),
        ('\u{1d185}','\u{1d18b}'),
        ('\u{1d1aa}','\u{1d1ad}'),
        ('\u{1d242}','\u{1d244}'),
        ('\u{1da00}','\u{1da36}'),
        ('\u{1da3b}','\u{1da6c}'),
        ('\u{1da75}','\u{1da75}'),
        ('\u{1da84}','\u{1da84}'),
        ('\u{1da9b}','\u{1da9f}'),
        ('\u{1daa1}','\u{1daaf}'),
        ('\u{1e000}','\u{1e006}'),
        ('\u{1e008}','\u{1e018}'),
        ('\u{1e01b}','\u{1e021}'),
        ('\u{1e023}','\u{1e024}'),
        ('\u{1e026}','\u{1e02a}'),
        ('\u{1e8d0}','\u{1e8d6}'),
        ('\u{1e944}','\u{1e94a}'),
        ('\u{e0100}','\u{e01ef}'),

    ];


}

